%% plot summary data, across sessions and across freqs
load('Figure3C_SourceData.mat')
path('helpers',path) 

%%
cc = get(groot,'defaultAxesColorOrder');
warning off

figure
block = 1;

C = {C{:,block}};
ER = {ER{:,block}};

F = size(freqs,1);
S = length(C);
slopes = zeros(S,F);
r2 = zeros(S,F);
p = zeros(S,F);
for s=1:S,
    for fp=1:F,
        fpass = freqs(fp,:);
        
        % linear regression
        X = addones(ER{s});
        Y = mean(C{s}(:,fp),2);
        [B,~,~,~,stats] = regress(Y,X);
        yhat = X*B;
        
        % store
        slopes(s,fp) = B(2);
        r2(s,fp) = stats(1);
        p(s,fp) = stats(3);
        if isinf(r2(s,fp)), r2(s,fp) = 0; end
    end
end

% plot
subplot(2,1,1), hold on
boundedline(freqs(:,1),mean(slopes),std(slopes)/sqrt(S),'cmap',cc(block,:)), hold on
ylabel('slope')
title('Initial Coherence Vs Pk2Tr Across Frequencies')
xlim([0,60])

subplot(2,1,2), hold on
boundedline(freqs(:,1),nanmean(r2),nanstd(r2)/sqrt(S),'cmap',cc(block,:)), hold on
ylabel('r^2')
xlabel('freq (Hz)')
xlim([0,60])

% proportion of p-vals less than .05
pvec = p(:);
pvec = pvec(~isnan(pvec));
pprop = mean(pvec<.05);
fprintf('\nProportion of P-vals < .05: %.2f\n',pprop)

% do ttest on slope (avg across freqs)
[h,pval] = ttest(mean(slopes,2))
mean(mean(slopes,2))
slopes_avg{block} = mean(slopes,2);




