%% parameters for figure
clear,clc,close all

% colors/markers
cc = [.35 .35 .35]; % gray

% font
title_size = 14;
label_size = 10;
other_size = 10;
type = 'Helvetica';

% box
box off
hold on

%% load data
load('Figure4D_SourceData.mat')

%% plots
avg = [mean(pktr1_none{1}),mean(pktr2_none{1}),mean(pktr1S1),mean(pktr2S1),mean(pktr1M1),mean(pktr2M1)];
sem = [std(pktr1_none{1}),std(pktr2_none{1}),std(pktr1S1),std(pktr2S1),std(pktr1M1),std(pktr2M1)] ...
    ./ sqrt(([length(pktr1_none{1}),length(pktr2_none{1}),length(pktr1S1),length(pktr2S1),length(pktr1M1),length(pktr2M1)]));
bar([1,2,3.5,4.5,6,7],avg,'FaceColor',cc,'LineWidth',1), hold on
errorbar([1,2,3.5,4.5,6,7],avg,[],sem,'k.','LineWidth',1.5,'CapSize',6)
box off

xlim([.5,7.5])
ylim([0,1.2])
set(gca,'XTick',[1,2,3.5,4.5,6,7],'XTickLabel',{'Pre','Post'},'YTick',0:.25:1)
ylabel('SERR')
set(gca,'FontName',type,'FontSize',label_size)

text(1.5,-.10,'No Stim','HorizontalAlignment','center')
text(4.0,-.10,'S1 --> M1','HorizontalAlignment','center')
text(6.5,-.10,'M1 --> S1','HorizontalAlignment','center')

if ttest(pktr1_none{1},pktr2_none{1})
    text(1.5,1,'*','FontSize',24)
end

if ttest(pktr1S1,pktr2S1)
    text(4,1,'*','FontSize',24)
end

if ttest(pktr1M1,pktr2M1)
    text(6.5,1,'*','FontSize',24)
end

%% STATS
[h,p]=ttest(pktr1_none{1},pktr2_none{1});
fprintf('ctrl: ttest p=%.02g, N=%i\n',p,length(pktr1_none{1}))
[h,p]=ttest(pktr1S1,pktr2S1);
fprintf('S1: ttest p=%.02g, N=%i\n',p,length(pktr1S1))
[h,p]=ttest(pktr1M1,pktr2M1);
fprintf('M1: ttest p=%.02g, N=%i\n',p,length(pktr1M1))

[h,p]=ttest2(pktr2_none{1}-pktr1_none{1},[pktr2M1-pktr1M1 pktr2S1-pktr1S1]);
fprintf('ctrl vs S1&M1: ttest p=%.02g\n',p)
