%% parameters for figure
clear,clc,close all
path('helpers',path)
figure

% colors
cc = get(groot,'defaultAxesColorOrder');

% font
title_size = 14;
label_size = 10;
other_size = 10;
type = 'Helvetica';

% box
box off

%% load data
load('Figure4G_SourceData')
freqs = mean(freqs,2);
Nfreqs = size(freqs,1);

%% plot of change in coh per freq

for ctrl=1:2,
    % get avg change per session
    dCch = cell(1,Nfreqs);
    for fp=1:Nfreqs,
        for s=1:length(C0_M1S1{ctrl,fp}),
%             if strcmp(NAMES{ctrl,fp}{s},'GT')
                dCch{fp} = [dCch{fp} ; mean(Cf_M1S1{ctrl,fp}{s}-C0_M1S1{ctrl,fp}{s})];
%             end
        end
    end

    % figure % bar plot

    avg = nanmean([dCch{:}],1);
    sem = nanstd([dCch{:}],[],1) / sqrt(size([dCch{:}],1));
    switch ctrl,
        case 1,
            h(ctrl)=errorbar(freqs(:,1)-.25,avg,sem,'.',...
                'LineWidth',1.5,'CapSize',0,'Color',cc(ctrl,:)); hold on
        case 2,
            h(ctrl)=errorbar(freqs(:,1)+.25,avg,sem,'.',...
                'LineWidth',1.5,'CapSize',0,'Color',cc(ctrl,:)); hold on
    end
end

xx = [4,8];
yy = [-.3,.2];
fill(...
    [xx(1) xx(1) xx(2) xx(2)],...
    [yy(1) yy(2) yy(2) yy(1)],...
    [.6 .6 .6],...
    'FaceAlpha',.3,'LineStyle','none')

xlabel('Frequency Band (Hz)','FontName',type,'FontSize',label_size)
ylabel('\Delta Coherence','FontName',type,'FontSize',label_size)
legend(h,'No Stim','Long','Location','SouthEast')
legend boxoff
set(gca,'YTick',-.3:.1:.2,'YLim',yy)
hline(0,'--','Color',[.8,.8,.8])

%% do ttests for each freq band with bonferroni

for fp=1:length(freqs),
    dC = cell(1,2);
    for ctrl=1:2,
        for s=1:length(C0_M1S1{ctrl,fp}),
            dC{ctrl} = [dC{ctrl} ; mean(Cf_M1S1{ctrl,fp}{s}-C0_M1S1{ctrl,fp}{s})];
        end
    end
    [h,p] = ttest2(dC{1},dC{2});
    fprintf('[%i-%iH] : bonf corrected p=%.02g\n',freqs(fp)-2,freqs(fp)+2,p*length(freqs))
    if p<(.05/length(freqs)), % Multiple Comparisons Correction (Bonferonni)
        text(freqs(fp),.15,'*','FontSize',24)
    end
end

% %% do ttests for each freq band with Benjamini-Hochberg
% 
% for fp=1:length(freqs),
%     dC = cell(1,2);
%     for ctrl=1:2,
%         for s=1:length(C0_M1S1{ctrl,fp}),
% %             if strcmp(NAMES{ctrl,fp}{s},'GT')
%                 dC{ctrl} = [dC{ctrl} ; mean(Cf_M1S1{ctrl,fp}{s}-C0_M1S1{ctrl,fp}{s})];
% %             end
%         end
%     end
%     [~,p(fp,1)] = ttest2(dC{1},dC{2});
% end
% 
% % Benjamini-Hochberg procedure for multiple comparisons correction
% [~,idx] = sort(p,'ascend');
% BHvec = (1:length(freqs))'*.05/length(freqs);
% N = find((p(idx)<=BHvec)==1,1,'last');
% 
% for i=1:N,
%     fp = idx(i);
%     text(freqs(fp),.15,'*','FontSize',24)
% end
% 
% %% ttests of control signal compared to 0 (uncorrected)
% for fp=1:length(freqs),
%     dC = cell(1,2);
%     for ctrl=2,
%         for s=1:length(C0_M1S1{ctrl,fp}),
% %             if strcmp(NAMES{ctrl,fp}{s},'GT')
%                 dC{ctrl} = [dC{ctrl} ; mean(Cf_M1S1{ctrl,fp}{s}-C0_M1S1{ctrl,fp}{s})];
% %             end
%         end
%     end
%     [~,p(fp,1)] = ttest(dC{2});
% end
% 
% % Benjamini-Hochberg procedure for multiple comparisons correction
% [~,idx] = sort(p,'ascend');
% BHvec = (1:length(freqs))'*.05/length(freqs);
% N = find((p(idx)<=BHvec)==1,1,'last');
% 
% for i=1:N,
%     fp = idx(i);
%     text(freqs(fp),.15,'*','FontSize',24)
% end
% 
% N
% [freqs(idx)-2,freqs(idx)+2,p(idx)]

