%% go through example sessions: scatter plot of coh vs. evoked resp @ theta band
clear, clc, close all

% fpass = [4,8];
% fidx = fpass(1):(fpass(2)-1);

%% plot summary data, across sessions and across freqs
cc = get(groot,'defaultAxesColorOrder');
warning off
figure

for block=1:2,
    load('Figure4_FigureSupplement1_SourceData.mat')

    C = {C{:,block}};
    ER = {ER{:,block}};

    F = size(freqs,1);
    S = length(C);
    slopes = zeros(S,F);
    r2 = zeros(S,F);
    p = zeros(S,F);
    for s=1:S,
        for fp=1:F,
            fpass = freqs(fp,:);
            fidx = fpass(1):(fpass(2)-1);

            % linear regression
            X = addones(ER{s});
            Y = mean(C{s}(:,fidx),2);
            [B,~,~,~,stats] = regress(Y,X);
            yhat = X*B;

            % store
            slopes(s,fp) = B(2);
            r2(s,fp) = stats(1);
            p(s,fp) = stats(3);
            if isinf(r2(s,fp)), r2(s,fp) = 0; end
        end
    end

    % plot
    subplot(2,1,1), hold on
    h(block)=boundedline(freqs(:,1),mean(slopes),std(slopes)/sqrt(S),'cmap',cc(block,:)); hold on
    ylabel('slope')
    title('Final Coherence Vs Pk2Tr Across Frequencies')
    xlim([0,60])

    subplot(2,1,2), hold on
    boundedline(freqs(:,1),nanmean(r2),nanstd(r2)/sqrt(S),'cmap',cc(block,:)); hold on
    ylabel('r^2')
    xlabel('freq (Hz)')
    xlim([0,60])
    
    % proportion of p-vals less than .05
    pvec = p(:);
    pvec = pvec(~isnan(pvec));
    pprop = mean(pvec<.05);
    fprintf('\nProportion of P-vals < .05: %.2f\n',pprop)
    
    % do ttest on slope (avg across freqs)
    [h,pval] = ttest(mean(slopes,2))
    mean(mean(slopes,2))
    slopes_avg{block} = mean(slopes,2);
end

%% plot delta summary data, across sessions and across freqs
load('Figure4_FigureSupplement1_SourceData.mat')

F = size(freqs,1);
S = size(C,1);
slopes = zeros(S,F);
r2 = zeros(S,F);
for s=1:S,
    for fp=1:F,
        fpass = freqs(fp,:);
        fidx = fpass(1):(fpass(2)-1);
        
        % linear regression
        X = addones(ER{s,2}-ER{s,1});
        Y = mean(C{s,2}(:,fidx)-C{s,1}(:,fidx),2);
        [B,~,~,~,stats] = regress(Y,X);
        yhat = X*B;

        % store
        slopes(s,fp) = B(2);
        r2(s,fp) = stats(1);
        p(s,fp) = stats(3);
        if isinf(r2(s,fp)), r2(s,fp) = 0; end
    end
end

% plot
subplot(2,1,1), hold on
h(3)=boundedline(freqs(:,1),mean(slopes),std(slopes)/sqrt(S),'cmap',cc(3,:));
ylabel('slope')
title('\Delta Coherence Vs \Delta Pk2Tr Across Frequencies')
xlim([0,60])

subplot(2,1,2), hold on
boundedline(freqs(:,1),nanmean(r2),nanstd(r2)/sqrt(S),'cmap',cc(3,:))
ylabel('r^2')
xlabel('freq (Hz)')
xlim([0,60])


% proportion of p-vals less than .05
pvec = p(:);
pvec = pvec(~isnan(pvec));
pprop = mean(pvec<.05);
fprintf('\nProportion of P-vals < .05: %.2f\n',pprop)

% do ttest on slope (avg across freqs)
[h,pval] = ttest(mean(slopes,2))
mean(mean(slopes,2))

