%% parameters
clear,clc,close all

% colors
blue = [0    0.4470    0.7410];
orange = [0.8500    0.3250    0.0980];
open = 'none';
colors = {orange,open};
edges = {'none','k'};

EcogMap

%% load data
load('Figure4E-F_SourceData.mat')

%% Change in Evoked Response Amplitude (STATS)

names = 'GT';
s_vec = [8,9];


coh_all = [];
for i=1:2,
    % set up fig
    figure, axis equal
    s = s_vec(i);
    secondary{i} = setdiff(secondary{i},stim_ch{i});
    secondary{i} = setdiff(secondary{i},bad_channels);
    
    % stats
    [h,p] = ttest(C0_M1S1{1}{s},Cf_M1S1{1}{s})
    N = length(C0_M1S1{1}{s}(:,1))

    % all for normalized visualization
    coh_all = cat(1,C0_M1S1{1}{s},Cf_M1S1{1}{s});
    
    for j=2:-1:1,
        % plot stim ch
        [r1,c1] = find(MapChM==stim_ch{i});
        rectangle('Position',[MapXM(r1,c1),MapYM(r1,c1),0.6,0.6],...
            'FaceColor',blue, 'Curvature',[1,1],'EdgeColor','none'); hold on
        % plot each secondary ch
        for iChan=1:length(secondary{i}),
            ch = secondary{i}(iChan);
            [r2,c2] = find(MapChM==ch); % ch pos on array
            % normalized pk2tr
            if j==1,
                rectangle('Position',[MapXM(r2,c2),MapYM(r2,c2),...
                    C0_M1S1{1}{s}(iChan)*0.6/max(coh_all),C0_M1S1{1}{s}(iChan)*0.6/max(coh_all)],...
                    'FaceColor',colors{j}, 'Curvature',[1,1],...
                    'EdgeColor',edges{j}); hold on
            else
                rectangle('Position',[MapXM(r2,c2),MapYM(r2,c2),...
                    Cf_M1S1{1}{s}(iChan)*0.6/max(coh_all),Cf_M1S1{1}{s}(iChan)*0.6/max(coh_all)],...
                    'FaceColor',colors{j}, 'Curvature',[1,1],...
                    'EdgeColor',edges{j}); hold on
            end
        end
    end
    % plot ecog grid outline
    xlim([-0.1 11]);
    axis off
    rectangle('Position',[0,0,11,8.5],'FaceColor','none','EdgeColor','k','LineWidth',1)
end


