%% parameters for figure
clear,clc,close all

% colors/markers
cc = [
 .75 0   .75 % purple    
0   .5  0   % green
    ]; % for each monkey
M = {'o','d'}; % markers for each monkey
sz = 16; % marker size
lw = {1,3}; % line width (sz 1 is for filled in markers, sz 2 is for empty markers)

% font
title_size = 14;
label_size = 18;
other_size = 14;
type = 'Helvetica';

% box
box off

%% load data
load('Figure4E-F_SourceData.mat')

%% plot of change in coh per session
hold on
for n=1:2,
    for s=1:length(C0_M1S1{n,1}),
        if isempty(C0_M1S1{n,1}{s}), continue; end
        [h,p] = ttest(C0_M1S1{n,1}{s},Cf_M1S1{n,1}{s});
        if h,
%             fprintf('Monkey%i, %i, %.3g\n',n,length(C0_M1S1{n,1}{s}),p)
%             fprintf('Monkey%i\n',n)
%             fprintf('%i\n',length(C0_M1S1{n,1}{s}))
            fprintf('%.3g\n',p)
            if s==2,
                ax(n)=plot(mean(C0_M1S1{n,1}{s}),mean(Cf_M1S1{n,1}{s}),...
                    M{n},'MarkerFaceColor',cc(n,:),...
                    'MarkerEdgeColor',[1,1,1],'MarkerSize',sz,...
                    'LineWidth',lw{1});
            else
                plot(mean(C0_M1S1{n,1}{s}),mean(Cf_M1S1{n,1}{s}),...
                    M{n},'MarkerFaceColor',cc(n,:),...
                    'MarkerEdgeColor',[1,1,1],'MarkerSize',sz,...
                    'LineWidth',lw{1})
            end
        else
            plot(mean(C0_M1S1{n,1}{s}),mean(Cf_M1S1{n,1}{s}),...
                M{n},'MarkerEdgeColor',cc(n,:),...
                'MarkerSize',sz,'LineWidth',lw{2});
        end
%         text(mean(C0_M1S1{n,1}{s}),mean(Cf_M1S1{n,1}{s}),num2str(S{n,1}{s}))
    end
end

xx = [0,1];
plot(xx,xx,'-k')
set(gca,'XTick',[0,.5,1],'YTick',[0,.5,1])
xlabel('Pre Stim','FontName',type,'FontSize',label_size)
ylabel('Post Stim','FontName',type,'FontSize',label_size)
set(gca,'FontSize',16)
% title('\theta Coherence','FontName',type,'FontSize',title_size)
% legend(ax,{'Monkey G','Monkey J'},'Location','SouthEast')
% legend boxoff

%% stats by monkey
GT = [];
J = [];
for n=1:2,
    for s=1:length(C0_M1S1{n,1}),
        if isempty(C0_M1S1{n,1}{s}), continue; end
        switch n,
            case 1,
                GT(end+1,:) = zeros(1,2);
                GT(end,1) = mean(C0_M1S1{n,1}{s});
                GT(end,2) = mean(Cf_M1S1{n,1}{s});
            case 2,
                J(end+1,:) = zeros(1,2);
                J(end,1) = mean(C0_M1S1{n,1}{s});
                J(end,2) = mean(Cf_M1S1{n,1}{s});
        end
    end
end

fprintf('\npaired ttest for GT:\n')
[h,p]=ttest(diff(GT,[],2))

fprintf('\npaired ttest for J:\n')
[h,p]=ttest(diff(J,[],2))
