%% go through example sessions: scatter plot of coh vs. evoked resp @ theta band
clear, clc, close all

fpass = [4,8];
fidx = (fpass(1)+1):fpass(2);

%% plot summary data, across sessions and across freqs
cc = get(groot,'defaultAxesColorOrder');
warning off
figure

for block=1:2,
    load('Figure4H_SourceData.mat')

    C = {C{:,block}};
    ER = {ER{:,block}};

    F = size(freqs,1);
    S = length(C);
    slopes = zeros(S,F);
    r2 = zeros(S,F);
    p = zeros(S,F);
    for s=1:S,
        for fp=1:F,
            fpass = freqs(fp,:);
            fidx = (fpass(1)+1):fpass(2);

            % linear regression
            X = addones(ER{s});
            Y = mean(C{s}(:,fidx),2);
            [B,~,~,~,stats] = regress(Y,X);
            yhat = X*B;

            % store
            slopes(s,fp) = B(2);
            r2(s,fp) = stats(1);
            p(s,fp) = stats(3);
            if isinf(r2(s,fp)), r2(s,fp) = 0; end
        end
    end

    % plot
    subplot(2,1,1), hold on
    h(block)=boundedline(freqs(:,1),mean(slopes),std(slopes)/sqrt(S),'cmap',cc(block,:)); hold on
    ylabel('slope')
    title('Final Coherence Vs Pk2Tr Across Frequencies')
    xlim([0,60])

    subplot(2,1,2), hold on
    boundedline(freqs(:,1),nanmean(r2),nanstd(r2)/sqrt(S),'cmap',cc(block,:)); hold on
    ylabel('r^2')
    xlabel('freq (Hz)')
    xlim([0,60])
    
    % proportion of p-vals less than .05
    pvec = p(:);
    pvec = pvec(~isnan(pvec));
    pprop = mean(pvec<.05);
    fprintf('\nProportion of P-vals < .05: %.2f\n',pprop)
    
    % do ttest on slope (avg across freqs)
    [h,pval] = ttest(mean(slopes,2))
    mean(mean(slopes,2))
    slopes_avg{block} = mean(slopes,2);
end

% do ttest btw slopes
[h,pval] = ttest(slopes_avg{2}-slopes_avg{1})
mean(slopes_avg{2}-slopes_avg{1})

%% plot delta summary data, across sessions and across freqs
load('Figure4H_SourceData.mat')

F = size(freqs,1);
S = size(C,1);
slopes = zeros(S,F);
r2 = zeros(S,F);
for s=1:S,
    for fp=1:F,
        fpass = freqs(fp,:);
        fidx = (fpass(1)+1):fpass(2);
        
        % linear regression
        X = addones(ER{s,2}-ER{s,1});
        Y = mean(C{s,2}(:,fidx)-C{s,1}(:,fidx),2);
        [B,~,~,~,stats] = regress(Y,X);
        yhat = X*B;

        % store
        slopes(s,fp) = B(2);
        r2(s,fp) = stats(1);
        p(s,fp) = stats(3);
        if isinf(r2(s,fp)), r2(s,fp) = 0; end
    end
end

% plot
subplot(2,1,1), hold on
h(3)=boundedline(freqs(:,1),mean(slopes),std(slopes)/sqrt(S),'cmap',cc(3,:));
ylabel('slope')
title('\Delta Coherence Vs \Delta Pk2Tr Across Frequencies')
xlim([0,60])

subplot(2,1,2), hold on
boundedline(freqs(:,1),nanmean(r2),nanstd(r2)/sqrt(S),'cmap',cc(3,:))
ylabel('r^2')
xlabel('freq (Hz)')
xlim([0,60])


% proportion of p-vals less than .05
pvec = p(:);
pvec = pvec(~isnan(pvec));
pprop = mean(pvec<.05);
fprintf('\nProportion of P-vals < .05: %.2f\n',pprop)

% do ttest on slope (avg across freqs)
[h,pval] = ttest(mean(slopes,2))
mean(mean(slopes,2))

%% stats between no stim controls and stim sessions
figure('Position',[440 260 850 535])
for fp=1:15,
    pre_stim(1,fp) = median(slopes_all{1,1}(:,fp));
    post_stim(1,fp) = median(slopes_all{1,2}(:,fp));
    subplot(3,1,1), hold on, % significant change in stim block 1->6
    errorbar(fp-.25,median(slopes_all{1,1}(:,fp)),...
        median(slopes_all{1,1}(:,fp))-prctile(slopes_all{1,1}(:,fp),25),...
        prctile(slopes_all{1,1}(:,fp),75)-median(slopes_all{1,1}(:,fp)),'b')
    errorbar(fp+.25,median(slopes_all{1,2}(:,fp)),...
        median(slopes_all{1,2}(:,fp))-prctile(slopes_all{1,2}(:,fp),25),...
        prctile(slopes_all{1,2}(:,fp),75)-median(slopes_all{1,2}(:,fp)),'b')
    plot(fp+[-.25,.25],[median(slopes_all{1,1}(:,fp)),median(slopes_all{1,2}(:,fp))],'b')
    [p,h]=signrank(slopes_all{1,1}(:,fp),slopes_all{1,2}(:,fp));
    if h,
        plot(fp,1,'k*')
    end
    
    pre_nostim(1,fp) = median(slopes_all{2,1}(:,fp));
    post_nostim(1,fp) = median(slopes_all{2,2}(:,fp));
    subplot(3,1,2), hold on, % significant change in no stim block 1->6
    errorbar(fp-.25,median(slopes_all{2,1}(:,fp)),...
        median(slopes_all{2,1}(:,fp))-prctile(slopes_all{2,1}(:,fp),25),...
        prctile(slopes_all{2,1}(:,fp),75)-median(slopes_all{2,1}(:,fp)),'r')
    errorbar(fp+.25,median(slopes_all{2,2}(:,fp)),...
        median(slopes_all{2,2}(:,fp))-prctile(slopes_all{2,2}(:,fp),25),...
        prctile(slopes_all{2,2}(:,fp),75)-median(slopes_all{2,2}(:,fp)),'r')
    plot(fp+[-.25,.25],[median(slopes_all{2,1}(:,fp)),median(slopes_all{2,2}(:,fp))],'r')
    [p,h]=signrank(slopes_all{2,1}(:,fp),slopes_all{2,2}(:,fp));
    if h,
        plot(fp,1,'k*')
    end
    
    delta_stim(1,fp) = median(slopes_all{1,2}(:,fp)) - median(slopes_all{1,1}(:,fp));
    delta_nostim(1,fp) = median(slopes_all{2,2}(:,fp)) - median(slopes_all{2,1}(:,fp));
    subplot(3,1,3), hold on, % significant larger change btw 'stim' and 'no stim' block 1->6
    leg(1)=plot(mean(freqs(fp,:))-.25,delta_stim(fp),'ob');
    leg(2)=plot(mean(freqs(fp,:))+.25,delta_nostim(fp),'or');
    plot(mean(freqs(fp,:))+[-.25,.25],[delta_stim(fp),delta_nostim(fp)],'-k')

end

subplot(311)
[h,p]=ttest(pre_stim,post_stim);
title(sprintf('signrank across freqs: p=%.03f',p))
set(gca,'XTick',[])
ylabel('stim slope')

subplot(312)
[h,p]=ttest(pre_nostim,post_nostim);
title(sprintf('signrank across freqs: p=%.03f',p))
set(gca,'XTick',[])
ylabel('no stim slope')

subplot(313)
[h,p]=ttest(delta_stim,delta_nostim);
title(sprintf('signrank across freqs: p=%.03f',p))
set(gca,'XTick',(1:15)-.5,...
    'XTickLabel',{'0-4','4-8','8-12','12-16','16-20',...
    '20-24','24-28','28-32','32-36','36-40','40-44',...
    '44-48','48-52','52-56','56-60'})
xlabel('freqs (hz)')
ylabel('\Delta Slope')
legend(leg,'stim','no stim')

fprintf('Is the change in slope different btw ''no stim'' and ''stim'' conditions?\n')
fprintf('ttest: p=%.02g',p)
