function hline(y,varargin)
%% hline(x)
% Plots horizontal line on current axes at X=x. (x can be a vector)
% Default is a black dashed line, but user can specify formatting

y = y(:)';
Y = [repmat(y,2,1);nan(2,length(y))];
Y = Y(:);

xx = get(gca,'XLim')';
X = [repmat(xx,1,length(y));nan(2,length(y))];
X = X(:);

hold on
if nargin < 2,
    plot(X,Y,'--k')
else
    plot(X,Y,varargin{:})
end