%% plot summary data, across sessions and across freqs
clear, clc
cc = get(groot,'defaultAxesColorOrder');
warning off
f = load(sprintf('SupplementalTable2_SourceData.mat'));
freqs = f.freqs;
blocks = f.blocks;

block = 1;
stat_names = {'broadband_slope','broadband_energy','broadband_amplitude','hg_energy'};
for stat_idx=1:length(stat_names),
    stat = stat_names{stat_idx};

    C = {f.C{:,block}};
    ER_stat = {f.(stat){:,block}};

    F = size(freqs,1);
    S = length(C);
    slopes = zeros(S,F);
    r2 = zeros(S,F);
    p = zeros(S,F);
    for s=1:S,
        for fp=1:F,
            fpass = freqs(fp,:);

            % linear regression
            X = addones(ER_stat{s});
            Y = mean(C{s}(:,fp),2);
            [B,~,~,~,stats] = regress(Y,X);

            % store
            slopes(s,fp) = B(2);
            r2(s,fp) = stats(1);
            p(s,fp) = stats(3);
        end
    end

    fprintf('%s:\n',stat)
    % proportion of p-vals less than .05
    pvec = p(:);
    pvec = pvec(~isnan(pvec));
    pprop = mean(pvec<.05);
    fprintf('Proportion of P-vals < .05: %.2f\n',pprop)
    
    % do ttest on slope (avg across freqs)
    [h,pval] = ttest(mean(slopes,2));
    fprintf('ttest of slope: p=%.03f\n',pval)

    
end
