%% parameters for figure
clear,clc,close all

% colors/markers
cc = [
.75 0   .75 % purple    
0   .5  0   % green    
    ]; % for each monkey
M = {'o','d'}; % markers for each monkey
sz = 12; % marker size
lw = {1,3}; % line width (sz 1 is for filled in markers, sz 2 is for empty markers)

% font
title_size = 14;
label_size = 14;
other_size = 10;
type = 'Helvetica';

% box
box off

%% load data
load('Figure7C_SourceData.mat')

%% plot of change in coh per session
hold on
for n=1:2,
    for s=1:length(C0_M1S1{n,1}),
        if length(C0_M1S1{n,1}{s})<2, continue; end
        if ttest(C0_M1S1{n,1}{s},Cf_M1S1{n,1}{s}),
            if s==4,
                ax(n)=plot(mean(C0_M1S1{n,1}{s}),mean(Cf_M1S1{n,1}{s}),...
                    M{n},'MarkerFaceColor',cc(n,:),...
                    'MarkerEdgeColor','w','MarkerSize',sz,...
                    'LineWidth',lw{1});
            else
                plot(mean(C0_M1S1{n,1}{s}),mean(Cf_M1S1{n,1}{s}),...
                    M{n},'MarkerFaceColor',cc(n,:),...
                    'MarkerEdgeColor','w','MarkerSize',sz,...
                    'LineWidth',lw{1})
            end
        else
            plot(mean(C0_M1S1{n,1}{s}),mean(Cf_M1S1{n,1}{s}),...
                M{n},'MarkerEdgeColor',cc(n,:),...
                'MarkerSize',sz,'LineWidth',lw{2});
        end
%         text(mean(C0_M1S1{n,1}{s}),mean(Cf_M1S1{n,1}{s}),[S{n,1}{s}.area{1},' ',S{n,1}{s}.area{2}])
    end
end

xx = [0,1];
plot(xx,xx,'-k')
set(gca,'XTick',[0,.5,1],'YTick',[0,.5,1])
xlabel('Pre','FontName',type,'FontSize',label_size)
ylabel('Post','FontName',type,'FontSize',label_size)
title('\theta Coherence','FontName',type,'FontSize',title_size)
legend(ax,{'Monkey G','Monkey J'},'Location','SouthEast')
legend boxoff


