%% parameters for figure
clear,clc,close all

% colors/markers
cc = [.55 .55 .55]; % gray

% font
title_size = 14;
label_size = 10;
other_size = 10;
type = 'Helvetica';

%% example session

% load data
load('Figure6AB_SourceData.mat')

% remove bad channels and lower triangle of pairwise matrix
Cf = Cf(~isnan(Cf(:,33)),~isnan(Cf(33,:)));
Cf = triu(Cf,1);
Cf = Cf(Cf~=0);

C2 = C2(~isnan(C2(:,33)),~isnan(C2(33,:)));
C2 = triu(C2,1);
C2 = C2(C2~=0);

C0_1 = C0_1(~isnan(C0_1(:,33)),~isnan(C0_1(33,:)));
C0_1 = triu(C0_1,1);
C0_1 = C0_1(C0_1~=0);

C0_2 = C0_2(~isnan(C0_2(:,33)),~isnan(C0_2(33,:)));
C0_2 = triu(C0_2,1);
C0_2 = C0_2(C0_2~=0);

% convert to vectors
dC   = Cf(:)-C0_2(:);
Cc   = C2(:)-C0_1(:);

% go through each session and frequency and do regression
% (Cf - C0) = a + b * (Cc - C0),
%   do regression by area and by channel
%   keep track of a, b, and r2

%% plot

[B,~,~,~,stats] = regress(dC,addones(Cc));
beta    = B;
r2      = stats(1);
p       = stats(3);

figure
plot(Cc,dC,'o','Color',cc), hold on
xx = get(gca,'XLim');
yy = beta(1) + beta(2)*xx;
plot(xx,yy,'k')

xlabel('Stimulus Evoked Coherence','FontName',type,'FontSize',label_size)
ylabel('\Delta \theta Coherence','FontName',type,'FontSize',label_size)

% long
title('Example Long Latency Session')
text(.2,-.15,sprintf('y = %.2f + %.2f*x',beta(1),beta(2)),'FontName',type,'FontSize',label_size)
text(.2,-.10,sprintf('r^2 = %.2f',r2),'FontName',type,'FontSize',label_size)
text(.2,-.05,sprintf('p = %.03g',p),'FontName',type,'FontSize',label_size)








