function ConnectivityVisualization(C,delta,L)
%% ConnectivityVisualization(C)
%   function to visualize connectivity across the Ecog grid
%   generates 96 heatmaps - 1 @ each electrode location
%   each heatmap represents the connectivity @ that site to each of the
%   other 96 electrodes
% 
%       C - 96x96 connectivity matrix

% normalize ecog grid to figure dimensions
EcogMap;
w = .06;
h = .06;
Xvec = MapXv / max(MapXv) * (1 - w) - .001;
Yvec = MapYv / max(MapYv) * (1 - h);

% want to ignore bad channels
chans = 1:96;
ch = 1;
while ch<=96,
    bad = chans(isnan(C(:,ch)));
    if length(bad) < 96, break; end
    ch = ch + 1;
end
good = setdiff(chans,bad);
good = unique([ch,good]);

% get a good color scale
Cmin = min(C(:));
Cmax = max(C(:));

% if visualizing delta connectivity matrix, use a divergent colormap
if delta,
    map = makeColorMap([0 0 1],[1 1 1],[1 0 0],40); % blue-to-red
%     map = makeColorMap([116,7,166]/255,[0.865, 0.865, 0.865],[240,142,22]/255,40); % purple-to-orange
%     map = makeColorMap([129,42,166]/255,[1,1,1],[82,230,32]/255,40); % purple-to-green
%     map = makeColorMap([53,255,248]/255,[1,1,1],[255,248,53]/255,40); % cyan-to-yellow
    Cmax = max([abs(Cmin),abs(Cmax)]);
    Cmax = ceil(Cmax*10)/10;
    Cmin = -1*Cmax;
    % overwrite auto CLIM
    Cmin = -.1;
    Cmax = .1;
else
    Cmin = 0;
    Cmax = 1;
    map = colormap;
end

% plot each heatmap
for i=1:length(good),
    ch = good(i);
    [r,c] = find(MapChM == ch);
    x = Xvec(r);
    y = Yvec(c);
    ax = axes('Position',[x,y,w,h]);
    
    [xx,yy,Cmap] = vec2heatmap(C(:,ch),1);
    im = imagesc(xx,yy,Cmap,[Cmin,Cmax]);
    colormap(map)
    set(im,'AlphaData',~isnan(Cmap))
    
    set(ax,'XTickLabel',{},'YTickLabel',{})
    axis xy

    % add title to stim channels
    if ch==L{1},
        title('Laser 1')
    elseif ch==L{2},
        title('Laser 2')
    end
end

set(gcf,'Numbertitle','off','Name',sprintf('CLIM = [%.2g , %.2g]',Cmin,Cmax))

% % plot colormap in a separate figure
% figure
% colormap(map)
% caxis([Cmin,Cmax])
% colorbar

