%% go through each session & plot coherence connectivity
clear, clc
path('helpers',path);

%% load data
load('Figure6AB_SourceData.mat')
dC   = Cf-C0_2;
Cc   = C2-C0_1;

%% plot

% mean subtraction
dC   = dC - nanmean(dC(:));
Cc   = Cc - nanmean(Cc(:));

figure,
ConnectivityVisualization(dC,1,L); % delta
set(gcf,'Name',sprintf('Change in Coherence: %s',get(gcf,'Name')))

figure,
ConnectivityVisualization(Cc,1,L); % delta
set(gcf,'Name',sprintf('Conditioning Coherence: %s',get(gcf,'Name')))
