%% parameters for figure
clear,clc,close all

% colors/markers
cc = [.35 .35 .35]; % gray

% font
title_size = 14;
label_size = 10;
other_size = 10;
type = 'Helvetica';

%% PREDICT COHERENCE CHANGES FROM INPUT COHERENCE
load Figure6C_SourceData.mat

subplot(2,1,1), 
errorbar(1:5,mean(slope.long),std(slope.long)/sqrt(size(slope.long,1)))
xlim([.5,5.5])
set(gca,'XTick',1:5,'XTickLabel','',...
    'YLim',[0,.75],'YTick',0:.25:.75)
ylabel('slope')
title('Hebbian Analysis: Long Latency Stim Sessions')
box off

subplot(2,1,2),
errorbar(1:5,mean(r2.long),std(r2.long)/sqrt(size(r2.long,1)))
xlim([.5,5.5])
set(gca,'XTick',1:5,'XTickLabel',{'1-->2','2-->3','3-->4','4-->5','5-->6'},...
    'YLim',[0,.4],'YTick',0:.1:.4)
ylabel('r^2')
box off

text(3,-.075,'Blocks','HorizontalAlignment','center')

%% STATS
% data points
Nnone = size(slope.none(:),1);
Nlong = size(slope.long(:),1);

% ranksum slope
[pval,h] = ranksum(slope.none(:),slope.long(:));
fprintf('ranksum-test on slope stim vs. ctrl: p=%.03f\n',pval)

% ranksum r2
[pval,h] = ranksum(r2.none(:),r2.long(:));
fprintf('ranksum-test on r^2 stim vs. ctrl: p=%.03f\n',pval)

% t-test slope
[h,pval] = ttest(slope.long(:));
fprintf('t-test on slope stim: p=%.09f\n',pval)

% proportion of regression model p-vals<.05
fprintf('no stim proportion of p-vals<.05: %i out of %i\n',sum(p.none(:)<.05),Nnone)
fprintf('long latency stim proportion of p-vals<.05: %i out of %i\n',sum(p.long(:)<.05),Nlong)

