function [Xvecq,Yvecq,heatmap] = vec2heatmap(vec,N)

%

% This function converts a vector of size (96 x 1) to an interpolated

% ECoG heatmap (calls EcogMap).

% 

% Note to self... one day should generalize to any map.

% 

% Function Call:

% [Xvecq,Yvecq,heatmap] = vec2heatmap(vec,N)

%   vec (96 x 1) or (1 x 96) vector

%   N - level of interpolation 

%       1 - no interpolation (for debugging)

%       100 - works well for smooth heatmap

 

vec = vec(:);

EcogMap;

matrixMap = nan(size(MapChM));

 

for ch=1:96

    [r,c] = find(MapChM == ch);

    matrixMap(r,c) = vec(ch);

end

 

if N>1,

    % replace nans with avg (if on edge just steal neighbor's value)

    [nanr,nanc] = find(isnan(matrixMap));

    for i=1:length(nanr)

        if nanr(i)==1

            matrixMap(nanr(i),nanc(i)) = nanmean(matrixMap(nanr(i):nanr(i)+1,nanc(i)));

        elseif nanr(i)==16

            matrixMap(nanr(i),nanc(i)) = nanmean(matrixMap(nanr(i)-1:nanr(i),nanc(i)));

        else

            matrixMap(nanr(i),nanc(i)) = nanmean(matrixMap(nanr(i)-1:nanr(i)+1,nanc(i)));

        end

    end

    % interpolate for smooth image

    Xvec = MapXM(:,1);

    Yvec = MapYM(2,:)';

    [X,Y] = meshgrid(Xvec',Yvec');

 

    Xvecq = linspace(min(MapXM(:,1)),max(MapXM(:,1)),N*length(Xvec))';

    Yvecq = linspace(min(MapYM(2,:)),max(MapYM(2,:)),N*length(Yvec))';

    [Xq,Yq] = meshgrid(Xvecq,Yvecq);

 

    heatmap = interp2(X,Y,matrixMap',Xq,Yq);

    heatmap = (heatmap); % flip to correct for plotting

else

    Xvecq = MapXM(:,1);

    Yvecq = MapYM(2,:)';

    heatmap = (matrixMap');

end