%% parameters for figure
clear,clc,close all
figure

% colors
cc = get(groot,'defaultAxesColorOrder');
% cc = [0 0 0;
%     0.5 0.5 0.5];

% font
title_size = 14;
label_size = 10;
other_size = 10;
type = 'Helvetica';

% box
box off

%% load data
load('Figure4_FigureSupplement2_SourceData.mat')
freqs = mean(freqs,2);
Nfreqs = size(freqs,1);

%% plot of change in coh per freq

for i=1:3,
    subplot(3,1,i)
    for ctrl=1:2,
        % get avg change per session
        dPch = cell(1,Nfreqs);
        for fp=1:Nfreqs,
            for s=1:length(P0{ctrl,fp}),
                switch i
                    case 1, dPch{fp} = [dPch{fp} ; mean(Pf{ctrl,fp}{s}-P0{ctrl,fp}{s})];
                    case 2, dPch{fp} = [dPch{fp} ; mean(Pf_stim{ctrl,fp}{s}-P0_stim{ctrl,fp}{s})];
                    case 3, dPch{fp} = [dPch{fp} ; mean(Pf_sec{ctrl,fp}{s}-P0_sec{ctrl,fp}{s})];
                end
            end
        end
        
        % figure % bar plot
        
        avg = nanmean([dPch{:}],1);
        sem = nanstd([dPch{:}],[],1) / sqrt(size([dPch{:}],1));
        switch ctrl,
            case 1,
                h(ctrl)=errorbar(freqs(:,1)-.25,avg,sem,'.',...
                    'LineWidth',1.5,'CapSize',0,'Color',cc(ctrl,:)); hold on
            case 2,
                h(ctrl)=errorbar(freqs(:,1)+.25,avg,sem,'.',...
                    'LineWidth',1.5,'CapSize',0,'Color',cc(ctrl,:)); hold on
        end
    end
    
    xlabel('Frequency Band (Hz)','FontName',type,'FontSize',label_size)
    ylabel('\Delta Power (dB)','FontName',type,'FontSize',label_size)
    legend(h,'No Stim','Long','Location','SouthEast')
    legend boxoff
    switch i
        case 1, title('Change in Normalized Power'), fprintf('Change in Normalized Power\n')
        case 2, title('Change in Stim Channel Power'), fprintf('Change in Stim Channel Power\n')
        case 3, title('Change in Secondary Channels Power'), fprintf('Change in Secondary Channels Power\n')
    end
    hline(0,'--','Color',[.8,.8,.8])
    
    % do ttests for each freq band with bonferroni
    for fp=1:length(freqs),
        dPch = cell(1,2);
        for ctrl=1:2,
            for s=1:length(P0{ctrl,fp}),
                switch i,
                    case 1, dPch{ctrl} = [dPch{ctrl} ; mean(Pf{ctrl,fp}{s}-P0{ctrl,fp}{s})];
                    case 2, dPch{ctrl} = [dPch{ctrl} ; mean(Pf_stim{ctrl,fp}{s}-P0_stim{ctrl,fp}{s})];
                    case 3, dPch{ctrl} = [dPch{ctrl} ; mean(Pf_sec{ctrl,fp}{s}-P0_sec{ctrl,fp}{s})];
                end
            end
        end
        [h,p] = ttest2(dPch{1},dPch{2});
        if p<(.05/length(freqs)), % Multiple Comparisons Correction (Bonferonni)
            text(freqs(fp),.15,'*','FontSize',24)
        end
        fprintf('%.2f\n',p*length(freqs))
    end
end
%
