%% parameters for figure
clear,clc,close all

% colors/markers
cc = get(groot,'defaultAxesColorOrder');

% font
title_size = 14;
label_size = 10;
other_size = 10;
type = 'Helvetica';

% box
box off

%% load data
load('Figure5_FigureSupplement1_SourceData.mat');

%% PLOT SUMMARY DATA: Connectivity Across Time
blocks = [1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2];

% organize data: 
%   test_summary (block x session)
%   cond_summary (block x session x pulseGroup)
S = length(test_pk2tr{1,1}) + length(test_pk2tr{2,1});
test_summary = nan(6,S);
cond_summary = nan(5,S,36);
idx = 0;
for n=1:2,
    for s=1:length(test_pk2tr{n,1}),
        block = 0;
        idx = idx + 1;
        for i=1:length(blocks),
            block_type = blocks(i);
            if block_type==1, block = block + 1; end
            switch block_type,
                case 1, % recording block
                case 2, % test block
                    test_summary(block,idx) = nanmean(test_pk2tr{n,block}{s},2);
                case 3, % conditioning block
                    I = size(cond_pk2tr{n,block}{s},1);
                    cond_summary(block,idx,1:I)...
                        = nanmean(cond_pk2tr{n,block}{s},2);
            end
        end
    end
end

% plotting
block = 0;
xf = 0;
trec = [];
t_test = [];
t_cond = [];
for i=1:length(blocks),
    block_type = blocks(i);
    if block_type==1, block = block + 1; end
    switch block_type,
        case 1, % recording block
            x0 = xf;
            xf = x0 + 5;
            trec(end+1) = mean([x0,xf]);
        case 2, % test block
            x0 = xf;
            xf = x0 + 1;
            N = sum(~isnan(test_summary(block,:)));
            t_test(end+1) = mean([x0,xf]);
        case 3, % conditioning block
            x0 = xf;
            xf = x0 + 10;
            t_cond = [t_cond;linspace(x0,xf,36)];
            I = 36;
            N = sum(~isnan(cond_summary(block,:,1)));
    end
end

%% PLOT SUMMARY DATA: from Baseline Across Time

% organize data: 
%   cond_slope (block x session)
DEBUG = false;
if DEBUG, figure; end

S = length(cond_pk2tr{1,1}) + length(cond_pk2tr{2,1});
% cond_slope = nan(5,S);
% idx = 0;
% for n=1:2,
%     for s=1:length(cond_pk2tr{n,1}),
%         idx = idx + 1;
%         for block=1:5,
%             % do linear regression
%             X = addones((1:size(cond_pk2tr{n,block}{s},1))');
%             Y = mean(cond_pk2tr{n,block}{s},2);
%             B = X\Y;
%             cond_slope(block,idx) = B(2);
%             if DEBUG,
%                 clf;
%                 scatter(X(:,2),Y), hold on
%                 xx = get(gca,'XLim');
%                 yy = B(1) + B(2)*xx;
%                 plot(xx,yy,'k')
%                 waitforbuttonpress;
%             end
%         end
%     end
% end

% test block delta summary
test_change_summary = test_summary' - test_summary(1,:)'; %#ok<UDIM>

% cond block delta summary
cond_change_summary = cond_summary - cond_summary(1,:,1); %#ok<UDIM>

% plotting
hold on
yyaxis left

% errorbar(11:16:75,nanmean(cond_slope,2),nanstd(cond_slope,[],2)/sqrt(size(cond_slope,2)),'.','CapSize',0)
for i=1:5,
    boundedline(t_cond(i,:),squeeze(nanmean(cond_change_summary(i,:,:),2)),squeeze(nanstd(cond_change_summary(i,:,:),[],2))/sqrt(size(cond_change_summary,2)))
end
errorbar(t_test,nanmean(test_change_summary,1),nanstd(test_change_summary,[],1)/sqrt(size(test_change_summary,1)),'.','CapSize',0)
ylabel('\Delta Pk2Tr Ratio','FontName',type,'FontSize',label_size)
xlim([0,90])
ylim([-.3,.3])


%% summary plot of coherence across blocks
C_summary = [];
for n=1:2,
    for s=1:length(C{n,1}),
        C_summary(end+1,:) = nan(1,Nblocks);
        for k=1:Nblocks,
            C_summary(end,k) = mean(C{n,k}{s});
        end
    end
end
dC_summary = C_summary - C_summary(:,1);

yyaxis right

errorbar(trec(1:end),nanmean(dC_summary),nanstd(dC_summary)/sqrt(sum(~isnan(dC_summary(:,1)))),'.','CapSize',0)
xlabel('Time (min)','FontName',type,'FontSize',label_size)
ylabel('\Delta \theta Coherence','FontName',type,'FontSize',label_size)
title('Block-to-Block Changes','FontName',type,'FontSize',title_size)
ylim([-.2,.2])

%% is change from initial block similar for coh and evoked resp?
rec_dC_summary = dC_summary;
test_change_summary = test_summary' - test_summary(1,:)';

idx = ~isnan(rec_dC_summary(:,1));
rec_dC_summary = rec_dC_summary(idx,:);
test_change_summary = test_change_summary(idx,:);


for i=1:size(test_change_summary,1),
    X = [test_change_summary(i,:)',rec_dC_summary(i,:)'];
    R{i} = corrcoef(X);
end
R = mean(cat(3,R{:}),3);

str = {'Test','Rec'};
fprintf('\n\n\tCorrelation Matrix\n\n')
fprintf('\tTest\tRec\n')
fprintf('Test\t%.2f\t%.2f\n',R(1,:))
fprintf('Rec\t%.2f\t%.2f\n',R(2,:))
save('CorrelationMatrixV2NoStim.mat','R','str')


%% do significance test on last test block (is it stable?)
fprintf('t-test for test block 5 --> 6:\n')
[h,p] = ttest(test_summary(6,:)'-test_summary(5,:)')

%% do sig test for each block: last delta cond to delta test
for i=1:5,
    idx = [];
    for j=1:size(cond_change_summary,2)
        nanidx = isnan(squeeze(cond_change_summary(i,j,:)));
        idx = [idx,find(nanidx==0,1,'last')];
    end
    idx = max(idx);
    [h,p] = ttest(cond_change_summary(i,:,idx),-test_change_summary(:,i+1)');
    fprintf('\nAfter Block %i:\n',i)
    fprintf('  p=%.4f',p*5)
end

%% significance test for changes from baseline during conditioning during first block
clc
for blk = 1:5,
    h = [];
    p = [];
    for i=1:36,
        [htmp,ptmp] = ttest(squeeze(cond_summary(blk,:,i))-test_summary(blk,:));
        h(i) = htmp;
        p(i) = ptmp;
    end
end
[t_cond(blk,:)'-t_cond(blk,1),h',p']
