%% parameters for figure
clear,clc,close all

% colors/markers
cc = [
    .75 0   .75 % purple
    0   .5  0   % green
    ]; % for each monkey
M = {'o','d'}; % markers for each monkey
sz = 12; % marker size
lw = {1,3}; % line width (sz 1 is for filled in markers, sz 2 is for empty markers)

% font
title_size = 14;
label_size = 14;
other_size = 10;
type = 'Helvetica';

% box
box off
hold on

%% load data
load('Figure4B-C_SourceData.mat')

%% Evoked Response Amplitude vs Coherence (regressing out distance)

names = {'GT','Jalapeno'};

pktr1 = [];
pktr2 = [];
for s=1:length(pk2tr),
    n = find(strcmp(S{s}.name,names));
    pktr1(end+1) = mean(pk2tr{s}(:,1));
    pktr2(end+1) = mean(pk2tr{s}(:,2));
    [h,p] = ttest(pk2tr{s}(:,1),pk2tr{s}(:,2));
    fprintf('Monkey%i, %i, %.3g\n',n,length(pk2tr{s}(:,1)),p)
%     fprintf('Monkey%i\n',n)
%     fprintf('%i\n',length(pk2tr{s}(:,1)))
%     fprintf('%.3g\n',p)
    
    if h,
        ax(n)=plot(pktr1(end),pktr2(end),...
            M{n},'MarkerFaceColor',cc(n,:),...
            'MarkerEdgeColor','w','MarkerSize',sz,...
            'LineWidth',lw{1});
    else
        plot(pktr1(end),pktr2(end),...
            M{n},'MarkerEdgeColor',cc(n,:),...
            'MarkerSize',sz,'LineWidth',lw{2});
    end
end

% pre post scatter plots
xx = [0,1.5];
yy = [0,1.5];
set(gca,'XLim',xx);
set(gca,'YLim',yy);
plot(xx,xx,'k')
xlabel('Pre','FontName',type,'FontSize',label_size)
ylabel('Post','FontName',type,'FontSize',label_size)
title('Normalized Pk2Tr','FontName',type,'FontSize',title_size)
legend(ax,{'Monkey G','Monkey J'},'Location','SouthEast')
legend boxoff



