%% parameters for figure
clear,clc,close all

% colors/markers
cc = get(groot,'defaultAxesColorOrder');

% font
title_size = 14;
label_size = 10;
other_size = 10;
type = 'Helvetica';

% box
box off

%% PLOT EXAMPLE SESSION
n=1;
s=3;
%n=1: s=3,6,8
%n=2: s=1,7

%% AMPLITUDE
load('Figure5_SourceData.mat');
S{n}{s};

yyaxis left
hold on

blocks = [1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2];

block = 0;
xf = 0;
for i=1:length(blocks),
    block_type = blocks(i);
    if block_type==1, block = block + 1; end
    switch block_type,
        case 1, % recording block
            x0 = xf;
            xf = x0 + 5;
        case 2, % test block
            x0 = xf;
            xf = x0 + 1;
            ax(2)=plot(mean([x0,xf]),mean(test_pk2tr{n,block}{s},2),'o','Color',cc(1,:));
        case 3, % conditioning block
            x0 = xf;
            xf = x0 + 10;
            I = size(cond_pk2tr{n,block}{s},1);
            ax(3)=plot(linspace(x0,xf,I),mean(cond_pk2tr{n,block}{s},2),'.','Color',cc(1,:));
    end
end
xlim([0,90])
xlabel('Time (min)','FontName',type,'FontSize',label_size)
ylabel('SERR','FontName',type,'FontSize',label_size)
title('Example Session','FontName',type,'FontSize',title_size)

%% COHERENCE
load('Figure5_SourceData.mat')
S{n}{s}

hold on
yyaxis right

blocks = [1,2,3,1,2,3,1,2,3,1,2,3,1,2,3,1,2];

block = 0;
xf = 0;
for i=1:length(blocks),
    block_type = blocks(i);
    if block_type==1, block = block + 1; end
    switch block_type,
        case 1, % recording block
            x0 = xf;
            xf = x0 + 5;
            ax(1)=plot(mean([x0,xf]),mean(C{n,block}{s},1),'x','Color',cc(2,:));
        case 2, % test block
            x0 = xf;
            xf = x0 + 1;
        case 3, % conditioning block
            x0 = xf;
            xf = x0 + 10;
    end
end
ylabel('\theta Coherence','FontName',type,'FontSize',label_size)
legend(ax,{'Recording','Test','Condition'},'Location','SouthEast')
legend boxoff


