%% load data
clear, close all, clc
f=load('SupplementalTable2_SourceData.mat');
stats = {'broadband_amp','broadband_energy','broadband_slope','hg_energy'};

% colors/markers
cc = [.35 .35 .35]; % gray

% font
title_size = 14;
label_size = 10;
other_size = 10;
type = 'Helvetica';

%% plots
for i=1:length(stats),
    stat = stats{i};

    stat1_stim = cat(1,f.(sprintf('%s1_S1stim',stat)),f.(sprintf('%s1_M1stim',stat)));
    stat2_stim = cat(1,f.(sprintf('%s2_S1stim',stat)),f.(sprintf('%s2_M1stim',stat)));
    
    % do stats on all stim vs no stim
    fprintf('%s:\n',strrep(stat,'_',' '))
    [p,h] = signrank(f.(sprintf('%s1_nostim',stat)),f.(sprintf('%s2_nostim',stat)));
    fprintf('%s: ranksum (no stim change) p= %.03f\n',strrep(stat,'_',' '),p)
    [p,h] = signrank(stat1_stim,stat2_stim);
    fprintf('%s: ranksum (stim change) p= %.03f\n',strrep(stat,'_',' '),p)
    
    [p,h] = ranksum(...
        f.(sprintf('%s2_nostim',stat))-f.(sprintf('%s1_nostim',stat)),...
        stat2_stim-stat1_stim);
    fprintf('%s: ranksum (no stim vs. stim) p= %.03f\n\n',strrep(stat,'_',' '),p)
    
end