%% ASH soma data import and basic analysis script for ASH 3x10sec stimulus protocos
%  Donovan Ventimilglia
% Matlab 2013b

%% Import Data and collect axon and background values

Datafiles = dir('*.txt'); 
numfiles = length(Datafiles);
mydata = cell(1, numfiles); % Cell containing imported txt file: data, textdata, and column headers
AllDataS=[]; % Matrix containing mean intensity values of axon 
AllDataBG=[]; % Matrix containing mean intensity values of background

for k = 1:numfiles
    mydata{1,k} = importdata(Datafiles(k).name);
    filenamesS{k}=Datafiles(k).name;
    AllDataS(1:length(mydata{1,k}(:,4)),k)=mydata{1,k}(:,4); %Make matrix of soma signals
    AllDataBG(1:length(mydata{1,k}(:,6)),k)=mydata{1,k}(:,6); %Make matrix of Background 
end

%% Assign trial number to each trace
for k = 1:numfiles
    TrialPos=strfind(filenamesS{k},'T')+1;
    TrialNum(k)=str2num(filenamesS{k}(TrialPos));
end

%% Perform background normalization and calculate deltaF. 
% DeltaF = (Signal - Signal_Initial)/Signal_Initial * 100.
% Due to signal scatter from GCaMP, background correction cannot be perfrom
% without removing true signal. Data is instead normalized by the mean
% background during the normalization period to account for differences in
% head auto fluorescence 

NP=[100:149]; %Set normalization period (NP)
numframes=size(AllDataS,1); %number of frames recorded durning acquisition 
BGNorm_correctedData=AllDataS./repmat(mean(AllDataBG(NP,:)),numframes,1);; %background subtraion
Initial=repmat(mean(BGNorm_correctedData(NP,:)),numframes,1); %Creates matrix of NP values for each trace and each time point 
DeltaF=(BGNorm_correctedData-Initial)./Initial*100; %Calculate DeltaF
databrowse(DeltaF',[1:numframes]./5);hilite([150 200;300 350;450 500]/5);


%% Separate data into trials

% Separate Data by trial 
Trial_1_DeltaF_data=DeltaF(:,TrialNum==1);
Trial_2_DeltaF_data=DeltaF(:,TrialNum==2);
Trial_3_DeltaF_data=DeltaF(:,TrialNum==3);

% Create a vector to sort data
Trial_sorter(1,1:size(Trial_1_DeltaF_data,2))=1;
Trial_sorter(1,size(Trial_1_DeltaF_data,2)+1:size(Trial_1_DeltaF_data,2)+size(Trial_2_DeltaF_data,2))=2;
Trial_sorter(1,size(Trial_1_DeltaF_data,2)+size(Trial_2_DeltaF_data,2)+1:size(Trial_1_DeltaF_data,2)+size(Trial_2_DeltaF_data,2)+size(Trial_3_DeltaF_data,2))=3;
Trials=[Trial_1_DeltaF_data Trial_2_DeltaF_data Trial_3_DeltaF_data]; %organize trial data into a single matrix: trials 1, 2, 3.
% Plot 
databrowse(Trials',[1:numframes]./5,Trial_sorter);hilite([150 200;300 350;450 500]/5);

%% Average pulses separately BG subtracted data

% Separate pulses
Pulse_1=BGNorm_correctedData(125:300,:);
Pulse_2=BGNorm_correctedData(275:450,:);
Pulse_3=BGNorm_correctedData(425:600,:);
AllPulses=[Pulse_1 Pulse_2 Pulse_3];

% Perform background subtraion and calculate deltaF. 
dF_AllPulses=(AllPulses-repmat(mean(AllPulses(1:10,:)),176,1))./repmat(mean(AllPulses(1:10,:)),176,1)*100;

% Create a vector to sort data
Sort_by_pulse_num(1,1:size(Pulse_1,2))=1;
Sort_by_pulse_num(1,size(Pulse_1,2)+1:size(Pulse_1,2)+size(Pulse_2,2))=2;
Sort_by_pulse_num(1,size(Pulse_1,2)+size(Pulse_2,2)+1:size(Pulse_1,2)+size(Pulse_2,2)+size(Pulse_3,2))=3;

% Plot pulses separated 
databrowse(dF_AllPulses',[1:size(dF_AllPulses,1)]/5,Sort_by_pulse_num);
hilite([5 15]);

% Plot All pulses  
databrowse(dF_AllPulses',[1:size(dF_AllPulses,1)]/5);
hilite([5 15]);

% Save analysis
save(datestr(now));
























