// Neuron GCaMP Tracking
// Andrew Gordus
// November 16, 2011
// Tracks two thresholded features (i.e. neurons).
// Modified by Donovan Ventimiglia 2015 - used for tracking ASH (single neuron), AIB, or AVA neurons

//--------------------------------------//
// Open Files, Set Threshold and Select //
// Neuron, Background and Dye locations //
//--------------------------------------//


macro "Neuron tracksSettings double static [s]" {

dir = getDirectory("Choose a Directory ");
list = getFileList(dir);
k=0;
newlist = newArray(list.length);
for (i=0; i < list.length; i++)  {
	if (endsWith(list[i], ".tif")) {
	newlist[k] = list[i];
	k=k+1;
	}
}
list = Array.trim(newlist, k)


if (File.exists(dir+"/Tracksettings/")==0){File.makeDirectory(dir+"/Tracksettings/");}

Lower1 = newArray(list.length);
XE1 = newArray(list.length);
YE1 = newArray(list.length);
WE1 = newArray(list.length);
HE1 = newArray(list.length);
XB1 = newArray(list.length);
YB1 = newArray(list.length);
Lower2 = newArray(list.length);
XE2 = newArray(list.length);
YE2 = newArray(list.length);
WE2 = newArray(list.length);
HE2 = newArray(list.length);
XB2 = newArray(list.length);
YB2 = newArray(list.length);
Extension1 = newArray(list.length);
Extension2 = newArray(list.length);


for (file=0; file < list.length; file++)  {
open(dir + list[file]);
run("In [+]");
run("In [+]");

dv_name = getTitle;
dv_dotIndex = indexOf(dv_name, "."); 
dv_title=newArray(list.length);
dv_title[file] = substring(dv_name, 0, dv_dotIndex); 

// Set Parameters for Neuron #1

run("Clear Results");

print("Select threshold");

// Go to beginning of stack
//setSlice(1);
//updateDisplay();
run("Select None");
//setMinAndMax(100, 550);

run("Clear Results");
// Set lower threshold limit
showStatus("Set threshold for neuron #1:");
setThreshold(800,65535);
run("Threshold...");
do {
	getThreshold(lower, upper);
	} while (isKeyDown("space") != 1);
setThreshold(lower, 65535);

wait(100);

selectWindow("Log"); 
run("Close");
run("Threshold...");

// Create ellipse around neuron #1

print("Select neuron #1");
setTool("oval");

showStatus("Create Ellipse around neuron #1:");
wait(1000);
do {
	// Measure selection parameters.
	getSelectionBounds(x, y, w, h);
	wait(100);
	} while (isKeyDown("space") != 1);


wait(100);

selectWindow("Log"); 
run("Close");


// Choose background location for neuron #1

print("Select BG #1");

showStatus("Select center background location:"); 
do {
	getCursorLoc(xb, yb, z, flags);
	wait(100);
} while (flags != 16);

wait(100);


Lower1[file]=lower;
XE1[file]=x;
YE1[file]=y;
WE1[file]=w;
HE1[file]=h;
XB1[file]=xb;
YB1[file]=yb;

wait(100);

selectWindow("Log"); 
run("Close");

// Set Parameters for Neuron #2

print("Threshold Neuron #2");

run("Clear Results");

// Go to beginning of stack
setSlice(1);
updateDisplay();
run("Select None");

run("Clear Results");
// Set lower threshold limit
showStatus("Set threshold for neuron #2:");
run("Threshold...");
do {
	getThreshold(lower, upper);
	} while (isKeyDown("space") != 1);
setThreshold(lower, 65535);

wait(100);

selectWindow("Log"); 
run("Close");


// Create ellipse around neuron #2

print("Select Neuron #2");

showStatus("Create Ellipse around neuron #2:");
wait(1000);
do {
	// Measure selection parameters.
	getSelectionBounds(x, y, w, h);
	wait(100);
	} while (isKeyDown("space") != 1);


wait(100);

selectWindow("Log"); 
run("Close");

// Choose background location for neuron #2

print("Select BG #2");


showStatus("Select center background location:"); 
do {
	getCursorLoc(xb, yb, z, flags);
	wait(100);
} while (flags != 16);

wait(100);

selectWindow("Log"); 
run("Close");

Lower2[file]=lower;
XE2[file]=x;
YE2[file]=y;
WE2[file]=w;
HE2[file]=h;
XB2[file]=xb;
YB2[file]=yb;

wait(100);

// Establish recording order
title = "ASH";
title2="ASI";
width=512; height=512;
Dialog.create("Parameters");
Dialog.addString("Neuron # 1:", title);
Dialog.addString("Neuron # 2:", title2);
Dialog.addCheckbox("Hide Movie?", true);
Dialog.show();
Extension1[file] = Dialog.getString();
Extension2[file] = Dialog.getString();
dispmovie = Dialog.getCheckbox();

close();


start = getTime;

print(Lower1[file]);
print(XE1[file]);
print(YE1[file]);
print(WE1[file]);
print(HE1[file]);
print(XB1[file]);
print(YB1[file]);

print(Lower2[file]);
print(XE2[file]);
print(YE2[file]);
print(WE2[file]);
print(HE2[file]);
print(XB2[file]);
print(YB2[file]);

print(Extension1[file]);
print(Extension2[file]);


selectWindow("Log");
saveAs("Text",dir+"/Tracksettings/"+dv_title[file]+"_Tracksettings");
selectWindow("Log");
run("Close");


}} // end of tracksettings script


//----------------------------//
// Open Files and Record Data //
//----------------------------//



macro "Neuron tracking double static [t]" {


dir = getDirectory("Choose a Directory ");
list = getFileList(dir);
k=0;
newlist = newArray(list.length);
for (i=0; i < list.length; i++)  {
	if (endsWith(list[i], ".tif")) {
	newlist[k] = list[i];
	k=k+1;
	}
}
list = Array.trim(newlist, k)


// Specify location of tracksettings file and create a list of files

TrackSettingfiles=getFileList(dir+"Tracksettings/");
if (File.exists(dir+"/Data/")==0){File.makeDirectory(dir+"/Data/");}

for (file=0; file < list.length; file++)  {
setBatchMode(true);
open(dir + list[file]);
rename("Movie_A");
run("Clear Results");
filename =getInfo("image.filename");
filename =substring(filename,0,lengthOf(filename)-4);


//dv_name = getTitle;
//dv_dotIndex = indexOf(dv_name, "."); 
//dv_title=newArray(list.length);
//dv_title[file] = substring(dv_name, 0, dv_dotIndex); 



// Import tracksettings from text file

TrckSttng=newArray(16);
TrckSttng=ReadSettings(TrckSttng,dir+"Tracksettings/"+TrackSettingfiles[file]);

Lower1= TrckSttng[0];
XE1=TrckSttng[1];
YE1=TrckSttng[2];
WE1=TrckSttng[3];
HE1=TrckSttng[4];
XB1=TrckSttng[5];
YB1=TrckSttng[6];

Lower2= TrckSttng[7];
XE2=TrckSttng[8];
YE2=TrckSttng[9];
WE2=TrckSttng[10];
HE2=TrckSttng[11];
XB2=TrckSttng[12];
YB2=TrckSttng[13];

Extension1=newArray(list.length);
Extension2=newArray(list.length);
Extension1[file]=TrckSttng[14];
Extension2[file]=TrckSttng[15];


// import finished

min_avg = 1000000;
max_avg = 0;
min_int = 10000000;
max_int = 0;
min_x = 10000000;
max_x = 0;
	


for (ext=0; ext < 2; ext++)  {
	run("Clear Results");

	// Go to beginning of stack
	setSlice(1);
	updateDisplay();
	run("Select None");
	
	run("Clear Results");
	if (ext==0){
		lower = parseFloat(Lower1);
		x = parseFloat(XE1);
		y = parseFloat(YE1);
		w = parseFloat(WE1);
		h = parseFloat(HE1);
		xb = parseFloat(XB1);
		yb = parseFloat(YB1);
	}else{
		lower = parseFloat(Lower2);
		x = parseFloat(XE2);
		y = parseFloat(YE2);
		w = parseFloat(WE2);
		h = parseFloat(HE2);
		xb = parseFloat(XB2);
		yb = parseFloat(YB2);
	}

	
	wb = 10;
	hb = 10;
	
	// Defaults
	
	// Initialize variables
	area = 0; maxint = 0; intdens = 0; xc = x + 0.5*w; yc = y + 0.5*h; xp = xc; yp = yc; avg = 0; bgavg = 0; dx = 0; dy = 0;
	if (ext==0){
		X1 = newArray(nSlices);
		Y1 = newArray(nSlices);
		Int1 = newArray(nSlices);
		Bg1 = newArray(nSlices);
		Avg1 = newArray(nSlices);
		Area1 = newArray(nSlices);
		Plot1 = newArray(nSlices);
	}else{
		X2 = newArray(nSlices);
		Y2 = newArray(nSlices);
		Int2 = newArray(nSlices);
		Bg2 = newArray(nSlices);
		Avg2 = newArray(nSlices);
		Area2 = newArray(nSlices);
		Plot2 = newArray(nSlices);
	}
	
	print("\\Clear");
	// print("Slice,avg,intdens, bgavg, maxint, dye, xc, yc, area");
	
	run("Threshold...");
	setThreshold(lower, 65535);
	
	run("Clear Results");
	for (slice=1; slice<=nSlices; slice++)  {
		run("Clear Results");
		setSlice(slice);
		makeOval(xc - 0.5*w, yc - 0.5*h, w, h);
		if (slice == 1) {
		//	if(ext==0){
				run("Set Measurements...", "area min centroid center integrated slice limit redirect=None decimal=3");
				run("Analyze Particles...", "size=1-Infinity circularity=0.00-1.00 show=Nothing display clear slice");
				if (nResults == 1) {
					start_area = getResult("Area", 0);
					good = 0;
				}
				if (nResults > 1) {
					start_area = 0;
					for (result=0; result<nResults; result++)  {
						area = getResult("Area", result);
						if (area > start_area) {
							start_area = area;
							good = result;
						}
					}
				}
		//	}else{
		//		run("Set Measurements...", "area mean min median slice limit redirect=None decimal=3");
		//		run("Measure");
		//		if (nResults == 1) {
		//			avg = getResult("Mean", 0);
		//		}
		//	}
		}else {
		//	if(ext==0){
				run("Set Measurements...", "area min centroid center integrated slice limit redirect=None decimal=3");
				small = 0.1*start_area;  //10; // 0.75*start_area;
				large = 1.25*start_area;
				run("Analyze Particles...", "size=small-Infinity circularity=0.00-1.00 show=Nothing display clear slice");
				if (nResults == 1) {
				area = getResult("Area", 0);
				good = 0;
				}
				if (nResults > 1) {
					area = 0;
					for (result=0; result<nResults; result++)  {
						test_area = getResult("Area", result);
						if (test_area > area) {
							area = test_area;
							good = result;
						}
					}
				}
				if (nResults < 1) {
					area = 0;
				}
				
				while (area > start_area) {
					lower = lower + 10;
					setThreshold(lower, 65535);
					makeOval(xc - 0.5*w, yc - 0.5*h, w, h);
					run("Analyze Particles...", "size=small-Infinity circularity=0.00-1.00 show=Nothing display clear slice");
					if (nResults == 1) {
						area = getResult("Area", 0);
						good = 0;
					}
					if (nResults > 1) {
						area = 0;
						for (result=0; result<nResults; result++)  {
							test_area = getResult("Area", result);
							if (test_area > area) {
								area = test_area;
								good = result;
							}
						}
					}
					if (nResults == 0) {
						lower = lower - 11;
					}
					
				}
				while (area < start_area) {
					lower = lower - 10;
					setThreshold(lower, 65535);
					makeOval(xc - 0.5*w, yc - 0.5*h, w, h);
					run("Analyze Particles...", "size=small-Infinity circularity=0.00-1.00 show=Nothing display clear slice");
					if (nResults == 1) {
						result = 0;
						area = getResult("Area", result);
						good = 0;
					}
					if (nResults > 1) {
						area = 0;
						for (result=0; result<nResults; result++)  {
							test_area = getResult("Area", result);
							if (test_area > area) {
								area = test_area;
								good = result;
							}
						}
					}
					if (nResults < 1) {
						area = 0;
					}
				}
		
		//	}else{
		//		run("Set Measurements...", "area mean min median slice limit redirect=None decimal=3");
		//		run("Measure");
		//		if (nResults == 1) {
		//			avg = getResult("Mean", 0);
		//		}
		//	}
		}
		if (ext==0){
			xc = getResult("XM", good);
			yc = getResult("YM", good);
		}
		area = getResult("Area", good);
		maxint = getResult("Max", good);
		intdens = getResult("IntDen", good);
		avg = intdens / area;

		makeOval(xb - 0.5*wb, yb - 0.5*hb, wb, hb);
		run("Clear Results");
		run("Set Measurements...", "area mean min median slice redirect=None decimal=3");
		run("Measure");
		if (nResults == 1) {
			bgavg = getResult("Mean", 0);
		}
//		makeRectangle(xd - 0.5*wb, yd - 0.5*hb, wb, hb);
//		run("Clear Results");
//		run("Set Measurements...", "area mean min median slice redirect=None decimal=3");
//		run("Measure");
//		if (nResults == 1) {
//			dye = getResult("Mean", 0);
//		}
		

		if (ext==0){
			X1[slice-1]=xc;
			Y1[slice-1]=yc;
			Int1[slice-1]= intdens - bgavg*area;
			Bg1[slice-1]=bgavg;
			Avg1[slice-1]=avg-bgavg;
			Plot1[slice-1]=avg-bgavg;
			Area1[slice-1]=area;
			//Velocity prediction
			dx = xc-xp; dy = yc-yp;
			xp = xc; yp = yc;
			xc = xc + dx; yc = yc+dy;
			xb = xb + dx; yb = yb+dy;
		}else{
			X2[slice-1]=xc;
			Y2[slice-1]=yc;
			Int2[slice-1]= intdens - bgavg*area;
			Bg2[slice-1]=bgavg;
			Avg2[slice-1]=avg-bgavg;
			Area2[slice-1]=area;
			Plot2[slice-1]=avg-bgavg;
			//Velocity prediction
			if (slice !=nSlices){
				dx = X1[slice]-X1[slice-1]; dy = Y1[slice]-Y1[slice-1];
				xc = xc + dx; yc = yc+dy;
				xb = xb + dx; yb = yb+dy;
			}
		}


		if (avg-bgavg > max_avg){max_avg = avg-bgavg;}
		if (avg-bgavg < min_avg){min_avg = avg-bgavg;}
		if (intdens - bgavg*area > max_int){max_int = intdens - bgavg*area;}
		if (intdens - bgavg*area < min_int){min_int = intdens - bgavg*area;}
//		if (dye > max_dye){max_dye = dye;}
//		if (dye < min_dye){min_dye = dye;}
		if (xc > max_x){max_x = xc;}
		if (xc < min_x){min_x = xc;}
		// wait(1000);
		print(ext+" , "+slice);
	}
}

print("\\Clear");
for (slice=1; slice<=nSlices; slice++)  {
	print(slice+","+Avg1[slice-1]+","+Avg2[slice-1]+","+Int1[slice-1]+","+Int2[slice-1]+","+ Bg1[slice-1]+","+ Bg2[slice-1]+","+ Area1[slice-1]+","+ Area2[slice-1]+","+ X1[slice-1]+","+ X2[slice-1]+","+ Y1[slice-1]+","+ Y2[slice-1]);
}

selectWindow("Movie_A");
close();
wait(100);
setBatchMode(false);


extension = Extension1[file]+"_"+Extension2[file];

Plot.create(filename+extension, "Frame", "Intensity");
Plot.setLimits(0, slice, min_avg, max_avg);
if (endsWith(Extension1[file], "A")) {
	Plot.setColor("red");
}
if (endsWith(Extension1[file], "B")) {
	Plot.setColor("blue");
}
if (endsWith(Extension1[file], "M")) {
	Plot.setColor("green");
}
Plot.add("line", Avg1);
if (endsWith(Extension2[file], "A")) {
	Plot.setColor("red");
}
if (endsWith(Extension2[file], "B")) {
	Plot.setColor("blue");
}
if (endsWith(Extension2[file], "M")) {
	Plot.setColor("green");
}
Plot.add("line", Avg2);
Plot.show();

Plot.create (filename+"X", "Frame", "Pixel");
Plot.setLimits(0, slice, min_x, max_x);
if (endsWith(Extension1[file], "A")) {
	Plot.setColor("red");
}
if (endsWith(Extension1[file], "B")) {
	Plot.setColor("blue");
}
if (endsWith(Extension1[file], "M")) {
	Plot.setColor("green");
}
Plot.add("line", X1);
if (endsWith(Extension2[file], "A")) {
	Plot.setColor("red");
}
if (endsWith(Extension2[file], "B")) {
	Plot.setColor("blue");
}
if (endsWith(Extension2[file], "M")) {
	Plot.setColor("green");
}
Plot.add("line", X2);
Plot.show();


selectWindow("Log");
save(dir+"/Data/"+filename+extension+".txt");


wait(100);
}


//end = getTime();
//time = (end-start)/60000;
//showStatus("Time = "+time+" minutes");
//print("Time = "+time+" minutes");

//beep();

}

//-----------------------------------------------------------


function ReadSettings(TrckSttng,file) {

string = File.openAsString(file);
xlines = split(string, "\n");

return xlines;
}

//------------------------------------------------------------


