%% AWC Soma GCaMP import and basic analysis
% Donovan Ventimiglia
% Matlab 2013b


files = dir('*txt'); 
numfiles = length(files);
mydata = cell(1, numfiles);
AllData=[];
Data=[];
DataIndex=[];
SDataN=[];
AllAvg=[];
groupnum=cell(1,numfiles);
groupTrial=[];

for k = 1:numfiles
    mydata{1,k} = importdata(files(k).name);
    filenames{k}=files(k).name;
    AllAvg(1:length(mydata{1,k}(:,2)),k)=mydata{1,k}(:,2);
end


for k = 1:numfiles
    
    trialPos=strfind(filenames{k},'trial')+6;
    groupTrial(k)=str2num(filenames{k}(trialPos));
    videonum=strfind(filenames{k},'trial')+8;
    videonumend=strfind(filenames{k},'N2')-1;
    groupnum{1,k}=(filenames{k}(videonum:videonumend));

end


AllThirty=AllAvg(1:900,groupTrial<4);
I=repmat(mean(AllThirty(339:349,:)),900,1);
AllthirtyNorm=(AllThirty-I)./I*100;
databrowse(AllthirtyNorm',[1:900]/10);
hilite([5 35]);
set(gcf,'Color',[1 1 1]);
h=gca;
saveas(h,'AllThirty','fig');
ThrityOnResp=mean(AllthirtyNorm(1:50,:),2);
ThrityOffResp=max(AllthirtyNorm(350:450,:))';
[OnAvgRespThirty,OnAvgstdThirty,OnAvgIntvThirty] = normfit(ThrityOnResp);
[OffAvgRespThirty,OffAvgstdThirty,OffAvgIntvThirty] = normfit(ThrityOffResp);

AllSixty=AllAvg(1:900,groupTrial>3);
I=repmat(mean(AllSixty(639:649,:)),900,1);
AllSixtyNorm=(AllSixty-I)./I*100;
databrowse(AllSixtyNorm',[1:900]/10);
hilite([5 65]);
set(gcf,'Color',[1 1 1]);
h=gca;
saveas(h,'AllSixty','fig');
SixtyOnResp=mean(AllSixtyNorm(1:50,:),2);
SixtyOffResp=max(AllSixtyNorm(650:750,:))';
[OnAvgRespSixty,OnAvgstdSixty,OnAvgIntvSixty] = normfit(SixtyOnResp);
[OffAvgRespSixty,OffAvgstdSixty,OffAvgIntvSixty] = normfit(SixtyOffResp);


summary=[OnAvgRespThirty OffAvgRespThirty OnAvgRespSixty OffAvgRespSixty;
    OnAvgIntvThirty(1,1) OffAvgIntvThirty(1,1) OnAvgIntvSixty(1,1) OffAvgIntvSixty(1,1)];   

