%% AWC syGCaMP import and basic analysis script
% Donovan Ventimilglia
% Matlab 2013b


%% Import Data and collect axon and background values

Datafiles = dir('*Data.txt'); 
numfiles = length(Datafiles);
mydata = cell(1, numfiles); % Cell containing imported txt file: data, textdata, and column headers
ROI_BG1=cell(1,numfiles); % integrated Background FL for left ROIs
ROI_BG2=cell(1,numfiles); % integrated Background FL for right ROIs
Total_BG_mean=[]; % Stores background measure for each video (combines all
Whole_axon_FL=[];
ROI_axon_mean_FL=cell(1,numfiles);
num_of_trials=3;
plotlinkedtrials=0;
plotlinkedtrialsRAW=0;
otherBGcorrect=0;
ROIanalysis=0;


Date=date;
prompt = 'Name this Analysis?';
AnalysisGroupName = ['_' input(prompt) '_' Date];

% Set Normalization point : 10sP = 65:74; 60sP = 315:324; 3minP = 915:924;
% Single pulse: 60sP = 441:450
prompt= 'Specify Normalization point:';
NP=input(prompt);

% import text files
for k = 1:numfiles
    mydata{1,k} = importdata(Datafiles(k).name);
    filenamesS{k}=Datafiles(k).name;
end

% Assign trial iteration number to each video
for k = 1:numfiles
    TrialPos=strfind(filenamesS{k},'T')+1;
    A= isempty(TrialPos);
    if A==0
    TrialNum(k)=str2num(filenamesS{k}(TrialPos));
    else
    TrialNum(k)=1;    
    clear TrialPos;
    end
end


% Get Whole axon FL measurements
for k = 1:size(mydata,2);
    Whole_axon_FL(:,k)=mydata{1,k}.data(:,3);
end

% Get axon ROI measurements for each video
for k = 1:size(mydata,2);
    counter=1;
    for n = 9:18:size(mydata{1,k}.data,2)
    ROI_axon_mean_FL{1,k}(:,counter)=mydata{1,k}.data(:,n);
    counter=counter+1;
    end
end

% Get Background values for each ROI (left and right of axon)
for k = 1:size(mydata,2);
    counter=1;
    for n = 19:18:size(mydata{1,k}.data,2)
        ROI_BG1{1,k}(:,counter)=mydata{1,k}.data(:,n);
        counter=counter+1;
    end
    counter=1;
    for n = 25:18:size(mydata{1,k}.data,2)
        ROI_BG2{1,k}(:,counter)=mydata{1,k}.data(:,n);
        counter=counter+1;
    end
end

% Calculate overall mean background (sum FL of each BG Box, add left and
% right together and divdie by the total area)
for k=1:numfiles
Total_BG_mean(:,k)=(sum(ROI_BG1{1,k},2)+sum(ROI_BG2{1,k},2))./repmat(64*size(ROI_BG1{1,k},2)*2,size(ROI_BG1{1,k},1),1);
end

%% Background correction and DeltaF for whole axon measurement -all data

% Signal corrected by normalizing to average background (single
% measurement, from NP point). Too much scatter from axon to subtract
% background.

for k = 1:numfiles
    Whole_axon_BGcorrected(:,k)=Whole_axon_FL(:,k)./repmat(mean(Total_BG_mean(NP,k)),size(Whole_axon_FL,1),1);
end

% DeltaF calcuation
Inital=repmat(mean(Whole_axon_BGcorrected(NP,:)),size(Whole_axon_BGcorrected,1),1);
DeltaF=(Whole_axon_BGcorrected-Inital)./Inital*100;
databrowse(DeltaF',[1:size(DeltaF,1)]./5); % hilite([30 90]);


%% Create matrix of linked trials (RAW)
%---------------------------

if plotlinkedtrialsRAW==1

counter=1;
for k=1:3:numfiles
temp=Whole_axon_FL(:,k:k+2);
Linked_trials_raw(:,counter)=temp(:);
counter=counter+1;
clear temp
end

plot
figure;
for k=1:size(Linked_trials_raw,2);
subplot(size(Linked_trials_raw,2),1,k);plot(Linked_trials_raw(:,k));
end

end
%---------------------------

%% Create matrix of linked trials (DeltaF)
%---------------------------
if plotlinkedtrials==1

counter=1;
for k=1:3:numfiles
temp=DeltaF(:,k:k+2);
Linked_trials_sub(:,counter)=temp(:);
counter=counter+1;
clear temp
end

% plot
figure;
for k=1:size(Linked_trials_sub,2);
subplot(size(Linked_trials_sub,2),1,k);plot(Linked_trials_sub(:,k));
end

end
%---------------------------

%% other background correction methods

if otherBGcorrect==1

% Background Division
for k = 1:numfiles
    Whole_axon_BGdiv(:,k)=Whole_axon_FL(:,k)./Total_BG_mean(:,k);
end

%---------------------------
% DeltaF for Background Division signal
Inital_div=repmat(mean(Whole_axon_BGdiv(NP,:)),size(Whole_axon_BGdiv,1),1);
DeltaF_div=(Whole_axon_BGdiv-Inital_div)./Inital_div*100;
databrowse(DeltaF_div',[1:size(DeltaF_div,1)]./5);

end

%---------------------------

FileName=['Completed_Analysis' AnalysisGroupName];
save(FileName);




