Start = 2;    % of the actin driven phase (min)
Finish = 8;
%tracks2=tracks;
timestep=5;
nn = size(tracks2, 1)
timeMin = 60; %sec per min
index = 1;  %for the track ID
finish = Finish*(timeMin/timestep);
start = Start*(timeMin/timestep);
%% extract actin tracks
for i = 1:nn
    if tracks2(i,6) <= finish  &  tracks2(i,6) >= start
       actinTracks(index, :) = tracks2(i, :);
       index=index+1;      
    end 
end
% Make sure to catch the actin-driven phase (crop temporally the stack)
% Final table is RESULTS (velocity in um/s plotted against Initial pairwise
% distance in um so slope is in s-1)
% plotted versus the average initial pairwise distance
tracks = actinTracks;
 %parameters
 pixelSize = 0.4340; % in um
 zstep = 2; % in um
 timestep = 5/60; % in min
 %Fit goodness to extract the pairwise velocity
 val_goodness = 0.9;
 loop = 0;                                 

trackshift = circshift(tracks(:,1),-1);
trackends = [0; find(tracks(:,1)-trackshift)]; % sum up progressively the number of time points from each track
L_tracks = [];

L=12; %define the minimum number of timepoint for analysis

for i=1:length(trackends)-1
    if trackends(i+1)-trackends(i)>=L
        L_tracks = [L_tracks; tracks(trackends(i)+1:trackends(i+1),:)]; % Tracks for analysis
    end
end

numberOfTracks = max(L_tracks(:,1));  % define the number of chromosomes for analysis
%cmap = colormap(jet(numberOfTracks));

pairwise_velocity = [];
initial_pairwisedistance = [];


for j = 1 : numberOfTracks
    
    clear trackx_ref tracky_ref trackz_ref Track_ref
    trackIndex = find(L_tracks(:,1) == j);  % find individual track 
    
        if (max(trackIndex) > 0) % if there are valid tracks in this table
            trackx_ref = pixelSize*L_tracks(trackIndex, 3);  
            tracky_ref = pixelSize*L_tracks(trackIndex, 4);
            trackz_ref = zstep*L_tracks(trackIndex, 5);                      
            Track_ref = [trackx_ref,tracky_ref,trackz_ref];
            
            for i = 1 : numberOfTracks
                
                clear trackx_calc tracky_calc trackz_calc Track_calc
                trackIndex2 = find(L_tracks(:,1) == i);
                
                    if (max(trackIndex2) > 0) % if there are valid tracks in this table
                        trackx_calc = pixelSize*L_tracks(trackIndex2, 3);  
                        tracky_calc = pixelSize*L_tracks(trackIndex2, 4);
                        trackz_calc = zstep*L_tracks(trackIndex2, 5);                      
                        Track_calc = [trackx_calc,tracky_calc,trackz_calc];
                        
                        if (size(Track_calc,1) == size(Track_ref,1))
                            time = [0,1:size(Track_calc,1)-1]*timestep;
                            pairdistance = sqrt((trackx_ref-trackx_calc).^2 + (tracky_ref-tracky_calc).^2 + (trackz_ref-trackz_calc).^2);      
                                Fit_pairdistance{j,2}=pairdistance; %save tje pairwise distance calculation used for fitting
                                Fit_pairdistance{j,1}=time;
                                %p=polyfit(time',pairdistance,1);
                                [p,s]=polyfit(time',pairdistance,1);
                                pairwise_velocity(j,i)=-p(1);
                                %initial_pairwisedistance(j,i) = pairdistance(1) ;
                                 initial_pairwisedistance(j,i) = mean(pairdistance) ;
                                goodness(j,i) = 1 - s.normr^2 / norm(pairdistance-mean(pairdistance))^2;
                                clear trackx_calc tracky_calc trackz_calc Track_ref2 Track_calc2 pairdistance;
                        end
    
                        if (size(Track_calc,1) > size(Track_ref,1))
                            Track_ref2 = nan(length(Track_calc),3); %need to expand the smaller vector - filling with NaN first
                            Track_ref2(1:length(Track_ref),:) = Track_ref; %Fill with values, blanks are filled with NaN
                            time = [0,1:size(Track_ref,1)-1]*timestep;
                            pairdistance = sqrt((Track_ref2(:,1)-trackx_calc).^2 + (Track_ref2(:,2)-tracky_calc).^2 + (Track_ref2(:,3)-trackz_calc).^2);
                            pairdistance(isnan(pairdistance(:,1)),:)=[]; % getting rid of NaN in the vector
                                Fit_pairdistance{j,2}=pairdistance; %save tje pairwise distance calculation used for fitting
                                Fit_pairdistance{j,1}=time;
                                %p=polyfit(time',pairdistance,1);
                                [p,s]=polyfit(time',pairdistance,1);
                                pairwise_velocity(j,i)=-p(1);
                                 %initial_pairwisedistance(j,i) = pairdistance(1) ;
                                 initial_pairwisedistance(j,i) = mean(pairdistance) ;
                                goodness(j,i) = 1 - s.normr^2 / norm(pairdistance-mean(pairdistance))^2;
                                
                                clear trackx_calc tracky_calc trackz_calc Track_ref2 Track_calc2 pairdistance;
                        end
                        
                        if (size(Track_ref,1) > size(Track_calc,1))
                            Track_calc2 = nan(length(Track_ref),3); %need to expand the smaller vector - filling with NaN first
                            Track_calc2(1:length(Track_calc),:) = Track_calc; %Fill with values, blanks are filled with NaN
                            time = [0,1:size(Track_calc,1)-1]*timestep;
                            pairdistance = sqrt((Track_calc2(:,1)-trackx_ref).^2 + (Track_calc2(:,2)-tracky_ref).^2 + (Track_calc2(:,3)-trackz_ref).^2);
                            pairdistance(isnan(pairdistance(:,1)),:)=[]; % getting rid of NaN in the vector
                                Fit_pairdistance{j,2}=pairdistance; %save the pairwise distance calculation used for fitting
                                Fit_pairdistance{j,1}=time;
                                %p=polyfit(time',pairdistance,1);
                                [p,s]=polyfit(time',pairdistance,1);
                                pairwise_velocity(j,i)=-p(1);
                                 %initial_pairwisedistance(j,i) = pairdistance(1) ;
                                 initial_pairwisedistance(j,i) = mean(pairdistance) ;
                                goodness(j,i) = 1 - s.normr^2 / norm(pairdistance-mean(pairdistance))^2;
                                
                                clear trackx_calc tracky_calc trackz_calc Track_ref2 Track_calc2 pairdistance;
                        end
                        end
                        end
                        end
end

pairwise_velocity = pairwise_velocity(pairwise_velocity~=0);
initial_pairwisedistance = initial_pairwisedistance(initial_pairwisedistance~=0);
goodness = goodness(goodness~=0);
goodness(isnan(goodness))=[];
results=[initial_pairwisedistance,pairwise_velocity,goodness]; %get rid of doublets which the function cat does not
%results=cat(2,initial_pairwisedistance,pairwise_velocity);
results=unique(results,'rows');

%Tracks used to extract the pairwise velocity



%Keep only the pairwise velocity defined by the goodness of the fit
for i=1:size(results,1)
    if results(i,3) > 0.9
        loop=loop+1;
        Plot_results(loop,:)=results(i,:);
    end
end

plot(Plot_results(:,1),Plot_results(:,2),'.');

save Fit_pairdistance;
save Plot_results;