#!/usr/bin/octave -q -f

%Developed by: Saeed Tavazoie and Peter Freddolino, Tavazoie lab, Columbia University
% https://tavazoielab.c2b2.columbia.edu/lab/
%
%Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal with the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
%
%    * Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimers.
%    * Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimers in the documentation and/or other materials provided with the distribution.
%    * Neither the names of the Tavazoie lab, Columbia University, nor the names of its contributors may be used to endorse or promote products derived from this Software without specific prior written permission.
%
%THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE CONTRIBUTORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS WITH THE SOFTWARE.


% this file runs a tuning simulation from a fixed set of initial conditions, specifying a target value for the first gene of 80, threshold value of 70, and
% initial value of 25 (as in Fig. 5 of the accompanying paper)

load Tuning_matlab_data_for_Peter.mat;
rand("state");
X0m=Xm;
X0m(1) = 25;
Xm(1)=80;
[X_out_test_2,F_test_2] = expression_optimize_distance_with_gene_thresh_firstonly(X0m,Xm,0.1,1000000,0.1,70);

printf("Final fitness: %f\n", -1*F_test_2(1000000));
printf("idx: %i\n",find(F_test_2<400,1,'first'));
printf("Final X01 value: %f\n", X_out_test_2(1,1000000));
printf("x0 idx: %i\n",find(X_out_test_2(1,:)>75,1,'first'));

printf("printing\n")
plot(-1 * X_out_test_2(1,:))
print

