function [X_out,F] = expression_optimize_distance_with_gene_thresh(X0,Xm,step_size,steps,noise_scale,tune_thresh)

%Developed by: Saeed Tavazoie and Peter Freddolino, Tavazoie lab, Columbia University
% https://tavazoielab.c2b2.columbia.edu/lab/
%
%Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal with the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
%
%    * Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimers.
%    * Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimers in the documentation and/or other materials provided with the distribution.
%    * Neither the names of the Tavazoie lab, Columbia University, nor the names of its contributors may be used to endorse or promote products derived from this Software without specific prior written permission.
%
%THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE CONTRIBUTORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS WITH THE SOFTWARE.

%
%
% This code implements a multi-dimensional expression optimization approach
% through single-gene hill-climbing.
% by Saeed Tavazoie, Feb. 25, 2010
%
% modified by ST to simplify on 7/16/2013

% X0 is the initial vector of expression values
% Xm is the optimal vector of expression values
% step_size  is the size of the change in expression during the optimization
% noise_scale is the size of random excursions (+ or -) during optimization
% initial values for the paper were (step_size = 0.1, noise_scale = 0.1)
% and(step_size = 0.5, noise_scale = 0.5).

% plf 7/26/16 -- added the tune_thresh parameter
% now cells can only move toward the optimum if their fitness is better tune_thresh
% otherwise they move randomly without the directed component
% note that tune_thresh is expressed as a distance, so we want the distance to be
% *below* tune_thresh before tuning kicks in. In this version, we enforce the distance separately for each gene



upper = 2000;
lower  = 0;

[dims,dummy] = size(X0);

upper_bound = ones(dims,1)*upper;
lower_bound = ones(dims,1)*lower;

X_out = zeros(dims,steps);
F = zeros(1,steps);

X_out(:,1) = X0+step_size.*(sign((rand(dims,1)-0.5))*noise_scale);   % noise  = 0.05  to test
X_out(:,2) = X_out(:,1)+ step_size.*(sign((rand(dims,1)-0.5))*noise_scale);  % noise  = 0.05  to test


X_out(:,1) = (X_out(:,1)>=lower_bound).*X_out(:,1);  % impose lower bound of zero.
X_out(:,1) = ((X_out(:,1)<=upper_bound).*X_out(:,1))+~(X_out(:,1)<=upper_bound).*upper_bound;  % impose upper bound


X_out(:,2) = (X_out(:,2)>=lower_bound).*X_out(:,2);  % impose lower bound of zero.
X_out(:,2) = ((X_out(:,2)<=upper_bound).*X_out(:,2))+~(X_out(:,2)<=upper_bound).*upper_bound;  % impose upper bound


% Euclidean distance:
F(1) = (sum((X0-Xm).^2))^0.5;
F(2) = ((sum((X_out(:,1)-Xm).^2))^0.5);


for t=3:steps
    
  
    F(1,t) = (sum((X_out(:,t-1)-Xm).^2))^0.5;
  
    delta_F_global = (F(1,t)-F(1,t-1));
 

    X_out(:,t) = X_out(:,t-1) +   (abs(X_out(:,t-1) - Xm) < tune_thresh) * sign(-delta_F_global)*step_size.*sign((X_out(:,t-1)-X_out(:,t-2))).*(ones(dims,1)) +(sign((rand(dims,1)-0.5))*noise_scale);
 
    
    X_out(:,t) = (X_out(:,t)>=lower_bound).*X_out(:,t);  % impose lower bound of zero.
    X_out(:,t) = ((X_out(:,t)<=upper_bound).*X_out(:,t))+~(X_out(:,t)<=upper_bound).*upper_bound;  % impose upper bound
    
    
end

%F(:,t);

%corr(Xm,X_out(:,steps))


