# Flow cytometry analysis tools

This directory contains a variety of tools for analyzing flow cytometry data related to stochastic tuning in yeast.

## Analysis of long tuning experiments including spike-in count beads

For our long-timescale flow cytometry experiments, it is necessary both to obtain counts of the cells at each timepoints (compared with spike-in beads), and to extract information on the fluorescence distribution of each population.

`common_tools_thermobeads.R` contains code for basic plotting of all .fcs files in a given directory, as well as extracting all data from those files into python-readable tables. All data in a particular directory can be analyzed with `process.datset(1)`. The resulting tables are used by the following plot/analysis scripts

`make_growth_plots.py` can then be used to plot the numbers of cells at various timepoints, along with the corresponding average fluorescence of the popultations at each timepoint. This program is reliant upon proper specifications of file names and timepoints, following the comments in the first few lines of the file. The cell count plotting is used, for example, in Fig. 4A of the accompanying paper. 

`make_comp_hists_cdf.py` is used to generate cumulative histograms comparing the distribution of fluorescence observed in a specified timepoint, compared with a reference distribution (the latter typically arising from exponential growth in rich media). These distributions are plotted in Fig. 4B and similar panels of the accompanying paper

## Prerequisites

The R code for extraction and visualization of flow cytometry data requires the flowCore and flowViz R packages 

The python programs require an installation of numpy/scipy and matplotlib. In addition, they make use of lightweight modules for R-like data tables and for bootstrap simulations, which are provided in the lib/ subdirectory.
