# common set of functions for analyzing the facs runs in this directory
require('flowCore')
library(flowViz)
require('flowViz')
library(flowViz)
library(mclust)

#Developed by: Peter Freddolino, Tavazoie lab, Columbia University
# https://tavazoielab.c2b2.columbia.edu/lab/
#
#Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal with the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
#
#    * Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimers.
#    * Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimers in the documentation and/or other materials provided with the distribution.
#    * Neither the names of the Tavazoie lab, Columbia University, nor the names of its contributors may be used to endorse or promote products derived from this Software without specific prior written permission.
#
#THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE CONTRIBUTORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS WITH THE SOFTWARE.


plotcols=list( "black","red","blue","green","orange","cyan","magenta","black","red","blue","green","orange")

process.datset = function(dummy) {
  # read, process, and return data from a timepoint
  dat <- read.flowSet(files = list.files('./', pattern = "fcs", full = T))

  bead.fsc.ssc.gate <- rectangleGate(filterId="beadsize", list("FSC-A"=c(100,300),"SSC-A"=c(600,1000)))
  bead.fluor.gate <- rectangleGate(filterId="beadfluor", list('PE-Texas Red-A'=c(8000,Inf), 'FITC-A'=c(2000,Inf)))
  is.bead.filter = bead.fsc.ssc.gate %&% bead.fluor.gate
  identifier(is.bead.filter) = 'bead.flag'
  
  splitset = split(dat,is.bead.filter)
  beads = splitset['bead.flag+']$`bead.flag+`
  notbeads = splitset['bead.flag-']$`bead.flag-`

  # gate out cell debris
  rectGate <- rectangleGate(filterId = "FSC+", "FSC-A" = c(50,800))
  rectGateY <- rectangleGate(filterId = "SSC+", "SSC-A" = c(0,800))
  rectGateF <- rectangleGate(filterId = "cellfluor", list("FITC-A" = c(0,8000), "PE-Texas Red-A"=c(0,8000) ))
  cellgate = rectGate %&% rectGateY %&% rectGateF
  cells = Subset(notbeads,cellgate)

  # set up a logicle transformation
  #tr.gfp <- estimateLogicle(flowFrame(fsApply(cells, function(x) exprs(x))),'FITC-A')
  #tr.mruby <- estimateLogicle(flowFrame(fsApply(cells, function(x) exprs(x))),'PE-Texas Red-A')
  cells.tr <- cells[seq(along=cells)]
  for (samplename in sampleNames(cells.tr)) {
    tr.gfp <- estimateLogicle(cells.tr[[samplename]], channels=c("FITC-A","PE-Texas Red-A"))
    cells.tr[[samplename]] <- transform(cells.tr[[samplename]], tr.gfp)
  }

  count.all.samples(cells,beads)
  write.dattabs(cells)
  plot.all.t1(cells)

  return(list(cells=cells,cells.tr=cells.tr,beads=beads))
}

write.dattabs <- function(cells) {
  # write python-friendly data tables for each set of cell types
  
  for (sampname in sampleNames(cells)) {

    newdat=data.frame(fsc=exprs(cells[[sampname]])[,'FSC-A'],ssc=exprs(cells[[sampname]])[,'SSC-A'],gfp=exprs(cells[[sampname]])[,'FITC-A'],mruby=exprs(cells[[sampname]])[,'PE-Texas Red-A'])
    newdat$gfp[1] = newdat$gfp[1] - 0.000000001
    newdat$mruby[1] = newdat$mruby[1] - 0.000000001
    write.csv(newdat,file=paste(sampname, '_data.txt',sep=""),quote=FALSE)
  }

}


count.all.samples <- function(cells,beads) {
  # for each sample name, print a count of the cells and beads in it
  sink('cellcounts.txt')
  for (sampname in sampleNames(cells)) {
    ncells=length(exprs(cells[[sampname]])[,'FSC-A'])
    nbeads=length(exprs(beads[[sampname]])[,'FSC-A'])
    cat("Sample: ", sampname, "  Cells: ", ncells, "  Beads: ", nbeads, "\n")
  }
  sink()
}

plot.all.t1 = function(cells) {
  # for each sample name, make some basic plots

  png("fsc_vs_ssc.png")
  loopi=1
  for (sampname in sampleNames(cells)) {
    cat("loopi is", loopi)
    if (loopi == 1) {
    cat("Starting plot")
    contour(cells[[sampname]], c(1,2),xlim=c(0,500), ylim=c(0,300))
    } else {
      cat("plot color is", plotcols[[loopi]])
    contour(cells[[sampname]], c(1,2), add=TRUE, col=plotcols[[loopi]])
    }
    loopi = loopi+1
  }
  dev.off()

  png("fsc_vs_gfp.png")
  loopi=1
  for (sampname in sampleNames(cells)) {
    cat("loopi is", loopi)
    if (loopi == 1) {
    cat("Starting plot")
    contour(cells[[sampname]], c(1,3),xlim=c(0,500), ylim=c(0,300))
    } else {
      cat("plot color is", plotcols[[loopi]])
    contour(cells[[sampname]], c(1,3), add=TRUE, col=plotcols[[loopi]])
    }
    loopi = loopi+1
  }
  dev.off()

  png("fsc_vs_mruby.png")
  loopi=1
  for (sampname in sampleNames(cells)) {
    cat("loopi is", loopi)
    if (loopi == 1) {
    cat("Starting plot")
    contour(cells[[sampname]], c(1,4),xlim=c(0,500), ylim=c(0,300))
    } else {
      cat("plot color is", plotcols[[loopi]])
    contour(cells[[sampname]], c(1,4), add=TRUE, col=plotcols[[loopi]])
    }
    loopi = loopi+1
  }
  dev.off()

}

