function histo=Plot_PSTH(spikes,artefacts,fen,bin,smooth)
%fen=0.2
% fen=.2;                     % fen/2etre, en s, autour du stimulus
 %bin=.002;                    % pas de temps de l'histogramme, en s
% smooth=0;                 % pas du lissage (largeur du kernel Ka, gaussien)

LL=1.5*fen/bin+1; histo=zeros(LL,1);    %LL: longueur du vecteur histo (PSTH), et dfinition d'un vecteur histo vide (avec des zros)
Nb_trials=length(artefacts);            % Nombre d'essais (longueur du vecteur artefacts)

% Calcul du PSTH et figure du raster
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
figure,                               % Ouvre une figure et positionne les axes
axes('position', [0.1,0.1, 0.8,0.6]);
hold on
counter=3;

for k=1:Nb_trials                                % Boucle sur le nombre de stimulations
    A=spikes(find(spikes>artefacts(k)-fen/2 & spikes<artefacts(k)+fen))-artefacts(k)+fen/2;      % selection de la partie du train de spike autour de la stimulation
    B=fen/2+spikes(find(spikes>artefacts(k)-0.7*fen & spikes<artefacts(k)+1.2*fen))-artefacts(k);
    if smooth>0
        for ind=1:LL                                              % calcul de la frequence moyenne sur un essai, lisse avec le 
            tps=(ind-1)*bin;
            Ka=exp(-power(tps-B,2)/(2*smooth^2))/(smooth*sqrt(2*pi));       % kernel estimator (Silverman, 86)
            freq(k,ind)=sum(Ka);
        end
    else
        for ks=1:length(A)
            histo(1+floor(A(ks)/bin))=histo(1+floor(A(ks)/bin))+1;                      % On ajoute 1 dans le PSTH  chaque spike prsent
        end
    end
    if length(A)>0
        plot([1;1]*(A-fen/2)', [counter-3 counter],'k')          %raster: un trait pour chaque spike
    end
    counter=counter+3;
end
axis([-fen/2 fen 0 counter])            % ajuster les axes des X et Y
xlabel('Time from stimulation (ms)')
ylabel('Trial number')

if smooth>0                                                 % calcul de la frequence moyenne sur tous les essais 
    histo=mean(freq);
else
    histo=histo/(bin*Nb_trials);
end
    
moybase=mean(histo(1:floor(LL/3-5)));                       % Moyenne de base et interval de confiance
deviation=std(histo(1:floor(LL/3-5)))
maxi=moybase+2.5*deviation;
mini=moybase-2.5*deviation;

%Figure
%%%%%%%%%%
temps=-fen/2:bin:fen;                                       % Vecteur de temps pour la figure
histo=histo(1:LL-1); temps=temps(1:LL-1);
axes('position', [0.1,0.7, 0.8,0.25]);                      % Position de la figure de l'histogramme
bar(temps,histo,1,'k')                                      % Figure de l'histogramme

ymax=(floor(max(histo)/10)+1)*10; ymin=10*floor(min(histo)/10);
axis([-fen/2 fen ymin ymax])                                % ajuster les axes des X et Y
ylabel('Firing rate (sp/s)')                                % Lgende de l'axe Y
set(gca,'XTickLabel',[])                                    % Supression de la lgende pour X

hold on;
plot([-fen/2 fen],[moybase moybase],'k');                   %Plot confidence limits
plot([-fen/2 fen],[maxi maxi],'r');
plot([-fen/2 fen],[mini mini],'r');
plot([0 0],[0 ymax],'k');                                   % Plot stimulation time (vertical line)


% % % 
% % %
% % figure,
% % bar(histo,'EdgeColor','r')
% % % % size(histo) %,'Linewidth',3,)                          % Figure "en barres"
% temps=-fen/2:bin:fen; 
% LL=1.5*fen/bin+1;
% temps=temps(1:LL-1)% Vecteur de temps pour la figure
% X=[temps,fliplr(temps)]           %#create continuous x value array for plotting
% histo_min=(histo-(2.5*deviation))
% histo_max=(histo+(2.5*deviation))
% % 
% Y=[histo_min',fliplr(histo_max')]              %#create y values for out and then back
% figure, fill(X,Y,'k','FaceAlpha', 0.4);                  %#plot filled area
% % % 
% axis([-fen/2 fen 0 inf])            % ajuster les axes des X et Y
%  hold on;
%  plot(temps,histo,'k')
% % plot([-fen/2 fen],[moybase moybase],'k');         %Confidence limits
% % plot([-fen/2 fen],[maxi maxi],'r');
% % plot([-fen/2 fen],[mini mini],'r');
% % ymax=max(histo);
% % plot([0 0],[0 ymax],'k');
