clear
CondName={'pre'; 'early post'; 'crist'};
SongsOrNot='Songs_'; %''; %
cd('E:\Ludivine\Lesion Chants\Ludivine Lesion and Control Data - tris\')

% GoodFamilies=[1 2 3 5 6 7];
GoodFamilies=[1:7];
for i=1:length(GoodFamilies)
    cd(['Family ' num2str(GoodFamilies(i))])
    for cond=1:3
        load(['SpectralSimSimilarity_' SongsOrNot CondName{cond}])
        MeanSimilarity(i,cond)=mean(mean(AllSimilarity));
    end
    cd('..')
end

AutresLeses={'10.6'; '11.5'; '12.7'};

for i=1:length(AutresLeses)
    cd(['autres leses\' AutresLeses{i}])
    for cond=1:3
        load(['SpectralSimSimilarity_' SongsOrNot CondName{cond}])
        MeanSimilarity(i+length(GoodFamilies),cond)=mean(mean(AllSimilarity));
    end
    cd('..\..')
end

ContFamily=[3 5];
for i=1:length(ContFamily)
    cd(['Family ' num2str(ContFamily(i))])
    for cond=1:3
        load(['SpectralSimSimilarity_Cont_' SongsOrNot CondName{cond}])
        MeanSimilarityCont(i,cond)=mean(mean(AllSimilarity));
    end
    cd('..')
end

ContCristFamily=[1 2 4];
for i=1:length(ContCristFamily)
    cond=3; cd(['Family ' num2str(ContCristFamily(i))])
    load(['SpectralSimSimilarity_Cont_' SongsOrNot CondName{cond}])
    MeanSimilarityContCrist(i)=mean(mean(AllSimilarity));
    cd('..')
end

Shams={'1.51'; '2.53'; '4.40'; '4.41'; '4.42'; '5.55'};
cd('Shams')
for i=1:length(Shams)
    cd([Shams{i}])
    for cond=1:3
        load(['SpectralSimSimilarity_Cont_' SongsOrNot CondName{cond}])
        MeanSimilarityShams(i,cond)=mean(mean(AllSimilarity));
    end
    cd('..')
end
cd('..')
Nlese=size(MeanSimilarity,1); Nsham=size(MeanSimilarityShams,1);

figure
plot(MeanSimilarity','r')
hold on
plot(MeanSimilarityCont','k')
plot(MeanSimilarityShams','b')
plot([3 3 3], MeanSimilarityContCrist, 'ok')

figure
errorbar([mean(MeanSimilarity(:,1)) mean(MeanSimilarity(:,3))],[std(MeanSimilarity(:,1))/sqrt(Nlese) std(MeanSimilarity(:,3))/sqrt(Nlese)],'r')
hold on
errorbar([mean(MeanSimilarityShams(:,1)) mean(MeanSimilarityShams(:,3))],[std(MeanSimilarityShams(:,1))/sqrt(Nsham) std(MeanSimilarityShams(:,3))/sqrt(Nsham)],'k')
plot(ones(1,Nlese),MeanSimilarity(:,1),'or')
plot(2*ones(1,Nlese),MeanSimilarity(:,3),'or')
plot([1 2],[MeanSimilarity(:,1) MeanSimilarity(:,3)], ':r')
plot(ones(1,Nsham),MeanSimilarityShams(:,1),'ok')
plot(2*ones(1,Nsham),MeanSimilarityShams(:,3),'ok')
plot([1 2],[MeanSimilarityShams(:,1) MeanSimilarityShams(:,3)], ':k')

% [p,h,stats]=signrank(MeanSimilarity(:,3)',[MeanSimilarityCont(:,3)' MeanSimilarityContCrist])
[p,h,stats]=ranksum(MeanSimilarity(:,3)',[MeanSimilarityCont(:,3)' MeanSimilarityContCrist MeanSimilarityShams(:,3)'])

% 
base=1;
for i=1:length(GoodFamilies)+length(AutresLeses)
    MeanSimilarityNorm(i,:)=MeanSimilarity(i,:)./MeanSimilarity(i,base);
end
for i=1:length(ContFamily)
    MeanSimilarityContNorm(i,:)=MeanSimilarityCont(i,:)./MeanSimilarityCont(i,base);
end
for i=1:length(Shams)
    MeanSimilarityShamsNorm(i,:)=MeanSimilarityShams(i,:)./MeanSimilarityShams(i,base);
end

[p,h,stats]=ranksum(MeanSimilarityNorm(:,3)',[MeanSimilarityContNorm(:,3)' MeanSimilarityShamsNorm(:,3)'])

figure
plot(MeanSimilarityNorm','r')
hold on
plot(MeanSimilarityContNorm','k')
plot(MeanSimilarityShamsNorm','b')

figure
errorbar([mean(MeanSimilarityNorm(:,1)) mean(MeanSimilarityNorm(:,3))],[std(MeanSimilarityNorm(:,1))/sqrt(Nlese) std(MeanSimilarityNorm(:,3))/sqrt(Nlese)],'r')
hold on
errorbar([mean(MeanSimilarityShamsNorm(:,1)) mean(MeanSimilarityShamsNorm(:,3))],[std(MeanSimilarityShamsNorm(:,1))/sqrt(Nsham) std(MeanSimilarityShamsNorm(:,3))/sqrt(Nsham)],'k')
plot(ones(1,Nlese),MeanSimilarityNorm(:,1),'or')
plot(2*ones(1,Nlese),MeanSimilarityNorm(:,3),'or')
plot([1 2],[MeanSimilarityNorm(:,1) MeanSimilarityNorm(:,3)], ':r')
plot(ones(1,Nsham),MeanSimilarityShamsNorm(:,1),'ok')
plot(2*ones(1,Nsham),MeanSimilarityShamsNorm(:,3),'ok')
plot([1 2],[MeanSimilarityShamsNorm(:,1) MeanSimilarityShamsNorm(:,3)], ':k')


load('LesionSize.mat')
figure, plot(TotalSize,MeanSimilarityNorm(:,3),'ro')
hold on
plot(100*ones(1,length(Shams)),MeanSimilarityShamsNorm(:,3),'ko')
% plot(100*ones(1,length(ContFamily)),MeanSimilarityContNorm(:,3),'ko')

[r,p]=corrcoef(TotalSize,MeanSimilarityNorm(:,3))
[r,p]=corrcoef([TotalSize 100 100 100 100 100 100],[MeanSimilarityNorm(:,3)' MeanSimilarityShamsNorm(:,3)'])

[p,h,stats]=ranksum(MeanSimilarity(:,1),MeanSimilarity(:,3))
[p,h,stats]=ranksum(MeanSimilarityShams(:,1),MeanSimilarityShams(:,3))
% [h,p]=ttest2(MeanSimilarityShams(:,1),MeanSimilarityShams(:,3))
