%-----------------------------------------------------------------------
% Job saved on 03-May-2016 11:50:56 by cfg_util (rev $Rev: 6460 $)
% spm SPM - SPM12 (6470)
% cfg_basicio BasicIO - Unknown
%-----------------------------------------------------------------------
%% general variables
clear all

addpath R:\ROOP\ONWAR_SOFTWARES\Windows\spm12
%pre_basepath = 'R:\ROOP\ROOP_fMRI\Subject_';
Session = {'Real', 'Sham'};
Task = {'own_MECH_1' ,'own_MECH_2', 'own_SHOCK_1', 'own_SHOCK_2'};
%sbjnum=[2 3 4 9 10 16 17 18 19 20 21 22 23 24 26 27 28 29 31 33 34 35 36 37 38];

%% 
for Subject_i=[2 3 4 9 10 16 17 18 19 20 21 22 23 24 26 27 28 29 31 33 34 35 36 37 38];
    disp(Subject_i)
%% SLICE TIMING

%[1 2 3 4 5 6 9 10 12 16 17 18 19 20 21 22 23 24 25 26 27 28 29 31 33 34 35 36 37 38]
    spm_jobman('initCfg');
    
    basepath = ['R:\ROOP\ROOP_fMRI\Subject_' num2str(Subject_i) '_p1'];
    for k=[1 2] %session
        
        %display(k)
            for j = 1:size(Task,2);
            %display(j)
            disp(['Doing slice time correction for subject # ' num2str(Subject_i)]);
            task_location = sprintf('%s%s%s%s',basepath,filesep,char(Session(:,k)),filesep,char(Task(:,j)))
            scans = spm_select('FPList',fullfile(task_location), '.nii');%%
            
                matlabbatch = cell(1,1);
                matlabbatch{1}.spm.temporal.st.scans{1} = cellstr(scans);           
                matlabbatch{1}.spm.temporal.st.nslices = 32;
                matlabbatch{1}.spm.temporal.st.tr = 1.7;
                matlabbatch{1}.spm.temporal.st.ta = 1.646875;
                matlabbatch{1}.spm.temporal.st.so = [1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32];
                matlabbatch{1}.spm.temporal.st.refslice = 17;
                matlabbatch{1}.spm.temporal.st.prefix = 'a';
                
spm_jobman('run',matlabbatch);
            end% task
    end % sessions


%% REALIGMENT - estimate and reslice

% it writes the mean image in the folder of the fist task selected:
%Real - OTH 1

 disp(['Realign (estimate and reslice) for subject # ' num2str(Subject_i)]);
 
 spm_jobman('initCfg');
 
 basepath = ['R:\ROOP\ROOP_fMRI\Subject_' num2str(Subject_i) '_p1'];
 
                        task_location_R_MECH_1 = sprintf('%s%s%s%s',basepath,filesep,char(Session(:,1)),filesep,char(Task(:,3)))
            task_location_R_MECH_2 = sprintf('%s%s%s%s',basepath,filesep,char(Session(:,1)),filesep,char(Task(:,4)))
            task_location_R_SHOCK_1 = sprintf('%s%s%s%s',basepath,filesep,char(Session(:,1)),filesep,char(Task(:,5)))
            task_location_R_SHOCK_2 = sprintf('%s%s%s%s',basepath,filesep,char(Session(:,1)),filesep,char(Task(:,6)))
            
                        task_location_S_MECH_1 = sprintf('%s%s%s%s',basepath,filesep,char(Session(:,2)),filesep,char(Task(:,3)))
            task_location_S_MECH_2 = sprintf('%s%s%s%s',basepath,filesep,char(Session(:,2)),filesep,char(Task(:,4)))
            task_location_S_SHOCK_1 = sprintf('%s%s%s%s',basepath,filesep,char(Session(:,2)),filesep,char(Task(:,5)))
            task_location_S_SHOCK_2 = sprintf('%s%s%s%s',basepath,filesep,char(Session(:,2)),filesep,char(Task(:,6)))
           
            % Select scans with prefix "a" / time-sliced ones
            scan_R_MECH_1 = spm_select('FPList',fullfile(task_location_R_MECH_1),['^a*']); 
            scan_R_MECH_2 = spm_select('FPList',fullfile(task_location_R_MECH_2),['^a*']); 
            scan_R_SHOCK_1 = spm_select('FPList',fullfile(task_location_R_SHOCK_1),['^a*']); 
            scan_R_SHOCK_2 = spm_select('FPList',fullfile(task_location_R_SHOCK_2),['^a*']);
          
            scan_S_MECH_1 = spm_select('FPList',fullfile(task_location_S_MECH_1),['^a*']); 
            scan_S_MECH_2 = spm_select('FPList',fullfile(task_location_S_MECH_2),['^a*']); 
            scan_S_SHOCK_1 = spm_select('FPList',fullfile(task_location_S_SHOCK_1),['^a*']); 
            scan_S_SHOCK_2 = spm_select('FPList',fullfile(task_location_S_SHOCK_2),['^a*']);
            
%            
scans_all =    {cellstr(scan_R_MECH_1);...
                cellstr(scan_R_MECH_2); cellstr(scan_R_SHOCK_1); cellstr(scan_R_SHOCK_2);...
                cellstr(scan_S_MECH_1);...
                cellstr(scan_S_MECH_2); cellstr(scan_S_SHOCK_1); cellstr(scan_S_SHOCK_2)}';
            
            matlabbatch = cell(1,1);
            
            matlabbatch{1}.spm.spatial.realign.estwrite.data = scans_all;       
                
            matlabbatch{1}.spm.spatial.realign.estwrite.eoptions.quality = 0.9;
            matlabbatch{1}.spm.spatial.realign.estwrite.eoptions.sep = 4;
            matlabbatch{1}.spm.spatial.realign.estwrite.eoptions.fwhm = 5;
            matlabbatch{1}.spm.spatial.realign.estwrite.eoptions.rtm = 1;
            matlabbatch{1}.spm.spatial.realign.estwrite.eoptions.interp = 2;
            matlabbatch{1}.spm.spatial.realign.estwrite.eoptions.wrap = [0 0 0];
            matlabbatch{1}.spm.spatial.realign.estwrite.eoptions.weight = '';
            matlabbatch{1}.spm.spatial.realign.estwrite.roptions.which = [0 1];
            matlabbatch{1}.spm.spatial.realign.estwrite.roptions.interp = 4;
            matlabbatch{1}.spm.spatial.realign.estwrite.roptions.wrap = [0 0 0];
            matlabbatch{1}.spm.spatial.realign.estwrite.roptions.mask = 1;
            matlabbatch{1}.spm.spatial.realign.estwrite.roptions.prefix = 'r';
    
spm_jobman('run',matlabbatch);   

%% T1 REALIGMENT

 disp(['Realign (estimate and reslice) T1 for subject # ' num2str(Subject_i)]);
 spm_jobman('initCfg');
 
 basepath = ['R:\ROOP\ROOP_fMRI\Subject_' num2str(Subject_i) '_p1'];
 
            anatomy_location = sprintf('%s%s',basepath,filesep,'Anatomy')
            scans = spm_select('FPList',fullfile(anatomy_location));

             matlabbatch = cell(1,1);
matlabbatch{1}.spm.spatial.realign.estwrite.data = {cellstr(scans(1,:)) cellstr(scans(2,:))}' ;
matlabbatch{1}.spm.spatial.realign.estwrite.eoptions.quality = 0.9;
matlabbatch{1}.spm.spatial.realign.estwrite.eoptions.sep = 4;
matlabbatch{1}.spm.spatial.realign.estwrite.eoptions.fwhm = 5;
matlabbatch{1}.spm.spatial.realign.estwrite.eoptions.rtm = 1;
matlabbatch{1}.spm.spatial.realign.estwrite.eoptions.interp = 2;
matlabbatch{1}.spm.spatial.realign.estwrite.eoptions.wrap = [0 0 0];
matlabbatch{1}.spm.spatial.realign.estwrite.eoptions.weight = '';
matlabbatch{1}.spm.spatial.realign.estwrite.roptions.which = [0 1];
matlabbatch{1}.spm.spatial.realign.estwrite.roptions.interp = 4;
matlabbatch{1}.spm.spatial.realign.estwrite.roptions.wrap = [0 0 0];
matlabbatch{1}.spm.spatial.realign.estwrite.roptions.mask = 1;
matlabbatch{1}.spm.spatial.realign.estwrite.roptions.prefix = 'r';

spm_jobman('run',matlabbatch);


%% COREGISTRATION MEAN-T1 (source) AND MEAN EPI (reference)

 disp(['Realign (estimate and reslice) T1 for subject # ' num2str(Subject_i)]);
 spm_jobman('initCfg');
 
 basepath = ['R:\ROOP\ROOP_fMRI\Subject_' num2str(Subject_i) '_p1'];
 
            source_location = sprintf('%s%s',basepath,filesep,'Anatomy');
            source_scans = spm_select('FPList',fullfile(source_location),['^mean*'])
            
            ref_location= sprintf('%s%s',basepath,filesep,'Real\OTH_1');
            ref_scans = spm_select('FPList',fullfile(ref_location),['^mean*'])
matlabbatch = cell(1,1);
matlabbatch{1}.spm.spatial.coreg.estimate.ref = {ref_scans};
matlabbatch{1}.spm.spatial.coreg.estimate.source = {source_scans};
matlabbatch{1}.spm.spatial.coreg.estimate.other = {''};
matlabbatch{1}.spm.spatial.coreg.estimate.eoptions.cost_fun = 'nmi';
matlabbatch{1}.spm.spatial.coreg.estimate.eoptions.sep = [4 2];
matlabbatch{1}.spm.spatial.coreg.estimate.eoptions.tol = [0.02 0.02 0.02 0.001 0.001 0.001 0.01 0.01 0.01 0.001 0.001 0.001];
matlabbatch{1}.spm.spatial.coreg.estimate.eoptions.fwhm = [7 7];


spm_jobman('run',matlabbatch);


%% SEGMENTATION OF MEAN-T1
 disp(['Segment mean-T1 for subject # ' num2str(Subject_i)]);
 spm_jobman('initCfg');
 
 basepath = ['R:\ROOP\ROOP_fMRI\Subject_' num2str(Subject_i) '_p1'];
 
            source_location = sprintf('%s%s',basepath,filesep,'Anatomy');
            source_scans = spm_select('FPList',fullfile(source_location),['^mean*'])
matlabbatch = cell(1,1);
matlabbatch{1}.spm.spatial.preproc.channel.vols = {source_scans};
matlabbatch{1}.spm.spatial.preproc.channel.biasreg = 0.001;
matlabbatch{1}.spm.spatial.preproc.channel.biasfwhm = 60;
matlabbatch{1}.spm.spatial.preproc.channel.write = [0 0];
matlabbatch{1}.spm.spatial.preproc.tissue(1).tpm = {'R:\ROOP\ONWAR_SOFTWARES\Windows\spm12\tpm\TPM.nii,1'};
matlabbatch{1}.spm.spatial.preproc.tissue(1).ngaus = 1;
matlabbatch{1}.spm.spatial.preproc.tissue(1).native = [1 0];
matlabbatch{1}.spm.spatial.preproc.tissue(1).warped = [0 0];
matlabbatch{1}.spm.spatial.preproc.tissue(2).tpm = {'R:\ROOP\ONWAR_SOFTWARES\Windows\spm12\tpm\TPM.nii,2'};
matlabbatch{1}.spm.spatial.preproc.tissue(2).ngaus = 1;
matlabbatch{1}.spm.spatial.preproc.tissue(2).native = [1 0];
matlabbatch{1}.spm.spatial.preproc.tissue(2).warped = [0 0];
matlabbatch{1}.spm.spatial.preproc.tissue(3).tpm = {'R:\ROOP\ONWAR_SOFTWARES\Windows\spm12\tpm\TPM.nii,3'};
matlabbatch{1}.spm.spatial.preproc.tissue(3).ngaus = 2;
matlabbatch{1}.spm.spatial.preproc.tissue(3).native = [1 0];
matlabbatch{1}.spm.spatial.preproc.tissue(3).warped = [0 0];
matlabbatch{1}.spm.spatial.preproc.tissue(4).tpm = {'R:\ROOP\ONWAR_SOFTWARES\Windows\spm12\tpm\TPM.nii,4'};
matlabbatch{1}.spm.spatial.preproc.tissue(4).ngaus = 3;
matlabbatch{1}.spm.spatial.preproc.tissue(4).native = [1 0];
matlabbatch{1}.spm.spatial.preproc.tissue(4).warped = [0 0];
matlabbatch{1}.spm.spatial.preproc.tissue(5).tpm = {'R:\ROOP\ONWAR_SOFTWARES\Windows\spm12\tpm\TPM.nii,5'};
matlabbatch{1}.spm.spatial.preproc.tissue(5).ngaus = 4;
matlabbatch{1}.spm.spatial.preproc.tissue(5).native = [1 0];
matlabbatch{1}.spm.spatial.preproc.tissue(5).warped = [0 0];
matlabbatch{1}.spm.spatial.preproc.tissue(6).tpm = {'R:\ROOP\ONWAR_SOFTWARES\Windows\spm12\tpm\TPM.nii,6'};
matlabbatch{1}.spm.spatial.preproc.tissue(6).ngaus = 2;
matlabbatch{1}.spm.spatial.preproc.tissue(6).native = [0 0];
matlabbatch{1}.spm.spatial.preproc.tissue(6).warped = [0 0];
matlabbatch{1}.spm.spatial.preproc.warp.mrf = 1;
matlabbatch{1}.spm.spatial.preproc.warp.cleanup = 1;
matlabbatch{1}.spm.spatial.preproc.warp.reg = [0 0.001 0.5 0.05 0.2];
matlabbatch{1}.spm.spatial.preproc.warp.affreg = 'mni';
matlabbatch{1}.spm.spatial.preproc.warp.fwhm = 0;
matlabbatch{1}.spm.spatial.preproc.warp.samp = 3;
matlabbatch{1}.spm.spatial.preproc.warp.write = [0 1];


spm_jobman('run',matlabbatch);
 

%% NORMALIZATION EPI using parameter calculated by mean-T1 segmentation

 disp(['NORMALIZATION EPI for subject # ' num2str(Subject_i)]);
 spm_jobman('initCfg');
 
 basepath = ['R:\ROOP\ROOP_fMRI\Subject_' num2str(Subject_i) '_p1'];
 % select deformation field created during segmentation mean-T1
            anatomy_location = sprintf('%s%s',basepath,filesep,'Anatomy')
            def_field= spm_select('FPList',fullfile(anatomy_location),['^y*']);
 
 for k=1:size(Session,2)
        for j = 1:size(Task,2)
             
             task_location = sprintf('%s%s%s%s',basepath,filesep,char(Session(:,k)),filesep,char(Task(:,j)))
             %disp(['Smooth for subject # ' num2str(Subject_i)]);
             %task_location = sprintf('%s%d%s%s%s',basepath,Subject_i,filesep,char(Session(:,k)),filesep,char(Task(:,j)))
             % select normalized scans with prefix "w"
             scans = spm_select('FPList',fullfile(task_location),['^a*']);
             if isempty(scans)
                continue
             else 
              
matlabbatch = cell(1,1);  
matlabbatch{1}.spm.spatial.normalise.write.subj.def = cellstr(def_field);
matlabbatch{1}.spm.spatial.normalise.write.subj.resample = cellstr(scans);
matlabbatch{1}.spm.spatial.normalise.write.woptions.bb = [-90 -126 -72
                                                          90 90 108];
matlabbatch{1}.spm.spatial.normalise.write.woptions.vox = [2 2 2];
matlabbatch{1}.spm.spatial.normalise.write.woptions.interp = 4;


spm_jobman('run',matlabbatch);
 clear scans
             end
        end
 end


%% NORMALIZATION MEAN-T1  AND GRAY MATTER SEG

 disp(['NORMALIZATION MEAN-T1  AND GRAY MATTER SEG for subject # ' num2str(Subject_i)]);
 spm_jobman('initCfg');
 
 basepath = ['R:\ROOP\ROOP_fMRI\Subject_' num2str(Subject_i) '_p1'];
 
            anatomy_location = sprintf('%s%s',basepath,filesep,'Anatomy');
            meanT1 = spm_select('FPList',fullfile(anatomy_location),['^mean*'] , '.nii')
            GM = spm_select('FPList',fullfile(anatomy_location),['^c1mean*'])
            def_field= spm_select('FPList',fullfile(anatomy_location),['^y*'])
            data=[cellstr(meanT1); cellstr(GM)];
            
matlabbatch = cell(1,1);
matlabbatch{1}.spm.spatial.normalise.write.subj.def = {def_field};
matlabbatch{1}.spm.spatial.normalise.write.subj.resample = cellstr(data);
matlabbatch{1}.spm.spatial.normalise.write.woptions.bb = [-90 -126 -72
                                                          90 90 108];
matlabbatch{1}.spm.spatial.normalise.write.woptions.vox = [1 1 1];
matlabbatch{1}.spm.spatial.normalise.write.woptions.interp = 4;

spm_jobman('run',matlabbatch);            


%% SHOOTING EPI (6mm)
         
    
     for k=1:size(Session,2)
        for j = 1:size(Task,2)
             basepath = ['R:\ROOP\ROOP_fMRI\Subject_' num2str(Subject_i) '_p1'];
             task_location = sprintf('%s%s%s%s',basepath,filesep,char(Session(:,k)),filesep,char(Task(:,j)))
             disp(['Smooth for subject # ' num2str(Subject_i)]);
             %task_location = sprintf('%s%d%s%s%s',basepath,Subject_i,filesep,char(Session(:,k)),filesep,char(Task(:,j)))
             % select normalized scans with prefix "w"
             scans = spm_select('FPList',fullfile(task_location),['^w*']);
             if isempty(scans)
                continue
             else 
                matlabbatch = cell(1,1);
                matlabbatch{1}.spm.spatial.smooth.data = cellstr(scans);
                matlabbatch{1}.spm.spatial.smooth.fwhm = [6 6 6];
                matlabbatch{1}.spm.spatial.smooth.dtype = 0;
                matlabbatch{1}.spm.spatial.smooth.im = 0;
                matlabbatch{1}.spm.spatial.smooth.prefix = 's';
                
                spm_jobman('run',matlabbatch);
                clear scans
             end
           
        end
    end

%% GLM OWN PAIN
basepath_Regr_Shock = 'R:\ROOP\ROOP_fMRI\XLS\SHOCK\regressors4GLM\';
basepath_Regr_Mech = 'R:\ROOP\ROOP_fMRI\XLS\MECH\regressors4GLM\';
Task_GLM = {'own_SHOCK_1', 'own_SHOCK_2', 'OWN_MECH_1', 'OWN_MECH_2' };   

 basepath = ['R:\ROOP\ROOP_fMRI\Subject_' num2str(Subject_i) '_p1'];
        % directory to save SPM design matrix 
        mkdir([basepath '\Results_Subj_level\ResultsSELF\QuestMarkAndExtraPress'])
        
        matlabbatch = cell(1,1);

        matlabbatch{1}.spm.stats.fmri_spec.dir = {sprintf('%s%sResults_Subj_level%sResultsSELF%sQuestMarkAndExtraPress',basepath,filesep, filesep, filesep)};
        
        matlabbatch{1}.spm.stats.fmri_spec.timing.units = 'secs';
        matlabbatch{1}.spm.stats.fmri_spec.timing.RT = 1.7;
        matlabbatch{1}.spm.stats.fmri_spec.timing.fmri_t = 32;
        matlabbatch{1}.spm.stats.fmri_spec.timing.fmri_t0 = 17;


        % load regressors file
        load([basepath_Regr_Shock 'sbj_' num2str(Subject_i) '_Shock.mat'])
        load([basepath_Regr_Mech 'sbj_' num2str(Subject_i) '_Mech.mat'])
        
         % select all scans for each session and task
         task_location_1 = sprintf('%s%s%s%s',basepath,filesep,char(Session(:,1)),filesep,char(Task_GLM(:,1)));
            scans_1 = spm_select('FPList',fullfile(task_location_1),'^swaROOP*');  
            scans_1(end,:)
         task_location_2 = sprintf('%s%s%s%s',basepath,filesep,char(Session(:,1)),filesep,char(Task_GLM(2)));
            scans_2 = spm_select('FPList',fullfile(task_location_2), '^swaROOP*');
            scans_2(end,:)
         task_location_3 = sprintf('%s%s%s%s',basepath,filesep,char(Session(:,2)),filesep,char(Task_GLM(1)));
            scans_3 = spm_select('FPList',fullfile(task_location_3), '^swaROOP*');
            scans_3(end,:)
         task_location_4 = sprintf('%s%s%s%s',basepath,filesep,char(Session(:,2)),filesep,char(Task_GLM(2)));
            scans_4 = spm_select('FPList',fullfile(task_location_4), '^swaROOP*');
            scans_4(end,:)
         task_location_5 = sprintf('%s%s%s%s',basepath,filesep,char(Session(:,1)),filesep,char(Task_GLM(3)));
            scans_5 = spm_select('FPList',fullfile(task_location_5), '^swaROOP*');
            scans_5(end,:)
         task_location_6 = sprintf('%s%s%s%s',basepath,filesep,char(Session(:,1)),filesep,char(Task_GLM(4)));
            scans_6 = spm_select('FPList',fullfile(task_location_6), '^swaROOP*');
            scans_6(end,:)
         task_location_7 = sprintf('%s%s%s%s',basepath,filesep,char(Session(:,2)),filesep,char(Task_GLM(3)));
            scans_7 = spm_select('FPList',fullfile(task_location_7), '^swaROOP*');
            scans_7(end,:)
         task_location_8 = sprintf('%s%s%s%s',basepath,filesep,char(Session(:,2)),filesep,char(Task_GLM(4)));
            scans_8 = spm_select('FPList',fullfile(task_location_8), '^swaROOP*');
            scans_8(end,:)
            
            
       
        % REAL own_SHOCK_1
        matlabbatch{1}.spm.stats.fmri_spec.sess(1).scans =  cellstr(scans_1);
        
        a=1;
        % stim and rating
        matlabbatch{1}.spm.stats.fmri_spec.sess(1).cond(a).name = 'shock_R_r1';
        matlabbatch{1}.spm.stats.fmri_spec.sess(1).cond(a).onset = Shock.Real.Run1.stim_onset;
        matlabbatch{1}.spm.stats.fmri_spec.sess(1).cond(a).duration = repmat(0.5,size(Shock.Real.Run1.stim_onset,1),1);
        matlabbatch{1}.spm.stats.fmri_spec.sess(1).cond(a).tmod = 0;
        matlabbatch{1}.spm.stats.fmri_spec.sess(1).cond(a).pmod.name = 'Shock_R_r1_Rating';
        matlabbatch{1}.spm.stats.fmri_spec.sess(1).cond(a).pmod.param = Shock.Real.Run1.stim_rating;
        matlabbatch{1}.spm.stats.fmri_spec.sess(1).cond(a).pmod.poly = 1;
        matlabbatch{1}.spm.stats.fmri_spec.sess(1).cond(a).orth = 1;
        % question mark
        if (isempty(Shock.Real.Run1.quest_onset)==0)
        a=a+1;    
        end
        matlabbatch{1}.spm.stats.fmri_spec.sess(1).cond(a).name = 'shock_quest_R_r1';
        matlabbatch{1}.spm.stats.fmri_spec.sess(1).cond(a).onset = Shock.Real.Run1.quest_onset;
        matlabbatch{1}.spm.stats.fmri_spec.sess(1).cond(a).duration = Shock.Real.Run1.quest_duration;
        matlabbatch{1}.spm.stats.fmri_spec.sess(1).cond(a).tmod = 0;
        matlabbatch{1}.spm.stats.fmri_spec.sess(1).cond(a).pmod = struct('name', {}, 'param', {}, 'poly', {});
        matlabbatch{1}.spm.stats.fmri_spec.sess(1).cond(a).orth = 1;
        
        % Intro
        a=a+1;
        matlabbatch{1}.spm.stats.fmri_spec.sess(1).cond(a).name = 'shock_intro_R_r1';
        matlabbatch{1}.spm.stats.fmri_spec.sess(1).cond(a).onset = 0;
        matlabbatch{1}.spm.stats.fmri_spec.sess(1).cond(a).duration = 5;
        matlabbatch{1}.spm.stats.fmri_spec.sess(1).cond(a).tmod = 0;
        matlabbatch{1}.spm.stats.fmri_spec.sess(1).cond(a).pmod = struct('name', {}, 'param', {}, 'poly', {});
        matlabbatch{1}.spm.stats.fmri_spec.sess(1).cond(a).orth = 1;
        
        % extra button press (duration: zero)
        if (isempty(Shock.Real.Run1.extra_button_press_onset)==0)
        a=a+1;    
            matlabbatch{1}.spm.stats.fmri_spec.sess(1).cond(a).name = 'shock_extra_button_press_onset_R_r1';
            matlabbatch{1}.spm.stats.fmri_spec.sess(1).cond(a).onset = Shock.Real.Run1.extra_button_press_onset;
            matlabbatch{1}.spm.stats.fmri_spec.sess(1).cond(a).duration = zeros(size(Shock.Real.Run1.extra_button_press_onset,1),1); 

            matlabbatch{1}.spm.stats.fmri_spec.sess(1).cond(a).tmod = 0;
            matlabbatch{1}.spm.stats.fmri_spec.sess(1).cond(a).pmod = struct('name', {}, 'param', {}, 'poly', {});
            matlabbatch{1}.spm.stats.fmri_spec.sess(1).cond(a).orth = 1;
        end
        
        % right hand button press (duration: zero) !!!NOT ALWAYS PRESENT 
        if (isfield(Shock.Real.Run1, 'right_hand_button_press_onset')==1)
        a=a+1;    
            matlabbatch{1}.spm.stats.fmri_spec.sess(1).cond(a).name = 'shock_right_hand_button_press_onset_R_r1';
            matlabbatch{1}.spm.stats.fmri_spec.sess(1).cond(a).onset = Shock.Real.Run1.right_hand_button_press_onset;
            matlabbatch{1}.spm.stats.fmri_spec.sess(1).cond(a).duration = zeros(size(Shock.Real.Run1.right_hand_button_press_onset,1),1); 

            matlabbatch{1}.spm.stats.fmri_spec.sess(1).cond(a).tmod = 0;
            matlabbatch{1}.spm.stats.fmri_spec.sess(1).cond(a).pmod = struct('name', {}, 'param', {}, 'poly', {});
            matlabbatch{1}.spm.stats.fmri_spec.sess(1).cond(a).orth = 1;
        end
        
        % stim changed rating!!! NOT ALWAYS PRESENT 
        if (isfield(Shock.Real.Run1, 'stim_changed_rating_onset')==1)
        a=a+1;    
            matlabbatch{1}.spm.stats.fmri_spec.sess(1).cond(a).name = 'shock_stim_changed_rating_onset_R_r1';
            matlabbatch{1}.spm.stats.fmri_spec.sess(1).cond(a).onset = Shock.Real.Run1.stim_changed_rating_onset;
            matlabbatch{1}.spm.stats.fmri_spec.sess(1).cond(a).duration = zeros(size(Shock.Real.Run1.stim_changed_rating_onset,1),1); 

            matlabbatch{1}.spm.stats.fmri_spec.sess(1).cond(a).tmod = 0;
            matlabbatch{1}.spm.stats.fmri_spec.sess(1).cond(a).pmod = struct('name', {}, 'param', {}, 'poly', {});
            matlabbatch{1}.spm.stats.fmri_spec.sess(1).cond(a).orth = 1;
        end
        
        matlabbatch{1}.spm.stats.fmri_spec.sess(1).multi = {''};
        matlabbatch{1}.spm.stats.fmri_spec.sess(1).regress = struct('name', {}, 'val', {});
        motion_par_1 = spm_select('FPList',fullfile(task_location_1),'^r*');
        matlabbatch{1}.spm.stats.fmri_spec.sess(1).multi_reg = {motion_par_1};
        matlabbatch{1}.spm.stats.fmri_spec.sess(1).hpf = 128;
        
% REAL own_SHOCK_2
        matlabbatch{1}.spm.stats.fmri_spec.sess(2).scans =  cellstr(scans_2);
        
        b=1;
        % stim and rating
        matlabbatch{1}.spm.stats.fmri_spec.sess(2).cond(b).name = 'shock_R_r2';
        matlabbatch{1}.spm.stats.fmri_spec.sess(2).cond(b).onset = Shock.Real.Run2.stim_onset;
        matlabbatch{1}.spm.stats.fmri_spec.sess(2).cond(b).duration = repmat(0.5,size(Shock.Real.Run2.stim_onset,1),1);
        matlabbatch{1}.spm.stats.fmri_spec.sess(2).cond(b).tmod = 0;
        matlabbatch{1}.spm.stats.fmri_spec.sess(2).cond(b).pmod.name = 'Shock_R_r2_Rating';
        matlabbatch{1}.spm.stats.fmri_spec.sess(2).cond(b).pmod.param = Shock.Real.Run2.stim_rating;
        matlabbatch{1}.spm.stats.fmri_spec.sess(2).cond(b).pmod.poly = 1;
        matlabbatch{1}.spm.stats.fmri_spec.sess(2).cond(b).orth = 1;
        % question mark
        if (isempty(Shock.Real.Run2.quest_onset)==0)
        b=b+1;    
        end
        matlabbatch{1}.spm.stats.fmri_spec.sess(2).cond(b).name = 'shock_quest_R_r2';
        matlabbatch{1}.spm.stats.fmri_spec.sess(2).cond(b).onset = Shock.Real.Run2.quest_onset;
        matlabbatch{1}.spm.stats.fmri_spec.sess(2).cond(b).duration = Shock.Real.Run2.quest_duration;
        matlabbatch{1}.spm.stats.fmri_spec.sess(2).cond(b).tmod = 0;
        matlabbatch{1}.spm.stats.fmri_spec.sess(2).cond(b).pmod = struct('name', {}, 'param', {}, 'poly', {});
        matlabbatch{1}.spm.stats.fmri_spec.sess(2).cond(b).orth = 1;
        % Intro
        b=b+1;
        matlabbatch{1}.spm.stats.fmri_spec.sess(2).cond(b).name = 'shock_intro_R_r2';
        matlabbatch{1}.spm.stats.fmri_spec.sess(2).cond(b).onset = 0;
        matlabbatch{1}.spm.stats.fmri_spec.sess(2).cond(b).duration = 5;
        matlabbatch{1}.spm.stats.fmri_spec.sess(2).cond(b).tmod = 0;
        matlabbatch{1}.spm.stats.fmri_spec.sess(2).cond(b).pmod = struct('name', {}, 'param', {}, 'poly', {});
        matlabbatch{1}.spm.stats.fmri_spec.sess(2).cond(b).orth = 1;
        % extra button press (duration: zero)
        if (isempty(Shock.Real.Run2.extra_button_press_onset)==0)
        b=b+1;    
            matlabbatch{1}.spm.stats.fmri_spec.sess(2).cond(b).name = 'shock_extra_button_press_onset_R_r2';
            matlabbatch{1}.spm.stats.fmri_spec.sess(2).cond(b).onset = Shock.Real.Run2.extra_button_press_onset;
            matlabbatch{1}.spm.stats.fmri_spec.sess(2).cond(b).duration = zeros(size(Shock.Real.Run2.extra_button_press_onset,1),1); 

            matlabbatch{1}.spm.stats.fmri_spec.sess(2).cond(b).tmod = 0;
            matlabbatch{1}.spm.stats.fmri_spec.sess(2).cond(b).pmod = struct('name', {}, 'param', {}, 'poly', {});
            matlabbatch{1}.spm.stats.fmri_spec.sess(2).cond(b).orth = 1;
        end
        
        % right hand button press (duration: zero) !!!NOT ALWAYS PRESENT 
        if (isfield(Shock.Real.Run2, 'right_hand_button_press_onset')==1)
        b=b+1;    
            matlabbatch{1}.spm.stats.fmri_spec.sess(2).cond(b).name = 'shock_right_hand_button_press_onset_R_r2';
            matlabbatch{1}.spm.stats.fmri_spec.sess(2).cond(b).onset = Shock.Real.Run2.right_hand_button_press_onset;
            matlabbatch{1}.spm.stats.fmri_spec.sess(2).cond(b).duration = zeros(size(Shock.Real.Run2.right_hand_button_press_onset,1),1); 

            matlabbatch{1}.spm.stats.fmri_spec.sess(2).cond(b).tmod = 0;
            matlabbatch{1}.spm.stats.fmri_spec.sess(2).cond(b).pmod = struct('name', {}, 'param', {}, 'poly', {});
            matlabbatch{1}.spm.stats.fmri_spec.sess(2).cond(b).orth = 1;
        end
        
        % stim changed rating!!! NOT ALWAYS PRESENT 
        if (isfield(Shock.Real.Run2, 'stim_changed_rating_onset')==1)
        b=b+1;    
            matlabbatch{1}.spm.stats.fmri_spec.sess(2).cond(b).name = 'shock_stim_changed_rating_onset_R_r2';
            matlabbatch{1}.spm.stats.fmri_spec.sess(2).cond(b).onset = Shock.Real.Run2.stim_changed_rating_onset;
            matlabbatch{1}.spm.stats.fmri_spec.sess(2).cond(b).duration = zeros(size(Shock.Real.Run2.stim_changed_rating_onset,1),1); 

            matlabbatch{1}.spm.stats.fmri_spec.sess(2).cond(b).tmod = 0;
            matlabbatch{1}.spm.stats.fmri_spec.sess(2).cond(b).pmod = struct('name', {}, 'param', {}, 'poly', {});
            matlabbatch{1}.spm.stats.fmri_spec.sess(2).cond(b).orth = 1;
        end
        
        matlabbatch{1}.spm.stats.fmri_spec.sess(2).multi = {''};
        matlabbatch{1}.spm.stats.fmri_spec.sess(2).regress = struct('name', {}, 'val', {});
        motion_par_2 = spm_select('FPList',fullfile(task_location_2),'^r*');
        matlabbatch{1}.spm.stats.fmri_spec.sess(2).multi_reg = {motion_par_2};
        matlabbatch{1}.spm.stats.fmri_spec.sess(2).hpf = 128;
        
% SHAM own_SHOCK_1
        matlabbatch{1}.spm.stats.fmri_spec.sess(3).scans =  cellstr(scans_3);
        
        c=1;
        % stim and rating
        matlabbatch{1}.spm.stats.fmri_spec.sess(3).cond(c).name = 'shock_S_r1';
        matlabbatch{1}.spm.stats.fmri_spec.sess(3).cond(c).onset = Shock.Sham.Run1.stim_onset;
        matlabbatch{1}.spm.stats.fmri_spec.sess(3).cond(c).duration = repmat(0.5,size(Shock.Sham.Run1.stim_onset,1),1);
        matlabbatch{1}.spm.stats.fmri_spec.sess(3).cond(c).tmod = 0;
        matlabbatch{1}.spm.stats.fmri_spec.sess(3).cond(c).pmod.name = 'Shock_S_r1_Rating';
        matlabbatch{1}.spm.stats.fmri_spec.sess(3).cond(c).pmod.param = Shock.Sham.Run1.stim_rating;
        matlabbatch{1}.spm.stats.fmri_spec.sess(3).cond(c).pmod.poly = 1;
        matlabbatch{1}.spm.stats.fmri_spec.sess(3).cond(c).orth = 1;
        % question mark
        if (isempty(Shock.Sham.Run1.quest_onset)==0)
        c=c+1;    
        end
        matlabbatch{1}.spm.stats.fmri_spec.sess(3).cond(c).name = 'shock_quest_S_r1';
        matlabbatch{1}.spm.stats.fmri_spec.sess(3).cond(c).onset = Shock.Sham.Run1.quest_onset;
        matlabbatch{1}.spm.stats.fmri_spec.sess(3).cond(c).duration = Shock.Sham.Run1.quest_duration;
        matlabbatch{1}.spm.stats.fmri_spec.sess(3).cond(c).tmod = 0;
        matlabbatch{1}.spm.stats.fmri_spec.sess(3).cond(c).pmod = struct('name', {}, 'param', {}, 'poly', {});
        matlabbatch{1}.spm.stats.fmri_spec.sess(3).cond(c).orth = 1;
        % intro
        c=c+1;
        matlabbatch{1}.spm.stats.fmri_spec.sess(3).cond(c).name = 'shock_intro_S_r1';
        matlabbatch{1}.spm.stats.fmri_spec.sess(3).cond(c).onset = 0;
        matlabbatch{1}.spm.stats.fmri_spec.sess(3).cond(c).duration = 5;
        matlabbatch{1}.spm.stats.fmri_spec.sess(3).cond(c).tmod = 0;
        matlabbatch{1}.spm.stats.fmri_spec.sess(3).cond(c).pmod = struct('name', {}, 'param', {}, 'poly', {});
        matlabbatch{1}.spm.stats.fmri_spec.sess(3).cond(c).orth = 1;
        
        % extra button press (duration: zero)
        if (isempty(Shock.Sham.Run1.extra_button_press_onset)==0)
        c=c+1;    
            matlabbatch{1}.spm.stats.fmri_spec.sess(3).cond(c).name = 'shock_extra_button_press_onset_S_r1';
            matlabbatch{1}.spm.stats.fmri_spec.sess(3).cond(c).onset = Shock.Sham.Run1.extra_button_press_onset;
            matlabbatch{1}.spm.stats.fmri_spec.sess(3).cond(c).duration = zeros(size(Shock.Sham.Run1.extra_button_press_onset,1),1); 

            matlabbatch{1}.spm.stats.fmri_spec.sess(3).cond(c).tmod = 0;
            matlabbatch{1}.spm.stats.fmri_spec.sess(3).cond(c).pmod = struct('name', {}, 'param', {}, 'poly', {});
            matlabbatch{1}.spm.stats.fmri_spec.sess(3).cond(c).orth = 1;
        end
        
        % right hand button press (duration: zero) !!!NOT ALWAYS PRESENT 
        if (isfield(Shock.Sham.Run1, 'right_hand_button_press_onset')==1)
        c=c+1;    
            matlabbatch{1}.spm.stats.fmri_spec.sess(3).cond(c).name = 'shock_right_hand_button_press_onset_S_r1';
            matlabbatch{1}.spm.stats.fmri_spec.sess(3).cond(c).onset = Shock.Sham.Run1.right_hand_button_press_onset;
            matlabbatch{1}.spm.stats.fmri_spec.sess(3).cond(c).duration = zeros(size(Shock.Sham.Run1.right_hand_button_press_onset,1),1); 

            matlabbatch{1}.spm.stats.fmri_spec.sess(3).cond(c).tmod = 0;
            matlabbatch{1}.spm.stats.fmri_spec.sess(3).cond(c).pmod = struct('name', {}, 'param', {}, 'poly', {});
            matlabbatch{1}.spm.stats.fmri_spec.sess(3).cond(c).orth = 1;
        end
        
        % stim changed rating!!! NOT ALWAYS PRESENT 
        if (isfield(Shock.Sham.Run1, 'stim_changed_rating_onset')==1)
        c=c+1;    
            matlabbatch{1}.spm.stats.fmri_spec.sess(3).cond(c).name = 'shock_stim_changed_rating_onset_S_r1';
            matlabbatch{1}.spm.stats.fmri_spec.sess(3).cond(c).onset = Shock.Sham.Run1.stim_changed_rating_onset;
            matlabbatch{1}.spm.stats.fmri_spec.sess(3).cond(c).duration = zeros(size(Shock.Sham.Run1.stim_changed_rating_onset,1),1); 

            matlabbatch{1}.spm.stats.fmri_spec.sess(3).cond(c).tmod = 0;
            matlabbatch{1}.spm.stats.fmri_spec.sess(3).cond(c).pmod = struct('name', {}, 'param', {}, 'poly', {});
            matlabbatch{1}.spm.stats.fmri_spec.sess(3).cond(c).orth = 1;
        end
        
        matlabbatch{1}.spm.stats.fmri_spec.sess(3).multi = {''};
        matlabbatch{1}.spm.stats.fmri_spec.sess(3).regress = struct('name', {}, 'val', {});
        motion_par_3 = spm_select('FPList',fullfile(task_location_3),'^r*');
        matlabbatch{1}.spm.stats.fmri_spec.sess(3).multi_reg = {motion_par_3};
        matlabbatch{1}.spm.stats.fmri_spec.sess(3).hpf = 128;

% SHAM own_SHOCK_2
        matlabbatch{1}.spm.stats.fmri_spec.sess(4).scans =  cellstr(scans_4);
        
        d=1;
        % stim and rating
        matlabbatch{1}.spm.stats.fmri_spec.sess(4).cond(d).name = 'shock_S_r2';
        matlabbatch{1}.spm.stats.fmri_spec.sess(4).cond(d).onset = Shock.Sham.Run2.stim_onset;
        matlabbatch{1}.spm.stats.fmri_spec.sess(4).cond(d).duration = repmat(0.5,size(Shock.Sham.Run2.stim_onset,1),1);
        matlabbatch{1}.spm.stats.fmri_spec.sess(4).cond(d).tmod = 0;
        matlabbatch{1}.spm.stats.fmri_spec.sess(4).cond(d).pmod.name = 'Shock_S_r2_Rating';
        matlabbatch{1}.spm.stats.fmri_spec.sess(4).cond(d).pmod.param = Shock.Sham.Run2.stim_rating;
        matlabbatch{1}.spm.stats.fmri_spec.sess(4).cond(d).pmod.poly = 1;
        matlabbatch{1}.spm.stats.fmri_spec.sess(4).cond(d).orth = 1;
        % question mark
        if (isempty(Shock.Sham.Run2.quest_onset)==0)
        d=d+1;    
        end
        matlabbatch{1}.spm.stats.fmri_spec.sess(4).cond(d).name = 'shock_quest_S_r2';
        matlabbatch{1}.spm.stats.fmri_spec.sess(4).cond(d).onset = Shock.Sham.Run2.quest_onset;
        matlabbatch{1}.spm.stats.fmri_spec.sess(4).cond(d).duration = Shock.Sham.Run2.quest_duration;
        matlabbatch{1}.spm.stats.fmri_spec.sess(4).cond(d).tmod = 0;
        matlabbatch{1}.spm.stats.fmri_spec.sess(4).cond(d).pmod = struct('name', {}, 'param', {}, 'poly', {});
        matlabbatch{1}.spm.stats.fmri_spec.sess(4).cond(d).orth = 1;
        % intro
        d=d+1;
         matlabbatch{1}.spm.stats.fmri_spec.sess(4).cond(d).name = 'shock_intro_S_r2';
        matlabbatch{1}.spm.stats.fmri_spec.sess(4).cond(d).onset = 0;
        matlabbatch{1}.spm.stats.fmri_spec.sess(4).cond(d).duration =5;
        matlabbatch{1}.spm.stats.fmri_spec.sess(4).cond(d).tmod = 0;
        matlabbatch{1}.spm.stats.fmri_spec.sess(4).cond(d).pmod = struct('name', {}, 'param', {}, 'poly', {});
        matlabbatch{1}.spm.stats.fmri_spec.sess(4).cond(d).orth = 1;
        % extra button press (duration: zero)
        if (isempty(Shock.Sham.Run2.extra_button_press_onset)==0)
        d=d+1;    
            matlabbatch{1}.spm.stats.fmri_spec.sess(4).cond(d).name = 'shock_extra_button_press_onset_S_r2';
            matlabbatch{1}.spm.stats.fmri_spec.sess(4).cond(d).onset = Shock.Sham.Run2.extra_button_press_onset;
            matlabbatch{1}.spm.stats.fmri_spec.sess(4).cond(d).duration = zeros(size(Shock.Sham.Run2.extra_button_press_onset,1),1); 

            matlabbatch{1}.spm.stats.fmri_spec.sess(4).cond(d).tmod = 0;
            matlabbatch{1}.spm.stats.fmri_spec.sess(4).cond(d).pmod = struct('name', {}, 'param', {}, 'poly', {});
            matlabbatch{1}.spm.stats.fmri_spec.sess(4).cond(d).orth = 1;
        end
        
        % right hand button press (duration: zero) !!!NOT ALWAYS PRESENT 
        if (isfield(Shock.Sham.Run2, 'right_hand_button_press_onset')==1)
        d=d+1;    
            matlabbatch{1}.spm.stats.fmri_spec.sess(4).cond(d).name = 'shock_right_hand_button_press_onset_S_r2';
            matlabbatch{1}.spm.stats.fmri_spec.sess(4).cond(d).onset = Shock.Sham.Run2.right_hand_button_press_onset;
            matlabbatch{1}.spm.stats.fmri_spec.sess(4).cond(d).duration = zeros(size(Shock.Sham.Run2.right_hand_button_press_onset,1),1); 

            matlabbatch{1}.spm.stats.fmri_spec.sess(4).cond(d).tmod = 0;
            matlabbatch{1}.spm.stats.fmri_spec.sess(4).cond(d).pmod = struct('name', {}, 'param', {}, 'poly', {});
            matlabbatch{1}.spm.stats.fmri_spec.sess(4).cond(d).orth = 1;
        end
        
        % stim changed rating!!! NOT ALWAYS PRESENT 
        if (isfield(Shock.Sham.Run2, 'stim_changed_rating_onset')==1)
        d=d+1;    
            matlabbatch{1}.spm.stats.fmri_spec.sess(4).cond(d).name = 'shock_stim_changed_rating_onset_S_r2';
            matlabbatch{1}.spm.stats.fmri_spec.sess(4).cond(d).onset = Shock.Sham.Run2.stim_changed_rating_onset;
            matlabbatch{1}.spm.stats.fmri_spec.sess(4).cond(d).duration = zeros(size(Shock.Sham.Run2.stim_changed_rating_onset,1),1); 

            matlabbatch{1}.spm.stats.fmri_spec.sess(4).cond(d).tmod = 0;
            matlabbatch{1}.spm.stats.fmri_spec.sess(4).cond(d).pmod = struct('name', {}, 'param', {}, 'poly', {});
            matlabbatch{1}.spm.stats.fmri_spec.sess(4).cond(d).orth = 1;
        end
        
        matlabbatch{1}.spm.stats.fmri_spec.sess(4).multi = {''};
        matlabbatch{1}.spm.stats.fmri_spec.sess(4).regress = struct('name', {}, 'val', {});
        motion_par_4 = spm_select('FPList',fullfile(task_location_4),'^r*');
        matlabbatch{1}.spm.stats.fmri_spec.sess(4).multi_reg = {motion_par_4};
        matlabbatch{1}.spm.stats.fmri_spec.sess(4).hpf = 128;
        
    
%%%%%%%%%%%%%%%%%%%%%%%%%% 
%
        % REAL own_Mech_1
        matlabbatch{1}.spm.stats.fmri_spec.sess(5).scans =  cellstr(scans_5);
        
        e=1;
        % stim and rating
        matlabbatch{1}.spm.stats.fmri_spec.sess(5).cond(e).name = 'Mech_R_r1';
        matlabbatch{1}.spm.stats.fmri_spec.sess(5).cond(e).onset = Mech.Real.Run1.stim_onset;
        matlabbatch{1}.spm.stats.fmri_spec.sess(5).cond(e).duration = repmat(0.5,size(Mech.Real.Run1.stim_onset,1),1);
        matlabbatch{1}.spm.stats.fmri_spec.sess(5).cond(e).tmod = 0;
        matlabbatch{1}.spm.stats.fmri_spec.sess(5).cond(e).pmod.name = 'Mech_R_r1_Rating';
        matlabbatch{1}.spm.stats.fmri_spec.sess(5).cond(e).pmod.param = Mech.Real.Run1.stim_rating;
        matlabbatch{1}.spm.stats.fmri_spec.sess(5).cond(e).pmod.poly = 1;
        matlabbatch{1}.spm.stats.fmri_spec.sess(5).cond(e).orth = 1;
        % question mark
        if (isempty(Mech.Real.Run1.quest_onset)==0)
        e=e+1;   
        end
        matlabbatch{1}.spm.stats.fmri_spec.sess(5).cond(e).name = 'mech_quest_R_r1';
        matlabbatch{1}.spm.stats.fmri_spec.sess(5).cond(e).onset = Mech.Real.Run1.quest_onset;
        matlabbatch{1}.spm.stats.fmri_spec.sess(5).cond(e).duration = Mech.Real.Run1.quest_duration;
        matlabbatch{1}.spm.stats.fmri_spec.sess(5).cond(e).tmod = 0;
        matlabbatch{1}.spm.stats.fmri_spec.sess(5).cond(e).pmod = struct('name', {}, 'param', {}, 'poly', {});
        matlabbatch{1}.spm.stats.fmri_spec.sess(5).cond(e).orth = 1;
        % intro
        e=e+1;
        matlabbatch{1}.spm.stats.fmri_spec.sess(5).cond(e).name = 'mech_intro_R_r1';
        matlabbatch{1}.spm.stats.fmri_spec.sess(5).cond(e).onset = 0;
        matlabbatch{1}.spm.stats.fmri_spec.sess(5).cond(e).duration = 5;
        matlabbatch{1}.spm.stats.fmri_spec.sess(5).cond(e).tmod = 0;
        matlabbatch{1}.spm.stats.fmri_spec.sess(5).cond(e).pmod = struct('name', {}, 'param', {}, 'poly', {});
        matlabbatch{1}.spm.stats.fmri_spec.sess(5).cond(e).orth = 1;
        
        % extra button press (duration: zero)
        if (isempty(Mech.Real.Run1.extra_button_press_onset)==0)
        e=e+1;   
            matlabbatch{1}.spm.stats.fmri_spec.sess(5).cond(e).name = 'mech_extra_button_press_onset_R_r1';
            matlabbatch{1}.spm.stats.fmri_spec.sess(5).cond(e).onset = Mech.Real.Run1.extra_button_press_onset;
            matlabbatch{1}.spm.stats.fmri_spec.sess(5).cond(e).duration = zeros(size(Mech.Real.Run1.extra_button_press_onset,1),1); 

            matlabbatch{1}.spm.stats.fmri_spec.sess(5).cond(e).tmod = 0;
            matlabbatch{1}.spm.stats.fmri_spec.sess(5).cond(e).pmod = struct('name', {}, 'param', {}, 'poly', {});
            matlabbatch{1}.spm.stats.fmri_spec.sess(5).cond(e).orth = 1;
        end
        
        % right hand button press (duration: zero) !!!NOT ALWAYS PRESENT 
        if (isfield(Mech.Real.Run1, 'right_hand_button_press_onset')==1)
        e=e+1; 
            matlabbatch{1}.spm.stats.fmri_spec.sess(5).cond(e).name = 'mech_right_hand_button_press_onset_R_r1';
            matlabbatch{1}.spm.stats.fmri_spec.sess(5).cond(e).onset = Mech.Real.Run1.right_hand_button_press_onset;
            matlabbatch{1}.spm.stats.fmri_spec.sess(5).cond(e).duration = zeros(size(Mech.Real.Run1.right_hand_button_press_onset,1),1); 

            matlabbatch{1}.spm.stats.fmri_spec.sess(5).cond(e).tmod = 0;
            matlabbatch{1}.spm.stats.fmri_spec.sess(5).cond(e).pmod = struct('name', {}, 'param', {}, 'poly', {});
            matlabbatch{1}.spm.stats.fmri_spec.sess(5).cond(e).orth = 1;
        end
        
        % stim changed rating!!! NOT ALWAYS PRESENT 
        if (isfield(Mech.Real.Run1, 'stim_changed_rating_onset')==1)
        e=e+1;   
            matlabbatch{1}.spm.stats.fmri_spec.sess(5).cond(e).name = 'mech_stim_changed_rating_onset_R_r1';
            matlabbatch{1}.spm.stats.fmri_spec.sess(5).cond(e).onset = Mech.Real.Run1.stim_changed_rating_onset;
            matlabbatch{1}.spm.stats.fmri_spec.sess(5).cond(e).duration = zeros(size(Mech.Real.Run1.stim_changed_rating_onset,1),1); 

            matlabbatch{1}.spm.stats.fmri_spec.sess(5).cond(e).tmod = 0;
            matlabbatch{1}.spm.stats.fmri_spec.sess(5).cond(e).pmod = struct('name', {}, 'param', {}, 'poly', {});
            matlabbatch{1}.spm.stats.fmri_spec.sess(5).cond(e).orth = 1;
        end
        
        matlabbatch{1}.spm.stats.fmri_spec.sess(5).multi = {''};
        matlabbatch{1}.spm.stats.fmri_spec.sess(5).regress = struct('name', {}, 'val', {});
        motion_par_5 = spm_select('FPList',fullfile(task_location_5),'^r*');
        matlabbatch{1}.spm.stats.fmri_spec.sess(5).multi_reg = {motion_par_5};
        matlabbatch{1}.spm.stats.fmri_spec.sess(5).hpf = 128;
        
% REAL own_Mech_2
        matlabbatch{1}.spm.stats.fmri_spec.sess(6).scans =  cellstr(scans_6);
        
        f=1;
        % stim and rating
        matlabbatch{1}.spm.stats.fmri_spec.sess(6).cond(f).name = 'Mech_R_r2';
        matlabbatch{1}.spm.stats.fmri_spec.sess(6).cond(f).onset = Mech.Real.Run2.stim_onset;
        matlabbatch{1}.spm.stats.fmri_spec.sess(6).cond(f).duration = repmat(0.5,size(Mech.Real.Run2.stim_onset,1),1);
        matlabbatch{1}.spm.stats.fmri_spec.sess(6).cond(f).tmod = 0;
        matlabbatch{1}.spm.stats.fmri_spec.sess(6).cond(f).pmod.name = 'Mech_R_r2_Rating';
        matlabbatch{1}.spm.stats.fmri_spec.sess(6).cond(f).pmod.param = Mech.Real.Run2.stim_rating;
        matlabbatch{1}.spm.stats.fmri_spec.sess(6).cond(f).pmod.poly = 1;
        matlabbatch{1}.spm.stats.fmri_spec.sess(6).cond(f).orth = 1;
        % question mark
        if (isempty(Mech.Real.Run2.quest_onset)==0)
        f=f+1;    
        end
        matlabbatch{1}.spm.stats.fmri_spec.sess(6).cond(f).name = 'mech_quest_R_r2';
        matlabbatch{1}.spm.stats.fmri_spec.sess(6).cond(f).onset = Mech.Real.Run2.quest_onset;
        matlabbatch{1}.spm.stats.fmri_spec.sess(6).cond(f).duration = Mech.Real.Run2.quest_duration;
        matlabbatch{1}.spm.stats.fmri_spec.sess(6).cond(f).tmod = 0;
        matlabbatch{1}.spm.stats.fmri_spec.sess(6).cond(f).pmod = struct('name', {}, 'param', {}, 'poly', {});
        matlabbatch{1}.spm.stats.fmri_spec.sess(6).cond(f).orth = 1;
        % intro
        f=f+1;
        matlabbatch{1}.spm.stats.fmri_spec.sess(6).cond(f).name = 'mech_intro_R_r2';
        matlabbatch{1}.spm.stats.fmri_spec.sess(6).cond(f).onset = 0;
        matlabbatch{1}.spm.stats.fmri_spec.sess(6).cond(f).duration = 5;
        matlabbatch{1}.spm.stats.fmri_spec.sess(6).cond(f).tmod = 0;
        matlabbatch{1}.spm.stats.fmri_spec.sess(6).cond(f).pmod = struct('name', {}, 'param', {}, 'poly', {});
        matlabbatch{1}.spm.stats.fmri_spec.sess(6).cond(f).orth = 1;
        
        % extra button press (duration: zero)
        if (isempty(Mech.Real.Run2.extra_button_press_onset)==0)
        f=f+1;    
            matlabbatch{1}.spm.stats.fmri_spec.sess(6).cond(f).name = 'mech_extra_button_press_onset_R_r2';
            matlabbatch{1}.spm.stats.fmri_spec.sess(6).cond(f).onset = Mech.Real.Run2.extra_button_press_onset;
            matlabbatch{1}.spm.stats.fmri_spec.sess(6).cond(f).duration = zeros(size(Mech.Real.Run2.extra_button_press_onset,1),1); 

            matlabbatch{1}.spm.stats.fmri_spec.sess(6).cond(f).tmod = 0;
            matlabbatch{1}.spm.stats.fmri_spec.sess(6).cond(f).pmod = struct('name', {}, 'param', {}, 'poly', {});
            matlabbatch{1}.spm.stats.fmri_spec.sess(6).cond(f).orth = 1;
        end
        
        % right hand button press (duration: zero) !!!NOT ALWAYS PRESENT 
        if (isfield(Mech.Real.Run2, 'right_hand_button_press_onset')==1)
        f=f+1;    
            matlabbatch{1}.spm.stats.fmri_spec.sess(6).cond(f).name = 'mech_right_hand_button_press_onset_R_r2';
            matlabbatch{1}.spm.stats.fmri_spec.sess(6).cond(f).onset = Mech.Real.Run2.right_hand_button_press_onset;
            matlabbatch{1}.spm.stats.fmri_spec.sess(6).cond(f).duration = zeros(size(Mech.Real.Run2.right_hand_button_press_onset,1),1); 

            matlabbatch{1}.spm.stats.fmri_spec.sess(6).cond(f).tmod = 0;
            matlabbatch{1}.spm.stats.fmri_spec.sess(6).cond(f).pmod = struct('name', {}, 'param', {}, 'poly', {});
            matlabbatch{1}.spm.stats.fmri_spec.sess(6).cond(f).orth = 1;
        end
        
        % stim changed rating!!! NOT ALWAYS PRESENT 
        if (isfield(Mech.Real.Run2, 'stim_changed_rating_onset')==1)
        f=f+1;    
            matlabbatch{1}.spm.stats.fmri_spec.sess(6).cond(f).name = 'mech_stim_changed_rating_onset_R_r2';
            matlabbatch{1}.spm.stats.fmri_spec.sess(6).cond(f).onset = Mech.Real.Run2.stim_changed_rating_onset;
            matlabbatch{1}.spm.stats.fmri_spec.sess(6).cond(f).duration = zeros(size(Mech.Real.Run2.stim_changed_rating_onset,1),1); 

            matlabbatch{1}.spm.stats.fmri_spec.sess(6).cond(f).tmod = 0;
            matlabbatch{1}.spm.stats.fmri_spec.sess(6).cond(f).pmod = struct('name', {}, 'param', {}, 'poly', {});
            matlabbatch{1}.spm.stats.fmri_spec.sess(6).cond(f).orth = 1;
        end
        
        matlabbatch{1}.spm.stats.fmri_spec.sess(6).multi = {''};
        matlabbatch{1}.spm.stats.fmri_spec.sess(6).regress = struct('name', {}, 'val', {});
        motion_par_6 = spm_select('FPList',fullfile(task_location_6),'^r*');
        matlabbatch{1}.spm.stats.fmri_spec.sess(6).multi_reg = {motion_par_6};
        matlabbatch{1}.spm.stats.fmri_spec.sess(6).hpf = 128;
        
% SHAM own_Mech_1
        matlabbatch{1}.spm.stats.fmri_spec.sess(7).scans =  cellstr(scans_7);
        
        g=1;
        % stim and rating
        matlabbatch{1}.spm.stats.fmri_spec.sess(7).cond(g).name = 'Mech_S_r1';
        matlabbatch{1}.spm.stats.fmri_spec.sess(7).cond(g).onset = Mech.Sham.Run1.stim_onset;
        matlabbatch{1}.spm.stats.fmri_spec.sess(7).cond(g).duration = repmat(0.5,size(Mech.Sham.Run1.stim_onset,1),1);
        matlabbatch{1}.spm.stats.fmri_spec.sess(7).cond(g).tmod = 0;
        matlabbatch{1}.spm.stats.fmri_spec.sess(7).cond(g).pmod.name = 'Mech_S_r1_Rating';
        matlabbatch{1}.spm.stats.fmri_spec.sess(7).cond(g).pmod.param = Mech.Sham.Run1.stim_rating;
        matlabbatch{1}.spm.stats.fmri_spec.sess(7).cond(g).pmod.poly = 1;
        matlabbatch{1}.spm.stats.fmri_spec.sess(7).cond(g).orth = 1;
        % question mark
        if (isempty(Mech.Sham.Run1.quest_onset)==0)
        g=g+1;    
        end
        matlabbatch{1}.spm.stats.fmri_spec.sess(7).cond(g).name = 'mech_quest_S_r1';
        matlabbatch{1}.spm.stats.fmri_spec.sess(7).cond(g).onset = Mech.Sham.Run1.quest_onset;
        matlabbatch{1}.spm.stats.fmri_spec.sess(7).cond(g).duration = Mech.Sham.Run1.quest_duration;
        matlabbatch{1}.spm.stats.fmri_spec.sess(7).cond(g).tmod = 0;
        matlabbatch{1}.spm.stats.fmri_spec.sess(7).cond(g).pmod = struct('name', {}, 'param', {}, 'poly', {});
        matlabbatch{1}.spm.stats.fmri_spec.sess(7).cond(g).orth = 1;
        
        % intro
        g=g+1;
        matlabbatch{1}.spm.stats.fmri_spec.sess(7).cond(g).name = 'mech_intro_S_r1';
        matlabbatch{1}.spm.stats.fmri_spec.sess(7).cond(g).onset = 0;
        matlabbatch{1}.spm.stats.fmri_spec.sess(7).cond(g).duration = 5;
        matlabbatch{1}.spm.stats.fmri_spec.sess(7).cond(g).tmod = 0;
        matlabbatch{1}.spm.stats.fmri_spec.sess(7).cond(g).pmod = struct('name', {}, 'param', {}, 'poly', {});
        matlabbatch{1}.spm.stats.fmri_spec.sess(7).cond(g).orth = 1;
        % extra button press (duration: zero)
        if (isempty(Mech.Sham.Run1.extra_button_press_onset)==0)
        g=g+1;    
            matlabbatch{1}.spm.stats.fmri_spec.sess(7).cond(g).name = 'mech_extra_button_press_onset_S_r1';
            matlabbatch{1}.spm.stats.fmri_spec.sess(7).cond(g).onset = Mech.Sham.Run1.extra_button_press_onset;
            matlabbatch{1}.spm.stats.fmri_spec.sess(7).cond(g).duration = zeros(size(Mech.Sham.Run1.extra_button_press_onset,1),1); 

            matlabbatch{1}.spm.stats.fmri_spec.sess(7).cond(g).tmod = 0;
            matlabbatch{1}.spm.stats.fmri_spec.sess(7).cond(g).pmod = struct('name', {}, 'param', {}, 'poly', {});
            matlabbatch{1}.spm.stats.fmri_spec.sess(7).cond(g).orth = 1;
        end
        
        % right hand button press (duration: zero) !!!NOT ALWAYS PRESENT 
        if (isfield(Mech.Sham.Run1, 'right_hand_button_press_onset')==1)
        g=g+1;    
            matlabbatch{1}.spm.stats.fmri_spec.sess(7).cond(g).name = 'mech_right_hand_button_press_onset_S_r1';
            matlabbatch{1}.spm.stats.fmri_spec.sess(7).cond(g).onset = Mech.Sham.Run1.right_hand_button_press_onset;
            matlabbatch{1}.spm.stats.fmri_spec.sess(7).cond(g).duration = zeros(size(Mech.Sham.Run1.right_hand_button_press_onset,1),1); 

            matlabbatch{1}.spm.stats.fmri_spec.sess(7).cond(g).tmod = 0;
            matlabbatch{1}.spm.stats.fmri_spec.sess(7).cond(g).pmod = struct('name', {}, 'param', {}, 'poly', {});
            matlabbatch{1}.spm.stats.fmri_spec.sess(7).cond(g).orth = 1;
        end
        
        % stim changed rating!!! NOT ALWAYS PRESENT 
        if (isfield(Mech.Sham.Run1, 'stim_changed_rating_onset')==1)
        g=g+1;    
            matlabbatch{1}.spm.stats.fmri_spec.sess(7).cond(g).name = 'mech_stim_changed_rating_onset_S_r1';
            matlabbatch{1}.spm.stats.fmri_spec.sess(7).cond(g).onset = Mech.Sham.Run1.stim_changed_rating_onset;
            matlabbatch{1}.spm.stats.fmri_spec.sess(7).cond(g).duration = zeros(size(Mech.Sham.Run1.stim_changed_rating_onset,1),1); 

            matlabbatch{1}.spm.stats.fmri_spec.sess(7).cond(g).tmod = 0;
            matlabbatch{1}.spm.stats.fmri_spec.sess(7).cond(g).pmod = struct('name', {}, 'param', {}, 'poly', {});
            matlabbatch{1}.spm.stats.fmri_spec.sess(7).cond(g).orth = 1;
        end
        
        matlabbatch{1}.spm.stats.fmri_spec.sess(7).multi = {''};
        matlabbatch{1}.spm.stats.fmri_spec.sess(7).regress = struct('name', {}, 'val', {});
        motion_par_7 = spm_select('FPList',fullfile(task_location_7),'^r*');
        matlabbatch{1}.spm.stats.fmri_spec.sess(7).multi_reg = {motion_par_7};
        matlabbatch{1}.spm.stats.fmri_spec.sess(7).hpf = 128;

%SHAM own_Mech_2
        matlabbatch{1}.spm.stats.fmri_spec.sess(8).scans =  cellstr(scans_8);
        
        h=1;
        % stim and rating
        matlabbatch{1}.spm.stats.fmri_spec.sess(8).cond(h).name = 'Mech_S_r2';
        matlabbatch{1}.spm.stats.fmri_spec.sess(8).cond(h).onset = Mech.Sham.Run2.stim_onset;
        matlabbatch{1}.spm.stats.fmri_spec.sess(8).cond(h).duration = repmat(0.5,size(Mech.Sham.Run2.stim_onset,1),1);
        matlabbatch{1}.spm.stats.fmri_spec.sess(8).cond(h).tmod = 0;
        matlabbatch{1}.spm.stats.fmri_spec.sess(8).cond(h).pmod.name = 'Mech_S_r2_Rating';
        matlabbatch{1}.spm.stats.fmri_spec.sess(8).cond(h).pmod.param = Mech.Sham.Run2.stim_rating;
        matlabbatch{1}.spm.stats.fmri_spec.sess(8).cond(h).pmod.poly = 1;
        matlabbatch{1}.spm.stats.fmri_spec.sess(8).cond(h).orth = 1;
        % question mark
        if (isempty(Mech.Sham.Run2.quest_onset)==0)
        h=h+1;    
        end
        matlabbatch{1}.spm.stats.fmri_spec.sess(8).cond(h).name = 'mech_quest_S_r2';
        matlabbatch{1}.spm.stats.fmri_spec.sess(8).cond(h).onset = Mech.Sham.Run2.quest_onset;
        matlabbatch{1}.spm.stats.fmri_spec.sess(8).cond(h).duration = Mech.Sham.Run2.quest_duration;
        matlabbatch{1}.spm.stats.fmri_spec.sess(8).cond(h).tmod = 0;
        matlabbatch{1}.spm.stats.fmri_spec.sess(8).cond(h).pmod = struct('name', {}, 'param', {}, 'poly', {});
        matlabbatch{1}.spm.stats.fmri_spec.sess(8).cond(h).orth = 1;
        % intro
        h=h+1;
        matlabbatch{1}.spm.stats.fmri_spec.sess(8).cond(h).name = 'mech_intro_S_r2';
        matlabbatch{1}.spm.stats.fmri_spec.sess(8).cond(h).onset = 0;
        matlabbatch{1}.spm.stats.fmri_spec.sess(8).cond(h).duration = 5;
        matlabbatch{1}.spm.stats.fmri_spec.sess(8).cond(h).tmod = 0;
        matlabbatch{1}.spm.stats.fmri_spec.sess(8).cond(h).pmod = struct('name', {}, 'param', {}, 'poly', {});
        matlabbatch{1}.spm.stats.fmri_spec.sess(8).cond(h).orth = 1;
        % extra button press (duration: zero)
        if (isempty(Mech.Sham.Run2.extra_button_press_onset)==0)
        h=h+1;    
            matlabbatch{1}.spm.stats.fmri_spec.sess(8).cond(h).name = 'mech_extra_button_press_onset_S_r2';
            matlabbatch{1}.spm.stats.fmri_spec.sess(8).cond(h).onset = Mech.Sham.Run2.extra_button_press_onset;
            matlabbatch{1}.spm.stats.fmri_spec.sess(8).cond(h).duration = zeros(size(Mech.Sham.Run2.extra_button_press_onset,1),1); 

            matlabbatch{1}.spm.stats.fmri_spec.sess(8).cond(h).tmod = 0;
            matlabbatch{1}.spm.stats.fmri_spec.sess(8).cond(h).pmod = struct('name', {}, 'param', {}, 'poly', {});
            matlabbatch{1}.spm.stats.fmri_spec.sess(8).cond(h).orth = 1;
        end
        
        % right hand button press (duration: zero) !!!NOT ALWAYS PRESENT 
        if (isfield(Mech.Sham.Run2, 'right_hand_button_press_onset')==1)
        h=h+1;    
            matlabbatch{1}.spm.stats.fmri_spec.sess(8).cond(h).name = 'mech_right_hand_button_press_onset_S_r2';
            matlabbatch{1}.spm.stats.fmri_spec.sess(8).cond(h).onset = Mech.Sham.Run2.right_hand_button_press_onset;
            matlabbatch{1}.spm.stats.fmri_spec.sess(8).cond(h).duration = zeros(size(Mech.Sham.Run2.right_hand_button_press_onset,1),1); 

            matlabbatch{1}.spm.stats.fmri_spec.sess(8).cond(h).tmod = 0;
            matlabbatch{1}.spm.stats.fmri_spec.sess(8).cond(h).pmod = struct('name', {}, 'param', {}, 'poly', {});
            matlabbatch{1}.spm.stats.fmri_spec.sess(8).cond(h).orth = 1;
        end
        
        % stim changed rating!!! NOT ALWAYS PRESENT 
        if (isfield(Mech.Sham.Run2, 'stim_changed_rating_onset')==1)
        h=h+1;    
            matlabbatch{1}.spm.stats.fmri_spec.sess(8).cond(h).name = 'mech_stim_changed_rating_onset_S_r2';
            matlabbatch{1}.spm.stats.fmri_spec.sess(8).cond(h).onset = Mech.Sham.Run2.stim_changed_rating_onset;
            matlabbatch{1}.spm.stats.fmri_spec.sess(8).cond(h).duration = zeros(size(Mech.Sham.Run2.stim_changed_rating_onset,1),1); 

            matlabbatch{1}.spm.stats.fmri_spec.sess(8).cond(h).tmod = 0;
            matlabbatch{1}.spm.stats.fmri_spec.sess(8).cond(h).pmod = struct('name', {}, 'param', {}, 'poly', {});
            matlabbatch{1}.spm.stats.fmri_spec.sess(8).cond(h).orth = 1;
        end
        
        matlabbatch{1}.spm.stats.fmri_spec.sess(8).multi = {''};
        matlabbatch{1}.spm.stats.fmri_spec.sess(8).regress = struct('name', {}, 'val', {});
        motion_par_8 = spm_select('FPList',fullfile(task_location_8),'^r*');
        matlabbatch{1}.spm.stats.fmri_spec.sess(8).multi_reg = {motion_par_8};
        matlabbatch{1}.spm.stats.fmri_spec.sess(8).hpf = 128;
%
        
        % END OF THE GLM
        matlabbatch{1}.spm.stats.fmri_spec.fact = struct('name', {}, 'levels', {});
        matlabbatch{1}.spm.stats.fmri_spec.bases.hrf.derivs = [0 0];
        matlabbatch{1}.spm.stats.fmri_spec.volt = 1;
        matlabbatch{1}.spm.stats.fmri_spec.global = 'None';
        matlabbatch{1}.spm.stats.fmri_spec.mthresh = 0.8;
        matlabbatch{1}.spm.stats.fmri_spec.mask = {''};
        matlabbatch{1}.spm.stats.fmri_spec.cvi = 'AR(1)';
        
       spm_jobman('run',matlabbatch);
  
        %clearvars -except Session Task sbjnum basepath filenames xlslist Sub Subject_i
% estimate GLM
        spm_jobman('initCfg');
    
        basepath = ['R:\ROOP\ROOP_fMRI\Subject_' num2str(Subject_i) '_p1'];
        SPM_location = sprintf('%s%sResults_Subj_level%sResultsSELF%sQuestMarkAndExtraPress',basepath,filesep, filesep,filesep)
        SPM = spm_select('FPList',fullfile(SPM_location),'SPM.mat');
        
        matlabbatch = cell(1,1);

        matlabbatch{1}.spm.stats.fmri_est.spmmat = cellstr(SPM);
        matlabbatch{1}.spm.stats.fmri_est.write_residuals = 0;
        matlabbatch{1}.spm.stats.fmri_est.method.Classical = 1;
        
        spm_jobman('run',matlabbatch);
        
        %% contrasts
        
        spm_jobman('initCfg');
        basepath = ['R:\ROOP\ROOP_fMRI\Subject_' num2str(Subject_i) '_p1'];
        SPM_location = sprintf('%s%sResults_Subj_level%sResultsSELF%sQuestMarkAndExtraPress',basepath,filesep, filesep,filesep)
        SPM = spm_select('FPList',fullfile(SPM_location),'SPM.mat');
               
        load('R:\ROOP\ROOP_fMRI\Batches\script_v2_selene\contrasts_PlusOnlyMod.mat');

        contrasts.(sprintf('Subject_%d',Subject_i))

                matlabbatch = cell(1,1);

        matlabbatch{1}.spm.stats.con.spmmat = {SPM};
        %1
        matlabbatch{1}.spm.stats.con.consess{1}.tcon.name = 'ShockMRealShamMinusBS';
        matlabbatch{1}.spm.stats.con.consess{1}.tcon.weights = contrasts.(sprintf('Subject_%d',Subject_i)).ShockMRealShamMinusBS;
        matlabbatch{1}.spm.stats.con.consess{1}.tcon.sessrep = 'none';
        %2
        matlabbatch{1}.spm.stats.con.consess{2}.tcon.name = 'ShockMRealMinusBS';
        matlabbatch{1}.spm.stats.con.consess{2}.tcon.weights = contrasts.(sprintf('Subject_%d',Subject_i)).ShockMRealMinusBS;
        matlabbatch{1}.spm.stats.con.consess{2}.tcon.sessrep = 'none';
        %3
        matlabbatch{1}.spm.stats.con.consess{3}.tcon.name = 'ShockMShamMinusBS';
        matlabbatch{1}.spm.stats.con.consess{3}.tcon.weights = contrasts.(sprintf('Subject_%d',Subject_i)).ShockMShamMinusBS;
        matlabbatch{1}.spm.stats.con.consess{3}.tcon.sessrep = 'none';
        %4
        matlabbatch{1}.spm.stats.con.consess{4}.tcon.name = 'MechMRealShamMMinusBS';
        matlabbatch{1}.spm.stats.con.consess{4}.tcon.weights = contrasts.(sprintf('Subject_%d',Subject_i)).MechMRealShamMMinusBS;
        matlabbatch{1}.spm.stats.con.consess{4}.tcon.sessrep = 'none';
        %5
        matlabbatch{1}.spm.stats.con.consess{5}.tcon.name = 'MechMRealMinusBS';
        matlabbatch{1}.spm.stats.con.consess{5}.tcon.weights = contrasts.(sprintf('Subject_%d',Subject_i)).MechMRealMinusBS;
        matlabbatch{1}.spm.stats.con.consess{5}.tcon.sessrep = 'none';
        %6
        matlabbatch{1}.spm.stats.con.consess{6}.tcon.name = 'MechMShamMinusBS';
        matlabbatch{1}.spm.stats.con.consess{6}.tcon.weights = contrasts.(sprintf('Subject_%d',Subject_i)).MechMShamMinusBS;
        matlabbatch{1}.spm.stats.con.consess{6}.tcon.sessrep = 'none';
        %7
        matlabbatch{1}.spm.stats.con.consess{7}.tcon.name = 'MechRealShamMinusShockRealSham';
        matlabbatch{1}.spm.stats.con.consess{7}.tcon.weights = contrasts.(sprintf('Subject_%d',Subject_i)).MechRealShamMinusShockRealSham;
        matlabbatch{1}.spm.stats.con.consess{7}.tcon.sessrep = 'none';
        %8
        matlabbatch{1}.spm.stats.con.consess{8}.tcon.name = 'MechRealMinusShockReal';
        matlabbatch{1}.spm.stats.con.consess{8}.tcon.weights = contrasts.(sprintf('Subject_%d',Subject_i)).MechRealMinusShockReal;
        matlabbatch{1}.spm.stats.con.consess{8}.tcon.sessrep = 'none';
        %9
        matlabbatch{1}.spm.stats.con.consess{9}.tcon.name = 'MechShamMinusShockSham';
        matlabbatch{1}.spm.stats.con.consess{9}.tcon.weights = contrasts.(sprintf('Subject_%d',Subject_i)).MechShamMinusShockSham;
        matlabbatch{1}.spm.stats.con.consess{9}.tcon.sessrep = 'none';
        %10
        matlabbatch{1}.spm.stats.con.consess{10}.tcon.name = 'MechMRealShamMinusShockMRealSham';
        matlabbatch{1}.spm.stats.con.consess{10}.tcon.weights = contrasts.(sprintf('Subject_%d',Subject_i)).MechMRealShamMinusShockMRealSham;
        matlabbatch{1}.spm.stats.con.consess{10}.tcon.sessrep = 'none';
        %11
        matlabbatch{1}.spm.stats.con.consess{11}.tcon.name = 'MechMRealMinusShockMReal';
        matlabbatch{1}.spm.stats.con.consess{11}.tcon.weights = contrasts.(sprintf('Subject_%d',Subject_i)).MechMRealMinusShockMReal;
        matlabbatch{1}.spm.stats.con.consess{11}.tcon.sessrep = 'none';
        %12
        matlabbatch{1}.spm.stats.con.consess{12}.tcon.name = 'MechMShamMinusMShockSham';
        matlabbatch{1}.spm.stats.con.consess{12}.tcon.weights = contrasts.(sprintf('Subject_%d',Subject_i)).MechMShamMinusMShockSham;
        matlabbatch{1}.spm.stats.con.consess{12}.tcon.sessrep = 'none';
        %13
        matlabbatch{1}.spm.stats.con.consess{13}.tcon.name = 'ShockRealShamMinusMechRealSham';
        matlabbatch{1}.spm.stats.con.consess{13}.tcon.weights = contrasts.(sprintf('Subject_%d',Subject_i)).ShockRealShamMinusMechRealSham;
        matlabbatch{1}.spm.stats.con.consess{13}.tcon.sessrep = 'none';
        %14
        matlabbatch{1}.spm.stats.con.consess{14}.tcon.name = 'ShockRealMinusMechReal';
        matlabbatch{1}.spm.stats.con.consess{14}.tcon.weights = contrasts.(sprintf('Subject_%d',Subject_i)).ShockRealMinusMechReal;
        matlabbatch{1}.spm.stats.con.consess{14}.tcon.sessrep = 'none';
        %15
        matlabbatch{1}.spm.stats.con.consess{15}.tcon.name = 'ShockShamMinusMechSham';
        matlabbatch{1}.spm.stats.con.consess{15}.tcon.weights = contrasts.(sprintf('Subject_%d',Subject_i)).ShockShamMinusMechSham;
        matlabbatch{1}.spm.stats.con.consess{15}.tcon.sessrep = 'none';
        %16
        matlabbatch{1}.spm.stats.con.consess{16}.tcon.name = 'ShockMRealShamMinusMechMRealSham';
        matlabbatch{1}.spm.stats.con.consess{16}.tcon.weights = contrasts.(sprintf('Subject_%d',Subject_i)).ShockMRealShamMinusMechMRealSham;
        matlabbatch{1}.spm.stats.con.consess{16}.tcon.sessrep = 'none';
        %17
        matlabbatch{1}.spm.stats.con.consess{17}.tcon.name = 'ShockMRealMinusMechMReal';
        matlabbatch{1}.spm.stats.con.consess{17}.tcon.weights = contrasts.(sprintf('Subject_%d',Subject_i)).ShockMRealMinusMechMReal;
        matlabbatch{1}.spm.stats.con.consess{17}.tcon.sessrep = 'none';
        %18
        matlabbatch{1}.spm.stats.con.consess{18}.tcon.name = 'ShockMShamMinusMechMSham';
        matlabbatch{1}.spm.stats.con.consess{18}.tcon.weights = contrasts.(sprintf('Subject_%d',Subject_i)).ShockMShamMinusMechMSham;
        matlabbatch{1}.spm.stats.con.consess{18}.tcon.sessrep = 'none';
        %19
        matlabbatch{1}.spm.stats.con.consess{19}.tcon.name = 'ShockRealMechRealMinusShockShamMechSham';
        matlabbatch{1}.spm.stats.con.consess{19}.tcon.weights = contrasts.(sprintf('Subject_%d',Subject_i)).ShockRealMechRealMinusShockShamMechSham;
        matlabbatch{1}.spm.stats.con.consess{19}.tcon.sessrep = 'none';
        %20
        matlabbatch{1}.spm.stats.con.consess{20}.tcon.name = 'ShockShamMechShamMinusShockRealMechReal';
        matlabbatch{1}.spm.stats.con.consess{20}.tcon.weights = contrasts.(sprintf('Subject_%d',Subject_i)).ShockShamMechShamMinusShockRealMechReal;
        matlabbatch{1}.spm.stats.con.consess{20}.tcon.sessrep = 'none';
        %21
        matlabbatch{1}.spm.stats.con.consess{21}.tcon.name = 'ShockMRealMechMRealMinusShockMShamMechMSham';
        matlabbatch{1}.spm.stats.con.consess{21}.tcon.weights = contrasts.(sprintf('Subject_%d',Subject_i)).ShockMRealMechMRealMinusShockMShamMechMSham;
        matlabbatch{1}.spm.stats.con.consess{21}.tcon.sessrep = 'none';
        %22
        matlabbatch{1}.spm.stats.con.consess{22}.tcon.name = 'ShockMShamMechMShamMinusShockMRealMechMReal';
        matlabbatch{1}.spm.stats.con.consess{22}.tcon.weights = contrasts.(sprintf('Subject_%d',Subject_i)).ShockMShamMechMShamMinusShockMRealMechMReal;
        matlabbatch{1}.spm.stats.con.consess{22}.tcon.sessrep = 'none';
        %23
        matlabbatch{1}.spm.stats.con.consess{23}.tcon.name = 'ShockRealMinusShockSham';
        matlabbatch{1}.spm.stats.con.consess{23}.tcon.weights = contrasts.(sprintf('Subject_%d',Subject_i)).ShockRealMinusShockSham;
        matlabbatch{1}.spm.stats.con.consess{23}.tcon.sessrep = 'none';
        
        %24
        matlabbatch{1}.spm.stats.con.consess{24}.tcon.name = 'ShockShamMinusShockReal';
        matlabbatch{1}.spm.stats.con.consess{24}.tcon.weights = contrasts.(sprintf('Subject_%d',Subject_i)).ShockShamMinusShockReal;
        matlabbatch{1}.spm.stats.con.consess{24}.tcon.sessrep = 'none';
        %25
        matlabbatch{1}.spm.stats.con.consess{25}.tcon.name = 'ShockMRealMinusShockMSham';
        matlabbatch{1}.spm.stats.con.consess{25}.tcon.weights = contrasts.(sprintf('Subject_%d',Subject_i)).ShockMRealMinusShockMSham;
        matlabbatch{1}.spm.stats.con.consess{25}.tcon.sessrep = 'none';
        %26
        matlabbatch{1}.spm.stats.con.consess{26}.tcon.name = 'ShockMShamMinusShockMReal';
        matlabbatch{1}.spm.stats.con.consess{26}.tcon.weights = contrasts.(sprintf('Subject_%d',Subject_i)).ShockMShamMinusShockMReal;
        matlabbatch{1}.spm.stats.con.consess{26}.tcon.sessrep = 'none';
        %27
        matlabbatch{1}.spm.stats.con.consess{27}.tcon.name = 'MechRealMinusMechSham';
        matlabbatch{1}.spm.stats.con.consess{27}.tcon.weights = contrasts.(sprintf('Subject_%d',Subject_i)).MechRealMinusMechSham;
        matlabbatch{1}.spm.stats.con.consess{27}.tcon.sessrep = 'none';
        %28
        matlabbatch{1}.spm.stats.con.consess{28}.tcon.name = 'MechShamMinusMechReal';
        matlabbatch{1}.spm.stats.con.consess{28}.tcon.weights = contrasts.(sprintf('Subject_%d',Subject_i)).MechShamMinusMechReal;
        matlabbatch{1}.spm.stats.con.consess{28}.tcon.sessrep = 'none';
        %29
        matlabbatch{1}.spm.stats.con.consess{29}.tcon.name = 'MechMRealMinusMechMSham';
        matlabbatch{1}.spm.stats.con.consess{29}.tcon.weights = contrasts.(sprintf('Subject_%d',Subject_i)).MechMRealMinusMechMSham;
        matlabbatch{1}.spm.stats.con.consess{29}.tcon.sessrep = 'none';
        %30
        matlabbatch{1}.spm.stats.con.consess{30}.tcon.name = 'MechShamMMinusMechMReal';
        matlabbatch{1}.spm.stats.con.consess{30}.tcon.weights = contrasts.(sprintf('Subject_%d',Subject_i)).MechShamMMinusMechMReal;
        matlabbatch{1}.spm.stats.con.consess{30}.tcon.sessrep = 'none';
        %31
        matlabbatch{1}.spm.stats.con.consess{31}.tcon.name = 'QuestMark';
        matlabbatch{1}.spm.stats.con.consess{31}.tcon.weights = contrasts.(sprintf('Subject_%d',Subject_i)).QuestMark;
        matlabbatch{1}.spm.stats.con.consess{31}.tcon.sessrep = 'none';
        
         %1
        matlabbatch{1}.spm.stats.con.consess{32}.tcon.name = 'ShockOnlyMRealShamMinusBS';
        matlabbatch{1}.spm.stats.con.consess{32}.tcon.weights = contrasts.(sprintf('Subject_%d',Subject_i)).ShockOnlyMRealShamMinusBS;
        matlabbatch{1}.spm.stats.con.consess{32}.tcon.sessrep = 'none';
        %2
        matlabbatch{1}.spm.stats.con.consess{33}.tcon.name = 'MechOnlyMRealShamMMinusBS';
        matlabbatch{1}.spm.stats.con.consess{33}.tcon.weights = contrasts.(sprintf('Subject_%d',Subject_i)).MechOnlyMRealShamMMinusBS;
        matlabbatch{1}.spm.stats.con.consess{33}.tcon.sessrep = 'none';
        %3
        matlabbatch{1}.spm.stats.con.consess{34}.tcon.name = 'MechOnlyMRealShamMinusShockOnlyMRealSham';
        matlabbatch{1}.spm.stats.con.consess{34}.tcon.weights = contrasts.(sprintf('Subject_%d',Subject_i)).MechOnlyMRealShamMinusShockOnlyMRealSham;
        matlabbatch{1}.spm.stats.con.consess{34}.tcon.sessrep = 'none';
        %4
        matlabbatch{1}.spm.stats.con.consess{35}.tcon.name = 'MechOnlyMRealMinusShockOnlyMReal';
        matlabbatch{1}.spm.stats.con.consess{35}.tcon.weights = contrasts.(sprintf('Subject_%d',Subject_i)).MechOnlyMRealMinusShockOnlyMReal;
        matlabbatch{1}.spm.stats.con.consess{35}.tcon.sessrep = 'none';
        %5
        matlabbatch{1}.spm.stats.con.consess{36}.tcon.name = 'MechOnlyMShamMinusShockOnlyMSham';
        matlabbatch{1}.spm.stats.con.consess{36}.tcon.weights = contrasts.(sprintf('Subject_%d',Subject_i)).MechOnlyMShamMinusShockOnlyMSham;
        matlabbatch{1}.spm.stats.con.consess{36}.tcon.sessrep = 'none';
        %6
        matlabbatch{1}.spm.stats.con.consess{37}.tcon.name = 'ShockOnlyMRealShamMinusMechOnlyMRealSham';
        matlabbatch{1}.spm.stats.con.consess{37}.tcon.weights = contrasts.(sprintf('Subject_%d',Subject_i)).ShockOnlyMRealShamMinusMechOnlyMRealSham;
        matlabbatch{1}.spm.stats.con.consess{37}.tcon.sessrep = 'none';
        %7
        matlabbatch{1}.spm.stats.con.consess{38}.tcon.name = 'ShockOnlyMRealMinusMechOnlyMReal';
        matlabbatch{1}.spm.stats.con.consess{38}.tcon.weights = contrasts.(sprintf('Subject_%d',Subject_i)).ShockOnlyMRealMinusMechOnlyMReal;
        matlabbatch{1}.spm.stats.con.consess{38}.tcon.sessrep = 'none';
        %8
        matlabbatch{1}.spm.stats.con.consess{39}.tcon.name = 'ShockOnlyMShamMinusMechOnlyMSham';
        matlabbatch{1}.spm.stats.con.consess{39}.tcon.weights = contrasts.(sprintf('Subject_%d',Subject_i)).ShockOnlyMShamMinusMechOnlyMSham;
        matlabbatch{1}.spm.stats.con.consess{39}.tcon.sessrep = 'none';
        %9
        matlabbatch{1}.spm.stats.con.consess{40}.tcon.name = 'ShockOnlyMRealMechOnlyMRealMinusShockOnlyMShamMechOnlyMSham';
        matlabbatch{1}.spm.stats.con.consess{40}.tcon.weights = contrasts.(sprintf('Subject_%d',Subject_i)).ShockOnlyMRealMechOnlyMRealMinusShockOnlyMShamMechOnlyMSham;
        matlabbatch{1}.spm.stats.con.consess{40}.tcon.sessrep = 'none';
        %10
        matlabbatch{1}.spm.stats.con.consess{41}.tcon.name = 'ShockOnlyMShamMechOnlyMShamMinusShockOnlyMRealMechOnlyMReal';
        matlabbatch{1}.spm.stats.con.consess{41}.tcon.weights = contrasts.(sprintf('Subject_%d',Subject_i)).ShockOnlyMShamMechOnlyMShamMinusShockOnlyMRealMechOnlyMReal;
        matlabbatch{1}.spm.stats.con.consess{41}.tcon.sessrep = 'none';
        %11
        matlabbatch{1}.spm.stats.con.consess{42}.tcon.name = 'ShockOnlyMRealMinusShockOnlyMSham';
        matlabbatch{1}.spm.stats.con.consess{42}.tcon.weights = contrasts.(sprintf('Subject_%d',Subject_i)).ShockOnlyMRealMinusShockOnlyMSham;
        matlabbatch{1}.spm.stats.con.consess{42}.tcon.sessrep = 'none';
        %12
        matlabbatch{1}.spm.stats.con.consess{43}.tcon.name = 'ShockOnlyMShamMinusShockOnlyMReal';
        matlabbatch{1}.spm.stats.con.consess{43}.tcon.weights = contrasts.(sprintf('Subject_%d',Subject_i)).ShockOnlyMShamMinusShockOnlyMReal;
        matlabbatch{1}.spm.stats.con.consess{43}.tcon.sessrep = 'none';
        %13
        matlabbatch{1}.spm.stats.con.consess{44}.tcon.name = 'MechOnlyMRealMinusMechOnlyMSham';
        matlabbatch{1}.spm.stats.con.consess{44}.tcon.weights = contrasts.(sprintf('Subject_%d',Subject_i)).MechOnlyMRealMinusMechOnlyMSham;
        matlabbatch{1}.spm.stats.con.consess{44}.tcon.sessrep = 'none';
        %14
        matlabbatch{1}.spm.stats.con.consess{45}.tcon.name = 'MechShamOnlyMMinusMechOnlyMReal';
        matlabbatch{1}.spm.stats.con.consess{45}.tcon.weights = contrasts.(sprintf('Subject_%d',Subject_i)).MechShamOnlyMMinusMechOnlyMReal;
        matlabbatch{1}.spm.stats.con.consess{45}.tcon.sessrep = 'none';
        %15
        matlabbatch{1}.spm.stats.con.consess{46}.tcon.name = 'ShockOnlyMRealShamANDMechOnlyMRealSham';
        matlabbatch{1}.spm.stats.con.consess{46}.tcon.weights = contrasts.(sprintf('Subject_%d',Subject_i)).ShockOnlyMRealShamANDMechOnlyMRealSham;
        matlabbatch{1}.spm.stats.con.consess{46}.tcon.sessrep = 'none';
        %16
        matlabbatch{1}.spm.stats.con.consess{47}.tcon.name = 'ShockRealShamANDMechRealSham';
        matlabbatch{1}.spm.stats.con.consess{47}.tcon.weights = contrasts.(sprintf('Subject_%d',Subject_i)).ShockRealShamANDMechRealSham;
        matlabbatch{1}.spm.stats.con.consess{47}.tcon.sessrep = 'none';
        
       
        matlabbatch{1}.spm.stats.con.delete = 1;
       
        spm_jobman('run',matlabbatch);
        
end % sbj
