
% HELPING EEG BEHAVIORAL 
%
%
% Authors: Selene
%
%
% date: 21st of July 2015 


%data name suffice legend:
% s -> data segmented
% c -> data cleaned by muscle artifacts rejection
% i -> data cleaned by ica
clear all; close all;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%define variable

sbj     = 22; %subject number
task    = 1; %task: 1: face, 2: hand


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% PREPROCESSING
ft_defaults

%fieldtrip path
addpath('C:\fieldtrip-20141201');
datapath = 'C:\Users\SBL 2\Documents\MATLAB\HB_Script_July2015\EEG Data';

switch task
    case 1
        t= 'face';
        ta= 'F_';
        def_int_a= [2	2   2	2	2	2	2	2	2	2	2	2	2	2	2	2	2	2	2	2	2	2	2	2	2	2	2	2	2	2	2	3	3	3	3	3	3	3	3	3	3	3	3	3	3	3	3	3	3	3	3	4	4	4	4	4	4	4	4	4	4	4	4	4	4	5	5	5	5	5	5	5	5	6	6	6	6	6	6	6	7];
        nostring_m_name= ['S  3';'S 72'; 'S 12';'S 21';'S 22';'S 25';'S 51';'S 52';'S 53';'S 61';'S 62';'S 63';'S 71';'S 81';'S 82';'S 83';'S 84';'S 91';'S 92';'S  5';'S102';'S103';'S104';'S  7';'S112';'S113';'S114';'S121';'S122';'S123';'S124';'S 13';'S 15';'S 23';'S 24';'S 54';'S 65';'S 73';'S 74';'S 76';'S 78';'S 93';'S 94';'S 95';'S 97';'S105';'S107';'S115';'S116';'S117';'S125';'S 17';'S 26';'S 27';'S 55';'S 64';'S 75';'S 77';'S 96';'S 98';'S106';'S108';'S118';'S126';'S127';'S 14';'S 37';'S 56';'S 57';'S 66';	'S 85';	'S 88';	'S128';	'S 16';	'S 18';	'S 28';	'S 67';	'S 68';	'S 86';	'S 87';'S 58'];
        m_name=cellstr(nostring_m_name);
        
    case 2
        t= 'hand';
        ta= 'H_';
        def_int_a= [2   2	2	2	2	2	2	2	2	2	2	2	2	2	2	2	2	2	2	3	3	3	3	3	3	3	3	3	3	3	3	3	3	3	3	3	3	3	3	3	3	3	3	3	3	3	4	4	4	4	4	4	4	4	4	4	4	4	4	4	4	4	4	4	4	4	4	4	4	4	4	4	4	4	4	4	5	5	5	5	5	5	5	5	5	5	5	5	5	5	5	5	5	5	5	6];
        nostring_m_name= ['S221'; 'S  3';'S 21';'S 31';'S 41';'S 51';'S 61';'S 71';'S 81';'S 91';'S  5';'S  7';'S121';'S131';'S152';'S181';'S191';'S211';'S 12';'S 22';'S 23';'S 24';'S 32';'S 42';'S 52';'S 62';'S 72';'S102';'S112';'S124';'S132';'S141';'S151';'S161';'S171';'S172';'S183';'S192';'S201';'S212';'S213';'S223';'S231';'S232';'S241';'S242';'S 13';'S 14';'S 33';'S 43';'S 53';'S 73';'S 83';'S 84';'S 92';'S 93';'S103';'S104';'S122';'S123';'S133';'S142';'S143';'S144';'S162';'S164';'S173';'S182';'S193';'S194';'S202';'S203';'S214';'S222';'S243';'S244';'S 34';'S 44';'S 63';'S 64';'S 74';'S 82';'S 94';'S113';'S114';'S134';'S153';'S154';'S163';'S174';'S184';'S204';'S224';'S233';'S234';'S 54'];
        m_name=cellstr(nostring_m_name);
end

%load donation matrix
don_file= ([t '_don']);
load(don_file);

%define the data
headerfile = [datapath '\part' num2str(sbj) '_moral_' t '.vhdr']; 
datafile    = [datapath '\part' num2str(sbj) '_moral_' t '.eeg'];

%PREPROCESSING
cfg = [];
cfg.dataset = headerfile; 
% Select only 64 channels
cfg.channel = 1:64;

% % notch filter = multiple band stop filters
cfg.bsfilter = 'yes';
cfg.bsfreq = [49 51; 99 101; 149 151; 199 201];

% % low pass filter
cfg.lpfilter = 'yes';
cfg.lpfreq = 60;  % Select frequencies between 4 and 60 Hz


% Re-reference the signal to common average
cfg.reref = 'yes';
cfg.refchannel = 'all';
cfg.demean = 'yes';
cfg.detrend= 'yes';

%segmentation in epoch of interest
% Define trials and segment dataset
cfg.trialfun                = 'HELPING_EEGtrialfun'; % this is my function, change it according to which movie you are analising

%add to cfg the variable you need for defining the trials
cfg.subject     = sbj;
cfg.def_int_a   = def_int_a ;
def_int         = def_int_a';
cfg.m_name      = m_name;
cfg.donation    = don;

%defintion of trial length
cfg.trialdef.pre            = 4.5; % in seconds
cfg.trialdef.post           = 2.5; % in seconds

cfg = ft_definetrial(cfg);

s_data = ft_preprocessing(cfg);

%%
%  visual inspection for muscle artifact rejection
data= s_data;

cfg=[];
cfg.viewmode = 'vertical';  %string, 'butterfly', 'vertical', 'component'
cfg.continuous = 'no';
cfg.continuous = 'no';
artifact = ft_databrowser(cfg, data);

c_data = ft_rejectartifact(artifact, data);

  
  % save the clean data
save([ta 'sbj' num2str(sbj) '_c_data.mat' ],'c_data');


%%
%ica for ocular movements
%INDEP COMPONENT ANALYSIS for removing artifacts

%prepare layout
% cfg = [];
% cfg.image = '64ch_map.png';
% lay = ft_prepare_layout(cfg);
% 
%display the components in topographic maps
%%layout: http://fieldtrip.fcdonders.nl/template/layout

data= c_data;

cfg = [];

cfg.method = 'runica'; % this is the default and uses the implementation from EEGLAB
cfg.numcomponent = 30;
comp = ft_componentanalysis(cfg, data);

cfg              = [];
cfg.component = [1:30];       % specify the component(s) that should be plotted
cfg.layout    = 'activecap64_modlay.mat'; % specify the layout file that should be used for plotting
cfg.comment   = 'no';
cfg.title     = 'auto';
ft_topoplotIC(cfg, comp)

%plot the component in timeline
cfg = [];
%cfg.component = [1];
cfg.channel = {'runica001'; 'runica002'; 'runica003'; 'runica004'; 'runica005'; 'runica006'};
cfg.layout = 'activecap64_modlay.mat'; % specify the layout file that should be used for plotting
cfg.viewmode = 'component';
cfg.plotlabels = 'yes';

ft_databrowser(cfg, comp)

%%
%reject components !!! every time you run a ICA the indeces of the
%components change
cfg =[];
cfg. component= [1 2]; %list of the components to be removed [1 2 6]
ics_data = ft_rejectcomponent(cfg,comp);

%%

%visual double check
cfg=[];
cfg.viewmode = 'vertical';  %string, 'butterfly', 'vertical', 'component'
cfg.channel = {'Ch8'; 'Ch25'; 'Ch49'}; %this is the channel we will analyse, in case it changes, change it also here
cfg.trial=ics_data.trial;
cfg.continuous = 'no';

artifact=ft_databrowser(cfg,ics_data);

ics_data = ft_rejectartifact(artifact, ics_data);

% save
filename= [ta 'sbj' num2str(sbj) '_ics_data.mat' ];
save(filename,'ics_data');

%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%  MANUALLY chech oif donation and intesity in the eeg file corresponds to
%  the one the event ide file

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
