% HELPING JULY 2016

% 01 TIME LOCK analysis

%% Path & co
clear all
%addpath('C:\fieldtrip-20160118') % seles laptop
addpath('C:\fieldtrip-20160401')
ft_defaults

% #1
datapath='E:\EXPERIMENTS\MDT_EEG\ANALYSIS_SEPT2015\Preprocessed_Data\';
timelock_datapath='C:\Users\gallo\Dropbox (Social Brain Lab)\HELPING_S1_EEGTMS\EEG_analysis\script\RESULTS\timefreq_data_sta';
% subjexts list excluding unbelievers
subjects=[1:3 6:10 12:22 24:32];
nsubjects = length(subjects);

%% baseline correction

allERP=cell(nsubjects,2); % (:,1)-->face (:,2)-->hand
allSlopes=cell(nsubjects,2); % (:,1)-->face (:,2)-->hand

for task =[1 2]; 
switch task
    case 1 %face
        ta= 'F_';
    case 2 %hand[
        ta= 'H_';
end


for s = 1%1:nsubjects
   sbj=subjects(s);
   load([datapath ta 'sbj' num2str(sbj) '_ics_data.mat' ]);
   data=ics_data;
   
   disp(['******************* SUBJECT' num2str(sbj) 'TASK ' ta '***********************'])
%% BASELINE CORRECTION

    cfg=[];
    cfg.baseline     =  [-2.4 -2.2]; % black during the cross
    data_bs=ft_timelockbaseline(cfg,data);
    data= data_bs;
%% ERP CALCULATION (avg movies)
    cfg=[];
    cfg.vartrllength       = 0;
    cfg.covariance        = 'yes';
    cfg.covariancewindow ='all'; %[-1 1]; during movie %[-2 -1]; use fix time
    erp= ft_timelockanalysis(cfg, data_bs);
    
    allERP{s,task}=erp;

%% SLOPE CALCULATION only during movie
exampledata=erp;
exampledata.avg(:,:)=nan;
moviestart_timeind= find(exampledata.time==-1);
movieend_timeind= find(exampledata.time==1);
donation= data.trialinfo(:,2);

 for ch=1:length(exampledata.label);
     
     for time=moviestart_timeind:movieend_timeind
      value=data.trial(:,ch,time);
 
%  ROBUST FIT ROBUST LINEAR REGRESSION
%     B = robustfit(X,Y) returns the vector B of regression coefficients,
%     obtained by performing robust regression to estimate the linear model
%     Y = Xb.  X is an n-by-p matrix of predictor variables, and Y is an
%     n-by-1 vector of observations.  The algorithm uses iteratively
%     reweighted least squares with the bisquare weighting function.  By
%     default, robustfit adds a column of ones to X, corresponding to a
%     constant term in the first element of B.  Do not enter a column of ones
%     directly into the X matrix.

 [p] = robustfit(value,donation);  % p=[intercept slope]
 
  exampledata.avg(ch,time)=p(2);
     end %time
 end % channels
  allSlopes{s,task}=exampledata;
end % sbj
end % task

save('allSlopes_timelock.mat', 'allSlopes')
save('allERP_timelock.mat', 'allERP')