%%  Paths and co.
  
clear all
%addpath('C:\fieldtrip-20160118')
%ft_defaults

% #1
datapath='E:\EXPERIMENTS\MDT_EEG\ANALYSIS_SEPT2015\Preprocessed_Data\';
savepath='E:\EXPERIMENTS\MDT_EEG\ERP_ANALYSIS\';
saveVirtualData='E:\EXPERIMENTS\MDT_EEG\#Helping_July2016\ROIs_beamform\TIMELOCK\';

% subjexts list excluding unbelievers sbj 2 and 11
% sbj 5 bad eeg data
% sbj 23 too many artifacts
subjects=[1:3 6:10 12:22 24:32];
nsubjects = length(subjects);

% load allERP baseline corrected calculated in a01_time_lock.m
load ('C:\Users\gallo\Dropbox (Social Brain Lab)\HELPING_S1_EEGTMS\EEG_analysis\script\allERP_timelock.mat')

% coordinated ROI  for each region
% dSIL_peak=[-3 -4 6]; % real roi
% vSIL_peak=[-5 -2 3]; % real roi
dSIR_peak=[3 -4 6] ; % mirror roi
vSIR_peak=[5 -2 3] ; % mirror roibelievers

%% ROBUST REGRESSION BRAIN ACTIVITY --> DONATION
% delete data inside the variable

load('alldata_dSIL_peak_structureExemp.mat')
slope=alldata;
%interc=alldata;

for rois=3:4
    switch rois
        case 1
          whichROI='dSIL_peak';     
        case 2
          whichROI='vSIL_peak';
        case 3
          whichROI='dSIR_peak';
           case 4
          whichROI='vSIR_peak'; 
      
    end
for task=1:2
    switch task
        case 1
            ta= 'F_';
        case 2
            ta= 'H_';
    end

 for sbj = 1:nsubjects
     sub_i = subjects(sbj);
    

filename=[saveVirtualData whichROI '\' ta num2str(sub_i) '_trials.mat'];
load(filename);

data=data_virtual;
cfg=[];
data=ft_timelockbaseline(cfg,data);
donation= data.trialinfo(:,2);


 % separated stardization  for the 2 task
avg_don= nanmean(donation);
std_don=nanstd(donation); 


slope{sbj,task}.avg=nan(length(data.label), length(data.time));
interc{sbj,task}.avg=nan(length(data.label), length(data.time));


 for ch=1:3;
     
     disp(['**** Subject ' num2str(sub_i) ' task' num2str(task) ' channel ' num2str(ch) ' calculation ****']);

    
     for time=1751:length(data.time)
      value=data.trial(:,ch,time);

 %robust fit
 
%  robustfit Robust linear regression
%     B = robustfit(X,Y) returns the vector B of regression coefficients,
%     obtained by performing robust regression to estimate the linear model
%     Y = Xb.  X is an n-by-p matrix of predictor variables, and Y is an
%     n-by-1 vector of observations.  The algorithm uses iteratively
%     reweighted least squares with the bisquare weighting function.  By
%     default, robustfit adds a column of ones to X, corresponding to a
%     constant term in the first element of B.  Do not enter a column of ones
%     directly into the X matrix.

 [p] = robustfit(value,(donation-avg_don)/std_don);  % p=[intercept slope]
 
  interc{sbj,task}.avg(ch,time)=p(1);
  slope{sbj,task}.avg(ch,time)=p(2);
 
    
     end % time points

 end   % channel
end % sbj
end %task
if whichROI<=2
    save(['slopeZdon_' whichROI '.mat'], 'slope')
save(['interc_' whichROI '.mat'], 'interc')
else
save(['slopeZdon_' whichROI '_mirr.mat'], 'slope')
save(['interc_' whichROI '_mirr.mat'], 'interc')
end
end %roi
