% timelock fig low - high donation with median split


%%  Paths and co.
  
clear all
addpath('C:\fieldtrip-20160118')
ft_defaults

% #1
datapath='F:\EXPERIMENTS\MDT_EEG\ANALYSIS_SEPT2015\Preprocessed_Data\';
savepath='F:\EXPERIMENTS\MDT_EEG\ERP_ANALYSIS\';
saveVirtualData='F:\EXPERIMENTS\MDT_EEG\#Helping_July2016\ROIs_beamform\TIMELOCK\';

% subjexts list excluding unbelievers
subjects=[1:3 6:10 12:22 24:32];
nsubjects = length(subjects);

%%
for rois=1:4
    switch rois
        case 1
          whichROI='dSIL_peak';     
        case 2

          whichROI='vSIL_peak';
        case 3

            whichROI='dSIR_peak';
           case 4

          whichROI='vSIR_peak'; 
      
    end
for task=1:2
    switch task
        case 1
            ta= 'F_';
        case 2
            ta= 'H_';
    end
allERP=cell(nsubjects,2);
 for s = 1:nsubjects
     sub_i = subjects(s);
    

filename=[saveVirtualData whichROI '\' ta num2str(sub_i) '_trials.mat'];
load(filename);

data=data_virtual;

cfg=[];
data=ft_timelockbaseline(cfg,data);

    data.cfg.previous=[];
    donation= data.trialinfo(:,2);
    donation_mean=nanmean(donation);
%% ERP CALCULATION low and high donation
    cfg=[];
    cfg.vartrllength       = 0;
    
    cfg.trials=find(data.trialinfo(:,2)<donation_mean);
    erp_low_don= ft_timelockanalysis(cfg, data);
    
    cfg.trials=find(data.trialinfo(:,2)>donation_mean);
    erp_high_don= ft_timelockanalysis(cfg, data);
     
    allERP{s,1}=erp_low_don;
    allERP{s,2}=erp_high_don;    
    
end % sbj

save(['allERP_LowHighDon_' ta whichROI '.mat'])  

end % task
end % roi
%%

for rois=rois=1:4
    switch rois
        case 1
          whichROI='dSIL_peak';     
        case 2

          whichROI='vSIL_peak';
        case 3

            whichROI='dSIR_peak';
           case 4

          whichROI='vSIR_peak'; 
        
    end
for task=1:2
    switch task
        case 1
            ta= 'F_';
        case 2
            ta= 'H_';
    end
    
    load(['allERP_LowHighDon_' ta whichROI '.mat'])
    
cfg=[];
low_don=ft_timelockgrandaverage(cfg,allERP{:,1});
high_don=ft_timelockgrandaverage(cfg,allERP{:,2});


for ch=1:3
    low=low_don.avg(ch, find(low_don.time==-1):find(low_don.time==1));
    high=high_don.avg(ch, find(high_don.time==-1):find(high_don.time==1));
    
time= high_don.time(find(high_don.time==-1):find(high_don.time==1));
figure(99)
plot(time,low, 'b');
hold on
plot(time, high, 'r')

title([ whichROI ' Task ' ta ' dipole ' num2str(ch) ])
xlabel('time (sec)') % x-axis label
%ylabel('slope')
legend('low don','high don', 'Location','southeast')
hold off

saveas(gcf, [ whichROI ' Task ' ta ' dipole ' num2str(ch) ]);

end % ch
end % task
end % rois

    