% Hotelling's T-Squared test for one multivariate sample and montecarlo +
% cluster permutation analysis

% Selene Dec 2016
clear all
addpath C:\fieldtrip-20160118
ft_defaults
% path to the necessary functions
%addpath C:\Users\gallo\Dropbox (Social Brain Lab)\work_in_progress\Helping_EEG_July2016\HotellingT-SquaredTest_functions 
%addpath('C:\Users\gallo\Dropbox (Social Brain Lab)\work_in_progress\Helping_EEG_July2016\HotellingT-SquaredTest_functions');

peakROI_path='C:\Users\gallo\Dropbox (Social Brain Lab)\HELPING_S1_EEGTMS\EEG_analysis\script\'; % nin pc
%peakROI_path='C:\Users\Selene\Dropbox (Social Brain Lab)\HELPING_S1_EEGTMS\EEG_analysis\script\'; % my laptop

subjects=[1:3 6:10 12:22 24:32];
nsbj = length(subjects);

%%
for rois=3:4;% peak 7:10 com
switch rois
        case 1
         whichROI='dSIL_peak';     
        case 2
          whichROI='vSIL_peak';
        case 3
          whichROI='dSIR_peak_mirr';
           case 4
          whichROI='vSIR_peak_mirr'; 
       
end
    

 load([comROI_path 'slope_' whichROI]) 


for task=[1 2]
    
    disp (['********************** calculating   ' whichROI '  task # ' num2str(task)])
%% for each time point HT2 test on slopes from the 3 dipoles
p_t=0;
for t=1751:2751 % entire duration of video
    p_t= p_t+1;
    ss=0;
    for s=1:nsbj
       data(s,:)= slope{s,task}.avg(:,t)';
    end%sbj
    [pval, chisq]=T2Hot1ck(data,0.05);
    p(p_t)=pval;
    F(p_t)=chisq;
end % time points

%% switch sign to the slopes= of random participants 
nrand=1000;%1000;
nsbj=28;
myvalues=[1:nsbj];

p_t=0;
for t=1751:2751 % entire duration of video
    p_t= p_t+1;
   
    for sbj=1:nsbj % skip sbj 5
    
    data_X(sbj, p_t)= slope{sbj,task}.avg(1,t);
    data_Y(sbj, p_t)= slope{sbj,task}.avg(2,t);
    data_Z(sbj, p_t)= slope{sbj,task}.avg(3,t);
    end%sbj
 end % time points

datarnd_p=NaN(nrand,1001);
datarnd_F=NaN(nrand,1001);

for rnd=1:nrand

s=sign(rand(1,length(myvalues))-0.5)';
datarnd_X=data_X.*repmat(s,[1,1001]);
datarnd_Y=data_Y.*repmat(s,[1,1001]);
datarnd_Z=data_Z.*repmat(s,[1,1001]);


for t=1:1001 % entire duration of video
     A=[datarnd_X(:,t) datarnd_Y(:,t) datarnd_Z(:,t)];
    [pval, chisq]=T2Hot1ck(A,0.05);
    datarnd_p(rnd,t)=pval;
    datarnd_F(rnd, t)=chisq;
end 

end % randomization
%% cluster analysis

% according to  http://www.socr.ucla.edu/applets.dir/f_table.html#FTable0.05
% crical value for F test df1=3 and df2=25, alpha 0.05 = 2.9912  alpha 0.01 4.765
% df1=numb of variable
% df2=df1- nsbj

% the clusterstat function uses
  cfg.dim=[1        1001];
  %cfg.inside
  cfg.tail = 0; % -1, 0, 1
  cfg.clustertail=0;
  cfg.multivariate = 'no';%no, yes
  cfg.orderedstats = 'no'; %no, yes
  cfg.clusterstatistic = 'maxsum'; %max, maxsize, maxsum, wcm
  cfg.clusterthreshold = 'parametric'; % parametric, nonparametric_individual, nonparametric_common
  cfg.clusteralpha= 0.05;
  cfg.clustercritval= 4.765;%2.9912;
  cfg.numrandomization=nrand;
  %cfg.wcm_weight
  %cfg.feedback

 statrnd=datarnd_F'; % timepoints X nrandomization
 statobs=F';
 varargin={};
 % [stat, cfg] = clusterstat(cfg, statrnd, statobs, varargin)
 
 stat=clusterstat(cfg, statrnd, statobs, varargin);
 stat.stat=statobs;
 
 switch task
     case 1
         stat_F=stat;
     case 2 
         stat_H=stat;
 end
  
end % task
    if rois<=6
    save([peakROI_path 'stat_slope_' num2str(nrand) 'perm_' whichROI '_FaceHT2multvat.mat'], 'stat_F')
    save([peakROI_path 'stat_slope_' num2str(nrand) 'perm_' whichROI '_HandHT2multvat.mat'], 'stat_H')  

    else
    save([comROI_path 'stat_slope_1000perm_' whichROI '_FaceHT2multvat.mat'], 'stat_F')
    save([comROI_path 'stat_slope_1000perm_' whichROI '_HandHT2multvat.mat'], 'stat_H') 
    end

end % ROIS


 %% plot
 threshold=0.0125 %0.0063; % 0.0125 bonferroni correction 2 task x 2 rois 0.0063 bonf 2task X 4 rois

 time=-1:0.002:1;
 for rois=2%1:6 peak 7:10 com
switch rois
        case 1
         whichROI='dSIL_peak';     
        case 2
          whichROI='vSIL_peak';
        case 3
          whichROI='dSIR_peak_mirr';
           case 4
          whichROI='vSIR_peak_mirr'; 
        
end
    

    load([peakROI_path 'stat_slope_' num2str(nrand) 'perm_' whichROI '_FaceHT2multvat.mat']) 
    load([peakROI_path 'stat_slope_' num2str(nrand) 'perm_' whichROI '_HandHT2multvat.mat']) 


% face vs zero: blue
p0p05=find(stat_F.prob<threshold);
Idx=setdiff(1:length(stat_F.stat),p0p05);
statF0p05=stat_F.stat;
statF0p05(Idx)=NaN;

% hand vs zero: red
p0p05=find(stat_H.prob<threshold);
Idx=setdiff(1:length(stat_H.stat),p0p05);
statH0p05=stat_H.stat;
statH0p05(Idx)=NaN;

figure(99)
plot(time,stat_F.stat, 'b');
hold on
plot(time, statF0p05, 'b*')
plot(time,stat_H.stat, 'r')
plot(time, statH0p05, 'r*')

title(whichROI)
legend('F_test slopeFACE', '', 'F_test slopeHAND', '')
hold off


saveas(gcf,[peakROI_path 'slope_HT2multvat' whichROI '_threshold' num2str(threshold) '_nrand' num2str(nrand) '.fig']);


 end