% function Z = mysquareform(Y)
% 
% Fast version of squareform that is a little more general.
% Convert similarity matrix to vector or vector to similarity matrix. If
% input is a 3D matrix, it can convert results to a 2D matrix. Be advised
% that there are no checks included, i.e. if your input is not a similarity
% matrix (or set of similarity matrices) or a vector that can be converted
% to a similarity matrix, the results may be wrong.

% by Martin Hebart, 2017

function Z = mysquareform(Y)

if isvector(Y)

n = length(Y);
m = ceil(sqrt(2*n));
Z = zeros(m);
Z(tril(true(m),-1)) = Y;

Z = Z+Z';

else
    
    ind = tril(true(size(Y(:,:,1))),-1);
    
    for i = size(Y,3):-1:1 % can work on 3D matrices
    
        tmp = Y(:,:,i);
        Z(:,i) = tmp(ind);
    
    end
    
end


