function allranks = tiedrank2(x)

% faster, less general version of tiedrank (can't deal with inf or NaN)

% by Martin Hebart, 2016

[sx,sy] = size(x);
r = (1:sx)';

% allranks = zeros(sx,sy); % init
[xsorted,ir] = sort(x);
dxsorted = diff(xsorted,1,1);

for i = sy:-1:1 % invert to save time for preallocation
    f = [0;find(dxsorted(:,i)~=0);sx];
    if length(f)==sx+1 % if all are unique
        allranks(ir(:,i),i) = r;
    else
        for j = length(f)-1:-1:1 % invert to save time for preallocation
            ranks(f(j)+1:f(j+1)) = (f(j)+1+f(j+1))/2; % mean of edges
        end
        allranks(ir(:,i),i) = ranks;
    end
end