function varargout = find_clusters2(x)

% Will find clusters of 0 and 1 in a time-series and report as numeric
% output from 1 to n_cluster
%
% Output 1: Cluster sizes
% Output 2: Empty
% Output 3: Empty
% Output 4: Clusters labeled
%

[L,num] = spm_bwlabel(double(x),18); % 18 is edge connectivity

if num == 0
    varargout{1} = 0;
else
    varargout{1} = hist(L(L(:)~=0),num)';
end
varargout{2} = [];
varargout{3} = [];
varargout{4} = L;