function hout = plot_significance(h,n,t0,tk)

% INPUT:
% h: where hypothesis is significant
% n: number of values tested
% t0: bin that is the first
% tk: bin that is the last
%
% OUTPUT:
% h: values of 1 whereever p is significant and nan elsewhere

h = double(h);
h(h==0) = NaN;
hout = nan(1,n);
hout(t0:tk) = h;
