% Blue Light Control
% Matt

%% Initialize LabJack
ljud_LoadDriver; % Loads LabJack UD Function Library
ljud_Constants; % Loads LabJack UD constant file
[Error ljHandle] = ljud_OpenLabJack(LJ_dtU3,LJ_ctUSB,'1',1); % Returns ljHandle for open LabJack
Error_Message(Error) % Check for and display any Errros

%Start by using the pin_configuration_reset IOType so that all
%pin assignments are in the factory default condition.
Error = ljud_ePut (ljHandle, LJ_ioPIN_CONFIGURATION_RESET, 0, 0, 0);
Error_Message(Error)



%% Core Codes ----------------
% Switch  LED
Switch1 =0;% 0 o
Error = ljud_ePut(ljHandle, LJ_ioPUT_DAC, 0, Switch1, 0);
Error_Message(Error)




%% Turn on every X seconds and record current frame during stimulus

dirname=uigetdir('Please select the directory where images are located: ');
cd(dirname);
j=1;

ledontime=10; % seconds LED on-time
waittime=30; % seconds between led on
expruntime=8; % desired experiment  run time in hours


Switch1 = 0;
Error = ljud_ePut(ljHandle, LJ_ioPUT_DAC, 0, Switch1, 0);
Error_Message(Error)
pause(0); % pauses for number of seconds inside the pause functionurr
currstim=1;
stimulationFrames=[];
tic
exptime=toc;
while (exptime/3600)<expruntime
    ims=dir('image*');
    templ=length(ims);
    tempname=ims(templ).name;
    tempname=tempname(1:end-4);
    if length(tempname)==9
        currim=str2num(tempname(end-3:end));
    elseif length(tempname)==10
        currim=str2num(tempname(end-4:end));
    elseif length(tempname)==11
        currim=str2num(tempname(end-5:end));
    end
    stimulationFrames(currstim)=currim;
    display(['Light stimulation # ' num2str(currstim) ' occurs after image # ' num2str(currim) '.'])
    %Turn led on
    Error = ljud_ePut(ljHandle, LJ_ioPUT_DAC, 0, 4, 0);
    Error_Message(Error)
    % Wait  ledontime
    pause(ledontime)
    % turn led off
    Error = ljud_ePut(ljHandle, LJ_ioPUT_DAC, 0, 0, 0);
    Error_Message(Error)

    for z=1:waittime
        pause(1)

        display(['pausing. light turns on in ' num2str(waittime-z) ' seconds.'])
    end
    currstim=currstim+1;
    save('stimulationFrames.mat','stimulationFrames')
    exptime=toc;
end

%% Increasing light pulse duration

dirname=uigetdir('Please select the directory where images are located: ');
cd(dirname);
j=1;

ledontime=1; % seconds LED on-time
ontimeslope=ledontime/50; % change this number to edit stimulus length increase
waittime=30; % seconds between led on
expruntime=1; % desired experiment  run time in hours

Switch1 = 0;
Error = ljud_ePut(ljHandle, LJ_ioPUT_DAC, 0, Switch1, 0);
Error_Message(Error)
pause(0); % pauses for number of seconds inside the pause functionurr
currstim=1;
stimulationFrames=[];
tic
exptime=toc;
while (exptime/3600)<expruntime
    ims=dir('image*');
    templ=length(ims);
    tempname=ims(templ).name;
    tempname=tempname(1:end-4);
    if length(tempname)==9
        currim=str2num(tempname(end-3:end));
    elseif length(tempname)==10
        currim=str2num(tempname(end-4:end));
    elseif length(tempname)==11
        currim=str2num(tempname(end-5:end));
    end
    stimulationFrames(currstim)=currim;
    stimulationDuration(currstim)=ledontime;
    display(['Light stimulation # ' num2str(currstim) ' occurs after image # ' num2str(currim) '.'])
    %Turn led on
    Error = ljud_ePut(ljHandle, LJ_ioPUT_DAC, 0, 4, 0);
    Error_Message(Error)
    % Wait  ledontime
    pause(ledontime)
    % turn led off
    Error = ljud_ePut(ljHandle, LJ_ioPUT_DAC, 0, 0, 0);
    Error_Message(Error)

    for z=1:waittime
        pause(1)

        display(['pausing. light turns on in ' num2str(waittime-z) ' seconds.'])
    end
    currstim=currstim+1;
    ledontime=ledontime+ontimeslope;
    save('stimulationFrames.mat','stimulationFrames','stimulationDuration')
    exptime=toc;
end