% WorMotel w/ light stimulation image processing file
% By Matt Churgin.  Last updated 22 Sep. 2016
% Dependents include ComputeActivityMatt.m,
% ComputeTimeDiffBtwTwoDateVectorsMatt, GetImageTimeArrayMatt.m,
% ROIDefine.m, SearchActiveImagingPeriodsMatt.m, and
% SearchStimulationTimeMatt.m

% Run this code to process images

clear all
close all

% Initialize LabJack
ljud_LoadDriver; % Loads LabJack UD Function Library
ljud_Constants; % Loads LabJack UD constant file
[Error ljHandle] = ljud_OpenLabJack(LJ_dtU3,LJ_ctUSB,'1',1); % Returns ljHandle for open LabJack
Error_Message(Error) % Check for and display any Errros

%Start by using the pin_configuration_reset IOType so that all
%pin assignments are in the factory default condition.
Error = ljud_ePut (ljHandle, LJ_ioPIN_CONFIGURATION_RESET, 0, 0, 0);
Error_Message(Error)

Switch1 = 0;
Error = ljud_ePut(ljHandle, LJ_ioPUT_DAC, 0, Switch1, 0);
Error_Message(Error)

ROIDefine

display(['ROI selection complete.  Now moving on to image processing step.'])

pause(1)
close all
pause(1)

foldername=uigetdir('Select Directory with images to process');
srcDir=foldername; % change to let user select
imageFileExtension = 'bmp'; % change to let user input

destAnalysisFolder = [srcDir '\Analysis'];


if ~exist(destAnalysisFolder, 'dir')
    mkdir(destAnalysisFolder);
end

d=dir([srcDir '\*.' imageFileExtension]);

%imageTimeArray = GetImageTimeArrayMatt(d);

%save([destAnalysisFolder '\fileNames.mat'], 'd');
%save([destAnalysisFolder '\imageTimeArray.mat'], 'imageTimeArray');

analysisInterval = 6; % sec
%analysisInterval2 = 60; % sec
spi=6; % seconds per image
AutoSaveFrames=100;
NoiseThres=40;
temp=inputdlg('Please enter the test ROI number: ');
testROI=str2num(temp{1});
qthresh=1; % threshold to label an ROI as quiescent
lOT=4; % light on time in seconds
lo=0; % number of times light was on;
lightOnTimes=[]; %
% Initialize Activity Analysis

cd(srcDir)
load inits

analysisInterval1=analysisInterval/spi;
%analysisInterval2=analysisInterval2/spi;
NumStart=1;
NumEnd=2;
NumROI=length(ROI);

Error = 0;
AnalysisTPF = 'N/A';
% Create Gaussian Filter
x=-5:5;
y=x;
[xx yy]=meshgrid(x,y);
gau=exp(-sqrt(xx.^2+yy.^2));


okay=0;
while okay==0
    NameA = [num2str(NumStart,'%04d') '.bmp'];
    NameB =  [num2str(NumStart+1,'%04d') '.bmp'];
    ImgA=single(imread(NameA));
    ImgB=single(imread(NameB));
    ImgDif = abs(double(ImgA-ImgB));
    ImgDif = conv2(ImgDif,gau,'same');
    figure
    imagesc(ImgDif>NoiseThres)
    colormap(gray)

    okay=input('If NoiseThres okay, enter 1, otherwise enter 0:  ');

    if okay==0
        NoiseThres=input('Enter new NoiseThres:  ');
    end
    close all
end


%%
warning('off')
display(['Beginning image processing'])
beginclosedloop=0;
lo=1; % number of times light was on;
lightOnTimes=[1]; %
ActVal = zeros(NumROI,2);

stimuliPerHour=30; % number of stimuli per hour
timeBetweenStimuli=3600/stimuliPerHour; % time between stimuli
continuouslyActive=3; % number of frames the test fly must be continuously active before being stimulated
%ActValS = zeros(NumROI,length(d));


tic;
NumA = NumStart;
ROI=round(ROI);
%
% while NumA <= NumEnd
%
%     NameA = d(NumA).name;
%
%     if NumA > NumStart
%         if mod(NumA-NumStart-analysisInterval1,analysisInterval1)==0
%             ImgB = ImgA;
%         end
%         %         if mod(NumA-NumStart-analysisInterval2,analysisInterval2)==0
%         %             ImgC = ImgA;
%         %         end
%     end
%     try
%         ImgA = single(imread(NameA));
%     catch
%     end
%     % Activity Analysis --------------------------------------
%     if NumA > NumStart
%         if mod(NumA-NumStart-analysisInterval1,analysisInterval1)==0
%             try
%                 ImgDif = abs(double(ImgA-ImgB));
%                 for n = 1:NumROI
%                     ROIDif = ImgDif(ROI(n,3):ROI(n,4),ROI(n,1):ROI(n,2));
%                     ROIDifT = conv2(ROIDif,gau,'same');
%                     ROIDifT = ROIDifT>NoiseThres;
%                     ActVal(n,NumA-NumStart) = sum(sum(ROIDifT));
%                 end
%             catch
%             end
%         end
%
%         %         if mod(NumA-NumStart-analysisInterval2,analysisInterval2)==0
%         %             try
%         %                 ImgDifSkip = abs(double(ImgA-ImgC))./double(ImgA+ImgC);
%         %                 for n = 1:NumROI
%         %                     ROIDifSkip = ImgDifSkip(ROI(n,3):ROI(n,4),ROI(n,1):ROI(n,2));
%         %                     ROIDifTSkip = conv2(ROIDifSkip,gau,'same');
%         %                     ROIDifTSkip = ROIDifTSkip>NoiseThres;
%         %                     ActValS(n,NumA-NumStart) = sum(sum(ROIDifTSkip));
%         %                 end
%         %             catch
%         %             end
%         %         end
%
%         display(['Analysis in progress: Image #' num2str(NumA-NumStart) ', ' NameA '. Closed loop blue light OFF. Images processed at ' AnalysisTPF ' sec/frame.'])
%
%     end
%     if mod(NumA,10) == 0
%         AnalysisTPF = num2str(toc/10,'%0.3f');
%         tic;
%     end
%     if mod(NumA,AutoSaveFrames) == 0
%         save([destAnalysisFolder '/activity'],'NoiseThres','ActVal','analysisInterval1');
%     end
%     NumA = NumA + 1;
% end

% Begin closed-loop blue light section

%
% nextimage=d(end).name;
% splace=17:18;
% mplace=14:15;
% hplace=11:12;
%
% digits=nextimage(splace);
% digitm=nextimage(mplace);
% digith=nextimage(hplace);
% if str2num(digits)<(59-spi)
%     digits=num2str(str2num(digits)+spi);
%     if str2num(digits)>9
%         nextimage(splace)=digits;
%     else
%         nextimage(splace(2))=digits;
%         nextimage(19)=num2str(0);
%     end
% elseif str2num(digits)==(60-spi)
%     nextimage(splace(1))=num2str(0);
%     nextimage(splace(2))=num2str(0);
%
%     if str2num(digitm)<59
%         digitm=num2str(str2num(digitm)+1);
%         if str2num(digitm)>9
%             nextimage(mplace)=digitm;
%         else
%             nextimage(mplace(2))=digitm;
%             nextimage(mplace(1))=num2str(0);
%         end
%     else
%         nextimage(mplace(1))=num2str(0);
%         nextimage(mplace(2))=num2str(0);
%         digith=num2str(str2num(digith)+1);
%         if str2num(digith)>9
%             nextimage(hplace)=digith;
%         else
%             nextimage(hplace(2))=digith;
%             nextimage(hplace(1))=num2str(0);
%         end
%     end
% elseif str2num(digits)>(60-spi)
%     digits=num2str(mod(str2num(digits)+spi,60));
%     nextimage(splace(2))=num2str(digits);
%     nextimage(splace(1))=num2str(0);
%     if str2num(digitm)<59
%         digitm=num2str(str2num(digitm)+1);
%         nextimage(mplace)=digitm;
%     else
%         nextimage(mplace)=num2str(0);
%         digith=num2str(str2num(digith)+1);
%         nextimage(hplace)=digith;
%     end
% end
nextimage=[num2str(NumStart,'%04d') '.bmp'];
displayedmessage=0;
while NumA

    if mod(NumA-NumStart-analysisInterval1,analysisInterval1)==0
        ImgB = ImgA;
    end
    %     if mod(NumA-NumStart-analysisInterval2,analysisInterval2)==0
    %         ImgC = ImgA;
    %     end

    try
        ImgA = single(imread(nextimage));
        displayedmessage=0;

        % Activity Analysis --------------------------------------
        if NumA > NumStart
            if mod(NumA-NumStart-analysisInterval1,analysisInterval1)==0
                ImgDif = abs(double(ImgA-ImgB));
                for n = 1:NumROI
                    ROIDif = ImgDif(ROI(n,3):ROI(n,4),ROI(n,1):ROI(n,2));
                    ROIDifT = conv2(ROIDif,gau,'same');
                    ROIDifT = ROIDifT>NoiseThres;
                    ActVal(n,NumA-NumStart) = sum(sum(ROIDifT));
                end
            end

            %             if mod(NumA-NumStart-analysisInterval2,analysisInterval2)==0
            %                 ImgDifSkip = abs(double(ImgA-ImgC))./double(ImgA+ImgC);
            %                 for n = 1:NumROI
            %                     ROIDifSkip = ImgDifSkip(ROI(n,3):ROI(n,4),ROI(n,1):ROI(n,2));
            %                     ROIDifTSkip = conv2(ROIDifSkip,gau,'same');
            %                     ROIDifTSkip = ROIDifTSkip>NoiseThres;
            %                     ActValS(n,NumA-NumStart) = sum(sum(ROIDifTSkip));
            %                 end
            %             end
        end

        % test if testROI has been active for continuouslyActive frames
        if beginclosedloop==1
            enoughTimePassed=toc;
            if enoughTimePassed>=timeBetweenStimuli % test if enough time has passed since previous stimulus
                imagesc(conv2(ImgDif,gau,'same')>NoiseThres);
                colormap(gray)
                drawnow
                activeFly=sum(double(ActVal(testROI,(NumA-(NumStart+continuouslyActive-1)):(NumA-NumStart))>qthresh));
                if activeFly==continuouslyActive
                    % activate light
                    if lightOnTimes(lo)~=NumA

                        lo=lo+1;
                        lightOnTimes(lo)=NumA;

                        display(['Test ROI is ACTIVE.  Turning light on for ' num2str(lOT) ' seconds after image: ' nextimage '. Time since previous stimulus = ' num2str(enoughTimePassed) ' seconds.'])
                        %Turn led on
                        Error = ljud_ePut(ljHandle, LJ_ioPUT_DAC, 0, 4, 0);
                        Error_Message(Error)
                        % Wait  ledontime
                        pause(lOT)
                        % turn led off
                        Error = ljud_ePut(ljHandle, LJ_ioPUT_DAC, 0, 0, 0);
                        Error_Message(Error)
                        tic % reset clock after each stimulus
                    end
                else
                    Error = ljud_ePut(ljHandle, LJ_ioPUT_DAC, 0, 0, 0);
                    Error_Message(Error)
                    display(['Test ROI is not active enough.  Light not turned on after image name:  ' nextimage '.'])
                end
            else
                display(['Time since previous image is ' num2str(enoughTimePassed) ' seconds.  No new stimulus until ' num2str(timeBetweenStimuli) ' seconds have passed.'])
            end
        else

            display(['Analysis in progress: Image #' num2str(NumA-NumStart) ', ' nextimage '. Closed loop blue light OFF.'])

        end

%         if mod(NumA,10) == 0
%             AnalysisTPF = num2str(toc/10,'%0.3f');
%             tic;
%         end
        if mod(NumA,AutoSaveFrames) == 0
            save([destAnalysisFolder '/activity'],'NoiseThres','ActVal','analysisInterval1','lo','lightOnTimes');
        end

        NumA=NumA+1;
        nextimage=[num2str(NumA,'%04d') '.bmp'];
    catch
        if displayedmessage==0
            display(['Image ' nextimage ' not recorded yet.'])
            displayedmessage=1;
            if beginclosedloop==0
                beginclosedloop=1;
                display(['Beginning closed-loop analysis.  Test ROI #' num2str(testROI)])
                
            end
        end
    end
end
