var networks = {"DownregulatedSet": {
  "format_version" : "1.0",
  "generated_by" : "cytoscape-3.6.0",
  "target_cytoscapejs_version" : "~2.1",
  "data" : {
    "shared_name" : "Original(1)",
    "reference" : "Mutte et al., 2018 (Under revision)",
    "author" : "Dolf Weijers",
    "__Annotations" : [ "" ],
    "name" : "DownregulatedSet",
    "description" : "Shows BLAST hit similarities between downregulated genes in different species.",
    "SUID" : 25602,
    "version" : "1.0",
    "selected" : true
  },
  "elements" : {
    "nodes" : [ {
      "data" : {
        "id" : "17642",
        "degree_layout" : 6,
        "Description" : "Red/far-red photoreceptor involved in the regulation of de-etiolation. Exists in two inter-convertible forms: Pr and Pfr (active). Involved in the light-promotion of seed germination and in the shade avoidance response. Promotes seedling etiolation in both the presence and absence of phytochrome A. Overexpression results in etiolation under far-red light. Accumulates in the nucleus after exposure to far red light. The phosphorylation state of the Ser-86 residue of the phytochrome B molecule alters dark reversion of the molecule. The mRNA is cell-to-cell mobile.",
        "SecondarySymbol" : "PHYTOCHROME B (PHYB);OUT OF PHASE 1 (OOP1); (HY3)",
        "sstart" : 58,
        "qstart" : 854,
        "qcovhsp" : 21,
        "shared_name" : "PpCluster-21922.6",
        "ppos" : 76.2,
        "score" : 3415,
        "pident" : 61.561,
        "SUID" : 17642,
        "selected" : false,
        "sseqid" : "AT2G18790",
        "length" : 1025,
        "nident" : 631,
        "evalue" : 0.0,
        "positive" : 781,
        "gaps" : 13,
        "Type" : "protein_coding",
        "bitscore" : 1320.0,
        "slen" : 1172,
        "mismatch" : 381,
        "name" : "PpCluster-21922.6",
        "send" : 1077,
        "qcovs" : 62,
        "PrimarySymbol" : "PHYTOCHROME B (PHYB)",
        "qend" : 3904
      },
      "position" : {
        "x" : 1853.6995375750334,
        "y" : -1539.5258552132982
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17641",
        "degree_layout" : 4,
        "Description" : "encodes a gene similar to cellulose synthase",
        "SecondarySymbol" : "CELLULOSE-SYNTHASE LIKE C5 (ATCSLC05);CELLULOSE-SYNTHASE-LIKE C5 (CSLC5);CELLULOSE-SYNTHASE-LIKE C5 (ATCSLC5);CELLULOSE-SYNTHASE LIKE C5 (CSLC05)",
        "sstart" : 1,
        "qstart" : 2929,
        "qcovhsp" : 15,
        "shared_name" : "PpCluster-24384.2",
        "ppos" : 78.6,
        "score" : 2177,
        "pident" : 66.476,
        "SUID" : 17641,
        "selected" : false,
        "sseqid" : "AT4G31590",
        "length" : 701,
        "nident" : 466,
        "evalue" : 0.0,
        "positive" : 551,
        "gaps" : 15,
        "Type" : "protein_coding",
        "bitscore" : 843.0,
        "slen" : 692,
        "mismatch" : 220,
        "name" : "PpCluster-24384.2",
        "send" : 692,
        "qcovs" : 46,
        "PrimarySymbol" : "CELLULOSE-SYNTHASE-LIKE C5 (CSLC5)",
        "qend" : 845
      },
      "position" : {
        "x" : -849.2211303710938,
        "y" : -2295.38134765625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17640",
        "degree_layout" : 5,
        "Description" : "a member of Glycosyltransferase- Family 2 and encodes a beta-mannan synthase based on in vitro enzyme assays from heterologously expressed protein. Mutants exhibit defects in pollen tube growth and embryo development. The defective embryonic development was associated with reduced proliferation and failed cellularization of the endosperm.",
        "SecondarySymbol" : "CELLULOSE SYNTHASE LIKE (CSLA07);CELLULOSE SYNTHASE LIKE A7 (CSLA7); (ATCSLA7); (CSLA07);CELLULOSE SYNTHASE LIKE (ATCSLA07)",
        "sstart" : 250,
        "qstart" : 1452,
        "qcovhsp" : 7,
        "shared_name" : "PpCluster-22833.0",
        "ppos" : 84.69,
        "score" : 727,
        "pident" : 64.796,
        "SUID" : 17640,
        "selected" : false,
        "sseqid" : "AT2G35650",
        "length" : 196,
        "nident" : 127,
        "evalue" : 1.6E-102,
        "positive" : 166,
        "gaps" : 6,
        "Type" : "protein_coding",
        "bitscore" : 284.0,
        "slen" : 556,
        "mismatch" : 63,
        "name" : "PpCluster-22833.0",
        "send" : 439,
        "qcovs" : 20,
        "PrimarySymbol" : "CELLULOSE SYNTHASE LIKE (CSLA07)",
        "qend" : 2039
      },
      "position" : {
        "x" : -798.0524291992188,
        "y" : -2169.923583984375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17639",
        "degree_layout" : 4,
        "Description" : "encodes a gene similar to cellulose synthase",
        "SecondarySymbol" : "CELLULOSE-SYNTHASE LIKE C5 (ATCSLC05);CELLULOSE-SYNTHASE-LIKE C5 (CSLC5);CELLULOSE-SYNTHASE-LIKE C5 (ATCSLC5);CELLULOSE-SYNTHASE LIKE C5 (CSLC05)",
        "sstart" : 1,
        "qstart" : 2994,
        "qcovhsp" : 20,
        "shared_name" : "PpCluster-16763.0",
        "ppos" : 77.32,
        "score" : 2142,
        "pident" : 64.337,
        "SUID" : 17639,
        "selected" : false,
        "sseqid" : "AT4G31590",
        "length" : 701,
        "nident" : 451,
        "evalue" : 0.0,
        "positive" : 542,
        "gaps" : 18,
        "Type" : "protein_coding",
        "bitscore" : 829.0,
        "slen" : 692,
        "mismatch" : 232,
        "name" : "PpCluster-16763.0",
        "send" : 692,
        "qcovs" : 60,
        "PrimarySymbol" : "CELLULOSE-SYNTHASE-LIKE C5 (CSLC5)",
        "qend" : 919
      },
      "position" : {
        "x" : -915.9248657226562,
        "y" : -2228.024169921875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17636",
        "degree_layout" : 12,
        "Description" : "Encodes a member of the histidine kinase family.",
        "SecondarySymbol" : "HISTIDINE KINASE 1 (ATHK1);HISTIDINE KINASE 1 (HK1); (AHK1)",
        "sstart" : 1036,
        "qstart" : 491,
        "qcovhsp" : 17,
        "shared_name" : "SpCluster-12981.0",
        "ppos" : 59.89,
        "score" : 347,
        "pident" : 44.385,
        "SUID" : 17636,
        "selected" : false,
        "sseqid" : "AT2G17820",
        "length" : 187,
        "nident" : 83,
        "evalue" : 1.68E-35,
        "positive" : 112,
        "gaps" : 21,
        "Type" : "protein_coding",
        "bitscore" : 138.0,
        "slen" : 1207,
        "mismatch" : 83,
        "name" : "SpCluster-12981.0",
        "send" : 1201,
        "qcovs" : 50,
        "PrimarySymbol" : "HISTIDINE KINASE 1 (HK1)",
        "qend" : 1051
      },
      "position" : {
        "x" : 1836.5594008562834,
        "y" : -1477.0705329476732
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17633",
        "degree_layout" : 8,
        "Description" : "Encodes salt tolerance protein (STO) which confers salt tolerance to yeast cells. Fully complements calcineurin deficient yeast but does not encode a phosphoprotein phosphatase. Sequence has similarities to CONSTANS. STO co-localizes with COP1 and plays a role in light signaling.STO transcript levels are regulated by photoperiod and phtyohormones. STO competes with FLC in the regulation of floral transition genes SOC1 and FT.",
        "SecondarySymbol" : "B-BOX DOMAIN PROTEIN 24 (BBX24);SALT TOLERANCE (STO)",
        "sstart" : 63,
        "qstart" : 367,
        "qcovhsp" : 2,
        "shared_name" : "PpCluster-16072.0",
        "ppos" : 77.27,
        "score" : 173,
        "pident" : 68.182,
        "SUID" : 17633,
        "selected" : false,
        "sseqid" : "AT1G06040",
        "length" : 44,
        "nident" : 30,
        "evalue" : 5.06E-14,
        "positive" : 34,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 71.2,
        "slen" : 177,
        "mismatch" : 14,
        "name" : "PpCluster-16072.0",
        "send" : 106,
        "qcovs" : 6,
        "PrimarySymbol" : "SALT TOLERANCE (STO)",
        "qend" : 498
      },
      "position" : {
        "x" : 1967.9446784554855,
        "y" : -1058.614501953125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17632",
        "degree_layout" : 2,
        "Description" : "zinc finger (MYND type) family protein / programmed cell death 2 C-terminal domain-containing protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 51,
        "qstart" : 1552,
        "qcovhsp" : 11,
        "shared_name" : "SpCluster-4959.0",
        "ppos" : 60.0,
        "score" : 448,
        "pident" : 41.622,
        "SUID" : 17632,
        "selected" : false,
        "sseqid" : "AT4G02220",
        "length" : 185,
        "nident" : 77,
        "evalue" : 9.1E-50,
        "positive" : 111,
        "gaps" : 1,
        "Type" : "protein_coding",
        "bitscore" : 177.0,
        "slen" : 418,
        "mismatch" : 107,
        "name" : "SpCluster-4959.0",
        "send" : 235,
        "qcovs" : 33,
        "PrimarySymbol" : "0",
        "qend" : 1001
      },
      "position" : {
        "x" : 663.9140998422042,
        "y" : -2723.6227790414227
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17628",
        "degree_layout" : 2,
        "Description" : "encodes a member of the DREB subfamily A-4 of ERF/AP2 transcription factor family. The protein contains one AP2 domain. There are 17 members in this subfamily including TINY.",
        "SecondarySymbol" : "FYF UP-REGULATING 321 FACTOR 1 (FUF1)",
        "sstart" : 32,
        "qstart" : 1250,
        "qcovhsp" : 2,
        "shared_name" : "PpCluster-3498.0",
        "ppos" : 51.72,
        "score" : 75,
        "pident" : 31.034,
        "SUID" : 17628,
        "selected" : false,
        "sseqid" : "AT1G71450",
        "length" : 58,
        "nident" : 18,
        "evalue" : 0.53,
        "positive" : 30,
        "gaps" : 3,
        "Type" : "protein_coding",
        "bitscore" : 33.5,
        "slen" : 183,
        "mismatch" : 37,
        "name" : "PpCluster-3498.0",
        "send" : 87,
        "qcovs" : 6,
        "PrimarySymbol" : "FYF UP-REGULATING 321 FACTOR 1 (FUF1)",
        "qend" : 1080
      },
      "position" : {
        "x" : -859.1796480886626,
        "y" : 356.9954007394624
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17625",
        "degree_layout" : 12,
        "Description" : "\"Encodes a protein belonging to SART-1 family. The gene is expressed in the basal region of the developing embryo during heart stage. Phenotypic analyses of dot2 mutants suggest that this protein plays a role in root, shoot, and flower development. dot2 mutants are dwarved plants that display an aberrant spurred leaf venation pattern and fail to flower. In the roots DOT2 appears to be require for normal meristem organization and maintenance and the proper expression of PIN and PLT genes.\"",
        "SecondarySymbol" : "MERISTEM-DEFECTIVE (MDF);DEFECTIVELY ORGANIZED TRIBUTARIES  2 (DOT2)",
        "sstart" : 103,
        "qstart" : 1611,
        "qcovhsp" : 15,
        "shared_name" : "PpCluster-8053.0",
        "ppos" : 60.8,
        "score" : 978,
        "pident" : 44.114,
        "SUID" : 17625,
        "selected" : false,
        "sseqid" : "AT5G16780",
        "length" : 773,
        "nident" : 341,
        "evalue" : 8.22E-114,
        "positive" : 470,
        "gaps" : 94,
        "Type" : "protein_coding",
        "bitscore" : 381.0,
        "slen" : 820,
        "mismatch" : 338,
        "name" : "PpCluster-8053.0",
        "send" : 819,
        "qcovs" : 44,
        "PrimarySymbol" : "DEFECTIVELY ORGANIZED TRIBUTARIES  2 (DOT2)",
        "qend" : 3815
      },
      "position" : {
        "x" : -225.07855224609375,
        "y" : -1444.5966796875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17624",
        "degree_layout" : 2,
        "Description" : "Conceptual translation of this open reading frame gave the sequence of a 229-residue hypothetical protein that contains the same sequence as the mature A. thaliana chloroplast luminal 19-kDa protein linked to a putative signal sequence.",
        "SecondarySymbol" : "0",
        "sstart" : 6,
        "qstart" : 476,
        "qcovhsp" : 1,
        "shared_name" : "PpCluster-15569.2",
        "ppos" : 54.0,
        "score" : 68,
        "pident" : 34.0,
        "SUID" : 17624,
        "selected" : false,
        "sseqid" : "AT3G63540",
        "length" : 50,
        "nident" : 17,
        "evalue" : 2.9,
        "positive" : 27,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 30.8,
        "slen" : 143,
        "mismatch" : 33,
        "name" : "PpCluster-15569.2",
        "send" : 55,
        "qcovs" : 4,
        "PrimarySymbol" : "0",
        "qend" : 327
      },
      "position" : {
        "x" : -270.5107116699219,
        "y" : -1045.6888427734375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17623",
        "degree_layout" : 4,
        "Description" : "\"encodes a ubiquitin-specific protease family member, UBP9.\"",
        "SecondarySymbol" : "UBIQUITIN-SPECIFIC PROTEASE 9 (UBP9)",
        "sstart" : 10,
        "qstart" : 2001,
        "qcovhsp" : 29,
        "shared_name" : "SpCluster-8688.0",
        "ppos" : 56.46,
        "score" : 1155,
        "pident" : 42.042,
        "SUID" : 17623,
        "selected" : false,
        "sseqid" : "AT4G10570",
        "length" : 666,
        "nident" : 280,
        "evalue" : 1.41E-145,
        "positive" : 376,
        "gaps" : 65,
        "Type" : "protein_coding",
        "bitscore" : 449.0,
        "slen" : 923,
        "mismatch" : 321,
        "name" : "SpCluster-8688.0",
        "send" : 634,
        "qcovs" : 87,
        "PrimarySymbol" : "UBIQUITIN-SPECIFIC PROTEASE 9 (UBP9)",
        "qend" : 76
      },
      "position" : {
        "x" : 858.0268361870908,
        "y" : -2009.0081369574405
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17622",
        "degree_layout" : 4,
        "Description" : "ubiquitin-specific protease 8;(source:Araport11)",
        "SecondarySymbol" : "UBIQUITIN-SPECIFIC PROTEASE 8 (UBP8)",
        "sstart" : 690,
        "qstart" : 987,
        "qcovhsp" : 18,
        "shared_name" : "SpCluster-18586.0",
        "ppos" : 65.15,
        "score" : 561,
        "pident" : 48.133,
        "SUID" : 17622,
        "selected" : false,
        "sseqid" : "AT5G22030",
        "length" : 241,
        "nident" : 116,
        "evalue" : 1.68E-63,
        "positive" : 157,
        "gaps" : 21,
        "Type" : "protein_coding",
        "bitscore" : 220.0,
        "slen" : 913,
        "mismatch" : 104,
        "name" : "SpCluster-18586.0",
        "send" : 910,
        "qcovs" : 54,
        "PrimarySymbol" : "UBIQUITIN-SPECIFIC PROTEASE 8 (UBP8)",
        "qend" : 268
      },
      "position" : {
        "x" : 993.2030029296875,
        "y" : -2705.8984375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17621",
        "degree_layout" : 6,
        "Description" : "ubiquitin-specific protease 18;(source:Araport11)",
        "SecondarySymbol" : "UBIQUITIN-SPECIFIC PROTEASE 18 (UBP18)",
        "sstart" : 56,
        "qstart" : 733,
        "qcovhsp" : 10,
        "shared_name" : "PpCluster-15917.0",
        "ppos" : 68.7,
        "score" : 1315,
        "pident" : 52.826,
        "SUID" : 17621,
        "selected" : false,
        "sseqid" : "AT4G31670",
        "length" : 460,
        "nident" : 243,
        "evalue" : 2.09E-164,
        "positive" : 316,
        "gaps" : 37,
        "Type" : "protein_coding",
        "bitscore" : 511.0,
        "slen" : 631,
        "mismatch" : 180,
        "name" : "PpCluster-15917.0",
        "send" : 479,
        "qcovs" : 29,
        "PrimarySymbol" : "UBIQUITIN-SPECIFIC PROTEASE 18 (UBP18)",
        "qend" : 2109
      },
      "position" : {
        "x" : 858.4852294921875,
        "y" : -2621.270751953125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17620",
        "degree_layout" : 8,
        "Description" : "Encodes a ubiquitin-specific protease.",
        "SecondarySymbol" : "UBIQUITIN-SPECIFIC PROTEASE 23 (UBP23)",
        "sstart" : 106,
        "qstart" : 905,
        "qcovhsp" : 8,
        "shared_name" : "PpCluster-15424.0",
        "ppos" : 73.94,
        "score" : 1013,
        "pident" : 58.958,
        "SUID" : 17620,
        "selected" : false,
        "sseqid" : "AT5G57990",
        "length" : 307,
        "nident" : 181,
        "evalue" : 6.33E-120,
        "positive" : 227,
        "gaps" : 3,
        "Type" : "protein_coding",
        "bitscore" : 394.0,
        "slen" : 859,
        "mismatch" : 123,
        "name" : "PpCluster-15424.0",
        "send" : 410,
        "qcovs" : 23,
        "PrimarySymbol" : "UBIQUITIN-SPECIFIC PROTEASE 23 (UBP23)",
        "qend" : 1822
      },
      "position" : {
        "x" : 955.194091796875,
        "y" : -2639.59814453125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17619",
        "degree_layout" : 2,
        "Description" : "Encodes a protein with UDP-D-glucose 4-epimerase activity.",
        "SecondarySymbol" : "UDP-D-GLUCOSE/UDP-D-GALACTOSE 4-EPIMERASE 5 (UGE5)",
        "sstart" : 4,
        "qstart" : 1005,
        "qcovhsp" : 9,
        "shared_name" : "PpCluster-15134.1",
        "ppos" : 77.1,
        "score" : 1201,
        "pident" : 65.797,
        "SUID" : 17619,
        "selected" : false,
        "sseqid" : "AT4G10960",
        "length" : 345,
        "nident" : 227,
        "evalue" : 1.28E-154,
        "positive" : 266,
        "gaps" : 1,
        "Type" : "protein_coding",
        "bitscore" : 467.0,
        "slen" : 351,
        "mismatch" : 117,
        "name" : "PpCluster-15134.1",
        "send" : 347,
        "qcovs" : 28,
        "PrimarySymbol" : "UDP-D-GLUCOSE/UDP-D-GALACTOSE 4-EPIMERASE 5 (UGE5)",
        "qend" : 2039
      },
      "position" : {
        "x" : 416.3836364746094,
        "y" : -604.5022583007812
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17616",
        "degree_layout" : 28,
        "Description" : "Encodes a kinesin HINKEL. Required for cytokinesis in pollen. Mutant has cytokinesis defects; seedling lethal.",
        "SecondarySymbol" : "HINKEL (HIK);NPK1-ACTIVATING KINESIN 1 (NACK1);ARABIDOPSIS NPK1-ACTIVATING KINESIN 1 (ATNACK1)",
        "sstart" : 28,
        "qstart" : 689,
        "qcovhsp" : 9,
        "shared_name" : "SpCluster-8516.0",
        "ppos" : 74.22,
        "score" : 1121,
        "pident" : 57.757,
        "SUID" : 17616,
        "selected" : false,
        "sseqid" : "AT1G18370",
        "length" : 419,
        "nident" : 242,
        "evalue" : 1.69E-132,
        "positive" : 311,
        "gaps" : 18,
        "Type" : "protein_coding",
        "bitscore" : 436.0,
        "slen" : 974,
        "mismatch" : 159,
        "name" : "SpCluster-8516.0",
        "send" : 431,
        "qcovs" : 27,
        "PrimarySymbol" : "HINKEL (HIK)",
        "qend" : 1936
      },
      "position" : {
        "x" : 1438.4725341796875,
        "y" : -2245.661689265666
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17615",
        "degree_layout" : 30,
        "Description" : "Kinesin that binds cyclin-dependent kinase CDKA;1 as homodimer or as heterodimer with KCA1",
        "SecondarySymbol" : "KINESIN CDKA ;1 ASSOCIATED 2 (KCA2); (KAC2);KINESIN LIKE PROTEIN FOR ACTIN BASED CHLOROPLAST MOVEMENT 2 (KAC2)",
        "sstart" : 10,
        "qstart" : 884,
        "qcovhsp" : 11,
        "shared_name" : "PpCluster-7618.0",
        "ppos" : 66.32,
        "score" : 1469,
        "pident" : 45.865,
        "SUID" : 17615,
        "selected" : false,
        "sseqid" : "AT5G65460",
        "length" : 665,
        "nident" : 305,
        "evalue" : 1.91E-175,
        "positive" : 441,
        "gaps" : 45,
        "Type" : "protein_coding",
        "bitscore" : 570.0,
        "slen" : 1264,
        "mismatch" : 315,
        "name" : "PpCluster-7618.0",
        "send" : 632,
        "qcovs" : 33,
        "PrimarySymbol" : "KINESIN LIKE PROTEIN FOR ACTIN BASED CHLOROPLAST MOVEMENT 2 (KAC2)",
        "qend" : 2869
      },
      "position" : {
        "x" : 1475.7674560546875,
        "y" : -2318.590644343791
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17614",
        "degree_layout" : 28,
        "Description" : "\"PHRAGMOPLAST ORIENTING KINESIN 2 is one of the two Arabidopsis homologs isolated in yeast two-hybrid screen for interaction partners of maize gene TANGLED1 (TAN1). Based on sequence homology in their motor domains, POK1 and POK2 belong to the kinesin-12 class which also includes the well-characterized group of phragmoplast-associated kinesins AtPAKRPs. Both kinesins are composed of an N-terminal motor domain throughout the entire C terminus and putative cargo binding tail domains. The expression domains for POK2 constructs were broader than those for POK1; both are expressed in tissues enriched for dividing cells. The phenotype of pok1/pok2 double mutants strongly resembles that of maize tan1 mutants, characterized by misoriented mitotic cytoskeletal arrays and misplaced cell walls.\"",
        "SecondarySymbol" : "PHRAGMOPLAST ORIENTING KINESIN 2 (POK2)",
        "sstart" : 129,
        "qstart" : 1253,
        "qcovhsp" : 12,
        "shared_name" : "PpCluster-5327.0",
        "ppos" : 70.17,
        "score" : 1862,
        "pident" : 53.125,
        "SUID" : 17614,
        "selected" : false,
        "sseqid" : "AT3G19050",
        "length" : 704,
        "nident" : 374,
        "evalue" : 0.0,
        "positive" : 494,
        "gaps" : 50,
        "Type" : "protein_coding",
        "bitscore" : 721.0,
        "slen" : 2771,
        "mismatch" : 280,
        "name" : "PpCluster-5327.0",
        "send" : 830,
        "qcovs" : 35,
        "PrimarySymbol" : "PHRAGMOPLAST ORIENTING KINESIN 2 (POK2)",
        "qend" : 3220
      },
      "position" : {
        "x" : 1333.6475830078125,
        "y" : -2330.617255671916
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17613",
        "degree_layout" : 28,
        "Description" : "P-loop containing nucleoside triphosphate hydrolases superfamily protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 40,
        "qstart" : 1162,
        "qcovhsp" : 21,
        "shared_name" : "PpCluster-26518.1",
        "ppos" : 68.65,
        "score" : 2426,
        "pident" : 48.73,
        "SUID" : 17613,
        "selected" : false,
        "sseqid" : "AT3G45850",
        "length" : 1024,
        "nident" : 499,
        "evalue" : 0.0,
        "positive" : 703,
        "gaps" : 20,
        "Type" : "protein_coding",
        "bitscore" : 939.0,
        "slen" : 1058,
        "mismatch" : 505,
        "name" : "PpCluster-26518.1",
        "send" : 1058,
        "qcovs" : 64,
        "PrimarySymbol" : "0",
        "qend" : 4188
      },
      "position" : {
        "x" : 1340.3121337890625,
        "y" : -2284.198798640666
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17612",
        "degree_layout" : 28,
        "Description" : "ATP binding microtubule motor family protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 415,
        "qstart" : 2338,
        "qcovhsp" : 7,
        "shared_name" : "PpCluster-26302.1",
        "ppos" : 68.79,
        "score" : 450,
        "pident" : 61.146,
        "SUID" : 17612,
        "selected" : false,
        "sseqid" : "AT3G16060",
        "length" : 157,
        "nident" : 96,
        "evalue" : 8.29E-47,
        "positive" : 108,
        "gaps" : 5,
        "Type" : "protein_coding",
        "bitscore" : 177.0,
        "slen" : 684,
        "mismatch" : 56,
        "name" : "PpCluster-26302.1",
        "send" : 566,
        "qcovs" : 20,
        "PrimarySymbol" : "0",
        "qend" : 1868
      },
      "position" : {
        "x" : 1377.8424072265625,
        "y" : -2262.416083796916
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17611",
        "degree_layout" : 28,
        "Description" : "\"PHRAGMOPLAST ORIENTING KINESIN 2 is one of the two Arabidopsis homologs isolated in yeast two-hybrid screen for interaction partners of maize gene TANGLED1 (TAN1). Based on sequence homology in their motor domains, POK1 and POK2 belong to the kinesin-12 class which also includes the well-characterized group of phragmoplast-associated kinesins AtPAKRPs. Both kinesins are composed of an N-terminal motor domain throughout the entire C terminus and putative cargo binding tail domains. The expression domains for POK2 constructs were broader than those for POK1; both are expressed in tissues enriched for dividing cells. The phenotype of pok1/pok2 double mutants strongly resembles that of maize tan1 mutants, characterized by misoriented mitotic cytoskeletal arrays and misplaced cell walls.\"",
        "SecondarySymbol" : "PHRAGMOPLAST ORIENTING KINESIN 2 (POK2)",
        "sstart" : 118,
        "qstart" : 1986,
        "qcovhsp" : 5,
        "shared_name" : "PpCluster-24339.0",
        "ppos" : 73.03,
        "score" : 963,
        "pident" : 56.97,
        "SUID" : 17611,
        "selected" : false,
        "sseqid" : "AT3G19050",
        "length" : 330,
        "nident" : 188,
        "evalue" : 0.0,
        "positive" : 241,
        "gaps" : 23,
        "Type" : "protein_coding",
        "bitscore" : 375.0,
        "slen" : 2771,
        "mismatch" : 119,
        "name" : "PpCluster-24339.0",
        "send" : 442,
        "qcovs" : 14,
        "PrimarySymbol" : "PHRAGMOPLAST ORIENTING KINESIN 2 (POK2)",
        "qend" : 2921
      },
      "position" : {
        "x" : 1472.6673583984375,
        "y" : -2267.653388484416
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17610",
        "degree_layout" : 28,
        "Description" : "P-loop nucleoside triphosphate hydrolases superfamily protein with CH (Calponin Homology) domain-containing protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 626,
        "qstart" : 3,
        "qcovhsp" : 4,
        "shared_name" : "PpCluster-2097.4",
        "ppos" : 94.02,
        "score" : 512,
        "pident" : 78.632,
        "SUID" : 17610,
        "selected" : false,
        "sseqid" : "AT1G09170",
        "length" : 117,
        "nident" : 92,
        "evalue" : 3.28E-53,
        "positive" : 110,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 201.0,
        "slen" : 1010,
        "mismatch" : 25,
        "name" : "PpCluster-2097.4",
        "send" : 742,
        "qcovs" : 12,
        "PrimarySymbol" : "0",
        "qend" : 353
      },
      "position" : {
        "x" : 1374.5528564453125,
        "y" : -2304.887763484416
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17609",
        "degree_layout" : 28,
        "Description" : "encodes a kinesin-like protein with an N-terminal microtubule binding motor domain. Protein is localized to the periphery of the cytoplasm and mutants in the gene exhibit altered orientation of cellulose microfibrils and reduced mechanical strength of fibers.",
        "SecondarySymbol" : "FRAGILE FIBER 1 (FRA1)",
        "sstart" : 21,
        "qstart" : 3300,
        "qcovhsp" : 8,
        "shared_name" : "PpCluster-20322.3",
        "ppos" : 64.16,
        "score" : 935,
        "pident" : 52.987,
        "SUID" : 17609,
        "selected" : false,
        "sseqid" : "AT5G47820",
        "length" : 385,
        "nident" : 204,
        "evalue" : 1.97E-106,
        "positive" : 247,
        "gaps" : 40,
        "Type" : "protein_coding",
        "bitscore" : 364.0,
        "slen" : 1035,
        "mismatch" : 141,
        "name" : "PpCluster-20322.3",
        "send" : 399,
        "qcovs" : 23,
        "PrimarySymbol" : "FRAGILE FIBER 1 (FRA1)",
        "qend" : 2248
      },
      "position" : {
        "x" : 1427.4124755859375,
        "y" : -2291.919990046916
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17608",
        "degree_layout" : 29,
        "Description" : "encodes a novel member of the kinesin superfamily of motor proteins. recessive mutations have reduced number of trichome branches.",
        "SecondarySymbol" : "ZWICHEL (ZWI)",
        "sstart" : 55,
        "qstart" : 1283,
        "qcovhsp" : 23,
        "shared_name" : "PpCluster-19878.1",
        "ppos" : 75.8,
        "score" : 3608,
        "pident" : 59.295,
        "SUID" : 17608,
        "selected" : false,
        "sseqid" : "AT5G65930",
        "length" : 1248,
        "nident" : 740,
        "evalue" : 0.0,
        "positive" : 946,
        "gaps" : 51,
        "Type" : "protein_coding",
        "bitscore" : 1394.0,
        "slen" : 1266,
        "mismatch" : 457,
        "name" : "PpCluster-19878.1",
        "send" : 1258,
        "qcovs" : 68,
        "PrimarySymbol" : "ZWICHEL (ZWI)",
        "qend" : 5005
      },
      "position" : {
        "x" : 1361.6678466796875,
        "y" : -2364.197577937541
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17607",
        "degree_layout" : 20,
        "Description" : "P-loop containing nucleoside triphosphate hydrolases superfamily protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 422,
        "qstart" : 1813,
        "qcovhsp" : 6,
        "shared_name" : "PpCluster-15113.0",
        "ppos" : 72.17,
        "score" : 272,
        "pident" : 54.783,
        "SUID" : 17607,
        "selected" : false,
        "sseqid" : "AT5G27550",
        "length" : 115,
        "nident" : 63,
        "evalue" : 1.44E-31,
        "positive" : 83,
        "gaps" : 7,
        "Type" : "protein_coding",
        "bitscore" : 109.0,
        "slen" : 765,
        "mismatch" : 45,
        "name" : "PpCluster-15113.0",
        "send" : 529,
        "qcovs" : 17,
        "PrimarySymbol" : "0",
        "qend" : 1469
      },
      "position" : {
        "x" : 1428.9703369140625,
        "y" : -2376.424872859416
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "18084",
        "degree_layout" : 5,
        "Description" : "",
        "SecondarySymbol" : "",
        "shared_name" : "SpCluster-2423.0",
        "SUID" : 18084,
        "selected" : false,
        "sseqid" : "",
        "Type" : "",
        "name" : "SpCluster-2423.0",
        "PrimarySymbol" : ""
      },
      "position" : {
        "x" : -98.72140502929688,
        "y" : -1522.203369140625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17606",
        "Description" : "transcription initiation factor IIE (TFIIE) alpha subunit family protein / general transcription factor TFIIE family protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 246,
        "qstart" : 1749,
        "qcovhsp" : 2,
        "shared_name" : "SpCluster-18402.0",
        "ppos" : 52.63,
        "score" : 70,
        "pident" : 31.579,
        "SUID" : 17606,
        "selected" : false,
        "sseqid" : "AT4G20810",
        "length" : 57,
        "nident" : 18,
        "evalue" : 3.4,
        "positive" : 30,
        "gaps" : 3,
        "Type" : "protein_coding",
        "bitscore" : 31.6,
        "slen" : 416,
        "mismatch" : 36,
        "name" : "SpCluster-18402.0",
        "send" : 302,
        "qcovs" : 6,
        "PrimarySymbol" : "0",
        "qend" : 1588
      },
      "position" : {
        "x" : 1050.7895699112858,
        "y" : -3629.674072265625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17605",
        "Description" : "C2H2-type zinc finger family protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 150,
        "qstart" : 446,
        "qcovhsp" : 13,
        "shared_name" : "PpCluster-15072.1",
        "ppos" : 51.19,
        "score" : 239,
        "pident" : 38.095,
        "SUID" : 17605,
        "selected" : false,
        "sseqid" : "AT1G02040",
        "length" : 168,
        "nident" : 64,
        "evalue" : 3.78E-22,
        "positive" : 86,
        "gaps" : 31,
        "Type" : "protein_coding",
        "bitscore" : 96.7,
        "slen" : 324,
        "mismatch" : 73,
        "name" : "PpCluster-15072.1",
        "send" : 286,
        "qcovs" : 40,
        "PrimarySymbol" : "0",
        "qend" : 949
      },
      "position" : {
        "x" : 1103.1926460831608,
        "y" : -3730.2021484375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "18083",
        "degree_layout" : 2,
        "Description" : "F-box/FBD/LRR protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 482,
        "qstart" : 112,
        "qcovhsp" : 4,
        "shared_name" : "SpCluster-2314.1",
        "ppos" : 70.97,
        "score" : 67,
        "pident" : 38.71,
        "SUID" : 18083,
        "selected" : false,
        "sseqid" : "AT2G42730",
        "length" : 31,
        "nident" : 12,
        "evalue" : 1.8,
        "positive" : 22,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 30.4,
        "slen" : 737,
        "mismatch" : 19,
        "name" : "SpCluster-2314.1",
        "send" : 512,
        "qcovs" : 11,
        "PrimarySymbol" : "0",
        "qend" : 204
      },
      "position" : {
        "x" : 832.7670288085938,
        "y" : -981.0833129882812
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17600",
        "degree_layout" : 1,
        "Description" : "RNA recognition motif (RRM)-containing protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 353,
        "qstart" : 518,
        "qcovhsp" : 2,
        "shared_name" : "PpCluster-14963.1",
        "ppos" : 79.1,
        "score" : 209,
        "pident" : 53.731,
        "SUID" : 17600,
        "selected" : false,
        "sseqid" : "AT3G23900",
        "length" : 67,
        "nident" : 36,
        "evalue" : 1.86E-16,
        "positive" : 53,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 85.1,
        "slen" : 987,
        "mismatch" : 31,
        "name" : "PpCluster-14963.1",
        "send" : 419,
        "qcovs" : 6,
        "PrimarySymbol" : "0",
        "qend" : 718
      },
      "position" : {
        "x" : 655.4710360876799,
        "y" : -1910.0208740234375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17599",
        "degree_layout" : 12,
        "Description" : "Encodes salt tolerance protein (STO) which confers salt tolerance to yeast cells. Fully complements calcineurin deficient yeast but does not encode a phosphoprotein phosphatase. Sequence has similarities to CONSTANS. STO co-localizes with COP1 and plays a role in light signaling.STO transcript levels are regulated by photoperiod and phtyohormones. STO competes with FLC in the regulation of floral transition genes SOC1 and FT.",
        "SecondarySymbol" : "B-BOX DOMAIN PROTEIN 24 (BBX24);SALT TOLERANCE (STO)",
        "sstart" : 1,
        "qstart" : 2085,
        "qcovhsp" : 4,
        "shared_name" : "PpCluster-3290.0",
        "ppos" : 77.36,
        "score" : 367,
        "pident" : 65.094,
        "SUID" : 17599,
        "selected" : false,
        "sseqid" : "AT1G06040",
        "length" : 106,
        "nident" : 69,
        "evalue" : 4.23E-40,
        "positive" : 82,
        "gaps" : 1,
        "Type" : "protein_coding",
        "bitscore" : 145.0,
        "slen" : 177,
        "mismatch" : 36,
        "name" : "PpCluster-3290.0",
        "send" : 106,
        "qcovs" : 12,
        "PrimarySymbol" : "SALT TOLERANCE (STO)",
        "qend" : 1771
      },
      "position" : {
        "x" : 1898.211402088298,
        "y" : -1073.7694091796875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17598",
        "degree_layout" : 12,
        "Description" : "Encodes salt tolerance protein (STO) which confers salt tolerance to yeast cells. Fully complements calcineurin deficient yeast but does not encode a phosphoprotein phosphatase. Sequence has similarities to CONSTANS. STO co-localizes with COP1 and plays a role in light signaling.STO transcript levels are regulated by photoperiod and phtyohormones. STO competes with FLC in the regulation of floral transition genes SOC1 and FT.",
        "SecondarySymbol" : "B-BOX DOMAIN PROTEIN 24 (BBX24);SALT TOLERANCE (STO)",
        "sstart" : 1,
        "qstart" : 525,
        "qcovhsp" : 4,
        "shared_name" : "PpCluster-18422.0",
        "ppos" : 71.7,
        "score" : 315,
        "pident" : 57.547,
        "SUID" : 17598,
        "selected" : false,
        "sseqid" : "AT1G06040",
        "length" : 106,
        "nident" : 61,
        "evalue" : 3.99E-33,
        "positive" : 76,
        "gaps" : 5,
        "Type" : "protein_coding",
        "bitscore" : 125.0,
        "slen" : 177,
        "mismatch" : 40,
        "name" : "PpCluster-18422.0",
        "send" : 106,
        "qcovs" : 13,
        "PrimarySymbol" : "SALT TOLERANCE (STO)",
        "qend" : 827
      },
      "position" : {
        "x" : 1919.185279041423,
        "y" : -978.76611328125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "18082",
        "degree_layout" : 2,
        "Description" : "\"Similar to terminal ear1 in Zea mays. A member of mei2-like gene family; phylogenetic analysis revealed that TEL1 belongs to the third clade of mei2-like proteins (TEL clade), with conserved two N-terminal RNA recognition motifs (RRM), in addition to the C-terminal RRM, shared among all mei2-like proteins.\"",
        "SecondarySymbol" : "TERMINAL EAR1-LIKE 1 (TEL1)",
        "sstart" : 389,
        "qstart" : 1311,
        "qcovhsp" : 7,
        "shared_name" : "SpCluster-2042.9",
        "ppos" : 60.87,
        "score" : 475,
        "pident" : 46.86,
        "SUID" : 18082,
        "selected" : false,
        "sseqid" : "AT3G26120",
        "length" : 207,
        "nident" : 97,
        "evalue" : 4.13E-50,
        "positive" : 126,
        "gaps" : 17,
        "Type" : "protein_coding",
        "bitscore" : 187.0,
        "slen" : 615,
        "mismatch" : 93,
        "name" : "SpCluster-2042.9",
        "send" : 587,
        "qcovs" : 22,
        "PrimarySymbol" : "TERMINAL EAR1-LIKE 1 (TEL1)",
        "qend" : 718
      },
      "position" : {
        "x" : 117.05738830566406,
        "y" : -1686.2581787109375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17595",
        "degree_layout" : 4,
        "Description" : "\"Encodes a protein with xylosyltransferase activity, which is specific for UDP-xylose as donor substrate and for oligosaccharides with a degree of polymerization >4. Although the enzyme utilizes either cellopentaose or cellohexaose, its activity is four-fold higher with cellohexaose as an acceptor compared to cellopentaose. The enzyme is able to add several xylosyl residues to the acceptor forming mono-, di- and trixylosylated polysaccharides. The mRNA is cell-to-cell mobile.\"",
        "SecondarySymbol" : "ARABIDOPSIS THALIANA UDP-XYLOSYLTRANSFERASE 2 (ATXT2); (ATXXT2);UDP-XYLOSYLTRANSFERASE 2 (XT2);XYG XYLOSYLTRANSFERASE 2 (XXT2)",
        "sstart" : 113,
        "qstart" : 209,
        "qcovhsp" : 23,
        "shared_name" : "SpCluster-13990.0",
        "ppos" : 70.72,
        "score" : 917,
        "pident" : 49.221,
        "SUID" : 17595,
        "selected" : false,
        "sseqid" : "AT4G02500",
        "length" : 321,
        "nident" : 158,
        "evalue" : 1.6E-119,
        "positive" : 227,
        "gaps" : 1,
        "Type" : "protein_coding",
        "bitscore" : 357.0,
        "slen" : 461,
        "mismatch" : 162,
        "name" : "SpCluster-13990.0",
        "send" : 433,
        "qcovs" : 69,
        "PrimarySymbol" : "UDP-XYLOSYLTRANSFERASE 2 (XT2)",
        "qend" : 1168
      },
      "position" : {
        "x" : 1819.5701667367355,
        "y" : -1810.4906479718416
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17594",
        "degree_layout" : 4,
        "Description" : "Galactosyl transferase GMA12/MNN10 family protein;(source:Araport11)",
        "SecondarySymbol" : "XYLOGLUCAN XYLOSYLTRANSFERASE 3 (XXT3)",
        "sstart" : 17,
        "qstart" : 1378,
        "qcovhsp" : 13,
        "shared_name" : "PpCluster-23804.0",
        "ppos" : 77.34,
        "score" : 1444,
        "pident" : 58.879,
        "SUID" : 17594,
        "selected" : false,
        "sseqid" : "AT5G07720",
        "length" : 428,
        "nident" : 252,
        "evalue" : 0.0,
        "positive" : 331,
        "gaps" : 10,
        "Type" : "protein_coding",
        "bitscore" : 560.0,
        "slen" : 457,
        "mismatch" : 166,
        "name" : "PpCluster-23804.0",
        "send" : 437,
        "qcovs" : 38,
        "PrimarySymbol" : "XYLOGLUCAN XYLOSYLTRANSFERASE 3 (XXT3)",
        "qend" : 2652
      },
      "position" : {
        "x" : 1895.7759772836105,
        "y" : -1863.254197776529
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17593",
        "degree_layout" : 2,
        "Description" : "Encodes a bHLH transcription factor involved in CFL1-mediated regulation of cuticle development. Overexpression leads to abnormal cuticle development.",
        "SecondarySymbol" : "ATCFL1 ASSOCIATED PROTEIN 2 (CFLAP2);FLOWERING BHLH 1 (FBH1)",
        "sstart" : 159,
        "qstart" : 2188,
        "qcovhsp" : 3,
        "shared_name" : "PpCluster-24072.0",
        "ppos" : 78.72,
        "score" : 307,
        "pident" : 60.638,
        "SUID" : 17593,
        "selected" : false,
        "sseqid" : "AT1G35460",
        "length" : 94,
        "nident" : 57,
        "evalue" : 5.17E-31,
        "positive" : 74,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 122.0,
        "slen" : 259,
        "mismatch" : 37,
        "name" : "PpCluster-24072.0",
        "send" : 252,
        "qcovs" : 10,
        "PrimarySymbol" : "FLOWERING BHLH 1 (FBH1)",
        "qend" : 2469
      },
      "position" : {
        "x" : 189.54748920337374,
        "y" : -2921.154541015625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17581",
        "Description" : "P-loop containing nucleoside triphosphate hydrolases superfamily protein;(source:Araport11)",
        "SecondarySymbol" : "EMBRYO DEFECTIVE 2765 (EMB2765)",
        "sstart" : 12,
        "qstart" : 4753,
        "qcovhsp" : 30,
        "shared_name" : "SpCluster-2982.0",
        "ppos" : 75.0,
        "score" : 4547,
        "pident" : 60.598,
        "SUID" : 17581,
        "selected" : false,
        "sseqid" : "AT2G38770",
        "length" : 1472,
        "nident" : 892,
        "evalue" : 0.0,
        "positive" : 1104,
        "gaps" : 52,
        "Type" : "protein_coding",
        "bitscore" : 1756.0,
        "slen" : 1509,
        "mismatch" : 528,
        "name" : "SpCluster-2982.0",
        "send" : 1447,
        "qcovs" : 90,
        "PrimarySymbol" : "EMBRYO DEFECTIVE 2765 (EMB2765)",
        "qend" : 386
      },
      "position" : {
        "x" : 515.100910243317,
        "y" : -3804.7648734480895
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17580",
        "degree_layout" : 8,
        "Description" : "\"encodes a member of the DREB subfamily A-5 of ERF/AP2 transcription factor family. The protein contains one AP2 domain. There are 15 members in this subfamily including RAP2.1, RAP2.9 and RAP2.10. A maternally expressed imprinted gene.\"",
        "SecondarySymbol" : "0",
        "sstart" : 5,
        "qstart" : 1357,
        "qcovhsp" : 3,
        "shared_name" : "PpCluster-23465.0",
        "ppos" : 55.17,
        "score" : 177,
        "pident" : 37.069,
        "SUID" : 17580,
        "selected" : false,
        "sseqid" : "AT4G31060",
        "length" : 116,
        "nident" : 43,
        "evalue" : 2.4E-14,
        "positive" : 64,
        "gaps" : 7,
        "Type" : "protein_coding",
        "bitscore" : 72.8,
        "slen" : 187,
        "mismatch" : 66,
        "name" : "PpCluster-23465.0",
        "send" : 115,
        "qcovs" : 10,
        "PrimarySymbol" : "0",
        "qend" : 1016
      },
      "position" : {
        "x" : -748.3481661550688,
        "y" : 214.08469517305616
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17579",
        "degree_layout" : 10,
        "Description" : "encodes a member of the DREB subfamily A-4 of ERF/AP2 transcription factor family. The protein contains one AP2 domain. There are 17 members in this subfamily including TINY. Ectopic overexpression of HRD increases the density of the root network and improves water and salt stress tolerance in Arabidopsis. Overexpression of HRD in rice causes an increase in plant biomass and drought resistance.",
        "SecondarySymbol" : "HARDY (HRD)",
        "sstart" : 10,
        "qstart" : 1344,
        "qcovhsp" : 3,
        "shared_name" : "PpCluster-15655.0",
        "ppos" : 57.97,
        "score" : 148,
        "pident" : 46.377,
        "SUID" : 17579,
        "selected" : false,
        "sseqid" : "AT2G36450",
        "length" : 69,
        "nident" : 32,
        "evalue" : 1.28E-10,
        "positive" : 40,
        "gaps" : 1,
        "Type" : "protein_coding",
        "bitscore" : 61.6,
        "slen" : 184,
        "mismatch" : 36,
        "name" : "PpCluster-15655.0",
        "send" : 78,
        "qcovs" : 8,
        "PrimarySymbol" : "HARDY (HRD)",
        "qend" : 1547
      },
      "position" : {
        "x" : -834.5640475027251,
        "y" : 236.7202542550874
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17578",
        "degree_layout" : 4,
        "Description" : "encodes a member of the DREB subfamily A-5 of ERF/AP2 transcription factor family (RAP2.1). The protein contains one AP2 domain. There are 16 members in this subfamily including RAP2.9 and RAP2.10.",
        "SecondarySymbol" : "RELATED TO AP2 1 (RAP2.1)",
        "sstart" : 11,
        "qstart" : 1389,
        "qcovhsp" : 3,
        "shared_name" : "PpCluster-14078.0",
        "ppos" : 56.79,
        "score" : 135,
        "pident" : 38.272,
        "SUID" : 17578,
        "selected" : false,
        "sseqid" : "AT1G46768",
        "length" : 81,
        "nident" : 31,
        "evalue" : 4.03E-9,
        "positive" : 46,
        "gaps" : 5,
        "Type" : "protein_coding",
        "bitscore" : 56.6,
        "slen" : 153,
        "mismatch" : 45,
        "name" : "PpCluster-14078.0",
        "send" : 90,
        "qcovs" : 8,
        "PrimarySymbol" : "RELATED TO AP2 1 (RAP2.1)",
        "qend" : 1619
      },
      "position" : {
        "x" : -754.5289522878813,
        "y" : 325.84739048555616
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17573",
        "degree_layout" : 4,
        "Description" : "\"Encodes a coiled-coil protein WEB1 (weak chloroplast movement under blue light 1).  WEB1, together with another coiled-coil protein WEB2/PMI2 (At1g66840), maintains the chloroplast photorelocation movement velocity.\"",
        "SecondarySymbol" : "WEAK CHLOROPLAST MOVEMENT UNDER BLUE LIGHT 1 (WEB1)",
        "sstart" : 630,
        "qstart" : 135,
        "qcovhsp" : 2,
        "shared_name" : "PpCluster-13751.1",
        "ppos" : 67.5,
        "score" : 85,
        "pident" : 47.5,
        "SUID" : 17573,
        "selected" : false,
        "sseqid" : "AT2G26570",
        "length" : 40,
        "nident" : 19,
        "evalue" : 0.035,
        "positive" : 27,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 37.4,
        "slen" : 807,
        "mismatch" : 21,
        "name" : "PpCluster-13751.1",
        "send" : 669,
        "qcovs" : 7,
        "PrimarySymbol" : "WEAK CHLOROPLAST MOVEMENT UNDER BLUE LIGHT 1 (WEB1)",
        "qend" : 254
      },
      "position" : {
        "x" : 814.0525512695312,
        "y" : -1346.970458984375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17570",
        "degree_layout" : 5,
        "Description" : "oxidoreductase/transition metal ion-binding protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 241,
        "qstart" : 275,
        "qcovhsp" : 12,
        "shared_name" : "SpCluster-4421.0",
        "ppos" : 56.11,
        "score" : 365,
        "pident" : 35.115,
        "SUID" : 17570,
        "selected" : false,
        "sseqid" : "AT5G52410",
        "length" : 262,
        "nident" : 92,
        "evalue" : 4.76E-36,
        "positive" : 147,
        "gaps" : 20,
        "Type" : "protein_coding",
        "bitscore" : 145.0,
        "slen" : 761,
        "mismatch" : 150,
        "name" : "SpCluster-4421.0",
        "send" : 492,
        "qcovs" : 37,
        "PrimarySymbol" : "0",
        "qend" : 1030
      },
      "position" : {
        "x" : 501.3187255859375,
        "y" : -1337.4278564453125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17569",
        "degree_layout" : 3,
        "Description" : "Ubiquitin carboxyl-terminal hydrolase-related protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 447,
        "qstart" : 586,
        "qcovhsp" : 2,
        "shared_name" : "SpCluster-19937.0",
        "ppos" : 57.89,
        "score" : 68,
        "pident" : 42.105,
        "SUID" : 17569,
        "selected" : false,
        "sseqid" : "AT1G52450",
        "length" : 38,
        "nident" : 16,
        "evalue" : 4.5,
        "positive" : 22,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 30.8,
        "slen" : 1136,
        "mismatch" : 22,
        "name" : "SpCluster-19937.0",
        "send" : 484,
        "qcovs" : 5,
        "PrimarySymbol" : "0",
        "qend" : 699
      },
      "position" : {
        "x" : 570.3046875,
        "y" : -1605.78466796875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17568",
        "degree_layout" : 8,
        "Description" : "\"Encodes a 237-kDA protein with similarity to vertebrate Tpr, a long coiled-coil proteins of nuclear pore inner basket filaments.  It is localized to the inner surface of the nuclear envelope and is a component of the nuclear pore-associated steps of sumoylation and mRNA export in plants.  Mutations affect flowering time regulation and other developmental processes.  Probably acts in the same pathway as ESD4 in affecting flowering time, vegetative and inflorescence development.\"",
        "SecondarySymbol" : "NUCLEAR PORE ANCHOR (NUA)",
        "sstart" : 411,
        "qstart" : 6624,
        "qcovhsp" : 16,
        "shared_name" : "PpCluster-13654.0",
        "ppos" : 64.23,
        "score" : 1484,
        "pident" : 41.058,
        "SUID" : 17568,
        "selected" : false,
        "sseqid" : "AT1G79280",
        "length" : 1096,
        "nident" : 450,
        "evalue" : 3.84E-170,
        "positive" : 704,
        "gaps" : 33,
        "Type" : "protein_coding",
        "bitscore" : 576.0,
        "slen" : 2093,
        "mismatch" : 613,
        "name" : "PpCluster-13654.0",
        "send" : 1485,
        "qcovs" : 49,
        "PrimarySymbol" : "NUCLEAR PORE ANCHOR (NUA)",
        "qend" : 3373
      },
      "position" : {
        "x" : 570.1967163085938,
        "y" : -1506.207275390625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "18079",
        "degree_layout" : 1,
        "Description" : "\"Encodes RDM4, a transcriptional regulator functioning in RNA-directed DNA methylation and plant development.\"",
        "SecondarySymbol" : "RNA-DIRECTED DNA METHYLATION 4 (RDM4);DEFECTIVE IN MERISTEM SILENCING 4 (DMS4)",
        "sstart" : 16,
        "qstart" : 1048,
        "qcovhsp" : 18,
        "shared_name" : "SpCluster-20048.0",
        "ppos" : 47.83,
        "score" : 170,
        "pident" : 29.13,
        "SUID" : 18079,
        "selected" : false,
        "sseqid" : "AT2G30280",
        "length" : 230,
        "nident" : 67,
        "evalue" : 3.42E-13,
        "positive" : 110,
        "gaps" : 35,
        "Type" : "protein_coding",
        "bitscore" : 70.1,
        "slen" : 346,
        "mismatch" : 128,
        "name" : "SpCluster-20048.0",
        "send" : 225,
        "qcovs" : 55,
        "PrimarySymbol" : "RNA-DIRECTED DNA METHYLATION 4 (RDM4)",
        "qend" : 404
      },
      "position" : {
        "x" : 1033.477783203125,
        "y" : -933.7501831054688
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "18078",
        "degree_layout" : 1,
        "Description" : "",
        "SecondarySymbol" : "",
        "shared_name" : "SpCluster-19890.0",
        "SUID" : 18078,
        "selected" : false,
        "sseqid" : "",
        "Type" : "",
        "name" : "SpCluster-19890.0",
        "PrimarySymbol" : ""
      },
      "position" : {
        "x" : 742.4478759765625,
        "y" : -1776.8134765625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "18075",
        "degree_layout" : 1,
        "Description" : "Homologous to the four eubacterial men genes involved in menanoquinone biosynthesis. Studies of mutants defective in this gene demonstrated its involvement in phylloquinone biosynthesis in Arabidopsis. The mRNA is cell-to-cell mobile.",
        "SecondarySymbol" : "PHYLLO (PHYLLO)",
        "sstart" : 1664,
        "qstart" : 227,
        "qcovhsp" : 5,
        "shared_name" : "SpCluster-19524.0",
        "ppos" : 64.52,
        "score" : 90,
        "pident" : 45.161,
        "SUID" : 18075,
        "selected" : false,
        "sseqid" : "AT1G68890",
        "length" : 31,
        "nident" : 14,
        "evalue" : 0.001,
        "positive" : 20,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 39.3,
        "slen" : 1715,
        "mismatch" : 17,
        "name" : "SpCluster-19524.0",
        "send" : 1694,
        "qcovs" : 15,
        "PrimarySymbol" : "PHYLLO (PHYLLO)",
        "qend" : 135
      },
      "position" : {
        "x" : 1240.6488819307883,
        "y" : -2628.760686880575
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "18071",
        "degree_layout" : 1,
        "Description" : "Encodes a membrane-localized protein that is predicted to function during cell wall modification.Overexpression of XTH33 results in abnormal cell morphology. It's expression is under epigenetic control by ATX1.",
        "SecondarySymbol" : "XYLOGLUCAN:XYLOGLUCOSYL TRANSFERASE 33 (XTH33);XYLOGLUCAN:XYLOGLUCOSYL TRANSFERASE 33 (XET)",
        "sstart" : 72,
        "qstart" : 87,
        "qcovhsp" : 9,
        "shared_name" : "SpCluster-19381.1",
        "ppos" : 72.41,
        "score" : 68,
        "pident" : 41.379,
        "SUID" : 18071,
        "selected" : false,
        "sseqid" : "AT1G10550",
        "length" : 29,
        "nident" : 12,
        "evalue" : 0.16,
        "positive" : 21,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 30.8,
        "slen" : 310,
        "mismatch" : 17,
        "name" : "SpCluster-19381.1",
        "send" : 100,
        "qcovs" : 26,
        "PrimarySymbol" : "XYLOGLUCAN:XYLOGLUCOSYL TRANSFERASE 33 (XTH33)",
        "qend" : 1
      },
      "position" : {
        "x" : -1053.65185546875,
        "y" : -583.4365844726562
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "18070",
        "degree_layout" : 2,
        "Description" : "Reduce transmission through pollen. The mRNA is cell-to-cell mobile.",
        "SecondarySymbol" : "(ATNRX1);NUCLEOREDOXIN 1 (NRX1)",
        "sstart" : 500,
        "qstart" : 1802,
        "qcovhsp" : 2,
        "shared_name" : "SpCluster-19369.2",
        "ppos" : 64.44,
        "score" : 114,
        "pident" : 44.444,
        "SUID" : 18070,
        "selected" : false,
        "sseqid" : "AT1G60420",
        "length" : 45,
        "nident" : 20,
        "evalue" : 1.24E-5,
        "positive" : 29,
        "gaps" : 1,
        "Type" : "protein_coding",
        "bitscore" : 48.5,
        "slen" : 578,
        "mismatch" : 24,
        "name" : "SpCluster-19369.2",
        "send" : 543,
        "qcovs" : 7,
        "PrimarySymbol" : "NUCLEOREDOXIN 1 (NRX1)",
        "qend" : 1936
      },
      "position" : {
        "x" : 952.5419311523438,
        "y" : -1374.770751953125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17561",
        "degree_layout" : 10,
        "Description" : "\"Encodes an Arabidopsis response regulator (ARR) protein that acts in concert with other type-B ARRs in the cytokinin signaling pathway. Also involved in cytokinin-dependent inhibition of hypocotyl elongation and cytokinin-dependent greening and shooting in tissue culture. ARR1, ARR10, and ARR12 are redundant regulators of drought response, with ARR1 being the most critical.\"",
        "SecondarySymbol" : "RESPONSE REGULATOR 1 (RR1);RESPONSE REGULATOR 1 (ARR1)",
        "sstart" : 30,
        "qstart" : 163,
        "qcovhsp" : 6,
        "shared_name" : "SpCluster-11637.0",
        "ppos" : 70.33,
        "score" : 724,
        "pident" : 58.242,
        "SUID" : 17561,
        "selected" : false,
        "sseqid" : "AT3G16857",
        "length" : 273,
        "nident" : 159,
        "evalue" : 4.8E-82,
        "positive" : 192,
        "gaps" : 29,
        "Type" : "protein_coding",
        "bitscore" : 283.0,
        "slen" : 669,
        "mismatch" : 85,
        "name" : "SpCluster-11637.0",
        "send" : 301,
        "qcovs" : 19,
        "PrimarySymbol" : "RESPONSE REGULATOR 1 (RR1)",
        "qend" : 897
      },
      "position" : {
        "x" : 994.880126953125,
        "y" : -1422.131103515625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "18065",
        "degree_layout" : 1,
        "Description" : "",
        "SecondarySymbol" : "",
        "shared_name" : "SpCluster-13408.96",
        "SUID" : 18065,
        "selected" : false,
        "sseqid" : "",
        "Type" : "",
        "name" : "SpCluster-13408.96",
        "PrimarySymbol" : ""
      },
      "position" : {
        "x" : -1791.6658935546875,
        "y" : -1014.1756591796875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17560",
        "degree_layout" : 2,
        "Description" : "Peptide-N4-(N-acetyl-beta-glucosaminyl)asparagine amidase A protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 20,
        "qstart" : 581,
        "qcovhsp" : 3,
        "shared_name" : "PpCluster-13268.2",
        "ppos" : 42.31,
        "score" : 67,
        "pident" : 36.538,
        "SUID" : 17560,
        "selected" : false,
        "sseqid" : "AT5G05480",
        "length" : 52,
        "nident" : 19,
        "evalue" : 2.7,
        "positive" : 22,
        "gaps" : 12,
        "Type" : "protein_coding",
        "bitscore" : 30.4,
        "slen" : 608,
        "mismatch" : 21,
        "name" : "PpCluster-13268.2",
        "send" : 71,
        "qcovs" : 9,
        "PrimarySymbol" : "0",
        "qend" : 462
      },
      "position" : {
        "x" : 1156.55712890625,
        "y" : -1297.435546875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17554",
        "degree_layout" : 4,
        "Description" : "homolog of anti-oxidant 1;(source:Araport11)",
        "SecondarySymbol" : "(ATATX1);HOMOLOG OF ANTI-OXIDANT 1 (ATX1)",
        "sstart" : 12,
        "qstart" : 3,
        "qcovhsp" : 19,
        "shared_name" : "SpCluster-62.0",
        "ppos" : 100.0,
        "score" : 437,
        "pident" : 100.0,
        "SUID" : 17554,
        "selected" : false,
        "sseqid" : "AT1G66240",
        "length" : 86,
        "nident" : 86,
        "evalue" : 6.46E-57,
        "positive" : 86,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 172.0,
        "slen" : 106,
        "mismatch" : 0,
        "name" : "SpCluster-62.0",
        "send" : 97,
        "qcovs" : 58,
        "PrimarySymbol" : "HOMOLOG OF ANTI-OXIDANT 1 (ATX1)",
        "qend" : 260
      },
      "position" : {
        "x" : -1064.7827186800503,
        "y" : -105.07507071345795
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17553",
        "degree_layout" : 2,
        "Description" : "",
        "SecondarySymbol" : "",
        "shared_name" : "PpCluster-23230.0",
        "SUID" : 17553,
        "selected" : false,
        "sseqid" : "",
        "Type" : "",
        "name" : "PpCluster-23230.0",
        "PrimarySymbol" : ""
      },
      "position" : {
        "x" : -1234.5429725863003,
        "y" : -192.44065604060637
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17552",
        "degree_layout" : 3,
        "Description" : "\"Encodes one of the 36 carboxylate clamp (CC)-tetratricopeptide repeat (TPR) proteins (Prasad 2010, Pubmed ID: 20856808) with potential to interact with Hsp90/Hsp70 as co-chaperones.\"",
        "SecondarySymbol" : "CLUMPED CHLOROPLASTS 1 (CLMP1);PHOX2 (Phox2)",
        "sstart" : 42,
        "qstart" : 240,
        "qcovhsp" : 3,
        "shared_name" : "SpCluster-2834.0",
        "ppos" : 71.32,
        "score" : 341,
        "pident" : 44.961,
        "SUID" : 17552,
        "selected" : false,
        "sseqid" : "AT1G62390",
        "length" : 129,
        "nident" : 58,
        "evalue" : 2.63E-32,
        "positive" : 92,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 135.0,
        "slen" : 751,
        "mismatch" : 71,
        "name" : "SpCluster-2834.0",
        "send" : 170,
        "qcovs" : 10,
        "PrimarySymbol" : "PHOX2 (Phox2)",
        "qend" : 626
      },
      "position" : {
        "x" : 972.7864990234375,
        "y" : -2560.644287109375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "18063",
        "degree_layout" : 1,
        "Description" : "Encodes a member of a core set of mRNA m6A writer proteins and is required for N6-adenosine methylation of mRNA.",
        "SecondarySymbol" : "EMBRYO DEFECTIVE 1706 (EMB1706);MRNAADENOSINE METHYLASE (MTA)",
        "sstart" : 312,
        "qstart" : 1910,
        "qcovhsp" : 11,
        "shared_name" : "SpCluster-5095.0",
        "ppos" : 85.71,
        "score" : 1448,
        "pident" : 73.077,
        "SUID" : 18063,
        "selected" : false,
        "sseqid" : "AT4G10760",
        "length" : 364,
        "nident" : 266,
        "evalue" : 0.0,
        "positive" : 312,
        "gaps" : 6,
        "Type" : "protein_coding",
        "bitscore" : 562.0,
        "slen" : 685,
        "mismatch" : 92,
        "name" : "SpCluster-5095.0",
        "send" : 669,
        "qcovs" : 33,
        "PrimarySymbol" : "MRNAADENOSINE METHYLASE (MTA)",
        "qend" : 3001
      },
      "position" : {
        "x" : -438.02783203125,
        "y" : -1467.7818603515625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "18062",
        "degree_layout" : 1,
        "Description" : "\"Encodes LOB domain protein whose overexpression results in KNOX gene repression. Overexpression also results in plants with hyponastic leaves, downward pointing flowers and reduced apical dominance.  May be involved in the transcriptional regulation of the homeobox gene BP (brevipedicellus) during lateral organ differentiation.  Acts together with AS2 in proximal-distal symmetry determination.\"",
        "SecondarySymbol" : "ASYMMETRIC LEAVES 2-LIKE 1 (ASL1);LATERAL ORGAN BOUNDARIES DOMAIN GENE 36 (LBD36)",
        "sstart" : 101,
        "qstart" : 394,
        "qcovhsp" : 4,
        "shared_name" : "SpCluster-19209.0",
        "ppos" : 55.88,
        "score" : 68,
        "pident" : 41.176,
        "SUID" : 18062,
        "selected" : false,
        "sseqid" : "AT5G66870",
        "length" : 34,
        "nident" : 14,
        "evalue" : 1.1,
        "positive" : 19,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 30.8,
        "slen" : 313,
        "mismatch" : 20,
        "name" : "SpCluster-19209.0",
        "send" : 134,
        "qcovs" : 12,
        "PrimarySymbol" : "ASYMMETRIC LEAVES 2-LIKE 1 (ASL1)",
        "qend" : 495
      },
      "position" : {
        "x" : -162.33168029785156,
        "y" : -1450.68994140625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17551",
        "degree_layout" : 9,
        "Description" : "\"putative farnesylated protein (At4g38580) mRNA, complete\"",
        "SecondarySymbol" : "FARNESYLATED PROTEIN 6 (ATFP6);FARNESYLATED PROTEIN 6 (FP6);HEAVY METAL ASSOCIATED ISOPRENYLATED PLANT PROTEIN 26 (HIPP26)",
        "sstart" : 15,
        "qstart" : 781,
        "qcovhsp" : 3,
        "shared_name" : "PpCluster-14618.0",
        "ppos" : 55.56,
        "score" : 122,
        "pident" : 40.741,
        "SUID" : 17551,
        "selected" : false,
        "sseqid" : "AT4G38580",
        "length" : 81,
        "nident" : 33,
        "evalue" : 1.99E-7,
        "positive" : 45,
        "gaps" : 5,
        "Type" : "protein_coding",
        "bitscore" : 51.6,
        "slen" : 153,
        "mismatch" : 43,
        "name" : "PpCluster-14618.0",
        "send" : 91,
        "qcovs" : 9,
        "PrimarySymbol" : "FARNESYLATED PROTEIN 6 (FP6)",
        "qend" : 542
      },
      "position" : {
        "x" : -1157.1977577425503,
        "y" : -106.06847891658295
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17550",
        "degree_layout" : 6,
        "Description" : "Heavy metal transport/detoxification superfamily protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 14,
        "qstart" : 852,
        "qcovhsp" : 9,
        "shared_name" : "PpCluster-13904.0",
        "ppos" : 53.12,
        "score" : 152,
        "pident" : 38.542,
        "SUID" : 17550,
        "selected" : false,
        "sseqid" : "AT2G18196",
        "length" : 96,
        "nident" : 37,
        "evalue" : 9.41E-12,
        "positive" : 51,
        "gaps" : 2,
        "Type" : "protein_coding",
        "bitscore" : 63.2,
        "slen" : 178,
        "mismatch" : 57,
        "name" : "PpCluster-13904.0",
        "send" : 109,
        "qcovs" : 26,
        "PrimarySymbol" : "0",
        "qend" : 571
      },
      "position" : {
        "x" : -1212.9252968050503,
        "y" : -151.555066440997
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17549",
        "degree_layout" : 4,
        "Description" : "Heavy metal transport/detoxification superfamily protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 37,
        "qstart" : 562,
        "qcovhsp" : 3,
        "shared_name" : "PpCluster-12712.0",
        "ppos" : 63.64,
        "score" : 80,
        "pident" : 43.182,
        "SUID" : 17549,
        "selected" : false,
        "sseqid" : "AT3G56891",
        "length" : 44,
        "nident" : 19,
        "evalue" : 7.32E-5,
        "positive" : 28,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 35.4,
        "slen" : 166,
        "mismatch" : 25,
        "name" : "PpCluster-12712.0",
        "send" : 80,
        "qcovs" : 8,
        "PrimarySymbol" : "0",
        "qend" : 431
      },
      "position" : {
        "x" : -1255.3818397738003,
        "y" : -42.53955206721771
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17548",
        "degree_layout" : 4,
        "Description" : "Encodes a bHLH transcription factor that is involved in transmitting tract and stigma development.",
        "SecondarySymbol" : "HECATE 3 (HEC3)",
        "sstart" : 148,
        "qstart" : 1251,
        "qcovhsp" : 1,
        "shared_name" : "SpCluster-19593.0",
        "ppos" : 69.23,
        "score" : 100,
        "pident" : 53.846,
        "SUID" : 17548,
        "selected" : false,
        "sseqid" : "AT5G09750",
        "length" : 39,
        "nident" : 21,
        "evalue" : 5.71E-4,
        "positive" : 27,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 43.1,
        "slen" : 224,
        "mismatch" : 18,
        "name" : "SpCluster-19593.0",
        "send" : 186,
        "qcovs" : 3,
        "PrimarySymbol" : "HECATE 3 (HEC3)",
        "qend" : 1135
      },
      "position" : {
        "x" : 384.7964516057175,
        "y" : -2716.132080078125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "18061",
        "degree_layout" : 2,
        "Description" : "Disease resistance protein (TIR-NBS-LRR class) family;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 502,
        "qstart" : 1926,
        "qcovhsp" : 1,
        "shared_name" : "AaCluster-19418.1",
        "ppos" : 63.64,
        "score" : 72,
        "pident" : 39.394,
        "SUID" : 18061,
        "selected" : false,
        "sseqid" : "AT5G41750",
        "length" : 33,
        "nident" : 13,
        "evalue" : 1.9,
        "positive" : 21,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 32.3,
        "slen" : 1068,
        "mismatch" : 20,
        "name" : "AaCluster-19418.1",
        "send" : 534,
        "qcovs" : 4,
        "PrimarySymbol" : "0",
        "qend" : 2024
      },
      "position" : {
        "x" : -229.19964599609375,
        "y" : -1982.9942626953125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17547",
        "degree_layout" : 3,
        "Description" : "basic helix-loop-helix (bHLH) DNA-binding superfamily protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 111,
        "qstart" : 1363,
        "qcovhsp" : 2,
        "shared_name" : "PpCluster-8594.0",
        "ppos" : 66.67,
        "score" : 103,
        "pident" : 36.842,
        "SUID" : 17547,
        "selected" : false,
        "sseqid" : "AT2G22760",
        "length" : 57,
        "nident" : 21,
        "evalue" : 3.04E-4,
        "positive" : 38,
        "gaps" : 1,
        "Type" : "protein_coding",
        "bitscore" : 44.3,
        "slen" : 295,
        "mismatch" : 35,
        "name" : "PpCluster-8594.0",
        "send" : 167,
        "qcovs" : 5,
        "PrimarySymbol" : "0",
        "qend" : 1530
      },
      "position" : {
        "x" : 392.5190163029831,
        "y" : -2776.914306640625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "18060",
        "degree_layout" : 1,
        "Description" : "\"Encodes a L-galactose dehydrogenase, involved in ascorbate biosynthesis\"",
        "SecondarySymbol" : "0",
        "sstart" : 135,
        "qstart" : 1506,
        "qcovhsp" : 3,
        "shared_name" : "SpCluster-19199.1",
        "ppos" : 47.62,
        "score" : 70,
        "pident" : 34.921,
        "SUID" : 18060,
        "selected" : false,
        "sseqid" : "AT4G33670",
        "length" : 63,
        "nident" : 22,
        "evalue" : 1.6,
        "positive" : 30,
        "gaps" : 7,
        "Type" : "protein_coding",
        "bitscore" : 31.6,
        "slen" : 319,
        "mismatch" : 34,
        "name" : "SpCluster-19199.1",
        "send" : 190,
        "qcovs" : 10,
        "PrimarySymbol" : "0",
        "qend" : 1318
      },
      "position" : {
        "x" : -84.85163879394531,
        "y" : -2162.023193359375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17546",
        "degree_layout" : 13,
        "Description" : "basic helix-loop-helix (bHLH) DNA-binding superfamily protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 263,
        "qstart" : 2030,
        "qcovhsp" : 2,
        "shared_name" : "PpCluster-4623.0",
        "ppos" : 87.67,
        "score" : 267,
        "pident" : 68.493,
        "SUID" : 17546,
        "selected" : false,
        "sseqid" : "AT3G21330",
        "length" : 73,
        "nident" : 50,
        "evalue" : 1.17E-24,
        "positive" : 64,
        "gaps" : 1,
        "Type" : "protein_coding",
        "bitscore" : 107.0,
        "slen" : 373,
        "mismatch" : 22,
        "name" : "PpCluster-4623.0",
        "send" : 334,
        "qcovs" : 7,
        "PrimarySymbol" : "0",
        "qend" : 1812
      },
      "position" : {
        "x" : 311.65845111743624,
        "y" : -2602.52685546875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17545",
        "degree_layout" : 8,
        "Description" : "basic helix-loop-helix (bHLH) DNA-binding superfamily protein;(source:Araport11)",
        "SecondarySymbol" : "(BHLH49);CIB1 LIKE PROTEIN 1 (CIL1)",
        "sstart" : 123,
        "qstart" : 1242,
        "qcovhsp" : 8,
        "shared_name" : "PpCluster-14403.1",
        "ppos" : 53.12,
        "score" : 384,
        "pident" : 39.236,
        "SUID" : 17545,
        "selected" : false,
        "sseqid" : "AT1G68920",
        "length" : 288,
        "nident" : 113,
        "evalue" : 5.19E-39,
        "positive" : 153,
        "gaps" : 48,
        "Type" : "protein_coding",
        "bitscore" : 152.0,
        "slen" : 486,
        "mismatch" : 127,
        "name" : "PpCluster-14403.1",
        "send" : 370,
        "qcovs" : 25,
        "PrimarySymbol" : "CIB1 LIKE PROTEIN 1 (CIL1)",
        "qend" : 2081
      },
      "position" : {
        "x" : 200.99107746020968,
        "y" : -2789.66796875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17544",
        "degree_layout" : 12,
        "Description" : "Encodes a bHLH transcription factor that is involved in transmitting tract and stigma development and acts as a local modulator of auxin and cytokinin responses to control gynoecium development. HEC1 affects auxin transport by acting as a transcriptional regulator of PIN1 and PIN3.",
        "SecondarySymbol" : "HECATE 1 (HEC1)",
        "sstart" : 96,
        "qstart" : 1294,
        "qcovhsp" : 3,
        "shared_name" : "PpCluster-14258.0",
        "ppos" : 86.96,
        "score" : 265,
        "pident" : 75.0,
        "SUID" : 17544,
        "selected" : false,
        "sseqid" : "AT5G67060",
        "length" : 92,
        "nident" : 69,
        "evalue" : 1.82E-25,
        "positive" : 80,
        "gaps" : 2,
        "Type" : "protein_coding",
        "bitscore" : 106.0,
        "slen" : 241,
        "mismatch" : 21,
        "name" : "PpCluster-14258.0",
        "send" : 186,
        "qcovs" : 9,
        "PrimarySymbol" : "HECATE 1 (HEC1)",
        "qend" : 1022
      },
      "position" : {
        "x" : 239.96875385181124,
        "y" : -2599.752197265625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17543",
        "degree_layout" : 15,
        "Description" : "basic helix-loop-helix (bHLH) DNA-binding superfamily protein;(source:Araport11)",
        "SecondarySymbol" : "EMBRYO SAC DEVELOPMENT ARREST 33 (EDA33);INDEHISCENT (IND); (GT140);INDEHISCENT (IND1)",
        "sstart" : 110,
        "qstart" : 1333,
        "qcovhsp" : 2,
        "shared_name" : "PpCluster-13601.0",
        "ppos" : 80.0,
        "score" : 252,
        "pident" : 61.25,
        "SUID" : 17543,
        "selected" : false,
        "sseqid" : "AT4G00120",
        "length" : 80,
        "nident" : 49,
        "evalue" : 3.54E-24,
        "positive" : 64,
        "gaps" : 4,
        "Type" : "protein_coding",
        "bitscore" : 101.0,
        "slen" : 198,
        "mismatch" : 27,
        "name" : "PpCluster-13601.0",
        "send" : 189,
        "qcovs" : 7,
        "PrimarySymbol" : "INDEHISCENT (IND)",
        "qend" : 1560
      },
      "position" : {
        "x" : 231.18762592212374,
        "y" : -2679.26611328125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17542",
        "degree_layout" : 15,
        "Description" : "basic helix-loop-helix (bHLH) DNA-binding superfamily protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 142,
        "qstart" : 999,
        "qcovhsp" : 7,
        "shared_name" : "PpCluster-12615.2",
        "ppos" : 64.97,
        "score" : 311,
        "pident" : 44.068,
        "SUID" : 17542,
        "selected" : false,
        "sseqid" : "AT4G37850",
        "length" : 177,
        "nident" : 78,
        "evalue" : 6.23E-31,
        "positive" : 115,
        "gaps" : 15,
        "Type" : "protein_coding",
        "bitscore" : 124.0,
        "slen" : 328,
        "mismatch" : 84,
        "name" : "PpCluster-12615.2",
        "send" : 304,
        "qcovs" : 21,
        "PrimarySymbol" : "0",
        "qend" : 1526
      },
      "position" : {
        "x" : 287.93036273853,
        "y" : -2718.12255859375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17541",
        "degree_layout" : 10,
        "Description" : "",
        "SecondarySymbol" : "",
        "shared_name" : "PpCluster-17103.2",
        "SUID" : 17541,
        "selected" : false,
        "sseqid" : "",
        "Type" : "",
        "name" : "PpCluster-17103.2",
        "PrimarySymbol" : ""
      },
      "position" : {
        "x" : 659.8778686523438,
        "y" : -1551.2098388671875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "18059",
        "degree_layout" : 3,
        "Description" : "Leucine-rich repeat protein kinase family protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 342,
        "qstart" : 212,
        "qcovhsp" : 12,
        "shared_name" : "SpCluster-19155.0",
        "ppos" : 60.0,
        "score" : 64,
        "pident" : 45.0,
        "SUID" : 18059,
        "selected" : false,
        "sseqid" : "AT3G47570",
        "length" : 40,
        "nident" : 18,
        "evalue" : 0.61,
        "positive" : 24,
        "gaps" : 2,
        "Type" : "protein_coding",
        "bitscore" : 29.3,
        "slen" : 1010,
        "mismatch" : 20,
        "name" : "SpCluster-19155.0",
        "send" : 381,
        "qcovs" : 35,
        "PrimarySymbol" : "0",
        "qend" : 325
      },
      "position" : {
        "x" : 68.26875305175781,
        "y" : -1531.239501953125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17540",
        "degree_layout" : 4,
        "Description" : "\"This gene is predicted to encode a protein that functions as a Golgi apparatus structural component known as a golgin in mammals and yeast.  A fluorescently-tagged version of GC5 co-localizes with Golgi markers, and this localization appears to be replicated using the C-terminal (139 aa) portion of the protein. The C-terminal portion of the protein can also specifically interact with two members of the Rab family of GTPases (RabH1b and RabH1c).\"",
        "SecondarySymbol" : "GOLGIN CANDIDATE 5 (GC5)",
        "sstart" : 878,
        "qstart" : 474,
        "qcovhsp" : 3,
        "shared_name" : "SpCluster-17699.0",
        "ppos" : 67.35,
        "score" : 159,
        "pident" : 39.796,
        "SUID" : 17540,
        "selected" : false,
        "sseqid" : "AT1G79830",
        "length" : 98,
        "nident" : 39,
        "evalue" : 1.38E-10,
        "positive" : 66,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 65.9,
        "slen" : 976,
        "mismatch" : 59,
        "name" : "SpCluster-17699.0",
        "send" : 975,
        "qcovs" : 10,
        "PrimarySymbol" : "GOLGIN CANDIDATE 5 (GC5)",
        "qend" : 181
      },
      "position" : {
        "x" : 772.3733520507812,
        "y" : -1358.3524169921875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17539",
        "degree_layout" : 7,
        "Description" : "\"This gene is predicted to encode a protein that functions as a Golgi apparatus structural component known as a golgin in mammals and yeast.  A fluorescently-tagged version of GC5 co-localizes with Golgi markers, and this localization appears to be replicated using the C-terminal (139 aa) portion of the protein. The C-terminal portion of the protein can also specifically interact with two members of the Rab family of GTPases (RabH1b and RabH1c).\"",
        "SecondarySymbol" : "GOLGIN CANDIDATE 5 (GC5)",
        "sstart" : 343,
        "qstart" : 1687,
        "qcovhsp" : 14,
        "shared_name" : "PpCluster-12601.2",
        "ppos" : 75.63,
        "score" : 1396,
        "pident" : 57.868,
        "SUID" : 17539,
        "selected" : false,
        "sseqid" : "AT1G79830",
        "length" : 591,
        "nident" : 342,
        "evalue" : 5.08E-173,
        "positive" : 447,
        "gaps" : 11,
        "Type" : "protein_coding",
        "bitscore" : 542.0,
        "slen" : 956,
        "mismatch" : 238,
        "name" : "PpCluster-12601.2",
        "send" : 924,
        "qcovs" : 42,
        "PrimarySymbol" : "GOLGIN CANDIDATE 5 (GC5)",
        "qend" : 3453
      },
      "position" : {
        "x" : 672.1675415039062,
        "y" : -1405.149658203125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17538",
        "degree_layout" : 5,
        "Description" : "\"This gene is predicted to encode a protein that functions as a Golgi apparatus structural component known as a golgin in mammals and yeast.  A fluorescently-tagged version of GC5 co-localizes with Golgi markers, and this localization appears to be replicated using the C-terminal (139 aa) portion of the protein. The C-terminal portion of the protein can also specifically interact with two members of the Rab family of GTPases (RabH1b and RabH1c).\"",
        "SecondarySymbol" : "GOLGIN CANDIDATE 5 (GC5)",
        "sstart" : 690,
        "qstart" : 197,
        "qcovhsp" : 4,
        "shared_name" : "PpCluster-12601.1",
        "ppos" : 81.63,
        "score" : 280,
        "pident" : 60.204,
        "SUID" : 17538,
        "selected" : false,
        "sseqid" : "AT1G79830",
        "length" : 98,
        "nident" : 59,
        "evalue" : 1.36E-37,
        "positive" : 80,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 112.0,
        "slen" : 976,
        "mismatch" : 39,
        "name" : "PpCluster-12601.1",
        "send" : 787,
        "qcovs" : 12,
        "PrimarySymbol" : "GOLGIN CANDIDATE 5 (GC5)",
        "qend" : 490
      },
      "position" : {
        "x" : 886.5912475585938,
        "y" : -1405.861572265625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17537",
        "degree_layout" : 1,
        "Description" : "\"Member of VQ gene family. VQ proteins are named for the VQ motif (FxxxVQxxTG), a conserved amino acid region. Interacts with members of WRKY gene family, involved in pollen development.\"",
        "SecondarySymbol" : "VQ MOTIF-CONTAINING PROTEIN 20 (VQ20)",
        "sstart" : 72,
        "qstart" : 834,
        "qcovhsp" : 2,
        "shared_name" : "PpCluster-1252.0",
        "ppos" : 71.43,
        "score" : 87,
        "pident" : 42.857,
        "SUID" : 17537,
        "selected" : false,
        "sseqid" : "AT3G18360",
        "length" : 35,
        "nident" : 15,
        "evalue" : 0.013,
        "positive" : 25,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 38.1,
        "slen" : 285,
        "mismatch" : 20,
        "name" : "PpCluster-1252.0",
        "send" : 106,
        "qcovs" : 6,
        "PrimarySymbol" : "VQ MOTIF-CONTAINING PROTEIN 20 (VQ20)",
        "qend" : 730
      },
      "position" : {
        "x" : 737.2554128472472,
        "y" : -2327.1641428168155
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "18055",
        "degree_layout" : 1,
        "Description" : "coiled-coil protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 1,
        "qstart" : 101,
        "qcovhsp" : 27,
        "shared_name" : "SpCluster-19023.0",
        "ppos" : 86.63,
        "score" : 633,
        "pident" : 72.674,
        "SUID" : 18055,
        "selected" : false,
        "sseqid" : "AT5G11500",
        "length" : 172,
        "nident" : 125,
        "evalue" : 4.1E-84,
        "positive" : 149,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 248.0,
        "slen" : 214,
        "mismatch" : 47,
        "name" : "SpCluster-19023.0",
        "send" : 172,
        "qcovs" : 82,
        "PrimarySymbol" : "0",
        "qend" : 616
      },
      "position" : {
        "x" : 432.3398132324219,
        "y" : -1568.6368408203125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17530",
        "degree_layout" : 6,
        "Description" : "\"Encodes a chloroplast-targeted Hsp101 homologue.  Functions as a molecular chaperone involved in plastid differentiation mediating internal thylakoid membrane formation and conferring thermotolerance to chloroplasts during heat stress.  APG6 is constitutively expressed in the root tips, the organ boundary region, the reproductive tissues of mature plants where plastids exist as proplastids, and slightly in the stems and leaves.  APG6 expression is upregulated in response to heat shock in various organs, but not in response to other abiotic stresses.  Apg6 mutants have a pale-green phenotype.\"",
        "SecondarySymbol" : "CASEIN LYTIC PROTEINASE B3 (CLPB3);ALBINO AND PALE GREEN 6 (APG6); (ATCLPB3);CASEIN LYTIC PROTEINASE B-P (CLPB-P)",
        "sstart" : 65,
        "qstart" : 516,
        "qcovhsp" : 25,
        "shared_name" : "SpCluster-3827.0",
        "ppos" : 90.72,
        "score" : 3765,
        "pident" : 78.453,
        "SUID" : 17530,
        "selected" : false,
        "sseqid" : "AT5G15450",
        "length" : 905,
        "nident" : 710,
        "evalue" : 0.0,
        "positive" : 821,
        "gaps" : 5,
        "Type" : "protein_coding",
        "bitscore" : 1454.0,
        "slen" : 968,
        "mismatch" : 190,
        "name" : "SpCluster-3827.0",
        "send" : 966,
        "qcovs" : 76,
        "PrimarySymbol" : "CASEIN LYTIC PROTEINASE B3 (CLPB3)",
        "qend" : 3224
      },
      "position" : {
        "x" : -724.3159790039062,
        "y" : -1704.637451171875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17529",
        "degree_layout" : 8,
        "Description" : "U-box domain-containing protein kinase family protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 776,
        "qstart" : 209,
        "qcovhsp" : 5,
        "shared_name" : "SpCluster-18886.0",
        "ppos" : 72.09,
        "score" : 124,
        "pident" : 53.488,
        "SUID" : 17529,
        "selected" : false,
        "sseqid" : "AT5G61550",
        "length" : 43,
        "nident" : 23,
        "evalue" : 1.84E-7,
        "positive" : 31,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 52.4,
        "slen" : 845,
        "mismatch" : 20,
        "name" : "SpCluster-18886.0",
        "send" : 818,
        "qcovs" : 15,
        "PrimarySymbol" : "0",
        "qend" : 81
      },
      "position" : {
        "x" : -544.0260620117188,
        "y" : -1783.5206298828125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17528",
        "degree_layout" : 5,
        "Description" : "\"Encodes a protein involved in cell elongation in root and anther filaments. Mutants have greater cell volumes in root tissues and have additive phenotypes with other cell expansion mutants such as those carrying mutations in COB, QUI and POM1 loci. POM2/CSI1 promotes Cellulose Synthase and microtubule co-alignment. The mRNA is cell-to-cell mobile.\"",
        "SecondarySymbol" : "CELLULOSE SYNTHASE-INTERACTIVE PROTEIN 1 (CSI1);POM-POM 2 (POM2)",
        "sstart" : 13,
        "qstart" : 298,
        "qcovhsp" : 29,
        "shared_name" : "SpCluster-13981.0",
        "ppos" : 64.43,
        "score" : 3674,
        "pident" : 44.033,
        "SUID" : 17528,
        "selected" : false,
        "sseqid" : "AT2G22125",
        "length" : 2187,
        "nident" : 963,
        "evalue" : 0.0,
        "positive" : 1409,
        "gaps" : 91,
        "Type" : "protein_coding",
        "bitscore" : 1419.0,
        "slen" : 2150,
        "mismatch" : 1133,
        "name" : "SpCluster-13981.0",
        "send" : 2150,
        "qcovs" : 86,
        "PrimarySymbol" : "CELLULOSE SYNTHASE-INTERACTIVE PROTEIN 1 (CSI1)",
        "qend" : 6732
      },
      "position" : {
        "x" : -706.5404663085938,
        "y" : -1651.4844970703125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17527",
        "degree_layout" : 6,
        "Description" : "ATP-dependent Clp protease regulatory subunit The mRNA is cell-to-cell mobile.",
        "SecondarySymbol" : "SENESCENCE ASSOCIATED GENE 15 (SAG15);EARLY RESPONSIVE TO DEHYDRATION 1 (ERD1); (CLPD)",
        "sstart" : 76,
        "qstart" : 3406,
        "qcovhsp" : 17,
        "shared_name" : "PpCluster-26790.1",
        "ppos" : 73.7,
        "score" : 1797,
        "pident" : 59.528,
        "SUID" : 17527,
        "selected" : false,
        "sseqid" : "AT5G51070",
        "length" : 635,
        "nident" : 378,
        "evalue" : 0.0,
        "positive" : 468,
        "gaps" : 39,
        "Type" : "protein_coding",
        "bitscore" : 696.0,
        "slen" : 945,
        "mismatch" : 218,
        "name" : "PpCluster-26790.1",
        "send" : 684,
        "qcovs" : 51,
        "PrimarySymbol" : "EARLY RESPONSIVE TO DEHYDRATION 1 (ERD1)",
        "qend" : 1541
      },
      "position" : {
        "x" : -784.5430908203125,
        "y" : -1755.742431640625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "18051",
        "degree_layout" : 3,
        "Description" : "ASG2 is farnesylated protein and this post-translational modification impacts its subcellular localization. It is the homolog of the human anti-obesity factor WDTC1 and is involved in the negative regulation of fatty acid biosynthesis. The non-farnesylated form displays a nucleo-cytosolic subcellular localization. The farnesylated form displays a cytosolic subcellular localization. Interaction with At4g05420 (DDB1a) was shown using BiFC approach.",
        "SecondarySymbol" : "ALTERED SEED GERMINATION 2 (ASG2)",
        "sstart" : 565,
        "qstart" : 271,
        "qcovhsp" : 18,
        "shared_name" : "SpCluster-18882.0",
        "ppos" : 64.58,
        "score" : 421,
        "pident" : 46.354,
        "SUID" : 18051,
        "selected" : false,
        "sseqid" : "AT5G10940",
        "length" : 192,
        "nident" : 89,
        "evalue" : 5.1E-46,
        "positive" : 124,
        "gaps" : 9,
        "Type" : "protein_coding",
        "bitscore" : 166.0,
        "slen" : 754,
        "mismatch" : 94,
        "name" : "SpCluster-18882.0",
        "send" : 754,
        "qcovs" : 54,
        "PrimarySymbol" : "ALTERED SEED GERMINATION 2 (ASG2)",
        "qend" : 825
      },
      "position" : {
        "x" : -742.4632568359375,
        "y" : -320.9020690917969
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17526",
        "degree_layout" : 6,
        "Description" : "\"Encodes a chloroplast-targeted Hsp101 homologue.  Functions as a molecular chaperone involved in plastid differentiation mediating internal thylakoid membrane formation and conferring thermotolerance to chloroplasts during heat stress.  APG6 is constitutively expressed in the root tips, the organ boundary region, the reproductive tissues of mature plants where plastids exist as proplastids, and slightly in the stems and leaves.  APG6 expression is upregulated in response to heat shock in various organs, but not in response to other abiotic stresses.  Apg6 mutants have a pale-green phenotype.\"",
        "SecondarySymbol" : "CASEIN LYTIC PROTEINASE B3 (CLPB3);ALBINO AND PALE GREEN 6 (APG6); (ATCLPB3);CASEIN LYTIC PROTEINASE B-P (CLPB-P)",
        "sstart" : 559,
        "qstart" : 1798,
        "qcovhsp" : 12,
        "shared_name" : "PpCluster-12306.0",
        "ppos" : 67.5,
        "score" : 1145,
        "pident" : 51.818,
        "SUID" : 17526,
        "selected" : false,
        "sseqid" : "AT5G15450",
        "length" : 440,
        "nident" : 228,
        "evalue" : 3.95E-138,
        "positive" : 297,
        "gaps" : 53,
        "Type" : "protein_coding",
        "bitscore" : 445.0,
        "slen" : 968,
        "mismatch" : 159,
        "name" : "PpCluster-12306.0",
        "send" : 951,
        "qcovs" : 35,
        "PrimarySymbol" : "CASEIN LYTIC PROTEINASE B3 (CLPB3)",
        "qend" : 497
      },
      "position" : {
        "x" : -704.2943725585938,
        "y" : -1802.9122314453125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17525",
        "degree_layout" : 3,
        "Description" : "\"PHRAGMOPLAST ORIENTING KINESIN 2 is one of the two Arabidopsis homologs isolated in yeast two-hybrid screen for interaction partners of maize gene TANGLED1 (TAN1). Based on sequence homology in their motor domains, POK1 and POK2 belong to the kinesin-12 class which also includes the well-characterized group of phragmoplast-associated kinesins AtPAKRPs. Both kinesins are composed of an N-terminal motor domain throughout the entire C terminus and putative cargo binding tail domains. The expression domains for POK2 constructs were broader than those for POK1; both are expressed in tissues enriched for dividing cells. The phenotype of pok1/pok2 double mutants strongly resembles that of maize tan1 mutants, characterized by misoriented mitotic cytoskeletal arrays and misplaced cell walls.\"",
        "SecondarySymbol" : "PHRAGMOPLAST ORIENTING KINESIN 2 (POK2)",
        "sstart" : 2213,
        "qstart" : 2136,
        "qcovhsp" : 25,
        "shared_name" : "PpCluster-6242.0",
        "ppos" : 54.82,
        "score" : 693,
        "pident" : 36.429,
        "SUID" : 17525,
        "selected" : false,
        "sseqid" : "AT3G19050",
        "length" : 560,
        "nident" : 204,
        "evalue" : 3.43E-77,
        "positive" : 307,
        "gaps" : 36,
        "Type" : "protein_coding",
        "bitscore" : 271.0,
        "slen" : 2771,
        "mismatch" : 320,
        "name" : "PpCluster-6242.0",
        "send" : 2766,
        "qcovs" : 74,
        "PrimarySymbol" : "PHRAGMOPLAST ORIENTING KINESIN 2 (POK2)",
        "qend" : 547
      },
      "position" : {
        "x" : 731.3300170898438,
        "y" : -1319.6578369140625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17524",
        "degree_layout" : 18,
        "Description" : "#N/A",
        "SecondarySymbol" : "#N/A",
        "sstart" : 424,
        "qstart" : 4509,
        "qcovhsp" : 1,
        "shared_name" : "PpCluster-17103.0",
        "ppos" : 52.78,
        "score" : 71,
        "pident" : 33.333,
        "SUID" : 17524,
        "selected" : false,
        "sseqid" : "AT3G54670",
        "length" : 72,
        "nident" : 24,
        "evalue" : 6.6,
        "positive" : 38,
        "gaps" : 1,
        "Type" : "#N/A",
        "bitscore" : 32.0,
        "slen" : 1239,
        "mismatch" : 47,
        "name" : "PpCluster-17103.0",
        "send" : 495,
        "qcovs" : 3,
        "PrimarySymbol" : "#N/A",
        "qend" : 4721
      },
      "position" : {
        "x" : 650.8721313476562,
        "y" : -1461.842041015625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17522",
        "degree_layout" : 6,
        "Description" : "\"Encodes WRKY48, a member of the WRKY Transcription Factor. WRKY48 is a stress- and pathogen-induced transcriptional activator that represses plant basal defense. The mRNA is cell-to-cell mobile.\"",
        "SecondarySymbol" : "ARABIDOPSIS THALIANA WRKY DNA-BINDING PROTEIN 48 (ATWRKY48);WRKY DNA-BINDING PROTEIN 48 (WRKY48)",
        "sstart" : 205,
        "qstart" : 1798,
        "qcovhsp" : 4,
        "shared_name" : "SpCluster-9857.0",
        "ppos" : 61.8,
        "score" : 210,
        "pident" : 41.573,
        "SUID" : 17522,
        "selected" : false,
        "sseqid" : "AT5G49520",
        "length" : 89,
        "nident" : 37,
        "evalue" : 1.79E-17,
        "positive" : 55,
        "gaps" : 5,
        "Type" : "protein_coding",
        "bitscore" : 85.5,
        "slen" : 399,
        "mismatch" : 47,
        "name" : "SpCluster-9857.0",
        "send" : 293,
        "qcovs" : 12,
        "PrimarySymbol" : "WRKY DNA-BINDING PROTEIN 48 (WRKY48)",
        "qend" : 1547
      },
      "position" : {
        "x" : -606.6302490234375,
        "y" : -1865.345703125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17521",
        "degree_layout" : 10,
        "Description" : "member of WRKY Transcription Factor; Group II-b",
        "SecondarySymbol" : "(WRKY42); (AtWRKY42)",
        "sstart" : 264,
        "qstart" : 127,
        "qcovhsp" : 5,
        "shared_name" : "SpCluster-6520.0",
        "ppos" : 75.68,
        "score" : 399,
        "pident" : 62.162,
        "SUID" : 17521,
        "selected" : false,
        "sseqid" : "AT4G04450",
        "length" : 111,
        "nident" : 69,
        "evalue" : 4.15E-41,
        "positive" : 84,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 158.0,
        "slen" : 528,
        "mismatch" : 42,
        "name" : "SpCluster-6520.0",
        "send" : 374,
        "qcovs" : 15,
        "PrimarySymbol" : "(WRKY42)",
        "qend" : 459
      },
      "position" : {
        "x" : -709.7400512695312,
        "y" : -1959.551025390625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17520",
        "degree_layout" : 18,
        "Description" : "U-box domain-containing protein kinase family protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 429,
        "qstart" : 2883,
        "qcovhsp" : 6,
        "shared_name" : "SpCluster-11987.0",
        "ppos" : 49.47,
        "score" : 338,
        "pident" : 31.228,
        "SUID" : 17520,
        "selected" : false,
        "sseqid" : "AT5G61560",
        "length" : 285,
        "nident" : 89,
        "evalue" : 9.66E-32,
        "positive" : 141,
        "gaps" : 16,
        "Type" : "protein_coding",
        "bitscore" : 134.0,
        "slen" : 794,
        "mismatch" : 180,
        "name" : "SpCluster-11987.0",
        "send" : 705,
        "qcovs" : 19,
        "PrimarySymbol" : "0",
        "qend" : 2053
      },
      "position" : {
        "x" : -560.5548095703125,
        "y" : -1853.530517578125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17519",
        "degree_layout" : 7,
        "Description" : "member of WRKY Transcription Factor; Group II-e",
        "SecondarySymbol" : "WRKY DNA-BINDING PROTEIN 69 (WRKY69);RABIDOPSIS THALIANA WRKY DNA-BINDING PROTEIN 69 (ATWRKY69)",
        "sstart" : 64,
        "qstart" : 1201,
        "qcovhsp" : 4,
        "shared_name" : "SpCluster-10839.0",
        "ppos" : 62.2,
        "score" : 185,
        "pident" : 42.683,
        "SUID" : 17519,
        "selected" : false,
        "sseqid" : "AT3G58710",
        "length" : 82,
        "nident" : 35,
        "evalue" : 5.01E-15,
        "positive" : 51,
        "gaps" : 2,
        "Type" : "protein_coding",
        "bitscore" : 75.9,
        "slen" : 272,
        "mismatch" : 45,
        "name" : "SpCluster-10839.0",
        "send" : 144,
        "qcovs" : 13,
        "PrimarySymbol" : "WRKY DNA-BINDING PROTEIN 69 (WRKY69)",
        "qend" : 959
      },
      "position" : {
        "x" : -589.9175415039062,
        "y" : -1908.4810791015625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17518",
        "degree_layout" : 4,
        "Description" : "member of WRKY Transcription Factor; Group II-c.  Involved in jasmonic acid inducible defense responses.",
        "SecondarySymbol" : "WRKY DNA-BINDING PROTEIN 50 (WRKY50);ARABIDOPSIS THALIANA WRKY DNA-BINDING PROTEIN 50 (ATWRKY50)",
        "sstart" : 133,
        "qstart" : 1659,
        "qcovhsp" : 2,
        "shared_name" : "PpCluster-3661.0",
        "ppos" : 81.08,
        "score" : 152,
        "pident" : 67.568,
        "SUID" : 17518,
        "selected" : false,
        "sseqid" : "AT5G26170",
        "length" : 37,
        "nident" : 25,
        "evalue" : 2.24E-11,
        "positive" : 30,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 63.2,
        "slen" : 173,
        "mismatch" : 12,
        "name" : "PpCluster-3661.0",
        "send" : 169,
        "qcovs" : 6,
        "PrimarySymbol" : "WRKY DNA-BINDING PROTEIN 50 (WRKY50)",
        "qend" : 1549
      },
      "position" : {
        "x" : -798.0230102539062,
        "y" : -1984.406494140625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17517",
        "degree_layout" : 5,
        "Description" : "Encodes a transcription factor WRKY6.  Regulates Phosphate1 (Pho1) expression in response to low phosphate (Pi) stress.",
        "SecondarySymbol" : "(ATWRKY6); (WRKY6)",
        "sstart" : 270,
        "qstart" : 1708,
        "qcovhsp" : 6,
        "shared_name" : "PpCluster-18610.1",
        "ppos" : 73.99,
        "score" : 406,
        "pident" : 64.74,
        "SUID" : 17517,
        "selected" : false,
        "sseqid" : "AT1G62300",
        "length" : 173,
        "nident" : 112,
        "evalue" : 2.12E-41,
        "positive" : 128,
        "gaps" : 7,
        "Type" : "protein_coding",
        "bitscore" : 160.0,
        "slen" : 553,
        "mismatch" : 54,
        "name" : "PpCluster-18610.1",
        "send" : 435,
        "qcovs" : 17,
        "PrimarySymbol" : "(WRKY6)",
        "qend" : 2226
      },
      "position" : {
        "x" : -631.4544677734375,
        "y" : -1989.998779296875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17516",
        "degree_layout" : 11,
        "Description" : "\"Encodes WRKY57, a member of the WRKY Transcription Factor. Activation of WRKY57 confers drought tolerance.\"",
        "SecondarySymbol" : "(AtWRKY57);WRKY DNA-BINDING PROTEIN 57 (WRKY57)",
        "sstart" : 125,
        "qstart" : 3669,
        "qcovhsp" : 2,
        "shared_name" : "PpCluster-12008.3",
        "ppos" : 81.01,
        "score" : 320,
        "pident" : 65.823,
        "SUID" : 17516,
        "selected" : false,
        "sseqid" : "AT1G69310",
        "length" : 79,
        "nident" : 52,
        "evalue" : 4.71E-32,
        "positive" : 64,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 127.0,
        "slen" : 287,
        "mismatch" : 27,
        "name" : "PpCluster-12008.3",
        "send" : 203,
        "qcovs" : 5,
        "PrimarySymbol" : "WRKY DNA-BINDING PROTEIN 57 (WRKY57)",
        "qend" : 3905
      },
      "position" : {
        "x" : -674.2435913085938,
        "y" : -1884.6441650390625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17501",
        "degree_layout" : 4,
        "Description" : "encodes a member of the DREB subfamily A-4 of ERF/AP2 transcription factor family. The protein contains one AP2 domain. There are 17 members in this subfamily including TINY.",
        "SecondarySymbol" : "TINY2 (TINY2)",
        "sstart" : 30,
        "qstart" : 301,
        "qcovhsp" : 4,
        "shared_name" : "PpCluster-11444.2",
        "ppos" : 53.19,
        "score" : 120,
        "pident" : 36.17,
        "SUID" : 17501,
        "selected" : false,
        "sseqid" : "AT5G11590",
        "length" : 94,
        "nident" : 34,
        "evalue" : 1.24E-6,
        "positive" : 50,
        "gaps" : 2,
        "Type" : "protein_coding",
        "bitscore" : 50.8,
        "slen" : 236,
        "mismatch" : 58,
        "name" : "PpCluster-11444.2",
        "send" : 123,
        "qcovs" : 11,
        "PrimarySymbol" : "TINY2 (TINY2)",
        "qend" : 576
      },
      "position" : {
        "x" : 499.241413221489,
        "y" : -847.8033028699265
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17500",
        "degree_layout" : 4,
        "Description" : "encodes a member of the DREB subfamily A-4 of ERF/AP2 transcription factor family. The protein contains one AP2 domain. There are 17 members in this subfamily including TINY.",
        "SecondarySymbol" : "0",
        "sstart" : 1,
        "qstart" : 244,
        "qcovhsp" : 3,
        "shared_name" : "PpCluster-11444.0",
        "ppos" : 50.0,
        "score" : 95,
        "pident" : 35.0,
        "SUID" : 17500,
        "selected" : false,
        "sseqid" : "AT4G16750",
        "length" : 80,
        "nident" : 28,
        "evalue" : 0.001,
        "positive" : 40,
        "gaps" : 1,
        "Type" : "protein_coding",
        "bitscore" : 41.2,
        "slen" : 179,
        "mismatch" : 51,
        "name" : "PpCluster-11444.0",
        "send" : 80,
        "qcovs" : 9,
        "PrimarySymbol" : "0",
        "qend" : 480
      },
      "position" : {
        "x" : 423.22673426641086,
        "y" : -796.280231580864
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17497",
        "degree_layout" : 3,
        "Description" : "ATP-dependent protease La (LON) domain protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 415,
        "qstart" : 893,
        "qcovhsp" : 9,
        "shared_name" : "SpCluster-16747.1",
        "ppos" : 47.33,
        "score" : 140,
        "pident" : 28.244,
        "SUID" : 17497,
        "selected" : false,
        "sseqid" : "AT2G25740",
        "length" : 131,
        "nident" : 37,
        "evalue" : 5.22E-9,
        "positive" : 62,
        "gaps" : 1,
        "Type" : "protein_coding",
        "bitscore" : 58.5,
        "slen" : 547,
        "mismatch" : 93,
        "name" : "SpCluster-16747.1",
        "send" : 544,
        "qcovs" : 28,
        "PrimarySymbol" : "0",
        "qend" : 1285
      },
      "position" : {
        "x" : 740.1774662445993,
        "y" : -1714.6039134142325
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17496",
        "degree_layout" : 2,
        "Description" : "ATP-dependent protease La (LON) domain protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 349,
        "qstart" : 2157,
        "qcovhsp" : 4,
        "shared_name" : "PpCluster-11251.0",
        "ppos" : 67.31,
        "score" : 419,
        "pident" : 47.436,
        "SUID" : 17496,
        "selected" : false,
        "sseqid" : "AT2G25740",
        "length" : 156,
        "nident" : 74,
        "evalue" : 5.23E-43,
        "positive" : 105,
        "gaps" : 1,
        "Type" : "protein_coding",
        "bitscore" : 166.0,
        "slen" : 547,
        "mismatch" : 81,
        "name" : "PpCluster-11251.0",
        "send" : 503,
        "qcovs" : 13,
        "PrimarySymbol" : "0",
        "qend" : 2624
      },
      "position" : {
        "x" : 769.9636786149457,
        "y" : -1769.6291874360056
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17493",
        "degree_layout" : 3,
        "Description" : "\"Encodes LIGHT-REGULATED WD1 (LWD1), a clock proteins regulating circadian period length and photoperiodic flowering.\"",
        "SecondarySymbol" : "LIGHT-REGULATED WD 1 (LWD1);ANTHOCYANIN11 (ATAN11)",
        "sstart" : 3,
        "qstart" : 1199,
        "qcovhsp" : 11,
        "shared_name" : "PpCluster-11209.0",
        "ppos" : 83.72,
        "score" : 1318,
        "pident" : 70.058,
        "SUID" : 17493,
        "selected" : false,
        "sseqid" : "AT1G12910",
        "length" : 344,
        "nident" : 241,
        "evalue" : 3.04E-174,
        "positive" : 288,
        "gaps" : 4,
        "Type" : "protein_coding",
        "bitscore" : 512.0,
        "slen" : 346,
        "mismatch" : 99,
        "name" : "PpCluster-11209.0",
        "send" : 346,
        "qcovs" : 33,
        "PrimarySymbol" : "ANTHOCYANIN11 (ATAN11)",
        "qend" : 2218
      },
      "position" : {
        "x" : -586.1683349609375,
        "y" : -371.5623474121094
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17490",
        "degree_layout" : 4,
        "Description" : "Allelic to ISE2(increased size  exclusion limit of plasmodesmata 2).  Mutants maintain dilated plasmodesmata at the embryonic torpedo stage.",
        "SecondarySymbol" : "EMBRYO DEFECTIVE 25 (EMB25);INCREASED SIZE EXCLUSION LIMIT 2 (ISE2);PIGMENT DEFECTIVE 317 (PDE317)",
        "sstart" : 126,
        "qstart" : 954,
        "qcovhsp" : 25,
        "shared_name" : "SpCluster-19134.0",
        "ppos" : 58.67,
        "score" : 1951,
        "pident" : 39.173,
        "SUID" : 17490,
        "selected" : false,
        "sseqid" : "AT1G70070",
        "length" : 1113,
        "nident" : 436,
        "evalue" : 0.0,
        "positive" : 653,
        "gaps" : 93,
        "Type" : "protein_coding",
        "bitscore" : 756.0,
        "slen" : 1171,
        "mismatch" : 584,
        "name" : "SpCluster-19134.0",
        "send" : 1169,
        "qcovs" : 76,
        "PrimarySymbol" : "EMBRYO DEFECTIVE 25 (EMB25)",
        "qend" : 4220
      },
      "position" : {
        "x" : -1624.1842014026413,
        "y" : -2697.129888210343
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17489",
        "degree_layout" : 2,
        "Description" : "Allelic to ISE2(increased size  exclusion limit of plasmodesmata 2).  Mutants maintain dilated plasmodesmata at the embryonic torpedo stage.",
        "SecondarySymbol" : "EMBRYO DEFECTIVE 25 (EMB25);INCREASED SIZE EXCLUSION LIMIT 2 (ISE2);PIGMENT DEFECTIVE 317 (PDE317)",
        "sstart" : 977,
        "qstart" : 1336,
        "qcovhsp" : 6,
        "shared_name" : "PpCluster-11072.0",
        "ppos" : 69.9,
        "score" : 462,
        "pident" : 53.061,
        "SUID" : 17489,
        "selected" : false,
        "sseqid" : "AT1G70070",
        "length" : 196,
        "nident" : 104,
        "evalue" : 1.57E-103,
        "positive" : 137,
        "gaps" : 1,
        "Type" : "protein_coding",
        "bitscore" : 182.0,
        "slen" : 1171,
        "mismatch" : 91,
        "name" : "PpCluster-11072.0",
        "send" : 1171,
        "qcovs" : 17,
        "PrimarySymbol" : "EMBRYO DEFECTIVE 25 (EMB25)",
        "qend" : 1923
      },
      "position" : {
        "x" : -1738.9377414417038,
        "y" : -2671.406987819718
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17488",
        "degree_layout" : 2,
        "Description" : "trichohyalin;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 59,
        "qstart" : 4000,
        "qcovhsp" : 4,
        "shared_name" : "SpCluster-20190.0",
        "ppos" : 60.0,
        "score" : 371,
        "pident" : 44.0,
        "SUID" : 17488,
        "selected" : false,
        "sseqid" : "AT3G15550",
        "length" : 175,
        "nident" : 77,
        "evalue" : 3.32E-39,
        "positive" : 105,
        "gaps" : 2,
        "Type" : "protein_coding",
        "bitscore" : 147.0,
        "slen" : 729,
        "mismatch" : 96,
        "name" : "SpCluster-20190.0",
        "send" : 231,
        "qcovs" : 12,
        "PrimarySymbol" : "0",
        "qend" : 3476
      },
      "position" : {
        "x" : 1477.013245373896,
        "y" : -274.1517333984375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17487",
        "degree_layout" : 3,
        "Description" : "trichohyalin;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 7,
        "qstart" : 3152,
        "qcovhsp" : 6,
        "shared_name" : "PpCluster-11058.1",
        "ppos" : 52.59,
        "score" : 433,
        "pident" : 38.793,
        "SUID" : 17487,
        "selected" : false,
        "sseqid" : "AT3G15550",
        "length" : 232,
        "nident" : 90,
        "evalue" : 9.11E-44,
        "positive" : 122,
        "gaps" : 54,
        "Type" : "protein_coding",
        "bitscore" : 171.0,
        "slen" : 729,
        "mismatch" : 88,
        "name" : "PpCluster-11058.1",
        "send" : 184,
        "qcovs" : 18,
        "PrimarySymbol" : "0",
        "qend" : 2457
      },
      "position" : {
        "x" : 1429.1137092410838,
        "y" : -372.8518684207712
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "18048",
        "degree_layout" : 2,
        "Description" : "receptor-like serine/threonine kinase (RKF3) The mRNA is cell-to-cell mobile.",
        "SecondarySymbol" : "RECEPTOR-LIKE KINASE IN IN FLOWERS 3 (RKF3)",
        "sstart" : 530,
        "qstart" : 268,
        "qcovhsp" : 9,
        "shared_name" : "SpCluster-18546.1",
        "ppos" : 55.56,
        "score" : 62,
        "pident" : 33.333,
        "SUID" : 18048,
        "selected" : false,
        "sseqid" : "AT2G48010",
        "length" : 45,
        "nident" : 15,
        "evalue" : 2.5,
        "positive" : 25,
        "gaps" : 2,
        "Type" : "protein_coding",
        "bitscore" : 28.5,
        "slen" : 617,
        "mismatch" : 28,
        "name" : "SpCluster-18546.1",
        "send" : 574,
        "qcovs" : 27,
        "PrimarySymbol" : "RECEPTOR-LIKE KINASE IN IN FLOWERS 3 (RKF3)",
        "qend" : 396
      },
      "position" : {
        "x" : -490.7886962890625,
        "y" : -2154.929443359375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "18047",
        "degree_layout" : 3,
        "Description" : "\"methyltransferase small domain protein, putative (DUF2431);(source:Araport11)\"",
        "SecondarySymbol" : "0",
        "sstart" : 17,
        "qstart" : 1742,
        "qcovhsp" : 3,
        "shared_name" : "SpCluster-6337.1",
        "ppos" : 49.25,
        "score" : 67,
        "pident" : 23.881,
        "SUID" : 18047,
        "selected" : false,
        "sseqid" : "AT5G56075",
        "length" : 67,
        "nident" : 16,
        "evalue" : 4.6,
        "positive" : 33,
        "gaps" : 6,
        "Type" : "protein_coding",
        "bitscore" : 30.4,
        "slen" : 256,
        "mismatch" : 45,
        "name" : "SpCluster-6337.1",
        "send" : 83,
        "qcovs" : 9,
        "PrimarySymbol" : "0",
        "qend" : 1924
      },
      "position" : {
        "x" : -473.6109924316406,
        "y" : -1357.8931884765625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17471",
        "degree_layout" : 8,
        "Description" : "Encodes a ubiquitin-specific protease.",
        "SecondarySymbol" : "(AtUBP12);UBIQUITIN-SPECIFIC PROTEASE 12 (UBP12)",
        "sstart" : 12,
        "qstart" : 4475,
        "qcovhsp" : 21,
        "shared_name" : "PpCluster-19446.0",
        "ppos" : 86.96,
        "score" : 4377,
        "pident" : 73.732,
        "SUID" : 17471,
        "selected" : false,
        "sseqid" : "AT5G06600",
        "length" : 1104,
        "nident" : 814,
        "evalue" : 0.0,
        "positive" : 960,
        "gaps" : 7,
        "Type" : "protein_coding",
        "bitscore" : 1690.0,
        "slen" : 1115,
        "mismatch" : 283,
        "name" : "PpCluster-19446.0",
        "send" : 1113,
        "qcovs" : 63,
        "PrimarySymbol" : "UBIQUITIN-SPECIFIC PROTEASE 12 (UBP12)",
        "qend" : 1179
      },
      "position" : {
        "x" : 902.1170043945312,
        "y" : -2678.998291015625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17470",
        "degree_layout" : 2,
        "Description" : "Encodes a ubiquitin-specific protease.",
        "SecondarySymbol" : "(AtUBP12);UBIQUITIN-SPECIFIC PROTEASE 12 (UBP12)",
        "sstart" : 533,
        "qstart" : 2696,
        "qcovhsp" : 21,
        "shared_name" : "PpCluster-10778.2",
        "ppos" : 85.89,
        "score" : 2215,
        "pident" : 74.39,
        "SUID" : 17470,
        "selected" : false,
        "sseqid" : "AT5G06600",
        "length" : 574,
        "nident" : 427,
        "evalue" : 0.0,
        "positive" : 493,
        "gaps" : 4,
        "Type" : "protein_coding",
        "bitscore" : 857.0,
        "slen" : 1115,
        "mismatch" : 143,
        "name" : "PpCluster-10778.2",
        "send" : 1102,
        "qcovs" : 64,
        "PrimarySymbol" : "UBIQUITIN-SPECIFIC PROTEASE 12 (UBP12)",
        "qend" : 975
      },
      "position" : {
        "x" : 925.8719539704191,
        "y" : -2725.47821617745
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "18046",
        "degree_layout" : 2,
        "Description" : "RNA-binding (RRM/RBD/RNP motifs) family protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 28,
        "qstart" : 1771,
        "qcovhsp" : 10,
        "shared_name" : "SpCluster-18437.0",
        "ppos" : 63.18,
        "score" : 450,
        "pident" : 44.961,
        "SUID" : 18046,
        "selected" : false,
        "sseqid" : "AT5G46840",
        "length" : 258,
        "nident" : 116,
        "evalue" : 3.96E-49,
        "positive" : 163,
        "gaps" : 16,
        "Type" : "protein_coding",
        "bitscore" : 177.0,
        "slen" : 364,
        "mismatch" : 126,
        "name" : "SpCluster-18437.0",
        "send" : 282,
        "qcovs" : 29,
        "PrimarySymbol" : "0",
        "qend" : 1037
      },
      "position" : {
        "x" : -1852.6734619140625,
        "y" : -961.291259765625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17469",
        "degree_layout" : 14,
        "Description" : "Myosin heavy chain-related protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 75,
        "qstart" : 1460,
        "qcovhsp" : 24,
        "shared_name" : "SpCluster-4250.0",
        "ppos" : 54.3,
        "score" : 252,
        "pident" : 27.664,
        "SUID" : 17469,
        "selected" : false,
        "sseqid" : "AT4G32190",
        "length" : 488,
        "nident" : 135,
        "evalue" : 3.79E-22,
        "positive" : 265,
        "gaps" : 2,
        "Type" : "protein_coding",
        "bitscore" : 101.0,
        "slen" : 783,
        "mismatch" : 351,
        "name" : "SpCluster-4250.0",
        "send" : 562,
        "qcovs" : 73,
        "PrimarySymbol" : "0",
        "qend" : 3
      },
      "position" : {
        "x" : 727.2366333007812,
        "y" : -1446.542236328125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17468",
        "degree_layout" : 20,
        "Description" : "Encodes PEROXISOMAL AND MITOCHONDRIAL DIVISION FACTOR2. Involved in mitochondrial morphogenesis.",
        "SecondarySymbol" : "PEROXISOMAL AND MITOCHONDRIAL DIVISION FACTOR 2 (PMD2)",
        "sstart" : 135,
        "qstart" : 1509,
        "qcovhsp" : 3,
        "shared_name" : "SpCluster-14405.2",
        "ppos" : 52.04,
        "score" : 66,
        "pident" : 29.592,
        "SUID" : 17468,
        "selected" : false,
        "sseqid" : "AT1G06530",
        "length" : 98,
        "nident" : 29,
        "evalue" : 8.4,
        "positive" : 51,
        "gaps" : 20,
        "Type" : "protein_coding",
        "bitscore" : 30.0,
        "slen" : 323,
        "mismatch" : 49,
        "name" : "SpCluster-14405.2",
        "send" : 232,
        "qcovs" : 8,
        "PrimarySymbol" : "PEROXISOMAL AND MITOCHONDRIAL DIVISION FACTOR 2 (PMD2)",
        "qend" : 1276
      },
      "position" : {
        "x" : 697.7422485351562,
        "y" : -1521.418212890625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17467",
        "degree_layout" : 7,
        "Description" : "\"Encodes a coiled-coil protein WEB1 (weak chloroplast movement under blue light 1).  WEB1, together with another coiled-coil protein WEB2/PMI2 (At1g66840), maintains the chloroplast photorelocation movement velocity.\"",
        "SecondarySymbol" : "WEAK CHLOROPLAST MOVEMENT UNDER BLUE LIGHT 1 (WEB1)",
        "sstart" : 521,
        "qstart" : 234,
        "qcovhsp" : 4,
        "shared_name" : "PpCluster-23257.0",
        "ppos" : 60.42,
        "score" : 123,
        "pident" : 39.583,
        "SUID" : 17467,
        "selected" : false,
        "sseqid" : "AT2G26570",
        "length" : 96,
        "nident" : 38,
        "evalue" : 1.54E-6,
        "positive" : 58,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 52.0,
        "slen" : 807,
        "mismatch" : 58,
        "name" : "PpCluster-23257.0",
        "send" : 616,
        "qcovs" : 12,
        "PrimarySymbol" : "WEAK CHLOROPLAST MOVEMENT UNDER BLUE LIGHT 1 (WEB1)",
        "qend" : 521
      },
      "position" : {
        "x" : 714.5242919921875,
        "y" : -1391.4281005859375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17466",
        "degree_layout" : 9,
        "Description" : "weak chloroplast movement under blue light protein (DUF827);(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 288,
        "qstart" : 4895,
        "qcovhsp" : 2,
        "shared_name" : "PpCluster-23004.0",
        "ppos" : 55.45,
        "score" : 107,
        "pident" : 32.673,
        "SUID" : 17466,
        "selected" : false,
        "sseqid" : "AT2G38370",
        "length" : 101,
        "nident" : 33,
        "evalue" : 3.39E-4,
        "positive" : 56,
        "gaps" : 1,
        "Type" : "protein_coding",
        "bitscore" : 45.8,
        "slen" : 522,
        "mismatch" : 67,
        "name" : "PpCluster-23004.0",
        "send" : 388,
        "qcovs" : 5,
        "PrimarySymbol" : "0",
        "qend" : 5194
      },
      "position" : {
        "x" : 711.748779296875,
        "y" : -1535.0975341796875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17459",
        "degree_layout" : 1,
        "Description" : "Encodes a UDP-D-glucuronate 4-epimerase involved in pectin biosynthesis in the cell wall and affects cell wall integrity and immunity to fungi and bacteria.",
        "SecondarySymbol" : "UDP-D-GLUCURONATE 4-EPIMERASE 1 (GAE1)",
        "sstart" : 221,
        "qstart" : 1428,
        "qcovhsp" : 14,
        "shared_name" : "PpCluster-10343.0",
        "ppos" : 87.44,
        "score" : 815,
        "pident" : 77.778,
        "SUID" : 17459,
        "selected" : false,
        "sseqid" : "AT4G30440",
        "length" : 207,
        "nident" : 161,
        "evalue" : 1.76E-104,
        "positive" : 181,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 318.0,
        "slen" : 429,
        "mismatch" : 46,
        "name" : "PpCluster-10343.0",
        "send" : 427,
        "qcovs" : 43,
        "PrimarySymbol" : "UDP-D-GLUCURONATE 4-EPIMERASE 1 (GAE1)",
        "qend" : 808
      },
      "position" : {
        "x" : 256.48681640625,
        "y" : -649.7091064453125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17458",
        "degree_layout" : 16,
        "Description" : "Involved in blue light response signaling pathway; interacts with the blue light photoreceptor NPH1. Null mutations abolish phototrophic responses of etiolated seedlings to low fluence blue light.  Protein contains multiple protein-protein interaction domains.",
        "SecondarySymbol" : "NON-PHOTOTROPIC HYPOCOTYL 3 (NPH3); (JK218);ROOT PHOTOTROPISM 3 (RPT3)",
        "sstart" : 276,
        "qstart" : 2008,
        "qcovhsp" : 22,
        "shared_name" : "PpCluster-762.4",
        "ppos" : 57.6,
        "score" : 668,
        "pident" : 37.045,
        "SUID" : 17458,
        "selected" : false,
        "sseqid" : "AT5G64330",
        "length" : 467,
        "nident" : 173,
        "evalue" : 3.33E-77,
        "positive" : 269,
        "gaps" : 39,
        "Type" : "protein_coding",
        "bitscore" : 261.0,
        "slen" : 746,
        "mismatch" : 255,
        "name" : "PpCluster-762.4",
        "send" : 731,
        "qcovs" : 66,
        "PrimarySymbol" : "NON-PHOTOTROPIC HYPOCOTYL 3 (NPH3)",
        "qend" : 692
      },
      "position" : {
        "x" : -140.0222930908203,
        "y" : -1841.022705078125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17457",
        "degree_layout" : 16,
        "Description" : "Involved in blue light response signaling pathway; interacts with the blue light photoreceptor NPH1. Null mutations abolish phototrophic responses of etiolated seedlings to low fluence blue light.  Protein contains multiple protein-protein interaction domains.",
        "SecondarySymbol" : "NON-PHOTOTROPIC HYPOCOTYL 3 (NPH3); (JK218);ROOT PHOTOTROPISM 3 (RPT3)",
        "sstart" : 374,
        "qstart" : 1567,
        "qcovhsp" : 22,
        "shared_name" : "PpCluster-762.20",
        "ppos" : 61.66,
        "score" : 680,
        "pident" : 44.041,
        "SUID" : 17457,
        "selected" : false,
        "sseqid" : "AT5G64330",
        "length" : 386,
        "nident" : 170,
        "evalue" : 5.49E-80,
        "positive" : 238,
        "gaps" : 30,
        "Type" : "protein_coding",
        "bitscore" : 266.0,
        "slen" : 746,
        "mismatch" : 186,
        "name" : "PpCluster-762.20",
        "send" : 746,
        "qcovs" : 66,
        "PrimarySymbol" : "NON-PHOTOTROPIC HYPOCOTYL 3 (NPH3)",
        "qend" : 461
      },
      "position" : {
        "x" : -165.88804626464844,
        "y" : -1894.7945556640625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17456",
        "degree_layout" : 16,
        "Description" : "Involved in blue light response signaling pathway; interacts with the blue light photoreceptor NPH1. Null mutations abolish phototrophic responses of etiolated seedlings to low fluence blue light.  Protein contains multiple protein-protein interaction domains.",
        "SecondarySymbol" : "NON-PHOTOTROPIC HYPOCOTYL 3 (NPH3); (JK218);ROOT PHOTOTROPISM 3 (RPT3)",
        "sstart" : 44,
        "qstart" : 4636,
        "qcovhsp" : 7,
        "shared_name" : "PpCluster-7621.0",
        "ppos" : 57.35,
        "score" : 785,
        "pident" : 39.81,
        "SUID" : 17456,
        "selected" : false,
        "sseqid" : "AT5G64330",
        "length" : 422,
        "nident" : 168,
        "evalue" : 1.08E-90,
        "positive" : 242,
        "gaps" : 71,
        "Type" : "protein_coding",
        "bitscore" : 306.0,
        "slen" : 558,
        "mismatch" : 183,
        "name" : "PpCluster-7621.0",
        "send" : 465,
        "qcovs" : 21,
        "PrimarySymbol" : "NON-PHOTOTROPIC HYPOCOTYL 3 (NPH3)",
        "qend" : 3584
      },
      "position" : {
        "x" : -291.6996154785156,
        "y" : -1845.06005859375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17455",
        "degree_layout" : 16,
        "Description" : "Involved in blue light response signaling pathway; interacts with the blue light photoreceptor NPH1. Null mutations abolish phototrophic responses of etiolated seedlings to low fluence blue light.  Protein contains multiple protein-protein interaction domains.",
        "SecondarySymbol" : "NON-PHOTOTROPIC HYPOCOTYL 3 (NPH3); (JK218);ROOT PHOTOTROPISM 3 (RPT3)",
        "sstart" : 45,
        "qstart" : 2331,
        "qcovhsp" : 21,
        "shared_name" : "PpCluster-6908.0",
        "ppos" : 57.06,
        "score" : 1178,
        "pident" : 40.39,
        "SUID" : 17455,
        "selected" : false,
        "sseqid" : "AT5G64330",
        "length" : 666,
        "nident" : 269,
        "evalue" : 3.39E-148,
        "positive" : 380,
        "gaps" : 39,
        "Type" : "protein_coding",
        "bitscore" : 458.0,
        "slen" : 746,
        "mismatch" : 358,
        "name" : "PpCluster-6908.0",
        "send" : 709,
        "qcovs" : 64,
        "PrimarySymbol" : "NON-PHOTOTROPIC HYPOCOTYL 3 (NPH3)",
        "qend" : 448
      },
      "position" : {
        "x" : -194.8710174560547,
        "y" : -1925.6328125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17454",
        "degree_layout" : 16,
        "Description" : "Involved in blue light response signaling pathway; interacts with the blue light photoreceptor NPH1. Null mutations abolish phototrophic responses of etiolated seedlings to low fluence blue light.  Protein contains multiple protein-protein interaction domains.",
        "SecondarySymbol" : "NON-PHOTOTROPIC HYPOCOTYL 3 (NPH3); (JK218);ROOT PHOTOTROPISM 3 (RPT3)",
        "sstart" : 501,
        "qstart" : 434,
        "qcovhsp" : 4,
        "shared_name" : "PpCluster-3387.0",
        "ppos" : 78.26,
        "score" : 345,
        "pident" : 53.043,
        "SUID" : 17454,
        "selected" : false,
        "sseqid" : "AT5G64330",
        "length" : 115,
        "nident" : 61,
        "evalue" : 3.91E-33,
        "positive" : 90,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 137.0,
        "slen" : 746,
        "mismatch" : 54,
        "name" : "PpCluster-3387.0",
        "send" : 615,
        "qcovs" : 13,
        "PrimarySymbol" : "NON-PHOTOTROPIC HYPOCOTYL 3 (NPH3)",
        "qend" : 778
      },
      "position" : {
        "x" : -240.3404541015625,
        "y" : -1882.4859619140625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17453",
        "degree_layout" : 16,
        "Description" : "Involved in blue light response signaling pathway; interacts with the blue light photoreceptor NPH1. Null mutations abolish phototrophic responses of etiolated seedlings to low fluence blue light.  Protein contains multiple protein-protein interaction domains.",
        "SecondarySymbol" : "NON-PHOTOTROPIC HYPOCOTYL 3 (NPH3); (JK218);ROOT PHOTOTROPISM 3 (RPT3)",
        "sstart" : 27,
        "qstart" : 1421,
        "qcovhsp" : 15,
        "shared_name" : "PpCluster-26340.0",
        "ppos" : 63.8,
        "score" : 1400,
        "pident" : 45.252,
        "SUID" : 17453,
        "selected" : false,
        "sseqid" : "AT5G64330",
        "length" : 674,
        "nident" : 305,
        "evalue" : 5.4E-177,
        "positive" : 430,
        "gaps" : 48,
        "Type" : "protein_coding",
        "bitscore" : 543.0,
        "slen" : 746,
        "mismatch" : 321,
        "name" : "PpCluster-26340.0",
        "send" : 694,
        "qcovs" : 46,
        "PrimarySymbol" : "NON-PHOTOTROPIC HYPOCOTYL 3 (NPH3)",
        "qend" : 3316
      },
      "position" : {
        "x" : -182.19692993164062,
        "y" : -1816.160888671875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "18045",
        "degree_layout" : 1,
        "Description" : "Encodes a microtubule associated protein (MAP70-1). Expressed in all tissues.",
        "SecondarySymbol" : "MICROTUBULE-ASSOCIATED PROTEINS 70-1 (MAP70-1);MICROTUBULE-ASSOCIATED PROTEINS 70-1 (ATMAP70-1)",
        "sstart" : 24,
        "qstart" : 2308,
        "qcovhsp" : 12,
        "shared_name" : "SpCluster-18281.0",
        "ppos" : 74.31,
        "score" : 772,
        "pident" : 49.847,
        "SUID" : 18045,
        "selected" : false,
        "sseqid" : "AT1G68060",
        "length" : 327,
        "nident" : 163,
        "evalue" : 1.69E-91,
        "positive" : 243,
        "gaps" : 5,
        "Type" : "protein_coding",
        "bitscore" : 301.0,
        "slen" : 622,
        "mismatch" : 159,
        "name" : "SpCluster-18281.0",
        "send" : 350,
        "qcovs" : 37,
        "PrimarySymbol" : "MICROTUBULE-ASSOCIATED PROTEINS 70-1 (MAP70-1)",
        "qend" : 1343
      },
      "position" : {
        "x" : 874.63623046875,
        "y" : -1537.8748779296875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17452",
        "degree_layout" : 16,
        "Description" : "Phototropic-responsive NPH3 family protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 58,
        "qstart" : 1483,
        "qcovhsp" : 9,
        "shared_name" : "PpCluster-1888.4",
        "ppos" : 69.83,
        "score" : 1050,
        "pident" : 54.501,
        "SUID" : 17452,
        "selected" : false,
        "sseqid" : "AT5G48800",
        "length" : 411,
        "nident" : 224,
        "evalue" : 2.69E-127,
        "positive" : 287,
        "gaps" : 37,
        "Type" : "protein_coding",
        "bitscore" : 409.0,
        "slen" : 614,
        "mismatch" : 150,
        "name" : "PpCluster-1888.4",
        "send" : 433,
        "qcovs" : 28,
        "PrimarySymbol" : "0",
        "qend" : 2709
      },
      "position" : {
        "x" : -272.03717041015625,
        "y" : -1905.668212890625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17451",
        "degree_layout" : 16,
        "Description" : "Involved in blue light response signaling pathway; interacts with the blue light photoreceptor NPH1. Null mutations abolish phototrophic responses of etiolated seedlings to low fluence blue light.  Protein contains multiple protein-protein interaction domains.",
        "SecondarySymbol" : "NON-PHOTOTROPIC HYPOCOTYL 3 (NPH3); (JK218);ROOT PHOTOTROPISM 3 (RPT3)",
        "sstart" : 47,
        "qstart" : 2708,
        "qcovhsp" : 7,
        "shared_name" : "PpCluster-10272.2",
        "ppos" : 61.71,
        "score" : 1395,
        "pident" : 44.33,
        "SUID" : 17451,
        "selected" : false,
        "sseqid" : "AT5G64330",
        "length" : 679,
        "nident" : 301,
        "evalue" : 3.88E-169,
        "positive" : 419,
        "gaps" : 84,
        "Type" : "protein_coding",
        "bitscore" : 541.0,
        "slen" : 746,
        "mismatch" : 294,
        "name" : "PpCluster-10272.2",
        "send" : 712,
        "qcovs" : 22,
        "PrimarySymbol" : "NON-PHOTOTROPIC HYPOCOTYL 3 (NPH3)",
        "qend" : 4531
      },
      "position" : {
        "x" : -214.6822052001953,
        "y" : -1835.51220703125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "18044",
        "degree_layout" : 1,
        "Description" : "\"Encodes the Arabidopsis thaliana orthologue of metazoan Strawberry notch, a highly conserved co-activator of the developmental regulator Notch. It mediates stress-induced chromatin memory by modulating nucleosome occupancy by interacting with chromatin remodeling proteins of the ISWI and SWI/SNF classes.\"",
        "SecondarySymbol" : "EMBRYO DEFECTIVE 1135 (EMB1135);FORGETTER 1 (FGT1)",
        "sstart" : 199,
        "qstart" : 3782,
        "qcovhsp" : 26,
        "shared_name" : "SpCluster-7521.0",
        "ppos" : 70.51,
        "score" : 3189,
        "pident" : 56.288,
        "SUID" : 18044,
        "selected" : false,
        "sseqid" : "AT1G79350",
        "length" : 1153,
        "nident" : 649,
        "evalue" : 0.0,
        "positive" : 813,
        "gaps" : 73,
        "Type" : "protein_coding",
        "bitscore" : 1233.0,
        "slen" : 1295,
        "mismatch" : 431,
        "name" : "SpCluster-7521.0",
        "send" : 1284,
        "qcovs" : 78,
        "PrimarySymbol" : "EMBRYO DEFECTIVE 1135 (EMB1135)",
        "qend" : 342
      },
      "position" : {
        "x" : -1540.5308810901413,
        "y" : -2288.683843288468
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17450",
        "degree_layout" : 9,
        "Description" : "protein phosphatase 2C and cyclic nucleotide-binding/kinase domain-containing protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 80,
        "qstart" : 3978,
        "qcovhsp" : 19,
        "shared_name" : "SpCluster-17254.0",
        "ppos" : 64.14,
        "score" : 1991,
        "pident" : 45.952,
        "SUID" : 17450,
        "selected" : false,
        "sseqid" : "AT2G20050",
        "length" : 951,
        "nident" : 437,
        "evalue" : 0.0,
        "positive" : 610,
        "gaps" : 48,
        "Type" : "protein_coding",
        "bitscore" : 771.0,
        "slen" : 1094,
        "mismatch" : 466,
        "name" : "SpCluster-17254.0",
        "send" : 1014,
        "qcovs" : 57,
        "PrimarySymbol" : "0",
        "qend" : 1222
      },
      "position" : {
        "x" : -118.05354309082031,
        "y" : -1720.570068359375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17449",
        "degree_layout" : 23,
        "Description" : "Encodes a dual specificity protein kinase which phosphorylates substract proteins on Ser/Thr and Tyr residues.  Some substrates include annexin family proteins.",
        "SecondarySymbol" : "YEAST YAK1-RELATED GENE 1 (YAK1)",
        "sstart" : 85,
        "qstart" : 3631,
        "qcovhsp" : 11,
        "shared_name" : "SpCluster-15346.0",
        "ppos" : 67.31,
        "score" : 1195,
        "pident" : 52.258,
        "SUID" : 17449,
        "selected" : false,
        "sseqid" : "AT5G35980",
        "length" : 465,
        "nident" : 243,
        "evalue" : 1.34E-146,
        "positive" : 313,
        "gaps" : 41,
        "Type" : "protein_coding",
        "bitscore" : 464.0,
        "slen" : 787,
        "mismatch" : 181,
        "name" : "SpCluster-15346.0",
        "send" : 510,
        "qcovs" : 34,
        "PrimarySymbol" : "YEAST YAK1-RELATED GENE 1 (YAK1)",
        "qend" : 2243
      },
      "position" : {
        "x" : -241.664306640625,
        "y" : -1662.5462646484375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17448",
        "degree_layout" : 20,
        "Description" : "Protein kinase superfamily protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 455,
        "qstart" : 1095,
        "qcovhsp" : 10,
        "shared_name" : "PpCluster-25562.3",
        "ppos" : 72.68,
        "score" : 1580,
        "pident" : 60.531,
        "SUID" : 17448,
        "selected" : false,
        "sseqid" : "AT3G25840",
        "length" : 527,
        "nident" : 319,
        "evalue" : 0.0,
        "positive" : 383,
        "gaps" : 57,
        "Type" : "protein_coding",
        "bitscore" : 613.0,
        "slen" : 935,
        "mismatch" : 151,
        "name" : "PpCluster-25562.3",
        "send" : 935,
        "qcovs" : 30,
        "PrimarySymbol" : "0",
        "qend" : 2642
      },
      "position" : {
        "x" : -146.87118530273438,
        "y" : -1735.49853515625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17445",
        "degree_layout" : 3,
        "Description" : "Cysteine/Histidine-rich C1 domain family protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 59,
        "qstart" : 1606,
        "qcovhsp" : 3,
        "shared_name" : "SpCluster-19369.0",
        "ppos" : 55.93,
        "score" : 114,
        "pident" : 35.593,
        "SUID" : 17445,
        "selected" : false,
        "sseqid" : "AT2G27660",
        "length" : 59,
        "nident" : 21,
        "evalue" : 1.36E-5,
        "positive" : 33,
        "gaps" : 5,
        "Type" : "protein_coding",
        "bitscore" : 48.5,
        "slen" : 718,
        "mismatch" : 33,
        "name" : "SpCluster-19369.0",
        "send" : 115,
        "qcovs" : 8,
        "PrimarySymbol" : "0",
        "qend" : 1773
      },
      "position" : {
        "x" : 935.3658447265625,
        "y" : -1514.183349609375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17444",
        "degree_layout" : 3,
        "Description" : "",
        "SecondarySymbol" : "",
        "shared_name" : "PpCluster-8950.1",
        "SUID" : 17444,
        "selected" : false,
        "sseqid" : "",
        "Type" : "",
        "name" : "PpCluster-8950.1",
        "PrimarySymbol" : ""
      },
      "position" : {
        "x" : 877.2386474609375,
        "y" : -1586.7628173828125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17443",
        "degree_layout" : 15,
        "Description" : "\"encodes a protein that physically interacts specifically with the putative coiled-coil region of COP1 in vitro. In hypocotyl and cotyledon protoplasts, it is associated to the cytoskeleton, but not in the root. expression is not regulated by light. The mRNA is cell-to-cell mobile.\"",
        "SecondarySymbol" : "COP1-INTERACTIVE PROTEIN 1 (CIP1)",
        "sstart" : 488,
        "qstart" : 3088,
        "qcovhsp" : 22,
        "shared_name" : "PpCluster-25598.0",
        "ppos" : 44.28,
        "score" : 75,
        "pident" : 23.949,
        "SUID" : 17443,
        "selected" : false,
        "sseqid" : "AT5G41790",
        "length" : 856,
        "nident" : 205,
        "evalue" : 1.1,
        "positive" : 379,
        "gaps" : 173,
        "Type" : "protein_coding",
        "bitscore" : 33.5,
        "slen" : 1586,
        "mismatch" : 478,
        "name" : "PpCluster-25598.0",
        "send" : 1260,
        "qcovs" : 66,
        "PrimarySymbol" : "COP1-INTERACTIVE PROTEIN 1 (CIP1)",
        "qend" : 791
      },
      "position" : {
        "x" : 700.9744262695312,
        "y" : -1607.9130859375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17442",
        "degree_layout" : 14,
        "Description" : "CAP-gly domain linker;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 253,
        "qstart" : 2331,
        "qcovhsp" : 11,
        "shared_name" : "PpCluster-2439.0",
        "ppos" : 48.83,
        "score" : 241,
        "pident" : 30.769,
        "SUID" : 17442,
        "selected" : false,
        "sseqid" : "AT2G39300",
        "length" : 299,
        "nident" : 92,
        "evalue" : 1.4E-20,
        "positive" : 146,
        "gaps" : 46,
        "Type" : "protein_coding",
        "bitscore" : 97.4,
        "slen" : 837,
        "mismatch" : 161,
        "name" : "PpCluster-2439.0",
        "send" : 531,
        "qcovs" : 34,
        "PrimarySymbol" : "0",
        "qend" : 1513
      },
      "position" : {
        "x" : 675.5264282226562,
        "y" : -1593.746337890625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17441",
        "degree_layout" : 36,
        "Description" : "P-loop containing nucleoside triphosphate hydrolases superfamily protein;(source:Araport11)",
        "SecondarySymbol" : "KINESIN 7.1 (KIN7.1)",
        "sstart" : 253,
        "qstart" : 856,
        "qcovhsp" : 13,
        "shared_name" : "PpCluster-20027.0",
        "ppos" : 66.71,
        "score" : 1557,
        "pident" : 53.256,
        "SUID" : 17441,
        "selected" : false,
        "sseqid" : "AT1G21730",
        "length" : 691,
        "nident" : 368,
        "evalue" : 0.0,
        "positive" : 461,
        "gaps" : 65,
        "Type" : "protein_coding",
        "bitscore" : 604.0,
        "slen" : 890,
        "mismatch" : 258,
        "name" : "PpCluster-20027.0",
        "send" : 888,
        "qcovs" : 40,
        "PrimarySymbol" : "KINESIN 7.1 (KIN7.1)",
        "qend" : 2898
      },
      "position" : {
        "x" : 1299.7606201171875,
        "y" : -2237.641913875041
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17440",
        "degree_layout" : 18,
        "Description" : "\"PHRAGMOPLAST ORIENTING KINESIN 2 is one of the two Arabidopsis homologs isolated in yeast two-hybrid screen for interaction partners of maize gene TANGLED1 (TAN1). Based on sequence homology in their motor domains, POK1 and POK2 belong to the kinesin-12 class which also includes the well-characterized group of phragmoplast-associated kinesins AtPAKRPs. Both kinesins are composed of an N-terminal motor domain throughout the entire C terminus and putative cargo binding tail domains. The expression domains for POK2 constructs were broader than those for POK1; both are expressed in tissues enriched for dividing cells. The phenotype of pok1/pok2 double mutants strongly resembles that of maize tan1 mutants, characterized by misoriented mitotic cytoskeletal arrays and misplaced cell walls.\"",
        "SecondarySymbol" : "PHRAGMOPLAST ORIENTING KINESIN 2 (POK2)",
        "sstart" : 2063,
        "qstart" : 2217,
        "qcovhsp" : 12,
        "shared_name" : "PpCluster-12150.0",
        "ppos" : 56.27,
        "score" : 621,
        "pident" : 32.875,
        "SUID" : 17440,
        "selected" : false,
        "sseqid" : "AT3G19050",
        "length" : 654,
        "nident" : 215,
        "evalue" : 2.32E-64,
        "positive" : 368,
        "gaps" : 48,
        "Type" : "protein_coding",
        "bitscore" : 243.0,
        "slen" : 2771,
        "mismatch" : 391,
        "name" : "PpCluster-12150.0",
        "send" : 2686,
        "qcovs" : 37,
        "PrimarySymbol" : "PHRAGMOPLAST ORIENTING KINESIN 2 (POK2)",
        "qend" : 4124
      },
      "position" : {
        "x" : 675.1034545898438,
        "y" : -1436.7969970703125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17435",
        "degree_layout" : 16,
        "Description" : "\"Encodes pseudo-response regulator 3 (APRR3/PRR3). PRR3 transcript levels vary in a circadian pattern with peak expression at dusk under long and short day conditions. PRR3 affects the period of the circadian clock and seedlings with reduced levels of PRR3 have shorter periods, based on transcriptional assays of clock-regulated genes. PRR3 is expressed in the vasculature of cotyledons and leaves where it may help stabilize the TOC1 protein by preventing interactions between TOC1 and the F-box protein ZTL.\"",
        "SecondarySymbol" : "PSEUDO-RESPONSE REGULATOR 3 (PRR3)",
        "sstart" : 55,
        "qstart" : 3227,
        "qcovhsp" : 5,
        "shared_name" : "SpCluster-12761.0",
        "ppos" : 68.91,
        "score" : 519,
        "pident" : 56.995,
        "SUID" : 17435,
        "selected" : false,
        "sseqid" : "AT5G60100",
        "length" : 193,
        "nident" : 110,
        "evalue" : 2.12E-56,
        "positive" : 133,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 204.0,
        "slen" : 495,
        "mismatch" : 83,
        "name" : "SpCluster-12761.0",
        "send" : 247,
        "qcovs" : 16,
        "PrimarySymbol" : "PSEUDO-RESPONSE REGULATOR 3 (PRR3)",
        "qend" : 2649
      },
      "position" : {
        "x" : 1660.593726307048,
        "y" : -1006.4281005859375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17434",
        "degree_layout" : 18,
        "Description" : "B-box type zinc finger protein with CCT domain-containing protein;(source:Araport11)",
        "SecondarySymbol" : "CONSTANS-LIKE 7 (COL7);B-BOX DOMAIN PROTEIN 16 (BBX16)",
        "sstart" : 279,
        "qstart" : 1242,
        "qcovhsp" : 3,
        "shared_name" : "PpCluster-4816.0",
        "ppos" : 61.26,
        "score" : 240,
        "pident" : 46.847,
        "SUID" : 17434,
        "selected" : false,
        "sseqid" : "AT1G73870",
        "length" : 111,
        "nident" : 52,
        "evalue" : 3.77E-21,
        "positive" : 68,
        "gaps" : 15,
        "Type" : "protein_coding",
        "bitscore" : 97.1,
        "slen" : 392,
        "mismatch" : 44,
        "name" : "PpCluster-4816.0",
        "send" : 389,
        "qcovs" : 10,
        "PrimarySymbol" : "B-BOX DOMAIN PROTEIN 16 (BBX16)",
        "qend" : 955
      },
      "position" : {
        "x" : 1825.423316150798,
        "y" : -1069.943359375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "18043",
        "degree_layout" : 3,
        "Description" : "transmembrane protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 145,
        "qstart" : 279,
        "qcovhsp" : 2,
        "shared_name" : "SpCluster-19416.0",
        "ppos" : 53.19,
        "score" : 69,
        "pident" : 36.17,
        "SUID" : 18043,
        "selected" : false,
        "sseqid" : "AT1G71110",
        "length" : 47,
        "nident" : 17,
        "evalue" : 4.7,
        "positive" : 25,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 31.2,
        "slen" : 557,
        "mismatch" : 30,
        "name" : "SpCluster-19416.0",
        "send" : 191,
        "qcovs" : 5,
        "PrimarySymbol" : "0",
        "qend" : 139
      },
      "position" : {
        "x" : 861.4719848632812,
        "y" : -1151.4051513671875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17433",
        "degree_layout" : 18,
        "Description" : "B-box type zinc finger protein with CCT domain-containing protein;(source:Araport11)",
        "SecondarySymbol" : "B-BOX DOMAIN PROTEIN 15 (BBX15)",
        "sstart" : 280,
        "qstart" : 1304,
        "qcovhsp" : 3,
        "shared_name" : "PpCluster-26212.2",
        "ppos" : 52.46,
        "score" : 226,
        "pident" : 43.443,
        "SUID" : 17433,
        "selected" : false,
        "sseqid" : "AT1G25440",
        "length" : 122,
        "nident" : 53,
        "evalue" : 3.4E-19,
        "positive" : 64,
        "gaps" : 19,
        "Type" : "protein_coding",
        "bitscore" : 91.7,
        "slen" : 417,
        "mismatch" : 50,
        "name" : "PpCluster-26212.2",
        "send" : 400,
        "qcovs" : 10,
        "PrimarySymbol" : "B-BOX DOMAIN PROTEIN 15 (BBX15)",
        "qend" : 993
      },
      "position" : {
        "x" : 1848.654517322673,
        "y" : -1009.7750244140625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17432",
        "degree_layout" : 16,
        "Description" : "B-box type zinc finger protein with CCT domain-containing protein;(source:Araport11)",
        "SecondarySymbol" : "B-BOX DOMAIN PROTEIN 14 (BBX14)",
        "sstart" : 279,
        "qstart" : 1149,
        "qcovhsp" : 3,
        "shared_name" : "PpCluster-26212.1",
        "ppos" : 58.47,
        "score" : 252,
        "pident" : 50.0,
        "SUID" : 17432,
        "selected" : false,
        "sseqid" : "AT1G68520",
        "length" : 118,
        "nident" : 59,
        "evalue" : 1.59E-22,
        "positive" : 69,
        "gaps" : 19,
        "Type" : "protein_coding",
        "bitscore" : 101.0,
        "slen" : 406,
        "mismatch" : 40,
        "name" : "PpCluster-26212.1",
        "send" : 396,
        "qcovs" : 10,
        "PrimarySymbol" : "B-BOX DOMAIN PROTEIN 14 (BBX14)",
        "qend" : 853
      },
      "position" : {
        "x" : 1818.626685291423,
        "y" : -956.3568115234375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17431",
        "degree_layout" : 16,
        "Description" : "B-box type zinc finger protein with CCT domain-containing protein;(source:Araport11)",
        "SecondarySymbol" : "B-BOX DOMAIN PROTEIN 15 (BBX15)",
        "sstart" : 328,
        "qstart" : 2513,
        "qcovhsp" : 2,
        "shared_name" : "PpCluster-14718.0",
        "ppos" : 72.37,
        "score" : 222,
        "pident" : 64.474,
        "SUID" : 17431,
        "selected" : false,
        "sseqid" : "AT1G25440",
        "length" : 76,
        "nident" : 49,
        "evalue" : 1.13E-18,
        "positive" : 55,
        "gaps" : 4,
        "Type" : "protein_coding",
        "bitscore" : 90.1,
        "slen" : 417,
        "mismatch" : 23,
        "name" : "PpCluster-14718.0",
        "send" : 403,
        "qcovs" : 6,
        "PrimarySymbol" : "B-BOX DOMAIN PROTEIN 15 (BBX15)",
        "qend" : 2728
      },
      "position" : {
        "x" : 1790.1138679086105,
        "y" : -1017.077392578125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17430",
        "degree_layout" : 12,
        "Description" : "PRR7 and PRR9 are partially redundant essential components of a temperature-sensitive circadian system. CCA1 and LHY had a positive effect on PRR7 expression levels. Acts as transcriptional repressor of CCA1 and LHY.",
        "SecondarySymbol" : "(APRR7);PSEUDO-RESPONSE REGULATOR 7 (PRR7)",
        "sstart" : 662,
        "qstart" : 21,
        "qcovhsp" : 2,
        "shared_name" : "PpCluster-1309.2",
        "ppos" : 88.46,
        "score" : 207,
        "pident" : 76.923,
        "SUID" : 17430,
        "selected" : false,
        "sseqid" : "AT5G02810",
        "length" : 52,
        "nident" : 40,
        "evalue" : 1.96E-16,
        "positive" : 46,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 84.3,
        "slen" : 727,
        "mismatch" : 12,
        "name" : "PpCluster-1309.2",
        "send" : 713,
        "qcovs" : 5,
        "PrimarySymbol" : "PSEUDO-RESPONSE REGULATOR 7 (PRR7)",
        "qend" : 176
      },
      "position" : {
        "x" : 1745.112525135173,
        "y" : -1063.971435546875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17429",
        "degree_layout" : 12,
        "Description" : "PRR7 and PRR9 are partially redundant essential components of a temperature-sensitive circadian system. CCA1 and LHY had a positive effect on PRR7 expression levels. Acts as transcriptional repressor of CCA1 and LHY.",
        "SecondarySymbol" : "(APRR7);PSEUDO-RESPONSE REGULATOR 7 (PRR7)",
        "sstart" : 663,
        "qstart" : 2677,
        "qcovhsp" : 2,
        "shared_name" : "MpCluster-25788.0",
        "ppos" : 77.42,
        "score" : 201,
        "pident" : 67.742,
        "SUID" : 17429,
        "selected" : false,
        "sseqid" : "AT5G02810",
        "length" : 62,
        "nident" : 42,
        "evalue" : 9.86E-16,
        "positive" : 48,
        "gaps" : 7,
        "Type" : "protein_coding",
        "bitscore" : 82.0,
        "slen" : 727,
        "mismatch" : 13,
        "name" : "MpCluster-25788.0",
        "send" : 721,
        "qcovs" : 6,
        "PrimarySymbol" : "PSEUDO-RESPONSE REGULATOR 7 (PRR7)",
        "qend" : 2504
      },
      "position" : {
        "x" : 1732.125220447673,
        "y" : -973.47265625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "18042",
        "degree_layout" : 1,
        "Description" : "stress response protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 103,
        "qstart" : 806,
        "qcovhsp" : 9,
        "shared_name" : "SpCluster-18043.2",
        "ppos" : 52.9,
        "score" : 129,
        "pident" : 34.058,
        "SUID" : 18042,
        "selected" : false,
        "sseqid" : "AT1G60640",
        "length" : 138,
        "nident" : 47,
        "evalue" : 5.54E-8,
        "positive" : 73,
        "gaps" : 27,
        "Type" : "protein_coding",
        "bitscore" : 54.3,
        "slen" : 298,
        "mismatch" : 64,
        "name" : "SpCluster-18043.2",
        "send" : 217,
        "qcovs" : 28,
        "PrimarySymbol" : "0",
        "qend" : 405
      },
      "position" : {
        "x" : -1126.1601600863003,
        "y" : -57.46594366878021
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "18041",
        "degree_layout" : 1,
        "Description" : "",
        "SecondarySymbol" : "",
        "shared_name" : "SpCluster-17976.1",
        "SUID" : 18041,
        "selected" : false,
        "sseqid" : "",
        "Type" : "",
        "name" : "SpCluster-17976.1",
        "PrimarySymbol" : ""
      },
      "position" : {
        "x" : -106.00607299804688,
        "y" : -1411.4835205078125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "18040",
        "degree_layout" : 2,
        "Description" : "\"Encodes SEC24a/ERMO2.  Required for endoplasmic reticulum (ER) morphology. Has epistatic interactions with AT1G55350, AT3G59420, and AT3G10525.\"",
        "SecondarySymbol" : "(AtSEC24A);ENDOPLASMIC RETICULUM MORPHOLOGY 2 (ERMO2); (SEC24A)",
        "sstart" : 266,
        "qstart" : 340,
        "qcovhsp" : 27,
        "shared_name" : "SpCluster-6718.0",
        "ppos" : 74.32,
        "score" : 2113,
        "pident" : 53.806,
        "SUID" : 18040,
        "selected" : false,
        "sseqid" : "AT3G07100",
        "length" : 775,
        "nident" : 417,
        "evalue" : 0.0,
        "positive" : 576,
        "gaps" : 9,
        "Type" : "protein_coding",
        "bitscore" : 818.0,
        "slen" : 1038,
        "mismatch" : 349,
        "name" : "SpCluster-6718.0",
        "send" : 1036,
        "qcovs" : 82,
        "PrimarySymbol" : "ENDOPLASMIC RETICULUM MORPHOLOGY 2 (ERMO2)",
        "qend" : 2649
      },
      "position" : {
        "x" : -58.529945373535156,
        "y" : -1331.5341796875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "18039",
        "degree_layout" : 9,
        "Description" : "homologous to yeast and animal Sec24 proteins; expression in yeast cells enhances their survival under oxidative stress conditions.",
        "SecondarySymbol" : "CLONE EIGHTY-FOUR (CEF)",
        "sstart" : 264,
        "qstart" : 2910,
        "qcovhsp" : 21,
        "shared_name" : "SpCluster-17948.0",
        "ppos" : 72.08,
        "score" : 2287,
        "pident" : 54.79,
        "SUID" : 18039,
        "selected" : false,
        "sseqid" : "AT3G44340",
        "length" : 856,
        "nident" : 469,
        "evalue" : 0.0,
        "positive" : 617,
        "gaps" : 24,
        "Type" : "protein_coding",
        "bitscore" : 885.0,
        "slen" : 1096,
        "mismatch" : 363,
        "name" : "SpCluster-17948.0",
        "send" : 1096,
        "qcovs" : 63,
        "PrimarySymbol" : "CLONE EIGHTY-FOUR (CEF)",
        "qend" : 346
      },
      "position" : {
        "x" : -2.6748924255371094,
        "y" : -1442.3656005859375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "18038",
        "degree_layout" : 1,
        "Description" : "",
        "SecondarySymbol" : "",
        "shared_name" : "SpCluster-11789.0",
        "SUID" : 18038,
        "selected" : false,
        "sseqid" : "",
        "Type" : "",
        "name" : "SpCluster-11789.0",
        "PrimarySymbol" : ""
      },
      "position" : {
        "x" : 942.6531982421875,
        "y" : -1545.6060791015625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17426",
        "degree_layout" : 2,
        "Description" : "Nuclear localized K-homology containing protein that interacts with AS1.",
        "SecondarySymbol" : "RS2-INTERACTING KH PROTEIN (RIK)",
        "sstart" : 79,
        "qstart" : 533,
        "qcovhsp" : 2,
        "shared_name" : "MpCluster-18007.0",
        "ppos" : 73.68,
        "score" : 274,
        "pident" : 60.0,
        "SUID" : 17426,
        "selected" : false,
        "sseqid" : "AT3G29390",
        "length" : 95,
        "nident" : 57,
        "evalue" : 2.47E-24,
        "positive" : 70,
        "gaps" : 7,
        "Type" : "protein_coding",
        "bitscore" : 110.0,
        "slen" : 578,
        "mismatch" : 31,
        "name" : "MpCluster-18007.0",
        "send" : 167,
        "qcovs" : 6,
        "PrimarySymbol" : "RS2-INTERACTING KH PROTEIN (RIK)",
        "qend" : 814
      },
      "position" : {
        "x" : -1140.4581271838913,
        "y" : -2459.719243679093
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "18035",
        "degree_layout" : 2,
        "Description" : "Encodes a nuclear localized splicing factor homolog that is involved in alternative splicing of some mRNAs.",
        "SecondarySymbol" : "ARABIDOPSIS SF1 HOMOLOG (ATSF1)",
        "sstart" : 275,
        "qstart" : 2618,
        "qcovhsp" : 4,
        "shared_name" : "SpCluster-17537.0",
        "ppos" : 68.18,
        "score" : 367,
        "pident" : 53.896,
        "SUID" : 18035,
        "selected" : false,
        "sseqid" : "AT5G51300",
        "length" : 154,
        "nident" : 83,
        "evalue" : 2.27E-35,
        "positive" : 105,
        "gaps" : 5,
        "Type" : "protein_coding",
        "bitscore" : 145.0,
        "slen" : 804,
        "mismatch" : 66,
        "name" : "SpCluster-17537.0",
        "send" : 424,
        "qcovs" : 11,
        "PrimarySymbol" : "ARABIDOPSIS SF1 HOMOLOG (ATSF1)",
        "qend" : 2160
      },
      "position" : {
        "x" : -1587.2913818359375,
        "y" : -1075.2265625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17425",
        "degree_layout" : 7,
        "Description" : "\"U2 snRNP auxilliary factor, large subunit, splicing factor;(source:Araport11)\"",
        "SecondarySymbol" : "(ATU2AF65B); (U2AF65B)",
        "sstart" : 250,
        "qstart" : 2525,
        "qcovhsp" : 8,
        "shared_name" : "SpCluster-18491.0",
        "ppos" : 51.04,
        "score" : 360,
        "pident" : 31.25,
        "SUID" : 17425,
        "selected" : false,
        "sseqid" : "AT1G60900",
        "length" : 288,
        "nident" : 90,
        "evalue" : 2.63E-35,
        "positive" : 147,
        "gaps" : 29,
        "Type" : "protein_coding",
        "bitscore" : 143.0,
        "slen" : 589,
        "mismatch" : 169,
        "name" : "SpCluster-18491.0",
        "send" : 531,
        "qcovs" : 24,
        "PrimarySymbol" : "(U2AF65B)",
        "qend" : 1731
      },
      "position" : {
        "x" : -1393.014404296875,
        "y" : -1035.147705078125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17422",
        "degree_layout" : 3,
        "Description" : "Encodes an ania-6a type arginine-rich cyclin which confers tolerance to LiCl and NaCl when expressed in yeast.",
        "SecondarySymbol" : "ARGININE-RICH CYCLIN 1 (RCY1);MODIFIER OF SNC1 12 (MOS12);ARGININE-RICH CYCLIN 1 (ATRCY1)",
        "sstart" : 102,
        "qstart" : 1675,
        "qcovhsp" : 6,
        "shared_name" : "SpCluster-12625.0",
        "ppos" : 73.68,
        "score" : 313,
        "pident" : 57.895,
        "SUID" : 17422,
        "selected" : false,
        "sseqid" : "AT2G26430",
        "length" : 95,
        "nident" : 55,
        "evalue" : 2.62E-31,
        "positive" : 70,
        "gaps" : 1,
        "Type" : "protein_coding",
        "bitscore" : 125.0,
        "slen" : 361,
        "mismatch" : 39,
        "name" : "SpCluster-12625.0",
        "send" : 195,
        "qcovs" : 17,
        "PrimarySymbol" : "ARGININE-RICH CYCLIN 1 (RCY1)",
        "qend" : 1391
      },
      "position" : {
        "x" : 1973.0425788461105,
        "y" : -1876.771043479654
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17421",
        "degree_layout" : 2,
        "Description" : "Encodes a cyclin T partner CYCT1;5.  Plays important roles in infection with Cauliflower mosaic virus (CaMV).",
        "SecondarySymbol" : "0",
        "sstart" : 31,
        "qstart" : 843,
        "qcovhsp" : 4,
        "shared_name" : "PpCluster-4124.3",
        "ppos" : 89.83,
        "score" : 730,
        "pident" : 79.661,
        "SUID" : 17421,
        "selected" : false,
        "sseqid" : "AT5G45190",
        "length" : 177,
        "nident" : 141,
        "evalue" : 2.55E-83,
        "positive" : 159,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 285.0,
        "slen" : 579,
        "mismatch" : 36,
        "name" : "PpCluster-4124.3",
        "send" : 207,
        "qcovs" : 12,
        "PrimarySymbol" : "0",
        "qend" : 1373
      },
      "position" : {
        "x" : 2047.217017322673,
        "y" : -2013.241502464029
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17420",
        "degree_layout" : 4,
        "Description" : "Encodes an ania-6a type arginine-rich cyclin which confers tolerance to LiCl and NaCl when expressed in yeast.",
        "SecondarySymbol" : "ARGININE-RICH CYCLIN 1 (RCY1);MODIFIER OF SNC1 12 (MOS12);ARGININE-RICH CYCLIN 1 (ATRCY1)",
        "sstart" : 1,
        "qstart" : 5572,
        "qcovhsp" : 4,
        "shared_name" : "MpCluster-15339.0",
        "ppos" : 82.25,
        "score" : 1059,
        "pident" : 68.841,
        "SUID" : 17420,
        "selected" : false,
        "sseqid" : "AT2G26430",
        "length" : 276,
        "nident" : 190,
        "evalue" : 3.08E-129,
        "positive" : 227,
        "gaps" : 1,
        "Type" : "protein_coding",
        "bitscore" : 412.0,
        "slen" : 416,
        "mismatch" : 85,
        "name" : "MpCluster-15339.0",
        "send" : 276,
        "qcovs" : 13,
        "PrimarySymbol" : "ARGININE-RICH CYCLIN 1 (RCY1)",
        "qend" : 4748
      },
      "position" : {
        "x" : 2023.672095447673,
        "y" : -1939.182176292154
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "18034",
        "degree_layout" : 2,
        "Description" : "Encodes a histone H3K4 demethylase repressing floral transition.",
        "SecondarySymbol" : "(PKDM7B);JUMONJI 14 (JMJ14)",
        "sstart" : 13,
        "qstart" : 156,
        "qcovhsp" : 10,
        "shared_name" : "SpCluster-17372.1",
        "ppos" : 49.09,
        "score" : 64,
        "pident" : 38.182,
        "SUID" : 18034,
        "selected" : false,
        "sseqid" : "AT4G20400",
        "length" : 55,
        "nident" : 21,
        "evalue" : 2.2,
        "positive" : 27,
        "gaps" : 6,
        "Type" : "protein_coding",
        "bitscore" : 29.3,
        "slen" : 954,
        "mismatch" : 28,
        "name" : "SpCluster-17372.1",
        "send" : 61,
        "qcovs" : 29,
        "PrimarySymbol" : "JUMONJI 14 (JMJ14)",
        "qend" : 320
      },
      "position" : {
        "x" : 497.60345458984375,
        "y" : -2057.766357421875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "18033",
        "degree_layout" : 2,
        "Description" : "",
        "SecondarySymbol" : "",
        "shared_name" : "SpCluster-17372.3",
        "SUID" : 18033,
        "selected" : false,
        "sseqid" : "",
        "Type" : "",
        "name" : "SpCluster-17372.3",
        "PrimarySymbol" : ""
      },
      "position" : {
        "x" : 461.24444580078125,
        "y" : -1935.609130859375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "18032",
        "degree_layout" : 2,
        "Description" : "",
        "SecondarySymbol" : "",
        "shared_name" : "SpCluster-17372.2",
        "SUID" : 18032,
        "selected" : false,
        "sseqid" : "",
        "Type" : "",
        "name" : "SpCluster-17372.2",
        "PrimarySymbol" : ""
      },
      "position" : {
        "x" : 401.9337463378906,
        "y" : -1958.4635009765625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "18031",
        "degree_layout" : 3,
        "Description" : "",
        "SecondarySymbol" : "",
        "shared_name" : "SpCluster-17372.0",
        "SUID" : 18031,
        "selected" : false,
        "sseqid" : "",
        "Type" : "",
        "name" : "SpCluster-17372.0",
        "PrimarySymbol" : ""
      },
      "position" : {
        "x" : 343.4278869628906,
        "y" : -1770.315673828125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "18030",
        "degree_layout" : 3,
        "Description" : "\"Encodes a member of the Lon protease-like proteins (Lon1/At5g26860, Lon2/At5g47040, Lon3/At3g05780, Lon4/At3g05790).  Lon is a multifunctional ATP-dependent protease which exists in bacteria, archaea and within organelles in eukaryotic cells.  Lon proteases are responsible for the degradation of abnormal, damaged and unstable proteins.\"",
        "SecondarySymbol" : "LON PROTEASE 4 (LON4)",
        "sstart" : 49,
        "qstart" : 3886,
        "qcovhsp" : 22,
        "shared_name" : "SpCluster-17266.0",
        "ppos" : 72.19,
        "score" : 2634,
        "pident" : 56.146,
        "SUID" : 18030,
        "selected" : false,
        "sseqid" : "AT3G05790",
        "length" : 960,
        "nident" : 539,
        "evalue" : 0.0,
        "positive" : 693,
        "gaps" : 80,
        "Type" : "protein_coding",
        "bitscore" : 1019.0,
        "slen" : 942,
        "mismatch" : 341,
        "name" : "SpCluster-17266.0",
        "send" : 942,
        "qcovs" : 65,
        "PrimarySymbol" : "LON PROTEASE 4 (LON4)",
        "qend" : 1049
      },
      "position" : {
        "x" : -581.922119140625,
        "y" : -653.6660766601562
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "18029",
        "degree_layout" : 1,
        "Description" : "Encodes a type-I DNA topoisomerase I. Disruptions in this gene affect phyllotaxis and plant architecture suggesting that the gene plays a critical role in the maintenance of a regular pattern of organ initiation. Isolated as a protein oxidized during seed germination; proteomics approach revealed differences in de novo synthesis levels of this protein in condition with vs. without salicylic acid in the period from 0 to 40 hrs. following seed imbibition. Functions in stem cell maintenance at all stages of shoot and floral meristems and in the regulation of gene silencing.",
        "SecondarySymbol" : "FASCIATA5 (FAS5);DNA TOPOISOMERASE I ALPHA (TOP1ALPHA)",
        "sstart" : 366,
        "qstart" : 1102,
        "qcovhsp" : 17,
        "shared_name" : "SpCluster-17120.0",
        "ppos" : 82.66,
        "score" : 1965,
        "pident" : 69.526,
        "SUID" : 18029,
        "selected" : false,
        "sseqid" : "AT5G55300",
        "length" : 548,
        "nident" : 381,
        "evalue" : 0.0,
        "positive" : 453,
        "gaps" : 4,
        "Type" : "protein_coding",
        "bitscore" : 761.0,
        "slen" : 916,
        "mismatch" : 163,
        "name" : "SpCluster-17120.0",
        "send" : 913,
        "qcovs" : 51,
        "PrimarySymbol" : "DNA TOPOISOMERASE I ALPHA (TOP1ALPHA)",
        "qend" : 2733
      },
      "position" : {
        "x" : 1757.8650886117355,
        "y" : -1787.8063217999666
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "18028",
        "degree_layout" : 1,
        "Description" : "APEM9 is required for both PTS1- and PTS2-dependent protein transport. APEM9 interacts with PEX6 in BiFC assay and mating-based Split ubiquitin system. BiFC data shows that APEM9 is required for peroxisomal localization of PEX1-PEX6 complex. These results indicate that APEM9 functions like mammalian PEX26 and yeast PEX15.",
        "SecondarySymbol" : "ABERRANT PEROXISOME MORPHOLOGY 9 (APEM9); (DAYU); (PEX26)",
        "sstart" : 9,
        "qstart" : 115,
        "qcovhsp" : 6,
        "shared_name" : "SpCluster-19153.0",
        "ppos" : 41.61,
        "score" : 102,
        "pident" : 21.739,
        "SUID" : 18028,
        "selected" : false,
        "sseqid" : "AT3G10572",
        "length" : 161,
        "nident" : 35,
        "evalue" : 4.01E-4,
        "positive" : 67,
        "gaps" : 46,
        "Type" : "protein_coding",
        "bitscore" : 43.9,
        "slen" : 333,
        "mismatch" : 80,
        "name" : "SpCluster-19153.0",
        "send" : 123,
        "qcovs" : 17,
        "PrimarySymbol" : "ABERRANT PEROXISOME MORPHOLOGY 9 (APEM9)",
        "qend" : 597
      },
      "position" : {
        "x" : 692.5,
        "y" : -1130.9254150390625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "18027",
        "degree_layout" : 1,
        "Description" : "diaminopimelate epimerase family protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 78,
        "qstart" : 609,
        "qcovhsp" : 19,
        "shared_name" : "SpCluster-13189.0",
        "ppos" : 72.36,
        "score" : 770,
        "pident" : 57.091,
        "SUID" : 18027,
        "selected" : false,
        "sseqid" : "AT3G53580",
        "length" : 275,
        "nident" : 157,
        "evalue" : 1.14E-98,
        "positive" : 199,
        "gaps" : 15,
        "Type" : "protein_coding",
        "bitscore" : 301.0,
        "slen" : 362,
        "mismatch" : 103,
        "name" : "SpCluster-13189.0",
        "send" : 337,
        "qcovs" : 58,
        "PrimarySymbol" : "0",
        "qend" : 1433
      },
      "position" : {
        "x" : 638.494873046875,
        "y" : -1107.2254638671875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17413",
        "degree_layout" : 1,
        "Description" : "polyribonucleotide nucleotidyltransferase;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 53,
        "qstart" : 2699,
        "qcovhsp" : 20,
        "shared_name" : "KfCluster-9164.0",
        "ppos" : 73.1,
        "score" : 1961,
        "pident" : 53.219,
        "SUID" : 17413,
        "selected" : false,
        "sseqid" : "AT5G14580",
        "length" : 699,
        "nident" : 372,
        "evalue" : 0.0,
        "positive" : 511,
        "gaps" : 4,
        "Type" : "protein_coding",
        "bitscore" : 759.0,
        "slen" : 991,
        "mismatch" : 323,
        "name" : "KfCluster-9164.0",
        "send" : 748,
        "qcovs" : 60,
        "PrimarySymbol" : "0",
        "qend" : 606
      },
      "position" : {
        "x" : -526.5894775390625,
        "y" : -940.4061279296875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "18026",
        "degree_layout" : 5,
        "Description" : "Mob1/phocein family protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 113,
        "qstart" : 328,
        "qcovhsp" : 3,
        "shared_name" : "SpCluster-17007.0",
        "ppos" : 72.73,
        "score" : 67,
        "pident" : 50.0,
        "SUID" : 18026,
        "selected" : false,
        "sseqid" : "AT5G20440",
        "length" : 22,
        "nident" : 11,
        "evalue" : 1.2,
        "positive" : 16,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 30.4,
        "slen" : 216,
        "mismatch" : 11,
        "name" : "SpCluster-17007.0",
        "send" : 134,
        "qcovs" : 8,
        "PrimarySymbol" : "0",
        "qend" : 393
      },
      "position" : {
        "x" : 607.2042846679688,
        "y" : -1284.3084716796875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17412",
        "degree_layout" : 2,
        "Description" : "\"Encodes alpha-2,4 tubulin.  TUA2 and TUA4 encode identical proteins. The mRNA is cell-to-cell mobile.\"",
        "SecondarySymbol" : "TUBULIN ALPHA-2 CHAIN (TUA2)",
        "sstart" : 358,
        "qstart" : 464,
        "qcovhsp" : 16,
        "shared_name" : "SpCluster-1293.0",
        "ppos" : 100.0,
        "score" : 387,
        "pident" : 100.0,
        "SUID" : 17412,
        "selected" : false,
        "sseqid" : "AT1G50010",
        "length" : 73,
        "nident" : 73,
        "evalue" : 2.55E-45,
        "positive" : 73,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 153.0,
        "slen" : 450,
        "mismatch" : 0,
        "name" : "SpCluster-1293.0",
        "send" : 430,
        "qcovs" : 47,
        "PrimarySymbol" : "TUBULIN ALPHA-2 CHAIN (TUA2)",
        "qend" : 246
      },
      "position" : {
        "x" : -218.290283203125,
        "y" : -2233.314697265625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17411",
        "degree_layout" : 1,
        "Description" : "\"Encodes a component of the conserved TREX-2 complex that couples mRNA transcription with nucleo-cytoplasmic export, that is required for prevention of epigenetic gene silencing and has additional roles in regulating siRNAs and DNA methylation.\"",
        "SecondarySymbol" : "(AtSAC3B);YEAST SAC3 HOMOLOG B (SAC3B)",
        "sstart" : 966,
        "qstart" : 976,
        "qcovhsp" : 2,
        "shared_name" : "KfCluster-8612.0",
        "ppos" : 68.97,
        "score" : 67,
        "pident" : 51.724,
        "SUID" : 17411,
        "selected" : false,
        "sseqid" : "AT3G06290",
        "length" : 29,
        "nident" : 15,
        "evalue" : 5.5,
        "positive" : 20,
        "gaps" : 1,
        "Type" : "protein_coding",
        "bitscore" : 30.4,
        "slen" : 1697,
        "mismatch" : 13,
        "name" : "KfCluster-8612.0",
        "send" : 994,
        "qcovs" : 5,
        "PrimarySymbol" : "YEAST SAC3 HOMOLOG B (SAC3B)",
        "qend" : 1059
      },
      "position" : {
        "x" : 229.5465087890625,
        "y" : -934.4794921875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "18019",
        "degree_layout" : 1,
        "Description" : "Contains two ring finger domains and one ZZ domain. Week similarity to yeast Rad18p. Putative component of the N-end rule pathway (ubiquitin-dependent proteolysis).",
        "SecondarySymbol" : "PROTEOLYSIS 1 (PRT1)",
        "sstart" : 9,
        "qstart" : 1125,
        "qcovhsp" : 5,
        "shared_name" : "PpCluster-18902.1",
        "ppos" : 46.87,
        "score" : 449,
        "pident" : 32.153,
        "SUID" : 18019,
        "selected" : false,
        "sseqid" : "AT3G24800",
        "length" : 367,
        "nident" : 118,
        "evalue" : 9.95E-48,
        "positive" : 172,
        "gaps" : 82,
        "Type" : "protein_coding",
        "bitscore" : 177.0,
        "slen" : 410,
        "mismatch" : 167,
        "name" : "PpCluster-18902.1",
        "send" : 372,
        "qcovs" : 14,
        "PrimarySymbol" : "PROTEOLYSIS 1 (PRT1)",
        "qend" : 1988
      },
      "position" : {
        "x" : 668.3091697321731,
        "y" : -2592.1646613950993
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17409",
        "degree_layout" : 2,
        "Description" : "\"phosphoglucan, water dikinase;(source:Araport11)\"",
        "SecondarySymbol" : "\" (GWD3); (AT4G24450); (ATGWD2);PHOSPHOGLUCAN, WATER DIKINASE (PWD)\"",
        "sstart" : 1076,
        "qstart" : 1368,
        "qcovhsp" : 4,
        "shared_name" : "PpCluster-4303.1",
        "ppos" : 80.77,
        "score" : 375,
        "pident" : 64.423,
        "SUID" : 17409,
        "selected" : false,
        "sseqid" : "AT4G24450",
        "length" : 104,
        "nident" : 67,
        "evalue" : 2.24E-71,
        "positive" : 84,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 149.0,
        "slen" : 1278,
        "mismatch" : 37,
        "name" : "PpCluster-4303.1",
        "send" : 1179,
        "qcovs" : 13,
        "PrimarySymbol" : "\"PHOSPHOGLUCAN, WATER DIKINASE (PWD)\"",
        "qend" : 1679
      },
      "position" : {
        "x" : -863.3817749023438,
        "y" : -1587.93408203125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "18018",
        "degree_layout" : 1,
        "Description" : "",
        "SecondarySymbol" : "",
        "shared_name" : "SpCluster-5807.0",
        "SUID" : 18018,
        "selected" : false,
        "sseqid" : "",
        "Type" : "",
        "name" : "SpCluster-5807.0",
        "PrimarySymbol" : ""
      },
      "position" : {
        "x" : 1064.52392578125,
        "y" : -1893.624755859375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17408",
        "degree_layout" : 4,
        "Description" : "\"phosphoglucan, water dikinase;(source:Araport11)\"",
        "SecondarySymbol" : "\" (GWD3); (AT4G24450); (ATGWD2);PHOSPHOGLUCAN, WATER DIKINASE (PWD)\"",
        "sstart" : 281,
        "qstart" : 3414,
        "qcovhsp" : 25,
        "shared_name" : "KfCluster-8006.0",
        "ppos" : 52.37,
        "score" : 1236,
        "pident" : 35.334,
        "SUID" : 17408,
        "selected" : false,
        "sseqid" : "AT4G24450",
        "length" : 1033,
        "nident" : 365,
        "evalue" : 6.37E-148,
        "positive" : 541,
        "gaps" : 90,
        "Type" : "protein_coding",
        "bitscore" : 480.0,
        "slen" : 1278,
        "mismatch" : 578,
        "name" : "KfCluster-8006.0",
        "send" : 1278,
        "qcovs" : 76,
        "PrimarySymbol" : "\"PHOSPHOGLUCAN, WATER DIKINASE (PWD)\"",
        "qend" : 481
      },
      "position" : {
        "x" : -721.9180297851562,
        "y" : -1588.5523681640625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "18017",
        "degree_layout" : 2,
        "Description" : "CCCH-type zinc finger family protein;(source:Araport11)",
        "SecondarySymbol" : "(C3H17); (ATC3H17)",
        "sstart" : 25,
        "qstart" : 485,
        "qcovhsp" : 3,
        "shared_name" : "SpCluster-16785.0",
        "ppos" : 60.87,
        "score" : 326,
        "pident" : 45.217,
        "SUID" : 18017,
        "selected" : false,
        "sseqid" : "AT2G02160",
        "length" : 115,
        "nident" : 52,
        "evalue" : 7.61E-31,
        "positive" : 70,
        "gaps" : 20,
        "Type" : "protein_coding",
        "bitscore" : 130.0,
        "slen" : 669,
        "mismatch" : 43,
        "name" : "SpCluster-16785.0",
        "send" : 139,
        "qcovs" : 9,
        "PrimarySymbol" : "(ATC3H17)",
        "qend" : 769
      },
      "position" : {
        "x" : 926.3663940429688,
        "y" : -1774.372802734375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "18014",
        "degree_layout" : 2,
        "Description" : "TRAF-like family protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 1402,
        "qstart" : 1369,
        "qcovhsp" : 7,
        "shared_name" : "SpCluster-16664.0",
        "ppos" : 80.19,
        "score" : 491,
        "pident" : 56.522,
        "SUID" : 18014,
        "selected" : false,
        "sseqid" : "AT2G25320",
        "length" : 207,
        "nident" : 117,
        "evalue" : 4.23E-50,
        "positive" : 166,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 193.0,
        "slen" : 1673,
        "mismatch" : 90,
        "name" : "SpCluster-16664.0",
        "send" : 1608,
        "qcovs" : 22,
        "PrimarySymbol" : "0",
        "qend" : 749
      },
      "position" : {
        "x" : 506.23748779296875,
        "y" : -1295.3046875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17404",
        "degree_layout" : 5,
        "Description" : "\"encodes a member of the DREB subfamily A-1 of ERF/AP2 transcription factor family (DDF2). The protein contains one AP2 domain. There are six members in this subfamily, including CBF1, CBF2, and CBF3. Overexpression of this gene results in the reduction of gibberellic acid biosynthesis. This gene is expressed in all tissues examined, but most abundantly expressed in rosette leaves and stems. Overexpression of DDF1, a putative paralog of this gene, also reduces gibberellic acid biosynthesis and makes the plants more tolerant to high-salinity levels.\"",
        "SecondarySymbol" : "DWARF AND DELAYED FLOWERING 2 (ddf2);DWARF AND DELAYED FLOWERING 2 (ATDDF2)",
        "sstart" : 1,
        "qstart" : 317,
        "qcovhsp" : 2,
        "shared_name" : "PpCluster-11444.1",
        "ppos" : 51.43,
        "score" : 88,
        "pident" : 37.143,
        "SUID" : 17404,
        "selected" : false,
        "sseqid" : "AT1G63030",
        "length" : 70,
        "nident" : 26,
        "evalue" : 0.011,
        "positive" : 36,
        "gaps" : 2,
        "Type" : "protein_coding",
        "bitscore" : 38.5,
        "slen" : 181,
        "mismatch" : 42,
        "name" : "PpCluster-11444.1",
        "send" : 70,
        "qcovs" : 7,
        "PrimarySymbol" : "DWARF AND DELAYED FLOWERING 2 (ddf2)",
        "qend" : 520
      },
      "position" : {
        "x" : 384.10170374883273,
        "y" : -917.7440377332077
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17403",
        "degree_layout" : 8,
        "Description" : "glycosyl hydrolase 9C2;(source:Araport11)",
        "SecondarySymbol" : "GLYCOSYL HYDROLASE 9C2 (GH9C2);GLYCOSYL HYDROLASE 9C2 (AtGH9C2)",
        "sstart" : 527,
        "qstart" : 455,
        "qcovhsp" : 15,
        "shared_name" : "SpCluster-5835.0",
        "ppos" : 47.42,
        "score" : 60,
        "pident" : 27.835,
        "SUID" : 17403,
        "selected" : false,
        "sseqid" : "AT1G64390",
        "length" : 97,
        "nident" : 27,
        "evalue" : 7.3,
        "positive" : 46,
        "gaps" : 8,
        "Type" : "protein_coding",
        "bitscore" : 27.7,
        "slen" : 620,
        "mismatch" : 62,
        "name" : "SpCluster-5835.0",
        "send" : 617,
        "qcovs" : 46,
        "PrimarySymbol" : "GLYCOSYL HYDROLASE 9C2 (GH9C2)",
        "qend" : 171
      },
      "position" : {
        "x" : 37.202735900878906,
        "y" : -1284.8150634765625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17402",
        "degree_layout" : 2,
        "Description" : "",
        "SecondarySymbol" : "",
        "shared_name" : "SpCluster-10085.0",
        "SUID" : 17402,
        "selected" : false,
        "sseqid" : "",
        "Type" : "",
        "name" : "SpCluster-10085.0",
        "PrimarySymbol" : ""
      },
      "position" : {
        "x" : 178.47683715820312,
        "y" : -913.8359375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17401",
        "degree_layout" : 7,
        "Description" : "",
        "SecondarySymbol" : "",
        "shared_name" : "KfCluster-6756.0",
        "SUID" : 17401,
        "selected" : false,
        "sseqid" : "",
        "Type" : "",
        "name" : "KfCluster-6756.0",
        "PrimarySymbol" : ""
      },
      "position" : {
        "x" : -59.058326721191406,
        "y" : -1169.7010498046875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17400",
        "degree_layout" : 3,
        "Description" : "zinc finger (C3HC4-type RING finger) family protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 189,
        "qstart" : 1161,
        "qcovhsp" : 14,
        "shared_name" : "SpCluster-16841.0",
        "ppos" : 66.89,
        "score" : 760,
        "pident" : 50.331,
        "SUID" : 17400,
        "selected" : false,
        "sseqid" : "AT1G18660",
        "length" : 302,
        "nident" : 152,
        "evalue" : 6.4E-93,
        "positive" : 202,
        "gaps" : 5,
        "Type" : "protein_coding",
        "bitscore" : 297.0,
        "slen" : 486,
        "mismatch" : 145,
        "name" : "SpCluster-16841.0",
        "send" : 486,
        "qcovs" : 43,
        "PrimarySymbol" : "0",
        "qend" : 259
      },
      "position" : {
        "x" : 830.3203125,
        "y" : -2536.410400390625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "18012",
        "degree_layout" : 2,
        "Description" : "root hair specific 16;(source:Araport11)",
        "SecondarySymbol" : "ROOT HAIR SPECIFIC 16 (RHS16)",
        "sstart" : 764,
        "qstart" : 90,
        "qcovhsp" : 6,
        "shared_name" : "SpCluster-16329.0",
        "ppos" : 47.89,
        "score" : 70,
        "pident" : 28.169,
        "SUID" : 18012,
        "selected" : false,
        "sseqid" : "AT4G29180",
        "length" : 71,
        "nident" : 20,
        "evalue" : 1.1,
        "positive" : 34,
        "gaps" : 9,
        "Type" : "protein_coding",
        "bitscore" : 31.6,
        "slen" : 911,
        "mismatch" : 42,
        "name" : "SpCluster-16329.0",
        "send" : 830,
        "qcovs" : 18,
        "PrimarySymbol" : "ROOT HAIR SPECIFIC 16 (RHS16)",
        "qend" : 287
      },
      "position" : {
        "x" : -932.8077392578125,
        "y" : -570.9144287109375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17399",
        "degree_layout" : 1,
        "Description" : "\"Encodes one of the 36 carboxylate clamp (CC)-tetratricopeptide repeat (TPR) proteins (Prasad 2010, Pubmed ID: 20856808) with potential to interact with Hsp90/Hsp70 as co-chaperones.\"",
        "SecondarySymbol" : "HOP3 (Hop3)",
        "sstart" : 13,
        "qstart" : 253,
        "qcovhsp" : 5,
        "shared_name" : "PpCluster-15045.0",
        "ppos" : 48.39,
        "score" : 92,
        "pident" : 33.871,
        "SUID" : 17399,
        "selected" : false,
        "sseqid" : "AT4G12400",
        "length" : 62,
        "nident" : 21,
        "evalue" : 0.003,
        "positive" : 30,
        "gaps" : 2,
        "Type" : "protein_coding",
        "bitscore" : 40.0,
        "slen" : 530,
        "mismatch" : 39,
        "name" : "PpCluster-15045.0",
        "send" : 72,
        "qcovs" : 14,
        "PrimarySymbol" : "HOP3 (Hop3)",
        "qend" : 438
      },
      "position" : {
        "x" : 578.9638118805753,
        "y" : -2519.2084407868256
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17396",
        "Description" : "early dehydration-induced gene ERD13 homologous to tobacco and maize glutathione S-transferases.  Encodes glutathione transferase belonging to the phi class of GSTs. Naming convention according to Wagner et al. (2002)",
        "SecondarySymbol" : "ARABIDOPSIS THALIANA GLUTATHIONE S-TRANSFERASE PHI 10 (ATGSTF10);GLUTATHIONE S-TRANSFERASE PHI 10 (GSTF10); (ATGSTF4);EARLY DEHYDRATION-INDUCED 13 (ERD13)",
        "sstart" : 1,
        "qstart" : 13,
        "qcovhsp" : 26,
        "shared_name" : "SpCluster-4846.0",
        "ppos" : 100.0,
        "score" : 1123,
        "pident" : 100.0,
        "SUID" : 17396,
        "selected" : false,
        "sseqid" : "AT2G30870",
        "length" : 215,
        "nident" : 215,
        "evalue" : 1.67E-157,
        "positive" : 215,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 437.0,
        "slen" : 215,
        "mismatch" : 0,
        "name" : "SpCluster-4846.0",
        "send" : 215,
        "qcovs" : 77,
        "PrimarySymbol" : "GLUTATHIONE S-TRANSFERASE PHI 10 (GSTF10)",
        "qend" : 657
      },
      "position" : {
        "x" : -2107.349853515625,
        "y" : -3205.6757159130075
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17395",
        "Description" : "\"Encodes a chloroplastic stromal ascorbate peroxidase sAPX.  Ascorbate peroxidases are enzymes that scavenge hydrogen peroxide in plant cells.  Eight types of APX have been described for Arabidopsis: three cytosolic (APX1, APX2, APX6), two chloroplastic types (stromal sAPX, thylakoid tAPX), and three microsomal (APX3, APX4, APX5) isoforms. The mRNA is cell-to-cell mobile.\"",
        "SecondarySymbol" : "STROMAL ASCORBATE PEROXIDASE (SAPX)",
        "sstart" : 106,
        "qstart" : 931,
        "qcovhsp" : 16,
        "shared_name" : "KfCluster-6299.0",
        "ppos" : 67.47,
        "score" : 800,
        "pident" : 54.795,
        "SUID" : 17395,
        "selected" : false,
        "sseqid" : "AT4G08390",
        "length" : 292,
        "nident" : 160,
        "evalue" : 2.31E-101,
        "positive" : 197,
        "gaps" : 25,
        "Type" : "protein_coding",
        "bitscore" : 312.0,
        "slen" : 372,
        "mismatch" : 107,
        "name" : "KfCluster-6299.0",
        "send" : 372,
        "qcovs" : 48,
        "PrimarySymbol" : "STROMAL ASCORBATE PEROXIDASE (SAPX)",
        "qend" : 1806
      },
      "position" : {
        "x" : -2235.123046875,
        "y" : -3245.3273272411325
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "18011",
        "degree_layout" : 3,
        "Description" : "",
        "SecondarySymbol" : "",
        "shared_name" : "SpCluster-2314.0",
        "SUID" : 18011,
        "selected" : false,
        "sseqid" : "",
        "Type" : "",
        "name" : "SpCluster-2314.0",
        "PrimarySymbol" : ""
      },
      "position" : {
        "x" : 739.1746826171875,
        "y" : -1089.1153564453125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "18010",
        "degree_layout" : 1,
        "Description" : "\"This gene is predicted to encode a protein with a DWD motif. It can bind to DDB1a in Y2H assays, and may be involved in the formation of a CUL4-based E3 ubiquitin ligase\"",
        "SecondarySymbol" : "RNA EXPORT FACTOR 1 (RAE1)",
        "sstart" : 49,
        "qstart" : 831,
        "qcovhsp" : 3,
        "shared_name" : "PpCluster-10235.4",
        "ppos" : 60.61,
        "score" : 66,
        "pident" : 36.364,
        "SUID" : 18010,
        "selected" : false,
        "sseqid" : "AT1G80670",
        "length" : 33,
        "nident" : 12,
        "evalue" : 3.4,
        "positive" : 20,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 30.0,
        "slen" : 349,
        "mismatch" : 21,
        "name" : "PpCluster-10235.4",
        "send" : 81,
        "qcovs" : 8,
        "PrimarySymbol" : "RNA EXPORT FACTOR 1 (RAE1)",
        "qend" : 733
      },
      "position" : {
        "x" : 652.7139282226562,
        "y" : -1167.804931640625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "18009",
        "degree_layout" : 2,
        "Description" : "\"Encodes a deSUMOylating enzyme. In vitro it has both peptidase activity and isopeptidase activity: it can cleave C-terminal residues from SUMO to activate it for attachment to a target protein and it can also act on the isopeptide bond between SUMO and another protein. sGFP:OTS1 protein accumulates in the nucleus. Double mutant analysis with ULP1C/OTS2 indicates that these genes are involved in salt stress responses and flowering time regulation. Over-expression of 35S:OTS1 increases salt tolerance and reduces the level of SUMO-conjugated proteins. OTS1 transcript levels do not appear to change in response to salt, but, salt stress reduces the level of OTS1 protein in a proteasome-dependent manner.\"",
        "SecondarySymbol" : "UB-LIKE PROTEASE 1D (ULP1D);OVERLY TOLERANT TO SALT 1 (OTS1)",
        "sstart" : 371,
        "qstart" : 23,
        "qcovhsp" : 5,
        "shared_name" : "SpCluster-19549.0",
        "ppos" : 44.04,
        "score" : 117,
        "pident" : 24.87,
        "SUID" : 18009,
        "selected" : false,
        "sseqid" : "AT1G60220",
        "length" : 193,
        "nident" : 48,
        "evalue" : 1.2E-5,
        "positive" : 85,
        "gaps" : 26,
        "Type" : "protein_coding",
        "bitscore" : 49.7,
        "slen" : 584,
        "mismatch" : 119,
        "name" : "SpCluster-19549.0",
        "send" : 551,
        "qcovs" : 14,
        "PrimarySymbol" : "UB-LIKE PROTEASE 1D (ULP1D)",
        "qend" : 559
      },
      "position" : {
        "x" : -430.7892150878906,
        "y" : -2351.592529296875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "18008",
        "degree_layout" : 3,
        "Description" : "jJumonji-domain-containing H3K9 histone demethylase. Loss of function mutants are susceptible to bacterial infection and early flowering.",
        "SecondarySymbol" : "(ATJMJ17);JMJC DOMAIN-CONTAINING PROTEIN 27 (JMJ27)",
        "sstart" : 285,
        "qstart" : 1729,
        "qcovhsp" : 2,
        "shared_name" : "SpCluster-16089.3",
        "ppos" : 52.0,
        "score" : 69,
        "pident" : 36.0,
        "SUID" : 18008,
        "selected" : false,
        "sseqid" : "AT4G00990",
        "length" : 50,
        "nident" : 18,
        "evalue" : 4.0,
        "positive" : 26,
        "gaps" : 4,
        "Type" : "protein_coding",
        "bitscore" : 31.2,
        "slen" : 840,
        "mismatch" : 28,
        "name" : "SpCluster-16089.3",
        "send" : 330,
        "qcovs" : 6,
        "PrimarySymbol" : "JMJC DOMAIN-CONTAINING PROTEIN 27 (JMJ27)",
        "qend" : 1878
      },
      "position" : {
        "x" : -388.08135986328125,
        "y" : -2228.221435546875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17389",
        "degree_layout" : 2,
        "Description" : "hypothetical protein;(source:Araport11)",
        "SecondarySymbol" : "LIKE EARLY STARVATION (LESV)",
        "sstart" : 82,
        "qstart" : 413,
        "qcovhsp" : 24,
        "shared_name" : "SpCluster-13251.0",
        "ppos" : 54.02,
        "score" : 760,
        "pident" : 40.561,
        "SUID" : 17389,
        "selected" : false,
        "sseqid" : "AT3G55760",
        "length" : 535,
        "nident" : 217,
        "evalue" : 1.91E-91,
        "positive" : 289,
        "gaps" : 50,
        "Type" : "protein_coding",
        "bitscore" : 297.0,
        "slen" : 578,
        "mismatch" : 268,
        "name" : "SpCluster-13251.0",
        "send" : 573,
        "qcovs" : 71,
        "PrimarySymbol" : "LIKE EARLY STARVATION (LESV)",
        "qend" : 1996
      },
      "position" : {
        "x" : -661.8880004882812,
        "y" : -649.3707275390625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17388",
        "degree_layout" : 3,
        "Description" : "inactive purple acid phosphatase-like protein;(source:Araport11)",
        "SecondarySymbol" : "EARLY STARVATION 1 (ESV1)",
        "sstart" : 81,
        "qstart" : 992,
        "qcovhsp" : 12,
        "shared_name" : "KfCluster-5481.0",
        "ppos" : 77.54,
        "score" : 1057,
        "pident" : 62.462,
        "SUID" : 17388,
        "selected" : false,
        "sseqid" : "AT1G42430",
        "length" : 325,
        "nident" : 203,
        "evalue" : 2.11E-135,
        "positive" : 252,
        "gaps" : 11,
        "Type" : "protein_coding",
        "bitscore" : 411.0,
        "slen" : 426,
        "mismatch" : 111,
        "name" : "KfCluster-5481.0",
        "send" : 400,
        "qcovs" : 35,
        "PrimarySymbol" : "EARLY STARVATION 1 (ESV1)",
        "qend" : 1948
      },
      "position" : {
        "x" : -529.8901977539062,
        "y" : -647.8055419921875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17387",
        "degree_layout" : 2,
        "Description" : "\"Involved in golgi protein trafficking. AtARL1 binds directly to the GRIP domain of AtGRIP in a GTP-dependent manner. Localized to the golgi apparatus, tyrosine 717 in  AtGRIP is crucial for Golgi localization.\"",
        "SecondarySymbol" : "(GRIP); (ATGRIP)",
        "sstart" : 439,
        "qstart" : 1243,
        "qcovhsp" : 25,
        "shared_name" : "SpCluster-7980.0",
        "ppos" : 62.65,
        "score" : 491,
        "pident" : 42.284,
        "SUID" : 17387,
        "selected" : false,
        "sseqid" : "AT5G66030",
        "length" : 324,
        "nident" : 137,
        "evalue" : 1.28E-54,
        "positive" : 203,
        "gaps" : 21,
        "Type" : "protein_coding",
        "bitscore" : 193.0,
        "slen" : 788,
        "mismatch" : 166,
        "name" : "SpCluster-7980.0",
        "send" : 754,
        "qcovs" : 75,
        "PrimarySymbol" : "(ATGRIP)",
        "qend" : 311
      },
      "position" : {
        "x" : 728.2584838867188,
        "y" : -1595.6116943359375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17386",
        "degree_layout" : 3,
        "Description" : "RING/U-box superfamily protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 374,
        "qstart" : 1194,
        "qcovhsp" : 10,
        "shared_name" : "SpCluster-10411.0",
        "ppos" : 66.67,
        "score" : 619,
        "pident" : 45.723,
        "SUID" : 17386,
        "selected" : false,
        "sseqid" : "AT2G35330",
        "length" : 339,
        "nident" : 155,
        "evalue" : 6.54E-68,
        "positive" : 226,
        "gaps" : 4,
        "Type" : "protein_coding",
        "bitscore" : 243.0,
        "slen" : 711,
        "mismatch" : 180,
        "name" : "SpCluster-10411.0",
        "send" : 708,
        "qcovs" : 30,
        "PrimarySymbol" : "0",
        "qend" : 178
      },
      "position" : {
        "x" : 674.9058227539062,
        "y" : -1820.3321533203125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "18005",
        "degree_layout" : 3,
        "Description" : "",
        "SecondarySymbol" : "",
        "shared_name" : "SpCluster-15977.0",
        "SUID" : 18005,
        "selected" : false,
        "sseqid" : "",
        "Type" : "",
        "name" : "SpCluster-15977.0",
        "PrimarySymbol" : ""
      },
      "position" : {
        "x" : -695.819580078125,
        "y" : -1244.615966796875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17385",
        "degree_layout" : 6,
        "Description" : "paramyosin;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 64,
        "qstart" : 479,
        "qcovhsp" : 6,
        "shared_name" : "SpCluster-10408.0",
        "ppos" : 48.04,
        "score" : 150,
        "pident" : 35.784,
        "SUID" : 17385,
        "selected" : false,
        "sseqid" : "AT1G24560",
        "length" : 204,
        "nident" : 73,
        "evalue" : 9.59E-10,
        "positive" : 98,
        "gaps" : 52,
        "Type" : "protein_coding",
        "bitscore" : 62.4,
        "slen" : 678,
        "mismatch" : 79,
        "name" : "SpCluster-10408.0",
        "send" : 252,
        "qcovs" : 19,
        "PrimarySymbol" : "0",
        "qend" : 979
      },
      "position" : {
        "x" : 796.0264282226562,
        "y" : -1509.55419921875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17384",
        "degree_layout" : 13,
        "Description" : "encodes a DNA-binding protein that binds to plastid DNA non-specifically and is associated with nucleoids and thylakoid membranes. The expression of the gene is correlated with the development of thylakoid membranes.",
        "SecondarySymbol" : "MAR BINDING FILAMENT-LIKE PROTEIN 1 (MFP1)",
        "sstart" : 136,
        "qstart" : 1271,
        "qcovhsp" : 14,
        "shared_name" : "PpCluster-20519.0",
        "ppos" : 45.69,
        "score" : 141,
        "pident" : 23.966,
        "SUID" : 17384,
        "selected" : false,
        "sseqid" : "AT3G16000",
        "length" : 580,
        "nident" : 139,
        "evalue" : 1.79E-8,
        "positive" : 265,
        "gaps" : 92,
        "Type" : "protein_coding",
        "bitscore" : 58.9,
        "slen" : 726,
        "mismatch" : 349,
        "name" : "PpCluster-20519.0",
        "send" : 689,
        "qcovs" : 42,
        "PrimarySymbol" : "MAR BINDING FILAMENT-LIKE PROTEIN 1 (MFP1)",
        "qend" : 2812
      },
      "position" : {
        "x" : 651.8114624023438,
        "y" : -1478.369140625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17383",
        "degree_layout" : 31,
        "Description" : "\"PHRAGMOPLAST ORIENTING KINESIN 2 is one of the two Arabidopsis homologs isolated in yeast two-hybrid screen for interaction partners of maize gene TANGLED1 (TAN1). Based on sequence homology in their motor domains, POK1 and POK2 belong to the kinesin-12 class which also includes the well-characterized group of phragmoplast-associated kinesins AtPAKRPs. Both kinesins are composed of an N-terminal motor domain throughout the entire C terminus and putative cargo binding tail domains. The expression domains for POK2 constructs were broader than those for POK1; both are expressed in tissues enriched for dividing cells. The phenotype of pok1/pok2 double mutants strongly resembles that of maize tan1 mutants, characterized by misoriented mitotic cytoskeletal arrays and misplaced cell walls.\"",
        "SecondarySymbol" : "PHRAGMOPLAST ORIENTING KINESIN 2 (POK2)",
        "sstart" : 2180,
        "qstart" : 2821,
        "qcovhsp" : 3,
        "shared_name" : "PpCluster-17961.0",
        "ppos" : 52.94,
        "score" : 86,
        "pident" : 27.731,
        "SUID" : 17383,
        "selected" : false,
        "sseqid" : "AT3G19050",
        "length" : 119,
        "nident" : 33,
        "evalue" : 0.085,
        "positive" : 63,
        "gaps" : 20,
        "Type" : "protein_coding",
        "bitscore" : 37.7,
        "slen" : 2771,
        "mismatch" : 66,
        "name" : "PpCluster-17961.0",
        "send" : 2291,
        "qcovs" : 8,
        "PrimarySymbol" : "PHRAGMOPLAST ORIENTING KINESIN 2 (POK2)",
        "qend" : 3138
      },
      "position" : {
        "x" : 615.8759155273438,
        "y" : -1563.650390625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17382",
        "degree_layout" : 13,
        "Description" : "weak chloroplast movement under blue light protein (DUF827);(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 21,
        "qstart" : 2688,
        "qcovhsp" : 5,
        "shared_name" : "PpCluster-10713.0",
        "ppos" : 44.89,
        "score" : 120,
        "pident" : 26.705,
        "SUID" : 17382,
        "selected" : false,
        "sseqid" : "AT1G12150",
        "length" : 176,
        "nident" : 47,
        "evalue" : 5.04E-6,
        "positive" : 79,
        "gaps" : 28,
        "Type" : "protein_coding",
        "bitscore" : 50.8,
        "slen" : 548,
        "mismatch" : 101,
        "name" : "PpCluster-10713.0",
        "send" : 174,
        "qcovs" : 15,
        "PrimarySymbol" : "0",
        "qend" : 2179
      },
      "position" : {
        "x" : 628.498779296875,
        "y" : -1407.0255126953125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17381",
        "degree_layout" : 3,
        "Description" : "\"Encodes a protein similar to the 100kD subunit of cleavage and polyadenylation specificity factor (CPSF), the factor responsible for the recognition of the AAUAAA motif during mRNA polyadenylation.  The protein interacts with a portion of a nuclear poly(A) polymerase.  It is likely to be a part of the mRNA 3'end formation apparatus.\"",
        "SecondarySymbol" : "EMBRYO DEFECTIVE 1265 (EMB1265);CLEAVAGE AND POLYADENYLATION SPECIFICITY FACTOR 100 (ATCPSF100);ENHANCED SILENCING PHENOTYPE 5 (ESP5);CLEAVAGE AND POLYADENYLATION SPECIFICITY FACTOR 100 (CPSF100)",
        "sstart" : 471,
        "qstart" : 122,
        "qcovhsp" : 11,
        "shared_name" : "SpCluster-20477.0",
        "ppos" : 61.37,
        "score" : 541,
        "pident" : 41.516,
        "SUID" : 17381,
        "selected" : false,
        "sseqid" : "AT5G23880",
        "length" : 277,
        "nident" : 115,
        "evalue" : 2.03E-58,
        "positive" : 170,
        "gaps" : 24,
        "Type" : "protein_coding",
        "bitscore" : 213.0,
        "slen" : 739,
        "mismatch" : 138,
        "name" : "SpCluster-20477.0",
        "send" : 735,
        "qcovs" : 33,
        "PrimarySymbol" : "CLEAVAGE AND POLYADENYLATION SPECIFICITY FACTOR 100 (CPSF100)",
        "qend" : 916
      },
      "position" : {
        "x" : -76.2737808227539,
        "y" : -1567.6959228515625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17380",
        "degree_layout" : 5,
        "Description" : "Eukaryotic aspartyl protease family protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 59,
        "qstart" : 278,
        "qcovhsp" : 21,
        "shared_name" : "SpCluster-13610.0",
        "ppos" : 47.69,
        "score" : 373,
        "pident" : 28.71,
        "SUID" : 17380,
        "selected" : false,
        "sseqid" : "AT3G02740",
        "length" : 411,
        "nident" : 118,
        "evalue" : 2.52E-38,
        "positive" : 196,
        "gaps" : 44,
        "Type" : "protein_coding",
        "bitscore" : 148.0,
        "slen" : 488,
        "mismatch" : 249,
        "name" : "SpCluster-13610.0",
        "send" : 442,
        "qcovs" : 63,
        "PrimarySymbol" : "0",
        "qend" : 1459
      },
      "position" : {
        "x" : 536.9282033745909,
        "y" : -2155.243080555506
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17379",
        "degree_layout" : 6,
        "Description" : "Encodes the Type II Arabidopsis formin14.  Interacts with microtubules and microfilaments to regulate cell division.",
        "SecondarySymbol" : "FORMIN HOMOLOGY 14 (AFH14); (ATFH14)",
        "sstart" : 822,
        "qstart" : 3603,
        "qcovhsp" : 8,
        "shared_name" : "SpCluster-13048.0",
        "ppos" : 78.76,
        "score" : 1183,
        "pident" : 64.247,
        "SUID" : 17379,
        "selected" : false,
        "sseqid" : "AT1G31810",
        "length" : 372,
        "nident" : 239,
        "evalue" : 5.96E-139,
        "positive" : 293,
        "gaps" : 7,
        "Type" : "protein_coding",
        "bitscore" : 460.0,
        "slen" : 1230,
        "mismatch" : 126,
        "name" : "SpCluster-13048.0",
        "send" : 1188,
        "qcovs" : 24,
        "PrimarySymbol" : "FORMIN HOMOLOGY 14 (AFH14)",
        "qend" : 2494
      },
      "position" : {
        "x" : 270.7272644042969,
        "y" : -1428.2950439453125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17378",
        "degree_layout" : 4,
        "Description" : "\"Member of Alpha-Expansin Gene Family. Naming convention from the Expansin Working Group (Kende et al, 2004. Plant Mol Bio).  Containing a conserved root hair-specific cis-element RHE.  Expressed specifically in root hair cell and involved in root hair elongation.\"",
        "SecondarySymbol" : "EXPANSIN A7 (ATEXPA7); (EXP7);EXPANSIN A7 (EXPA7); (ATHEXP ALPHA 1.26); (ATEXP7)",
        "sstart" : 58,
        "qstart" : 895,
        "qcovhsp" : 7,
        "shared_name" : "KfCluster-5326.0",
        "ppos" : 44.93,
        "score" : 123,
        "pident" : 29.71,
        "SUID" : 17378,
        "selected" : false,
        "sseqid" : "AT1G12560",
        "length" : 138,
        "nident" : 41,
        "evalue" : 4.43E-7,
        "positive" : 62,
        "gaps" : 26,
        "Type" : "protein_coding",
        "bitscore" : 52.0,
        "slen" : 262,
        "mismatch" : 71,
        "name" : "KfCluster-5326.0",
        "send" : 171,
        "qcovs" : 20,
        "PrimarySymbol" : "EXPANSIN A7 (EXPA7)",
        "qend" : 488
      },
      "position" : {
        "x" : 238.072509765625,
        "y" : -1592.6009521484375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "18000",
        "degree_layout" : 3,
        "Description" : "",
        "SecondarySymbol" : "",
        "shared_name" : "SpCluster-6361.0",
        "SUID" : 18000,
        "selected" : false,
        "sseqid" : "",
        "Type" : "",
        "name" : "SpCluster-6361.0",
        "PrimarySymbol" : ""
      },
      "position" : {
        "x" : -1971.9476318359375,
        "y" : -937.3548583984375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17999",
        "degree_layout" : 2,
        "Description" : "U3 ribonucleoprotein (Utp) family protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 444,
        "qstart" : 1044,
        "qcovhsp" : 7,
        "shared_name" : "SpCluster-15680.0",
        "ppos" : 55.29,
        "score" : 111,
        "pident" : 40.0,
        "SUID" : 17999,
        "selected" : false,
        "sseqid" : "AT4G02400",
        "length" : 85,
        "nident" : 34,
        "evalue" : 1.59E-5,
        "positive" : 47,
        "gaps" : 9,
        "Type" : "protein_coding",
        "bitscore" : 47.4,
        "slen" : 855,
        "mismatch" : 42,
        "name" : "SpCluster-15680.0",
        "send" : 519,
        "qcovs" : 22,
        "PrimarySymbol" : "0",
        "qend" : 790
      },
      "position" : {
        "x" : -2181.34228515625,
        "y" : -945.9879760742188
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17376",
        "degree_layout" : 5,
        "Description" : "encodes a member of HECT ubiquitin protein ligase family that is involved in trichome cell morphogenesis. Mutants in this gene exhibit supernumerary trichome branches and increased DNA content.",
        "SecondarySymbol" : "KAKTUS (KAK);UBIQUITIN-PROTEIN LIGASE 3 (UPL3)",
        "sstart" : 1195,
        "qstart" : 2490,
        "qcovhsp" : 11,
        "shared_name" : "SpCluster-18058.0",
        "ppos" : 60.44,
        "score" : 1381,
        "pident" : 44.256,
        "SUID" : 17376,
        "selected" : false,
        "sseqid" : "AT4G38600",
        "length" : 766,
        "nident" : 339,
        "evalue" : 1.09E-157,
        "positive" : 463,
        "gaps" : 92,
        "Type" : "protein_coding",
        "bitscore" : 536.0,
        "slen" : 1888,
        "mismatch" : 335,
        "name" : "SpCluster-18058.0",
        "send" : 1888,
        "qcovs" : 34,
        "PrimarySymbol" : "KAKTUS (KAK)",
        "qend" : 253
      },
      "position" : {
        "x" : -286.9968566894531,
        "y" : -2144.86474609375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17375",
        "degree_layout" : 1,
        "Description" : "\"Encodes importin alpha involved in nuclear import. Protein interacts with Agrobacterium proteins VirD2 and VirE2. Is not individually essential for Agrobacterium-mediated root transformation, but when overexpressed can rescue the impa-4 decreased transformation susceptibility phenotype.\"",
        "SecondarySymbol" : "(ATKAP ALPHA);IMPORTIN ALPHA (AIMP ALPHA); (AT-IMP);IMPORTIN ALPHA ISOFORM 1 (IMPA1);IMPORTIN ALPHA ISOFORM 1 (IMPA-1)",
        "sstart" : 1,
        "qstart" : 448,
        "qcovhsp" : 19,
        "shared_name" : "KfCluster-4947.0",
        "ppos" : 84.24,
        "score" : 2009,
        "pident" : 74.296,
        "SUID" : 17375,
        "selected" : false,
        "sseqid" : "AT3G06720",
        "length" : 533,
        "nident" : 396,
        "evalue" : 0.0,
        "positive" : 449,
        "gaps" : 5,
        "Type" : "protein_coding",
        "bitscore" : 778.0,
        "slen" : 532,
        "mismatch" : 132,
        "name" : "KfCluster-4947.0",
        "send" : 531,
        "qcovs" : 58,
        "PrimarySymbol" : "IMPORTIN ALPHA ISOFORM 1 (IMPA-1)",
        "qend" : 2037
      },
      "position" : {
        "x" : -261.4785461425781,
        "y" : -2305.935546875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17374",
        "degree_layout" : 6,
        "Description" : "P-loop containing nucleoside triphosphate hydrolases superfamily protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 730,
        "qstart" : 1616,
        "qcovhsp" : 15,
        "shared_name" : "SpCluster-13182.331",
        "ppos" : 73.25,
        "score" : 1182,
        "pident" : 57.662,
        "SUID" : 17374,
        "selected" : false,
        "sseqid" : "AT1G06720",
        "length" : 385,
        "nident" : 222,
        "evalue" : 6.65E-146,
        "positive" : 282,
        "gaps" : 3,
        "Type" : "protein_coding",
        "bitscore" : 459.0,
        "slen" : 1147,
        "mismatch" : 160,
        "name" : "SpCluster-13182.331",
        "send" : 1114,
        "qcovs" : 45,
        "PrimarySymbol" : "0",
        "qend" : 471
      },
      "position" : {
        "x" : -293.6925354003906,
        "y" : -834.0428466796875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17373",
        "degree_layout" : 9,
        "Description" : "Heavy metal transport/detoxification superfamily protein;(source:Araport11)",
        "SecondarySymbol" : "HEAVY METAL ASSOCIATED ISOPRENYLATED PLANT PROTEIN 21 (HIPP21)",
        "sstart" : 6,
        "qstart" : 735,
        "qcovhsp" : 4,
        "shared_name" : "PpCluster-13027.0",
        "ppos" : 53.49,
        "score" : 133,
        "pident" : 40.698,
        "SUID" : 17373,
        "selected" : false,
        "sseqid" : "AT5G17450",
        "length" : 86,
        "nident" : 35,
        "evalue" : 4.38E-9,
        "positive" : 46,
        "gaps" : 1,
        "Type" : "protein_coding",
        "bitscore" : 55.8,
        "slen" : 149,
        "mismatch" : 50,
        "name" : "PpCluster-13027.0",
        "send" : 91,
        "qcovs" : 13,
        "PrimarySymbol" : "HEAVY METAL ASSOCIATED ISOPRENYLATED PLANT PROTEIN 21 (HIPP21)",
        "qend" : 989
      },
      "position" : {
        "x" : -1112.9594764925503,
        "y" : -173.56394705623137
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17372",
        "degree_layout" : 8,
        "Description" : "pre-rRNA-processing TSR1-like protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 459,
        "qstart" : 1681,
        "qcovhsp" : 11,
        "shared_name" : "KfCluster-6967.0",
        "ppos" : 74.56,
        "score" : 1029,
        "pident" : 58.284,
        "SUID" : 17372,
        "selected" : false,
        "sseqid" : "AT1G42440",
        "length" : 338,
        "nident" : 197,
        "evalue" : 7.18E-126,
        "positive" : 252,
        "gaps" : 21,
        "Type" : "protein_coding",
        "bitscore" : 400.0,
        "slen" : 793,
        "mismatch" : 120,
        "name" : "KfCluster-6967.0",
        "send" : 786,
        "qcovs" : 34,
        "PrimarySymbol" : "0",
        "qend" : 2661
      },
      "position" : {
        "x" : -281.6946105957031,
        "y" : -714.738525390625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17371",
        "degree_layout" : 3,
        "Description" : "Noc2p family;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 123,
        "qstart" : 1753,
        "qcovhsp" : 20,
        "shared_name" : "SpCluster-10571.0",
        "ppos" : 60.94,
        "score" : 1042,
        "pident" : 39.245,
        "SUID" : 17371,
        "selected" : false,
        "sseqid" : "AT2G18220",
        "length" : 530,
        "nident" : 208,
        "evalue" : 2.86E-129,
        "positive" : 323,
        "gaps" : 30,
        "Type" : "protein_coding",
        "bitscore" : 405.0,
        "slen" : 764,
        "mismatch" : 292,
        "name" : "SpCluster-10571.0",
        "send" : 622,
        "qcovs" : 61,
        "PrimarySymbol" : "0",
        "qend" : 164
      },
      "position" : {
        "x" : -501.71685791015625,
        "y" : -1848.6031494140625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17370",
        "degree_layout" : 2,
        "Description" : "\"Responsible for the final assembly of galactolipids in photosynthetic membranes.  Provides stability to the PS I core complex (e.g. subunits PsaD, PsaE).\"",
        "SecondarySymbol" : "DIGALACTOSYL DIACYLGLYCEROL DEFICIENT 1 (DGD1)",
        "sstart" : 253,
        "qstart" : 3,
        "qcovhsp" : 23,
        "shared_name" : "SpCluster-18596.0",
        "ppos" : 68.29,
        "score" : 1636,
        "pident" : 52.181,
        "SUID" : 17370,
        "selected" : false,
        "sseqid" : "AT3G11670",
        "length" : 596,
        "nident" : 311,
        "evalue" : 0.0,
        "positive" : 407,
        "gaps" : 45,
        "Type" : "protein_coding",
        "bitscore" : 634.0,
        "slen" : 808,
        "mismatch" : 240,
        "name" : "SpCluster-18596.0",
        "send" : 808,
        "qcovs" : 70,
        "PrimarySymbol" : "DIGALACTOSYL DIACYLGLYCEROL DEFICIENT 1 (DGD1)",
        "qend" : 1775
      },
      "position" : {
        "x" : -342.5628356933594,
        "y" : -465.7225646972656
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17369",
        "degree_layout" : 1,
        "Description" : "",
        "SecondarySymbol" : "",
        "shared_name" : "SpCluster-1678.0",
        "SUID" : 17369,
        "selected" : false,
        "sseqid" : "",
        "Type" : "",
        "name" : "SpCluster-1678.0",
        "PrimarySymbol" : ""
      },
      "position" : {
        "x" : -339.6609802246094,
        "y" : -399.0052795410156
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17368",
        "degree_layout" : 1,
        "Description" : "This gene is predicted to encode a nucleosome assembly protein. Plant lines expressing an RNAi construct directed against this gene show a reduction in agrobacterium-mediated root transformation. The mRNA is cell-to-cell mobile. Plants mutated in three ubiquitously expressed NAP1 genes (NAP1;1~NAP1;3) and organ-specifically expressed NAP1;4 gene show hypersensitivity to genotoxic stresses including UV and DSB-inducing agent Bleomycin. The NAP1 genes act synergistically with NRP genes in promoting somatic homologous recombination.",
        "SecondarySymbol" : "NUCLEOSOME ASSEMBLY PROTEIN 1;2 (NAP1;2);NUCLEOSOME/CHROMATIN ASSEMBLY FACTOR GROUP A 2 (NFA2);NUCLEOSOME/CHROMATIN ASSEMBLY FACTOR GROUP A 02 (NFA02)",
        "sstart" : 24,
        "qstart" : 332,
        "qcovhsp" : 9,
        "shared_name" : "KfCluster-20781.0",
        "ppos" : 67.48,
        "score" : 551,
        "pident" : 52.846,
        "SUID" : 17368,
        "selected" : false,
        "sseqid" : "AT2G19480",
        "length" : 246,
        "nident" : 130,
        "evalue" : 1.55E-62,
        "positive" : 166,
        "gaps" : 17,
        "Type" : "protein_coding",
        "bitscore" : 216.0,
        "slen" : 373,
        "mismatch" : 99,
        "name" : "KfCluster-20781.0",
        "send" : 254,
        "qcovs" : 26,
        "PrimarySymbol" : "NUCLEOSOME ASSEMBLY PROTEIN 1;2 (NAP1;2)",
        "qend" : 1063
      },
      "position" : {
        "x" : -285.31134033203125,
        "y" : -427.9778137207031
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17367",
        "degree_layout" : 5,
        "Description" : "\"Responsible for the final assembly of galactolipids in photosynthetic membranes.  Provides stability to the PS I core complex (e.g. subunits PsaD, PsaE).\"",
        "SecondarySymbol" : "DIGALACTOSYL DIACYLGLYCEROL DEFICIENT 1 (DGD1)",
        "sstart" : 185,
        "qstart" : 2848,
        "qcovhsp" : 17,
        "shared_name" : "KfCluster-4805.0",
        "ppos" : 64.17,
        "score" : 1581,
        "pident" : 47.526,
        "SUID" : 17367,
        "selected" : false,
        "sseqid" : "AT3G11670",
        "length" : 667,
        "nident" : 317,
        "evalue" : 0.0,
        "positive" : 428,
        "gaps" : 50,
        "Type" : "protein_coding",
        "bitscore" : 613.0,
        "slen" : 808,
        "mismatch" : 300,
        "name" : "KfCluster-4805.0",
        "send" : 807,
        "qcovs" : 50,
        "PrimarySymbol" : "DIGALACTOSYL DIACYLGLYCEROL DEFICIENT 1 (DGD1)",
        "qend" : 866
      },
      "position" : {
        "x" : -338.071533203125,
        "y" : -581.857177734375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17364",
        "degree_layout" : 2,
        "Description" : "FAD-binding Berberine family protein;(source:Araport11)",
        "SecondarySymbol" : "(ATBBE9)",
        "sstart" : 253,
        "qstart" : 260,
        "qcovhsp" : 11,
        "shared_name" : "SpCluster-18114.0",
        "ppos" : 52.56,
        "score" : 72,
        "pident" : 26.923,
        "SUID" : 17364,
        "selected" : false,
        "sseqid" : "AT1G30710",
        "length" : 78,
        "nident" : 21,
        "evalue" : 0.27,
        "positive" : 41,
        "gaps" : 1,
        "Type" : "protein_coding",
        "bitscore" : 32.3,
        "slen" : 531,
        "mismatch" : 56,
        "name" : "SpCluster-18114.0",
        "send" : 329,
        "qcovs" : 33,
        "PrimarySymbol" : "(ATBBE9)",
        "qend" : 493
      },
      "position" : {
        "x" : -353.3088684082031,
        "y" : -688.3017578125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17363",
        "degree_layout" : 1,
        "Description" : "\"Represents a homolog of the yeast MDN gene, which encodes a non-ribosomal protein involved in the maturation and assembly of the 60S ribosomal subunit. In Arabidopsis, it is essential for female gametogenesis progression.\"",
        "SecondarySymbol" : "(ATMDN1);MIDASIN 1 (MDN1)",
        "sstart" : 5098,
        "qstart" : 584,
        "qcovhsp" : 15,
        "shared_name" : "KfCluster-10028.0",
        "ppos" : 74.16,
        "score" : 887,
        "pident" : 56.711,
        "SUID" : 17363,
        "selected" : false,
        "sseqid" : "AT1G67120",
        "length" : 298,
        "nident" : 169,
        "evalue" : 3.79E-103,
        "positive" : 221,
        "gaps" : 8,
        "Type" : "protein_coding",
        "bitscore" : 346.0,
        "slen" : 5393,
        "mismatch" : 121,
        "name" : "KfCluster-10028.0",
        "send" : 5389,
        "qcovs" : 44,
        "PrimarySymbol" : "MIDASIN 1 (MDN1)",
        "qend" : 1471
      },
      "position" : {
        "x" : -398.3132629394531,
        "y" : -671.2245483398438
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17362",
        "degree_layout" : 4,
        "Description" : "\"Encodes a member of the Lon protease-like proteins (Lon1/At5g26860, Lon2/At5g47040, Lon3/At3g05780, Lon4/At3g05790).  Lon is a multifunctional ATP-dependent protease which exists in bacteria, archaea and within organelles in eukaryotic cells.  Lon proteases are responsible for the degradation of abnormal, damaged and unstable proteins.\"",
        "SecondarySymbol" : "ABERRANT PEROXISOME MORPHOLOGY 10 (APEM10);LON PROTEASE 2 (LON2)",
        "sstart" : 5,
        "qstart" : 3150,
        "qcovhsp" : 26,
        "shared_name" : "SpCluster-18162.0",
        "ppos" : 69.77,
        "score" : 2176,
        "pident" : 54.205,
        "SUID" : 17362,
        "selected" : false,
        "sseqid" : "AT5G47040",
        "length" : 880,
        "nident" : 477,
        "evalue" : 0.0,
        "positive" : 614,
        "gaps" : 73,
        "Type" : "protein_coding",
        "bitscore" : 842.0,
        "slen" : 888,
        "mismatch" : 330,
        "name" : "SpCluster-18162.0",
        "send" : 827,
        "qcovs" : 79,
        "PrimarySymbol" : "LON PROTEASE 2 (LON2)",
        "qend" : 559
      },
      "position" : {
        "x" : -482.9530029296875,
        "y" : -769.7091064453125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17361",
        "degree_layout" : 10,
        "Description" : "glycosyl hydrolase 9C3;(source:Araport11)",
        "SecondarySymbol" : "GLYCOSYL HYDROLASE 9C3 (GH9C3);GLYCOSYL HYDROLASE 9C3 (AtGH9C3)",
        "sstart" : 26,
        "qstart" : 1706,
        "qcovhsp" : 25,
        "shared_name" : "SpCluster-13584.0",
        "ppos" : 65.11,
        "score" : 1107,
        "pident" : 49.149,
        "SUID" : 17361,
        "selected" : false,
        "sseqid" : "AT4G11050",
        "length" : 470,
        "nident" : 231,
        "evalue" : 7.62E-144,
        "positive" : 306,
        "gaps" : 7,
        "Type" : "protein_coding",
        "bitscore" : 431.0,
        "slen" : 626,
        "mismatch" : 232,
        "name" : "SpCluster-13584.0",
        "send" : 490,
        "qcovs" : 76,
        "PrimarySymbol" : "GLYCOSYL HYDROLASE 9C3 (GH9C3)",
        "qend" : 303
      },
      "position" : {
        "x" : 84.02727508544922,
        "y" : -1438.17919921875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17360",
        "degree_layout" : 4,
        "Description" : "",
        "SecondarySymbol" : "",
        "shared_name" : "KfCluster-4291.0",
        "SUID" : 17360,
        "selected" : false,
        "sseqid" : "",
        "Type" : "",
        "name" : "KfCluster-4291.0",
        "PrimarySymbol" : ""
      },
      "position" : {
        "x" : 126.84687805175781,
        "y" : -1350.57568359375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17359",
        "degree_layout" : 10,
        "Description" : "P-loop containing nucleoside triphosphate hydrolases superfamily protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 722,
        "qstart" : 1652,
        "qcovhsp" : 8,
        "shared_name" : "KfCluster-4925.0",
        "ppos" : 77.02,
        "score" : 1299,
        "pident" : 59.343,
        "SUID" : 17359,
        "selected" : false,
        "sseqid" : "AT1G06720",
        "length" : 396,
        "nident" : 235,
        "evalue" : 1.96E-155,
        "positive" : 305,
        "gaps" : 3,
        "Type" : "protein_coding",
        "bitscore" : 504.0,
        "slen" : 1147,
        "mismatch" : 158,
        "name" : "KfCluster-4925.0",
        "send" : 1117,
        "qcovs" : 24,
        "PrimarySymbol" : "0",
        "qend" : 474
      },
      "position" : {
        "x" : -356.74066162109375,
        "y" : -767.6725463867188
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17358",
        "degree_layout" : 2,
        "Description" : "galactosyltransferase 13;(source:Araport11)",
        "SecondarySymbol" : "GALACTOSYLTRANSFERASE 13 (GT13);ARABIDOPSIS GALACTOSYLTRANSFERASE 13 (ATGT13)",
        "sstart" : 260,
        "qstart" : 1596,
        "qcovhsp" : 3,
        "shared_name" : "KfCluster-4180.0",
        "ppos" : 44.3,
        "score" : 70,
        "pident" : 29.114,
        "SUID" : 17358,
        "selected" : false,
        "sseqid" : "AT2G32740",
        "length" : 79,
        "nident" : 23,
        "evalue" : 2.9,
        "positive" : 35,
        "gaps" : 15,
        "Type" : "protein_coding",
        "bitscore" : 31.6,
        "slen" : 468,
        "mismatch" : 41,
        "name" : "KfCluster-4180.0",
        "send" : 326,
        "qcovs" : 9,
        "PrimarySymbol" : "GALACTOSYLTRANSFERASE 13 (GT13)",
        "qend" : 1823
      },
      "position" : {
        "x" : -124.09001159667969,
        "y" : -957.9752807617188
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17357",
        "degree_layout" : 1,
        "Description" : "Encodes a member of the dihydroxyacid dehydrates family of proteins that encode enzymes involved in branched chain amino acid biosynthesis. Loss of function mutations have significantly reduced transmission and fertility due to defects in male and female gametophyte development and embryo lethality. Mutants have increased sensitivity to abiotic stressors which may be partially compensated by addition of amino acids to the growth medium.",
        "SecondarySymbol" : "DIHYDROXYACID DEHYDRATASE (DHAD)",
        "sstart" : 25,
        "qstart" : 331,
        "qcovhsp" : 16,
        "shared_name" : "KfCluster-4135.0",
        "ppos" : 84.26,
        "score" : 2182,
        "pident" : 72.42,
        "SUID" : 17357,
        "selected" : false,
        "sseqid" : "AT3G23940",
        "length" : 591,
        "nident" : 428,
        "evalue" : 0.0,
        "positive" : 498,
        "gaps" : 8,
        "Type" : "protein_coding",
        "bitscore" : 845.0,
        "slen" : 608,
        "mismatch" : 155,
        "name" : "KfCluster-4135.0",
        "send" : 608,
        "qcovs" : 49,
        "PrimarySymbol" : "DIHYDROXYACID DEHYDRATASE (DHAD)",
        "qend" : 2100
      },
      "position" : {
        "x" : -732.8892211914062,
        "y" : -1291.5201416015625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17356",
        "degree_layout" : 4,
        "Description" : "Transducin/WD40 repeat-like superfamily protein;(source:Araport11)",
        "SecondarySymbol" : "WD40-DOMAIN 1 (WDD1)",
        "sstart" : 325,
        "qstart" : 2310,
        "qcovhsp" : 13,
        "shared_name" : "PpCluster-20719.1",
        "ppos" : 67.44,
        "score" : 657,
        "pident" : 52.159,
        "SUID" : 17356,
        "selected" : false,
        "sseqid" : "AT5G54200",
        "length" : 301,
        "nident" : 157,
        "evalue" : 5.0E-74,
        "positive" : 203,
        "gaps" : 18,
        "Type" : "protein_coding",
        "bitscore" : 257.0,
        "slen" : 825,
        "mismatch" : 126,
        "name" : "PpCluster-20719.1",
        "send" : 608,
        "qcovs" : 38,
        "PrimarySymbol" : "WD40-DOMAIN 1 (WDD1)",
        "qend" : 1411
      },
      "position" : {
        "x" : -602.7302856445312,
        "y" : -425.8816833496094
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17355",
        "degree_layout" : 6,
        "Description" : "Encodes a splicing factor PRP31. Involved in transcriptional gene silencing and stress responses.",
        "SecondarySymbol" : "(PRP31);EMBRYO DEFECTIVE 1220 (emb1220)",
        "sstart" : 63,
        "qstart" : 1401,
        "qcovhsp" : 25,
        "shared_name" : "SpCluster-18881.0",
        "ppos" : 79.91,
        "score" : 1224,
        "pident" : 68.085,
        "SUID" : 17355,
        "selected" : false,
        "sseqid" : "AT1G60170",
        "length" : 423,
        "nident" : 288,
        "evalue" : 4.89E-164,
        "positive" : 338,
        "gaps" : 3,
        "Type" : "protein_coding",
        "bitscore" : 476.0,
        "slen" : 485,
        "mismatch" : 132,
        "name" : "SpCluster-18881.0",
        "send" : 484,
        "qcovs" : 75,
        "PrimarySymbol" : "(PRP31)",
        "qend" : 139
      },
      "position" : {
        "x" : 992.8778076171875,
        "y" : -1617.101806640625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17354",
        "degree_layout" : 9,
        "Description" : "\"SAR DNA-binding protein, putative, strong similarity to SAR DNA-binding protein-1 (Pisum sativum) GI:3132696; contains Pfam profile PF01798: Putative snoRNA binding domain; has similarity to MAR binding NOP58 protein The mRNA is cell-to-cell mobile.\"",
        "SecondarySymbol" : "0",
        "sstart" : 105,
        "qstart" : 1675,
        "qcovhsp" : 20,
        "shared_name" : "SpCluster-13470.0",
        "ppos" : 86.14,
        "score" : 1334,
        "pident" : 73.746,
        "SUID" : 17354,
        "selected" : false,
        "sseqid" : "AT5G27120",
        "length" : 339,
        "nident" : 250,
        "evalue" : 4.34E-180,
        "positive" : 292,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 518.0,
        "slen" : 533,
        "mismatch" : 89,
        "name" : "SpCluster-13470.0",
        "send" : 443,
        "qcovs" : 61,
        "PrimarySymbol" : "0",
        "qend" : 659
      },
      "position" : {
        "x" : 898.8204345703125,
        "y" : -1605.373779296875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17353",
        "degree_layout" : 6,
        "Description" : "NOP56-like protein",
        "SecondarySymbol" : "HOMOLOG OF NUCLEOLAR PROTEIN NOP56 (NOP56)",
        "sstart" : 1,
        "qstart" : 167,
        "qcovhsp" : 19,
        "shared_name" : "PpCluster-22379.1",
        "ppos" : 86.88,
        "score" : 1813,
        "pident" : 73.756,
        "SUID" : 17353,
        "selected" : false,
        "sseqid" : "AT1G56110",
        "length" : 442,
        "nident" : 326,
        "evalue" : 0.0,
        "positive" : 384,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 702.0,
        "slen" : 522,
        "mismatch" : 116,
        "name" : "PpCluster-22379.1",
        "send" : 442,
        "qcovs" : 56,
        "PrimarySymbol" : "HOMOLOG OF NUCLEOLAR PROTEIN NOP56 (NOP56)",
        "qend" : 1492
      },
      "position" : {
        "x" : 1073.4796142578125,
        "y" : -1634.20068359375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17352",
        "degree_layout" : 6,
        "Description" : "\"SAR DNA-binding protein, putative, strong similarity to SAR DNA-binding protein-1 (Pisum sativum) GI:3132696; contains Pfam profile PF01798: Putative snoRNA binding domain; encodes NOP58-like protein\"",
        "SecondarySymbol" : "0",
        "sstart" : 1,
        "qstart" : 259,
        "qcovhsp" : 18,
        "shared_name" : "KfCluster-3817.0",
        "ppos" : 83.71,
        "score" : 1647,
        "pident" : 70.312,
        "SUID" : 17352,
        "selected" : false,
        "sseqid" : "AT3G05060",
        "length" : 448,
        "nident" : 315,
        "evalue" : 0.0,
        "positive" : 375,
        "gaps" : 3,
        "Type" : "protein_coding",
        "bitscore" : 639.0,
        "slen" : 533,
        "mismatch" : 130,
        "name" : "KfCluster-3817.0",
        "send" : 448,
        "qcovs" : 55,
        "PrimarySymbol" : "0",
        "qend" : 1593
      },
      "position" : {
        "x" : 1002.69775390625,
        "y" : -1700.3502197265625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17351",
        "degree_layout" : 8,
        "Description" : "\"Encodes one of the 36 carboxylate clamp (CC)-tetratricopeptide repeat (TPR) proteins (Prasad 2010, Pubmed ID: 20856808) with potential to interact with Hsp90/Hsp70 as co-chaperones.\"",
        "SecondarySymbol" : "TETRATRICOPEPTIDE REPEAT 5 (TPR5)",
        "sstart" : 90,
        "qstart" : 328,
        "qcovhsp" : 5,
        "shared_name" : "SpCluster-10964.0",
        "ppos" : 84.09,
        "score" : 323,
        "pident" : 63.636,
        "SUID" : 17351,
        "selected" : false,
        "sseqid" : "AT1G56440",
        "length" : 88,
        "nident" : 56,
        "evalue" : 6.23E-32,
        "positive" : 74,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 129.0,
        "slen" : 476,
        "mismatch" : 32,
        "name" : "SpCluster-10964.0",
        "send" : 177,
        "qcovs" : 16,
        "PrimarySymbol" : "TETRATRICOPEPTIDE REPEAT 5 (TPR5)",
        "qend" : 591
      },
      "position" : {
        "x" : 903.1473999023438,
        "y" : -2525.870849609375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17350",
        "degree_layout" : 8,
        "Description" : "\"Encodes one of the 36 carboxylate clamp (CC)-tetratricopeptide repeat (TPR) proteins (Prasad 2010, Pubmed ID: 20856808) with potential to interact with Hsp90/Hsp70 as co-chaperones. The TTL family is required for osmotic stress tolerance and male sporogenesis. The mRNA is cell-to-cell mobile.\"",
        "SecondarySymbol" : "TETRATRICOPEPTIDE-REPEAT THIOREDOXIN-LIKE 1 (TTL1)",
        "sstart" : 219,
        "qstart" : 2015,
        "qcovhsp" : 9,
        "shared_name" : "PpCluster-26666.0",
        "ppos" : 68.96,
        "score" : 1175,
        "pident" : 49.167,
        "SUID" : 17350,
        "selected" : false,
        "sseqid" : "AT1G53300",
        "length" : 480,
        "nident" : 236,
        "evalue" : 3.09E-142,
        "positive" : 331,
        "gaps" : 5,
        "Type" : "protein_coding",
        "bitscore" : 457.0,
        "slen" : 699,
        "mismatch" : 239,
        "name" : "PpCluster-26666.0",
        "send" : 698,
        "qcovs" : 27,
        "PrimarySymbol" : "TETRATRICOPEPTIDE-REPEAT THIOREDOXIN-LIKE 1 (TTL1)",
        "qend" : 3439
      },
      "position" : {
        "x" : 856.9459228515625,
        "y" : -2506.08544921875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17349",
        "degree_layout" : 10,
        "Description" : "\"Encodes one of the 36 carboxylate clamp (CC)-tetratricopeptide repeat (TPR) proteins (Prasad 2010, Pubmed ID: 20856808) with potential to interact with Hsp90/Hsp70 as co-chaperones. The TTL family is required for osmotic stress tolerance and male sporogenesis. The mRNA is cell-to-cell mobile.\"",
        "SecondarySymbol" : "TETRATRICOPEPTIDE-REPEAT THIOREDOXIN-LIKE 1 (TTL1)",
        "sstart" : 211,
        "qstart" : 1982,
        "qcovhsp" : 12,
        "shared_name" : "PpCluster-12742.0",
        "ppos" : 69.26,
        "score" : 1244,
        "pident" : 50.41,
        "SUID" : 17349,
        "selected" : false,
        "sseqid" : "AT1G53300",
        "length" : 488,
        "nident" : 246,
        "evalue" : 8.72E-155,
        "positive" : 338,
        "gaps" : 5,
        "Type" : "protein_coding",
        "bitscore" : 483.0,
        "slen" : 699,
        "mismatch" : 237,
        "name" : "PpCluster-12742.0",
        "send" : 698,
        "qcovs" : 35,
        "PrimarySymbol" : "TETRATRICOPEPTIDE-REPEAT THIOREDOXIN-LIKE 1 (TTL1)",
        "qend" : 3430
      },
      "position" : {
        "x" : 968.402587890625,
        "y" : -2484.17138671875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17348",
        "degree_layout" : 13,
        "Description" : "\"Encodes one of the 36 carboxylate clamp (CC)-tetratricopeptide repeat (TPR) proteins (Prasad 2010, Pubmed ID: 20856808) with potential to interact with Hsp90/Hsp70 as co-chaperones.\"",
        "SecondarySymbol" : "HOP3 (Hop3)",
        "sstart" : 2,
        "qstart" : 2191,
        "qcovhsp" : 24,
        "shared_name" : "KfCluster-6497.0",
        "ppos" : 76.22,
        "score" : 1609,
        "pident" : 58.916,
        "SUID" : 17348,
        "selected" : false,
        "sseqid" : "AT4G12400",
        "length" : 572,
        "nident" : 337,
        "evalue" : 0.0,
        "positive" : 436,
        "gaps" : 15,
        "Type" : "protein_coding",
        "bitscore" : 624.0,
        "slen" : 558,
        "mismatch" : 220,
        "name" : "KfCluster-6497.0",
        "send" : 558,
        "qcovs" : 72,
        "PrimarySymbol" : "HOP3 (Hop3)",
        "qend" : 476
      },
      "position" : {
        "x" : 724.9330501618253,
        "y" : -2482.8914127287994
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17347",
        "degree_layout" : 8,
        "Description" : "\"Encodes one of the 36 carboxylate clamp (CC)-tetratricopeptide repeat (TPR) proteins (Prasad 2010, Pubmed ID: 20856808) with potential to interact with Hsp90/Hsp70 as co-chaperones.\"",
        "SecondarySymbol" : "TRANSLOCON AT THE OUTER MEMBRANE OF CHLOROPLASTS 64-V (ATTOC64-V);ARABIDOPSIS THALIANA TRANSLOCON AT THE OUTER MEMBRANE OF CHLOROPLASTS 64-V (MTOM64);TRANSLOCON AT THE OUTER MEMBRANE OF CHLOROPLASTS 64-V (TOC64-V);OUTER MEMBRANE 64 (OM64); (AtmtOM64)",
        "sstart" : 19,
        "qstart" : 1922,
        "qcovhsp" : 28,
        "shared_name" : "KfCluster-3609.0",
        "ppos" : 58.94,
        "score" : 1006,
        "pident" : 41.908,
        "SUID" : 17347,
        "selected" : false,
        "sseqid" : "AT5G09420",
        "length" : 587,
        "nident" : 246,
        "evalue" : 5.6E-128,
        "positive" : 346,
        "gaps" : 10,
        "Type" : "protein_coding",
        "bitscore" : 392.0,
        "slen" : 603,
        "mismatch" : 331,
        "name" : "KfCluster-3609.0",
        "send" : 600,
        "qcovs" : 84,
        "PrimarySymbol" : "TRANSLOCON AT THE OUTER MEMBRANE OF CHLOROPLASTS 64-V (TOC64-V)",
        "qend" : 177
      },
      "position" : {
        "x" : 784.6163330078125,
        "y" : -2478.36767578125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17346",
        "Description" : "aspartate-glutamate racemase family;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 45,
        "qstart" : 600,
        "qcovhsp" : 14,
        "shared_name" : "KfCluster-3355.0",
        "ppos" : 60.0,
        "score" : 460,
        "pident" : 38.621,
        "SUID" : 17346,
        "selected" : false,
        "sseqid" : "AT1G15410",
        "length" : 290,
        "nident" : 112,
        "evalue" : 1.34E-51,
        "positive" : 174,
        "gaps" : 26,
        "Type" : "protein_coding",
        "bitscore" : 181.0,
        "slen" : 330,
        "mismatch" : 152,
        "name" : "KfCluster-3355.0",
        "send" : 324,
        "qcovs" : 42,
        "PrimarySymbol" : "0",
        "qend" : 1421
      },
      "position" : {
        "x" : -2358.4027353430797,
        "y" : -1754.3074951171875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17345",
        "Description" : "U3 small nucleolar RNA-associated protein;(source:Araport11)",
        "SecondarySymbol" : "NUCLEOLAR FACTOR 1 (NOF1)",
        "sstart" : 174,
        "qstart" : 534,
        "qcovhsp" : 21,
        "shared_name" : "PpCluster-18904.0",
        "ppos" : 66.16,
        "score" : 1347,
        "pident" : 47.811,
        "SUID" : 17345,
        "selected" : false,
        "sseqid" : "AT1G17690",
        "length" : 594,
        "nident" : 284,
        "evalue" : 6.63E-174,
        "positive" : 393,
        "gaps" : 26,
        "Type" : "protein_coding",
        "bitscore" : 523.0,
        "slen" : 754,
        "mismatch" : 284,
        "name" : "PpCluster-18904.0",
        "send" : 753,
        "qcovs" : 63,
        "PrimarySymbol" : "NUCLEOLAR FACTOR 1 (NOF1)",
        "qend" : 2279
      },
      "position" : {
        "x" : 1492.95556640625,
        "y" : -3552.3674125105895
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17339",
        "Description" : "MATE efflux family protein;(source:Araport11)",
        "SecondarySymbol" : "(BIGE1A)",
        "sstart" : 2,
        "qstart" : 854,
        "qcovhsp" : 13,
        "shared_name" : "PpCluster-4956.1",
        "ppos" : 70.37,
        "score" : 461,
        "pident" : 57.672,
        "SUID" : 17339,
        "selected" : false,
        "sseqid" : "AT1G71870",
        "length" : 189,
        "nident" : 109,
        "evalue" : 1.89E-51,
        "positive" : 133,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 182.0,
        "slen" : 510,
        "mismatch" : 80,
        "name" : "PpCluster-4956.1",
        "send" : 190,
        "qcovs" : 40,
        "PrimarySymbol" : "(BIGE1A)",
        "qend" : 1420
      },
      "position" : {
        "x" : -2236.2633310462047,
        "y" : -1599.6602783203125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17338",
        "Description" : "\"Encodes Activated Disease Susceptibility 1 (ADS1), a putative MATE (multidrug and toxic compound extrusion) transport protein that negatively regulates plant disease resistance.\"",
        "SecondarySymbol" : "ALTERED DEVELOPMENT PROGRAM 1 (ADP1);ACTIVATED DISEASE SUSCEPTIBILITY 1 (ADS1);ARABIDOPSIS ABNORMAL SHOOT3 (ABS3)",
        "sstart" : 216,
        "qstart" : 1409,
        "qcovhsp" : 22,
        "shared_name" : "PpCluster-4956.0",
        "ppos" : 64.52,
        "score" : 649,
        "pident" : 47.097,
        "SUID" : 17338,
        "selected" : false,
        "sseqid" : "AT4G29140",
        "length" : 310,
        "nident" : 146,
        "evalue" : 1.18E-78,
        "positive" : 200,
        "gaps" : 4,
        "Type" : "protein_coding",
        "bitscore" : 254.0,
        "slen" : 532,
        "mismatch" : 160,
        "name" : "PpCluster-4956.0",
        "send" : 521,
        "qcovs" : 66,
        "PrimarySymbol" : "ACTIVATED DISEASE SUSCEPTIBILITY 1 (ADS1)",
        "qend" : 480
      },
      "position" : {
        "x" : -2369.2291513587047,
        "y" : -1574.4952392578125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17335",
        "degree_layout" : 1,
        "Description" : "WW domain-containing protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 355,
        "qstart" : 566,
        "qcovhsp" : 6,
        "shared_name" : "SpCluster-11802.1",
        "ppos" : 85.54,
        "score" : 325,
        "pident" : 75.904,
        "SUID" : 17335,
        "selected" : false,
        "sseqid" : "AT2G41020",
        "length" : 83,
        "nident" : 63,
        "evalue" : 1.49E-32,
        "positive" : 71,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 129.0,
        "slen" : 463,
        "mismatch" : 20,
        "name" : "SpCluster-11802.1",
        "send" : 437,
        "qcovs" : 17,
        "PrimarySymbol" : "0",
        "qend" : 318
      },
      "position" : {
        "x" : -1485.6152316760788,
        "y" : -2491.234868679093
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17334",
        "degree_layout" : 1,
        "Description" : "Encodes the catalytic subunit of a N-terminal acetyltransferase.",
        "SecondarySymbol" : "EMBRYO DEFECTIVE 2753 (EMB2753);NAA15 (NAA15);OMISHA (OMA)",
        "sstart" : 381,
        "qstart" : 714,
        "qcovhsp" : 1,
        "shared_name" : "KfCluster-31200.0",
        "ppos" : 84.62,
        "score" : 64,
        "pident" : 76.923,
        "SUID" : 17334,
        "selected" : false,
        "sseqid" : "AT1G80410",
        "length" : 13,
        "nident" : 10,
        "evalue" : 4.9,
        "positive" : 11,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 29.3,
        "slen" : 897,
        "mismatch" : 3,
        "name" : "KfCluster-31200.0",
        "send" : 393,
        "qcovs" : 4,
        "PrimarySymbol" : "NAA15 (NAA15)",
        "qend" : 752
      },
      "position" : {
        "x" : -1556.7239963245163,
        "y" : -2396.388677272843
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17333",
        "Description" : "Ribosomal protein L22p/L17e family protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 62,
        "qstart" : 744,
        "qcovhsp" : 9,
        "shared_name" : "KfCluster-32896.0",
        "ppos" : 61.27,
        "score" : 299,
        "pident" : 41.04,
        "SUID" : 17333,
        "selected" : false,
        "sseqid" : "AT4G28360",
        "length" : 173,
        "nident" : 71,
        "evalue" : 3.44E-30,
        "positive" : 106,
        "gaps" : 13,
        "Type" : "protein_coding",
        "bitscore" : 119.0,
        "slen" : 271,
        "mismatch" : 89,
        "name" : "KfCluster-32896.0",
        "send" : 230,
        "qcovs" : 28,
        "PrimarySymbol" : "0",
        "qend" : 1235
      },
      "position" : {
        "x" : 1291.4185791015625,
        "y" : -3139.6181449324645
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17332",
        "Description" : "Encodes AT4g21960 (AT4g21960/T8O5_170). The mRNA is cell-to-cell mobile.",
        "SecondarySymbol" : "(PRXR1)",
        "sstart" : 10,
        "qstart" : 40,
        "qcovhsp" : 25,
        "shared_name" : "SpCluster-8200.0",
        "ppos" : 100.0,
        "score" : 1724,
        "pident" : 100.0,
        "SUID" : 17332,
        "selected" : false,
        "sseqid" : "AT4G21960",
        "length" : 321,
        "nident" : 321,
        "evalue" : 0.0,
        "positive" : 321,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 668.0,
        "slen" : 330,
        "mismatch" : 0,
        "name" : "SpCluster-8200.0",
        "send" : 330,
        "qcovs" : 74,
        "PrimarySymbol" : "(PRXR1)",
        "qend" : 1002
      },
      "position" : {
        "x" : -2204.236572265625,
        "y" : -3336.6390948192575
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17331",
        "Description" : "Peroxidase superfamily protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 1,
        "qstart" : 17,
        "qcovhsp" : 30,
        "shared_name" : "SpCluster-7492.0",
        "ppos" : 100.0,
        "score" : 1789,
        "pident" : 100.0,
        "SUID" : 17331,
        "selected" : false,
        "sseqid" : "AT3G32980",
        "length" : 352,
        "nident" : 352,
        "evalue" : 0.0,
        "positive" : 352,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 693.0,
        "slen" : 352,
        "mismatch" : 0,
        "name" : "SpCluster-7492.0",
        "send" : 352,
        "qcovs" : 91,
        "PrimarySymbol" : "0",
        "qend" : 1072
      },
      "position" : {
        "x" : -2135.29150390625,
        "y" : -3261.5072588817575
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17330",
        "Description" : "Peroxidase family protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 1,
        "qstart" : 1093,
        "qcovhsp" : 29,
        "shared_name" : "SpCluster-3516.0",
        "ppos" : 100.0,
        "score" : 1661,
        "pident" : 100.0,
        "SUID" : 17330,
        "selected" : false,
        "sseqid" : "AT4G30170",
        "length" : 325,
        "nident" : 325,
        "evalue" : 0.0,
        "positive" : 325,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 644.0,
        "slen" : 325,
        "mismatch" : 0,
        "name" : "SpCluster-3516.0",
        "send" : 325,
        "qcovs" : 88,
        "PrimarySymbol" : "0",
        "qend" : 119
      },
      "position" : {
        "x" : -2077.4638671875,
        "y" : -3341.3449053661325
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17329",
        "Description" : "Peroxidase superfamily protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 1,
        "qstart" : 829,
        "qcovhsp" : 32,
        "shared_name" : "SpCluster-13789.0",
        "ppos" : 100.0,
        "score" : 1389,
        "pident" : 100.0,
        "SUID" : 17329,
        "selected" : false,
        "sseqid" : "AT2G37130",
        "length" : 276,
        "nident" : 276,
        "evalue" : 0.0,
        "positive" : 276,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 539.0,
        "slen" : 327,
        "mismatch" : 0,
        "name" : "SpCluster-13789.0",
        "send" : 276,
        "qcovs" : 95,
        "PrimarySymbol" : "0",
        "qend" : 2
      },
      "position" : {
        "x" : -2168.7470703125,
        "y" : -3381.9403643505075
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17328",
        "Description" : "Encodes a cell wall bound peroxidase that is induced by hypo-osmolarity and is involved in the lignification of cell walls.",
        "SecondarySymbol" : "PEROXIDASE 71 (PRX71); (ATPRX71)",
        "sstart" : 32,
        "qstart" : 1229,
        "qcovhsp" : 16,
        "shared_name" : "PpCluster-2761.0",
        "ppos" : 61.41,
        "score" : 681,
        "pident" : 46.98,
        "SUID" : 17328,
        "selected" : false,
        "sseqid" : "AT5G64120",
        "length" : 298,
        "nident" : 140,
        "evalue" : 3.12E-84,
        "positive" : 183,
        "gaps" : 7,
        "Type" : "protein_coding",
        "bitscore" : 266.0,
        "slen" : 328,
        "mismatch" : 151,
        "name" : "PpCluster-2761.0",
        "send" : 328,
        "qcovs" : 48,
        "PrimarySymbol" : "PEROXIDASE 71 (PRX71)",
        "qend" : 354
      },
      "position" : {
        "x" : -2189.36474609375,
        "y" : -3280.3070635692575
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17327",
        "Description" : "Peroxidase superfamily protein;(source:Araport11)",
        "SecondarySymbol" : "(PRX64);PEROXIDASE 64 (PER64)",
        "sstart" : 129,
        "qstart" : 1153,
        "qcovhsp" : 7,
        "shared_name" : "PpCluster-19425.0",
        "ppos" : 58.64,
        "score" : 363,
        "pident" : 42.408,
        "SUID" : 17327,
        "selected" : false,
        "sseqid" : "AT5G42180",
        "length" : 191,
        "nident" : 81,
        "evalue" : 7.35E-38,
        "positive" : 112,
        "gaps" : 10,
        "Type" : "protein_coding",
        "bitscore" : 144.0,
        "slen" : 317,
        "mismatch" : 100,
        "name" : "PpCluster-19425.0",
        "send" : 316,
        "qcovs" : 20,
        "PrimarySymbol" : "PEROXIDASE 64 (PER64)",
        "qend" : 602
      },
      "position" : {
        "x" : -2111.2470703125,
        "y" : -3386.2787432567575
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17989",
        "degree_layout" : 3,
        "Description" : "Zinc finger C-x8-C-x5-C-x3-H type family protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 5,
        "qstart" : 1663,
        "qcovhsp" : 8,
        "shared_name" : "SpCluster-14521.0",
        "ppos" : 49.68,
        "score" : 239,
        "pident" : 38.065,
        "SUID" : 17989,
        "selected" : false,
        "sseqid" : "AT1G19860",
        "length" : 155,
        "nident" : 59,
        "evalue" : 3.21E-21,
        "positive" : 77,
        "gaps" : 9,
        "Type" : "protein_coding",
        "bitscore" : 96.7,
        "slen" : 413,
        "mismatch" : 87,
        "name" : "SpCluster-14521.0",
        "send" : 150,
        "qcovs" : 24,
        "PrimarySymbol" : "0",
        "qend" : 1199
      },
      "position" : {
        "x" : -58.11369323730469,
        "y" : -2077.358154296875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17988",
        "degree_layout" : 1,
        "Description" : "DDRGK domain protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 170,
        "qstart" : 629,
        "qcovhsp" : 8,
        "shared_name" : "SpCluster-14483.0",
        "ppos" : 85.71,
        "score" : 407,
        "pident" : 68.75,
        "SUID" : 17988,
        "selected" : false,
        "sseqid" : "AT4G27120",
        "length" : 112,
        "nident" : 77,
        "evalue" : 1.37E-45,
        "positive" : 96,
        "gaps" : 1,
        "Type" : "protein_coding",
        "bitscore" : 161.0,
        "slen" : 298,
        "mismatch" : 34,
        "name" : "SpCluster-14483.0",
        "send" : 280,
        "qcovs" : 23,
        "PrimarySymbol" : "0",
        "qend" : 294
      },
      "position" : {
        "x" : 849.8139038085938,
        "y" : -1378.6143798828125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17987",
        "degree_layout" : 2,
        "Description" : "ARM repeat superfamily protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 584,
        "qstart" : 704,
        "qcovhsp" : 4,
        "shared_name" : "SpCluster-19092.0",
        "ppos" : 61.79,
        "score" : 229,
        "pident" : 40.65,
        "SUID" : 17987,
        "selected" : false,
        "sseqid" : "AT3G54790",
        "length" : 123,
        "nident" : 50,
        "evalue" : 4.56E-19,
        "positive" : 76,
        "gaps" : 2,
        "Type" : "protein_coding",
        "bitscore" : 92.8,
        "slen" : 724,
        "mismatch" : 71,
        "name" : "SpCluster-19092.0",
        "send" : 704,
        "qcovs" : 13,
        "PrimarySymbol" : "0",
        "qend" : 336
      },
      "position" : {
        "x" : -742.029296875,
        "y" : -1861.840087890625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17986",
        "degree_layout" : 4,
        "Description" : "member of Putative potassium proton antiporter family",
        "SecondarySymbol" : "K+ EFFLUX ANTIPORTER 6 (KEA6);ARABIDOPSIS THALIANA K+ EFFLUX ANTIPORTER 6 (ATKEA6)",
        "sstart" : 141,
        "qstart" : 1349,
        "qcovhsp" : 13,
        "shared_name" : "SpCluster-7052.0",
        "ppos" : 67.61,
        "score" : 933,
        "pident" : 51.408,
        "SUID" : 17986,
        "selected" : false,
        "sseqid" : "AT5G11800",
        "length" : 426,
        "nident" : 219,
        "evalue" : 2.11E-113,
        "positive" : 288,
        "gaps" : 16,
        "Type" : "protein_coding",
        "bitscore" : 363.0,
        "slen" : 597,
        "mismatch" : 191,
        "name" : "SpCluster-7052.0",
        "send" : 559,
        "qcovs" : 39,
        "PrimarySymbol" : "K+ EFFLUX ANTIPORTER 6 (KEA6)",
        "qend" : 2599
      },
      "position" : {
        "x" : 1166.7083740234375,
        "y" : -1097.9364013671875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17325",
        "degree_layout" : 1,
        "Description" : "Encodes a gene whose sequence is similar to ferredoxin dependent glutamate synthase (Fd-GOGAT). Expression is most abundant in root. The mRNA is cell-to-cell mobile.",
        "SecondarySymbol" : "GLUTAMATE SYNTHASE 2 (GLU2)",
        "sstart" : 29,
        "qstart" : 335,
        "qcovhsp" : 29,
        "shared_name" : "KfCluster-13898.0",
        "ppos" : 75.58,
        "score" : 2607,
        "pident" : 62.596,
        "SUID" : 17325,
        "selected" : false,
        "sseqid" : "AT2G41220",
        "length" : 778,
        "nident" : 487,
        "evalue" : 0.0,
        "positive" : 588,
        "gaps" : 14,
        "Type" : "protein_coding",
        "bitscore" : 1008.0,
        "slen" : 1629,
        "mismatch" : 277,
        "name" : "KfCluster-13898.0",
        "send" : 793,
        "qcovs" : 87,
        "PrimarySymbol" : "GLUTAMATE SYNTHASE 2 (GLU2)",
        "qend" : 2665
      },
      "position" : {
        "x" : -1358.1995822620163,
        "y" : -2531.124272975968
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17985",
        "degree_layout" : 5,
        "Description" : "\"Encodes a potassium efflux antiporter; has three splice forms KEA3.1, KEA3.2, and KEA3.3, KEA3.2 is the most abundant splice form in all plant organs (silique, flower, leaf and root).  KEA3.1 and KEA3.3 are minor variants that can be found in flowers and in leaves. KEA3 is localized to the thylakoid membrane and  enriched in the stromal lamellae. It allows proton efflux from the thylakoid lumen by proton/potassium antiport.\"",
        "SecondarySymbol" : "K+ EFFLUX ANTIPORTER 3 (KEA3)",
        "sstart" : 93,
        "qstart" : 814,
        "qcovhsp" : 14,
        "shared_name" : "SpCluster-18144.0",
        "ppos" : 81.82,
        "score" : 1698,
        "pident" : 68.007,
        "SUID" : 17985,
        "selected" : false,
        "sseqid" : "AT4G04850",
        "length" : 572,
        "nident" : 389,
        "evalue" : 0.0,
        "positive" : 468,
        "gaps" : 9,
        "Type" : "protein_coding",
        "bitscore" : 658.0,
        "slen" : 776,
        "mismatch" : 174,
        "name" : "SpCluster-18144.0",
        "send" : 655,
        "qcovs" : 42,
        "PrimarySymbol" : "K+ EFFLUX ANTIPORTER 3 (KEA3)",
        "qend" : 2529
      },
      "position" : {
        "x" : 1056.806884765625,
        "y" : -1071.5982666015625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17984",
        "degree_layout" : 1,
        "Description" : "",
        "SecondarySymbol" : "",
        "shared_name" : "SpCluster-13519.3",
        "SUID" : 17984,
        "selected" : false,
        "sseqid" : "",
        "Type" : "",
        "name" : "SpCluster-13519.3",
        "PrimarySymbol" : ""
      },
      "position" : {
        "x" : 1204.4691162109375,
        "y" : -1048.16357421875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17983",
        "degree_layout" : 6,
        "Description" : "Encodes a K(+)/H(+) antiporter that modulates monovalent cation and pH homeostasis in plant chloroplasts or plastids.",
        "SecondarySymbol" : "K+ EFFLUX ANTIPORTER 2 (KEA2)",
        "sstart" : 479,
        "qstart" : 1837,
        "qcovhsp" : 16,
        "shared_name" : "SpCluster-1428.0",
        "ppos" : 87.43,
        "score" : 2274,
        "pident" : 76.479,
        "SUID" : 17983,
        "selected" : false,
        "sseqid" : "AT4G00630",
        "length" : 676,
        "nident" : 517,
        "evalue" : 0.0,
        "positive" : 591,
        "gaps" : 2,
        "Type" : "protein_coding",
        "bitscore" : 880.0,
        "slen" : 1174,
        "mismatch" : 157,
        "name" : "SpCluster-1428.0",
        "send" : 1154,
        "qcovs" : 49,
        "PrimarySymbol" : "K+ EFFLUX ANTIPORTER 2 (KEA2)",
        "qend" : 3858
      },
      "position" : {
        "x" : 1070.1156005859375,
        "y" : -1171.3006591796875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17982",
        "degree_layout" : 1,
        "Description" : "Outer membrane OMP85 family protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 76,
        "qstart" : 1549,
        "qcovhsp" : 21,
        "shared_name" : "SpCluster-13762.0",
        "ppos" : 51.89,
        "score" : 650,
        "pident" : 34.034,
        "SUID" : 17982,
        "selected" : false,
        "sseqid" : "AT3G11070",
        "length" : 476,
        "nident" : 162,
        "evalue" : 6.07E-76,
        "positive" : 247,
        "gaps" : 51,
        "Type" : "protein_coding",
        "bitscore" : 254.0,
        "slen" : 520,
        "mismatch" : 263,
        "name" : "SpCluster-13762.0",
        "send" : 512,
        "qcovs" : 62,
        "PrimarySymbol" : "0",
        "qend" : 158
      },
      "position" : {
        "x" : 149.56878662109375,
        "y" : -2089.099853515625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17981",
        "degree_layout" : 2,
        "Description" : "",
        "SecondarySymbol" : "",
        "shared_name" : "SpCluster-14112.0",
        "SUID" : 17981,
        "selected" : false,
        "sseqid" : "",
        "Type" : "",
        "name" : "SpCluster-14112.0",
        "PrimarySymbol" : ""
      },
      "position" : {
        "x" : 144.71697998046875,
        "y" : -1922.171630859375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17320",
        "Description" : "\"A member of the Glycosyltransferase Family 64, homologous to Poplar cambium-expressed GT64 gene.  The EPC1 protein plays a critical role during plant development in maintaining the integrity of organs via cell-cell adhesion, thereby providing mechanical strength and facilitating the movement of metabolites throughout the plant.Loss of function specifically affects glycosylinositolphosphorylceramide (GIPC) mannosylation.\"",
        "SecondarySymbol" : "GIPC MANNOSYL-TRANSFERASE1 (GMT1);ECTOPICALLY PARTING CELLS (EPC1)",
        "sstart" : 75,
        "qstart" : 2177,
        "qcovhsp" : 7,
        "shared_name" : "SpCluster-9868.0",
        "ppos" : 49.61,
        "score" : 304,
        "pident" : 31.496,
        "SUID" : 17320,
        "selected" : false,
        "sseqid" : "AT3G55830",
        "length" : 254,
        "nident" : 80,
        "evalue" : 1.03E-29,
        "positive" : 126,
        "gaps" : 20,
        "Type" : "protein_coding",
        "bitscore" : 121.0,
        "slen" : 334,
        "mismatch" : 154,
        "name" : "SpCluster-9868.0",
        "send" : 326,
        "qcovs" : 22,
        "PrimarySymbol" : "ECTOPICALLY PARTING CELLS (EPC1)",
        "qend" : 1470
      },
      "position" : {
        "x" : -1628.3450736434015,
        "y" : -389.5120658309017
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17319",
        "Description" : "Encodes a glucuronyltransferase responsible  for the addition of GlcA residues onto xylan and for secondary wall deposition.",
        "SecondarySymbol" : "GLUCURONIC ACID SUBSTITUTION OF XYLAN 3 (GUX3);PLANT GLYCOGENIN-LIKE STARCH INITIATION PROTEIN 2 (PGSIP2)",
        "sstart" : 130,
        "qstart" : 3005,
        "qcovhsp" : 9,
        "shared_name" : "PpCluster-15801.0",
        "ppos" : 66.81,
        "score" : 1226,
        "pident" : 48.511,
        "SUID" : 17319,
        "selected" : false,
        "sseqid" : "AT1G77130",
        "length" : 470,
        "nident" : 228,
        "evalue" : 1.33E-150,
        "positive" : 314,
        "gaps" : 12,
        "Type" : "protein_coding",
        "bitscore" : 476.0,
        "slen" : 618,
        "mismatch" : 230,
        "name" : "PpCluster-15801.0",
        "send" : 592,
        "qcovs" : 27,
        "PrimarySymbol" : "PLANT GLYCOGENIN-LIKE STARCH INITIATION PROTEIN 2 (PGSIP2)",
        "qend" : 4399
      },
      "position" : {
        "x" : -1609.7718314559015,
        "y" : -491.9515189559017
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17318",
        "Description" : "Predicted to encode a galactinol synthase.",
        "SecondarySymbol" : "GALACTINOL SYNTHASE 7 (GolS7);GALACTINOL SYNTHASE 7 (AtGolS7)",
        "sstart" : 233,
        "qstart" : 835,
        "qcovhsp" : 2,
        "shared_name" : "KfCluster-31970.0",
        "ppos" : 67.21,
        "score" : 173,
        "pident" : 49.18,
        "SUID" : 17318,
        "selected" : false,
        "sseqid" : "AT1G60450",
        "length" : 61,
        "nident" : 30,
        "evalue" : 6.49E-13,
        "positive" : 41,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 71.2,
        "slen" : 332,
        "mismatch" : 31,
        "name" : "KfCluster-31970.0",
        "send" : 293,
        "qcovs" : 6,
        "PrimarySymbol" : "GALACTINOL SYNTHASE 7 (GolS7)",
        "qend" : 653
      },
      "position" : {
        "x" : -1530.3648490340265,
        "y" : -424.6497611434017
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17315",
        "Description" : "zinc ion binding protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 1,
        "qstart" : 1646,
        "qcovhsp" : 7,
        "shared_name" : "SpCluster-8869.0",
        "ppos" : 66.41,
        "score" : 329,
        "pident" : 53.435,
        "SUID" : 17315,
        "selected" : false,
        "sseqid" : "AT2G19385",
        "length" : 131,
        "nident" : 70,
        "evalue" : 4.61E-34,
        "positive" : 87,
        "gaps" : 4,
        "Type" : "protein_coding",
        "bitscore" : 131.0,
        "slen" : 275,
        "mismatch" : 57,
        "name" : "SpCluster-8869.0",
        "send" : 128,
        "qcovs" : 21,
        "PrimarySymbol" : "0",
        "qend" : 1257
      },
      "position" : {
        "x" : 1681.9063720703125,
        "y" : -3295.9360160262145
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17314",
        "Description" : "U3 small nucleolar RNA-associated protein;(source:Araport11)",
        "SecondarySymbol" : "NUCLEOLAR FACTOR 1 (NOF1)",
        "sstart" : 412,
        "qstart" : 1388,
        "qcovhsp" : 10,
        "shared_name" : "KfCluster-33240.0",
        "ppos" : 75.0,
        "score" : 1055,
        "pident" : 56.977,
        "SUID" : 17314,
        "selected" : false,
        "sseqid" : "AT1G17690",
        "length" : 344,
        "nident" : 196,
        "evalue" : 4.85E-128,
        "positive" : 258,
        "gaps" : 3,
        "Type" : "protein_coding",
        "bitscore" : 410.0,
        "slen" : 754,
        "mismatch" : 145,
        "name" : "KfCluster-33240.0",
        "send" : 754,
        "qcovs" : 29,
        "PrimarySymbol" : "NUCLEOLAR FACTOR 1 (NOF1)",
        "qend" : 363
      },
      "position" : {
        "x" : 1540.249755859375,
        "y" : -3458.4982718855895
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17313",
        "Description" : "zinc ion binding protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 1,
        "qstart" : 2673,
        "qcovhsp" : 4,
        "shared_name" : "KfCluster-31801.0",
        "ppos" : 66.96,
        "score" : 328,
        "pident" : 51.304,
        "SUID" : 17313,
        "selected" : false,
        "sseqid" : "AT2G19385",
        "length" : 115,
        "nident" : 59,
        "evalue" : 1.49E-33,
        "positive" : 77,
        "gaps" : 8,
        "Type" : "protein_coding",
        "bitscore" : 130.0,
        "slen" : 275,
        "mismatch" : 48,
        "name" : "KfCluster-31801.0",
        "send" : 110,
        "qcovs" : 11,
        "PrimarySymbol" : "0",
        "qend" : 2338
      },
      "position" : {
        "x" : 1606.4085693359375,
        "y" : -3369.8864554793395
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17312",
        "degree_layout" : 2,
        "Description" : "SET domain protein 38;(source:Araport11)",
        "SecondarySymbol" : "SET DOMAIN PROTEIN 38 (SDG38); (ATXR4)",
        "sstart" : 203,
        "qstart" : 1652,
        "qcovhsp" : 5,
        "shared_name" : "KfCluster-31776.0",
        "ppos" : 64.17,
        "score" : 276,
        "pident" : 46.667,
        "SUID" : 17312,
        "selected" : false,
        "sseqid" : "AT5G06620",
        "length" : 120,
        "nident" : 56,
        "evalue" : 2.39E-26,
        "positive" : 77,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 110.0,
        "slen" : 325,
        "mismatch" : 64,
        "name" : "KfCluster-31776.0",
        "send" : 322,
        "qcovs" : 14,
        "PrimarySymbol" : "SET DOMAIN PROTEIN 38 (SDG38)",
        "qend" : 2011
      },
      "position" : {
        "x" : 79.41719818115234,
        "y" : -1937.4249267578125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17311",
        "degree_layout" : 2,
        "Description" : "involved in trafficking from the trans-Golgi Network to the central vacuole. The mRNA is cell-to-cell mobile.",
        "SecondarySymbol" : "DYNAMIN-RELATED PROTEIN 2A (DRP2A);DYNAMIN-LIKE PROTEIN 6 (ADL6)",
        "sstart" : 3,
        "qstart" : 3948,
        "qcovhsp" : 17,
        "shared_name" : "SpCluster-19709.0",
        "ppos" : 61.6,
        "score" : 1366,
        "pident" : 42.198,
        "SUID" : 17311,
        "selected" : false,
        "sseqid" : "AT1G10290",
        "length" : 737,
        "nident" : 311,
        "evalue" : 1.12E-169,
        "positive" : 454,
        "gaps" : 47,
        "Type" : "protein_coding",
        "bitscore" : 530.0,
        "slen" : 914,
        "mismatch" : 379,
        "name" : "SpCluster-19709.0",
        "send" : 729,
        "qcovs" : 51,
        "PrimarySymbol" : "DYNAMIN-LIKE PROTEIN 6 (ADL6)",
        "qend" : 1849
      },
      "position" : {
        "x" : -982.01123046875,
        "y" : -1788.4595947265625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17310",
        "degree_layout" : 4,
        "Description" : "Molecular chaperone Hsp40/DnaJ family protein;(source:Araport11)",
        "SecondarySymbol" : "DNA J PROTEIN A7 (DJA7)",
        "sstart" : 186,
        "qstart" : 3351,
        "qcovhsp" : 7,
        "shared_name" : "KfCluster-32150.0",
        "ppos" : 76.83,
        "score" : 769,
        "pident" : 60.163,
        "SUID" : 17310,
        "selected" : false,
        "sseqid" : "AT1G80030",
        "length" : 246,
        "nident" : 148,
        "evalue" : 1.32E-90,
        "positive" : 189,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 300.0,
        "slen" : 500,
        "mismatch" : 98,
        "name" : "KfCluster-32150.0",
        "send" : 431,
        "qcovs" : 22,
        "PrimarySymbol" : "DNA J PROTEIN A7 (DJA7)",
        "qend" : 2614
      },
      "position" : {
        "x" : 1743.8489753304855,
        "y" : -2122.749070823404
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17307",
        "degree_layout" : 6,
        "Description" : "SET domain protein 35;(source:Araport11)",
        "SecondarySymbol" : "SET DOMAIN PROTEIN 35 (SDG35); (ATXR1)",
        "sstart" : 70,
        "qstart" : 2062,
        "qcovhsp" : 8,
        "shared_name" : "PpCluster-18994.0",
        "ppos" : 51.25,
        "score" : 425,
        "pident" : 32.133,
        "SUID" : 17307,
        "selected" : false,
        "sseqid" : "AT1G26760",
        "length" : 361,
        "nident" : 116,
        "evalue" : 1.11E-43,
        "positive" : 185,
        "gaps" : 18,
        "Type" : "protein_coding",
        "bitscore" : 168.0,
        "slen" : 545,
        "mismatch" : 227,
        "name" : "PpCluster-18994.0",
        "send" : 421,
        "qcovs" : 23,
        "PrimarySymbol" : "SET DOMAIN PROTEIN 35 (SDG35)",
        "qend" : 1007
      },
      "position" : {
        "x" : 48.23273468017578,
        "y" : -1791.8321533203125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17306",
        "degree_layout" : 5,
        "Description" : "\"Encodes one of the 36 carboxylate clamp (CC)-tetratricopeptide repeat (TPR) proteins (Prasad 2010, Pubmed ID: 20856808) with potential to interact with Hsp90/Hsp70 as co-chaperones.\"",
        "SecondarySymbol" : "PHOX3 (Phox3)",
        "sstart" : 130,
        "qstart" : 3149,
        "qcovhsp" : 3,
        "shared_name" : "KfCluster-31606.1",
        "ppos" : 53.64,
        "score" : 107,
        "pident" : 29.091,
        "SUID" : 17306,
        "selected" : false,
        "sseqid" : "AT5G20360",
        "length" : 110,
        "nident" : 32,
        "evalue" : 2.22E-4,
        "positive" : 59,
        "gaps" : 17,
        "Type" : "protein_coding",
        "bitscore" : 45.8,
        "slen" : 809,
        "mismatch" : 61,
        "name" : "KfCluster-31606.1",
        "send" : 228,
        "qcovs" : 8,
        "PrimarySymbol" : "PHOX3 (Phox3)",
        "qend" : 3460
      },
      "position" : {
        "x" : -188.52369689941406,
        "y" : -1408.383056640625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17305",
        "degree_layout" : 1,
        "Description" : "Required for proper proliferation of basal cells.",
        "SecondarySymbol" : "VALYL TRNA SYNTHETASE (VALRS);TWIN 2 (TWN2)",
        "sstart" : 118,
        "qstart" : 1108,
        "qcovhsp" : 22,
        "shared_name" : "KfCluster-26764.0",
        "ppos" : 73.46,
        "score" : 3032,
        "pident" : 59.529,
        "SUID" : 17305,
        "selected" : false,
        "sseqid" : "AT1G14610",
        "length" : 976,
        "nident" : 581,
        "evalue" : 0.0,
        "positive" : 717,
        "gaps" : 14,
        "Type" : "protein_coding",
        "bitscore" : 1172.0,
        "slen" : 1108,
        "mismatch" : 381,
        "name" : "KfCluster-26764.0",
        "send" : 1089,
        "qcovs" : 67,
        "PrimarySymbol" : "TWIN 2 (TWN2)",
        "qend" : 4005
      },
      "position" : {
        "x" : -1857.87255859375,
        "y" : -875.6860961914062
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17304",
        "degree_layout" : 1,
        "Description" : "\"CINV2 appears to function as a neutral invertase based on the phenotype of a  cinv1(AT1G35580)/cinv2 double mutant. It is predicted to be a cytosolic enzyme. CINV1, CINV2, and possibly other cytosolic invertases may play an important role in supplying carbon from sucrose to non-photosynthetic tissues.\"",
        "SecondarySymbol" : "ALKALINE/NEUTRAL INVERTASE I (A/N-InvI);CYTOSOLIC INVERTASE 2 (CINV2)",
        "sstart" : 69,
        "qstart" : 1880,
        "qcovhsp" : 20,
        "shared_name" : "KfCluster-31256.0",
        "ppos" : 84.63,
        "score" : 1986,
        "pident" : 71.257,
        "SUID" : 17304,
        "selected" : false,
        "sseqid" : "AT4G09510",
        "length" : 501,
        "nident" : 357,
        "evalue" : 0.0,
        "positive" : 424,
        "gaps" : 12,
        "Type" : "protein_coding",
        "bitscore" : 769.0,
        "slen" : 558,
        "mismatch" : 132,
        "name" : "KfCluster-31256.0",
        "send" : 557,
        "qcovs" : 59,
        "PrimarySymbol" : "CYTOSOLIC INVERTASE 2 (CINV2)",
        "qend" : 378
      },
      "position" : {
        "x" : -745.0525512695312,
        "y" : -1335.5701904296875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17303",
        "degree_layout" : 4,
        "Description" : "transducin family protein / WD-40 repeat family protein;(source:Araport11)",
        "SecondarySymbol" : "(SEC31B)",
        "sstart" : 3,
        "qstart" : 4255,
        "qcovhsp" : 18,
        "shared_name" : "SpCluster-18919.0",
        "ppos" : 64.5,
        "score" : 1853,
        "pident" : 46.56,
        "SUID" : 17303,
        "selected" : false,
        "sseqid" : "AT3G63460",
        "length" : 814,
        "nident" : 379,
        "evalue" : 0.0,
        "positive" : 525,
        "gaps" : 53,
        "Type" : "protein_coding",
        "bitscore" : 718.0,
        "slen" : 1104,
        "mismatch" : 382,
        "name" : "SpCluster-18919.0",
        "send" : 780,
        "qcovs" : 55,
        "PrimarySymbol" : "(SEC31B)",
        "qend" : 1865
      },
      "position" : {
        "x" : -645.0756225585938,
        "y" : -351.4376525878906
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17302",
        "degree_layout" : 2,
        "Description" : "Transducin/WD40 repeat-like superfamily protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 177,
        "qstart" : 1679,
        "qcovhsp" : 26,
        "shared_name" : "SpCluster-13264.0",
        "ppos" : 75.1,
        "score" : 1457,
        "pident" : 59.053,
        "SUID" : 17302,
        "selected" : false,
        "sseqid" : "AT2G20330",
        "length" : 486,
        "nident" : 287,
        "evalue" : 0.0,
        "positive" : 365,
        "gaps" : 29,
        "Type" : "protein_coding",
        "bitscore" : 565.0,
        "slen" : 648,
        "mismatch" : 170,
        "name" : "SpCluster-13264.0",
        "send" : 634,
        "qcovs" : 77,
        "PrimarySymbol" : "0",
        "qend" : 225
      },
      "position" : {
        "x" : -814.4223022460938,
        "y" : -317.6556091308594
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17301",
        "degree_layout" : 1,
        "Description" : "\"Encodes a spermine synthase.  Required for internode elongation and vascular development, specifically in the mechanism that defines the boundaries between veins and nonvein regions.   This mechanism may be mediated by polar auxin transport.  Though ACL5 has been shown to function as a spermine  synthase in E. coli, an ACL5 knockout has no effect on the endogenous levels of free and conjugated polyamines in Arabidopsis, suggesting that ACL5 may have a very specific or altogether different in vivo function.\"",
        "SecondarySymbol" : "ACAULIS 5 (ACL5)",
        "sstart" : 28,
        "qstart" : 1295,
        "qcovhsp" : 7,
        "shared_name" : "KfCluster-31215.5",
        "ppos" : 75.41,
        "score" : 928,
        "pident" : 57.705,
        "SUID" : 17301,
        "selected" : false,
        "sseqid" : "AT5G19530",
        "length" : 305,
        "nident" : 176,
        "evalue" : 9.66E-114,
        "positive" : 230,
        "gaps" : 1,
        "Type" : "protein_coding",
        "bitscore" : 362.0,
        "slen" : 332,
        "mismatch" : 128,
        "name" : "KfCluster-31215.5",
        "send" : 331,
        "qcovs" : 20,
        "PrimarySymbol" : "ACAULIS 5 (ACL5)",
        "qend" : 381
      },
      "position" : {
        "x" : -744.9766235351562,
        "y" : -1214.2060546875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17298",
        "degree_layout" : 8,
        "Description" : "\"Encodes SVR3, a putative chloroplast TypA translation elongation GTPase.  Loss of SVR3 suppresses variegation mediated by var2.  SVR3 is essential for plants? ability to develop functional chloroplasts under chilling stress (8C), but not at normal temperature (22C).\"",
        "SecondarySymbol" : "SUPPRESSOR OF VARIEGATION 3 (SVR3)",
        "sstart" : 176,
        "qstart" : 888,
        "qcovhsp" : 17,
        "shared_name" : "SpCluster-20223.0",
        "ppos" : 85.31,
        "score" : 1248,
        "pident" : 72.5,
        "SUID" : 17298,
        "selected" : false,
        "sseqid" : "AT5G13650",
        "length" : 320,
        "nident" : 232,
        "evalue" : 2.7E-164,
        "positive" : 273,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 485.0,
        "slen" : 675,
        "mismatch" : 88,
        "name" : "SpCluster-20223.0",
        "send" : 495,
        "qcovs" : 52,
        "PrimarySymbol" : "SUPPRESSOR OF VARIEGATION 3 (SVR3)",
        "qend" : 1847
      },
      "position" : {
        "x" : 1269.3510521272947,
        "y" : -406.63006591796875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17297",
        "degree_layout" : 12,
        "Description" : "Ribosomal protein S5/Elongation factor G/III/V family protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 3,
        "qstart" : 150,
        "qcovhsp" : 31,
        "shared_name" : "SpCluster-17705.0",
        "ppos" : 63.11,
        "score" : 2606,
        "pident" : 47.8,
        "SUID" : 17297,
        "selected" : false,
        "sseqid" : "AT3G22980",
        "length" : 1182,
        "nident" : 565,
        "evalue" : 0.0,
        "positive" : 746,
        "gaps" : 180,
        "Type" : "protein_coding",
        "bitscore" : 1008.0,
        "slen" : 1015,
        "mismatch" : 437,
        "name" : "SpCluster-17705.0",
        "send" : 1015,
        "qcovs" : 92,
        "PrimarySymbol" : "0",
        "qend" : 3662
      },
      "position" : {
        "x" : 1149.6047142366697,
        "y" : -542.146240234375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17296",
        "degree_layout" : 2,
        "Description" : "\"Encodes SVR3, a putative chloroplast TypA translation elongation GTPase.  Loss of SVR3 suppresses variegation mediated by var2.  SVR3 is essential for plants? ability to develop functional chloroplasts under chilling stress (8C), but not at normal temperature (22C).\"",
        "SecondarySymbol" : "SUPPRESSOR OF VARIEGATION 3 (SVR3)",
        "sstart" : 489,
        "qstart" : 583,
        "qcovhsp" : 29,
        "shared_name" : "SpCluster-10238.0",
        "ppos" : 83.14,
        "score" : 642,
        "pident" : 66.279,
        "SUID" : 17296,
        "selected" : false,
        "sseqid" : "AT5G13650",
        "length" : 172,
        "nident" : 114,
        "evalue" : 2.81E-80,
        "positive" : 143,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 251.0,
        "slen" : 675,
        "mismatch" : 58,
        "name" : "SpCluster-10238.0",
        "send" : 660,
        "qcovs" : 88,
        "PrimarySymbol" : "SUPPRESSOR OF VARIEGATION 3 (SVR3)",
        "qend" : 68
      },
      "position" : {
        "x" : 1358.553775697606,
        "y" : -286.6349509654385
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17295",
        "degree_layout" : 3,
        "Description" : "\"A member of ARF GAP domain (AGD), A thaliana has 15 members, grouped into four classes. AGD2 belongs to the class 1, together with AGD1, AGD3, and AGD4.\"",
        "SecondarySymbol" : "ARF-GAP DOMAIN 2 (AGD2)",
        "sstart" : 676,
        "qstart" : 641,
        "qcovhsp" : 9,
        "shared_name" : "SpCluster-12364.0",
        "ppos" : 65.96,
        "score" : 220,
        "pident" : 46.809,
        "SUID" : 17295,
        "selected" : false,
        "sseqid" : "AT1G60860",
        "length" : 94,
        "nident" : 44,
        "evalue" : 3.79E-19,
        "positive" : 62,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 89.4,
        "slen" : 776,
        "mismatch" : 50,
        "name" : "SpCluster-12364.0",
        "send" : 769,
        "qcovs" : 26,
        "PrimarySymbol" : "ARF-GAP DOMAIN 2 (AGD2)",
        "qend" : 922
      },
      "position" : {
        "x" : -381.9510192871094,
        "y" : -350.1232604980469
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17290",
        "Description" : "ribosome biogenesis regulatory protein (RRS1) family protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 12,
        "qstart" : 1229,
        "qcovhsp" : 19,
        "shared_name" : "SpCluster-4313.0",
        "ppos" : 67.35,
        "score" : 666,
        "pident" : 48.639,
        "SUID" : 17290,
        "selected" : false,
        "sseqid" : "AT2G37990",
        "length" : 294,
        "nident" : 143,
        "evalue" : 3.41E-83,
        "positive" : 198,
        "gaps" : 8,
        "Type" : "protein_coding",
        "bitscore" : 261.0,
        "slen" : 318,
        "mismatch" : 143,
        "name" : "SpCluster-4313.0",
        "send" : 297,
        "qcovs" : 57,
        "PrimarySymbol" : "0",
        "qend" : 348
      },
      "position" : {
        "x" : -1041.186748448089,
        "y" : -3626.309101161286
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17289",
        "Description" : "ribosome biogenesis regulatory protein (RRS1) family protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 180,
        "qstart" : 674,
        "qcovhsp" : 4,
        "shared_name" : "PpCluster-19284.0",
        "ppos" : 80.82,
        "score" : 241,
        "pident" : 64.384,
        "SUID" : 17289,
        "selected" : false,
        "sseqid" : "AT2G37990",
        "length" : 73,
        "nident" : 47,
        "evalue" : 5.89E-22,
        "positive" : 59,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 97.4,
        "slen" : 318,
        "mismatch" : 26,
        "name" : "PpCluster-19284.0",
        "send" : 252,
        "qcovs" : 12,
        "PrimarySymbol" : "0",
        "qend" : 456
      },
      "position" : {
        "x" : -1022.6132621199641,
        "y" : -3728.748554286286
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17288",
        "Description" : "ribosome biogenesis regulatory protein (RRS1) family protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 13,
        "qstart" : 1475,
        "qcovhsp" : 15,
        "shared_name" : "KfCluster-29960.0",
        "ppos" : 64.71,
        "score" : 422,
        "pident" : 49.16,
        "SUID" : 17288,
        "selected" : false,
        "sseqid" : "AT2G37990",
        "length" : 238,
        "nident" : 117,
        "evalue" : 3.8E-47,
        "positive" : 154,
        "gaps" : 4,
        "Type" : "protein_coding",
        "bitscore" : 167.0,
        "slen" : 318,
        "mismatch" : 117,
        "name" : "KfCluster-29960.0",
        "send" : 246,
        "qcovs" : 44,
        "PrimarySymbol" : "0",
        "qend" : 762
      },
      "position" : {
        "x" : -943.2062796980891,
        "y" : -3661.446796473786
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17287",
        "degree_layout" : 2,
        "Description" : "RNA recognition motif (RRM)-containing protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 166,
        "qstart" : 3063,
        "qcovhsp" : 20,
        "shared_name" : "PpCluster-20170.0",
        "ppos" : 60.12,
        "score" : 1528,
        "pident" : 47.977,
        "SUID" : 17287,
        "selected" : false,
        "sseqid" : "AT5G10800",
        "length" : 865,
        "nident" : 415,
        "evalue" : 0.0,
        "positive" : 520,
        "gaps" : 158,
        "Type" : "protein_coding",
        "bitscore" : 593.0,
        "slen" : 947,
        "mismatch" : 292,
        "name" : "PpCluster-20170.0",
        "send" : 880,
        "qcovs" : 60,
        "PrimarySymbol" : "0",
        "qend" : 493
      },
      "position" : {
        "x" : -1800.6600341796875,
        "y" : -874.5836181640625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17970",
        "degree_layout" : 3,
        "Description" : "",
        "SecondarySymbol" : "",
        "shared_name" : "SpCluster-16969.0",
        "SUID" : 17970,
        "selected" : false,
        "sseqid" : "",
        "Type" : "",
        "name" : "SpCluster-16969.0",
        "PrimarySymbol" : ""
      },
      "position" : {
        "x" : 324.984375,
        "y" : -1054.4532470703125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17969",
        "degree_layout" : 4,
        "Description" : "\"member of Alpha-Expansin Gene Family. Naming convention from the Expansin Working Group (Kende et al, 2004. Plant Mol Bio)\"",
        "SecondarySymbol" : "EXPANSIN A24 (ATEXPA24);EXPANSIN 24 (EXP24);EXPANSIN A24 (EXPA24); (ATHEXP ALPHA 1.19); (ATEXP24)",
        "sstart" : 27,
        "qstart" : 730,
        "qcovhsp" : 3,
        "shared_name" : "SpCluster-13182.87",
        "ppos" : 44.62,
        "score" : 90,
        "pident" : 29.231,
        "SUID" : 17969,
        "selected" : false,
        "sseqid" : "AT5G39310",
        "length" : 65,
        "nident" : 19,
        "evalue" : 0.008,
        "positive" : 29,
        "gaps" : 3,
        "Type" : "protein_coding",
        "bitscore" : 39.3,
        "slen" : 296,
        "mismatch" : 43,
        "name" : "SpCluster-13182.87",
        "send" : 91,
        "qcovs" : 8,
        "PrimarySymbol" : "EXPANSIN A24 (EXPA24)",
        "qend" : 915
      },
      "position" : {
        "x" : 362.76666259765625,
        "y" : -1204.575927734375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17283",
        "degree_layout" : 17,
        "Description" : "",
        "SecondarySymbol" : "",
        "shared_name" : "SpCluster-9928.38",
        "SUID" : 17283,
        "selected" : false,
        "sseqid" : "",
        "Type" : "",
        "name" : "SpCluster-9928.38",
        "PrimarySymbol" : ""
      },
      "position" : {
        "x" : 709.832275390625,
        "y" : -1431.9017333984375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17282",
        "degree_layout" : 19,
        "Description" : "phosphoglycolate phosphatase;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 436,
        "qstart" : 2344,
        "qcovhsp" : 1,
        "shared_name" : "SpCluster-20260.0",
        "ppos" : 65.33,
        "score" : 182,
        "pident" : 46.667,
        "SUID" : 17282,
        "selected" : false,
        "sseqid" : "AT5G48830",
        "length" : 75,
        "nident" : 35,
        "evalue" : 4.75E-13,
        "positive" : 49,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 74.7,
        "slen" : 511,
        "mismatch" : 40,
        "name" : "SpCluster-20260.0",
        "send" : 510,
        "qcovs" : 3,
        "PrimarySymbol" : "0",
        "qend" : 2568
      },
      "position" : {
        "x" : 752.0177612304688,
        "y" : -1585.118896484375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17281",
        "degree_layout" : 2,
        "Description" : "\"Peptidase C12, ubiquitin carboxyl-terminal hydrolase 1;(source:Araport11)\"",
        "SecondarySymbol" : "(UCH1)",
        "sstart" : 44,
        "qstart" : 156,
        "qcovhsp" : 11,
        "shared_name" : "SpCluster-16297.1",
        "ppos" : 66.77,
        "score" : 718,
        "pident" : 48.171,
        "SUID" : 17281,
        "selected" : false,
        "sseqid" : "AT5G16310",
        "length" : 328,
        "nident" : 158,
        "evalue" : 3.15E-86,
        "positive" : 219,
        "gaps" : 43,
        "Type" : "protein_coding",
        "bitscore" : 281.0,
        "slen" : 334,
        "mismatch" : 127,
        "name" : "SpCluster-16297.1",
        "send" : 332,
        "qcovs" : 32,
        "PrimarySymbol" : "(UCH1)",
        "qend" : 1127
      },
      "position" : {
        "x" : 342.1654052734375,
        "y" : -1558.0267333984375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17280",
        "degree_layout" : 13,
        "Description" : "",
        "SecondarySymbol" : "",
        "shared_name" : "SpCluster-11052.0",
        "SUID" : 17280,
        "selected" : false,
        "sseqid" : "",
        "Type" : "",
        "name" : "SpCluster-11052.0",
        "PrimarySymbol" : ""
      },
      "position" : {
        "x" : 686.5408935546875,
        "y" : -1531.1553955078125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17968",
        "degree_layout" : 2,
        "Description" : "Encodes a subunit of the WAVE complex. The WAVE complex is required for activation of ARP2/3 complex which functions in actin microfilament nucleation and branching.  One of four ABI-like proteins.",
        "SecondarySymbol" : "ABI-1-LIKE 1 (ABIL1)",
        "sstart" : 23,
        "qstart" : 47,
        "qcovhsp" : 8,
        "shared_name" : "SpCluster-4032.0",
        "ppos" : 63.11,
        "score" : 200,
        "pident" : 38.835,
        "SUID" : 17968,
        "selected" : false,
        "sseqid" : "AT2G46225",
        "length" : 103,
        "nident" : 40,
        "evalue" : 2.83E-17,
        "positive" : 65,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 81.6,
        "slen" : 286,
        "mismatch" : 63,
        "name" : "SpCluster-4032.0",
        "send" : 125,
        "qcovs" : 25,
        "PrimarySymbol" : "ABI-1-LIKE 1 (ABIL1)",
        "qend" : 355
      },
      "position" : {
        "x" : -947.0753173828125,
        "y" : -1606.4560546875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17279",
        "degree_layout" : 2,
        "Description" : "",
        "SecondarySymbol" : "",
        "shared_name" : "PpCluster-8622.0",
        "SUID" : 17279,
        "selected" : false,
        "sseqid" : "",
        "Type" : "",
        "name" : "PpCluster-8622.0",
        "PrimarySymbol" : ""
      },
      "position" : {
        "x" : 678.0477294921875,
        "y" : -1654.5731201171875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17278",
        "degree_layout" : 23,
        "Description" : "kinesin heavy chain subunit",
        "SecondarySymbol" : "KINESIN 2 (ATK2);KINESIN-LIKE PROTEIN IN ARABIDOPSIS THALIANA B (KATB)",
        "sstart" : 143,
        "qstart" : 2171,
        "qcovhsp" : 3,
        "shared_name" : "PpCluster-21599.0",
        "ppos" : 48.15,
        "score" : 82,
        "pident" : 25.926,
        "SUID" : 17278,
        "selected" : false,
        "sseqid" : "AT4G27180",
        "length" : 135,
        "nident" : 35,
        "evalue" : 0.23,
        "positive" : 65,
        "gaps" : 10,
        "Type" : "protein_coding",
        "bitscore" : 36.2,
        "slen" : 745,
        "mismatch" : 90,
        "name" : "PpCluster-21599.0",
        "send" : 277,
        "qcovs" : 9,
        "PrimarySymbol" : "KINESIN 2 (ATK2)",
        "qend" : 1797
      },
      "position" : {
        "x" : 538.2349853515625,
        "y" : -1594.378662109375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17967",
        "degree_layout" : 2,
        "Description" : "\"Encodes a RNA binding protein ELF9 (EARLY FLOWERING9).  Loss of ELF9 function in the Wassilewskija ecotype causes early flowering in short days.  ELF9 reduces SOC1 (SUPPRESSOR OF OVEREXPRESSION OF CO1) transcript levels, possibly via nonsense-mediated mRNA decay. The mRNA is cell-to-cell mobile.\"",
        "SecondarySymbol" : "EARLY FLOWERING 9 (ELF9)",
        "sstart" : 267,
        "qstart" : 1012,
        "qcovhsp" : 12,
        "shared_name" : "SpCluster-13182.15",
        "ppos" : 73.71,
        "score" : 701,
        "pident" : 58.566,
        "SUID" : 17967,
        "selected" : false,
        "sseqid" : "AT5G16260",
        "length" : 251,
        "nident" : 147,
        "evalue" : 6.4E-84,
        "positive" : 185,
        "gaps" : 1,
        "Type" : "protein_coding",
        "bitscore" : 274.0,
        "slen" : 519,
        "mismatch" : 103,
        "name" : "SpCluster-13182.15",
        "send" : 516,
        "qcovs" : 36,
        "PrimarySymbol" : "EARLY FLOWERING 9 (ELF9)",
        "qend" : 1764
      },
      "position" : {
        "x" : -710.0322875976562,
        "y" : -2062.60986328125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17277",
        "degree_layout" : 15,
        "Description" : "\"This gene is predicted to encode a protein that functions as a Golgi apparatus structural component known as a golgin in mammals and yeast.  A fluorescently-tagged version of GC1 co-localizes with Golgi markers, and this localization appears to be replicated using the C-terminal (558-715 aa) portion of the protein.\"",
        "SecondarySymbol" : "GOLGIN CANDIDATE 1 (GC1)",
        "sstart" : 343,
        "qstart" : 2047,
        "qcovhsp" : 4,
        "shared_name" : "PpCluster-10195.0",
        "ppos" : 45.96,
        "score" : 91,
        "pident" : 24.747,
        "SUID" : 17277,
        "selected" : false,
        "sseqid" : "AT2G19950",
        "length" : 198,
        "nident" : 49,
        "evalue" : 0.015,
        "positive" : 91,
        "gaps" : 42,
        "Type" : "protein_coding",
        "bitscore" : 39.7,
        "slen" : 710,
        "mismatch" : 107,
        "name" : "PpCluster-10195.0",
        "send" : 537,
        "qcovs" : 13,
        "PrimarySymbol" : "GOLGIN CANDIDATE 1 (GC1)",
        "qend" : 2523
      },
      "position" : {
        "x" : 759.1307373046875,
        "y" : -1517.44775390625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17276",
        "degree_layout" : 1,
        "Description" : "",
        "SecondarySymbol" : "",
        "shared_name" : "KfCluster-28093.0",
        "SUID" : 17276,
        "selected" : false,
        "sseqid" : "",
        "Type" : "",
        "name" : "KfCluster-28093.0",
        "PrimarySymbol" : ""
      },
      "position" : {
        "x" : 483.527099609375,
        "y" : -1581.741455078125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17966",
        "degree_layout" : 2,
        "Description" : "Encodes the Type II Arabidopsis formin14.  Interacts with microtubules and microfilaments to regulate cell division.",
        "SecondarySymbol" : "FORMIN HOMOLOGY 14 (AFH14); (ATFH14)",
        "sstart" : 801,
        "qstart" : 1918,
        "qcovhsp" : 18,
        "shared_name" : "SpCluster-16135.0",
        "ppos" : 61.2,
        "score" : 757,
        "pident" : 41.146,
        "SUID" : 17966,
        "selected" : false,
        "sseqid" : "AT1G31810",
        "length" : 384,
        "nident" : 158,
        "evalue" : 1.66E-86,
        "positive" : 235,
        "gaps" : 10,
        "Type" : "protein_coding",
        "bitscore" : 296.0,
        "slen" : 1230,
        "mismatch" : 216,
        "name" : "SpCluster-16135.0",
        "send" : 1181,
        "qcovs" : 53,
        "PrimarySymbol" : "FORMIN HOMOLOGY 14 (AFH14)",
        "qend" : 788
      },
      "position" : {
        "x" : 344.2562255859375,
        "y" : -1358.42236328125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17962",
        "degree_layout" : 1,
        "Description" : "Encodes a microtubule-associated protein.",
        "SecondarySymbol" : "0",
        "sstart" : 16,
        "qstart" : 1618,
        "qcovhsp" : 14,
        "shared_name" : "SpCluster-12899.0",
        "ppos" : 66.26,
        "score" : 523,
        "pident" : 42.798,
        "SUID" : 17962,
        "selected" : false,
        "sseqid" : "AT2G18876",
        "length" : 243,
        "nident" : 104,
        "evalue" : 1.12E-60,
        "positive" : 161,
        "gaps" : 1,
        "Type" : "protein_coding",
        "bitscore" : 206.0,
        "slen" : 382,
        "mismatch" : 138,
        "name" : "SpCluster-12899.0",
        "send" : 257,
        "qcovs" : 42,
        "PrimarySymbol" : "0",
        "qend" : 890
      },
      "position" : {
        "x" : 911.7373657226562,
        "y" : -1676.07861328125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17275",
        "degree_layout" : 1,
        "Description" : "\"Encodes AtObgC, a plant ortholog of bacterial Obg.  AtObgC is a chloroplast-targeting GTPase essential for early embryogenesis. Mutations in this locus result in embryo lethality. The protein is  dually localized in the stroma and the inner envelope membrane and is involved in thylakoid membrane biogenesis and functions primarily in plastid ribosome biogenesis during chloroplast development.\"",
        "SecondarySymbol" : "EMBRYO DEFECTIVE 269 (EMB269); (ATOBGC); (OBG A-2);EMBRYO DEFECTIVE 3138 (EMB3138);OBG-LIKE PROTEIN (ATOBGL);CHLOROPLASTIC SAR1 (CPSAR1)",
        "sstart" : 192,
        "qstart" : 1842,
        "qcovhsp" : 12,
        "shared_name" : "KfCluster-29573.0",
        "ppos" : 69.73,
        "score" : 1263,
        "pident" : 56.442,
        "SUID" : 17275,
        "selected" : false,
        "sseqid" : "AT5G18570",
        "length" : 489,
        "nident" : 276,
        "evalue" : 9.15E-158,
        "positive" : 341,
        "gaps" : 14,
        "Type" : "protein_coding",
        "bitscore" : 491.0,
        "slen" : 681,
        "mismatch" : 199,
        "name" : "KfCluster-29573.0",
        "send" : 679,
        "qcovs" : 35,
        "PrimarySymbol" : "EMBRYO DEFECTIVE 269 (EMB269)",
        "qend" : 415
      },
      "position" : {
        "x" : 37.79936218261719,
        "y" : -1472.38037109375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17961",
        "degree_layout" : 3,
        "Description" : "\"Zinc finger, C3HC4 type (RING finger) family protein;(source:Araport11)\"",
        "SecondarySymbol" : "0",
        "sstart" : 3749,
        "qstart" : 3398,
        "qcovhsp" : 32,
        "shared_name" : "SpCluster-12836.0",
        "ppos" : 52.61,
        "score" : 1571,
        "pident" : 34.464,
        "SUID" : 17961,
        "selected" : false,
        "sseqid" : "AT5G23110",
        "length" : 1091,
        "nident" : 376,
        "evalue" : 0.0,
        "positive" : 574,
        "gaps" : 145,
        "Type" : "protein_coding",
        "bitscore" : 609.0,
        "slen" : 4706,
        "mismatch" : 570,
        "name" : "SpCluster-12836.0",
        "send" : 4706,
        "qcovs" : 95,
        "PrimarySymbol" : "0",
        "qend" : 162
      },
      "position" : {
        "x" : 597.2355014197111,
        "y" : -1890.3896484375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17274",
        "degree_layout" : 1,
        "Description" : "potassium transporter;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 275,
        "qstart" : 1005,
        "qcovhsp" : 5,
        "shared_name" : "KfCluster-29320.0",
        "ppos" : 43.52,
        "score" : 78,
        "pident" : 24.074,
        "SUID" : 17274,
        "selected" : false,
        "sseqid" : "AT5G14890",
        "length" : 108,
        "nident" : 26,
        "evalue" : 0.26,
        "positive" : 47,
        "gaps" : 9,
        "Type" : "protein_coding",
        "bitscore" : 34.7,
        "slen" : 754,
        "mismatch" : 73,
        "name" : "KfCluster-29320.0",
        "send" : 378,
        "qcovs" : 16,
        "PrimarySymbol" : "0",
        "qend" : 1313
      },
      "position" : {
        "x" : -485.953857421875,
        "y" : -1078.059814453125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17273",
        "degree_layout" : 2,
        "Description" : "mechanosensitive channel of small conductance-like 5;(source:Araport11)",
        "SecondarySymbol" : "MECHANOSENSITIVE CHANNEL OF SMALL CONDUCTANCE-LIKE 5 (MSL5)",
        "sstart" : 174,
        "qstart" : 1197,
        "qcovhsp" : 15,
        "shared_name" : "PpCluster-26952.0",
        "ppos" : 64.45,
        "score" : 1213,
        "pident" : 46.919,
        "SUID" : 17273,
        "selected" : false,
        "sseqid" : "AT3G14810",
        "length" : 633,
        "nident" : 297,
        "evalue" : 4.63E-148,
        "positive" : 408,
        "gaps" : 31,
        "Type" : "protein_coding",
        "bitscore" : 471.0,
        "slen" : 881,
        "mismatch" : 305,
        "name" : "PpCluster-26952.0",
        "send" : 782,
        "qcovs" : 46,
        "PrimarySymbol" : "MECHANOSENSITIVE CHANNEL OF SMALL CONDUCTANCE-LIKE 5 (MSL5)",
        "qend" : 3074
      },
      "position" : {
        "x" : 994.2515869140625,
        "y" : -1173.9554443359375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17272",
        "degree_layout" : 3,
        "Description" : "mechanosensitive channel of small conductance-like 5;(source:Araport11)",
        "SecondarySymbol" : "MECHANOSENSITIVE CHANNEL OF SMALL CONDUCTANCE-LIKE 5 (MSL5)",
        "sstart" : 163,
        "qstart" : 1387,
        "qcovhsp" : 15,
        "shared_name" : "KfCluster-29088.0",
        "ppos" : 58.87,
        "score" : 1037,
        "pident" : 40.981,
        "SUID" : 17272,
        "selected" : false,
        "sseqid" : "AT3G14810",
        "length" : 693,
        "nident" : 284,
        "evalue" : 5.97E-122,
        "positive" : 408,
        "gaps" : 88,
        "Type" : "protein_coding",
        "bitscore" : 404.0,
        "slen" : 881,
        "mismatch" : 321,
        "name" : "KfCluster-29088.0",
        "send" : 790,
        "qcovs" : 44,
        "PrimarySymbol" : "MECHANOSENSITIVE CHANNEL OF SMALL CONDUCTANCE-LIKE 5 (MSL5)",
        "qend" : 3396
      },
      "position" : {
        "x" : 856.1852416992188,
        "y" : -1286.1981201171875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17271",
        "degree_layout" : 6,
        "Description" : "GTP binding Elongation factor Tu family protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 57,
        "qstart" : 1,
        "qcovhsp" : 33,
        "shared_name" : "SpCluster-7050.6",
        "ppos" : 76.3,
        "score" : 518,
        "pident" : 75.556,
        "SUID" : 17271,
        "selected" : false,
        "sseqid" : "AT1G07930",
        "length" : 135,
        "nident" : 102,
        "evalue" : 7.07E-66,
        "positive" : 103,
        "gaps" : 30,
        "Type" : "protein_coding",
        "bitscore" : 204.0,
        "slen" : 372,
        "mismatch" : 3,
        "name" : "SpCluster-7050.6",
        "send" : 161,
        "qcovs" : 100,
        "PrimarySymbol" : "0",
        "qend" : 405
      },
      "position" : {
        "x" : 1191.1711204866697,
        "y" : -477.5043640136719
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17270",
        "degree_layout" : 4,
        "Description" : "GTP binding Elongation factor Tu family protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 151,
        "qstart" : 276,
        "qcovhsp" : 28,
        "shared_name" : "SpCluster-7050.4",
        "ppos" : 93.51,
        "score" : 363,
        "pident" : 85.714,
        "SUID" : 17270,
        "selected" : false,
        "sseqid" : "AT1G07930",
        "length" : 77,
        "nident" : 66,
        "evalue" : 1.91E-43,
        "positive" : 72,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 144.0,
        "slen" : 372,
        "mismatch" : 11,
        "name" : "SpCluster-7050.4",
        "send" : 227,
        "qcovs" : 83,
        "PrimarySymbol" : "0",
        "qend" : 46
      },
      "position" : {
        "x" : 1054.0888450960447,
        "y" : -89.58907318115234
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17269",
        "degree_layout" : 8,
        "Description" : "GTP binding Elongation factor Tu family protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 20,
        "qstart" : 3,
        "qcovhsp" : 33,
        "shared_name" : "SpCluster-7050.26",
        "ppos" : 95.33,
        "score" : 533,
        "pident" : 94.393,
        "SUID" : 17269,
        "selected" : false,
        "sseqid" : "AT1G07930",
        "length" : 107,
        "nident" : 101,
        "evalue" : 1.5E-68,
        "positive" : 102,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 209.0,
        "slen" : 372,
        "mismatch" : 6,
        "name" : "SpCluster-7050.26",
        "send" : 126,
        "qcovs" : 99,
        "PrimarySymbol" : "0",
        "qend" : 323
      },
      "position" : {
        "x" : 1189.1059349397947,
        "y" : -423.5081787109375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17268",
        "degree_layout" : 11,
        "Description" : "GTP binding Elongation factor Tu family protein;(source:Araport11)",
        "SecondarySymbol" : "(EF1ALPHA)",
        "sstart" : 322,
        "qstart" : 2,
        "qcovhsp" : 33,
        "shared_name" : "SpCluster-7050.18",
        "ppos" : 91.18,
        "score" : 468,
        "pident" : 84.314,
        "SUID" : 17268,
        "selected" : false,
        "sseqid" : "AT5G60390",
        "length" : 102,
        "nident" : 86,
        "evalue" : 3.89E-58,
        "positive" : 93,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 184.0,
        "slen" : 449,
        "mismatch" : 16,
        "name" : "SpCluster-7050.18",
        "send" : 423,
        "qcovs" : 99,
        "PrimarySymbol" : "(EF1ALPHA)",
        "qend" : 307
      },
      "position" : {
        "x" : 994.8121727327634,
        "y" : -129.06570434570312
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17267",
        "degree_layout" : 8,
        "Description" : "GTP binding Elongation factor Tu family protein;(source:Araport11)",
        "SecondarySymbol" : "(EF1ALPHA)",
        "sstart" : 186,
        "qstart" : 230,
        "qcovhsp" : 33,
        "shared_name" : "SpCluster-7050.17",
        "ppos" : 97.37,
        "score" : 375,
        "pident" : 92.105,
        "SUID" : 17267,
        "selected" : false,
        "sseqid" : "AT5G60390",
        "length" : 76,
        "nident" : 70,
        "evalue" : 3.29E-45,
        "positive" : 74,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 149.0,
        "slen" : 400,
        "mismatch" : 6,
        "name" : "SpCluster-7050.17",
        "send" : 261,
        "qcovs" : 99,
        "PrimarySymbol" : "(EF1ALPHA)",
        "qend" : 3
      },
      "position" : {
        "x" : 1002.3890770296384,
        "y" : -188.01815795898438
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17266",
        "degree_layout" : 8,
        "Description" : "GTP binding Elongation factor Tu family protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 282,
        "qstart" : 282,
        "qcovhsp" : 28,
        "shared_name" : "SpCluster-7050.13",
        "ppos" : 93.59,
        "score" : 340,
        "pident" : 82.051,
        "SUID" : 17266,
        "selected" : false,
        "sseqid" : "AT1G07930",
        "length" : 78,
        "nident" : 64,
        "evalue" : 6.29E-40,
        "positive" : 73,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 135.0,
        "slen" : 372,
        "mismatch" : 14,
        "name" : "SpCluster-7050.13",
        "send" : 359,
        "qcovs" : 83,
        "PrimarySymbol" : "0",
        "qend" : 49
      },
      "position" : {
        "x" : 1116.1270531038572,
        "y" : -81.46737670898438
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17265",
        "degree_layout" : 19,
        "Description" : "Translation elongation factor EF1A/initiation factor IF2gamma family protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 222,
        "qstart" : 236,
        "qcovhsp" : 26,
        "shared_name" : "SpCluster-6992.0",
        "ppos" : 69.32,
        "score" : 1035,
        "pident" : 45.033,
        "SUID" : 17265,
        "selected" : false,
        "sseqid" : "AT5G10630",
        "length" : 453,
        "nident" : 204,
        "evalue" : 3.87E-133,
        "positive" : 314,
        "gaps" : 9,
        "Type" : "protein_coding",
        "bitscore" : 403.0,
        "slen" : 667,
        "mismatch" : 240,
        "name" : "SpCluster-6992.0",
        "send" : 665,
        "qcovs" : 79,
        "PrimarySymbol" : "0",
        "qend" : 1594
      },
      "position" : {
        "x" : 1202.5248802522947,
        "y" : -285.6294860839844
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17264",
        "degree_layout" : 20,
        "Description" : "Translation elongation factor EFG/EF2 protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 59,
        "qstart" : 610,
        "qcovhsp" : 19,
        "shared_name" : "SpCluster-5517.0",
        "ppos" : 45.36,
        "score" : 395,
        "pident" : 26.21,
        "SUID" : 17264,
        "selected" : false,
        "sseqid" : "AT2G45030",
        "length" : 496,
        "nident" : 130,
        "evalue" : 1.83E-39,
        "positive" : 225,
        "gaps" : 54,
        "Type" : "protein_coding",
        "bitscore" : 156.0,
        "slen" : 754,
        "mismatch" : 312,
        "name" : "SpCluster-5517.0",
        "send" : 530,
        "qcovs" : 58,
        "PrimarySymbol" : "0",
        "qend" : 2007
      },
      "position" : {
        "x" : 1094.2535179476072,
        "y" : -444.2366943359375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17263",
        "degree_layout" : 16,
        "Description" : "Translation elongation factor EF1A/initiation factor IF2gamma family protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 90,
        "qstart" : 1196,
        "qcovhsp" : 15,
        "shared_name" : "KfCluster-29036.0",
        "ppos" : 84.55,
        "score" : 1686,
        "pident" : 71.591,
        "SUID" : 17263,
        "selected" : false,
        "sseqid" : "AT1G18070",
        "length" : 440,
        "nident" : 315,
        "evalue" : 0.0,
        "positive" : 372,
        "gaps" : 1,
        "Type" : "protein_coding",
        "bitscore" : 654.0,
        "slen" : 532,
        "mismatch" : 124,
        "name" : "KfCluster-29036.0",
        "send" : 528,
        "qcovs" : 46,
        "PrimarySymbol" : "0",
        "qend" : 2515
      },
      "position" : {
        "x" : 1112.3057640413572,
        "y" : -301.076171875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17262",
        "degree_layout" : 3,
        "Description" : "\"Encodes AtLa1, a member of the highly abundant phosphoprotein La proteins.  Predominantly localized to the nucleoplasm and was also detected in the nucleolar cavity.  Has RNA binding activity.  Required for normal ribosome biogenesis and embryogenesis.\"",
        "SecondarySymbol" : "LA PROTEIN 1 (AtLa1);LA PROTEIN 1 (La1)",
        "sstart" : 14,
        "qstart" : 1029,
        "qcovhsp" : 12,
        "shared_name" : "SpCluster-8709.0",
        "ppos" : 53.39,
        "score" : 247,
        "pident" : 33.475,
        "SUID" : 17262,
        "selected" : false,
        "sseqid" : "AT4G32720",
        "length" : 236,
        "nident" : 79,
        "evalue" : 2.95E-22,
        "positive" : 126,
        "gaps" : 18,
        "Type" : "protein_coding",
        "bitscore" : 99.8,
        "slen" : 404,
        "mismatch" : 139,
        "name" : "SpCluster-8709.0",
        "send" : 245,
        "qcovs" : 36,
        "PrimarySymbol" : "LA PROTEIN 1 (La1)",
        "qend" : 364
      },
      "position" : {
        "x" : 51.57006072998047,
        "y" : -1704.0338134765625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17261",
        "degree_layout" : 3,
        "Description" : "\"Encodes AtLa1, a member of the highly abundant phosphoprotein La proteins.  Predominantly localized to the nucleoplasm and was also detected in the nucleolar cavity.  Has RNA binding activity.  Required for normal ribosome biogenesis and embryogenesis.\"",
        "SecondarySymbol" : "LA PROTEIN 1 (AtLa1);LA PROTEIN 1 (La1)",
        "sstart" : 316,
        "qstart" : 369,
        "qcovhsp" : 12,
        "shared_name" : "SpCluster-11248.0",
        "ppos" : 61.11,
        "score" : 118,
        "pident" : 31.944,
        "SUID" : 17261,
        "selected" : false,
        "sseqid" : "AT4G32720",
        "length" : 72,
        "nident" : 23,
        "evalue" : 2.68E-7,
        "positive" : 44,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 50.1,
        "slen" : 404,
        "mismatch" : 49,
        "name" : "SpCluster-11248.0",
        "send" : 387,
        "qcovs" : 37,
        "PrimarySymbol" : "LA PROTEIN 1 (La1)",
        "qend" : 154
      },
      "position" : {
        "x" : 14.116874694824219,
        "y" : -1643.5689697265625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17260",
        "degree_layout" : 5,
        "Description" : "\"Encodes AtLa1, a member of the highly abundant phosphoprotein La proteins.  Predominantly localized to the nucleoplasm and was also detected in the nucleolar cavity.  Has RNA binding activity.  Required for normal ribosome biogenesis and embryogenesis.\"",
        "SecondarySymbol" : "LA PROTEIN 1 (AtLa1);LA PROTEIN 1 (La1)",
        "sstart" : 45,
        "qstart" : 684,
        "qcovhsp" : 20,
        "shared_name" : "KfCluster-28728.0",
        "ppos" : 51.37,
        "score" : 298,
        "pident" : 28.022,
        "SUID" : 17260,
        "selected" : false,
        "sseqid" : "AT4G32720",
        "length" : 364,
        "nident" : 102,
        "evalue" : 5.22E-29,
        "positive" : 187,
        "gaps" : 42,
        "Type" : "protein_coding",
        "bitscore" : 119.0,
        "slen" : 404,
        "mismatch" : 220,
        "name" : "KfCluster-28728.0",
        "send" : 402,
        "qcovs" : 59,
        "PrimarySymbol" : "LA PROTEIN 1 (La1)",
        "qend" : 1667
      },
      "position" : {
        "x" : -29.809600830078125,
        "y" : -1531.9488525390625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17259",
        "degree_layout" : 1,
        "Description" : "\"Encodes a negative regulator of 1-aminocyclopropane-1-carboxylic acid synthase5(ACS5), which catalyze the rate-limiting step in ethylene biosynthesis. ETO1 directly interacts with ACS5 and inhibits its enzyme activity and targets it for degradation via proteasome-dependent pathway. It also interacts with CUL3 (a component of ubiquitin ligase complexes). eto1 (and eto3) mutations elevate ethylene biosynthesis by affecting the posttranscriptional regulation of ACS\"",
        "SecondarySymbol" : "ETHYLENE OVERPRODUCER 1 (ETO1)",
        "sstart" : 316,
        "qstart" : 2611,
        "qcovhsp" : 15,
        "shared_name" : "KfCluster-28683.0",
        "ppos" : 65.64,
        "score" : 1470,
        "pident" : 46.533,
        "SUID" : 17259,
        "selected" : false,
        "sseqid" : "AT3G51770",
        "length" : 649,
        "nident" : 302,
        "evalue" : 0.0,
        "positive" : 426,
        "gaps" : 15,
        "Type" : "protein_coding",
        "bitscore" : 570.0,
        "slen" : 959,
        "mismatch" : 332,
        "name" : "KfCluster-28683.0",
        "send" : 949,
        "qcovs" : 45,
        "PrimarySymbol" : "ETHYLENE OVERPRODUCER 1 (ETO1)",
        "qend" : 665
      },
      "position" : {
        "x" : 312.8243713378906,
        "y" : -1841.854736328125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17951",
        "degree_layout" : 6,
        "Description" : "glycosyl hydrolase 9C3;(source:Araport11)",
        "SecondarySymbol" : "GLYCOSYL HYDROLASE 9C3 (GH9C3);GLYCOSYL HYDROLASE 9C3 (AtGH9C3)",
        "sstart" : 31,
        "qstart" : 1926,
        "qcovhsp" : 19,
        "shared_name" : "SpCluster-13190.0",
        "ppos" : 55.33,
        "score" : 743,
        "pident" : 37.09,
        "SUID" : 17951,
        "selected" : false,
        "sseqid" : "AT4G11050",
        "length" : 488,
        "nident" : 181,
        "evalue" : 1.41E-87,
        "positive" : 270,
        "gaps" : 39,
        "Type" : "protein_coding",
        "bitscore" : 290.0,
        "slen" : 626,
        "mismatch" : 268,
        "name" : "SpCluster-13190.0",
        "send" : 489,
        "qcovs" : 58,
        "PrimarySymbol" : "GLYCOSYL HYDROLASE 9C3 (GH9C3)",
        "qend" : 493
      },
      "position" : {
        "x" : 154.5997772216797,
        "y" : -1443.705322265625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17258",
        "degree_layout" : 2,
        "Description" : "Encodes a member of the Arabidopsis Pumilio (APUM) proteins containing PUF domain (eight repeats of approximately 36 amino acids each). PUF proteins regulate both mRNA stability and translation through sequence-specific binding to the 3' UTR of target mRNA transcripts.",
        "SecondarySymbol" : "PUMILIO 2 (PUM2);PUMILIO 2 (APUM2)",
        "sstart" : 900,
        "qstart" : 2,
        "qcovhsp" : 6,
        "shared_name" : "PpCluster-1732.3",
        "ppos" : 94.03,
        "score" : 288,
        "pident" : 83.582,
        "SUID" : 17258,
        "selected" : false,
        "sseqid" : "AT2G29190",
        "length" : 67,
        "nident" : 56,
        "evalue" : 4.8E-28,
        "positive" : 63,
        "gaps" : 1,
        "Type" : "protein_coding",
        "bitscore" : 115.0,
        "slen" : 972,
        "mismatch" : 10,
        "name" : "PpCluster-1732.3",
        "send" : 965,
        "qcovs" : 19,
        "PrimarySymbol" : "PUMILIO 2 (PUM2)",
        "qend" : 202
      },
      "position" : {
        "x" : -812.430419921875,
        "y" : -1099.0341796875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17257",
        "degree_layout" : 3,
        "Description" : "Encodes a member of the Arabidopsis Pumilio (APUM) proteins containing PUF domain (eight repeats of approximately 36 amino acids each). PUF proteins regulate both mRNA stability and translation through sequence-specific binding to the 3' UTR of target mRNA transcripts.",
        "SecondarySymbol" : "PUMILIO 12 (APUM12);PUMILIO 12 (PUM12);WHITE RUST RESISTANCE 4 (WRR4)",
        "sstart" : 271,
        "qstart" : 2094,
        "qcovhsp" : 8,
        "shared_name" : "KfCluster-28430.0",
        "ppos" : 76.88,
        "score" : 1007,
        "pident" : 57.5,
        "SUID" : 17257,
        "selected" : false,
        "sseqid" : "AT5G56510",
        "length" : 320,
        "nident" : 184,
        "evalue" : 5.53E-122,
        "positive" : 246,
        "gaps" : 1,
        "Type" : "protein_coding",
        "bitscore" : 392.0,
        "slen" : 596,
        "mismatch" : 135,
        "name" : "KfCluster-28430.0",
        "send" : 590,
        "qcovs" : 24,
        "PrimarySymbol" : "PUMILIO 12 (PUM12)",
        "qend" : 1138
      },
      "position" : {
        "x" : -684.8887939453125,
        "y" : -1141.5985107421875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17256",
        "degree_layout" : 6,
        "Description" : "Encodes a GTPase that belongs to the subfamily of YlqF/YawG GTPases.  Functions in Pre-60S ribosomal subunit maturation. The mRNA is cell-to-cell mobile.",
        "SecondarySymbol" : "NUCLEAR/NUCLEOLAR GTPASE 2 (Nug2);NUCLEAR/NUCLEOLAR GTPASE 2 (AtNug2)",
        "sstart" : 1,
        "qstart" : 53,
        "qcovhsp" : 11,
        "shared_name" : "SpCluster-18200.0",
        "ppos" : 72.11,
        "score" : 759,
        "pident" : 57.823,
        "SUID" : 17256,
        "selected" : false,
        "sseqid" : "AT1G52980",
        "length" : 294,
        "nident" : 170,
        "evalue" : 7.48E-90,
        "positive" : 212,
        "gaps" : 4,
        "Type" : "protein_coding",
        "bitscore" : 296.0,
        "slen" : 576,
        "mismatch" : 120,
        "name" : "SpCluster-18200.0",
        "send" : 290,
        "qcovs" : 33,
        "PrimarySymbol" : "NUCLEAR/NUCLEOLAR GTPASE 2 (AtNug2)",
        "qend" : 934
      },
      "position" : {
        "x" : -700.4918823242188,
        "y" : -791.7721557617188
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17255",
        "degree_layout" : 6,
        "Description" : "Arabidopsis NSN1 encodes a nucleolar GTP-   binding protein and is required for maintenance of inflorescence meristem identity and floral organ development.",
        "SecondarySymbol" : "NUCLEOSTEMIN-LIKE 1 (NSN1)",
        "sstart" : 44,
        "qstart" : 307,
        "qcovhsp" : 17,
        "shared_name" : "PpCluster-11061.0",
        "ppos" : 70.47,
        "score" : 929,
        "pident" : 53.256,
        "SUID" : 17255,
        "selected" : false,
        "sseqid" : "AT3G07050",
        "length" : 430,
        "nident" : 229,
        "evalue" : 6.1E-115,
        "positive" : 303,
        "gaps" : 14,
        "Type" : "protein_coding",
        "bitscore" : 362.0,
        "slen" : 582,
        "mismatch" : 187,
        "name" : "PpCluster-11061.0",
        "send" : 463,
        "qcovs" : 50,
        "PrimarySymbol" : "NUCLEOSTEMIN-LIKE 1 (NSN1)",
        "qend" : 1584
      },
      "position" : {
        "x" : -615.7392578125,
        "y" : -826.4296875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17254",
        "degree_layout" : 7,
        "Description" : "Encodes a GTPase that belongs to the subfamily of YlqF/YawG GTPases.  Functions in Pre-60S ribosomal subunit maturation. The mRNA is cell-to-cell mobile.",
        "SecondarySymbol" : "NUCLEAR/NUCLEOLAR GTPASE 2 (Nug2);NUCLEAR/NUCLEOLAR GTPASE 2 (AtNug2)",
        "sstart" : 3,
        "qstart" : 243,
        "qcovhsp" : 18,
        "shared_name" : "KfCluster-7327.0",
        "ppos" : 78.57,
        "score" : 1563,
        "pident" : 68.615,
        "SUID" : 17254,
        "selected" : false,
        "sseqid" : "AT1G52980",
        "length" : 462,
        "nident" : 317,
        "evalue" : 0.0,
        "positive" : 363,
        "gaps" : 1,
        "Type" : "protein_coding",
        "bitscore" : 606.0,
        "slen" : 576,
        "mismatch" : 144,
        "name" : "KfCluster-7327.0",
        "send" : 463,
        "qcovs" : 55,
        "PrimarySymbol" : "NUCLEAR/NUCLEOLAR GTPASE 2 (AtNug2)",
        "qend" : 1628
      },
      "position" : {
        "x" : -615.917236328125,
        "y" : -928.0471801757812
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17253",
        "degree_layout" : 6,
        "Description" : "Arabidopsis NSN1 encodes a nucleolar GTP-   binding protein and is required for maintenance of inflorescence meristem identity and floral organ development.",
        "SecondarySymbol" : "NUCLEOSTEMIN-LIKE 1 (NSN1)",
        "sstart" : 44,
        "qstart" : 295,
        "qcovhsp" : 12,
        "shared_name" : "KfCluster-28313.0",
        "ppos" : 68.18,
        "score" : 962,
        "pident" : 54.278,
        "SUID" : 17253,
        "selected" : false,
        "sseqid" : "AT3G07050",
        "length" : 374,
        "nident" : 203,
        "evalue" : 1.17E-118,
        "positive" : 255,
        "gaps" : 56,
        "Type" : "protein_coding",
        "bitscore" : 375.0,
        "slen" : 582,
        "mismatch" : 115,
        "name" : "KfCluster-28313.0",
        "send" : 378,
        "qcovs" : 37,
        "PrimarySymbol" : "NUCLEOSTEMIN-LIKE 1 (NSN1)",
        "qend" : 1365
      },
      "position" : {
        "x" : -703.9319458007812,
        "y" : -866.6622924804688
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17248",
        "degree_layout" : 10,
        "Description" : "Encodes a capase involved in stress induced cell death.",
        "SecondarySymbol" : "(ATCATHB2)",
        "sstart" : 130,
        "qstart" : 1191,
        "qcovhsp" : 15,
        "shared_name" : "SpCluster-3532.3",
        "ppos" : 42.29,
        "score" : 248,
        "pident" : 30.837,
        "SUID" : 17248,
        "selected" : false,
        "sseqid" : "AT1G02305",
        "length" : 227,
        "nident" : 70,
        "evalue" : 6.46E-23,
        "positive" : 96,
        "gaps" : 26,
        "Type" : "protein_coding",
        "bitscore" : 100.0,
        "slen" : 362,
        "mismatch" : 131,
        "name" : "SpCluster-3532.3",
        "send" : 335,
        "qcovs" : 44,
        "PrimarySymbol" : "(ATCATHB2)",
        "qend" : 526
      },
      "position" : {
        "x" : 423.6316833496094,
        "y" : -1346.6510009765625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17247",
        "degree_layout" : 13,
        "Description" : "Late embryogenesis abundant protein (LEA) family protein;(source:Araport11)",
        "SecondarySymbol" : "LATE EMBRYOGENESIS ABUNDANT 7 (LEA7)",
        "sstart" : 14,
        "qstart" : 485,
        "qcovhsp" : 6,
        "shared_name" : "SpCluster-16168.0",
        "ppos" : 45.1,
        "score" : 75,
        "pident" : 35.294,
        "SUID" : 17247,
        "selected" : false,
        "sseqid" : "AT1G52690",
        "length" : 153,
        "nident" : 54,
        "evalue" : 0.33,
        "positive" : 69,
        "gaps" : 30,
        "Type" : "protein_coding",
        "bitscore" : 33.5,
        "slen" : 169,
        "mismatch" : 69,
        "name" : "SpCluster-16168.0",
        "send" : 136,
        "qcovs" : 19,
        "PrimarySymbol" : "LATE EMBRYOGENESIS ABUNDANT 7 (LEA7)",
        "qend" : 943
      },
      "position" : {
        "x" : 632.6066284179688,
        "y" : -1315.234375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17246",
        "degree_layout" : 6,
        "Description" : "",
        "SecondarySymbol" : "",
        "shared_name" : "SpCluster-12052.0",
        "SUID" : 17246,
        "selected" : false,
        "sseqid" : "",
        "Type" : "",
        "name" : "SpCluster-12052.0",
        "PrimarySymbol" : ""
      },
      "position" : {
        "x" : 635.9716186523438,
        "y" : -1663.68994140625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17245",
        "degree_layout" : 8,
        "Description" : "subunit 6b of cytochrome c oxidase",
        "SecondarySymbol" : "CYTOCHROME C OXIDASE 6B2 (ATCOX6B2);CYTOCHROME C OXIDASE 6B (COX6B)",
        "sstart" : 119,
        "qstart" : 1126,
        "qcovhsp" : 4,
        "shared_name" : "KfCluster-28147.0",
        "ppos" : 84.29,
        "score" : 305,
        "pident" : 62.857,
        "SUID" : 17245,
        "selected" : false,
        "sseqid" : "AT1G22450",
        "length" : 70,
        "nident" : 44,
        "evalue" : 5.51E-32,
        "positive" : 59,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 122.0,
        "slen" : 191,
        "mismatch" : 26,
        "name" : "KfCluster-28147.0",
        "send" : 188,
        "qcovs" : 12,
        "PrimarySymbol" : "CYTOCHROME C OXIDASE 6B (COX6B)",
        "qend" : 1335
      },
      "position" : {
        "x" : 544.3006591796875,
        "y" : -1443.0726318359375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17241",
        "degree_layout" : 4,
        "Description" : "bromodomain and extraterminal domain protein 10;(source:Araport11)",
        "SecondarySymbol" : "BROMODOMAIN AND EXTRATERMINAL DOMAIN PROTEIN 10 (BET10);BROMODOMAIN AND EXTRATERMINAL DOMAIN PROTEIN 10 (ATBET10)",
        "sstart" : 440,
        "qstart" : 1611,
        "qcovhsp" : 8,
        "shared_name" : "PpCluster-2303.1",
        "ppos" : 56.91,
        "score" : 190,
        "pident" : 39.227,
        "SUID" : 17241,
        "selected" : false,
        "sseqid" : "AT3G01770",
        "length" : 181,
        "nident" : 71,
        "evalue" : 1.14E-14,
        "positive" : 103,
        "gaps" : 39,
        "Type" : "protein_coding",
        "bitscore" : 77.8,
        "slen" : 620,
        "mismatch" : 71,
        "name" : "PpCluster-2303.1",
        "send" : 595,
        "qcovs" : 24,
        "PrimarySymbol" : "BROMODOMAIN AND EXTRATERMINAL DOMAIN PROTEIN 10 (BET10)",
        "qend" : 1111
      },
      "position" : {
        "x" : 239.16049194335938,
        "y" : -1666.468505859375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17240",
        "degree_layout" : 2,
        "Description" : "NB-ARC domain-containing disease resistance protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 905,
        "qstart" : 112,
        "qcovhsp" : 3,
        "shared_name" : "KfCluster-27987.1",
        "ppos" : 58.82,
        "score" : 70,
        "pident" : 38.235,
        "SUID" : 17240,
        "selected" : false,
        "sseqid" : "AT4G19050",
        "length" : 34,
        "nident" : 13,
        "evalue" : 1.6,
        "positive" : 20,
        "gaps" : 6,
        "Type" : "protein_coding",
        "bitscore" : 31.6,
        "slen" : 1201,
        "mismatch" : 15,
        "name" : "KfCluster-27987.1",
        "send" : 932,
        "qcovs" : 9,
        "PrimarySymbol" : "0",
        "qend" : 11
      },
      "position" : {
        "x" : 279.5024719238281,
        "y" : -2005.4696044921875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17239",
        "degree_layout" : 3,
        "Description" : "\"methyl-coenzyme M reductase II subunit gamma, putative (DUF3741);(source:Araport11)\"",
        "SecondarySymbol" : "TON1 RECRUITING MOTIF 20 (TRM20)",
        "sstart" : 616,
        "qstart" : 1857,
        "qcovhsp" : 3,
        "shared_name" : "KfCluster-27987.0",
        "ppos" : 47.62,
        "score" : 71,
        "pident" : 33.333,
        "SUID" : 17239,
        "selected" : false,
        "sseqid" : "AT4G28760",
        "length" : 63,
        "nident" : 21,
        "evalue" : 1.9,
        "positive" : 30,
        "gaps" : 3,
        "Type" : "protein_coding",
        "bitscore" : 32.0,
        "slen" : 924,
        "mismatch" : 39,
        "name" : "KfCluster-27987.0",
        "send" : 677,
        "qcovs" : 10,
        "PrimarySymbol" : "TON1 RECRUITING MOTIF 20 (TRM20)",
        "qend" : 1675
      },
      "position" : {
        "x" : 272.781982421875,
        "y" : -1891.01171875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17238",
        "degree_layout" : 16,
        "Description" : "Tetratricopeptide repeat (TPR)-like superfamily protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 310,
        "qstart" : 2145,
        "qcovhsp" : 21,
        "shared_name" : "SpCluster-9850.0",
        "ppos" : 38.49,
        "score" : 227,
        "pident" : 21.711,
        "SUID" : 17238,
        "selected" : false,
        "sseqid" : "AT3G06920",
        "length" : 608,
        "nident" : 132,
        "evalue" : 1.05E-18,
        "positive" : 234,
        "gaps" : 91,
        "Type" : "protein_coding",
        "bitscore" : 92.0,
        "slen" : 871,
        "mismatch" : 385,
        "name" : "SpCluster-9850.0",
        "send" : 842,
        "qcovs" : 63,
        "PrimarySymbol" : "0",
        "qend" : 370
      },
      "position" : {
        "x" : -341.0860290527344,
        "y" : -1999.73291015625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17237",
        "degree_layout" : 6,
        "Description" : "Di-glucose binding protein with Kinesin motor domain-containing protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 105,
        "qstart" : 616,
        "qcovhsp" : 5,
        "shared_name" : "KfCluster-5946.0",
        "ppos" : 45.74,
        "score" : 82,
        "pident" : 34.043,
        "SUID" : 17237,
        "selected" : false,
        "sseqid" : "AT2G22610",
        "length" : 94,
        "nident" : 32,
        "evalue" : 0.09,
        "positive" : 43,
        "gaps" : 12,
        "Type" : "protein_coding",
        "bitscore" : 36.2,
        "slen" : 1062,
        "mismatch" : 50,
        "name" : "KfCluster-5946.0",
        "send" : 189,
        "qcovs" : 16,
        "PrimarySymbol" : "0",
        "qend" : 888
      },
      "position" : {
        "x" : -174.63751220703125,
        "y" : -1311.03955078125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17236",
        "degree_layout" : 4,
        "Description" : "2-oxoglutarate (2OG) and Fe(II)-dependent oxygenase superfamily protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 9,
        "qstart" : 2241,
        "qcovhsp" : 15,
        "shared_name" : "SpCluster-6633.0",
        "ppos" : 66.32,
        "score" : 987,
        "pident" : 43.659,
        "SUID" : 17236,
        "selected" : false,
        "sseqid" : "AT3G12940",
        "length" : 481,
        "nident" : 210,
        "evalue" : 1.95E-123,
        "positive" : 319,
        "gaps" : 30,
        "Type" : "protein_coding",
        "bitscore" : 384.0,
        "slen" : 474,
        "mismatch" : 241,
        "name" : "SpCluster-6633.0",
        "send" : 474,
        "qcovs" : 46,
        "PrimarySymbol" : "0",
        "qend" : 844
      },
      "position" : {
        "x" : 289.47344970703125,
        "y" : -949.6474609375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17235",
        "degree_layout" : 5,
        "Description" : "RING/U-box superfamily protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 8,
        "qstart" : 189,
        "qcovhsp" : 17,
        "shared_name" : "SpCluster-15935.1",
        "ppos" : 56.73,
        "score" : 876,
        "pident" : 37.138,
        "SUID" : 17235,
        "selected" : false,
        "sseqid" : "AT3G19895",
        "length" : 587,
        "nident" : 218,
        "evalue" : 3.37E-105,
        "positive" : 333,
        "gaps" : 79,
        "Type" : "protein_coding",
        "bitscore" : 342.0,
        "slen" : 554,
        "mismatch" : 290,
        "name" : "SpCluster-15935.1",
        "send" : 534,
        "qcovs" : 50,
        "PrimarySymbol" : "0",
        "qend" : 1892
      },
      "position" : {
        "x" : 250.46066284179688,
        "y" : -1082.6142578125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17234",
        "degree_layout" : 7,
        "Description" : "RING/U-box superfamily protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 103,
        "qstart" : 3903,
        "qcovhsp" : 6,
        "shared_name" : "KfCluster-27754.0",
        "ppos" : 49.44,
        "score" : 458,
        "pident" : 32.5,
        "SUID" : 17234,
        "selected" : false,
        "sseqid" : "AT3G19895",
        "length" : 360,
        "nident" : 117,
        "evalue" : 1.22E-47,
        "positive" : 178,
        "gaps" : 38,
        "Type" : "protein_coding",
        "bitscore" : 181.0,
        "slen" : 554,
        "mismatch" : 205,
        "name" : "KfCluster-27754.0",
        "send" : 435,
        "qcovs" : 17,
        "PrimarySymbol" : "0",
        "qend" : 4949
      },
      "position" : {
        "x" : 144.09677124023438,
        "y" : -944.3739013671875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17945",
        "degree_layout" : 8,
        "Description" : "Calcium-binding EF hand family protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 351,
        "qstart" : 510,
        "qcovhsp" : 4,
        "shared_name" : "SpCluster-19769.0",
        "ppos" : 75.26,
        "score" : 346,
        "pident" : 63.918,
        "SUID" : 17945,
        "selected" : false,
        "sseqid" : "AT1G20760",
        "length" : 97,
        "nident" : 62,
        "evalue" : 5.04E-33,
        "positive" : 73,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 137.0,
        "slen" : 1019,
        "mismatch" : 35,
        "name" : "SpCluster-19769.0",
        "send" : 447,
        "qcovs" : 12,
        "PrimarySymbol" : "0",
        "qend" : 220
      },
      "position" : {
        "x" : -40.41239929199219,
        "y" : -1419.120361328125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17944",
        "degree_layout" : 2,
        "Description" : "Calcium-binding EF hand family protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 557,
        "qstart" : 2124,
        "qcovhsp" : 9,
        "shared_name" : "SpCluster-12210.0",
        "ppos" : 67.31,
        "score" : 281,
        "pident" : 45.673,
        "SUID" : 17944,
        "selected" : false,
        "sseqid" : "AT1G21630",
        "length" : 208,
        "nident" : 95,
        "evalue" : 2.8E-25,
        "positive" : 140,
        "gaps" : 3,
        "Type" : "protein_coding",
        "bitscore" : 112.0,
        "slen" : 1218,
        "mismatch" : 110,
        "name" : "SpCluster-12210.0",
        "send" : 761,
        "qcovs" : 28,
        "PrimarySymbol" : "0",
        "qend" : 1501
      },
      "position" : {
        "x" : -110.99981689453125,
        "y" : -1324.3931884765625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17233",
        "degree_layout" : 3,
        "Description" : "FAD/NAD(P)-binding oxidoreductase family protein;(source:Araport11)",
        "SecondarySymbol" : "(COQ6)",
        "sstart" : 224,
        "qstart" : 125,
        "qcovhsp" : 23,
        "shared_name" : "SpCluster-1665.0",
        "ppos" : 53.62,
        "score" : 501,
        "pident" : 38.816,
        "SUID" : 17233,
        "selected" : false,
        "sseqid" : "AT3G24200",
        "length" : 304,
        "nident" : 118,
        "evalue" : 1.85E-57,
        "positive" : 163,
        "gaps" : 27,
        "Type" : "protein_coding",
        "bitscore" : 197.0,
        "slen" : 507,
        "mismatch" : 159,
        "name" : "SpCluster-1665.0",
        "send" : 500,
        "qcovs" : 68,
        "PrimarySymbol" : "(COQ6)",
        "qend" : 1036
      },
      "position" : {
        "x" : 1104.2085960726072,
        "y" : -498.8170166015625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17232",
        "degree_layout" : 2,
        "Description" : "NADH dehydrogenase (ubiquinone)s;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 23,
        "qstart" : 926,
        "qcovhsp" : 2,
        "shared_name" : "KfCluster-12844.0",
        "ppos" : 61.54,
        "score" : 59,
        "pident" : 46.154,
        "SUID" : 17232,
        "selected" : false,
        "sseqid" : "AT1G14450",
        "length" : 26,
        "nident" : 12,
        "evalue" : 5.7,
        "positive" : 16,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 27.3,
        "slen" : 73,
        "mismatch" : 14,
        "name" : "KfCluster-12844.0",
        "send" : 48,
        "qcovs" : 5,
        "PrimarySymbol" : "0",
        "qend" : 1003
      },
      "position" : {
        "x" : 1049.5123070101072,
        "y" : -538.877197265625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17231",
        "degree_layout" : 4,
        "Description" : "FAD/NAD(P)-binding oxidoreductase family protein;(source:Araport11)",
        "SecondarySymbol" : "(COQ6)",
        "sstart" : 150,
        "qstart" : 2209,
        "qcovhsp" : 10,
        "shared_name" : "KfCluster-27686.0",
        "ppos" : 58.5,
        "score" : 605,
        "pident" : 41.499,
        "SUID" : 17231,
        "selected" : false,
        "sseqid" : "AT3G24200",
        "length" : 347,
        "nident" : 144,
        "evalue" : 1.01E-67,
        "positive" : 203,
        "gaps" : 10,
        "Type" : "protein_coding",
        "bitscore" : 237.0,
        "slen" : 507,
        "mismatch" : 193,
        "name" : "KfCluster-27686.0",
        "send" : 490,
        "qcovs" : 29,
        "PrimarySymbol" : "(COQ6)",
        "qend" : 1181
      },
      "position" : {
        "x" : 1118.3411644319822,
        "y" : -626.2841796875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17230",
        "degree_layout" : 14,
        "Description" : "\"Translation initiation factor 2, small GTP-binding protein;(source:Araport11)\"",
        "SecondarySymbol" : "0",
        "sstart" : 232,
        "qstart" : 1013,
        "qcovhsp" : 26,
        "shared_name" : "SpCluster-3485.0",
        "ppos" : 81.27,
        "score" : 836,
        "pident" : 66.667,
        "SUID" : 17230,
        "selected" : false,
        "sseqid" : "AT4G11160",
        "length" : 267,
        "nident" : 178,
        "evalue" : 4.66E-106,
        "positive" : 217,
        "gaps" : 1,
        "Type" : "protein_coding",
        "bitscore" : 326.0,
        "slen" : 743,
        "mismatch" : 88,
        "name" : "SpCluster-3485.0",
        "send" : 498,
        "qcovs" : 79,
        "PrimarySymbol" : "0",
        "qend" : 216
      },
      "position" : {
        "x" : 1236.7482689241697,
        "y" : -598.6956787109375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17229",
        "degree_layout" : 16,
        "Description" : "eukaryotic translation initiation factor 2 (eIF-2) family protein;(source:Araport11)",
        "SecondarySymbol" : "(EIF5B1)",
        "sstart" : 701,
        "qstart" : 3031,
        "qcovhsp" : 12,
        "shared_name" : "SpCluster-19429.0",
        "ppos" : 87.37,
        "score" : 2276,
        "pident" : 74.074,
        "SUID" : 17229,
        "selected" : false,
        "sseqid" : "AT1G76810",
        "length" : 594,
        "nident" : 440,
        "evalue" : 0.0,
        "positive" : 519,
        "gaps" : 1,
        "Type" : "protein_coding",
        "bitscore" : 881.0,
        "slen" : 1294,
        "mismatch" : 153,
        "name" : "SpCluster-19429.0",
        "send" : 1293,
        "qcovs" : 35,
        "PrimarySymbol" : "(EIF5B1)",
        "qend" : 4812
      },
      "position" : {
        "x" : 1105.5459984163572,
        "y" : -565.751220703125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17228",
        "degree_layout" : 4,
        "Description" : "\"Translation initiation factor 2, small GTP-binding protein;(source:Araport11)\"",
        "SecondarySymbol" : "0",
        "sstart" : 522,
        "qstart" : 123,
        "qcovhsp" : 24,
        "shared_name" : "SpCluster-17901.0",
        "ppos" : 72.2,
        "score" : 554,
        "pident" : 50.224,
        "SUID" : 17228,
        "selected" : false,
        "sseqid" : "AT4G11160",
        "length" : 223,
        "nident" : 112,
        "evalue" : 3.55E-65,
        "positive" : 161,
        "gaps" : 2,
        "Type" : "protein_coding",
        "bitscore" : 218.0,
        "slen" : 743,
        "mismatch" : 109,
        "name" : "SpCluster-17901.0",
        "send" : 742,
        "qcovs" : 72,
        "PrimarySymbol" : "0",
        "qend" : 791
      },
      "position" : {
        "x" : 1332.3512962679197,
        "y" : -631.46044921875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17227",
        "degree_layout" : 12,
        "Description" : "Encodes a chloroplast localized protein with similarity to translation initiation factor 2. Can complement loss of INFB in E.coli suggesting FUG1 does function as a translation initiation factor in vivo. Identified as a suppressor of the leaf variegation mutant var2-6. Suppression is only seen in hypomorphs as complete loss of function alleles are embryo lethal. The mRNA is cell-to-cell mobile.",
        "SecondarySymbol" : "FU-GAERI1 (FUG1)",
        "sstart" : 383,
        "qstart" : 2277,
        "qcovhsp" : 13,
        "shared_name" : "SpCluster-13459.0",
        "ppos" : 79.68,
        "score" : 1914,
        "pident" : 62.72,
        "SUID" : 17227,
        "selected" : false,
        "sseqid" : "AT1G17220",
        "length" : 625,
        "nident" : 392,
        "evalue" : 0.0,
        "positive" : 498,
        "gaps" : 3,
        "Type" : "protein_coding",
        "bitscore" : 741.0,
        "slen" : 1026,
        "mismatch" : 230,
        "name" : "SpCluster-13459.0",
        "send" : 1004,
        "qcovs" : 40,
        "PrimarySymbol" : "FU-GAERI1 (FUG1)",
        "qend" : 403
      },
      "position" : {
        "x" : 1175.0617454866697,
        "y" : -568.6629638671875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17226",
        "degree_layout" : 13,
        "Description" : "eukaryotic translation initiation factor 2 (eIF-2) family protein;(source:Araport11)",
        "SecondarySymbol" : "(EIF5B1)",
        "sstart" : 701,
        "qstart" : 3030,
        "qcovhsp" : 9,
        "shared_name" : "PpCluster-24155.0",
        "ppos" : 89.69,
        "score" : 2225,
        "pident" : 77.348,
        "SUID" : 17226,
        "selected" : false,
        "sseqid" : "AT1G76810",
        "length" : 543,
        "nident" : 420,
        "evalue" : 0.0,
        "positive" : 487,
        "gaps" : 1,
        "Type" : "protein_coding",
        "bitscore" : 861.0,
        "slen" : 1294,
        "mismatch" : 122,
        "name" : "PpCluster-24155.0",
        "send" : 1242,
        "qcovs" : 28,
        "PrimarySymbol" : "(EIF5B1)",
        "qend" : 4658
      },
      "position" : {
        "x" : 1325.4135521272947,
        "y" : -551.3565673828125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17225",
        "degree_layout" : 17,
        "Description" : "\"Encodes SVR3, a putative chloroplast TypA translation elongation GTPase.  Loss of SVR3 suppresses variegation mediated by var2.  SVR3 is essential for plants? ability to develop functional chloroplasts under chilling stress (8C), but not at normal temperature (22C).\"",
        "SecondarySymbol" : "SUPPRESSOR OF VARIEGATION 3 (SVR3)",
        "sstart" : 80,
        "qstart" : 2115,
        "qcovhsp" : 22,
        "shared_name" : "KfCluster-3077.0",
        "ppos" : 85.32,
        "score" : 2303,
        "pident" : 72.526,
        "SUID" : 17225,
        "selected" : false,
        "sseqid" : "AT5G13650",
        "length" : 586,
        "nident" : 425,
        "evalue" : 0.0,
        "positive" : 500,
        "gaps" : 1,
        "Type" : "protein_coding",
        "bitscore" : 891.0,
        "slen" : 676,
        "mismatch" : 160,
        "name" : "KfCluster-3077.0",
        "send" : 665,
        "qcovs" : 66,
        "PrimarySymbol" : "SUPPRESSOR OF VARIEGATION 3 (SVR3)",
        "qend" : 361
      },
      "position" : {
        "x" : 1295.6252220491697,
        "y" : -473.9176940917969
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17224",
        "degree_layout" : 14,
        "Description" : "Encodes a chloroplast localized protein with similarity to translation initiation factor 2. Can complement loss of INFB in E.coli suggesting FUG1 does function as a translation initiation factor in vivo. Identified as a suppressor of the leaf variegation mutant var2-6. Suppression is only seen in hypomorphs as complete loss of function alleles are embryo lethal. The mRNA is cell-to-cell mobile.",
        "SecondarySymbol" : "FU-GAERI1 (FUG1)",
        "sstart" : 405,
        "qstart" : 2233,
        "qcovhsp" : 17,
        "shared_name" : "KfCluster-2756.0",
        "ppos" : 76.19,
        "score" : 1717,
        "pident" : 59.113,
        "SUID" : 17224,
        "selected" : false,
        "sseqid" : "AT1G17220",
        "length" : 609,
        "nident" : 360,
        "evalue" : 0.0,
        "positive" : 464,
        "gaps" : 3,
        "Type" : "protein_coding",
        "bitscore" : 665.0,
        "slen" : 1026,
        "mismatch" : 246,
        "name" : "KfCluster-2756.0",
        "send" : 1011,
        "qcovs" : 51,
        "PrimarySymbol" : "FU-GAERI1 (FUG1)",
        "qend" : 410
      },
      "position" : {
        "x" : 1206.0400169710447,
        "y" : -641.339599609375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17223",
        "degree_layout" : 2,
        "Description" : "\"Chloroplastic enzyme responsible for the synthesis of 16:3 and 18:3 fatty acids from galactolipids, sulpholipids and phosphatidylglycerol. Uses ferredoxin as electron donor. Gene expression is induced by wounding in shoot and root. The wound-response in shoot is independent of jasmonic acid mediated pathway whereas the root response is mediated by jasmonic acid. The mRNA is cell-to-cell mobile.\"",
        "SecondarySymbol" : "FATTY ACID DESATURASE 7 (FAD7); (AtFAD7);FATTY ACID DESATURASE D (FADD)",
        "sstart" : 88,
        "qstart" : 595,
        "qcovhsp" : 10,
        "shared_name" : "KfCluster-27539.0",
        "ppos" : 84.34,
        "score" : 329,
        "pident" : 71.084,
        "SUID" : 17223,
        "selected" : false,
        "sseqid" : "AT3G11170",
        "length" : 83,
        "nident" : 59,
        "evalue" : 4.65E-35,
        "positive" : 70,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 131.0,
        "slen" : 446,
        "mismatch" : 24,
        "name" : "KfCluster-27539.0",
        "send" : 170,
        "qcovs" : 30,
        "PrimarySymbol" : "FATTY ACID DESATURASE 7 (FAD7)",
        "qend" : 843
      },
      "position" : {
        "x" : -1002.635009765625,
        "y" : -824.22705078125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17222",
        "degree_layout" : 10,
        "Description" : "Chaperone DnaJ-domain superfamily protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 1,
        "qstart" : 42,
        "qcovhsp" : 7,
        "shared_name" : "SpCluster-19412.0",
        "ppos" : 86.94,
        "score" : 703,
        "pident" : 68.98,
        "SUID" : 17222,
        "selected" : false,
        "sseqid" : "AT5G22080",
        "length" : 245,
        "nident" : 169,
        "evalue" : 8.22E-85,
        "positive" : 213,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 275.0,
        "slen" : 246,
        "mismatch" : 76,
        "name" : "SpCluster-19412.0",
        "send" : 245,
        "qcovs" : 22,
        "PrimarySymbol" : "0",
        "qend" : 776
      },
      "position" : {
        "x" : 1662.6863776742355,
        "y" : -1993.005174339029
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17221",
        "degree_layout" : 12,
        "Description" : "DNAJ heat shock N-terminal domain-containing protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 271,
        "qstart" : 1257,
        "qcovhsp" : 18,
        "shared_name" : "SpCluster-15839.0",
        "ppos" : 66.4,
        "score" : 426,
        "pident" : 45.6,
        "SUID" : 17221,
        "selected" : false,
        "sseqid" : "AT1G65280",
        "length" : 250,
        "nident" : 114,
        "evalue" : 3.75E-46,
        "positive" : 166,
        "gaps" : 9,
        "Type" : "protein_coding",
        "bitscore" : 168.0,
        "slen" : 588,
        "mismatch" : 127,
        "name" : "SpCluster-15839.0",
        "send" : 515,
        "qcovs" : 54,
        "PrimarySymbol" : "0",
        "qend" : 520
      },
      "position" : {
        "x" : 1722.7332526742355,
        "y" : -2035.3663803937166
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17220",
        "degree_layout" : 15,
        "Description" : "Chaperone DnaJ-domain superfamily protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 1,
        "qstart" : 297,
        "qcovhsp" : 4,
        "shared_name" : "SpCluster-11353.0",
        "ppos" : 67.14,
        "score" : 339,
        "pident" : 47.143,
        "SUID" : 17220,
        "selected" : false,
        "sseqid" : "AT5G37380",
        "length" : 140,
        "nident" : 66,
        "evalue" : 1.45E-33,
        "positive" : 94,
        "gaps" : 1,
        "Type" : "protein_coding",
        "bitscore" : 135.0,
        "slen" : 431,
        "mismatch" : 73,
        "name" : "SpCluster-11353.0",
        "send" : 140,
        "qcovs" : 12,
        "PrimarySymbol" : "0",
        "qend" : 713
      },
      "position" : {
        "x" : 1726.2728034554855,
        "y" : -1969.4381577374666
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17219",
        "degree_layout" : 12,
        "Description" : "DNAJ heat shock N-terminal domain-containing protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 324,
        "qstart" : 3127,
        "qcovhsp" : 7,
        "shared_name" : "PpCluster-14405.0",
        "ppos" : 64.26,
        "score" : 533,
        "pident" : 49.819,
        "SUID" : 17219,
        "selected" : false,
        "sseqid" : "AT1G65280",
        "length" : 277,
        "nident" : 138,
        "evalue" : 2.09E-57,
        "positive" : 178,
        "gaps" : 16,
        "Type" : "protein_coding",
        "bitscore" : 209.0,
        "slen" : 588,
        "mismatch" : 123,
        "name" : "PpCluster-14405.0",
        "send" : 588,
        "qcovs" : 21,
        "PrimarySymbol" : "0",
        "qend" : 2309
      },
      "position" : {
        "x" : 1795.5242682992355,
        "y" : -1935.027635276529
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17218",
        "degree_layout" : 8,
        "Description" : "homologous to the co-chaperon DNAJ protein from E coli",
        "SecondarySymbol" : "DNAJ HOMOLOGUE 3 (ATJ3); (J3); (ATJ)",
        "sstart" : 1,
        "qstart" : 275,
        "qcovhsp" : 23,
        "shared_name" : "KfCluster-31628.0",
        "ppos" : 82.56,
        "score" : 1309,
        "pident" : 70.762,
        "SUID" : 17218,
        "selected" : false,
        "sseqid" : "AT3G44110",
        "length" : 407,
        "nident" : 288,
        "evalue" : 1.36E-177,
        "positive" : 336,
        "gaps" : 10,
        "Type" : "protein_coding",
        "bitscore" : 508.0,
        "slen" : 420,
        "mismatch" : 109,
        "name" : "KfCluster-31628.0",
        "send" : 399,
        "qcovs" : 70,
        "PrimarySymbol" : "(J3)",
        "qend" : 1489
      },
      "position" : {
        "x" : 1666.1580573617355,
        "y" : -2045.568406760904
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17943",
        "degree_layout" : 2,
        "Description" : "",
        "SecondarySymbol" : "",
        "shared_name" : "SpCluster-15980.2",
        "SUID" : 17943,
        "selected" : false,
        "sseqid" : "",
        "Type" : "",
        "name" : "SpCluster-15980.2",
        "PrimarySymbol" : ""
      },
      "position" : {
        "x" : 780.6599731445312,
        "y" : -1698.74560546875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17217",
        "degree_layout" : 4,
        "Description" : "WD-40 repeat family protein / beige-like protein;(source:Araport11)",
        "SecondarySymbol" : "BEACH-DOMAIN HOMOLOG C2 (BCHC2)",
        "sstart" : 1593,
        "qstart" : 5054,
        "qcovhsp" : 28,
        "shared_name" : "PpCluster-18174.0",
        "ppos" : 62.21,
        "score" : 2882,
        "pident" : 45.77,
        "SUID" : 17217,
        "selected" : false,
        "sseqid" : "AT2G45540",
        "length" : 1442,
        "nident" : 660,
        "evalue" : 0.0,
        "positive" : 897,
        "gaps" : 109,
        "Type" : "protein_coding",
        "bitscore" : 1114.0,
        "slen" : 2946,
        "mismatch" : 673,
        "name" : "PpCluster-18174.0",
        "send" : 2944,
        "qcovs" : 84,
        "PrimarySymbol" : "BEACH-DOMAIN HOMOLOG C2 (BCHC2)",
        "qend" : 786
      },
      "position" : {
        "x" : -613.9564208984375,
        "y" : -288.0639343261719
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17216",
        "degree_layout" : 6,
        "Description" : "A nuclear encoded soluble protein found in the chloroplast stroma. Negatively regulated by light and has rapid turnover in darkness.",
        "SecondarySymbol" : "(J8);TRANSLOCON AT THE OUTER ENVELOPE MEMBRANE OF CHLOROPLASTS 12 (Toc12);DNA J PROTEIN C22 (DJC22); (AtJ8);TRANSLOCON AT THE OUTER ENVELOPE MEMBRANE OF CHLOROPLASTS 12 (AtToc12)",
        "sstart" : 54,
        "qstart" : 824,
        "qcovhsp" : 7,
        "shared_name" : "MpCluster-24485.0",
        "ppos" : 59.09,
        "score" : 205,
        "pident" : 40.0,
        "SUID" : 17216,
        "selected" : false,
        "sseqid" : "AT1G80920",
        "length" : 110,
        "nident" : 44,
        "evalue" : 1.18E-18,
        "positive" : 65,
        "gaps" : 5,
        "Type" : "protein_coding",
        "bitscore" : 83.6,
        "slen" : 163,
        "mismatch" : 61,
        "name" : "MpCluster-24485.0",
        "send" : 161,
        "qcovs" : 20,
        "PrimarySymbol" : "(J8)",
        "qend" : 504
      },
      "position" : {
        "x" : 1728.9456550179855,
        "y" : -2188.357469260904
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17215",
        "degree_layout" : 18,
        "Description" : "DnaJ-like protein with homology to coiled coils found in cytoskeleton-interacting proteins.",
        "SecondarySymbol" : "ALTERED RESPONSE TO GRAVITY 1 (ARG1)",
        "sstart" : 15,
        "qstart" : 602,
        "qcovhsp" : 12,
        "shared_name" : "KfCluster-27407.0",
        "ppos" : 76.95,
        "score" : 963,
        "pident" : 58.117,
        "SUID" : 17215,
        "selected" : false,
        "sseqid" : "AT1G68370",
        "length" : 308,
        "nident" : 179,
        "evalue" : 1.6E-122,
        "positive" : 237,
        "gaps" : 2,
        "Type" : "protein_coding",
        "bitscore" : 375.0,
        "slen" : 410,
        "mismatch" : 127,
        "name" : "KfCluster-27407.0",
        "send" : 321,
        "qcovs" : 37,
        "PrimarySymbol" : "ALTERED RESPONSE TO GRAVITY 1 (ARG1)",
        "qend" : 1522
      },
      "position" : {
        "x" : 1758.6414557992355,
        "y" : -2070.181443870279
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17214",
        "degree_layout" : 7,
        "Description" : "J domain protein localized in ER membrane. Mutants have defective pollen germination.",
        "SecondarySymbol" : "(ATERDJ2A)",
        "sstart" : 90,
        "qstart" : 1833,
        "qcovhsp" : 2,
        "shared_name" : "KfCluster-27231.0",
        "ppos" : 64.06,
        "score" : 129,
        "pident" : 40.625,
        "SUID" : 17214,
        "selected" : false,
        "sseqid" : "AT1G79940",
        "length" : 64,
        "nident" : 26,
        "evalue" : 2.64E-7,
        "positive" : 41,
        "gaps" : 3,
        "Type" : "protein_coding",
        "bitscore" : 54.3,
        "slen" : 594,
        "mismatch" : 35,
        "name" : "KfCluster-27231.0",
        "send" : 151,
        "qcovs" : 7,
        "PrimarySymbol" : "(ATERDJ2A)",
        "qend" : 2021
      },
      "position" : {
        "x" : 1801.3401862679855,
        "y" : -2142.485643089029
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17213",
        "degree_layout" : 3,
        "Description" : "Trypsin family protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 383,
        "qstart" : 1156,
        "qcovhsp" : 2,
        "shared_name" : "KfCluster-27211.0",
        "ppos" : 47.27,
        "score" : 70,
        "pident" : 38.182,
        "SUID" : 17213,
        "selected" : false,
        "sseqid" : "AT5G45030",
        "length" : 55,
        "nident" : 21,
        "evalue" : 3.9,
        "positive" : 26,
        "gaps" : 2,
        "Type" : "protein_coding",
        "bitscore" : 31.6,
        "slen" : 607,
        "mismatch" : 32,
        "name" : "KfCluster-27211.0",
        "send" : 435,
        "qcovs" : 5,
        "PrimarySymbol" : "0",
        "qend" : 992
      },
      "position" : {
        "x" : -342.45684814453125,
        "y" : -1100.4451904296875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17212",
        "degree_layout" : 1,
        "Description" : "\"Cleavage/polyadenylation specificity factor, 25kDa subunit;(source:Araport11)\"",
        "SecondarySymbol" : "0",
        "sstart" : 1,
        "qstart" : 1476,
        "qcovhsp" : 7,
        "shared_name" : "KfCluster-27067.0",
        "ppos" : 77.78,
        "score" : 532,
        "pident" : 65.972,
        "SUID" : 17212,
        "selected" : false,
        "sseqid" : "AT4G25550",
        "length" : 144,
        "nident" : 95,
        "evalue" : 1.02E-63,
        "positive" : 112,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 209.0,
        "slen" : 200,
        "mismatch" : 49,
        "name" : "KfCluster-27067.0",
        "send" : 144,
        "qcovs" : 22,
        "PrimarySymbol" : "0",
        "qend" : 1045
      },
      "position" : {
        "x" : -764.6651611328125,
        "y" : -1426.0718994140625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17936",
        "degree_layout" : 13,
        "Description" : "\"Similar to cysteine proteinases, induced by desiccation but not abscisic acid.  Required for RRS1-R mediated resistance against Ralstonia solanacearum.  Interacts with the R. solanacearum type III effector PopP2.  RD19 associates with PopP2 to form a nuclear complex that is required for activation of the RRS1-R?mediated resistance response.\"",
        "SecondarySymbol" : "RESPONSIVE TO DEHYDRATION 19 (RD19);RESPONSIVE TO DEHYDRATION 19A (RD19A)",
        "sstart" : 33,
        "qstart" : 1170,
        "qcovhsp" : 25,
        "shared_name" : "SpCluster-2096.0",
        "ppos" : 100.0,
        "score" : 1736,
        "pident" : 100.0,
        "SUID" : 17936,
        "selected" : false,
        "sseqid" : "AT4G39090",
        "length" : 319,
        "nident" : 319,
        "evalue" : 0.0,
        "positive" : 319,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 673.0,
        "slen" : 368,
        "mismatch" : 0,
        "name" : "SpCluster-2096.0",
        "send" : 351,
        "qcovs" : 74,
        "PrimarySymbol" : "RESPONSIVE TO DEHYDRATION 19 (RD19)",
        "qend" : 214
      },
      "position" : {
        "x" : 255.57131958007812,
        "y" : -1311.9510498046875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17206",
        "degree_layout" : 4,
        "Description" : "Encodes a ZRF1 chromatin regulator. Functions in regulating plant growth and development.",
        "SecondarySymbol" : "GONIDIALESS A/ZUOTIN RELATED FACTOR A1 (ATGLSA1);ZUOTIN-RELATED FACTOR 1A (ZRF1a);GONIDIALESS A/ZUOTIN RELATED FACTOR A2 (ATGLSA2)",
        "sstart" : 26,
        "qstart" : 3762,
        "qcovhsp" : 7,
        "shared_name" : "SpCluster-17792.0",
        "ppos" : 73.57,
        "score" : 747,
        "pident" : 58.929,
        "SUID" : 17206,
        "selected" : false,
        "sseqid" : "AT3G11450",
        "length" : 280,
        "nident" : 165,
        "evalue" : 2.71E-85,
        "positive" : 206,
        "gaps" : 9,
        "Type" : "protein_coding",
        "bitscore" : 292.0,
        "slen" : 647,
        "mismatch" : 106,
        "name" : "SpCluster-17792.0",
        "send" : 299,
        "qcovs" : 22,
        "PrimarySymbol" : "GONIDIALESS A/ZUOTIN RELATED FACTOR A1 (ATGLSA1)",
        "qend" : 2932
      },
      "position" : {
        "x" : 1949.0992194711105,
        "y" : -2054.434861839029
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17935",
        "degree_layout" : 9,
        "Description" : "\"Senescence-associated gene 12 (SAG12) encoding a cysteine protease influenced by cytokinin, auxin, and sugars.Localized to special vacuole found during senescence called senescence associated vacuoles which are different from central vacuole in the tonoplast composition and pH.\"",
        "SecondarySymbol" : "(ATSAG12);SENESCENCE-ASSOCIATED GENE 12 (SAG12)",
        "sstart" : 112,
        "qstart" : 2109,
        "qcovhsp" : 7,
        "shared_name" : "SpCluster-13795.0",
        "ppos" : 57.44,
        "score" : 398,
        "pident" : 41.538,
        "SUID" : 17935,
        "selected" : false,
        "sseqid" : "AT5G45890",
        "length" : 195,
        "nident" : 81,
        "evalue" : 3.76E-42,
        "positive" : 112,
        "gaps" : 10,
        "Type" : "protein_coding",
        "bitscore" : 157.0,
        "slen" : 346,
        "mismatch" : 104,
        "name" : "SpCluster-13795.0",
        "send" : 297,
        "qcovs" : 20,
        "PrimarySymbol" : "SENESCENCE-ASSOCIATED GENE 12 (SAG12)",
        "qend" : 1528
      },
      "position" : {
        "x" : 177.3338623046875,
        "y" : -1336.6380615234375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17934",
        "degree_layout" : 12,
        "Description" : "Papain family cysteine protease;(source:Araport11)",
        "SecondarySymbol" : "(ATCP2);CYSTEINE PROTEASE 2 (CP2)",
        "sstart" : 1,
        "qstart" : 1316,
        "qcovhsp" : 27,
        "shared_name" : "SpCluster-11570.0",
        "ppos" : 100.0,
        "score" : 1910,
        "pident" : 100.0,
        "SUID" : 17934,
        "selected" : false,
        "sseqid" : "AT4G11320",
        "length" : 371,
        "nident" : 371,
        "evalue" : 0.0,
        "positive" : 371,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 740.0,
        "slen" : 371,
        "mismatch" : 0,
        "name" : "SpCluster-11570.0",
        "send" : 371,
        "qcovs" : 81,
        "PrimarySymbol" : "CYSTEINE PROTEASE 2 (CP2)",
        "qend" : 204
      },
      "position" : {
        "x" : 243.818115234375,
        "y" : -1219.3890380859375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17205",
        "degree_layout" : 14,
        "Description" : "DNAJ heat shock N-terminal domain-containing protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 10,
        "qstart" : 2539,
        "qcovhsp" : 10,
        "shared_name" : "SpCluster-16060.0",
        "ppos" : 61.82,
        "score" : 429,
        "pident" : 44.595,
        "SUID" : 17205,
        "selected" : false,
        "sseqid" : "AT1G74250",
        "length" : 296,
        "nident" : 132,
        "evalue" : 5.07E-44,
        "positive" : 183,
        "gaps" : 21,
        "Type" : "protein_coding",
        "bitscore" : 169.0,
        "slen" : 630,
        "mismatch" : 143,
        "name" : "SpCluster-16060.0",
        "send" : 301,
        "qcovs" : 31,
        "PrimarySymbol" : "0",
        "qend" : 1703
      },
      "position" : {
        "x" : 1829.0496589242355,
        "y" : -2023.9659897687166
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17204",
        "degree_layout" : 4,
        "Description" : "Encodes a ZRF1 chromatin regulator. Functions in regulating plant growth and development.",
        "SecondarySymbol" : "GONIDIALESS A/ZUOTIN RELATED FACTOR A1 (ATGLSA1);ZUOTIN-RELATED FACTOR 1B (ZRF1b);GONIDIALESS A/ZUOTIN RELATED FACTOR A2 (ATGLSA2)",
        "sstart" : 8,
        "qstart" : 2419,
        "qcovhsp" : 11,
        "shared_name" : "KfCluster-26840.0",
        "ppos" : 70.03,
        "score" : 682,
        "pident" : 52.189,
        "SUID" : 17204,
        "selected" : false,
        "sseqid" : "AT5G06110",
        "length" : 297,
        "nident" : 155,
        "evalue" : 3.53E-78,
        "positive" : 208,
        "gaps" : 4,
        "Type" : "protein_coding",
        "bitscore" : 267.0,
        "slen" : 663,
        "mismatch" : 138,
        "name" : "KfCluster-26840.0",
        "send" : 300,
        "qcovs" : 34,
        "PrimarySymbol" : "GONIDIALESS A/ZUOTIN RELATED FACTOR A2 (ATGLSA2)",
        "qend" : 1529
      },
      "position" : {
        "x" : 1933.7515632211105,
        "y" : -1959.9049546124666
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17930",
        "degree_layout" : 2,
        "Description" : "\"Encodes PSL4, beta-subunit of endoplasmic reticulum-resident glucosidase II, which is essential for stable accumulation and quality control of the elf18 receptor EFR but not the flg22 receptor FLS2. The mRNA is cell-to-cell mobile.\"",
        "SecondarySymbol" : "PRIORITY IN SWEET LIFE 4 (PSL4)",
        "sstart" : 481,
        "qstart" : 358,
        "qcovhsp" : 11,
        "shared_name" : "SpCluster-3129.0",
        "ppos" : 61.43,
        "score" : 311,
        "pident" : 43.571,
        "SUID" : 17930,
        "selected" : false,
        "sseqid" : "AT5G56360",
        "length" : 140,
        "nident" : 61,
        "evalue" : 1.04E-30,
        "positive" : 86,
        "gaps" : 7,
        "Type" : "protein_coding",
        "bitscore" : 124.0,
        "slen" : 647,
        "mismatch" : 72,
        "name" : "SpCluster-3129.0",
        "send" : 620,
        "qcovs" : 32,
        "PrimarySymbol" : "PRIORITY IN SWEET LIFE 4 (PSL4)",
        "qend" : 756
      },
      "position" : {
        "x" : 825.9921264648438,
        "y" : -1098.544189453125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17203",
        "degree_layout" : 1,
        "Description" : "ketol-acid reductoisomerase;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 420,
        "qstart" : 2,
        "qcovhsp" : 16,
        "shared_name" : "KfCluster-26563.0",
        "ppos" : 78.7,
        "score" : 625,
        "pident" : 69.822,
        "SUID" : 17203,
        "selected" : false,
        "sseqid" : "AT3G58610",
        "length" : 169,
        "nident" : 118,
        "evalue" : 2.95E-76,
        "positive" : 133,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 245.0,
        "slen" : 591,
        "mismatch" : 51,
        "name" : "KfCluster-26563.0",
        "send" : 588,
        "qcovs" : 49,
        "PrimarySymbol" : "0",
        "qend" : 508
      },
      "position" : {
        "x" : 1590.516822010173,
        "y" : -1999.852342307779
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17929",
        "degree_layout" : 3,
        "Description" : "\"Encodes PSL4, beta-subunit of endoplasmic reticulum-resident glucosidase II, which is essential for stable accumulation and quality control of the elf18 receptor EFR but not the flg22 receptor FLS2. The mRNA is cell-to-cell mobile.\"",
        "SecondarySymbol" : "PRIORITY IN SWEET LIFE 4 (PSL4)",
        "sstart" : 28,
        "qstart" : 1359,
        "qcovhsp" : 10,
        "shared_name" : "SpCluster-2514.0",
        "ppos" : 65.38,
        "score" : 398,
        "pident" : 49.359,
        "SUID" : 17929,
        "selected" : false,
        "sseqid" : "AT5G56360",
        "length" : 156,
        "nident" : 77,
        "evalue" : 1.23E-41,
        "positive" : 102,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 157.0,
        "slen" : 647,
        "mismatch" : 79,
        "name" : "SpCluster-2514.0",
        "send" : 183,
        "qcovs" : 31,
        "PrimarySymbol" : "PRIORITY IN SWEET LIFE 4 (PSL4)",
        "qend" : 892
      },
      "position" : {
        "x" : 894.2883911132812,
        "y" : -1064.159423828125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17928",
        "degree_layout" : 1,
        "Description" : "",
        "SecondarySymbol" : "",
        "shared_name" : "SpCluster-6778.0",
        "SUID" : 17928,
        "selected" : false,
        "sseqid" : "",
        "Type" : "",
        "name" : "SpCluster-6778.0",
        "PrimarySymbol" : ""
      },
      "position" : {
        "x" : 411.8675231933594,
        "y" : -1634.9915771484375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17927",
        "degree_layout" : 1,
        "Description" : "Root hair defective 3 GTP-binding protein (RHD3);(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 694,
        "qstart" : 308,
        "qcovhsp" : 3,
        "shared_name" : "SpCluster-6002.0",
        "ppos" : 61.11,
        "score" : 70,
        "pident" : 36.111,
        "SUID" : 17927,
        "selected" : false,
        "sseqid" : "AT1G72960",
        "length" : 36,
        "nident" : 13,
        "evalue" : 1.6,
        "positive" : 22,
        "gaps" : 1,
        "Type" : "protein_coding",
        "bitscore" : 31.6,
        "slen" : 795,
        "mismatch" : 22,
        "name" : "SpCluster-6002.0",
        "send" : 728,
        "qcovs" : 8,
        "PrimarySymbol" : "0",
        "qend" : 415
      },
      "position" : {
        "x" : 537.5443115234375,
        "y" : -1724.5733642578125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17926",
        "degree_layout" : 3,
        "Description" : "",
        "SecondarySymbol" : "",
        "shared_name" : "SpCluster-4220.9",
        "SUID" : 17926,
        "selected" : false,
        "sseqid" : "",
        "Type" : "",
        "name" : "SpCluster-4220.9",
        "PrimarySymbol" : ""
      },
      "position" : {
        "x" : 260.35260009765625,
        "y" : -1736.428955078125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17202",
        "Description" : "Ribosomal protein S8e family protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 1,
        "qstart" : 802,
        "qcovhsp" : 25,
        "shared_name" : "SpCluster-13342.3",
        "ppos" : 100.0,
        "score" : 889,
        "pident" : 100.0,
        "SUID" : 17202,
        "selected" : false,
        "sseqid" : "AT5G20290",
        "length" : 210,
        "nident" : 210,
        "evalue" : 1.02E-121,
        "positive" : 210,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 347.0,
        "slen" : 222,
        "mismatch" : 0,
        "name" : "SpCluster-13342.3",
        "send" : 210,
        "qcovs" : 75,
        "PrimarySymbol" : "0",
        "qend" : 173
      },
      "position" : {
        "x" : -2148.080418953795,
        "y" : -113.36572016229107
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17201",
        "Description" : "Ribosomal protein S8e family protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 14,
        "qstart" : 351,
        "qcovhsp" : 14,
        "shared_name" : "KfCluster-26517.2",
        "ppos" : 94.0,
        "score" : 163,
        "pident" : 82.0,
        "SUID" : 17201,
        "selected" : false,
        "sseqid" : "AT5G59240",
        "length" : 50,
        "nident" : 41,
        "evalue" : 7.95E-15,
        "positive" : 47,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 67.4,
        "slen" : 210,
        "mismatch" : 9,
        "name" : "KfCluster-26517.2",
        "send" : 63,
        "qcovs" : 42,
        "PrimarySymbol" : "0",
        "qend" : 202
      },
      "position" : {
        "x" : -2049.86533106317,
        "y" : -74.42289484490826
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17925",
        "degree_layout" : 4,
        "Description" : "",
        "SecondarySymbol" : "",
        "shared_name" : "SpCluster-3030.0",
        "SUID" : 17925,
        "selected" : false,
        "sseqid" : "",
        "Type" : "",
        "name" : "SpCluster-3030.0",
        "PrimarySymbol" : ""
      },
      "position" : {
        "x" : 672.3951416015625,
        "y" : -1315.1961669921875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17924",
        "degree_layout" : 2,
        "Description" : "",
        "SecondarySymbol" : "",
        "shared_name" : "SpCluster-2261.0",
        "SUID" : 17924,
        "selected" : false,
        "sseqid" : "",
        "Type" : "",
        "name" : "SpCluster-2261.0",
        "PrimarySymbol" : ""
      },
      "position" : {
        "x" : 471.6483154296875,
        "y" : -1732.3428955078125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17923",
        "degree_layout" : 3,
        "Description" : "",
        "SecondarySymbol" : "",
        "shared_name" : "SpCluster-19416.1",
        "SUID" : 17923,
        "selected" : false,
        "sseqid" : "",
        "Type" : "",
        "name" : "SpCluster-19416.1",
        "PrimarySymbol" : ""
      },
      "position" : {
        "x" : 724.371337890625,
        "y" : -1272.328125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17922",
        "degree_layout" : 1,
        "Description" : "DNA-directed RNA polymerase;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 4,
        "qstart" : 2008,
        "qcovhsp" : 4,
        "shared_name" : "SpCluster-19337.0",
        "ppos" : 61.18,
        "score" : 153,
        "pident" : 38.824,
        "SUID" : 17922,
        "selected" : false,
        "sseqid" : "AT1G75670",
        "length" : 85,
        "nident" : 33,
        "evalue" : 2.47E-11,
        "positive" : 52,
        "gaps" : 1,
        "Type" : "protein_coding",
        "bitscore" : 63.5,
        "slen" : 196,
        "mismatch" : 51,
        "name" : "SpCluster-19337.0",
        "send" : 87,
        "qcovs" : 12,
        "PrimarySymbol" : "0",
        "qend" : 1754
      },
      "position" : {
        "x" : 503.63946533203125,
        "y" : -1727.2247314453125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17200",
        "degree_layout" : 3,
        "Description" : "Encodes a protein with xylanase activity.",
        "SecondarySymbol" : "ARABIDOPSIS THALIANA XYLANASE 1 (ATXYN1); (RXF12)",
        "sstart" : 448,
        "qstart" : 853,
        "qcovhsp" : 15,
        "shared_name" : "KfCluster-30581.0",
        "ppos" : 52.95,
        "score" : 632,
        "pident" : 31.947,
        "SUID" : 17200,
        "selected" : false,
        "sseqid" : "AT1G58370",
        "length" : 457,
        "nident" : 146,
        "evalue" : 1.04E-68,
        "positive" : 242,
        "gaps" : 19,
        "Type" : "protein_coding",
        "bitscore" : 248.0,
        "slen" : 917,
        "mismatch" : 292,
        "name" : "KfCluster-30581.0",
        "send" : 887,
        "qcovs" : 45,
        "PrimarySymbol" : "(RXF12)",
        "qend" : 2217
      },
      "position" : {
        "x" : 76.08234405517578,
        "y" : -908.9983520507812
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17199",
        "degree_layout" : 2,
        "Description" : "Glycosyl hydrolase family 10 protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 71,
        "qstart" : 755,
        "qcovhsp" : 16,
        "shared_name" : "KfCluster-2624.0",
        "ppos" : 46.39,
        "score" : 458,
        "pident" : 26.121,
        "SUID" : 17199,
        "selected" : false,
        "sseqid" : "AT4G38650",
        "length" : 513,
        "nident" : 134,
        "evalue" : 5.32E-48,
        "positive" : 238,
        "gaps" : 39,
        "Type" : "protein_coding",
        "bitscore" : 181.0,
        "slen" : 562,
        "mismatch" : 340,
        "name" : "KfCluster-2624.0",
        "send" : 557,
        "qcovs" : 49,
        "PrimarySymbol" : "0",
        "qend" : 2254
      },
      "position" : {
        "x" : 177.00332641601562,
        "y" : -802.9158935546875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17921",
        "degree_layout" : 1,
        "Description" : "Encodes a member of the NIMA-related serine/threonine kinases (Neks) that have been linked to cell-cycle regulation in fungi and mammals.  Plant Neks might be involved in plant development processes.",
        "SecondarySymbol" : "NIMA-RELATED KINASE 5 (ATNEK5);NIMA-RELATED KINASE 5 (NEK5)",
        "sstart" : 136,
        "qstart" : 2807,
        "qcovhsp" : 3,
        "shared_name" : "SpCluster-15376.0",
        "ppos" : 38.84,
        "score" : 70,
        "pident" : 28.099,
        "SUID" : 17921,
        "selected" : false,
        "sseqid" : "AT3G20860",
        "length" : 121,
        "nident" : 34,
        "evalue" : 4.1,
        "positive" : 47,
        "gaps" : 40,
        "Type" : "protein_coding",
        "bitscore" : 31.6,
        "slen" : 427,
        "mismatch" : 47,
        "name" : "SpCluster-15376.0",
        "send" : 234,
        "qcovs" : 9,
        "PrimarySymbol" : "NIMA-RELATED KINASE 5 (NEK5)",
        "qend" : 2499
      },
      "position" : {
        "x" : 440.17962646484375,
        "y" : -1701.751708984375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17198",
        "degree_layout" : 7,
        "Description" : "oxidoreductase/transition metal ion-binding protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 231,
        "qstart" : 2040,
        "qcovhsp" : 6,
        "shared_name" : "SpCluster-5847.0",
        "ppos" : 73.09,
        "score" : 607,
        "pident" : 50.673,
        "SUID" : 17198,
        "selected" : false,
        "sseqid" : "AT5G52410",
        "length" : 223,
        "nident" : 113,
        "evalue" : 1.37E-65,
        "positive" : 163,
        "gaps" : 8,
        "Type" : "protein_coding",
        "bitscore" : 238.0,
        "slen" : 761,
        "mismatch" : 102,
        "name" : "SpCluster-5847.0",
        "send" : 447,
        "qcovs" : 17,
        "PrimarySymbol" : "0",
        "qend" : 1378
      },
      "position" : {
        "x" : 404.9607849121094,
        "y" : -1395.9586181640625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17197",
        "degree_layout" : 3,
        "Description" : "GPI-anchored adhesin-like protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 449,
        "qstart" : 2450,
        "qcovhsp" : 4,
        "shared_name" : "KfCluster-26237.0",
        "ppos" : 69.12,
        "score" : 343,
        "pident" : 48.039,
        "SUID" : 17197,
        "selected" : false,
        "sseqid" : "AT5G23890",
        "length" : 204,
        "nident" : 98,
        "evalue" : 3.74E-32,
        "positive" : 141,
        "gaps" : 8,
        "Type" : "protein_coding",
        "bitscore" : 136.0,
        "slen" : 946,
        "mismatch" : 98,
        "name" : "KfCluster-26237.0",
        "send" : 650,
        "qcovs" : 12,
        "PrimarySymbol" : "0",
        "qend" : 3043
      },
      "position" : {
        "x" : 420.80865478515625,
        "y" : -1278.785888671875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17920",
        "degree_layout" : 2,
        "Description" : "mediator of RNA polymerase II transcription subunit 19a-like protein;(source:Araport11)",
        "SecondarySymbol" : "(MED19A)",
        "sstart" : 12,
        "qstart" : 98,
        "qcovhsp" : 11,
        "shared_name" : "SpCluster-13822.0",
        "ppos" : 56.6,
        "score" : 158,
        "pident" : 32.075,
        "SUID" : 17920,
        "selected" : false,
        "sseqid" : "AT5G12230",
        "length" : 106,
        "nident" : 34,
        "evalue" : 2.8E-12,
        "positive" : 60,
        "gaps" : 3,
        "Type" : "protein_coding",
        "bitscore" : 65.5,
        "slen" : 221,
        "mismatch" : 69,
        "name" : "SpCluster-13822.0",
        "send" : 114,
        "qcovs" : 32,
        "PrimarySymbol" : "(MED19A)",
        "qend" : 415
      },
      "position" : {
        "x" : 565.3964233398438,
        "y" : -1240.8765869140625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17194",
        "degree_layout" : 2,
        "Description" : "Encodes a LAM domain containing protein that is involved in leaf senescence.",
        "SecondarySymbol" : "(ATLARP1B);LA RELATED PROTEIN 1B (LARP1B)",
        "sstart" : 289,
        "qstart" : 1782,
        "qcovhsp" : 3,
        "shared_name" : "SpCluster-9941.0",
        "ppos" : 58.02,
        "score" : 194,
        "pident" : 38.931,
        "SUID" : 17194,
        "selected" : false,
        "sseqid" : "AT5G66100",
        "length" : 131,
        "nident" : 51,
        "evalue" : 4.85E-15,
        "positive" : 76,
        "gaps" : 18,
        "Type" : "protein_coding",
        "bitscore" : 79.3,
        "slen" : 453,
        "mismatch" : 62,
        "name" : "SpCluster-9941.0",
        "send" : 418,
        "qcovs" : 9,
        "PrimarySymbol" : "LA RELATED PROTEIN 1B (LARP1B)",
        "qend" : 2123
      },
      "position" : {
        "x" : -181.76296997070312,
        "y" : -1063.53125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17919",
        "degree_layout" : 6,
        "Description" : "\"Encodes PSL4, beta-subunit of endoplasmic reticulum-resident glucosidase II, which is essential for stable accumulation and quality control of the elf18 receptor EFR but not the flg22 receptor FLS2. The mRNA is cell-to-cell mobile.\"",
        "SecondarySymbol" : "PRIORITY IN SWEET LIFE 4 (PSL4)",
        "sstart" : 39,
        "qstart" : 2152,
        "qcovhsp" : 5,
        "shared_name" : "SpCluster-11412.0",
        "ppos" : 72.58,
        "score" : 396,
        "pident" : 54.839,
        "SUID" : 17919,
        "selected" : false,
        "sseqid" : "AT5G56360",
        "length" : 124,
        "nident" : 68,
        "evalue" : 5.94E-40,
        "positive" : 90,
        "gaps" : 1,
        "Type" : "protein_coding",
        "bitscore" : 157.0,
        "slen" : 647,
        "mismatch" : 55,
        "name" : "SpCluster-11412.0",
        "send" : 162,
        "qcovs" : 16,
        "PrimarySymbol" : "PRIORITY IN SWEET LIFE 4 (PSL4)",
        "qend" : 1784
      },
      "position" : {
        "x" : 747.4568481445312,
        "y" : -1204.5458984375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17918",
        "degree_layout" : 1,
        "Description" : "",
        "SecondarySymbol" : "",
        "shared_name" : "SpCluster-11291.0",
        "SUID" : 17918,
        "selected" : false,
        "sseqid" : "",
        "Type" : "",
        "name" : "SpCluster-11291.0",
        "PrimarySymbol" : ""
      },
      "position" : {
        "x" : 560.4522094726562,
        "y" : -1786.2808837890625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17917",
        "degree_layout" : 4,
        "Description" : "\"The PBP1(PYK10-binding protein 1) assists the PYK10 (beta-glucosidase complex) in its activity and may act like a molecular  chaperone that facilitates the correct polymerization of PYK10, when tissues are damaged and subcellular structures are destroyed by pests. The mRNA is cell-to-cell mobile.\"",
        "SecondarySymbol" : "PYK10-BINDING PROTEIN 1 (PBP1);JACALIN-RELATED LECTIN 30 (JAL30); (PBPI)",
        "sstart" : 1,
        "qstart" : 45,
        "qcovhsp" : 27,
        "shared_name" : "SpCluster-11368.1",
        "ppos" : 100.0,
        "score" : 1352,
        "pident" : 100.0,
        "SUID" : 17917,
        "selected" : false,
        "sseqid" : "AT3G16420",
        "length" : 295,
        "nident" : 295,
        "evalue" : 0.0,
        "positive" : 295,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 525.0,
        "slen" : 298,
        "mismatch" : 0,
        "name" : "SpCluster-11368.1",
        "send" : 295,
        "qcovs" : 81,
        "PrimarySymbol" : "PYK10-BINDING PROTEIN 1 (PBP1)",
        "qend" : 929
      },
      "position" : {
        "x" : -905.2623291015625,
        "y" : -1944.06884765625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17193",
        "degree_layout" : 6,
        "Description" : "",
        "SecondarySymbol" : "",
        "shared_name" : "SpCluster-11001.1",
        "SUID" : 17193,
        "selected" : false,
        "sseqid" : "",
        "Type" : "",
        "name" : "SpCluster-11001.1",
        "PrimarySymbol" : ""
      },
      "position" : {
        "x" : 208.77139282226562,
        "y" : -1512.8834228515625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17192",
        "degree_layout" : 7,
        "Description" : "Heat shock protein 70 (Hsp 70) family protein;(source:Araport11)",
        "SecondarySymbol" : "BINDING PROTEIN 3 (BIP3)",
        "sstart" : 312,
        "qstart" : 1475,
        "qcovhsp" : 5,
        "shared_name" : "SpCluster-11001.0",
        "ppos" : 51.9,
        "score" : 77,
        "pident" : 27.848,
        "SUID" : 17192,
        "selected" : false,
        "sseqid" : "AT1G09080",
        "length" : 79,
        "nident" : 22,
        "evalue" : 0.26,
        "positive" : 41,
        "gaps" : 5,
        "Type" : "protein_coding",
        "bitscore" : 34.3,
        "slen" : 675,
        "mismatch" : 52,
        "name" : "SpCluster-11001.0",
        "send" : 385,
        "qcovs" : 14,
        "PrimarySymbol" : "BINDING PROTEIN 3 (BIP3)",
        "qend" : 1239
      },
      "position" : {
        "x" : 112.61398315429688,
        "y" : -1495.619140625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17191",
        "degree_layout" : 10,
        "Description" : "phospholipase-like protein (PEARLI 4) with TRAF-like domain protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 150,
        "qstart" : 289,
        "qcovhsp" : 6,
        "shared_name" : "KfCluster-25483.1",
        "ppos" : 50.75,
        "score" : 64,
        "pident" : 32.836,
        "SUID" : 17191,
        "selected" : false,
        "sseqid" : "AT3G58270",
        "length" : 67,
        "nident" : 22,
        "evalue" : 5.5,
        "positive" : 34,
        "gaps" : 4,
        "Type" : "protein_coding",
        "bitscore" : 29.3,
        "slen" : 343,
        "mismatch" : 41,
        "name" : "KfCluster-25483.1",
        "send" : 212,
        "qcovs" : 17,
        "PrimarySymbol" : "0",
        "qend" : 89
      },
      "position" : {
        "x" : -115.14195251464844,
        "y" : -1378.748779296875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17190",
        "Description" : "\"interacts with H+-ATPase, and regulates its activity The mRNA is cell-to-cell mobile.\"",
        "SecondarySymbol" : "PROTON PUMP INTERACTOR 1 (PPI1)",
        "sstart" : 180,
        "qstart" : 120,
        "qcovhsp" : 5,
        "shared_name" : "SpCluster-4534.0",
        "ppos" : 71.88,
        "score" : 66,
        "pident" : 34.375,
        "SUID" : 17190,
        "selected" : false,
        "sseqid" : "AT4G27500",
        "length" : 32,
        "nident" : 11,
        "evalue" : 1.4,
        "positive" : 23,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 30.0,
        "slen" : 612,
        "mismatch" : 21,
        "name" : "SpCluster-4534.0",
        "send" : 211,
        "qcovs" : 15,
        "PrimarySymbol" : "PROTON PUMP INTERACTOR 1 (PPI1)",
        "qend" : 25
      },
      "position" : {
        "x" : 976.1192818253483,
        "y" : -3606.758544921875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17914",
        "degree_layout" : 4,
        "Description" : "\"Similar to terminal ear1 in Zea mays. A member of mei2-like gene family; phylogenetic analysis revealed that TEL1 belongs to the third clade of mei2-like proteins (TEL clade), with conserved two N-terminal RNA recognition motifs (RRM), in addition to the C-terminal RRM, shared among all mei2-like proteins.\"",
        "SecondarySymbol" : "TERMINAL EAR1-LIKE 1 (TEL1)",
        "sstart" : 389,
        "qstart" : 1311,
        "qcovhsp" : 4,
        "shared_name" : "SpCluster-2042.10",
        "ppos" : 60.87,
        "score" : 477,
        "pident" : 46.86,
        "SUID" : 17914,
        "selected" : false,
        "sseqid" : "AT3G26120",
        "length" : 207,
        "nident" : 97,
        "evalue" : 1.01E-49,
        "positive" : 126,
        "gaps" : 17,
        "Type" : "protein_coding",
        "bitscore" : 188.0,
        "slen" : 615,
        "mismatch" : 93,
        "name" : "SpCluster-2042.10",
        "send" : 587,
        "qcovs" : 12,
        "PrimarySymbol" : "TERMINAL EAR1-LIKE 1 (TEL1)",
        "qend" : 718
      },
      "position" : {
        "x" : 39.20759582519531,
        "y" : -1556.3057861328125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17189",
        "Description" : "\"interacts with H+-ATPase, and regulates its activity The mRNA is cell-to-cell mobile.\"",
        "SecondarySymbol" : "PROTON PUMP INTERACTOR 1 (PPI1)",
        "sstart" : 117,
        "qstart" : 459,
        "qcovhsp" : 11,
        "shared_name" : "SpCluster-13440.0",
        "ppos" : 52.77,
        "score" : 265,
        "pident" : 30.258,
        "SUID" : 17189,
        "selected" : false,
        "sseqid" : "AT4G27500",
        "length" : 271,
        "nident" : 82,
        "evalue" : 1.38E-23,
        "positive" : 143,
        "gaps" : 15,
        "Type" : "protein_coding",
        "bitscore" : 106.0,
        "slen" : 612,
        "mismatch" : 174,
        "name" : "SpCluster-13440.0",
        "send" : 375,
        "qcovs" : 32,
        "PrimarySymbol" : "PROTON PUMP INTERACTOR 1 (PPI1)",
        "qend" : 1262
      },
      "position" : {
        "x" : 992.0954781144108,
        "y" : -3510.798095703125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17188",
        "Description" : "calponin-like domain protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 809,
        "qstart" : 2493,
        "qcovhsp" : 3,
        "shared_name" : "KfCluster-25251.0",
        "ppos" : 52.68,
        "score" : 94,
        "pident" : 27.679,
        "SUID" : 17188,
        "selected" : false,
        "sseqid" : "AT1G20970",
        "length" : 112,
        "nident" : 31,
        "evalue" : 0.007,
        "positive" : 59,
        "gaps" : 11,
        "Type" : "protein_coding",
        "bitscore" : 40.8,
        "slen" : 1364,
        "mismatch" : 70,
        "name" : "KfCluster-25251.0",
        "send" : 913,
        "qcovs" : 10,
        "PrimarySymbol" : "0",
        "qend" : 2170
      },
      "position" : {
        "x" : 1078.5112495987858,
        "y" : -3556.557861328125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17187",
        "degree_layout" : 3,
        "Description" : "\"Enodes a subunit of chloroplast RNA polymerase, confers the ability to recognize promoter sequences on the core enzyme. SIG1 is induced by red and blue light.\"",
        "SecondarySymbol" : "SIGMA FACTOR B (SIGB);RNA POLYMERASE SIGMA SUBUNIT 1 (SIG1);RNAPOLYMERASE SIGMA SUBUNIT 2 (SIG2);SIGMA FACTOR 2 (ATSIG2);SIGMA FACTOR 1 (ATSIG1); (ABC1); (SIGA)",
        "sstart" : 252,
        "qstart" : 53,
        "qcovhsp" : 22,
        "shared_name" : "KfCluster-33071.0",
        "ppos" : 61.06,
        "score" : 586,
        "pident" : 38.318,
        "SUID" : 17187,
        "selected" : false,
        "sseqid" : "AT1G08540",
        "length" : 321,
        "nident" : 123,
        "evalue" : 8.02E-69,
        "positive" : 196,
        "gaps" : 6,
        "Type" : "protein_coding",
        "bitscore" : 230.0,
        "slen" : 572,
        "mismatch" : 192,
        "name" : "KfCluster-33071.0",
        "send" : 568,
        "qcovs" : 66,
        "PrimarySymbol" : "RNAPOLYMERASE SIGMA SUBUNIT 2 (SIG2)",
        "qend" : 1009
      },
      "position" : {
        "x" : -22.13821792602539,
        "y" : -746.8939819335938
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17186",
        "degree_layout" : 1,
        "Description" : "\"Encodes one of the closely related 12-oxophytodienoic acid reductases. This enzyme is not expected to participate in jasmonic acid biosynthesis because during in vitro assays, it shows very little activity with the naturally occurring OPDA isomer. Shows activity towards 2,4,6-trinitrotoluene.  Expressed predominately in root. Predicted to be a cytosolic protein.\"",
        "SecondarySymbol" : "12-OXOPHYTODIENOATE REDUCTASE 2 (OPR2);ARABIDOPSIS 12-OXOPHYTODIENOATE REDUCTASE 2 (ATOPR2)",
        "sstart" : 13,
        "qstart" : 1424,
        "qcovhsp" : 19,
        "shared_name" : "KfCluster-25092.0",
        "ppos" : 65.56,
        "score" : 943,
        "pident" : 49.036,
        "SUID" : 17186,
        "selected" : false,
        "sseqid" : "AT1G76690",
        "length" : 363,
        "nident" : 178,
        "evalue" : 1.41E-122,
        "positive" : 238,
        "gaps" : 3,
        "Type" : "protein_coding",
        "bitscore" : 367.0,
        "slen" : 374,
        "mismatch" : 182,
        "name" : "KfCluster-25092.0",
        "send" : 373,
        "qcovs" : 58,
        "PrimarySymbol" : "12-OXOPHYTODIENOATE REDUCTASE 2 (OPR2)",
        "qend" : 339
      },
      "position" : {
        "x" : -83.6946792602539,
        "y" : -620.5032958984375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17913",
        "degree_layout" : 1,
        "Description" : "\"Encodes a yeast CTR9 homolog that is involved in the control of flowering time by elevating FLC expression to a level that creates the vernalization-responsive, winter-annual habit.  Yeast CTR9 is a component of a five-member PAF1 complex that associates with RNA pol II and is thought to regulate gene expression by recruiting SET1 (a histone 3 Lys 4 [H3-K4] methyl transferase) to the initially transcribed [5'] regions of target chromatin.  Mutants display reduced H3-K4 methylation in both FLC and FLM chromatin.\"",
        "SecondarySymbol" : "VERNALIZATION INDEPENDENCE 6 (VIP6);EARLY FLOWERING 8 (ELF8)",
        "sstart" : 554,
        "qstart" : 397,
        "qcovhsp" : 15,
        "shared_name" : "SpCluster-16602.0",
        "ppos" : 69.49,
        "score" : 769,
        "pident" : 48.64,
        "SUID" : 17913,
        "selected" : false,
        "sseqid" : "AT2G06210",
        "length" : 331,
        "nident" : 161,
        "evalue" : 1.52E-88,
        "positive" : 230,
        "gaps" : 2,
        "Type" : "protein_coding",
        "bitscore" : 300.0,
        "slen" : 1091,
        "mismatch" : 168,
        "name" : "SpCluster-16602.0",
        "send" : 884,
        "qcovs" : 45,
        "PrimarySymbol" : "EARLY FLOWERING 8 (ELF8)",
        "qend" : 1383
      },
      "position" : {
        "x" : 906.77587890625,
        "y" : -1569.4564208984375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17912",
        "degree_layout" : 4,
        "Description" : "member of SLY1 Gene Family The mRNA is cell-to-cell mobile.",
        "SecondarySymbol" : "(ATSLY1)",
        "sstart" : 420,
        "qstart" : 399,
        "qcovhsp" : 8,
        "shared_name" : "SpCluster-11001.2",
        "ppos" : 67.65,
        "score" : 66,
        "pident" : 47.059,
        "SUID" : 17912,
        "selected" : false,
        "sseqid" : "AT2G17980",
        "length" : 34,
        "nident" : 16,
        "evalue" : 0.52,
        "positive" : 23,
        "gaps" : 1,
        "Type" : "protein_coding",
        "bitscore" : 30.0,
        "slen" : 627,
        "mismatch" : 17,
        "name" : "SpCluster-11001.2",
        "send" : 453,
        "qcovs" : 24,
        "PrimarySymbol" : "(ATSLY1)",
        "qend" : 301
      },
      "position" : {
        "x" : 167.9183807373047,
        "y" : -1605.7315673828125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17183",
        "degree_layout" : 3,
        "Description" : "hydroxyproline-rich glycoprotein family protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 383,
        "qstart" : 683,
        "qcovhsp" : 4,
        "shared_name" : "SpCluster-13621.0",
        "ppos" : 61.65,
        "score" : 273,
        "pident" : 38.346,
        "SUID" : 17183,
        "selected" : false,
        "sseqid" : "AT1G53645",
        "length" : 133,
        "nident" : 51,
        "evalue" : 1.04E-24,
        "positive" : 82,
        "gaps" : 1,
        "Type" : "protein_coding",
        "bitscore" : 109.0,
        "slen" : 523,
        "mismatch" : 81,
        "name" : "SpCluster-13621.0",
        "send" : 515,
        "qcovs" : 13,
        "PrimarySymbol" : "0",
        "qend" : 288
      },
      "position" : {
        "x" : -500.1429443359375,
        "y" : -2074.5546875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17909",
        "degree_layout" : 11,
        "Description" : "glycosyl hydrolase 9C3;(source:Araport11)",
        "SecondarySymbol" : "GLYCOSYL HYDROLASE 9C3 (GH9C3);GLYCOSYL HYDROLASE 9C3 (AtGH9C3)",
        "sstart" : 26,
        "qstart" : 162,
        "qcovhsp" : 21,
        "shared_name" : "SpCluster-12666.0",
        "ppos" : 61.63,
        "score" : 1107,
        "pident" : 46.318,
        "SUID" : 17909,
        "selected" : false,
        "sseqid" : "AT4G11050",
        "length" : 516,
        "nident" : 239,
        "evalue" : 2.22E-141,
        "positive" : 318,
        "gaps" : 54,
        "Type" : "protein_coding",
        "bitscore" : 431.0,
        "slen" : 626,
        "mismatch" : 223,
        "name" : "SpCluster-12666.0",
        "send" : 489,
        "qcovs" : 64,
        "PrimarySymbol" : "GLYCOSYL HYDROLASE 9C3 (GH9C3)",
        "qend" : 1703
      },
      "position" : {
        "x" : 97.57144165039062,
        "y" : -1331.912841796875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17180",
        "degree_layout" : 2,
        "Description" : "plastid transcriptionally active 3;(source:Araport11)",
        "SecondarySymbol" : "PLASTID TRANSCRIPTIONALLY ACTIVE 3 (PTAC3);PIGMENT DEFECTIVE 324 (PDE324)",
        "sstart" : 68,
        "qstart" : 1026,
        "qcovhsp" : 3,
        "shared_name" : "KfCluster-24824.0",
        "ppos" : 56.74,
        "score" : 261,
        "pident" : 39.007,
        "SUID" : 17180,
        "selected" : false,
        "sseqid" : "AT3G04260",
        "length" : 141,
        "nident" : 55,
        "evalue" : 1.7E-22,
        "positive" : 80,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 105.0,
        "slen" : 910,
        "mismatch" : 86,
        "name" : "KfCluster-24824.0",
        "send" : 208,
        "qcovs" : 10,
        "PrimarySymbol" : "PLASTID TRANSCRIPTIONALLY ACTIVE 3 (PTAC3)",
        "qend" : 1448
      },
      "position" : {
        "x" : -74.72219848632812,
        "y" : -1752.482666015625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17908",
        "degree_layout" : 6,
        "Description" : "glycosyl hydrolase 9C1;(source:Araport11)",
        "SecondarySymbol" : "GLYCOSYL HYDROLASE 9C1 (GH9C1);GLYCOSYL HYDROLASE 9C1 (AtGH9C1)",
        "sstart" : 532,
        "qstart" : 119,
        "qcovhsp" : 17,
        "shared_name" : "SpCluster-10824.3",
        "ppos" : 42.27,
        "score" : 76,
        "pident" : 25.773,
        "SUID" : 17908,
        "selected" : false,
        "sseqid" : "AT1G48930",
        "length" : 97,
        "nident" : 25,
        "evalue" : 0.067,
        "positive" : 41,
        "gaps" : 2,
        "Type" : "protein_coding",
        "bitscore" : 33.9,
        "slen" : 627,
        "mismatch" : 70,
        "name" : "SpCluster-10824.3",
        "send" : 627,
        "qcovs" : 50,
        "PrimarySymbol" : "GLYCOSYL HYDROLASE 9C1 (GH9C1)",
        "qend" : 406
      },
      "position" : {
        "x" : 103.96499633789062,
        "y" : -1403.23095703125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17907",
        "degree_layout" : 2,
        "Description" : "\"Belongs to a subgroup of SGS3-like proteins that act redundantly in RNA-directed DNA methylation: AT1G15910 (FDM1), AT4G00380 (FDM2), AT3G12550 (FDM3), AT1G13790 (FDM4), AT1G80790 (FDM5).\"",
        "SecondarySymbol" : "FACTOR OF DNA METHYLATION 4 (FDM4)",
        "sstart" : 362,
        "qstart" : 515,
        "qcovhsp" : 13,
        "shared_name" : "SpCluster-9928.42",
        "ppos" : 51.22,
        "score" : 69,
        "pident" : 32.927,
        "SUID" : 17907,
        "selected" : false,
        "sseqid" : "AT1G13790",
        "length" : 82,
        "nident" : 27,
        "evalue" : 0.51,
        "positive" : 42,
        "gaps" : 9,
        "Type" : "protein_coding",
        "bitscore" : 31.2,
        "slen" : 736,
        "mismatch" : 46,
        "name" : "SpCluster-9928.42",
        "send" : 443,
        "qcovs" : 38,
        "PrimarySymbol" : "FACTOR OF DNA METHYLATION 4 (FDM4)",
        "qend" : 297
      },
      "position" : {
        "x" : 446.76953125,
        "y" : -1518.9453125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17179",
        "degree_layout" : 5,
        "Description" : "lysyl-tRNA synthetase 1;(source:Araport11)",
        "SecondarySymbol" : "LYSYL-TRNA SYNTHETASE 1 (ATKRS-1)",
        "sstart" : 86,
        "qstart" : 363,
        "qcovhsp" : 22,
        "shared_name" : "KfCluster-4091.0",
        "ppos" : 74.41,
        "score" : 1821,
        "pident" : 60.878,
        "SUID" : 17179,
        "selected" : false,
        "sseqid" : "AT3G11710",
        "length" : 547,
        "nident" : 333,
        "evalue" : 0.0,
        "positive" : 407,
        "gaps" : 35,
        "Type" : "protein_coding",
        "bitscore" : 706.0,
        "slen" : 626,
        "mismatch" : 179,
        "name" : "KfCluster-4091.0",
        "send" : 620,
        "qcovs" : 66,
        "PrimarySymbol" : "LYSYL-TRNA SYNTHETASE 1 (ATKRS-1)",
        "qend" : 1934
      },
      "position" : {
        "x" : 174.41163635253906,
        "y" : -977.3052978515625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17904",
        "degree_layout" : 5,
        "Description" : "",
        "SecondarySymbol" : "",
        "shared_name" : "SpCluster-1794.0",
        "SUID" : 17904,
        "selected" : false,
        "sseqid" : "",
        "Type" : "",
        "name" : "SpCluster-1794.0",
        "PrimarySymbol" : ""
      },
      "position" : {
        "x" : -103.52340698242188,
        "y" : -1982.835693359375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17903",
        "degree_layout" : 3,
        "Description" : "zinc finger (C3HC4-type RING finger) family protein / BRCT domain-containing protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 299,
        "qstart" : 553,
        "qcovhsp" : 2,
        "shared_name" : "SpCluster-10656.0",
        "ppos" : 63.89,
        "score" : 96,
        "pident" : 47.222,
        "SUID" : 17903,
        "selected" : false,
        "sseqid" : "AT1G67180",
        "length" : 36,
        "nident" : 17,
        "evalue" : 0.001,
        "positive" : 23,
        "gaps" : 1,
        "Type" : "protein_coding",
        "bitscore" : 41.6,
        "slen" : 453,
        "mismatch" : 18,
        "name" : "SpCluster-10656.0",
        "send" : 333,
        "qcovs" : 6,
        "PrimarySymbol" : "0",
        "qend" : 660
      },
      "position" : {
        "x" : 76.59334564208984,
        "y" : -1868.337646484375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17900",
        "degree_layout" : 4,
        "Description" : "glutathione S-conjugate transporting ATPase (AtMRP1) mRNA. An ABCC-type arsenite-phytochelatin transporter. The expression of this gene is upregulated by herbicide safeners such as benoxacor and fenclorim.",
        "SecondarySymbol" : "(EST1);ATP-BINDING CASSETTE C1 (ABCC1);ARABIDOPSIS THALIANA ATP-BINDING CASSETTE C1 (ATABCC1);MULTIDRUG RESISTANCE-ASSOCIATED PROTEIN 1 (MRP1);ARABIDOPSIS THALIANA MULTIDRUG RESISTANCE-ASSOCIATED PROTEIN 1 (ATMRP1)",
        "sstart" : 232,
        "qstart" : 61,
        "qcovhsp" : 30,
        "shared_name" : "SpCluster-2957.0",
        "ppos" : 44.48,
        "score" : 249,
        "pident" : 27.586,
        "SUID" : 17900,
        "selected" : false,
        "sseqid" : "AT1G30400",
        "length" : 290,
        "nident" : 80,
        "evalue" : 3.01E-23,
        "positive" : 129,
        "gaps" : 13,
        "Type" : "protein_coding",
        "bitscore" : 100.0,
        "slen" : 1622,
        "mismatch" : 197,
        "name" : "SpCluster-2957.0",
        "send" : 511,
        "qcovs" : 91,
        "PrimarySymbol" : "ATP-BINDING CASSETTE C1 (ABCC1)",
        "qend" : 921
      },
      "position" : {
        "x" : 387.3438415527344,
        "y" : 47.99858474731445
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17172",
        "degree_layout" : 3,
        "Description" : "\"Similar to prokaryote sensory transduction proteins. Contains a histidine kinase and a response regulator domain. Homodimer. Membrane component. Binds ethylene. Mutations affect ethylene binding and metabolism of other plant hormones such as auxin, cytokinins, ABA and gibberellic acid. Ethylene receptor. Has histidine kinase activity. Is regulated by RTE1. Mutations in ETR1 block ethylene stimulation of flavonol synthesis.\"",
        "SecondarySymbol" : "ETHYLENE RESPONSE 1 (ETR1); (AtETR1);ETHYLENE RESPONSE (ETR);ETHYLENE INSENSITIVE 1 (EIN1)",
        "sstart" : 387,
        "qstart" : 1565,
        "qcovhsp" : 9,
        "shared_name" : "KfCluster-24057.0",
        "ppos" : 49.45,
        "score" : 152,
        "pident" : 29.67,
        "SUID" : 17172,
        "selected" : false,
        "sseqid" : "AT1G66340",
        "length" : 182,
        "nident" : 54,
        "evalue" : 3.18E-10,
        "positive" : 90,
        "gaps" : 22,
        "Type" : "protein_coding",
        "bitscore" : 63.2,
        "slen" : 738,
        "mismatch" : 106,
        "name" : "KfCluster-24057.0",
        "send" : 566,
        "qcovs" : 28,
        "PrimarySymbol" : "ETHYLENE RESPONSE 1 (ETR1)",
        "qend" : 1080
      },
      "position" : {
        "x" : 1905.0972426531584,
        "y" : -1464.4537116586107
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17171",
        "degree_layout" : 8,
        "Description" : "Plant mobile domain protein family;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 132,
        "qstart" : 956,
        "qcovhsp" : 6,
        "shared_name" : "SpCluster-8864.0",
        "ppos" : 45.56,
        "score" : 68,
        "pident" : 23.333,
        "SUID" : 17171,
        "selected" : false,
        "sseqid" : "AT1G50790",
        "length" : 90,
        "nident" : 21,
        "evalue" : 3.1,
        "positive" : 41,
        "gaps" : 4,
        "Type" : "protein_coding",
        "bitscore" : 30.8,
        "slen" : 812,
        "mismatch" : 65,
        "name" : "SpCluster-8864.0",
        "send" : 218,
        "qcovs" : 17,
        "PrimarySymbol" : "0",
        "qend" : 1222
      },
      "position" : {
        "x" : -539.7749633789062,
        "y" : -1164.0047607421875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17170",
        "degree_layout" : 11,
        "Description" : "F-box and associated interaction domains-containing protein;(source:Araport11)",
        "SecondarySymbol" : "(FOA2)",
        "sstart" : 96,
        "qstart" : 2670,
        "qcovhsp" : 2,
        "shared_name" : "SpCluster-15977.2",
        "ppos" : 49.02,
        "score" : 68,
        "pident" : 33.333,
        "SUID" : 17170,
        "selected" : false,
        "sseqid" : "AT3G16740",
        "length" : 51,
        "nident" : 17,
        "evalue" : 7.0,
        "positive" : 25,
        "gaps" : 4,
        "Type" : "protein_coding",
        "bitscore" : 30.8,
        "slen" : 391,
        "mismatch" : 30,
        "name" : "SpCluster-15977.2",
        "send" : 142,
        "qcovs" : 5,
        "PrimarySymbol" : "(FOA2)",
        "qend" : 2822
      },
      "position" : {
        "x" : -570.9884033203125,
        "y" : -1275.9168701171875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17169",
        "degree_layout" : 9,
        "Description" : "NAD(P)-binding Rossmann-fold superfamily protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 126,
        "qstart" : 312,
        "qcovhsp" : 6,
        "shared_name" : "SpCluster-15977.1",
        "ppos" : 38.67,
        "score" : 64,
        "pident" : 29.333,
        "SUID" : 17169,
        "selected" : false,
        "sseqid" : "AT4G13180",
        "length" : 75,
        "nident" : 22,
        "evalue" : 4.8,
        "positive" : 29,
        "gaps" : 7,
        "Type" : "protein_coding",
        "bitscore" : 29.3,
        "slen" : 263,
        "mismatch" : 46,
        "name" : "SpCluster-15977.1",
        "send" : 199,
        "qcovs" : 19,
        "PrimarySymbol" : "0",
        "qend" : 518
      },
      "position" : {
        "x" : -502.001708984375,
        "y" : -1225.55078125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17168",
        "degree_layout" : 9,
        "Description" : "G-type lectin S-receptor-like Serine/Threonine-kinase;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 420,
        "qstart" : 1130,
        "qcovhsp" : 4,
        "shared_name" : "SpCluster-13884.1",
        "ppos" : 52.17,
        "score" : 68,
        "pident" : 26.087,
        "SUID" : 17168,
        "selected" : false,
        "sseqid" : "AT1G61460",
        "length" : 69,
        "nident" : 18,
        "evalue" : 3.1,
        "positive" : 36,
        "gaps" : 6,
        "Type" : "protein_coding",
        "bitscore" : 30.8,
        "slen" : 598,
        "mismatch" : 45,
        "name" : "SpCluster-13884.1",
        "send" : 485,
        "qcovs" : 12,
        "PrimarySymbol" : "0",
        "qend" : 1327
      },
      "position" : {
        "x" : -630.2666625976562,
        "y" : -1215.96533203125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17167",
        "degree_layout" : 2,
        "Description" : "\"Conserved among eukaryotes, similar to Arabidopsis SABRE. The phenotype of the kip/sab double mutant suggests related functions for both genes, however, the KIP protein is mostly required for tip-growth. Predicted to be targeted to the secretory pathway. mRNA was detected in all organs, with most abundance in pollen and roots.\"",
        "SecondarySymbol" : "0",
        "sstart" : 1341,
        "qstart" : 234,
        "qcovhsp" : 23,
        "shared_name" : "KfCluster-24002.3",
        "ppos" : 51.67,
        "score" : 64,
        "pident" : 31.667,
        "SUID" : 17167,
        "selected" : false,
        "sseqid" : "AT5G49680",
        "length" : 60,
        "nident" : 19,
        "evalue" : 0.25,
        "positive" : 31,
        "gaps" : 7,
        "Type" : "protein_coding",
        "bitscore" : 29.3,
        "slen" : 2587,
        "mismatch" : 34,
        "name" : "KfCluster-24002.3",
        "send" : 1396,
        "qcovs" : 70,
        "PrimarySymbol" : "0",
        "qend" : 64
      },
      "position" : {
        "x" : -695.9880981445312,
        "y" : -1024.57080078125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17166",
        "degree_layout" : 2,
        "Description" : "glycosyl hydrolase 9B15;(source:Araport11)",
        "SecondarySymbol" : "GLYCOSYL HYDROLASE 9B15 (GH9B15);GLYCOSYL HYDROLASE 9B15 (AtGH9B15)",
        "sstart" : 394,
        "qstart" : 54,
        "qcovhsp" : 21,
        "shared_name" : "KfCluster-24002.1",
        "ppos" : 44.23,
        "score" : 58,
        "pident" : 32.692,
        "SUID" : 17166,
        "selected" : false,
        "sseqid" : "AT4G23560",
        "length" : 52,
        "nident" : 17,
        "evalue" : 1.4,
        "positive" : 23,
        "gaps" : 14,
        "Type" : "protein_coding",
        "bitscore" : 26.9,
        "slen" : 479,
        "mismatch" : 21,
        "name" : "KfCluster-24002.1",
        "send" : 434,
        "qcovs" : 63,
        "PrimarySymbol" : "GLYCOSYL HYDROLASE 9B15 (GH9B15)",
        "qend" : 200
      },
      "position" : {
        "x" : -755.0774536132812,
        "y" : -1115.691650390625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17165",
        "degree_layout" : 14,
        "Description" : "ABC transporter family protein;(source:Araport11)",
        "SecondarySymbol" : "ATP-BINDING CASSETTE G28 (ABCG28)",
        "sstart" : 57,
        "qstart" : 639,
        "qcovhsp" : 2,
        "shared_name" : "KfCluster-24002.8",
        "ppos" : 53.06,
        "score" : 68,
        "pident" : 38.776,
        "SUID" : 17165,
        "selected" : false,
        "sseqid" : "AT5G60740",
        "length" : 49,
        "nident" : 19,
        "evalue" : 4.7,
        "positive" : 26,
        "gaps" : 4,
        "Type" : "protein_coding",
        "bitscore" : 30.8,
        "slen" : 1109,
        "mismatch" : 26,
        "name" : "KfCluster-24002.8",
        "send" : 105,
        "qcovs" : 6,
        "PrimarySymbol" : "ATP-BINDING CASSETTE G28 (ABCG28)",
        "qend" : 773
      },
      "position" : {
        "x" : -622.9736328125,
        "y" : -1134.890380859375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17164",
        "degree_layout" : 2,
        "Description" : "Encodes a protein with high homology to animal villin. VLN3 is a Ca2+-regulated villin involved in actin filament bundling.",
        "SecondarySymbol" : "(ATVLN3);VILLIN 3 (VLN3)",
        "sstart" : 239,
        "qstart" : 86,
        "qcovhsp" : 14,
        "shared_name" : "KfCluster-24002.0",
        "ppos" : 60.0,
        "score" : 56,
        "pident" : 33.333,
        "SUID" : 17164,
        "selected" : false,
        "sseqid" : "AT3G57410",
        "length" : 30,
        "nident" : 10,
        "evalue" : 2.1,
        "positive" : 18,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 26.2,
        "slen" : 965,
        "mismatch" : 20,
        "name" : "KfCluster-24002.0",
        "send" : 268,
        "qcovs" : 43,
        "PrimarySymbol" : "VILLIN 3 (VLN3)",
        "qend" : 175
      },
      "position" : {
        "x" : -588.009521484375,
        "y" : -1003.1461181640625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17897",
        "degree_layout" : 18,
        "Description" : "cysteine proteinase1;(source:Araport11)",
        "SecondarySymbol" : "RD21A-LIKE PROTEASE1 (RDL1);CYSTEINE PROTEINASE1 (CP1)",
        "sstart" : 308,
        "qstart" : 1422,
        "qcovhsp" : 5,
        "shared_name" : "SpCluster-9675.0",
        "ppos" : 54.93,
        "score" : 132,
        "pident" : 46.479,
        "SUID" : 17897,
        "selected" : false,
        "sseqid" : "AT4G36880",
        "length" : 71,
        "nident" : 33,
        "evalue" : 3.52E-8,
        "positive" : 39,
        "gaps" : 11,
        "Type" : "protein_coding",
        "bitscore" : 55.5,
        "slen" : 376,
        "mismatch" : 27,
        "name" : "SpCluster-9675.0",
        "send" : 373,
        "qcovs" : 14,
        "PrimarySymbol" : "CYSTEINE PROTEINASE1 (CP1)",
        "qend" : 1228
      },
      "position" : {
        "x" : 229.450439453125,
        "y" : -1193.89697265625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17896",
        "degree_layout" : 20,
        "Description" : "Encodes a senescence-associated thiol protease. The mRNA is cell-to-cell mobile.",
        "SecondarySymbol" : "ALEURAIN-LIKE PROTEASE (ALP);ALEURAIN-LIKE PROTEASE (AALP)",
        "sstart" : 267,
        "qstart" : 24,
        "qcovhsp" : 7,
        "shared_name" : "SpCluster-2644.6",
        "ppos" : 61.0,
        "score" : 206,
        "pident" : 46.0,
        "SUID" : 17896,
        "selected" : false,
        "sseqid" : "AT5G60360",
        "length" : 100,
        "nident" : 46,
        "evalue" : 1.82E-17,
        "positive" : 61,
        "gaps" : 11,
        "Type" : "protein_coding",
        "bitscore" : 84.0,
        "slen" : 358,
        "mismatch" : 43,
        "name" : "SpCluster-2644.6",
        "send" : 357,
        "qcovs" : 21,
        "PrimarySymbol" : "ALEURAIN-LIKE PROTEASE (ALP)",
        "qend" : 317
      },
      "position" : {
        "x" : 242.03997802734375,
        "y" : -1276.135498046875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17895",
        "degree_layout" : 16,
        "Description" : "cysteine proteinase1;(source:Araport11)",
        "SecondarySymbol" : "RD21A-LIKE PROTEASE1 (RDL1);CYSTEINE PROTEINASE1 (CP1)",
        "sstart" : 323,
        "qstart" : 2,
        "qcovhsp" : 4,
        "shared_name" : "SpCluster-2644.5",
        "ppos" : 52.46,
        "score" : 102,
        "pident" : 44.262,
        "SUID" : 17895,
        "selected" : false,
        "sseqid" : "AT4G36880",
        "length" : 61,
        "nident" : 27,
        "evalue" : 1.84E-4,
        "positive" : 32,
        "gaps" : 11,
        "Type" : "protein_coding",
        "bitscore" : 43.9,
        "slen" : 376,
        "mismatch" : 23,
        "name" : "SpCluster-2644.5",
        "send" : 376,
        "qcovs" : 13,
        "PrimarySymbol" : "CYSTEINE PROTEINASE1 (CP1)",
        "qend" : 172
      },
      "position" : {
        "x" : 181.35586547851562,
        "y" : -1183.4520263671875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17894",
        "degree_layout" : 28,
        "Description" : "\"cysteine proteinase precursor-like protein/ dehydration stress-responsive gene (RD21).  Has been shown to have peptide ligase activity and protease activity in vitro.  RD21 is involved in immunity to the necrotrophic fungal pathogen Botrytis cinerea.Activity detected in root, leaf, flower and cell culture.\"",
        "SecondarySymbol" : "RESPONSIVE TO DEHYDRATION 21 (RD21);RESPONSIVE TO DEHYDRATION 21A (RD21A)",
        "sstart" : 128,
        "qstart" : 2230,
        "qcovhsp" : 9,
        "shared_name" : "SpCluster-18967.0",
        "ppos" : 57.5,
        "score" : 389,
        "pident" : 37.5,
        "SUID" : 17894,
        "selected" : false,
        "sseqid" : "AT1G47128",
        "length" : 240,
        "nident" : 90,
        "evalue" : 4.93E-40,
        "positive" : 138,
        "gaps" : 19,
        "Type" : "protein_coding",
        "bitscore" : 154.0,
        "slen" : 462,
        "mismatch" : 131,
        "name" : "SpCluster-18967.0",
        "send" : 352,
        "qcovs" : 27,
        "PrimarySymbol" : "RESPONSIVE TO DEHYDRATION 21A (RD21A)",
        "qend" : 1523
      },
      "position" : {
        "x" : 294.0281982421875,
        "y" : -1270.6297607421875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17893",
        "degree_layout" : 16,
        "Description" : "Encodes cytosolic phosphoglycerate kinase (PGK).",
        "SecondarySymbol" : "PHOSPHOGLYCERATE KINASE (PGK)",
        "sstart" : 258,
        "qstart" : 1163,
        "qcovhsp" : 3,
        "shared_name" : "SpCluster-15642.4",
        "ppos" : 60.87,
        "score" : 65,
        "pident" : 32.609,
        "SUID" : 17893,
        "selected" : false,
        "sseqid" : "AT1G79550",
        "length" : 46,
        "nident" : 15,
        "evalue" : 7.0,
        "positive" : 28,
        "gaps" : 6,
        "Type" : "protein_coding",
        "bitscore" : 29.6,
        "slen" : 401,
        "mismatch" : 25,
        "name" : "SpCluster-15642.4",
        "send" : 302,
        "qcovs" : 8,
        "PrimarySymbol" : "PHOSPHOGLYCERATE KINASE (PGK)",
        "qend" : 1041
      },
      "position" : {
        "x" : 317.6529846191406,
        "y" : -1177.12060546875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17892",
        "degree_layout" : 15,
        "Description" : "SAUR-like auxin-responsive protein family;(source:Araport11)",
        "SecondarySymbol" : "SMALL AUXIN UPREGULATED RNA 77 (SAUR77)",
        "sstart" : 29,
        "qstart" : 630,
        "qcovhsp" : 1,
        "shared_name" : "SpCluster-14026.5",
        "ppos" : 56.25,
        "score" : 70,
        "pident" : 43.75,
        "SUID" : 17892,
        "selected" : false,
        "sseqid" : "AT1G17345",
        "length" : 32,
        "nident" : 14,
        "evalue" : 0.87,
        "positive" : 18,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 31.6,
        "slen" : 131,
        "mismatch" : 18,
        "name" : "SpCluster-14026.5",
        "send" : 60,
        "qcovs" : 4,
        "PrimarySymbol" : "SMALL AUXIN UPREGULATED RNA 77 (SAUR77)",
        "qend" : 535
      },
      "position" : {
        "x" : 167.24343872070312,
        "y" : -1221.91943359375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17891",
        "degree_layout" : 16,
        "Description" : "Encodes a vacuolar sorting receptor that participates in vacuolar sorting in vegetative tissues and in seeds. The mRNA is cell-to-cell mobile.",
        "SecondarySymbol" : "VACUOLAR SORTING RECEPTOR 3 (VSR3);VACUOLAR SORTING RECEPTOR 2;2 (VSR2;2);BINDING PROTEIN OF 80 KDA 2;2 (BP80-2;2);VACULOLAR SORTING RECEPTOR 3 (VSR3); (UXS2);VACULOLAR SORTING RECEPTOR 3 (ATVSR3)",
        "sstart" : 501,
        "qstart" : 165,
        "qcovhsp" : 7,
        "shared_name" : "SpCluster-10145.8",
        "ppos" : 39.39,
        "score" : 78,
        "pident" : 30.303,
        "SUID" : 17891,
        "selected" : false,
        "sseqid" : "AT2G14740",
        "length" : 99,
        "nident" : 30,
        "evalue" : 0.18,
        "positive" : 39,
        "gaps" : 14,
        "Type" : "protein_coding",
        "bitscore" : 34.7,
        "slen" : 628,
        "mismatch" : 55,
        "name" : "SpCluster-10145.8",
        "send" : 585,
        "qcovs" : 22,
        "PrimarySymbol" : "VACULOLAR SORTING RECEPTOR 3 (VSR3)",
        "qend" : 461
      },
      "position" : {
        "x" : 312.2717590332031,
        "y" : -1213.556396484375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17890",
        "degree_layout" : 15,
        "Description" : "encodes a vacuolar sorting receptor",
        "SecondarySymbol" : "VACUOLAR SORTING RECEPTOR 2 (VSR-2);VACUOLAR SORTING RECEPTOR 4 (VSR4); (MTV4);BINDING PROTEIN OF 80 KDA 2;1 (BP80-2;1);VACUOLAR SORTING RECEPTOR 2;1 (VSR2;1)",
        "sstart" : 501,
        "qstart" : 165,
        "qcovhsp" : 7,
        "shared_name" : "SpCluster-10145.3",
        "ppos" : 40.4,
        "score" : 78,
        "pident" : 31.313,
        "SUID" : 17890,
        "selected" : false,
        "sseqid" : "AT2G14720",
        "length" : 99,
        "nident" : 31,
        "evalue" : 0.2,
        "positive" : 40,
        "gaps" : 14,
        "Type" : "protein_coding",
        "bitscore" : 34.7,
        "slen" : 628,
        "mismatch" : 54,
        "name" : "SpCluster-10145.3",
        "send" : 585,
        "qcovs" : 20,
        "PrimarySymbol" : "VACUOLAR SORTING RECEPTOR 4 (VSR4)",
        "qend" : 461
      },
      "position" : {
        "x" : 243.80276489257812,
        "y" : -1139.87109375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17161",
        "degree_layout" : 14,
        "Description" : "\"PUB4 encodes a functional ubiquitin-protein ligase. The gene is expressed in most plant tissues and the protein localizes to the nucleus. PUB4 has been recovered as a second site suppressor from several different genetic screens and from these, it has been inferred to have roles in regulating root development, pollen tapetum development and ROS induced chloroplast degredation.\"",
        "SecondarySymbol" : "(ATPUB4);PLANT U-BOX 4 (PUB4)",
        "sstart" : 545,
        "qstart" : 1989,
        "qcovhsp" : 8,
        "shared_name" : "SpCluster-14316.0",
        "ppos" : 61.15,
        "score" : 438,
        "pident" : 37.692,
        "SUID" : 17161,
        "selected" : false,
        "sseqid" : "AT2G23140",
        "length" : 260,
        "nident" : 98,
        "evalue" : 2.86E-44,
        "positive" : 159,
        "gaps" : 1,
        "Type" : "protein_coding",
        "bitscore" : 173.0,
        "slen" : 826,
        "mismatch" : 161,
        "name" : "SpCluster-14316.0",
        "send" : 803,
        "qcovs" : 25,
        "PrimarySymbol" : "PLANT U-BOX 4 (PUB4)",
        "qend" : 2768
      },
      "position" : {
        "x" : -604.4544677734375,
        "y" : -1771.7908935546875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17160",
        "degree_layout" : 8,
        "Description" : "ARM repeat superfamily protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 17,
        "qstart" : 911,
        "qcovhsp" : 17,
        "shared_name" : "PpCluster-21509.2",
        "ppos" : 63.19,
        "score" : 939,
        "pident" : 37.546,
        "SUID" : 17160,
        "selected" : false,
        "sseqid" : "AT2G45720",
        "length" : 546,
        "nident" : 205,
        "evalue" : 1.03E-114,
        "positive" : 345,
        "gaps" : 11,
        "Type" : "protein_coding",
        "bitscore" : 366.0,
        "slen" : 553,
        "mismatch" : 330,
        "name" : "PpCluster-21509.2",
        "send" : 552,
        "qcovs" : 50,
        "PrimarySymbol" : "0",
        "qend" : 2545
      },
      "position" : {
        "x" : -708.3026733398438,
        "y" : -1755.6302490234375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17159",
        "degree_layout" : 22,
        "Description" : "\"Encodes a protein containing a UND, a U-box, and an ARM domain. This protein has E3 ubiquitin ligase activity based on in vitro assays.  Can be phosphorylated in vitro by MLPK, ARK1, and ARK2 but not by SD1-29. Involved in ubiquitination of pattern recognition receptor FLS2.\"",
        "SecondarySymbol" : "ARABIDOPSIS THALIANA PLANT U-BOX 13 (ATPUB13);PLANT U-BOX 13 (PUB13)",
        "sstart" : 70,
        "qstart" : 3690,
        "qcovhsp" : 9,
        "shared_name" : "PpCluster-12276.2",
        "ppos" : 67.28,
        "score" : 1412,
        "pident" : 50.25,
        "SUID" : 17159,
        "selected" : false,
        "sseqid" : "AT3G46510",
        "length" : 599,
        "nident" : 301,
        "evalue" : 3.04E-174,
        "positive" : 403,
        "gaps" : 42,
        "Type" : "protein_coding",
        "bitscore" : 548.0,
        "slen" : 660,
        "mismatch" : 256,
        "name" : "PpCluster-12276.2",
        "send" : 629,
        "qcovs" : 28,
        "PrimarySymbol" : "PLANT U-BOX 13 (PUB13)",
        "qend" : 5477
      },
      "position" : {
        "x" : -596.6235961914062,
        "y" : -1684.9166259765625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17158",
        "degree_layout" : 8,
        "Description" : "ARM repeat superfamily protein;(source:Araport11)",
        "SecondarySymbol" : "(PUB2)",
        "sstart" : 409,
        "qstart" : 2169,
        "qcovhsp" : 4,
        "shared_name" : "KfCluster-23694.0",
        "ppos" : 53.1,
        "score" : 191,
        "pident" : 34.884,
        "SUID" : 17158,
        "selected" : false,
        "sseqid" : "AT5G67340",
        "length" : 258,
        "nident" : 90,
        "evalue" : 3.54E-14,
        "positive" : 137,
        "gaps" : 9,
        "Type" : "protein_coding",
        "bitscore" : 78.2,
        "slen" : 707,
        "mismatch" : 159,
        "name" : "KfCluster-23694.0",
        "send" : 658,
        "qcovs" : 13,
        "PrimarySymbol" : "(PUB2)",
        "qend" : 1399
      },
      "position" : {
        "x" : -779.3486328125,
        "y" : -1678.56103515625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17152",
        "degree_layout" : 2,
        "Description" : "transferring glycosyl group transferase (DUF604);(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 112,
        "qstart" : 491,
        "qcovhsp" : 20,
        "shared_name" : "KfCluster-22864.0",
        "ppos" : 70.43,
        "score" : 1201,
        "pident" : 50.721,
        "SUID" : 17152,
        "selected" : false,
        "sseqid" : "AT5G41460",
        "length" : 416,
        "nident" : 211,
        "evalue" : 2.21E-158,
        "positive" : 293,
        "gaps" : 7,
        "Type" : "protein_coding",
        "bitscore" : 467.0,
        "slen" : 524,
        "mismatch" : 198,
        "name" : "KfCluster-22864.0",
        "send" : 521,
        "qcovs" : 61,
        "PrimarySymbol" : "0",
        "qend" : 1735
      },
      "position" : {
        "x" : -175.0201873779297,
        "y" : -1128.065673828125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17151",
        "degree_layout" : 2,
        "Description" : "ILITHYIA (ILA) is a HEAT repeat protein involved in plant immunity. The gene is also involved in systemic acquired resistance induced by P. syringae expressing avrRps4. Loss-of-function mutants of ILA caused pleiotropic defects in the mutant plants. The mutant plants are smaller in size and the leaves are serrated and yellow to light green in color. Required for bacterium-triggered stomatal closure.",
        "SecondarySymbol" : "ILITHYIA (ILA)",
        "sstart" : 1415,
        "qstart" : 274,
        "qcovhsp" : 12,
        "shared_name" : "KfCluster-4956.0",
        "ppos" : 62.34,
        "score" : 134,
        "pident" : 37.662,
        "SUID" : 17151,
        "selected" : false,
        "sseqid" : "AT1G64790",
        "length" : 77,
        "nident" : 29,
        "evalue" : 3.71E-9,
        "positive" : 48,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 56.2,
        "slen" : 2696,
        "mismatch" : 48,
        "name" : "KfCluster-4956.0",
        "send" : 1491,
        "qcovs" : 36,
        "PrimarySymbol" : "ILITHYIA (ILA)",
        "qend" : 44
      },
      "position" : {
        "x" : -52.12067413330078,
        "y" : -467.069580078125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17150",
        "degree_layout" : 2,
        "Description" : "hypothetical protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 43,
        "qstart" : 1634,
        "qcovhsp" : 3,
        "shared_name" : "SpCluster-6101.0",
        "ppos" : 55.36,
        "score" : 67,
        "pident" : 26.786,
        "SUID" : 17150,
        "selected" : false,
        "sseqid" : "AT5G56850",
        "length" : 56,
        "nident" : 15,
        "evalue" : 5.4,
        "positive" : 31,
        "gaps" : 1,
        "Type" : "protein_coding",
        "bitscore" : 30.4,
        "slen" : 551,
        "mismatch" : 40,
        "name" : "SpCluster-6101.0",
        "send" : 97,
        "qcovs" : 8,
        "PrimarySymbol" : "0",
        "qend" : 1467
      },
      "position" : {
        "x" : -503.68878173828125,
        "y" : -1532.1787109375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17149",
        "degree_layout" : 6,
        "Description" : "encodes a ubiquitin-protein ligase containing a HECT domain. There are six other HECT-domain UPLs in Arabidopsis.",
        "SecondarySymbol" : "UBIQUITIN-PROTEIN LIGASE 1 (UPL1)",
        "sstart" : 3025,
        "qstart" : 2301,
        "qcovhsp" : 12,
        "shared_name" : "SpCluster-20089.1",
        "ppos" : 75.04,
        "score" : 1909,
        "pident" : 62.253,
        "SUID" : 17149,
        "selected" : false,
        "sseqid" : "AT1G55860",
        "length" : 657,
        "nident" : 409,
        "evalue" : 0.0,
        "positive" : 493,
        "gaps" : 11,
        "Type" : "protein_coding",
        "bitscore" : 739.0,
        "slen" : 3681,
        "mismatch" : 237,
        "name" : "SpCluster-20089.1",
        "send" : 3672,
        "qcovs" : 36,
        "PrimarySymbol" : "UBIQUITIN-PROTEIN LIGASE 1 (UPL1)",
        "qend" : 337
      },
      "position" : {
        "x" : -289.76226806640625,
        "y" : -1973.0533447265625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17148",
        "degree_layout" : 4,
        "Description" : "Leucine-rich repeat protein kinase family protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 131,
        "qstart" : 705,
        "qcovhsp" : 3,
        "shared_name" : "SpCluster-13182.204",
        "ppos" : 47.06,
        "score" : 75,
        "pident" : 25.0,
        "SUID" : 17148,
        "selected" : false,
        "sseqid" : "AT1G67720",
        "length" : 68,
        "nident" : 17,
        "evalue" : 0.72,
        "positive" : 32,
        "gaps" : 12,
        "Type" : "protein_coding",
        "bitscore" : 33.5,
        "slen" : 929,
        "mismatch" : 39,
        "name" : "SpCluster-13182.204",
        "send" : 186,
        "qcovs" : 10,
        "PrimarySymbol" : "0",
        "qend" : 502
      },
      "position" : {
        "x" : -805.5597534179688,
        "y" : -1593.1580810546875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17147",
        "degree_layout" : 3,
        "Description" : "\"At3g60190 encodes Arabidopsis dynamin-related protein 1E, DRP1E, also known as EDR3, ADL4 and ADL1E, which is 624 amino acid residues long, has a predicted mass of 69.8 kDa and a pI of 7.5.  Dynamin-related protein 1E belongs to a plant-specific subclass of dynamin-related proteins (DRP1), consisting of five members in Arabidopsis (A, B, C, D, E). This class is characterized by having an N-terminal GTPase domain, a central `dynamin 2` domain and a C-terminal GTPase effector domain (GED), a typical structure for plant dynamin-related proteins. However, this class lacks a PH domain and a proline-rich domain, which are found in classical animal dynamin-like proteins. Based on work on animal dynamins, the plant DRP1 proteins should be able to form polymeric structures that wrap around membranes to facilitate membrane tubulation and pinching off of vesicles, processes that are essential to vesicle trafficking and membrane compartmentalization.  The edr3 mutation causes a P77L substitution in the G2 motif of the GTPase domain of DRP1E.  edr3 mutant Arabidopsis plants display enhanced cell death in response to powdery mildew infection.\"",
        "SecondarySymbol" : "ARABIDOPSIS DYNAMIN-LIKE 4 (ADL4);DYNAMIN-LIKE PROTEIN 2 (ADLP2);DYNAMIN-LIKE 1E (DL1E);DYNAMIN-RELATED PROTEIN 1E (DRP1E);DYNAMIN-LIKE 1E (ADL1E);ENHANCED DISEASE RESISTANCE 3 (EDR3)",
        "sstart" : 4,
        "qstart" : 2244,
        "qcovhsp" : 25,
        "shared_name" : "KfCluster-31665.0",
        "ppos" : 84.62,
        "score" : 2271,
        "pident" : 70.353,
        "SUID" : 17147,
        "selected" : false,
        "sseqid" : "AT3G60190",
        "length" : 624,
        "nident" : 439,
        "evalue" : 0.0,
        "positive" : 528,
        "gaps" : 6,
        "Type" : "protein_coding",
        "bitscore" : 879.0,
        "slen" : 624,
        "mismatch" : 179,
        "name" : "KfCluster-31665.0",
        "send" : 622,
        "qcovs" : 75,
        "PrimarySymbol" : "DYNAMIN-LIKE 1E (DL1E)",
        "qend" : 376
      },
      "position" : {
        "x" : -857.4939575195312,
        "y" : -1723.7913818359375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17146",
        "degree_layout" : 4,
        "Description" : "Radical SAM superfamily protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 60,
        "qstart" : 1128,
        "qcovhsp" : 14,
        "shared_name" : "KfCluster-7947.0",
        "ppos" : 74.86,
        "score" : 1111,
        "pident" : 59.116,
        "SUID" : 17146,
        "selected" : false,
        "sseqid" : "AT2G39670",
        "length" : 362,
        "nident" : 214,
        "evalue" : 9.62E-144,
        "positive" : 271,
        "gaps" : 11,
        "Type" : "protein_coding",
        "bitscore" : 432.0,
        "slen" : 428,
        "mismatch" : 137,
        "name" : "KfCluster-7947.0",
        "send" : 410,
        "qcovs" : 41,
        "PrimarySymbol" : "0",
        "qend" : 2213
      },
      "position" : {
        "x" : 69.93055725097656,
        "y" : -995.645751953125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17145",
        "degree_layout" : 2,
        "Description" : "Radical SAM superfamily protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 94,
        "qstart" : 1759,
        "qcovhsp" : 12,
        "shared_name" : "KfCluster-22695.0",
        "ppos" : 73.03,
        "score" : 863,
        "pident" : 56.579,
        "SUID" : 17145,
        "selected" : false,
        "sseqid" : "AT1G60230",
        "length" : 304,
        "nident" : 172,
        "evalue" : 1.19E-106,
        "positive" : 222,
        "gaps" : 4,
        "Type" : "protein_coding",
        "bitscore" : 337.0,
        "slen" : 458,
        "mismatch" : 128,
        "name" : "KfCluster-22695.0",
        "send" : 394,
        "qcovs" : 35,
        "PrimarySymbol" : "0",
        "qend" : 851
      },
      "position" : {
        "x" : 60.23136901855469,
        "y" : -867.8680419921875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17144",
        "degree_layout" : 16,
        "Description" : "Encodes a nucleolar protein that is a ribosome biogenesis co-factor. Mutants display aberrant RNA processing and female gametophyte development.",
        "SecondarySymbol" : "PERIODIC TRYPTOPHAN PROTEIN 2 (ATPWP2);PERIODIC TRYPTOPHAN PROTEIN 2 (PWP2)",
        "sstart" : 247,
        "qstart" : 1987,
        "qcovhsp" : 20,
        "shared_name" : "SpCluster-8695.0",
        "ppos" : 70.89,
        "score" : 1705,
        "pident" : 52.195,
        "SUID" : 17144,
        "selected" : false,
        "sseqid" : "AT1G15440",
        "length" : 615,
        "nident" : 321,
        "evalue" : 0.0,
        "positive" : 436,
        "gaps" : 7,
        "Type" : "protein_coding",
        "bitscore" : 661.0,
        "slen" : 860,
        "mismatch" : 287,
        "name" : "SpCluster-8695.0",
        "send" : 857,
        "qcovs" : 60,
        "PrimarySymbol" : "PERIODIC TRYPTOPHAN PROTEIN 2 (PWP2)",
        "qend" : 152
      },
      "position" : {
        "x" : -680.5286865234375,
        "y" : -420.0133972167969
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17143",
        "degree_layout" : 16,
        "Description" : "Transducin/WD40 repeat-like superfamily protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 180,
        "qstart" : 1584,
        "qcovhsp" : 11,
        "shared_name" : "SpCluster-12868.0",
        "ppos" : 85.71,
        "score" : 1148,
        "pident" : 72.822,
        "SUID" : 17143,
        "selected" : false,
        "sseqid" : "AT1G10580",
        "length" : 287,
        "nident" : 209,
        "evalue" : 6.42E-148,
        "positive" : 246,
        "gaps" : 7,
        "Type" : "protein_coding",
        "bitscore" : 446.0,
        "slen" : 573,
        "mismatch" : 71,
        "name" : "SpCluster-12868.0",
        "send" : 464,
        "qcovs" : 34,
        "PrimarySymbol" : "0",
        "qend" : 739
      },
      "position" : {
        "x" : -705.1201782226562,
        "y" : -538.9437866210938
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17142",
        "degree_layout" : 9,
        "Description" : "Transducin/WD40 repeat-like superfamily protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 248,
        "qstart" : 2735,
        "qcovhsp" : 17,
        "shared_name" : "PpCluster-20719.0",
        "ppos" : 59.48,
        "score" : 981,
        "pident" : 43.621,
        "SUID" : 17142,
        "selected" : false,
        "sseqid" : "AT3G15470",
        "length" : 580,
        "nident" : 253,
        "evalue" : 1.63E-116,
        "positive" : 345,
        "gaps" : 65,
        "Type" : "protein_coding",
        "bitscore" : 382.0,
        "slen" : 883,
        "mismatch" : 262,
        "name" : "PpCluster-20719.0",
        "send" : 770,
        "qcovs" : 51,
        "PrimarySymbol" : "0",
        "qend" : 1020
      },
      "position" : {
        "x" : -711.2005004882812,
        "y" : -478.352783203125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17141",
        "degree_layout" : 4,
        "Description" : "Transducin/WD40 repeat-like superfamily protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 128,
        "qstart" : 3032,
        "qcovhsp" : 18,
        "shared_name" : "KfCluster-31553.0",
        "ppos" : 51.22,
        "score" : 826,
        "pident" : 35.073,
        "SUID" : 17141,
        "selected" : false,
        "sseqid" : "AT2G18900",
        "length" : 613,
        "nident" : 215,
        "evalue" : 2.94E-95,
        "positive" : 314,
        "gaps" : 66,
        "Type" : "protein_coding",
        "bitscore" : 322.0,
        "slen" : 804,
        "mismatch" : 332,
        "name" : "KfCluster-31553.0",
        "send" : 683,
        "qcovs" : 53,
        "PrimarySymbol" : "0",
        "qend" : 1221
      },
      "position" : {
        "x" : -484.28155517578125,
        "y" : -895.881591796875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17140",
        "degree_layout" : 16,
        "Description" : "Encodes a member of Calcium Dependent Protein Kinase. Protein is N-myristoylated. Localizes to the plasma membrane. Localizes to the chloroplast when the myristoylation motif is mutated.",
        "SecondarySymbol" : "CALCIUM-DEPENDENT PROTEIN KINASE 16 (CPK16);CALCIUM-DEPENDENT PROTEIN KINASE 16 (CDPK16); (ATCDPK16)",
        "sstart" : 47,
        "qstart" : 2148,
        "qcovhsp" : 9,
        "shared_name" : "PpCluster-7880.1",
        "ppos" : 81.39,
        "score" : 1189,
        "pident" : 69.716,
        "SUID" : 17140,
        "selected" : false,
        "sseqid" : "AT2G17890",
        "length" : 317,
        "nident" : 221,
        "evalue" : 2.79E-150,
        "positive" : 258,
        "gaps" : 4,
        "Type" : "protein_coding",
        "bitscore" : 462.0,
        "slen" : 571,
        "mismatch" : 92,
        "name" : "PpCluster-7880.1",
        "send" : 363,
        "qcovs" : 27,
        "PrimarySymbol" : "CALCIUM-DEPENDENT PROTEIN KINASE 16 (CPK16)",
        "qend" : 1210
      },
      "position" : {
        "x" : -185.16958618164062,
        "y" : -1644.3634033203125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17139",
        "degree_layout" : 16,
        "Description" : "Encodes a predicted protein kinase based on sequence similarity.",
        "SecondarySymbol" : "PUTATIVE PROTEIN KINASE 1 (PPK1)",
        "sstart" : 365,
        "qstart" : 2817,
        "qcovhsp" : 7,
        "shared_name" : "PpCluster-3719.0",
        "ppos" : 75.0,
        "score" : 1085,
        "pident" : 58.889,
        "SUID" : 17139,
        "selected" : false,
        "sseqid" : "AT1G77720",
        "length" : 360,
        "nident" : 212,
        "evalue" : 4.39E-129,
        "positive" : 270,
        "gaps" : 14,
        "Type" : "protein_coding",
        "bitscore" : 422.0,
        "slen" : 777,
        "mismatch" : 134,
        "name" : "PpCluster-3719.0",
        "send" : 720,
        "qcovs" : 21,
        "PrimarySymbol" : "PUTATIVE PROTEIN KINASE 1 (PPK1)",
        "qend" : 3866
      },
      "position" : {
        "x" : -176.7144775390625,
        "y" : -1705.789794921875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17138",
        "degree_layout" : 23,
        "Description" : "Protein kinase superfamily protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 950,
        "qstart" : 905,
        "qcovhsp" : 7,
        "shared_name" : "PpCluster-13064.2",
        "ppos" : 92.42,
        "score" : 919,
        "pident" : 81.313,
        "SUID" : 17138,
        "selected" : false,
        "sseqid" : "AT1G73450",
        "length" : 198,
        "nident" : 161,
        "evalue" : 1.26E-107,
        "positive" : 183,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 358.0,
        "slen" : 1152,
        "mismatch" : 37,
        "name" : "PpCluster-13064.2",
        "send" : 1147,
        "qcovs" : 22,
        "PrimarySymbol" : "0",
        "qend" : 1498
      },
      "position" : {
        "x" : -214.8441162109375,
        "y" : -1792.184814453125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17137",
        "degree_layout" : 2,
        "Description" : "Encodes acetyl-CoA carboxylase. Mutant displays uncoordinated cell divisions which are enhanced by cytokinins. Mutant also has aberrant organization of the apical region in the embryo and abnormal root and shoot development and is deficient in freezing tolerance after cold acclimation. Essential for very long chain fatty acid elongation. The mRNA is cell-to-cell mobile.",
        "SecondarySymbol" : "ACETYL-COA CARBOXYLASE 1 (ACC1);SENSITIVE TO FREEZING 3 (SFR3);GLOSSYHEAD 1 (GSD1);EMBRYO DEFECTIVE 22 (EMB22);GURKE (GK);PASTICCINO 3 (PAS3); (AT-ACC1)",
        "sstart" : 441,
        "qstart" : 5909,
        "qcovhsp" : 31,
        "shared_name" : "PpCluster-8345.0",
        "ppos" : 77.23,
        "score" : 6056,
        "pident" : 64.035,
        "SUID" : 17137,
        "selected" : false,
        "sseqid" : "AT1G36160",
        "length" : 1849,
        "nident" : 1184,
        "evalue" : 0.0,
        "positive" : 1428,
        "gaps" : 61,
        "Type" : "protein_coding",
        "bitscore" : 2337.0,
        "slen" : 2254,
        "mismatch" : 604,
        "name" : "PpCluster-8345.0",
        "send" : 2253,
        "qcovs" : 93,
        "PrimarySymbol" : "ACETYL-COA CARBOXYLASE 1 (ACC1)",
        "qend" : 438
      },
      "position" : {
        "x" : -687.342041015625,
        "y" : -961.2091674804688
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17136",
        "degree_layout" : 8,
        "Description" : "Encodes acetyl-CoA carboxylase. Mutant displays uncoordinated cell divisions which are enhanced by cytokinins. Mutant also has aberrant organization of the apical region in the embryo and abnormal root and shoot development and is deficient in freezing tolerance after cold acclimation. Essential for very long chain fatty acid elongation. The mRNA is cell-to-cell mobile.",
        "SecondarySymbol" : "ACETYL-COA CARBOXYLASE 1 (ACC1);SENSITIVE TO FREEZING 3 (SFR3);GLOSSYHEAD 1 (GSD1);EMBRYO DEFECTIVE 22 (EMB22);GURKE (GK);PASTICCINO 3 (PAS3); (AT-ACC1)",
        "sstart" : 23,
        "qstart" : 396,
        "qcovhsp" : 11,
        "shared_name" : "KfCluster-22301.0",
        "ppos" : 81.64,
        "score" : 3533,
        "pident" : 66.769,
        "SUID" : 17136,
        "selected" : false,
        "sseqid" : "AT1G36160",
        "length" : 975,
        "nident" : 651,
        "evalue" : 0.0,
        "positive" : 796,
        "gaps" : 5,
        "Type" : "protein_coding",
        "bitscore" : 1365.0,
        "slen" : 2254,
        "mismatch" : 319,
        "name" : "KfCluster-22301.0",
        "send" : 992,
        "qcovs" : 33,
        "PrimarySymbol" : "ACETYL-COA CARBOXYLASE 1 (ACC1)",
        "qend" : 3320
      },
      "position" : {
        "x" : -622.3812866210938,
        "y" : -1076.137451171875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17868",
        "degree_layout" : 2,
        "Description" : "\"Encodes a protein belonging to SART-1 family. The gene is expressed in the basal region of the developing embryo during heart stage. Phenotypic analyses of dot2 mutants suggest that this protein plays a role in root, shoot, and flower development. dot2 mutants are dwarved plants that display an aberrant spurred leaf venation pattern and fail to flower. In the roots DOT2 appears to be require for normal meristem organization and maintenance and the proper expression of PIN and PLT genes.\"",
        "SecondarySymbol" : "MERISTEM-DEFECTIVE (MDF);DEFECTIVELY ORGANIZED TRIBUTARIES  2 (DOT2)",
        "sstart" : 636,
        "qstart" : 2122,
        "qcovhsp" : 7,
        "shared_name" : "SpCluster-6777.0",
        "ppos" : 70.41,
        "score" : 545,
        "pident" : 60.714,
        "SUID" : 17868,
        "selected" : false,
        "sseqid" : "AT5G16780",
        "length" : 196,
        "nident" : 119,
        "evalue" : 5.65E-58,
        "positive" : 138,
        "gaps" : 12,
        "Type" : "protein_coding",
        "bitscore" : 214.0,
        "slen" : 820,
        "mismatch" : 65,
        "name" : "SpCluster-6777.0",
        "send" : 819,
        "qcovs" : 21,
        "PrimarySymbol" : "DEFECTIVELY ORGANIZED TRIBUTARIES  2 (DOT2)",
        "qend" : 2709
      },
      "position" : {
        "x" : -275.7272033691406,
        "y" : -1279.4915771484375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17867",
        "degree_layout" : 2,
        "Description" : "",
        "SecondarySymbol" : "",
        "shared_name" : "SpCluster-1971.0",
        "SUID" : 17867,
        "selected" : false,
        "sseqid" : "",
        "Type" : "",
        "name" : "SpCluster-1971.0",
        "PrimarySymbol" : ""
      },
      "position" : {
        "x" : 130.4941864013672,
        "y" : -1566.8643798828125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17132",
        "degree_layout" : 4,
        "Description" : "\"Encodes BELAYA SMERT (BSM), a plastid-localized protein homologous to mitochondrial transcription termination factors (mTERF) found in animal. Mutant bsm cells are albino, are compromised in growth, and suffer defects in global plastidic gene expression. The mRNA is cell-to-cell mobile.\"",
        "SecondarySymbol" : "RUGOSA 2 (RUG2);BELAYA SMERT (BSM)",
        "sstart" : 164,
        "qstart" : 229,
        "qcovhsp" : 2,
        "shared_name" : "KfCluster-26433.0",
        "ppos" : 52.73,
        "score" : 71,
        "pident" : 36.364,
        "SUID" : 17132,
        "selected" : false,
        "sseqid" : "AT4G02990",
        "length" : 55,
        "nident" : 20,
        "evalue" : 1.8,
        "positive" : 29,
        "gaps" : 3,
        "Type" : "protein_coding",
        "bitscore" : 32.0,
        "slen" : 541,
        "mismatch" : 32,
        "name" : "KfCluster-26433.0",
        "send" : 215,
        "qcovs" : 7,
        "PrimarySymbol" : "BELAYA SMERT (BSM)",
        "qend" : 393
      },
      "position" : {
        "x" : -360.1194152832031,
        "y" : -1339.0740966796875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17866",
        "degree_layout" : 4,
        "Description" : "PRP38 family protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 1,
        "qstart" : 9,
        "qcovhsp" : 16,
        "shared_name" : "SpCluster-19557.3",
        "ppos" : 88.59,
        "score" : 771,
        "pident" : 74.457,
        "SUID" : 17866,
        "selected" : false,
        "sseqid" : "AT2G40650",
        "length" : 184,
        "nident" : 137,
        "evalue" : 2.23E-100,
        "positive" : 163,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 301.0,
        "slen" : 355,
        "mismatch" : 47,
        "name" : "SpCluster-19557.3",
        "send" : 184,
        "qcovs" : 49,
        "PrimarySymbol" : "0",
        "qend" : 560
      },
      "position" : {
        "x" : 291.1946716308594,
        "y" : -1594.980712890625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17865",
        "degree_layout" : 1,
        "Description" : "",
        "SecondarySymbol" : "",
        "shared_name" : "SpCluster-19515.0",
        "SUID" : 17865,
        "selected" : false,
        "sseqid" : "",
        "Type" : "",
        "name" : "SpCluster-19515.0",
        "PrimarySymbol" : ""
      },
      "position" : {
        "x" : -339.0549621582031,
        "y" : -1255.53515625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17131",
        "degree_layout" : 2,
        "Description" : "\"alanine-tRNA ligase, putative (DUF760);(source:Araport11)\"",
        "SecondarySymbol" : "0",
        "sstart" : 79,
        "qstart" : 115,
        "qcovhsp" : 3,
        "shared_name" : "KfCluster-21973.9",
        "ppos" : 70.37,
        "score" : 61,
        "pident" : 44.444,
        "SUID" : 17131,
        "selected" : false,
        "sseqid" : "AT1G48450",
        "length" : 27,
        "nident" : 12,
        "evalue" : 8.9,
        "positive" : 19,
        "gaps" : 1,
        "Type" : "protein_coding",
        "bitscore" : 28.1,
        "slen" : 342,
        "mismatch" : 14,
        "name" : "KfCluster-21973.9",
        "send" : 105,
        "qcovs" : 9,
        "PrimarySymbol" : "0",
        "qend" : 38
      },
      "position" : {
        "x" : -460.873291015625,
        "y" : -435.2326354980469
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17130",
        "degree_layout" : 1,
        "Description" : "Serine carboxypeptidase S28 family protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 40,
        "qstart" : 1438,
        "qcovhsp" : 23,
        "shared_name" : "KfCluster-18284.0",
        "ppos" : 66.14,
        "score" : 1153,
        "pident" : 51.364,
        "SUID" : 17130,
        "selected" : false,
        "sseqid" : "AT4G36190",
        "length" : 440,
        "nident" : 226,
        "evalue" : 1.45E-152,
        "positive" : 291,
        "gaps" : 5,
        "Type" : "protein_coding",
        "bitscore" : 448.0,
        "slen" : 482,
        "mismatch" : 209,
        "name" : "KfCluster-18284.0",
        "send" : 478,
        "qcovs" : 70,
        "PrimarySymbol" : "0",
        "qend" : 131
      },
      "position" : {
        "x" : -448.8697814941406,
        "y" : -369.1754455566406
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17862",
        "degree_layout" : 5,
        "Description" : "Encodes a member of the casein kinase 1 protein family that is localized to the cytoplasm and nucleus. The mRNA is cell-to-cell mobile.",
        "SecondarySymbol" : "CASEIN KINASE 1-LIKE PROTEIN 2 (CKL2)",
        "sstart" : 5,
        "qstart" : 2500,
        "qcovhsp" : 11,
        "shared_name" : "SpCluster-13182.363",
        "ppos" : 54.7,
        "score" : 382,
        "pident" : 36.237,
        "SUID" : 17862,
        "selected" : false,
        "sseqid" : "AT1G72710",
        "length" : 287,
        "nident" : 104,
        "evalue" : 5.01E-39,
        "positive" : 157,
        "gaps" : 9,
        "Type" : "protein_coding",
        "bitscore" : 151.0,
        "slen" : 465,
        "mismatch" : 174,
        "name" : "SpCluster-13182.363",
        "send" : 289,
        "qcovs" : 32,
        "PrimarySymbol" : "CASEIN KINASE 1-LIKE PROTEIN 2 (CKL2)",
        "qend" : 1661
      },
      "position" : {
        "x" : -199.28829956054688,
        "y" : -1576.474365234375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17129",
        "degree_layout" : 7,
        "Description" : "encodes a DNA-binding protein that binds to plastid DNA non-specifically and is associated with nucleoids and thylakoid membranes. The expression of the gene is correlated with the development of thylakoid membranes.",
        "SecondarySymbol" : "MAR BINDING FILAMENT-LIKE PROTEIN 1 (MFP1)",
        "sstart" : 523,
        "qstart" : 1072,
        "qcovhsp" : 5,
        "shared_name" : "KfCluster-21606.0",
        "ppos" : 46.15,
        "score" : 82,
        "pident" : 29.487,
        "SUID" : 17129,
        "selected" : false,
        "sseqid" : "AT3G16000",
        "length" : 156,
        "nident" : 46,
        "evalue" : 0.14,
        "positive" : 72,
        "gaps" : 14,
        "Type" : "protein_coding",
        "bitscore" : 36.2,
        "slen" : 726,
        "mismatch" : 96,
        "name" : "KfCluster-21606.0",
        "send" : 678,
        "qcovs" : 16,
        "PrimarySymbol" : "MAR BINDING FILAMENT-LIKE PROTEIN 1 (MFP1)",
        "qend" : 1497
      },
      "position" : {
        "x" : 462.42193603515625,
        "y" : -1375.2152099609375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17128",
        "degree_layout" : 20,
        "Description" : "DNAJ heat shock family protein;(source:Araport11)",
        "SecondarySymbol" : "DNA J PROTEIN A6 (DJA6)",
        "sstart" : 23,
        "qstart" : 1762,
        "qcovhsp" : 20,
        "shared_name" : "KfCluster-8738.0",
        "ppos" : 73.46,
        "score" : 1168,
        "pident" : 60.19,
        "SUID" : 17128,
        "selected" : false,
        "sseqid" : "AT2G22360",
        "length" : 422,
        "nident" : 254,
        "evalue" : 1.48E-154,
        "positive" : 310,
        "gaps" : 19,
        "Type" : "protein_coding",
        "bitscore" : 454.0,
        "slen" : 442,
        "mismatch" : 149,
        "name" : "KfCluster-8738.0",
        "send" : 432,
        "qcovs" : 61,
        "PrimarySymbol" : "DNA J PROTEIN A6 (DJA6)",
        "qend" : 518
      },
      "position" : {
        "x" : 1634.596167713298,
        "y" : -2123.464891135904
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17127",
        "degree_layout" : 2,
        "Description" : "\"Barta et al (2010) have proposed a nomenclature for Serine/Arginine-Rich Protein Splicing Factors (SR proteins): Plant Cell. 2010, 22:2926.\"",
        "SecondarySymbol" : "SER/ARG-RICH PROTEIN 34A (SRp34a);SERINE/ARGININE-RICH PROTEIN SPLICING FACTOR 34A (SR34a);SERINE/ARGININE-RICH PROTEIN SPLICING FACTOR 34A (At-SR34a)",
        "sstart" : 1,
        "qstart" : 4208,
        "qcovhsp" : 2,
        "shared_name" : "MpCluster-23972.2",
        "ppos" : 77.4,
        "score" : 445,
        "pident" : 69.863,
        "SUID" : 17127,
        "selected" : false,
        "sseqid" : "AT3G49430",
        "length" : 146,
        "nident" : 102,
        "evalue" : 2.25E-48,
        "positive" : 113,
        "gaps" : 1,
        "Type" : "protein_coding",
        "bitscore" : 176.0,
        "slen" : 297,
        "mismatch" : 43,
        "name" : "MpCluster-23972.2",
        "send" : 146,
        "qcovs" : 5,
        "PrimarySymbol" : "SERINE/ARGININE-RICH PROTEIN SPLICING FACTOR 34A (SR34a)",
        "qend" : 4642
      },
      "position" : {
        "x" : -1862.4007568359375,
        "y" : -1057.807373046875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17126",
        "degree_layout" : 12,
        "Description" : "One of the 2 genes that code for the G subunit of eukaryotic initiation factor 3 (EIF3). The mRNA is cell-to-cell mobile.",
        "SecondarySymbol" : "(ATEIF3G1);EUKARYOTIC TRANSLATION INITIATION FACTOR 3G1 (EIF3G1)",
        "sstart" : 235,
        "qstart" : 680,
        "qcovhsp" : 9,
        "shared_name" : "KfCluster-21411.0",
        "ppos" : 89.66,
        "score" : 245,
        "pident" : 74.138,
        "SUID" : 17126,
        "selected" : false,
        "sseqid" : "AT3G11400",
        "length" : 58,
        "nident" : 43,
        "evalue" : 8.48E-25,
        "positive" : 52,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 99.0,
        "slen" : 294,
        "mismatch" : 15,
        "name" : "KfCluster-21411.0",
        "send" : 292,
        "qcovs" : 26,
        "PrimarySymbol" : "EUKARYOTIC TRANSLATION INITIATION FACTOR 3G1 (EIF3G1)",
        "qend" : 507
      },
      "position" : {
        "x" : -1691.8397216796875,
        "y" : -1015.7820434570312
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17125",
        "degree_layout" : 15,
        "Description" : "\"member of Alpha-Expansin Gene Family. Naming convention from the Expansin Working Group (Kende et al, 2004. Plant Mol Bio)\"",
        "SecondarySymbol" : "EXPANSIN A14 (ATEXPA14);EXPANSIN 14 (EXP14); (ATEXP14); (ATHEXP ALPHA 1.5);EXPANSIN A14 (EXPA14)",
        "sstart" : 54,
        "qstart" : 981,
        "qcovhsp" : 16,
        "shared_name" : "SpCluster-19201.0",
        "ppos" : 57.5,
        "score" : 373,
        "pident" : 39.5,
        "SUID" : 17125,
        "selected" : false,
        "sseqid" : "AT5G56320",
        "length" : 200,
        "nident" : 79,
        "evalue" : 5.24E-42,
        "positive" : 115,
        "gaps" : 11,
        "Type" : "protein_coding",
        "bitscore" : 148.0,
        "slen" : 255,
        "mismatch" : 110,
        "name" : "SpCluster-19201.0",
        "send" : 252,
        "qcovs" : 48,
        "PrimarySymbol" : "EXPANSIN A14 (EXPA14)",
        "qend" : 412
      },
      "position" : {
        "x" : -302.9947204589844,
        "y" : -1486.766845703125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17124",
        "degree_layout" : 12,
        "Description" : "\"Member of Alpha-Expansin Gene Family. Naming convention from the Expansin Working Group (Kende et al, 2004. Plant Mol Bio).  Containing a conserved root hair-specific cis-element RHE.  Expressed specifically in root hair cell and involved in root hair elongation.\"",
        "SecondarySymbol" : "EXPANSIN A7 (ATEXPA7); (EXP7);EXPANSIN A7 (EXPA7); (ATHEXP ALPHA 1.26); (ATEXP7)",
        "sstart" : 16,
        "qstart" : 1241,
        "qcovhsp" : 8,
        "shared_name" : "KfCluster-21389.0",
        "ppos" : 45.96,
        "score" : 178,
        "pident" : 34.161,
        "SUID" : 17124,
        "selected" : false,
        "sseqid" : "AT1G12560",
        "length" : 161,
        "nident" : 55,
        "evalue" : 2.96E-14,
        "positive" : 74,
        "gaps" : 32,
        "Type" : "protein_coding",
        "bitscore" : 73.2,
        "slen" : 262,
        "mismatch" : 74,
        "name" : "KfCluster-21389.0",
        "send" : 164,
        "qcovs" : 25,
        "PrimarySymbol" : "EXPANSIN A7 (EXPA7)",
        "qend" : 819
      },
      "position" : {
        "x" : -21.395896911621094,
        "y" : -1325.3321533203125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17859",
        "degree_layout" : 2,
        "Description" : "Kinesin that binds cyclin-dependent kinase CDKA;1 as homodimer or as heterodimer with KCA2. Demarcates the division site in plant cells.",
        "SecondarySymbol" : "KINESIN LIKE PROTEIN FOR ACTIN BASED CHLOROPLAST MOVEMENT 1 (KAC1)",
        "sstart" : 717,
        "qstart" : 156,
        "qcovhsp" : 26,
        "shared_name" : "SpCluster-17391.0",
        "ppos" : 52.75,
        "score" : 656,
        "pident" : 31.886,
        "SUID" : 17859,
        "selected" : false,
        "sseqid" : "AT5G10470",
        "length" : 599,
        "nident" : 191,
        "evalue" : 1.68E-72,
        "positive" : 316,
        "gaps" : 60,
        "Type" : "protein_coding",
        "bitscore" : 257.0,
        "slen" : 1273,
        "mismatch" : 348,
        "name" : "SpCluster-17391.0",
        "send" : 1273,
        "qcovs" : 78,
        "PrimarySymbol" : "KINESIN LIKE PROTEIN FOR ACTIN BASED CHLOROPLAST MOVEMENT 1 (KAC1)",
        "qend" : 1898
      },
      "position" : {
        "x" : 1493.4024658203125,
        "y" : -2395.360419734416
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17123",
        "degree_layout" : 4,
        "Description" : "\"Helicase/SANT-associated, DNA binding protein;(source:Araport11)\"",
        "SecondarySymbol" : "(ATEAF1B)",
        "sstart" : 535,
        "qstart" : 1864,
        "qcovhsp" : 10,
        "shared_name" : "PpCluster-22672.4",
        "ppos" : 44.43,
        "score" : 551,
        "pident" : 29.208,
        "SUID" : 17123,
        "selected" : false,
        "sseqid" : "AT3G24870",
        "length" : 808,
        "nident" : 236,
        "evalue" : 5.71E-56,
        "positive" : 359,
        "gaps" : 146,
        "Type" : "protein_coding",
        "bitscore" : 216.0,
        "slen" : 1907,
        "mismatch" : 426,
        "name" : "PpCluster-22672.4",
        "send" : 1247,
        "qcovs" : 30,
        "PrimarySymbol" : "(ATEAF1B)",
        "qend" : 4134
      },
      "position" : {
        "x" : -499.7022705078125,
        "y" : -680.5116577148438
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17122",
        "degree_layout" : 3,
        "Description" : "AICARFT/IMPCHase bienzyme family protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 23,
        "qstart" : 2103,
        "qcovhsp" : 25,
        "shared_name" : "KfCluster-2098.0",
        "ppos" : 76.29,
        "score" : 2098,
        "pident" : 66.003,
        "SUID" : 17122,
        "selected" : false,
        "sseqid" : "AT2G35040",
        "length" : 603,
        "nident" : 398,
        "evalue" : 0.0,
        "positive" : 460,
        "gaps" : 30,
        "Type" : "protein_coding",
        "bitscore" : 812.0,
        "slen" : 596,
        "mismatch" : 175,
        "name" : "KfCluster-2098.0",
        "send" : 596,
        "qcovs" : 76,
        "PrimarySymbol" : "0",
        "qend" : 298
      },
      "position" : {
        "x" : -503.7918701171875,
        "y" : -820.3351440429688
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17121",
        "degree_layout" : 8,
        "Description" : "ATP dependent copper transporter vital for ethylene response pathway",
        "SecondarySymbol" : "(HMA7);RESPONSIVE-TO-ANTAGONIST 1 (RAN1)",
        "sstart" : 55,
        "qstart" : 423,
        "qcovhsp" : 23,
        "shared_name" : "SpCluster-11480.0",
        "ppos" : 65.97,
        "score" : 1752,
        "pident" : 46.56,
        "SUID" : 17121,
        "selected" : false,
        "sseqid" : "AT5G44790",
        "length" : 814,
        "nident" : 379,
        "evalue" : 0.0,
        "positive" : 537,
        "gaps" : 28,
        "Type" : "protein_coding",
        "bitscore" : 679.0,
        "slen" : 1001,
        "mismatch" : 407,
        "name" : "SpCluster-11480.0",
        "send" : 842,
        "qcovs" : 68,
        "PrimarySymbol" : "RESPONSIVE-TO-ANTAGONIST 1 (RAN1)",
        "qend" : 2858
      },
      "position" : {
        "x" : -739.7947998046875,
        "y" : -2829.0383327770464
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17120",
        "degree_layout" : 10,
        "Description" : "\"Arabidopsis-autoinhibited Ca2+ -ATPase, isoform 8, contains all of the characteristic motifs of Ca2+ -transporting P-type Ca2+ -ATPases and is localized to the plasma membrane.\"",
        "SecondarySymbol" : "\"AUTOINHIBITED CA2+ -ATPASE, ISOFORM 8 (ACA8);\"\"AUTOINHIBITED CA2+ -ATPASE, ISOFORM 8\"\" (AT-ACA8)\"",
        "sstart" : 50,
        "qstart" : 885,
        "qcovhsp" : 23,
        "shared_name" : "PpCluster-14206.0",
        "ppos" : 72.24,
        "score" : 2822,
        "pident" : 59.449,
        "SUID" : 17120,
        "selected" : false,
        "sseqid" : "AT5G57110",
        "length" : 1016,
        "nident" : 604,
        "evalue" : 0.0,
        "positive" : 734,
        "gaps" : 41,
        "Type" : "protein_coding",
        "bitscore" : 1091.0,
        "slen" : 1074,
        "mismatch" : 371,
        "name" : "PpCluster-14206.0",
        "send" : 1052,
        "qcovs" : 70,
        "PrimarySymbol" : "\"AUTOINHIBITED CA2+ -ATPASE, ISOFORM 8 (ACA8)\"",
        "qend" : 3848
      },
      "position" : {
        "x" : -729.335693359375,
        "y" : -2701.4348171520464
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17119",
        "degree_layout" : 3,
        "Description" : "ATPase E1-E2 type family protein / haloacid dehalogenase-like hydrolase family protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 1,
        "qstart" : 1076,
        "qcovhsp" : 22,
        "shared_name" : "PpCluster-14136.0",
        "ppos" : 75.77,
        "score" : 4012,
        "pident" : 61.632,
        "SUID" : 17119,
        "selected" : false,
        "sseqid" : "AT1G17500",
        "length" : 1238,
        "nident" : 763,
        "evalue" : 0.0,
        "positive" : 938,
        "gaps" : 30,
        "Type" : "protein_coding",
        "bitscore" : 1550.0,
        "slen" : 1216,
        "mismatch" : 445,
        "name" : "PpCluster-14136.0",
        "send" : 1213,
        "qcovs" : 65,
        "PrimarySymbol" : "0",
        "qend" : 4774
      },
      "position" : {
        "x" : -792.3975830078125,
        "y" : -2786.7316921520464
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17118",
        "degree_layout" : 8,
        "Description" : "H[+]-ATPase 11;(source:Araport11)",
        "SecondarySymbol" : "H(+)-ATPASE 11 (AHA11);H(+)-ATPASE 11 (HA11)",
        "sstart" : 35,
        "qstart" : 458,
        "qcovhsp" : 27,
        "shared_name" : "KfCluster-9542.0",
        "ppos" : 63.45,
        "score" : 1076,
        "pident" : 44.122,
        "SUID" : 17118,
        "selected" : false,
        "sseqid" : "AT5G62670",
        "length" : 621,
        "nident" : 274,
        "evalue" : 1.98E-133,
        "positive" : 394,
        "gaps" : 32,
        "Type" : "protein_coding",
        "bitscore" : 419.0,
        "slen" : 956,
        "mismatch" : 315,
        "name" : "KfCluster-9542.0",
        "send" : 645,
        "qcovs" : 80,
        "PrimarySymbol" : "H(+)-ATPASE 11 (HA11)",
        "qend" : 2254
      },
      "position" : {
        "x" : -649.897216796875,
        "y" : -2814.4831569957964
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17117",
        "degree_layout" : 1,
        "Description" : "Encodes a novel plant specific protein that is co-expressed with components of pre-rRNA processing complex. Co-localizes with NuGWD1 and SWA1.",
        "SecondarySymbol" : "LANT-SPECIFIC COMPONENT OF THE PRE- RRNA PROCESSING COMPLEX1 (PCP1)",
        "sstart" : 100,
        "qstart" : 159,
        "qcovhsp" : 10,
        "shared_name" : "KfCluster-8038.0",
        "ppos" : 60.0,
        "score" : 139,
        "pident" : 35.833,
        "SUID" : 17117,
        "selected" : false,
        "sseqid" : "AT1G15420",
        "length" : 120,
        "nident" : 43,
        "evalue" : 2.45E-9,
        "positive" : 72,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 58.2,
        "slen" : 278,
        "mismatch" : 77,
        "name" : "KfCluster-8038.0",
        "send" : 219,
        "qcovs" : 31,
        "PrimarySymbol" : "LANT-SPECIFIC COMPONENT OF THE PRE- RRNA PROCESSING COMPLEX1 (PCP1)",
        "qend" : 518
      },
      "position" : {
        "x" : -703.620849609375,
        "y" : -2896.7673366832964
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17116",
        "degree_layout" : 5,
        "Description" : "\"Arabidopsis-autoinhibited Ca2+ -ATPase, isoform 8, contains all of the characteristic motifs of Ca2+ -transporting P-type Ca2+ -ATPases and is localized to the plasma membrane.\"",
        "SecondarySymbol" : "\"AUTOINHIBITED CA2+ -ATPASE, ISOFORM 8 (ACA8);\"\"AUTOINHIBITED CA2+ -ATPASE, ISOFORM 8\"\" (AT-ACA8)\"",
        "sstart" : 820,
        "qstart" : 614,
        "qcovhsp" : 14,
        "shared_name" : "KfCluster-29492.0",
        "ppos" : 73.17,
        "score" : 660,
        "pident" : 54.472,
        "SUID" : 17116,
        "selected" : false,
        "sseqid" : "AT5G57110",
        "length" : 246,
        "nident" : 134,
        "evalue" : 5.5E-75,
        "positive" : 180,
        "gaps" : 8,
        "Type" : "protein_coding",
        "bitscore" : 258.0,
        "slen" : 1074,
        "mismatch" : 104,
        "name" : "KfCluster-29492.0",
        "send" : 1057,
        "qcovs" : 42,
        "PrimarySymbol" : "\"AUTOINHIBITED CA2+ -ATPASE, ISOFORM 8 (ACA8)\"",
        "qend" : 1351
      },
      "position" : {
        "x" : -606.2692260742188,
        "y" : -2747.3830593395464
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17115",
        "degree_layout" : 12,
        "Description" : "\"Type IIA (SERCA-type) Ca2+ ATPase, catalyzes the efflux of calcium from the cytoplasm.\"",
        "SecondarySymbol" : "ARABIDOPSIS THALIANA ER-TYPE CA2+-ATPASE 2 (ATECA2);ER-TYPE CA2+-ATPASE 2 (ECA2)",
        "sstart" : 6,
        "qstart" : 141,
        "qcovhsp" : 29,
        "shared_name" : "KfCluster-20932.0",
        "ppos" : 77.12,
        "score" : 3257,
        "pident" : 65.865,
        "SUID" : 17115,
        "selected" : false,
        "sseqid" : "AT4G00900",
        "length" : 1040,
        "nident" : 685,
        "evalue" : 0.0,
        "positive" : 802,
        "gaps" : 19,
        "Type" : "protein_coding",
        "bitscore" : 1259.0,
        "slen" : 1054,
        "mismatch" : 336,
        "name" : "KfCluster-20932.0",
        "send" : 1040,
        "qcovs" : 88,
        "PrimarySymbol" : "ER-TYPE CA2+-ATPASE 2 (ECA2)",
        "qend" : 3218
      },
      "position" : {
        "x" : -680.59326171875,
        "y" : -2747.7893093395464
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17114",
        "Description" : "Dihydroxyacetone kinase;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 220,
        "qstart" : 1,
        "qcovhsp" : 3,
        "shared_name" : "PpCluster-825.4",
        "ppos" : 83.97,
        "score" : 492,
        "pident" : 68.702,
        "SUID" : 17114,
        "selected" : false,
        "sseqid" : "AT1G48430",
        "length" : 131,
        "nident" : 90,
        "evalue" : 5.07E-52,
        "positive" : 110,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 194.0,
        "slen" : 593,
        "mismatch" : 41,
        "name" : "PpCluster-825.4",
        "send" : 350,
        "qcovs" : 10,
        "PrimarySymbol" : "0",
        "qend" : 393
      },
      "position" : {
        "x" : -2270.218486729339,
        "y" : -2825.105712890625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17113",
        "Description" : "Dihydroxyacetone kinase;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 369,
        "qstart" : 81,
        "qcovhsp" : 2,
        "shared_name" : "MpCluster-24664.0",
        "ppos" : 76.79,
        "score" : 173,
        "pident" : 55.357,
        "SUID" : 17113,
        "selected" : false,
        "sseqid" : "AT3G17770",
        "length" : 56,
        "nident" : 31,
        "evalue" : 1.56E-12,
        "positive" : 43,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 71.2,
        "slen" : 595,
        "mismatch" : 25,
        "name" : "MpCluster-24664.0",
        "send" : 424,
        "qcovs" : 7,
        "PrimarySymbol" : "0",
        "qend" : 248
      },
      "position" : {
        "x" : -2251.645000401214,
        "y" : -2927.54296875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17112",
        "Description" : "Dihydroxyacetone kinase;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 4,
        "qstart" : 2708,
        "qcovhsp" : 16,
        "shared_name" : "KfCluster-20907.0",
        "ppos" : 80.51,
        "score" : 1653,
        "pident" : 65.938,
        "SUID" : 17112,
        "selected" : false,
        "sseqid" : "AT3G17770",
        "length" : 549,
        "nident" : 362,
        "evalue" : 0.0,
        "positive" : 442,
        "gaps" : 4,
        "Type" : "protein_coding",
        "bitscore" : 641.0,
        "slen" : 595,
        "mismatch" : 183,
        "name" : "KfCluster-20907.0",
        "send" : 552,
        "qcovs" : 47,
        "PrimarySymbol" : "0",
        "qend" : 1074
      },
      "position" : {
        "x" : -2172.237773838714,
        "y" : -2860.243408203125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17111",
        "degree_layout" : 1,
        "Description" : "L-Aspartase-like family protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 281,
        "qstart" : 959,
        "qcovhsp" : 9,
        "shared_name" : "KfCluster-20830.0",
        "ppos" : 85.41,
        "score" : 942,
        "pident" : 72.532,
        "SUID" : 17111,
        "selected" : false,
        "sseqid" : "AT5G10920",
        "length" : 233,
        "nident" : 169,
        "evalue" : 2.38E-117,
        "positive" : 199,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 367.0,
        "slen" : 517,
        "mismatch" : 64,
        "name" : "KfCluster-20830.0",
        "send" : 513,
        "qcovs" : 26,
        "PrimarySymbol" : "0",
        "qend" : 261
      },
      "position" : {
        "x" : -246.9473876953125,
        "y" : -1088.7039794921875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17108",
        "degree_layout" : 7,
        "Description" : "P-loop containing nucleoside triphosphate hydrolases superfamily protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 505,
        "qstart" : 2369,
        "qcovhsp" : 15,
        "shared_name" : "PpCluster-25749.0",
        "ppos" : 66.07,
        "score" : 1463,
        "pident" : 48.0,
        "SUID" : 17108,
        "selected" : false,
        "sseqid" : "AT1G06720",
        "length" : 675,
        "nident" : 324,
        "evalue" : 8.69E-180,
        "positive" : 446,
        "gaps" : 67,
        "Type" : "protein_coding",
        "bitscore" : 568.0,
        "slen" : 1147,
        "mismatch" : 284,
        "name" : "PpCluster-25749.0",
        "send" : 1122,
        "qcovs" : 44,
        "PrimarySymbol" : "0",
        "qend" : 375
      },
      "position" : {
        "x" : -376.5460205078125,
        "y" : -943.9129638671875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17107",
        "degree_layout" : 5,
        "Description" : "Noc2p family;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 129,
        "qstart" : 3089,
        "qcovhsp" : 9,
        "shared_name" : "KfCluster-4808.1",
        "ppos" : 68.66,
        "score" : 1273,
        "pident" : 49.301,
        "SUID" : 17107,
        "selected" : false,
        "sseqid" : "AT2G18220",
        "length" : 501,
        "nident" : 247,
        "evalue" : 3.27E-155,
        "positive" : 344,
        "gaps" : 9,
        "Type" : "protein_coding",
        "bitscore" : 494.0,
        "slen" : 764,
        "mismatch" : 245,
        "name" : "KfCluster-4808.1",
        "send" : 622,
        "qcovs" : 28,
        "PrimarySymbol" : "0",
        "qend" : 4585
      },
      "position" : {
        "x" : -539.9785766601562,
        "y" : -1695.2650146484375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17106",
        "degree_layout" : 16,
        "Description" : "\"Serine/threonine protein kinase, whose transcription is regulated by circadian rhythm.\"",
        "SecondarySymbol" : "(ZIK4); (ATWNK1);WITH NO LYSINE (K) KINASE 1 (WNK1)",
        "sstart" : 10,
        "qstart" : 552,
        "qcovhsp" : 5,
        "shared_name" : "KfCluster-20791.0",
        "ppos" : 88.97,
        "score" : 1211,
        "pident" : 77.224,
        "SUID" : 17106,
        "selected" : false,
        "sseqid" : "AT3G04910",
        "length" : 281,
        "nident" : 217,
        "evalue" : 1.62E-146,
        "positive" : 250,
        "gaps" : 3,
        "Type" : "protein_coding",
        "bitscore" : 471.0,
        "slen" : 700,
        "mismatch" : 61,
        "name" : "KfCluster-20791.0",
        "send" : 287,
        "qcovs" : 15,
        "PrimarySymbol" : "WITH NO LYSINE (K) KINASE 1 (WNK1)",
        "qend" : 1394
      },
      "position" : {
        "x" : -448.5140380859375,
        "y" : -1603.53466796875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17105",
        "Description" : "Encodes a putative apoplastic peroxidase Prx37.  Primarily expressed in the vascular bundles.  Overexpression renders a dwarf phenotype with smaller plants and delayed development. Plants overexpressing Prx37 also shows an increase in the amount of esterified phenolic material associated with their walls.",
        "SecondarySymbol" : "PEROXIDASE 37 (Prx37)",
        "sstart" : 36,
        "qstart" : 2638,
        "qcovhsp" : 7,
        "shared_name" : "KfCluster-32529.0",
        "ppos" : 49.41,
        "score" : 332,
        "pident" : 35.968,
        "SUID" : 17105,
        "selected" : false,
        "sseqid" : "AT4G08770",
        "length" : 253,
        "nident" : 91,
        "evalue" : 2.34E-33,
        "positive" : 125,
        "gaps" : 23,
        "Type" : "protein_coding",
        "bitscore" : 132.0,
        "slen" : 346,
        "mismatch" : 139,
        "name" : "KfCluster-32529.0",
        "send" : 287,
        "qcovs" : 22,
        "PrimarySymbol" : "PEROXIDASE 37 (Prx37)",
        "qend" : 1946
      },
      "position" : {
        "x" : -2081.16015625,
        "y" : -3283.2435870067575
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17104",
        "Description" : "\"encodes a glutamine amidotransferase and cyclase, catalyzes the fifth and sixth steps of the histidine biosynthetic pathway\"",
        "SecondarySymbol" : "(HISN4);HIS HF (AT-HF)",
        "sstart" : 36,
        "qstart" : 667,
        "qcovhsp" : 17,
        "shared_name" : "KfCluster-2064.0",
        "ppos" : 79.51,
        "score" : 2002,
        "pident" : 64.583,
        "SUID" : 17104,
        "selected" : false,
        "sseqid" : "AT4G26900",
        "length" : 576,
        "nident" : 372,
        "evalue" : 0.0,
        "positive" : 458,
        "gaps" : 21,
        "Type" : "protein_coding",
        "bitscore" : 775.0,
        "slen" : 592,
        "mismatch" : 183,
        "name" : "KfCluster-2064.0",
        "send" : 590,
        "qcovs" : 51,
        "PrimarySymbol" : "HIS HF (AT-HF)",
        "qend" : 2394
      },
      "position" : {
        "x" : -1980.82421875,
        "y" : -3217.0160479442575
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17103",
        "degree_layout" : 3,
        "Description" : "P-loop containing nucleoside triphosphate hydrolases superfamily protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 481,
        "qstart" : 1379,
        "qcovhsp" : 4,
        "shared_name" : "KfCluster-20534.0",
        "ppos" : 49.07,
        "score" : 76,
        "pident" : 29.63,
        "SUID" : 17103,
        "selected" : false,
        "sseqid" : "AT3G45850",
        "length" : 108,
        "nident" : 32,
        "evalue" : 0.78,
        "positive" : 53,
        "gaps" : 12,
        "Type" : "protein_coding",
        "bitscore" : 33.9,
        "slen" : 1058,
        "mismatch" : 64,
        "name" : "KfCluster-20534.0",
        "send" : 580,
        "qcovs" : 12,
        "PrimarySymbol" : "0",
        "qend" : 1068
      },
      "position" : {
        "x" : 749.8821411132812,
        "y" : -1446.1268310546875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17102",
        "degree_layout" : 2,
        "Description" : "S-adenosyl-L-methionine-dependent methyltransferases superfamily protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 53,
        "qstart" : 617,
        "qcovhsp" : 10,
        "shared_name" : "KfCluster-30878.0",
        "ppos" : 46.36,
        "score" : 71,
        "pident" : 30.909,
        "SUID" : 17102,
        "selected" : false,
        "sseqid" : "AT5G57300",
        "length" : 110,
        "nident" : 34,
        "evalue" : 0.43,
        "positive" : 51,
        "gaps" : 18,
        "Type" : "protein_coding",
        "bitscore" : 32.0,
        "slen" : 288,
        "mismatch" : 58,
        "name" : "KfCluster-30878.0",
        "send" : 161,
        "qcovs" : 31,
        "PrimarySymbol" : "0",
        "qend" : 895
      },
      "position" : {
        "x" : -749.9684448242188,
        "y" : -668.3607788085938
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17101",
        "degree_layout" : 2,
        "Description" : "#N/A",
        "SecondarySymbol" : "#N/A",
        "sstart" : 14,
        "qstart" : 584,
        "qcovhsp" : 5,
        "shared_name" : "KfCluster-2164.0",
        "ppos" : 53.33,
        "score" : 53,
        "pident" : 36.667,
        "SUID" : 17101,
        "selected" : false,
        "sseqid" : "AT2G38544",
        "length" : 30,
        "nident" : 11,
        "evalue" : 9.2,
        "positive" : 16,
        "gaps" : 0,
        "Type" : "#N/A",
        "bitscore" : 25.0,
        "slen" : 46,
        "mismatch" : 19,
        "name" : "KfCluster-2164.0",
        "send" : 43,
        "qcovs" : 14,
        "PrimarySymbol" : "#N/A",
        "qend" : 495
      },
      "position" : {
        "x" : -761.8131713867188,
        "y" : -720.9435424804688
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17100",
        "degree_layout" : 7,
        "Description" : "\"Mutant has increased seed ile, leu and val as well as his and arg.\"",
        "SecondarySymbol" : "0",
        "sstart" : 16,
        "qstart" : 1920,
        "qcovhsp" : 3,
        "shared_name" : "KfCluster-2040.0",
        "ppos" : 42.57,
        "score" : 74,
        "pident" : 23.762,
        "SUID" : 17100,
        "selected" : false,
        "sseqid" : "AT2G26800",
        "length" : 101,
        "nident" : 24,
        "evalue" : 1.2,
        "positive" : 43,
        "gaps" : 2,
        "Type" : "protein_coding",
        "bitscore" : 33.1,
        "slen" : 355,
        "mismatch" : 75,
        "name" : "KfCluster-2040.0",
        "send" : 115,
        "qcovs" : 9,
        "PrimarySymbol" : "0",
        "qend" : 1621
      },
      "position" : {
        "x" : -641.3081665039062,
        "y" : -749.6099853515625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17853",
        "degree_layout" : 1,
        "Description" : "",
        "SecondarySymbol" : "",
        "shared_name" : "SpCluster-9246.0",
        "SUID" : 17853,
        "selected" : false,
        "sseqid" : "",
        "Type" : "",
        "name" : "SpCluster-9246.0",
        "PrimarySymbol" : ""
      },
      "position" : {
        "x" : -867.9966430664062,
        "y" : -1334.2440185546875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17852",
        "degree_layout" : 1,
        "Description" : "",
        "SecondarySymbol" : "",
        "shared_name" : "SpCluster-16457.0",
        "SUID" : 17852,
        "selected" : false,
        "sseqid" : "",
        "Type" : "",
        "name" : "SpCluster-16457.0",
        "PrimarySymbol" : ""
      },
      "position" : {
        "x" : -960.0753784179688,
        "y" : -1267.5386962890625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17851",
        "degree_layout" : 1,
        "Description" : "elongation factor Ts family protein;(source:Araport11)",
        "SecondarySymbol" : "EMBRYO DEFECTIVE 2726 (emb2726)",
        "sstart" : 143,
        "qstart" : 1523,
        "qcovhsp" : 1,
        "shared_name" : "PpCluster-9854.0",
        "ppos" : 75.0,
        "score" : 92,
        "pident" : 56.25,
        "SUID" : 17851,
        "selected" : false,
        "sseqid" : "AT4G29060",
        "length" : 32,
        "nident" : 18,
        "evalue" : 0.01,
        "positive" : 24,
        "gaps" : 1,
        "Type" : "protein_coding",
        "bitscore" : 40.0,
        "slen" : 709,
        "mismatch" : 13,
        "name" : "PpCluster-9854.0",
        "send" : 173,
        "qcovs" : 3,
        "PrimarySymbol" : "EMBRYO DEFECTIVE 2726 (emb2726)",
        "qend" : 1428
      },
      "position" : {
        "x" : -919.3388061523438,
        "y" : -1225.1112060546875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17094",
        "degree_layout" : 5,
        "Description" : "Encodes a plastid-localized &#945;-amylase. Expression is reduced in the SEX4 mutant. Loss of function mutations show normal diurnal pattern of starch accumulation/degradation.  Expression follows circadian rhythms.",
        "SecondarySymbol" : "ALPHA-AMYLASE-LIKE 3 (AMY3);ALPHA-AMYLASE-LIKE 3 (ATAMY3)",
        "sstart" : 481,
        "qstart" : 2026,
        "qcovhsp" : 11,
        "shared_name" : "SpCluster-5363.0",
        "ppos" : 75.61,
        "score" : 1382,
        "pident" : 60.732,
        "SUID" : 17094,
        "selected" : false,
        "sseqid" : "AT1G69830",
        "length" : 410,
        "nident" : 249,
        "evalue" : 6.7E-174,
        "positive" : 310,
        "gaps" : 7,
        "Type" : "protein_coding",
        "bitscore" : 536.0,
        "slen" : 887,
        "mismatch" : 154,
        "name" : "SpCluster-5363.0",
        "send" : 885,
        "qcovs" : 34,
        "PrimarySymbol" : "ALPHA-AMYLASE-LIKE 3 (AMY3)",
        "qend" : 3249
      },
      "position" : {
        "x" : 1099.875244140625,
        "y" : -1713.2244873046875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17850",
        "degree_layout" : 5,
        "Description" : "\"Encodes a subunit of the polyadenylation apparatus that interacts with and stimulates the activity of poly(A) polymerase.  Additionally , it interacts with several polyadenylation factor subunits and is an RNA-binding protein.  It is suggested that this protein coordinates a number of polyadenylation factor subunits with PAP and with RNA. The mRNA is cell-to-cell mobile.\"",
        "SecondarySymbol" : "HOMOLOG OF YEAST FIP1 [V] (ATFIP1[V]);HOMOLOG OF YEAST FIP1 [V] (FIP1[V]); (ATFIPS5); (FIPS5)",
        "sstart" : 1040,
        "qstart" : 1601,
        "qcovhsp" : 1,
        "shared_name" : "PpCluster-5117.1",
        "ppos" : 72.41,
        "score" : 66,
        "pident" : 51.724,
        "SUID" : 17850,
        "selected" : false,
        "sseqid" : "AT5G58040",
        "length" : 29,
        "nident" : 15,
        "evalue" : 9.1,
        "positive" : 21,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 30.0,
        "slen" : 1196,
        "mismatch" : 14,
        "name" : "PpCluster-5117.1",
        "send" : 1068,
        "qcovs" : 4,
        "PrimarySymbol" : "HOMOLOG OF YEAST FIP1 [V] (FIP1[V])",
        "qend" : 1515
      },
      "position" : {
        "x" : -784.3462524414062,
        "y" : -1253.935546875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17093",
        "degree_layout" : 4,
        "Description" : "RNA binding (RRM/RBD/RNP motifs) family protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 5,
        "qstart" : 237,
        "qcovhsp" : 9,
        "shared_name" : "PpCluster-15522.1",
        "ppos" : 66.67,
        "score" : 438,
        "pident" : 45.887,
        "SUID" : 17093,
        "selected" : false,
        "sseqid" : "AT5G32450",
        "length" : 231,
        "nident" : 106,
        "evalue" : 1.7E-48,
        "positive" : 154,
        "gaps" : 18,
        "Type" : "protein_coding",
        "bitscore" : 173.0,
        "slen" : 267,
        "mismatch" : 107,
        "name" : "PpCluster-15522.1",
        "send" : 228,
        "qcovs" : 26,
        "PrimarySymbol" : "0",
        "qend" : 896
      },
      "position" : {
        "x" : 1236.98779296875,
        "y" : -1796.554443359375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17092",
        "degree_layout" : 4,
        "Description" : "Encodes a plastid-localized &#945;-amylase. Expression is reduced in the SEX4 mutant. Loss of function mutations show normal diurnal pattern of starch accumulation/degradation.  Expression follows circadian rhythms.",
        "SecondarySymbol" : "ALPHA-AMYLASE-LIKE 3 (AMY3);ALPHA-AMYLASE-LIKE 3 (ATAMY3)",
        "sstart" : 575,
        "qstart" : 1542,
        "qcovhsp" : 11,
        "shared_name" : "KfCluster-20176.0",
        "ppos" : 78.16,
        "score" : 1085,
        "pident" : 62.975,
        "SUID" : 17092,
        "selected" : false,
        "sseqid" : "AT1G69830",
        "length" : 316,
        "nident" : 199,
        "evalue" : 3.72E-133,
        "positive" : 247,
        "gaps" : 6,
        "Type" : "protein_coding",
        "bitscore" : 422.0,
        "slen" : 887,
        "mismatch" : 111,
        "name" : "KfCluster-20176.0",
        "send" : 885,
        "qcovs" : 33,
        "PrimarySymbol" : "ALPHA-AMYLASE-LIKE 3 (AMY3)",
        "qend" : 598
      },
      "position" : {
        "x" : 1224.7630615234375,
        "y" : -1708.046142578125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17091",
        "degree_layout" : 2,
        "Description" : "Glycosyltransferase family 61 protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 166,
        "qstart" : 282,
        "qcovhsp" : 22,
        "shared_name" : "SpCluster-16637.0",
        "ppos" : 63.11,
        "score" : 744,
        "pident" : 44.512,
        "SUID" : 17091,
        "selected" : false,
        "sseqid" : "AT2G41640",
        "length" : 328,
        "nident" : 146,
        "evalue" : 1.09E-92,
        "positive" : 207,
        "gaps" : 6,
        "Type" : "protein_coding",
        "bitscore" : 291.0,
        "slen" : 500,
        "mismatch" : 176,
        "name" : "SpCluster-16637.0",
        "send" : 489,
        "qcovs" : 65,
        "PrimarySymbol" : "0",
        "qend" : 1259
      },
      "position" : {
        "x" : -733.5709838867188,
        "y" : -924.9149780273438
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17090",
        "degree_layout" : 3,
        "Description" : "MUCI21 is a GT61 protein required for the production of highly branched xylan in seed coat mucilage. MUCI21 likely decorates xylan with xylose side chains that seem to be necessary for pectin attachment to the seed surface.",
        "SecondarySymbol" : "MUCILAGE-MODIFIED 5 (MUM5); (MUM5);MUCILAGE-RELATED 21 (MUCI21)",
        "sstart" : 66,
        "qstart" : 1701,
        "qcovhsp" : 7,
        "shared_name" : "KfCluster-20158.0",
        "ppos" : 49.55,
        "score" : 246,
        "pident" : 29.091,
        "SUID" : 17090,
        "selected" : false,
        "sseqid" : "AT3G10320",
        "length" : 220,
        "nident" : 64,
        "evalue" : 1.72E-21,
        "positive" : 109,
        "gaps" : 21,
        "Type" : "protein_coding",
        "bitscore" : 99.4,
        "slen" : 494,
        "mismatch" : 135,
        "name" : "KfCluster-20158.0",
        "send" : 275,
        "qcovs" : 22,
        "PrimarySymbol" : "MUCILAGE-RELATED 21 (MUCI21)",
        "qend" : 1075
      },
      "position" : {
        "x" : -630.9752197265625,
        "y" : -1013.13232421875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17089",
        "degree_layout" : 8,
        "Description" : "Encodes one of four Arabidopsis phosphoenolpyruvate carboxylase proteins.PPC1 and PPC2 are crucial for balancing carbon and nitrogen metabolism.",
        "SecondarySymbol" : "PHOSPHOENOLPYRUVATE CARBOXYLASE 2 (PPC2);PHOSPHOENOLPYRUVATE CARBOXYLASE 2 (ATPPC2)",
        "sstart" : 23,
        "qstart" : 235,
        "qcovhsp" : 18,
        "shared_name" : "SpCluster-13155.0",
        "ppos" : 82.77,
        "score" : 3445,
        "pident" : 68.191,
        "SUID" : 17089,
        "selected" : false,
        "sseqid" : "AT2G42600",
        "length" : 940,
        "nident" : 641,
        "evalue" : 0.0,
        "positive" : 778,
        "gaps" : 6,
        "Type" : "protein_coding",
        "bitscore" : 1331.0,
        "slen" : 963,
        "mismatch" : 293,
        "name" : "SpCluster-13155.0",
        "send" : 961,
        "qcovs" : 55,
        "PrimarySymbol" : "PHOSPHOENOLPYRUVATE CARBOXYLASE 2 (PPC2)",
        "qend" : 3039
      },
      "position" : {
        "x" : -404.12828700467816,
        "y" : 257.546142578125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17088",
        "degree_layout" : 8,
        "Description" : "Encodes one of four Arabidopsis phosphoenolpyruvate carboxylase proteins.Plays an important role in carbon and nitrogen metabolism.",
        "SecondarySymbol" : "PHOSPHOENOLPYRUVATE CARBOXYLASE 1 (PPC1); (ATPEPC1);PHOSPHOENOLPYRUVATE CARBOXYLASE 1 (ATPPC1);PEP(PHOSPHOENOLPYRUVATE) CARBOXYLASE 1 (PEPC1)",
        "sstart" : 6,
        "qstart" : 3368,
        "qcovhsp" : 25,
        "shared_name" : "PpCluster-24083.0",
        "ppos" : 82.53,
        "score" : 3796,
        "pident" : 72.031,
        "SUID" : 17088,
        "selected" : false,
        "sseqid" : "AT1G53310",
        "length" : 1019,
        "nident" : 734,
        "evalue" : 0.0,
        "positive" : 841,
        "gaps" : 65,
        "Type" : "protein_coding",
        "bitscore" : 1466.0,
        "slen" : 967,
        "mismatch" : 220,
        "name" : "PpCluster-24083.0",
        "send" : 967,
        "qcovs" : 76,
        "PrimarySymbol" : "PHOSPHOENOLPYRUVATE CARBOXYLASE 1 (PPC1)",
        "qend" : 336
      },
      "position" : {
        "x" : -289.7298800222563,
        "y" : 286.87371826171875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17087",
        "degree_layout" : 8,
        "Description" : "Encodes one of four Arabidopsis phosphoenolpyruvate carboxylase proteins.PPC1 and PPC2 are crucial for balancing carbon and nitrogen metabolism.",
        "SecondarySymbol" : "PHOSPHOENOLPYRUVATE CARBOXYLASE 2 (PPC2);PHOSPHOENOLPYRUVATE CARBOXYLASE 2 (ATPPC2)",
        "sstart" : 24,
        "qstart" : 3328,
        "qcovhsp" : 20,
        "shared_name" : "KfCluster-25806.0",
        "ppos" : 48.4,
        "score" : 907,
        "pident" : 31.45,
        "SUID" : 17087,
        "selected" : false,
        "sseqid" : "AT2G42600",
        "length" : 938,
        "nident" : 295,
        "evalue" : 2.6E-103,
        "positive" : 454,
        "gaps" : 82,
        "Type" : "protein_coding",
        "bitscore" : 353.0,
        "slen" : 963,
        "mismatch" : 561,
        "name" : "KfCluster-25806.0",
        "send" : 898,
        "qcovs" : 60,
        "PrimarySymbol" : "PHOSPHOENOLPYRUVATE CARBOXYLASE 2 (PPC2)",
        "qend" : 572
      },
      "position" : {
        "x" : -360.27843348905316,
        "y" : 313.18133544921875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17086",
        "degree_layout" : 8,
        "Description" : "Encodes one of four Arabidopsis phosphoenolpyruvate carboxylase proteins.PPC1 and PPC2 are crucial for balancing carbon and nitrogen metabolism.",
        "SecondarySymbol" : "PHOSPHOENOLPYRUVATE CARBOXYLASE 2 (PPC2);PHOSPHOENOLPYRUVATE CARBOXYLASE 2 (ATPPC2)",
        "sstart" : 23,
        "qstart" : 258,
        "qcovhsp" : 28,
        "shared_name" : "KfCluster-2126.0",
        "ppos" : 78.64,
        "score" : 3136,
        "pident" : 63.037,
        "SUID" : 17086,
        "selected" : false,
        "sseqid" : "AT2G42600",
        "length" : 955,
        "nident" : 602,
        "evalue" : 0.0,
        "positive" : 751,
        "gaps" : 16,
        "Type" : "protein_coding",
        "bitscore" : 1212.0,
        "slen" : 963,
        "mismatch" : 337,
        "name" : "KfCluster-2126.0",
        "send" : 963,
        "qcovs" : 83,
        "PrimarySymbol" : "PHOSPHOENOLPYRUVATE CARBOXYLASE 2 (PPC2)",
        "qend" : 3116
      },
      "position" : {
        "x" : -301.61653773710003,
        "y" : 216.2709503173828
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17085",
        "degree_layout" : 9,
        "Description" : "\"Encodes one of four Arabidopsis phosphoenolpyruvate (PEP) carboxylase proteins. But, it is more similar to bacterial PEP carboxylase than plant PEP carboxylase. Efforts to express this enzyme and to demonstrate its enzymatic activity in E.coli failed.\"",
        "SecondarySymbol" : "PHOSPHOENOLPYRUVATE CARBOXYLASE 4 (PPC4);PHOSPHOENOLPYRUVATE CARBOXYLASE 4 (ATPPC4)",
        "sstart" : 447,
        "qstart" : 2520,
        "qcovhsp" : 12,
        "shared_name" : "KfCluster-20109.0",
        "ppos" : 81.29,
        "score" : 2023,
        "pident" : 65.136,
        "SUID" : 17085,
        "selected" : false,
        "sseqid" : "AT1G68750",
        "length" : 588,
        "nident" : 383,
        "evalue" : 0.0,
        "positive" : 478,
        "gaps" : 6,
        "Type" : "protein_coding",
        "bitscore" : 783.0,
        "slen" : 1032,
        "mismatch" : 199,
        "name" : "KfCluster-20109.0",
        "send" : 1032,
        "qcovs" : 36,
        "PrimarySymbol" : "PHOSPHOENOLPYRUVATE CARBOXYLASE 4 (PPC4)",
        "qend" : 4271
      },
      "position" : {
        "x" : -381.36473719999066,
        "y" : 167.58966064453125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17071",
        "degree_layout" : 10,
        "Description" : "\"Encodes a member of a plant-specific class of histone deacetylases. Controls the development of adaxial/abaxial leaf polarity. Its mRNA is widely expressed in stems, leaves, flowers and young siliques. Plant lines expressing RNAi constructs directed against this gene showed a marked reduction in agrobacterium-mediated root transformation.\"",
        "SecondarySymbol" : "HISTONE DEACETYLASE 2B (HD2B); (HDT02); (HDT2);ARABIDOPSIS HISTONE DEACETYLASE 2 (ATHD2); (HDA4);HISTONE DEACETYLASE 2 (HD2); (ATHD2B)",
        "sstart" : 3,
        "qstart" : 1518,
        "qcovhsp" : 6,
        "shared_name" : "SpCluster-3708.0",
        "ppos" : 53.26,
        "score" : 120,
        "pident" : 32.609,
        "SUID" : 17071,
        "selected" : false,
        "sseqid" : "AT5G22650",
        "length" : 92,
        "nident" : 30,
        "evalue" : 1.13E-6,
        "positive" : 49,
        "gaps" : 4,
        "Type" : "protein_coding",
        "bitscore" : 50.8,
        "slen" : 305,
        "mismatch" : 58,
        "name" : "SpCluster-3708.0",
        "send" : 91,
        "qcovs" : 17,
        "PrimarySymbol" : "HISTONE DEACETYLASE 2B (HD2B)",
        "qend" : 1246
      },
      "position" : {
        "x" : -55.96192169189453,
        "y" : -1656.0718994140625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17070",
        "degree_layout" : 6,
        "Description" : "Encodes a member of the FKBP-type immunophilin family that functions as a histone chaparone. Binds to 18S rDNA and represses its expression.",
        "SecondarySymbol" : "(ATFKBP53);FK506 BINDING PROTEIN 53 (FKBP53)",
        "sstart" : 367,
        "qstart" : 437,
        "qcovhsp" : 7,
        "shared_name" : "SpCluster-16464.0",
        "ppos" : 73.87,
        "score" : 384,
        "pident" : 61.261,
        "SUID" : 17070,
        "selected" : false,
        "sseqid" : "AT4G25340",
        "length" : 111,
        "nident" : 68,
        "evalue" : 1.91E-40,
        "positive" : 82,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 152.0,
        "slen" : 477,
        "mismatch" : 43,
        "name" : "SpCluster-16464.0",
        "send" : 477,
        "qcovs" : 21,
        "PrimarySymbol" : "FK506 BINDING PROTEIN 53 (FKBP53)",
        "qend" : 105
      },
      "position" : {
        "x" : -64.84114837646484,
        "y" : -1800.8251953125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17069",
        "degree_layout" : 6,
        "Description" : "Encodes a member of the FKBP-type immunophilin family that functions as a histone chaparone. Binds to 18S rDNA and represses its expression.",
        "SecondarySymbol" : "(ATFKBP53);FK506 BINDING PROTEIN 53 (FKBP53)",
        "sstart" : 364,
        "qstart" : 2103,
        "qcovhsp" : 4,
        "shared_name" : "KfCluster-28982.0",
        "ppos" : 82.46,
        "score" : 425,
        "pident" : 66.667,
        "SUID" : 17069,
        "selected" : false,
        "sseqid" : "AT4G25340",
        "length" : 114,
        "nident" : 76,
        "evalue" : 1.51E-44,
        "positive" : 94,
        "gaps" : 1,
        "Type" : "protein_coding",
        "bitscore" : 168.0,
        "slen" : 477,
        "mismatch" : 37,
        "name" : "KfCluster-28982.0",
        "send" : 477,
        "qcovs" : 12,
        "PrimarySymbol" : "FK506 BINDING PROTEIN 53 (FKBP53)",
        "qend" : 2441
      },
      "position" : {
        "x" : 16.18036651611328,
        "y" : -1741.1158447265625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17068",
        "degree_layout" : 6,
        "Description" : "\"Encodes a member of a plant-specific class of histone deacetylases. Controls the development of adaxial/abaxial leaf polarity. Its mRNA is widely expressed in stems, leaves, flowers and young siliques. Plant lines expressing RNAi constructs directed against this gene showed a marked reduction in agrobacterium-mediated root transformation.\"",
        "SecondarySymbol" : "HISTONE DEACETYLASE 2B (HD2B); (HDT02); (HDT2);ARABIDOPSIS HISTONE DEACETYLASE 2 (ATHD2); (HDA4);HISTONE DEACETYLASE 2 (HD2); (ATHD2B)",
        "sstart" : 1,
        "qstart" : 286,
        "qcovhsp" : 5,
        "shared_name" : "KfCluster-19976.0",
        "ppos" : 60.44,
        "score" : 194,
        "pident" : 40.659,
        "SUID" : 17068,
        "selected" : false,
        "sseqid" : "AT5G22650",
        "length" : 91,
        "nident" : 37,
        "evalue" : 6.03E-16,
        "positive" : 55,
        "gaps" : 1,
        "Type" : "protein_coding",
        "bitscore" : 79.3,
        "slen" : 305,
        "mismatch" : 53,
        "name" : "KfCluster-19976.0",
        "send" : 91,
        "qcovs" : 15,
        "PrimarySymbol" : "HISTONE DEACETYLASE 2B (HD2B)",
        "qend" : 555
      },
      "position" : {
        "x" : 4.068561553955078,
        "y" : -1819.3712158203125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17067",
        "degree_layout" : 12,
        "Description" : "Pentatricopeptide repeat (PPR-like) superfamily protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 101,
        "qstart" : 2141,
        "qcovhsp" : 12,
        "shared_name" : "SpCluster-9850.1",
        "ppos" : 39.89,
        "score" : 158,
        "pident" : 22.404,
        "SUID" : 17067,
        "selected" : false,
        "sseqid" : "AT3G04760",
        "length" : 366,
        "nident" : 82,
        "evalue" : 1.27E-10,
        "positive" : 146,
        "gaps" : 60,
        "Type" : "protein_coding",
        "bitscore" : 65.5,
        "slen" : 602,
        "mismatch" : 224,
        "name" : "SpCluster-9850.1",
        "send" : 437,
        "qcovs" : 36,
        "PrimarySymbol" : "0",
        "qend" : 1137
      },
      "position" : {
        "x" : -228.89483642578125,
        "y" : -1917.743896484375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17066",
        "degree_layout" : 2,
        "Description" : "",
        "SecondarySymbol" : "",
        "shared_name" : "SpCluster-10596.0",
        "SUID" : 17066,
        "selected" : false,
        "sseqid" : "",
        "Type" : "",
        "name" : "SpCluster-10596.0",
        "PrimarySymbol" : ""
      },
      "position" : {
        "x" : 337.776123046875,
        "y" : -1713.0797119140625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17065",
        "degree_layout" : 3,
        "Description" : "pre-mRNA-splicing factor of RES complex protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 348,
        "qstart" : 1150,
        "qcovhsp" : 10,
        "shared_name" : "SpCluster-13182.478",
        "ppos" : 71.63,
        "score" : 532,
        "pident" : 54.419,
        "SUID" : 17065,
        "selected" : false,
        "sseqid" : "AT1G31870",
        "length" : 215,
        "nident" : 117,
        "evalue" : 6.15E-59,
        "positive" : 154,
        "gaps" : 5,
        "Type" : "protein_coding",
        "bitscore" : 209.0,
        "slen" : 561,
        "mismatch" : 93,
        "name" : "SpCluster-13182.478",
        "send" : 561,
        "qcovs" : 29,
        "PrimarySymbol" : "0",
        "qend" : 518
      },
      "position" : {
        "x" : 314.2493896484375,
        "y" : -1672.17138671875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17064",
        "degree_layout" : 3,
        "Description" : "Fatty acid desaturase family protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 143,
        "qstart" : 1672,
        "qcovhsp" : 6,
        "shared_name" : "KfCluster-30874.0",
        "ppos" : 57.66,
        "score" : 333,
        "pident" : 35.586,
        "SUID" : 17064,
        "selected" : false,
        "sseqid" : "AT3G15870",
        "length" : 222,
        "nident" : 79,
        "evalue" : 2.83E-33,
        "positive" : 128,
        "gaps" : 7,
        "Type" : "protein_coding",
        "bitscore" : 132.0,
        "slen" : 361,
        "mismatch" : 136,
        "name" : "KfCluster-30874.0",
        "send" : 359,
        "qcovs" : 19,
        "PrimarySymbol" : "0",
        "qend" : 1013
      },
      "position" : {
        "x" : -50.505226135253906,
        "y" : -1481.8074951171875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17063",
        "degree_layout" : 3,
        "Description" : "Chloroplastic enzyme responsible for the synthesis of 16:1 fatty acids from galactolipids and sulpholipids. Uses ferredoxin as electron donor. The mRNA is cell-to-cell mobile.",
        "SecondarySymbol" : "FATTY ACID DESATURASE 5 (FAD5);FATTY ACID DESATURASE B (FADB); (ATADS3); (ADS3); (JB67)",
        "sstart" : 65,
        "qstart" : 1650,
        "qcovhsp" : 14,
        "shared_name" : "KfCluster-19935.0",
        "ppos" : 73.6,
        "score" : 992,
        "pident" : 60.726,
        "SUID" : 17063,
        "selected" : false,
        "sseqid" : "AT3G15850",
        "length" : 303,
        "nident" : 184,
        "evalue" : 1.2E-128,
        "positive" : 223,
        "gaps" : 3,
        "Type" : "protein_coding",
        "bitscore" : 386.0,
        "slen" : 371,
        "mismatch" : 116,
        "name" : "KfCluster-19935.0",
        "send" : 367,
        "qcovs" : 41,
        "PrimarySymbol" : "FATTY ACID DESATURASE 5 (FAD5)",
        "qend" : 751
      },
      "position" : {
        "x" : 90.94247436523438,
        "y" : -1604.8092041015625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17062",
        "degree_layout" : 2,
        "Description" : "Encodes a  chloroplast-localized protein that modulates cytoplasmic Ca2+ concentration and is crucial for proper stomatal regulation in response to elevations of external Ca2+. Phosphorylation of this protein is dependent on calcium.",
        "SecondarySymbol" : "CALCIUM SENSING RECEPTOR (CaS)",
        "sstart" : 69,
        "qstart" : 358,
        "qcovhsp" : 16,
        "shared_name" : "KfCluster-7580.0",
        "ppos" : 58.84,
        "score" : 364,
        "pident" : 37.299,
        "SUID" : 17062,
        "selected" : false,
        "sseqid" : "AT5G23060",
        "length" : 311,
        "nident" : 116,
        "evalue" : 9.44E-38,
        "positive" : 183,
        "gaps" : 12,
        "Type" : "protein_coding",
        "bitscore" : 144.0,
        "slen" : 387,
        "mismatch" : 183,
        "name" : "KfCluster-7580.0",
        "send" : 367,
        "qcovs" : 49,
        "PrimarySymbol" : "CALCIUM SENSING RECEPTOR (CaS)",
        "qend" : 1290
      },
      "position" : {
        "x" : 198.6036834716797,
        "y" : -1794.1270751953125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17061",
        "degree_layout" : 5,
        "Description" : "GCK domain-containing protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 84,
        "qstart" : 552,
        "qcovhsp" : 4,
        "shared_name" : "KfCluster-28147.1",
        "ppos" : 68.42,
        "score" : 170,
        "pident" : 50.877,
        "SUID" : 17061,
        "selected" : false,
        "sseqid" : "AT1G14060",
        "length" : 57,
        "nident" : 29,
        "evalue" : 6.53E-14,
        "positive" : 39,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 70.1,
        "slen" : 179,
        "mismatch" : 28,
        "name" : "KfCluster-28147.1",
        "send" : 140,
        "qcovs" : 11,
        "PrimarySymbol" : "0",
        "qend" : 722
      },
      "position" : {
        "x" : 378.36376953125,
        "y" : -1482.19970703125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17060",
        "degree_layout" : 6,
        "Description" : "\"hydroxyproline-rich glycoprotein family protein, contains a rhodanese homology domain. Required  for anchoring the FNR flavoenzyme to the thylakoid membranes  and sustaining high efficiency photosynthetic linear electron flow. The mRNA is cell-to-cell mobile.\"",
        "SecondarySymbol" : "THYLAKOID RHODANESE-LIKE (TROL)",
        "sstart" : 131,
        "qstart" : 1386,
        "qcovhsp" : 12,
        "shared_name" : "KfCluster-1997.0",
        "ppos" : 59.43,
        "score" : 388,
        "pident" : 40.984,
        "SUID" : 17060,
        "selected" : false,
        "sseqid" : "AT4G01050",
        "length" : 244,
        "nident" : 100,
        "evalue" : 2.33E-40,
        "positive" : 145,
        "gaps" : 13,
        "Type" : "protein_coding",
        "bitscore" : 154.0,
        "slen" : 466,
        "mismatch" : 131,
        "name" : "KfCluster-1997.0",
        "send" : 368,
        "qcovs" : 36,
        "PrimarySymbol" : "THYLAKOID RHODANESE-LIKE (TROL)",
        "qend" : 676
      },
      "position" : {
        "x" : 94.16006469726562,
        "y" : -1799.517578125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17845",
        "degree_layout" : 3,
        "Description" : "\"encodes a DNA mismatch repair homolog of human MutS gene, MSH6. There are four MutS genes in Arabidopsis, MSH2, MSH3, MSH6, and MSH7, which all act as heterodimers and bind to 51-mer duplexes. MSH2*MSH6 bound the (+T) substrate strongly, (T/G) well, and (+AAG) no better than it did a (T/A) homoduplex.\"",
        "SecondarySymbol" : "MUTS HOMOLOG 6 (MSH6);ARABIDOPSIS THALIANA MUTS HOMOLOG 6 (ATMSH6);MUTS HOMOLOG  6-1 (MSH6-1)",
        "sstart" : 120,
        "qstart" : 1175,
        "qcovhsp" : 4,
        "shared_name" : "SpCluster-13544.0",
        "ppos" : 55.74,
        "score" : 99,
        "pident" : 26.23,
        "SUID" : 17845,
        "selected" : false,
        "sseqid" : "AT4G02070",
        "length" : 61,
        "nident" : 16,
        "evalue" : 6.31E-4,
        "positive" : 34,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 42.7,
        "slen" : 1321,
        "mismatch" : 45,
        "name" : "SpCluster-13544.0",
        "send" : 180,
        "qcovs" : 13,
        "PrimarySymbol" : "MUTS HOMOLOG 6 (MSH6)",
        "qend" : 1357
      },
      "position" : {
        "x" : 766.0816650390625,
        "y" : -1010.47705078125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17059",
        "degree_layout" : 6,
        "Description" : "\"hydroxyproline-rich glycoprotein family protein, contains a rhodanese homology domain. Required  for anchoring the FNR flavoenzyme to the thylakoid membranes  and sustaining high efficiency photosynthetic linear electron flow. The mRNA is cell-to-cell mobile.\"",
        "SecondarySymbol" : "THYLAKOID RHODANESE-LIKE (TROL)",
        "sstart" : 95,
        "qstart" : 3876,
        "qcovhsp" : 4,
        "shared_name" : "KfCluster-19930.0",
        "ppos" : 53.98,
        "score" : 212,
        "pident" : 31.25,
        "SUID" : 17059,
        "selected" : false,
        "sseqid" : "AT4G01050",
        "length" : 176,
        "nident" : 55,
        "evalue" : 4.2E-17,
        "positive" : 95,
        "gaps" : 9,
        "Type" : "protein_coding",
        "bitscore" : 86.3,
        "slen" : 466,
        "mismatch" : 112,
        "name" : "KfCluster-19930.0",
        "send" : 267,
        "qcovs" : 11,
        "PrimarySymbol" : "THYLAKOID RHODANESE-LIKE (TROL)",
        "qend" : 3367
      },
      "position" : {
        "x" : 276.8873291015625,
        "y" : -1639.275390625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17844",
        "degree_layout" : 2,
        "Description" : "One of 5 PO76/PDS5 cohesion cofactor orthologs of Arabidopsis.",
        "SecondarySymbol" : "(ATPDS5A); (PDS5A); (PDS5)",
        "sstart" : 6,
        "qstart" : 430,
        "qcovhsp" : 16,
        "shared_name" : "PpCluster-4568.3",
        "ppos" : 64.68,
        "score" : 2195,
        "pident" : 42.844,
        "SUID" : 17844,
        "selected" : false,
        "sseqid" : "AT5G47690",
        "length" : 1090,
        "nident" : 467,
        "evalue" : 0.0,
        "positive" : 705,
        "gaps" : 18,
        "Type" : "protein_coding",
        "bitscore" : 850.0,
        "slen" : 1607,
        "mismatch" : 605,
        "name" : "PpCluster-4568.3",
        "send" : 1084,
        "qcovs" : 49,
        "PrimarySymbol" : "(PDS5A)",
        "qend" : 3678
      },
      "position" : {
        "x" : 978.19970703125,
        "y" : -764.1848754882812
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17843",
        "degree_layout" : 4,
        "Description" : "One of 5 PO76/PDS5 cohesion cofactor orthologs of Arabidopsis.",
        "SecondarySymbol" : "(ATPDS5A); (PDS5A); (PDS5)",
        "sstart" : 6,
        "qstart" : 430,
        "qcovhsp" : 15,
        "shared_name" : "PpCluster-4568.2",
        "ppos" : 64.11,
        "score" : 2168,
        "pident" : 42.831,
        "SUID" : 17843,
        "selected" : false,
        "sseqid" : "AT5G47690",
        "length" : 1095,
        "nident" : 469,
        "evalue" : 0.0,
        "positive" : 702,
        "gaps" : 14,
        "Type" : "protein_coding",
        "bitscore" : 839.0,
        "slen" : 1607,
        "mismatch" : 612,
        "name" : "PpCluster-4568.2",
        "send" : 1090,
        "qcovs" : 46,
        "PrimarySymbol" : "(PDS5A)",
        "qend" : 3702
      },
      "position" : {
        "x" : 875.6326293945312,
        "y" : -863.2399291992188
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17055",
        "degree_layout" : 28,
        "Description" : "RNA binding protein involved in the processing of chloroplast psbB-psbT-psbH-petB-petD transcript unit.",
        "SecondarySymbol" : "(CRM3);HIGH CHLOROPHYLL FLUORESCENCE 152 (HCF152)",
        "sstart" : 92,
        "qstart" : 1998,
        "qcovhsp" : 19,
        "shared_name" : "SpCluster-9724.0",
        "ppos" : 47.46,
        "score" : 784,
        "pident" : 30.261,
        "SUID" : 17055,
        "selected" : false,
        "sseqid" : "AT3G09650",
        "length" : 727,
        "nident" : 220,
        "evalue" : 5.35E-90,
        "positive" : 345,
        "gaps" : 138,
        "Type" : "protein_coding",
        "bitscore" : 306.0,
        "slen" : 778,
        "mismatch" : 369,
        "name" : "SpCluster-9724.0",
        "send" : 771,
        "qcovs" : 58,
        "PrimarySymbol" : "HIGH CHLOROPHYLL FLUORESCENCE 152 (HCF152)",
        "qend" : 91
      },
      "position" : {
        "x" : -406.76922607421875,
        "y" : -1909.3790283203125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17054",
        "degree_layout" : 31,
        "Description" : "Pentatricopeptide repeat (PPR) superfamily protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 356,
        "qstart" : 1904,
        "qcovhsp" : 17,
        "shared_name" : "SpCluster-9559.0",
        "ppos" : 59.51,
        "score" : 708,
        "pident" : 43.252,
        "SUID" : 17054,
        "selected" : false,
        "sseqid" : "AT1G18900",
        "length" : 326,
        "nident" : 141,
        "evalue" : 2.55E-82,
        "positive" : 194,
        "gaps" : 1,
        "Type" : "protein_coding",
        "bitscore" : 277.0,
        "slen" : 860,
        "mismatch" : 184,
        "name" : "SpCluster-9559.0",
        "send" : 681,
        "qcovs" : 51,
        "PrimarySymbol" : "0",
        "qend" : 930
      },
      "position" : {
        "x" : -369.0575256347656,
        "y" : -1962.126708984375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17053",
        "degree_layout" : 32,
        "Description" : "Pentatricopeptide repeat (PPR) superfamily protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 162,
        "qstart" : 1345,
        "qcovhsp" : 17,
        "shared_name" : "SpCluster-6557.0",
        "ppos" : 49.44,
        "score" : 662,
        "pident" : 27.536,
        "SUID" : 17053,
        "selected" : false,
        "sseqid" : "AT5G02860",
        "length" : 621,
        "nident" : 171,
        "evalue" : 1.08E-72,
        "positive" : 307,
        "gaps" : 17,
        "Type" : "protein_coding",
        "bitscore" : 259.0,
        "slen" : 819,
        "mismatch" : 433,
        "name" : "SpCluster-6557.0",
        "send" : 781,
        "qcovs" : 51,
        "PrimarySymbol" : "0",
        "qend" : 3159
      },
      "position" : {
        "x" : -404.9703063964844,
        "y" : -1961.27783203125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17052",
        "degree_layout" : 24,
        "Description" : "Pentatricopeptide repeat (PPR) superfamily protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 414,
        "qstart" : 1511,
        "qcovhsp" : 9,
        "shared_name" : "SpCluster-19065.0",
        "ppos" : 51.08,
        "score" : 227,
        "pident" : 27.419,
        "SUID" : 17052,
        "selected" : false,
        "sseqid" : "AT2G15630",
        "length" : 186,
        "nident" : 51,
        "evalue" : 3.11E-19,
        "positive" : 95,
        "gaps" : 1,
        "Type" : "protein_coding",
        "bitscore" : 92.0,
        "slen" : 627,
        "mismatch" : 134,
        "name" : "SpCluster-19065.0",
        "send" : 599,
        "qcovs" : 28,
        "PrimarySymbol" : "0",
        "qend" : 957
      },
      "position" : {
        "x" : -355.9831237792969,
        "y" : -1879.2498779296875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17051",
        "degree_layout" : 18,
        "Description" : "Tetratricopeptide repeat (TPR)-like superfamily protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 122,
        "qstart" : 1661,
        "qcovhsp" : 20,
        "shared_name" : "SpCluster-18546.0",
        "ppos" : 50.89,
        "score" : 500,
        "pident" : 26.839,
        "SUID" : 17051,
        "selected" : false,
        "sseqid" : "AT1G26460",
        "length" : 503,
        "nident" : 135,
        "evalue" : 9.57E-54,
        "positive" : 256,
        "gaps" : 32,
        "Type" : "protein_coding",
        "bitscore" : 197.0,
        "slen" : 630,
        "mismatch" : 336,
        "name" : "SpCluster-18546.0",
        "send" : 618,
        "qcovs" : 61,
        "PrimarySymbol" : "0",
        "qend" : 231
      },
      "position" : {
        "x" : -447.78076171875,
        "y" : -2018.677978515625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17050",
        "degree_layout" : 26,
        "Description" : "Pentatricopeptide repeat (PPR-like) superfamily protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 149,
        "qstart" : 536,
        "qcovhsp" : 9,
        "shared_name" : "SpCluster-18049.0",
        "ppos" : 49.3,
        "score" : 240,
        "pident" : 25.581,
        "SUID" : 17050,
        "selected" : false,
        "sseqid" : "AT1G19720",
        "length" : 215,
        "nident" : 55,
        "evalue" : 2.11E-20,
        "positive" : 106,
        "gaps" : 10,
        "Type" : "protein_coding",
        "bitscore" : 97.1,
        "slen" : 894,
        "mismatch" : 150,
        "name" : "SpCluster-18049.0",
        "send" : 353,
        "qcovs" : 26,
        "PrimarySymbol" : "0",
        "qend" : 1180
      },
      "position" : {
        "x" : -324.6800842285156,
        "y" : -1933.13916015625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17049",
        "degree_layout" : 22,
        "Description" : "Tetratricopeptide repeat (TPR)-like superfamily protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 592,
        "qstart" : 1164,
        "qcovhsp" : 27,
        "shared_name" : "SpCluster-16826.0",
        "ppos" : 51.83,
        "score" : 416,
        "pident" : 29.878,
        "SUID" : 17049,
        "selected" : false,
        "sseqid" : "AT4G30825",
        "length" : 328,
        "nident" : 98,
        "evalue" : 2.15E-44,
        "positive" : 170,
        "gaps" : 17,
        "Type" : "protein_coding",
        "bitscore" : 164.0,
        "slen" : 904,
        "mismatch" : 213,
        "name" : "SpCluster-16826.0",
        "send" : 903,
        "qcovs" : 82,
        "PrimarySymbol" : "0",
        "qend" : 184
      },
      "position" : {
        "x" : -490.3843994140625,
        "y" : -1904.966552734375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17048",
        "degree_layout" : 13,
        "Description" : "\"Encodes a protein that promotes splicing of type II introns. otp51 mutants fail to splice intron 2 of plastid ycf3 transcripts, a factor required for the assembly of Photosystem I. Therefore, homozygous otp51 mutants have profound photosynthetic defects and can only survive in sucrose-supplemented in vitro cultures under low light conditions. OTP51 may also be involved in splicing several other transcripts and precursor forms of the trnL, trnG, trnI, and trnA transcripts also accumulate in otp51 mutants. Although OTP51 shares some homology with DNA endonucleases, it lacks key catalytic residues suggesting that it does not participate in DNA cleavage.\"",
        "SecondarySymbol" : "ORGANELLE TRANSCRIPT PROCESSING 51 (OTP51)",
        "sstart" : 380,
        "qstart" : 1817,
        "qcovhsp" : 21,
        "shared_name" : "SpCluster-12742.0",
        "ppos" : 48.46,
        "score" : 433,
        "pident" : 29.736,
        "SUID" : 17048,
        "selected" : false,
        "sseqid" : "AT2G15820",
        "length" : 454,
        "nident" : 135,
        "evalue" : 9.81E-45,
        "positive" : 220,
        "gaps" : 64,
        "Type" : "protein_coding",
        "bitscore" : 171.0,
        "slen" : 849,
        "mismatch" : 255,
        "name" : "SpCluster-12742.0",
        "send" : 813,
        "qcovs" : 63,
        "PrimarySymbol" : "ORGANELLE TRANSCRIPT PROCESSING 51 (OTP51)",
        "qend" : 588
      },
      "position" : {
        "x" : -513.1058349609375,
        "y" : -1999.499267578125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17047",
        "degree_layout" : 20,
        "Description" : "Pentatricopeptide repeat (PPR) superfamily protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 50,
        "qstart" : 1941,
        "qcovhsp" : 13,
        "shared_name" : "PpCluster-19512.0",
        "ppos" : 53.33,
        "score" : 445,
        "pident" : 34.444,
        "SUID" : 17047,
        "selected" : false,
        "sseqid" : "AT3G42630",
        "length" : 360,
        "nident" : 124,
        "evalue" : 9.47E-48,
        "positive" : 192,
        "gaps" : 7,
        "Type" : "protein_coding",
        "bitscore" : 176.0,
        "slen" : 415,
        "mismatch" : 229,
        "name" : "PpCluster-19512.0",
        "send" : 403,
        "qcovs" : 38,
        "PrimarySymbol" : "0",
        "qend" : 865
      },
      "position" : {
        "x" : -418.2320861816406,
        "y" : -2017.2861328125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17046",
        "degree_layout" : 17,
        "Description" : "Encodes a pentatricopeptide  repeat protein required for 5' end processing of nad9 and cox3 mRNAs in mitochondria.",
        "SecondarySymbol" : "RNA PROCESSING FACTOR 2 (RPF2); (RPF2)",
        "sstart" : 380,
        "qstart" : 2912,
        "qcovhsp" : 6,
        "shared_name" : "KfCluster-28638.0",
        "ppos" : 50.0,
        "score" : 247,
        "pident" : 25.221,
        "SUID" : 17046,
        "selected" : false,
        "sseqid" : "AT1G62670",
        "length" : 226,
        "nident" : 57,
        "evalue" : 3.21E-21,
        "positive" : 113,
        "gaps" : 7,
        "Type" : "protein_coding",
        "bitscore" : 99.8,
        "slen" : 630,
        "mismatch" : 162,
        "name" : "KfCluster-28638.0",
        "send" : 601,
        "qcovs" : 19,
        "PrimarySymbol" : "RNA PROCESSING FACTOR 2 (RPF2)",
        "qend" : 2244
      },
      "position" : {
        "x" : -354.1968078613281,
        "y" : -1907.970947265625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17045",
        "degree_layout" : 28,
        "Description" : "Pentatricopeptide repeat (PPR) superfamily protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 141,
        "qstart" : 860,
        "qcovhsp" : 16,
        "shared_name" : "KfCluster-24929.0",
        "ppos" : 45.05,
        "score" : 488,
        "pident" : 23.762,
        "SUID" : 17045,
        "selected" : false,
        "sseqid" : "AT5G02860",
        "length" : 606,
        "nident" : 144,
        "evalue" : 2.75E-50,
        "positive" : 273,
        "gaps" : 52,
        "Type" : "protein_coding",
        "bitscore" : 192.0,
        "slen" : 819,
        "mismatch" : 410,
        "name" : "KfCluster-24929.0",
        "send" : 740,
        "qcovs" : 49,
        "PrimarySymbol" : "0",
        "qend" : 2539
      },
      "position" : {
        "x" : -459.1168212890625,
        "y" : -1950.2889404296875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17044",
        "degree_layout" : 26,
        "Description" : "protein kinase family protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 306,
        "qstart" : 2883,
        "qcovhsp" : 13,
        "shared_name" : "KfCluster-19649.0",
        "ppos" : 50.22,
        "score" : 534,
        "pident" : 29.646,
        "SUID" : 17044,
        "selected" : false,
        "sseqid" : "AT5G21222",
        "length" : 452,
        "nident" : 134,
        "evalue" : 4.48E-56,
        "positive" : 227,
        "gaps" : 45,
        "Type" : "protein_coding",
        "bitscore" : 210.0,
        "slen" : 831,
        "mismatch" : 273,
        "name" : "KfCluster-19649.0",
        "send" : 730,
        "qcovs" : 39,
        "PrimarySymbol" : "0",
        "qend" : 1582
      },
      "position" : {
        "x" : -449.68402099609375,
        "y" : -1902.7132568359375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17043",
        "degree_layout" : 2,
        "Description" : "glycine decarboxylase P-protein 1;(source:Araport11)",
        "SecondarySymbol" : "GLYCINE DECARBOXYLASE P-PROTEIN 1 (AtGLDP1);GLYCINE DECARBOXYLASE P-PROTEIN 1 (GLDP1)",
        "sstart" : 175,
        "qstart" : 6,
        "qcovhsp" : 33,
        "shared_name" : "KfCluster-19485.0",
        "ppos" : 85.1,
        "score" : 2791,
        "pident" : 75.209,
        "SUID" : 17043,
        "selected" : false,
        "sseqid" : "AT4G33010",
        "length" : 718,
        "nident" : 540,
        "evalue" : 0.0,
        "positive" : 611,
        "gaps" : 5,
        "Type" : "protein_coding",
        "bitscore" : 1079.0,
        "slen" : 976,
        "mismatch" : 173,
        "name" : "KfCluster-19485.0",
        "send" : 887,
        "qcovs" : 99,
        "PrimarySymbol" : "GLYCINE DECARBOXYLASE P-PROTEIN 1 (GLDP1)",
        "qend" : 2159
      },
      "position" : {
        "x" : -778.73974609375,
        "y" : -977.8636474609375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17042",
        "degree_layout" : 1,
        "Description" : "ribosomal RNA processing-like protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 23,
        "qstart" : 2996,
        "qcovhsp" : 6,
        "shared_name" : "KfCluster-19402.0",
        "ppos" : 56.6,
        "score" : 430,
        "pident" : 38.491,
        "SUID" : 17042,
        "selected" : false,
        "sseqid" : "AT5G20600",
        "length" : 265,
        "nident" : 102,
        "evalue" : 2.28E-44,
        "positive" : 150,
        "gaps" : 16,
        "Type" : "protein_coding",
        "bitscore" : 170.0,
        "slen" : 532,
        "mismatch" : 147,
        "name" : "KfCluster-19402.0",
        "send" : 286,
        "qcovs" : 18,
        "PrimarySymbol" : "0",
        "qend" : 2247
      },
      "position" : {
        "x" : -580.7616577148438,
        "y" : -1179.170654296875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17831",
        "degree_layout" : 6,
        "Description" : "Binds the carboxyl-terminal domain (CTD) of the largest subunit of RNA polymerase II and functions as a scaffold  for RNA processing machineries.",
        "SecondarySymbol" : "PRE-MRNA-PROCESSING PROTEIN 40C (PRP40C);PRE-MRNA-PROCESSING PROTEIN 40C (ATPRP40C)",
        "sstart" : 461,
        "qstart" : 1662,
        "qcovhsp" : 10,
        "shared_name" : "SpCluster-9271.0",
        "ppos" : 65.64,
        "score" : 589,
        "pident" : 39.944,
        "SUID" : 17831,
        "selected" : false,
        "sseqid" : "AT3G19840",
        "length" : 358,
        "nident" : 143,
        "evalue" : 3.72E-63,
        "positive" : 235,
        "gaps" : 3,
        "Type" : "protein_coding",
        "bitscore" : 231.0,
        "slen" : 835,
        "mismatch" : 212,
        "name" : "SpCluster-9271.0",
        "send" : 816,
        "qcovs" : 31,
        "PrimarySymbol" : "PRE-MRNA-PROCESSING PROTEIN 40C (PRP40C)",
        "qend" : 2732
      },
      "position" : {
        "x" : 178.58460998535156,
        "y" : -1112.4471435546875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17830",
        "degree_layout" : 6,
        "Description" : "Binds the carboxyl-terminal domain (CTD) of the largest subunit of RNA polymerase II and functions as a scaffold  for RNA processing machineries.",
        "SecondarySymbol" : "PRE-MRNA-PROCESSING PROTEIN 40A (PRP40A);PRE-MRNA-PROCESSING PROTEIN 40A (ATPRP40A)",
        "sstart" : 376,
        "qstart" : 1615,
        "qcovhsp" : 11,
        "shared_name" : "SpCluster-13222.0",
        "ppos" : 74.54,
        "score" : 795,
        "pident" : 53.009,
        "SUID" : 17830,
        "selected" : false,
        "sseqid" : "AT1G44910",
        "length" : 432,
        "nident" : 229,
        "evalue" : 2.5E-89,
        "positive" : 322,
        "gaps" : 4,
        "Type" : "protein_coding",
        "bitscore" : 310.0,
        "slen" : 926,
        "mismatch" : 199,
        "name" : "SpCluster-13222.0",
        "send" : 803,
        "qcovs" : 34,
        "PrimarySymbol" : "PRE-MRNA-PROCESSING PROTEIN 40A (PRP40A)",
        "qend" : 2910
      },
      "position" : {
        "x" : 60.18171691894531,
        "y" : -1093.52392578125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17829",
        "degree_layout" : 6,
        "Description" : "Binds the carboxyl-terminal domain (CTD) of the largest subunit of RNA polymerase II and functions as a scaffold  for RNA processing machineries.",
        "SecondarySymbol" : "PRE-MRNA-PROCESSING PROTEIN 40A (PRP40A);PRE-MRNA-PROCESSING PROTEIN 40A (ATPRP40A)",
        "sstart" : 156,
        "qstart" : 633,
        "qcovhsp" : 13,
        "shared_name" : "PpCluster-3507.2",
        "ppos" : 70.95,
        "score" : 1500,
        "pident" : 53.211,
        "SUID" : 17829,
        "selected" : false,
        "sseqid" : "AT1G44910",
        "length" : 654,
        "nident" : 348,
        "evalue" : 0.0,
        "positive" : 464,
        "gaps" : 34,
        "Type" : "protein_coding",
        "bitscore" : 582.0,
        "slen" : 958,
        "mismatch" : 272,
        "name" : "PpCluster-3507.2",
        "send" : 806,
        "qcovs" : 39,
        "PrimarySymbol" : "PRE-MRNA-PROCESSING PROTEIN 40A (PRP40A)",
        "qend" : 2501
      },
      "position" : {
        "x" : 133.58489990234375,
        "y" : -1056.540283203125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17828",
        "degree_layout" : 8,
        "Description" : "Binds the carboxyl-terminal domain (CTD) of the largest subunit of RNA polymerase II and functions as a scaffold  for RNA processing machineries.",
        "SecondarySymbol" : "PRE-MRNA-PROCESSING PROTEIN 40A (PRP40A);PRE-MRNA-PROCESSING PROTEIN 40A (ATPRP40A)",
        "sstart" : 187,
        "qstart" : 1047,
        "qcovhsp" : 10,
        "shared_name" : "PpCluster-3507.1",
        "ppos" : 69.22,
        "score" : 1302,
        "pident" : 53.915,
        "SUID" : 17828,
        "selected" : false,
        "sseqid" : "AT1G44910",
        "length" : 562,
        "nident" : 303,
        "evalue" : 2.74E-157,
        "positive" : 389,
        "gaps" : 51,
        "Type" : "protein_coding",
        "bitscore" : 506.0,
        "slen" : 926,
        "mismatch" : 208,
        "name" : "PpCluster-3507.1",
        "send" : 726,
        "qcovs" : 30,
        "PrimarySymbol" : "PRE-MRNA-PROCESSING PROTEIN 40A (PRP40A)",
        "qend" : 2645
      },
      "position" : {
        "x" : 90.01753997802734,
        "y" : -1191.8355712890625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17041",
        "degree_layout" : 2,
        "Description" : "hypothetical protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 698,
        "qstart" : 4646,
        "qcovhsp" : 2,
        "shared_name" : "KfCluster-19301.0",
        "ppos" : 51.89,
        "score" : 140,
        "pident" : 29.245,
        "SUID" : 17041,
        "selected" : false,
        "sseqid" : "AT1G54920",
        "length" : 106,
        "nident" : 31,
        "evalue" : 5.01E-8,
        "positive" : 55,
        "gaps" : 3,
        "Type" : "protein_coding",
        "bitscore" : 58.5,
        "slen" : 890,
        "mismatch" : 72,
        "name" : "KfCluster-19301.0",
        "send" : 801,
        "qcovs" : 5,
        "PrimarySymbol" : "0",
        "qend" : 4960
      },
      "position" : {
        "x" : 155.05422973632812,
        "y" : -1386.1629638671875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17827",
        "degree_layout" : 6,
        "Description" : "\"Transcription factor interacting with photoreceptors phyA and phyB. Forms a ternary complex in vitro with G-box element of the promoters of LHY, CCA1. Acts as a negative regulator of phyB signalling. It degrades rapidly after irradiation of dark grown seedlings in a process controlled by phytochromes. Does not play a  significant role in controlling light input and function of the circadian  clockwork. Binds to G- and E-boxes, but not to other ACEs. Binds to anthocyanin biosynthetic genes in a light- and HY5-independent fashion. PIF3 function as a transcriptional activator can be functionally and mechanistically separated from its role in repression of PhyB mediated processes.\"",
        "SecondarySymbol" : "PURPLE ACID PHOSPHATASE 3 (PAP3);PHYTOCHROME-ASSOCIATED PROTEIN 3 (PAP3);PHOTOCURRENT 1 (POC1);PHYTOCHROME INTERACTING FACTOR 3 (PIF3)",
        "sstart" : 270,
        "qstart" : 1641,
        "qcovhsp" : 3,
        "shared_name" : "PpCluster-2938.1",
        "ppos" : 66.97,
        "score" : 238,
        "pident" : 51.376,
        "SUID" : 17827,
        "selected" : false,
        "sseqid" : "AT1G09530",
        "length" : 109,
        "nident" : 56,
        "evalue" : 6.65E-23,
        "positive" : 73,
        "gaps" : 4,
        "Type" : "protein_coding",
        "bitscore" : 96.3,
        "slen" : 524,
        "mismatch" : 49,
        "name" : "PpCluster-2938.1",
        "send" : 376,
        "qcovs" : 8,
        "PrimarySymbol" : "PHYTOCHROME INTERACTING FACTOR 3 (PIF3)",
        "qend" : 1321
      },
      "position" : {
        "x" : 282.50604633228,
        "y" : -2570.0673828125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17030",
        "degree_layout" : 9,
        "Description" : "Homeodomain-like superfamily protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 4,
        "qstart" : 675,
        "qcovhsp" : 2,
        "shared_name" : "SpCluster-20029.1",
        "ppos" : 69.35,
        "score" : 154,
        "pident" : 46.774,
        "SUID" : 17030,
        "selected" : false,
        "sseqid" : "AT5G45580",
        "length" : 62,
        "nident" : 29,
        "evalue" : 9.93E-11,
        "positive" : 43,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 63.9,
        "slen" : 264,
        "mismatch" : 33,
        "name" : "SpCluster-20029.1",
        "send" : 65,
        "qcovs" : 5,
        "PrimarySymbol" : "0",
        "qend" : 860
      },
      "position" : {
        "x" : 784.11181640625,
        "y" : -1229.76123046875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17029",
        "degree_layout" : 10,
        "Description" : "\"Encodes BOA (BROTHER OF LUX ARRHYTHMO), a component of the circadian clock. The mRNA is cell-to-cell mobile.\"",
        "SecondarySymbol" : "BROTHER OF LUX ARRHYTHMO (BOA)",
        "sstart" : 126,
        "qstart" : 391,
        "qcovhsp" : 6,
        "shared_name" : "SpCluster-20011.0",
        "ppos" : 85.19,
        "score" : 312,
        "pident" : 71.605,
        "SUID" : 17029,
        "selected" : false,
        "sseqid" : "AT5G59570",
        "length" : 81,
        "nident" : 58,
        "evalue" : 1.43E-32,
        "positive" : 69,
        "gaps" : 5,
        "Type" : "protein_coding",
        "bitscore" : 124.0,
        "slen" : 298,
        "mismatch" : 18,
        "name" : "SpCluster-20011.0",
        "send" : 202,
        "qcovs" : 19,
        "PrimarySymbol" : "BROTHER OF LUX ARRHYTHMO (BOA)",
        "qend" : 152
      },
      "position" : {
        "x" : 1094.8076171875,
        "y" : -1302.121826171875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17028",
        "degree_layout" : 10,
        "Description" : "\"Encodes a myb family transcription factor with a single Myb DNA-binding domain (type SHAQKYF) that is unique to plants and is essential for circadian rhythms, specifically for transcriptional regulation within the circadian clock.   LUX is required for normal rhythmic expression of multiple clock outputs in both constant light and darkness.  It is coregulated with TOC1 and seems to be repressed by CCA1 and LHY by direct binding of these proteins to the evening element in the LUX promoter. The mRNA is cell-to-cell mobile.\"",
        "SecondarySymbol" : "PHYTOCLOCK 1 (PCL1)",
        "sstart" : 131,
        "qstart" : 1476,
        "qcovhsp" : 5,
        "shared_name" : "SpCluster-18006.0",
        "ppos" : 88.75,
        "score" : 354,
        "pident" : 82.5,
        "SUID" : 17028,
        "selected" : false,
        "sseqid" : "AT3G46640",
        "length" : 80,
        "nident" : 66,
        "evalue" : 3.18E-37,
        "positive" : 71,
        "gaps" : 1,
        "Type" : "protein_coding",
        "bitscore" : 140.0,
        "slen" : 324,
        "mismatch" : 13,
        "name" : "SpCluster-18006.0",
        "send" : 210,
        "qcovs" : 14,
        "PrimarySymbol" : "PHYTOCLOCK 1 (PCL1)",
        "qend" : 1712
      },
      "position" : {
        "x" : 1109.94873046875,
        "y" : -1348.447265625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17027",
        "degree_layout" : 5,
        "Description" : "Homeodomain-like superfamily protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 42,
        "qstart" : 2142,
        "qcovhsp" : 1,
        "shared_name" : "PpCluster-6983.1",
        "ppos" : 72.55,
        "score" : 157,
        "pident" : 60.784,
        "SUID" : 17027,
        "selected" : false,
        "sseqid" : "AT2G42660",
        "length" : 51,
        "nident" : 31,
        "evalue" : 5.54E-11,
        "positive" : 37,
        "gaps" : 1,
        "Type" : "protein_coding",
        "bitscore" : 65.1,
        "slen" : 255,
        "mismatch" : 19,
        "name" : "PpCluster-6983.1",
        "send" : 92,
        "qcovs" : 3,
        "PrimarySymbol" : "0",
        "qend" : 2291
      },
      "position" : {
        "x" : 920.2274780273438,
        "y" : -1138.7977294921875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17026",
        "degree_layout" : 9,
        "Description" : "\"Encodes an aldehyde oxidase. AAO2 does not appear to act on abscisic aldehyde in vitro but it is possible that it may function in abscisic acid biosynthesis when the activity of At2g27150 (AAO3), the primary abscisic aldehyde oxidase, is lost.\"",
        "SecondarySymbol" : "ALDEHYDE OXIDASE 2 (AAO2);ARABIDOPSIS THALIANA ALDEHYDE OXIDASE 3 (AtAO3);ARABIDOPSIS THALIANA ALDEHYDE OXIDASE 2 (atAO-2);ALDEHYDE OXIDASE GAMMA (AOgamma);ALDEHYDE OXIDASE 3 (AO3)",
        "sstart" : 3,
        "qstart" : 8905,
        "qcovhsp" : 15,
        "shared_name" : "PpCluster-24311.0",
        "ppos" : 60.14,
        "score" : 2542,
        "pident" : 41.951,
        "SUID" : 17026,
        "selected" : false,
        "sseqid" : "AT3G43600",
        "length" : 1435,
        "nident" : 602,
        "evalue" : 0.0,
        "positive" : 863,
        "gaps" : 147,
        "Type" : "protein_coding",
        "bitscore" : 983.0,
        "slen" : 1321,
        "mismatch" : 686,
        "name" : "PpCluster-24311.0",
        "send" : 1319,
        "qcovs" : 45,
        "PrimarySymbol" : "ALDEHYDE OXIDASE 2 (AAO2)",
        "qend" : 4688
      },
      "position" : {
        "x" : 1086.50634765625,
        "y" : -1203.637451171875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17025",
        "degree_layout" : 16,
        "Description" : "Homeodomain-like superfamily protein;(source:Araport11)",
        "SecondarySymbol" : "PHR1-LIKE 2 (PHL2)",
        "sstart" : 31,
        "qstart" : 575,
        "qcovhsp" : 5,
        "shared_name" : "PpCluster-13268.4",
        "ppos" : 75.66,
        "score" : 495,
        "pident" : 64.474,
        "SUID" : 17025,
        "selected" : false,
        "sseqid" : "AT3G24120",
        "length" : 152,
        "nident" : 98,
        "evalue" : 1.16E-55,
        "positive" : 115,
        "gaps" : 3,
        "Type" : "protein_coding",
        "bitscore" : 195.0,
        "slen" : 295,
        "mismatch" : 51,
        "name" : "PpCluster-13268.4",
        "send" : 182,
        "qcovs" : 15,
        "PrimarySymbol" : "PHR1-LIKE 2 (PHL2)",
        "qend" : 1021
      },
      "position" : {
        "x" : 990.63037109375,
        "y" : -1291.3179931640625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17024",
        "degree_layout" : 10,
        "Description" : "Homeodomain-like superfamily protein;(source:Araport11)",
        "SecondarySymbol" : "PHR1-LIKE 2 (PHL2)",
        "sstart" : 66,
        "qstart" : 1283,
        "qcovhsp" : 4,
        "shared_name" : "PpCluster-13268.1",
        "ppos" : 68.49,
        "score" : 371,
        "pident" : 53.425,
        "SUID" : 17024,
        "selected" : false,
        "sseqid" : "AT3G24120",
        "length" : 146,
        "nident" : 78,
        "evalue" : 4.72E-39,
        "positive" : 100,
        "gaps" : 4,
        "Type" : "protein_coding",
        "bitscore" : 147.0,
        "slen" : 295,
        "mismatch" : 64,
        "name" : "PpCluster-13268.1",
        "send" : 211,
        "qcovs" : 13,
        "PrimarySymbol" : "PHR1-LIKE 2 (PHL2)",
        "qend" : 858
      },
      "position" : {
        "x" : 952.13330078125,
        "y" : -1210.4482421875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17023",
        "degree_layout" : 12,
        "Description" : "myb-like HTH transcriptional regulator family protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 15,
        "qstart" : 2006,
        "qcovhsp" : 2,
        "shared_name" : "KfCluster-18140.0",
        "ppos" : 80.26,
        "score" : 278,
        "pident" : 71.053,
        "SUID" : 17023,
        "selected" : false,
        "sseqid" : "AT2G01060",
        "length" : 76,
        "nident" : 54,
        "evalue" : 1.04E-26,
        "positive" : 61,
        "gaps" : 1,
        "Type" : "protein_coding",
        "bitscore" : 111.0,
        "slen" : 286,
        "mismatch" : 21,
        "name" : "KfCluster-18140.0",
        "send" : 89,
        "qcovs" : 7,
        "PrimarySymbol" : "0",
        "qend" : 2233
      },
      "position" : {
        "x" : 1011.780029296875,
        "y" : -1222.18408203125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17022",
        "degree_layout" : 2,
        "Description" : "Nucleus  encoded plastid RNA polymerase. Localized in mitochondria and chloroplast.",
        "SecondarySymbol" : "0",
        "sstart" : 668,
        "qstart" : 7,
        "qcovhsp" : 30,
        "shared_name" : "SpCluster-19623.1",
        "ppos" : 74.43,
        "score" : 1126,
        "pident" : 59.77,
        "SUID" : 17022,
        "selected" : false,
        "sseqid" : "AT5G15700",
        "length" : 348,
        "nident" : 208,
        "evalue" : 1.16E-145,
        "positive" : 259,
        "gaps" : 8,
        "Type" : "protein_coding",
        "bitscore" : 438.0,
        "slen" : 1011,
        "mismatch" : 132,
        "name" : "SpCluster-19623.1",
        "send" : 1011,
        "qcovs" : 90,
        "PrimarySymbol" : "0",
        "qend" : 1038
      },
      "position" : {
        "x" : -179.24295043945312,
        "y" : -1259.96337890625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17021",
        "degree_layout" : 1,
        "Description" : "\"Encodes one of the 36 carboxylate clamp (CC)-tetratricopeptide repeat (TPR) proteins (Prasad 2010, Pubmed ID: 20856808) with potential to interact with Hsp90/Hsp70 as co-chaperones.\"",
        "SecondarySymbol" : "CLUMPED CHLOROPLASTS 1 (CLMP1);PHOX2 (Phox2)",
        "sstart" : 448,
        "qstart" : 1582,
        "qcovhsp" : 16,
        "shared_name" : "KfCluster-16267.0",
        "ppos" : 47.85,
        "score" : 220,
        "pident" : 25.743,
        "SUID" : 17021,
        "selected" : false,
        "sseqid" : "AT1G62390",
        "length" : 303,
        "nident" : 78,
        "evalue" : 2.7E-18,
        "positive" : 145,
        "gaps" : 30,
        "Type" : "protein_coding",
        "bitscore" : 89.4,
        "slen" : 751,
        "mismatch" : 195,
        "name" : "KfCluster-16267.0",
        "send" : 733,
        "qcovs" : 48,
        "PrimarySymbol" : "PHOX2 (Phox2)",
        "qend" : 713
      },
      "position" : {
        "x" : -131.90757751464844,
        "y" : -1254.947998046875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17020",
        "degree_layout" : 7,
        "Description" : "Nucleus  encoded plastid RNA polymerase. Localized in mitochondria and chloroplast.",
        "SecondarySymbol" : "0",
        "sstart" : 396,
        "qstart" : 3425,
        "qcovhsp" : 11,
        "shared_name" : "KfCluster-17995.0",
        "ppos" : 69.8,
        "score" : 1722,
        "pident" : 51.487,
        "SUID" : 17020,
        "selected" : false,
        "sseqid" : "AT5G15700",
        "length" : 639,
        "nident" : 329,
        "evalue" : 0.0,
        "positive" : 446,
        "gaps" : 29,
        "Type" : "protein_coding",
        "bitscore" : 667.0,
        "slen" : 1011,
        "mismatch" : 281,
        "name" : "KfCluster-17995.0",
        "send" : 1011,
        "qcovs" : 34,
        "PrimarySymbol" : "0",
        "qend" : 5323
      },
      "position" : {
        "x" : -244.83737182617188,
        "y" : -1219.821533203125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17019",
        "degree_layout" : 2,
        "Description" : "\"Encodes a novel mitochondrial carrier capable of transporting both dicarboxylates (such as malate, oxaloacetate, oxoglutarate, and maleate) and tricarboxylates (such as citrate, isocitrate, cis-aconitate, and trans-aconitate).\"",
        "SecondarySymbol" : "0",
        "sstart" : 2,
        "qstart" : 317,
        "qcovhsp" : 15,
        "shared_name" : "KfCluster-17918.0",
        "ppos" : 83.5,
        "score" : 1111,
        "pident" : 73.064,
        "SUID" : 17019,
        "selected" : false,
        "sseqid" : "AT5G19760",
        "length" : 297,
        "nident" : 217,
        "evalue" : 9.7E-149,
        "positive" : 248,
        "gaps" : 1,
        "Type" : "protein_coding",
        "bitscore" : 432.0,
        "slen" : 298,
        "mismatch" : 79,
        "name" : "KfCluster-17918.0",
        "send" : 298,
        "qcovs" : 46,
        "PrimarySymbol" : "0",
        "qend" : 1204
      },
      "position" : {
        "x" : -1617.1849338245163,
        "y" : -1472.1595458984375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17018",
        "degree_layout" : 4,
        "Description" : "Encodes a cellulose synthase CESA5 that produces seed mucilage cellulose.Mutants are defective in seed coat mucilage.Involved in the regulation of mucilage composition and/or mucilage synthesis.",
        "SecondarySymbol" : "MUCILAGE-MODIFIED 3 (MUM3);CELLULOSE SYNTHASE 5 (CESA5)",
        "sstart" : 6,
        "qstart" : 3823,
        "qcovhsp" : 23,
        "shared_name" : "KfCluster-6284.0",
        "ppos" : 65.28,
        "score" : 2631,
        "pident" : 50.804,
        "SUID" : 17018,
        "selected" : false,
        "sseqid" : "AT5G09870",
        "length" : 1057,
        "nident" : 537,
        "evalue" : 0.0,
        "positive" : 690,
        "gaps" : 79,
        "Type" : "protein_coding",
        "bitscore" : 1018.0,
        "slen" : 1069,
        "mismatch" : 441,
        "name" : "KfCluster-6284.0",
        "send" : 1045,
        "qcovs" : 68,
        "PrimarySymbol" : "CELLULOSE SYNTHASE 5 (CESA5)",
        "qend" : 839
      },
      "position" : {
        "x" : 516.1310424804688,
        "y" : -685.8756103515625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17017",
        "degree_layout" : 4,
        "Description" : "cellulose synthase",
        "SecondarySymbol" : "CELLULOSE SYNTHASE 10 (CESA10)",
        "sstart" : 925,
        "qstart" : 1,
        "qcovhsp" : 16,
        "shared_name" : "KfCluster-17835.0",
        "ppos" : 66.94,
        "score" : 329,
        "pident" : 49.194,
        "SUID" : 17017,
        "selected" : false,
        "sseqid" : "AT2G25540",
        "length" : 124,
        "nident" : 61,
        "evalue" : 1.6E-34,
        "positive" : 83,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 131.0,
        "slen" : 1065,
        "mismatch" : 63,
        "name" : "KfCluster-17835.0",
        "send" : 1048,
        "qcovs" : 48,
        "PrimarySymbol" : "CELLULOSE SYNTHASE 10 (CESA10)",
        "qend" : 372
      },
      "position" : {
        "x" : 613.7775268554688,
        "y" : -619.5379028320312
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17016",
        "degree_layout" : 9,
        "Description" : "\"Encodes a guard cell outward potassium channel.  Belongs to the Shaker family K+ channel. This family includes five groups based on phylogenetic analysis (FEBS Letters (2007) 581: 2357): I (inward rectifying channel): AKT1 (AT2G26650), AKT5 (AT4G32500) and SPIK (also known as AKT6, AT2G25600); II (inward rectifying channel): KAT1 (AT5G46240) and KAT2 (AT4G18290); III (weakly inward rectifying channel): AKT2 (AT4G22200); IV (regulatory subunit involved in inwardly rectifying conductance formation): KAT3 (also known as AtKC1, AT4G32650); V (outward rectifying channel): SKOR (AT3G02850) and GORK (AT5G37500). Mutants have increased water consumption and limited stomatal closure in response to abscisic and jasmonic acids. It forms a heteromeric K(out) channels with SKOR. The gene is expressed ubiquitously in root and the vasculature and guard cells of leaves. Expression is suppressed during agrobacterium-induced tumor formation and increased in response to water deprivation and cold.\"",
        "SecondarySymbol" : "GATED OUTWARDLY-RECTIFYING K+ CHANNEL (GORK)",
        "sstart" : 43,
        "qstart" : 2682,
        "qcovhsp" : 19,
        "shared_name" : "KfCluster-30442.0",
        "ppos" : 54.79,
        "score" : 939,
        "pident" : 33.906,
        "SUID" : 17016,
        "selected" : false,
        "sseqid" : "AT5G37500",
        "length" : 699,
        "nident" : 237,
        "evalue" : 1.79E-110,
        "positive" : 383,
        "gaps" : 34,
        "Type" : "protein_coding",
        "bitscore" : 366.0,
        "slen" : 820,
        "mismatch" : 428,
        "name" : "KfCluster-30442.0",
        "send" : 713,
        "qcovs" : 56,
        "PrimarySymbol" : "GATED OUTWARDLY-RECTIFYING K+ CHANNEL (GORK)",
        "qend" : 604
      },
      "position" : {
        "x" : -398.02752685546875,
        "y" : -447.0101623535156
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17015",
        "degree_layout" : 1,
        "Description" : "Pyridoxal-dependent decarboxylase family protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 72,
        "qstart" : 1666,
        "qcovhsp" : 21,
        "shared_name" : "KfCluster-17691.0",
        "ppos" : 85.44,
        "score" : 1714,
        "pident" : 74.94,
        "SUID" : 17015,
        "selected" : false,
        "sseqid" : "AT5G11880",
        "length" : 419,
        "nident" : 314,
        "evalue" : 0.0,
        "positive" : 358,
        "gaps" : 4,
        "Type" : "protein_coding",
        "bitscore" : 664.0,
        "slen" : 489,
        "mismatch" : 101,
        "name" : "KfCluster-17691.0",
        "send" : 489,
        "qcovs" : 62,
        "PrimarySymbol" : "0",
        "qend" : 419
      },
      "position" : {
        "x" : -426.40826416015625,
        "y" : -271.6526794433594
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17014",
        "degree_layout" : 2,
        "Description" : "isolated from differential screening of a cDNA library from auxin-treated root culture. sequence does not show homology to any known proteins and is predicted to be extracellular.",
        "SecondarySymbol" : "AUXIN-INDUCED IN ROOT CULTURES 9 (AIR9)",
        "sstart" : 244,
        "qstart" : 451,
        "qcovhsp" : 13,
        "shared_name" : "SpCluster-17398.0",
        "ppos" : 63.8,
        "score" : 1581,
        "pident" : 46.433,
        "SUID" : 17014,
        "selected" : false,
        "sseqid" : "AT2G34680",
        "length" : 743,
        "nident" : 345,
        "evalue" : 0.0,
        "positive" : 474,
        "gaps" : 7,
        "Type" : "protein_coding",
        "bitscore" : 613.0,
        "slen" : 1708,
        "mismatch" : 391,
        "name" : "SpCluster-17398.0",
        "send" : 985,
        "qcovs" : 39,
        "PrimarySymbol" : "AUXIN-INDUCED IN ROOT CULTURES 9 (AIR9)",
        "qend" : 2661
      },
      "position" : {
        "x" : -482.7786865234375,
        "y" : -1001.14013671875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17013",
        "degree_layout" : 12,
        "Description" : "\"Encodes a xyloglucan endotransglycosylase/hydrolase. Protein sequence and phylogenetic analysis indicates that this enzyme resides in Group III-A of the XTH family, with high similarity to Tropaeolum majus (nasturtium) xyloglucanase 1 (TmNXG1). By sequence similarity to XTH31 (At3g44990) and in vivo analysis, likely to exhibit predominant xyloglucan endo-hydrolase activity (EC 3.2.1.151) with only limited potential to act as a xyloglucan endo-transglycosylase (EC 2.4.1.207).\"",
        "SecondarySymbol" : "(ATXTH32);XYLOGLUCAN ENDOTRANSGLUCOSYLASE/HYDROLASE 32 (XTH32)",
        "sstart" : 60,
        "qstart" : 873,
        "qcovhsp" : 7,
        "shared_name" : "SpCluster-16329.2",
        "ppos" : 53.14,
        "score" : 270,
        "pident" : 36.0,
        "SUID" : 17013,
        "selected" : false,
        "sseqid" : "AT2G36870",
        "length" : 175,
        "nident" : 63,
        "evalue" : 9.32E-26,
        "positive" : 93,
        "gaps" : 17,
        "Type" : "protein_coding",
        "bitscore" : 108.0,
        "slen" : 299,
        "mismatch" : 95,
        "name" : "SpCluster-16329.2",
        "send" : 226,
        "qcovs" : 21,
        "PrimarySymbol" : "XYLOGLUCAN ENDOTRANSGLUCOSYLASE/HYDROLASE 32 (XTH32)",
        "qend" : 376
      },
      "position" : {
        "x" : -880.9217529296875,
        "y" : -705.887939453125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17012",
        "degree_layout" : 6,
        "Description" : "isolated from differential screening of a cDNA library from auxin-treated root culture. sequence does not show homology to any known proteins and is predicted to be extracellular.",
        "SecondarySymbol" : "AUXIN-INDUCED IN ROOT CULTURES 9 (AIR9)",
        "sstart" : 683,
        "qstart" : 3771,
        "qcovhsp" : 11,
        "shared_name" : "KfCluster-17565.0",
        "ppos" : 57.33,
        "score" : 1817,
        "pident" : 40.118,
        "SUID" : 17012,
        "selected" : false,
        "sseqid" : "AT2G34680",
        "length" : 1017,
        "nident" : 408,
        "evalue" : 0.0,
        "positive" : 583,
        "gaps" : 17,
        "Type" : "protein_coding",
        "bitscore" : 704.0,
        "slen" : 1708,
        "mismatch" : 592,
        "name" : "KfCluster-17565.0",
        "send" : 1695,
        "qcovs" : 34,
        "PrimarySymbol" : "AUXIN-INDUCED IN ROOT CULTURES 9 (AIR9)",
        "qend" : 760
      },
      "position" : {
        "x" : -412.5912170410156,
        "y" : -1100.419677734375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17011",
        "degree_layout" : 26,
        "Description" : "\"encodes a SNF1-related protein kinase that physically interacts with SCF subunit SKP1/ASK1 and 20S proteosome subunit PAD1. It can also interact with PRL1 DWD-containing protein. Based on in vitro degradation assays and cul4cs and prl1 mutants, there is evidence that AKIN10 is degraded in a proteasome-dependent manner, and that this depends on a CUL4-PRL1 E3 ligase\"",
        "SecondarySymbol" : "SNF1 KINASE HOMOLOG 10 (AKIN10);SNF1 KINASE HOMOLOG 10 (KIN10); (KIN10)",
        "sstart" : 148,
        "qstart" : 2712,
        "qcovhsp" : 7,
        "shared_name" : "PpCluster-27038.1",
        "ppos" : 68.14,
        "score" : 919,
        "pident" : 54.572,
        "SUID" : 17011,
        "selected" : false,
        "sseqid" : "AT3G01090",
        "length" : 339,
        "nident" : 185,
        "evalue" : 2.15E-138,
        "positive" : 231,
        "gaps" : 17,
        "Type" : "protein_coding",
        "bitscore" : 358.0,
        "slen" : 535,
        "mismatch" : 137,
        "name" : "PpCluster-27038.1",
        "send" : 472,
        "qcovs" : 21,
        "PrimarySymbol" : "SNF1 KINASE HOMOLOG 10 (KIN10)",
        "qend" : 1705
      },
      "position" : {
        "x" : -333.2121276855469,
        "y" : -1742.528564453125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17822",
        "degree_layout" : 2,
        "Description" : "ENTH/VHS/GAT family protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 1,
        "qstart" : 2733,
        "qcovhsp" : 10,
        "shared_name" : "SpCluster-14449.0",
        "ppos" : 61.74,
        "score" : 569,
        "pident" : 43.96,
        "SUID" : 17822,
        "selected" : false,
        "sseqid" : "AT4G32760",
        "length" : 298,
        "nident" : 131,
        "evalue" : 4.69E-62,
        "positive" : 184,
        "gaps" : 32,
        "Type" : "protein_coding",
        "bitscore" : 223.0,
        "slen" : 676,
        "mismatch" : 135,
        "name" : "SpCluster-14449.0",
        "send" : 269,
        "qcovs" : 31,
        "PrimarySymbol" : "0",
        "qend" : 1849
      },
      "position" : {
        "x" : 172.06732177734375,
        "y" : -1656.070556640625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17821",
        "degree_layout" : 3,
        "Description" : "ENTH/VHS/GAT family protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 4,
        "qstart" : 412,
        "qcovhsp" : 3,
        "shared_name" : "PpCluster-26873.2",
        "ppos" : 83.82,
        "score" : 421,
        "pident" : 61.029,
        "SUID" : 17821,
        "selected" : false,
        "sseqid" : "AT4G32760",
        "length" : 136,
        "nident" : 83,
        "evalue" : 2.49E-42,
        "positive" : 114,
        "gaps" : 1,
        "Type" : "protein_coding",
        "bitscore" : 166.0,
        "slen" : 675,
        "mismatch" : 52,
        "name" : "PpCluster-26873.2",
        "send" : 138,
        "qcovs" : 9,
        "PrimarySymbol" : "0",
        "qend" : 819
      },
      "position" : {
        "x" : 150.50274658203125,
        "y" : -1515.212646484375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17010",
        "degree_layout" : 13,
        "Description" : "Encodes a member of SNF1-related protein kinases (SnRK2) whose activity is activated by ionic (salt) and non-ionic (mannitol) osmotic stress. Similar to the calcium/calmodulin-dependent protein kinase subfamily and the SNF1 kinase subfamily.",
        "SecondarySymbol" : "ARABIDOPSIS SKP1-LIKE1 (ASK2); (SRK2G);SNF1-RELATED PROTEIN KINASE 2.1 (SNRK2.1); (SNRK2-1);ARABIDOPSIS SERINE/THREONINE KINASE 2 (ASK2)",
        "sstart" : 99,
        "qstart" : 915,
        "qcovhsp" : 8,
        "shared_name" : "KfCluster-17560.0",
        "ppos" : 51.42,
        "score" : 321,
        "pident" : 32.075,
        "SUID" : 17010,
        "selected" : false,
        "sseqid" : "AT5G08590",
        "length" : 212,
        "nident" : 68,
        "evalue" : 6.4E-32,
        "positive" : 109,
        "gaps" : 20,
        "Type" : "protein_coding",
        "bitscore" : 128.0,
        "slen" : 353,
        "mismatch" : 124,
        "name" : "KfCluster-17560.0",
        "send" : 295,
        "qcovs" : 24,
        "PrimarySymbol" : "SNF1-RELATED PROTEIN KINASE 2.1 (SNRK2.1)",
        "qend" : 295
      },
      "position" : {
        "x" : -178.41635131835938,
        "y" : -1760.05908203125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17009",
        "degree_layout" : 10,
        "Description" : "RNA-binding (RRM/RBD/RNP motifs) family protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 562,
        "qstart" : 1759,
        "qcovhsp" : 14,
        "shared_name" : "SpCluster-6844.1",
        "ppos" : 58.52,
        "score" : 478,
        "pident" : 40.0,
        "SUID" : 17009,
        "selected" : false,
        "sseqid" : "AT2G21440",
        "length" : 270,
        "nident" : 108,
        "evalue" : 2.11E-50,
        "positive" : 158,
        "gaps" : 21,
        "Type" : "protein_coding",
        "bitscore" : 188.0,
        "slen" : 1003,
        "mismatch" : 141,
        "name" : "SpCluster-6844.1",
        "send" : 810,
        "qcovs" : 43,
        "PrimarySymbol" : "0",
        "qend" : 950
      },
      "position" : {
        "x" : -1678.7926025390625,
        "y" : -978.4443359375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17820",
        "degree_layout" : 3,
        "Description" : "myb-like transcription factor family protein;(source:Araport11)",
        "SecondarySymbol" : "(ATSWC4)",
        "sstart" : 1,
        "qstart" : 101,
        "qcovhsp" : 12,
        "shared_name" : "SpCluster-9120.0",
        "ppos" : 62.55,
        "score" : 531,
        "pident" : 45.318,
        "SUID" : 17820,
        "selected" : false,
        "sseqid" : "AT2G47210",
        "length" : 267,
        "nident" : 121,
        "evalue" : 3.74E-60,
        "positive" : 167,
        "gaps" : 34,
        "Type" : "protein_coding",
        "bitscore" : 209.0,
        "slen" : 441,
        "mismatch" : 112,
        "name" : "SpCluster-9120.0",
        "send" : 237,
        "qcovs" : 37,
        "PrimarySymbol" : "(ATSWC4)",
        "qend" : 889
      },
      "position" : {
        "x" : 900.5317993164062,
        "y" : -1208.6182861328125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17819",
        "degree_layout" : 2,
        "Description" : "myb-like transcription factor family protein;(source:Araport11)",
        "SecondarySymbol" : "(ATSWC4)",
        "sstart" : 5,
        "qstart" : 2950,
        "qcovhsp" : 4,
        "shared_name" : "PpCluster-26694.0",
        "ppos" : 73.08,
        "score" : 357,
        "pident" : 52.308,
        "SUID" : 17819,
        "selected" : false,
        "sseqid" : "AT2G47210",
        "length" : 130,
        "nident" : 68,
        "evalue" : 3.57E-60,
        "positive" : 95,
        "gaps" : 4,
        "Type" : "protein_coding",
        "bitscore" : 142.0,
        "slen" : 441,
        "mismatch" : 58,
        "name" : "PpCluster-26694.0",
        "send" : 131,
        "qcovs" : 11,
        "PrimarySymbol" : "(ATSWC4)",
        "qend" : 2564
      },
      "position" : {
        "x" : 989.0213623046875,
        "y" : -1086.49951171875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17008",
        "degree_layout" : 8,
        "Description" : "\"Plant-specific protein. Interacts with phragmoplastin, Rop1 and Rop2. Involved in cell plate formation.\"",
        "SecondarySymbol" : "PHRAGMOPLASTIN INTERACTING PROTEIN 1 (PHIP1)",
        "sstart" : 255,
        "qstart" : 2512,
        "qcovhsp" : 4,
        "shared_name" : "PpCluster-23053.0",
        "ppos" : 51.88,
        "score" : 260,
        "pident" : 35.625,
        "SUID" : 17008,
        "selected" : false,
        "sseqid" : "AT3G55340",
        "length" : 160,
        "nident" : 57,
        "evalue" : 6.6E-23,
        "positive" : 83,
        "gaps" : 38,
        "Type" : "protein_coding",
        "bitscore" : 104.0,
        "slen" : 597,
        "mismatch" : 65,
        "name" : "PpCluster-23053.0",
        "send" : 414,
        "qcovs" : 11,
        "PrimarySymbol" : "PHRAGMOPLASTIN INTERACTING PROTEIN 1 (PHIP1)",
        "qend" : 2877
      },
      "position" : {
        "x" : -1620.6541748046875,
        "y" : -865.54296875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17007",
        "degree_layout" : 7,
        "Description" : "RMB25 is an alternative splicing factor involved in mediation of abiotic stress response and ABA response. Its expression is modulated by a variety of stressors and it in turn appears to affect the ratio of splice variants of stress responsive genes such as HAB1.2/HAB1.1.",
        "SecondarySymbol" : "RNA-BINDING PROTEIN 25 (RBM25)",
        "sstart" : 788,
        "qstart" : 514,
        "qcovhsp" : 2,
        "shared_name" : "PpCluster-13263.1",
        "ppos" : 89.62,
        "score" : 390,
        "pident" : 72.642,
        "SUID" : 17007,
        "selected" : false,
        "sseqid" : "AT1G60200",
        "length" : 106,
        "nident" : 77,
        "evalue" : 6.44E-38,
        "positive" : 95,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 154.0,
        "slen" : 899,
        "mismatch" : 29,
        "name" : "PpCluster-13263.1",
        "send" : 893,
        "qcovs" : 7,
        "PrimarySymbol" : "RNA-BINDING PROTEIN 25 (RBM25)",
        "qend" : 197
      },
      "position" : {
        "x" : -1483.0899658203125,
        "y" : -1121.0428466796875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17006",
        "degree_layout" : 27,
        "Description" : "RNA-binding (RRM/RBD/RNP motifs) family protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 95,
        "qstart" : 1676,
        "qcovhsp" : 5,
        "shared_name" : "KfCluster-30895.0",
        "ppos" : 67.57,
        "score" : 382,
        "pident" : 47.973,
        "SUID" : 17006,
        "selected" : false,
        "sseqid" : "AT3G15010",
        "length" : 148,
        "nident" : 71,
        "evalue" : 1.85E-39,
        "positive" : 100,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 151.0,
        "slen" : 404,
        "mismatch" : 77,
        "name" : "KfCluster-30895.0",
        "send" : 242,
        "qcovs" : 15,
        "PrimarySymbol" : "0",
        "qend" : 2119
      },
      "position" : {
        "x" : -1584.103759765625,
        "y" : -962.97900390625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17005",
        "degree_layout" : 4,
        "Description" : "Encodes hydroxypyruvate reductase.",
        "SecondarySymbol" : "HYDROXYPYRUVATE REDUCTASE (HPR)",
        "sstart" : 173,
        "qstart" : 941,
        "qcovhsp" : 12,
        "shared_name" : "KfCluster-24652.0",
        "ppos" : 81.22,
        "score" : 769,
        "pident" : 64.789,
        "SUID" : 17005,
        "selected" : false,
        "sseqid" : "AT1G68010",
        "length" : 213,
        "nident" : 138,
        "evalue" : 1.33E-96,
        "positive" : 173,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 300.0,
        "slen" : 386,
        "mismatch" : 75,
        "name" : "KfCluster-24652.0",
        "send" : 385,
        "qcovs" : 36,
        "PrimarySymbol" : "HYDROXYPYRUVATE REDUCTASE (HPR)",
        "qend" : 303
      },
      "position" : {
        "x" : 353.3128356933594,
        "y" : -74.28359985351562
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17004",
        "degree_layout" : 4,
        "Description" : "D-isomer specific 2-hydroxyacid dehydrogenase family protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 1,
        "qstart" : 1408,
        "qcovhsp" : 20,
        "shared_name" : "KfCluster-21155.0",
        "ppos" : 65.29,
        "score" : 712,
        "pident" : 50.955,
        "SUID" : 17004,
        "selected" : false,
        "sseqid" : "AT1G79870",
        "length" : 314,
        "nident" : 160,
        "evalue" : 6.49E-90,
        "positive" : 205,
        "gaps" : 2,
        "Type" : "protein_coding",
        "bitscore" : 278.0,
        "slen" : 313,
        "mismatch" : 152,
        "name" : "KfCluster-21155.0",
        "send" : 312,
        "qcovs" : 59,
        "PrimarySymbol" : "0",
        "qend" : 467
      },
      "position" : {
        "x" : 268.63323974609375,
        "y" : -157.35264587402344
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17003",
        "degree_layout" : 22,
        "Description" : "\"Encodes a peroxisomal protein of the ATP binding cassette (ABC) transporter class (PMP subfamily) with significant identity to the human X-linked adrenoleukodystrophy protein (ALDP). The gene product promotes germination and represses embryo dormancy. ABI3, ABA1, FUS3 and LEC1 are epistatic to this gene. Mutants accumulate fatty acyl CoA suggesting a defect in uptake of fatty acyl CoA into the peroxisome.\"",
        "SecondarySymbol" : "PEROXISOMAL ABC TRANSPORTER 1 (PXA1);ATP-BINDING CASSETTE D1 (ABCD1)",
        "sstart" : 11,
        "qstart" : 256,
        "qcovhsp" : 17,
        "shared_name" : "KfCluster-17318.1",
        "ppos" : 71.22,
        "score" : 3894,
        "pident" : 56.759,
        "SUID" : 17003,
        "selected" : false,
        "sseqid" : "AT4G39850",
        "length" : 1376,
        "nident" : 781,
        "evalue" : 0.0,
        "positive" : 980,
        "gaps" : 57,
        "Type" : "protein_coding",
        "bitscore" : 1504.0,
        "slen" : 1337,
        "mismatch" : 538,
        "name" : "KfCluster-17318.1",
        "send" : 1334,
        "qcovs" : 52,
        "PrimarySymbol" : "ATP-BINDING CASSETTE D1 (ABCD1)",
        "qend" : 4368
      },
      "position" : {
        "x" : 223.23165893554688,
        "y" : -185.33346557617188
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17002",
        "degree_layout" : 4,
        "Description" : "\"Encodes the cytosolic minor isoform of nitrate reductase (NR). Involved in the first step of nitrate assimilation, it contributes about 15% of the nitrate reductase activity in shoots. Similar to molybdopterin oxidoreductases at the N-terminus, and to FAD/NAD-binding cytochrome reductases at the C-terminus. Cofactors: FAD, heme iron (cytochrome B-557), and molybdenum-pterin.\"",
        "SecondarySymbol" : "NITRATE REDUCTASE 1 (NIA1);NITRATE REDUCTASE 1 (NR1); (GNR1)",
        "sstart" : 591,
        "qstart" : 374,
        "qcovhsp" : 33,
        "shared_name" : "SpCluster-15027.0",
        "ppos" : 68.25,
        "score" : 314,
        "pident" : 51.587,
        "SUID" : 17002,
        "selected" : false,
        "sseqid" : "AT1G77760",
        "length" : 126,
        "nident" : 65,
        "evalue" : 2.06E-34,
        "positive" : 86,
        "gaps" : 3,
        "Type" : "protein_coding",
        "bitscore" : 125.0,
        "slen" : 917,
        "mismatch" : 58,
        "name" : "SpCluster-15027.0",
        "send" : 715,
        "qcovs" : 99,
        "PrimarySymbol" : "NITRATE REDUCTASE 1 (NIA1)",
        "qend" : 3
      },
      "position" : {
        "x" : -762.1764526367188,
        "y" : -1376.7625732421875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17001",
        "degree_layout" : 6,
        "Description" : "\"Encodes NADH:cytochrome (Cyt) b5 reductase that displayed strict specificity to NADH for the reduction of a recombinant Cyt b5 (AtB5-A), whereas no Cyt b5 reduction was observed when NADPH was used as the electron donor.\"",
        "SecondarySymbol" : "NADH:CYTOCHROME B5 REDUCTASE 1 (ATCBR);NADH:CYTOCHROME B5 REDUCTASE 1 (CBR);NADH:CYTOCHROME B5 REDUCTASE 1 (CBR1)",
        "sstart" : 30,
        "qstart" : 1427,
        "qcovhsp" : 14,
        "shared_name" : "KfCluster-2206.0",
        "ppos" : 77.08,
        "score" : 844,
        "pident" : 60.87,
        "SUID" : 17001,
        "selected" : false,
        "sseqid" : "AT5G17770",
        "length" : 253,
        "nident" : 154,
        "evalue" : 1.64E-109,
        "positive" : 195,
        "gaps" : 1,
        "Type" : "protein_coding",
        "bitscore" : 329.0,
        "slen" : 281,
        "mismatch" : 98,
        "name" : "KfCluster-2206.0",
        "send" : 281,
        "qcovs" : 43,
        "PrimarySymbol" : "NADH:CYTOCHROME B5 REDUCTASE 1 (CBR)",
        "qend" : 669
      },
      "position" : {
        "x" : -623.229736328125,
        "y" : -1335.154541015625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17000",
        "degree_layout" : 8,
        "Description" : "\"Major enzyme responsible for the synthesis of 18:2 fatty acids in the endoplasmic reticulum. Contains His-rich motifs, which contribute to the interaction with the electron donor cytochrome b5.  Mutations in this gene suppress the low temperature-induced phenotype of Arabidopsis tocopherol-deficient mutant vte2.\"",
        "SecondarySymbol" : "(ATFAD2);FATTY ACID DESATURASE 2 (FAD2)",
        "sstart" : 98,
        "qstart" : 1017,
        "qcovhsp" : 28,
        "shared_name" : "SpCluster-2078.0",
        "ppos" : 100.0,
        "score" : 1548,
        "pident" : 100.0,
        "SUID" : 17000,
        "selected" : false,
        "sseqid" : "AT3G12120",
        "length" : 286,
        "nident" : 286,
        "evalue" : 0.0,
        "positive" : 286,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 600.0,
        "slen" : 383,
        "mismatch" : 0,
        "name" : "SpCluster-2078.0",
        "send" : 383,
        "qcovs" : 84,
        "PrimarySymbol" : "FATTY ACID DESATURASE 2 (FAD2)",
        "qend" : 160
      },
      "position" : {
        "x" : -978.1954345703125,
        "y" : -773.6470336914062
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16999",
        "degree_layout" : 2,
        "Description" : "\"Chloroplastic enzyme responsible for the synthesis of 16:2 and 18:2 fatty acids from galactolipids, sulpholipids and phosphatidylglycerol. Uses ferredoxin as electron donor. Gene mutation resulted in reduced level of unsaturated fatty acids leading to susceptibility to photoinhibition.\"",
        "SecondarySymbol" : "FATTY ACID DESATURASE 6 (FAD6);STEAROYL DESATURASE DEFICIENCY 4 (SFD4);FATTY ACID DESATURASE C (FADC)",
        "sstart" : 61,
        "qstart" : 422,
        "qcovhsp" : 14,
        "shared_name" : "KfCluster-3566.0",
        "ppos" : 64.86,
        "score" : 221,
        "pident" : 40.541,
        "SUID" : 16999,
        "selected" : false,
        "sseqid" : "AT4G30950",
        "length" : 111,
        "nident" : 45,
        "evalue" : 1.42E-20,
        "positive" : 72,
        "gaps" : 12,
        "Type" : "protein_coding",
        "bitscore" : 89.7,
        "slen" : 448,
        "mismatch" : 54,
        "name" : "KfCluster-3566.0",
        "send" : 171,
        "qcovs" : 41,
        "PrimarySymbol" : "FATTY ACID DESATURASE 6 (FAD6)",
        "qend" : 718
      },
      "position" : {
        "x" : -1120.565673828125,
        "y" : -790.3232421875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16998",
        "degree_layout" : 11,
        "Description" : "\"Major enzyme responsible for the synthesis of 18:2 fatty acids in the endoplasmic reticulum. Contains His-rich motifs, which contribute to the interaction with the electron donor cytochrome b5.  Mutations in this gene suppress the low temperature-induced phenotype of Arabidopsis tocopherol-deficient mutant vte2.\"",
        "SecondarySymbol" : "(ATFAD2);FATTY ACID DESATURASE 2 (FAD2)",
        "sstart" : 1,
        "qstart" : 1701,
        "qcovhsp" : 20,
        "shared_name" : "KfCluster-2751.0",
        "ppos" : 71.95,
        "score" : 1098,
        "pident" : 59.74,
        "SUID" : 16998,
        "selected" : false,
        "sseqid" : "AT3G12120",
        "length" : 385,
        "nident" : 230,
        "evalue" : 2.06E-145,
        "positive" : 277,
        "gaps" : 7,
        "Type" : "protein_coding",
        "bitscore" : 427.0,
        "slen" : 383,
        "mismatch" : 148,
        "name" : "KfCluster-2751.0",
        "send" : 382,
        "qcovs" : 59,
        "PrimarySymbol" : "FATTY ACID DESATURASE 2 (FAD2)",
        "qend" : 559
      },
      "position" : {
        "x" : -895.7603759765625,
        "y" : -802.8364868164062
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16997",
        "degree_layout" : 8,
        "Description" : "\"Chloroplastic enzyme responsible for the synthesis of 16:3 and 18:3 fatty acids from galactolipids, sulpholipids and phosphatidylglycerol. Uses ferredoxin as electron donor. Gene expression is induced by wounding in shoot and root. The wound-response in shoot is independent of jasmonic acid mediated pathway whereas the root response is mediated by jasmonic acid. The mRNA is cell-to-cell mobile.\"",
        "SecondarySymbol" : "FATTY ACID DESATURASE 7 (FAD7); (AtFAD7);FATTY ACID DESATURASE D (FADD)",
        "sstart" : 163,
        "qstart" : 1493,
        "qcovhsp" : 18,
        "shared_name" : "KfCluster-22101.0",
        "ppos" : 80.44,
        "score" : 971,
        "pident" : 67.897,
        "SUID" : 16997,
        "selected" : false,
        "sseqid" : "AT3G11170",
        "length" : 271,
        "nident" : 184,
        "evalue" : 1.61E-127,
        "positive" : 218,
        "gaps" : 1,
        "Type" : "protein_coding",
        "bitscore" : 378.0,
        "slen" : 446,
        "mismatch" : 86,
        "name" : "KfCluster-22101.0",
        "send" : 432,
        "qcovs" : 54,
        "PrimarySymbol" : "FATTY ACID DESATURASE 7 (FAD7)",
        "qend" : 681
      },
      "position" : {
        "x" : -1038.848876953125,
        "y" : -806.1701049804688
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16996",
        "degree_layout" : 15,
        "Description" : "glycosyl hydrolase 9C3;(source:Araport11)",
        "SecondarySymbol" : "GLYCOSYL HYDROLASE 9C3 (GH9C3);GLYCOSYL HYDROLASE 9C3 (AtGH9C3)",
        "sstart" : 26,
        "qstart" : 2291,
        "qcovhsp" : 15,
        "shared_name" : "SpCluster-13584.3",
        "ppos" : 66.1,
        "score" : 1113,
        "pident" : 48.941,
        "SUID" : 16996,
        "selected" : false,
        "sseqid" : "AT4G11050",
        "length" : 472,
        "nident" : 231,
        "evalue" : 3.77E-139,
        "positive" : 312,
        "gaps" : 9,
        "Type" : "protein_coding",
        "bitscore" : 433.0,
        "slen" : 626,
        "mismatch" : 232,
        "name" : "SpCluster-13584.3",
        "send" : 490,
        "qcovs" : 44,
        "PrimarySymbol" : "GLYCOSYL HYDROLASE 9C3 (GH9C3)",
        "qend" : 882
      },
      "position" : {
        "x" : 6.2532958984375,
        "y" : -1404.3502197265625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16995",
        "degree_layout" : 7,
        "Description" : "COBRA-like protein 8 precursor;(source:Araport11)",
        "SecondarySymbol" : "COBRA-LIKE PROTEIN 8 PRECURSOR (COBL8)",
        "sstart" : 39,
        "qstart" : 2237,
        "qcovhsp" : 14,
        "shared_name" : "KfCluster-8358.0",
        "ppos" : 42.81,
        "score" : 479,
        "pident" : 26.677,
        "SUID" : 16995,
        "selected" : false,
        "sseqid" : "AT3G16860",
        "length" : 626,
        "nident" : 167,
        "evalue" : 7.26E-50,
        "positive" : 268,
        "gaps" : 61,
        "Type" : "protein_coding",
        "bitscore" : 189.0,
        "slen" : 653,
        "mismatch" : 398,
        "name" : "KfCluster-8358.0",
        "send" : 636,
        "qcovs" : 42,
        "PrimarySymbol" : "COBRA-LIKE PROTEIN 8 PRECURSOR (COBL8)",
        "qend" : 459
      },
      "position" : {
        "x" : -576.8114013671875,
        "y" : -1312.730224609375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16994",
        "degree_layout" : 29,
        "Description" : "Present in transcriptionally active plastid chromosomes. Involved in plastid gene expression.",
        "SecondarySymbol" : "PIGMENT DEFECTIVE 343 (PDE343);PLASTID TRANSCRIPTIONALLY ACTIVE 2 (PTAC2)",
        "sstart" : 104,
        "qstart" : 2557,
        "qcovhsp" : 15,
        "shared_name" : "KfCluster-27910.0",
        "ppos" : 46.61,
        "score" : 543,
        "pident" : 28.602,
        "SUID" : 16994,
        "selected" : false,
        "sseqid" : "AT1G74850",
        "length" : 472,
        "nident" : 135,
        "evalue" : 2.85E-57,
        "positive" : 220,
        "gaps" : 3,
        "Type" : "protein_coding",
        "bitscore" : 213.0,
        "slen" : 862,
        "mismatch" : 334,
        "name" : "KfCluster-27910.0",
        "send" : 575,
        "qcovs" : 45,
        "PrimarySymbol" : "PLASTID TRANSCRIPTIONALLY ACTIVE 2 (PTAC2)",
        "qend" : 1151
      },
      "position" : {
        "x" : -429.7450256347656,
        "y" : -1850.9642333984375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16993",
        "degree_layout" : 4,
        "Description" : "vacuolar ATP synthase subunit H family protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 206,
        "qstart" : 971,
        "qcovhsp" : 11,
        "shared_name" : "KfCluster-17033.0",
        "ppos" : 41.48,
        "score" : 67,
        "pident" : 25.185,
        "SUID" : 16993,
        "selected" : false,
        "sseqid" : "AT3G42050",
        "length" : 135,
        "nident" : 34,
        "evalue" : 2.8,
        "positive" : 56,
        "gaps" : 12,
        "Type" : "protein_coding",
        "bitscore" : 30.4,
        "slen" : 441,
        "mismatch" : 89,
        "name" : "KfCluster-17033.0",
        "send" : 330,
        "qcovs" : 32,
        "PrimarySymbol" : "0",
        "qend" : 573
      },
      "position" : {
        "x" : -261.5963439941406,
        "y" : -1448.6202392578125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16992",
        "degree_layout" : 40,
        "Description" : "P-loop containing nucleoside triphosphate hydrolases superfamily protein;(source:Araport11)",
        "SecondarySymbol" : "PIGMENT DEFECTIVE 340 (PDE340)",
        "sstart" : 356,
        "qstart" : 2846,
        "qcovhsp" : 12,
        "shared_name" : "SpCluster-7670.0",
        "ppos" : 70.04,
        "score" : 1162,
        "pident" : 49.802,
        "SUID" : 16992,
        "selected" : false,
        "sseqid" : "AT5G08610",
        "length" : 504,
        "nident" : 251,
        "evalue" : 4.19E-141,
        "positive" : 353,
        "gaps" : 10,
        "Type" : "protein_coding",
        "bitscore" : 452.0,
        "slen" : 850,
        "mismatch" : 243,
        "name" : "SpCluster-7670.0",
        "send" : 850,
        "qcovs" : 37,
        "PrimarySymbol" : "PIGMENT DEFECTIVE 340 (PDE340)",
        "qend" : 1338
      },
      "position" : {
        "x" : -1371.2399875354538,
        "y" : -2462.512456569718
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16991",
        "degree_layout" : 43,
        "Description" : "putative DEAD-box ATP-dependent RNA helicase 29;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 30,
        "qstart" : 200,
        "qcovhsp" : 28,
        "shared_name" : "SpCluster-7600.0",
        "ppos" : 69.18,
        "score" : 1859,
        "pident" : 51.058,
        "SUID" : 16991,
        "selected" : false,
        "sseqid" : "AT1G77030",
        "length" : 756,
        "nident" : 386,
        "evalue" : 0.0,
        "positive" : 523,
        "gaps" : 23,
        "Type" : "protein_coding",
        "bitscore" : 720.0,
        "slen" : 845,
        "mismatch" : 347,
        "name" : "SpCluster-7600.0",
        "send" : 765,
        "qcovs" : 85,
        "PrimarySymbol" : "0",
        "qend" : 2458
      },
      "position" : {
        "x" : -1237.2191135120163,
        "y" : -2439.783208522843
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16990",
        "degree_layout" : 46,
        "Description" : "DEA(D/H)-box RNA helicase family protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 155,
        "qstart" : 710,
        "qcovhsp" : 16,
        "shared_name" : "SpCluster-3056.1",
        "ppos" : 82.72,
        "score" : 1659,
        "pident" : 65.443,
        "SUID" : 16990,
        "selected" : false,
        "sseqid" : "AT4G16630",
        "length" : 463,
        "nident" : 303,
        "evalue" : 0.0,
        "positive" : 383,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 643.0,
        "slen" : 789,
        "mismatch" : 160,
        "name" : "SpCluster-3056.1",
        "send" : 617,
        "qcovs" : 49,
        "PrimarySymbol" : "0",
        "qend" : 2098
      },
      "position" : {
        "x" : -1296.2217990588913,
        "y" : -2493.041265163468
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16989",
        "degree_layout" : 46,
        "Description" : "P-loop containing nucleoside triphosphate hydrolases superfamily protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 162,
        "qstart" : 108,
        "qcovhsp" : 28,
        "shared_name" : "SpCluster-2701.0",
        "ppos" : 88.6,
        "score" : 2346,
        "pident" : 77.375,
        "SUID" : 16989,
        "selected" : false,
        "sseqid" : "AT2G33730",
        "length" : 579,
        "nident" : 448,
        "evalue" : 0.0,
        "positive" : 513,
        "gaps" : 7,
        "Type" : "protein_coding",
        "bitscore" : 908.0,
        "slen" : 733,
        "mismatch" : 124,
        "name" : "SpCluster-2701.0",
        "send" : 733,
        "qcovs" : 83,
        "PrimarySymbol" : "0",
        "qend" : 1844
      },
      "position" : {
        "x" : -1336.7318088245163,
        "y" : -2352.484624538468
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16988",
        "degree_layout" : 38,
        "Description" : "P-loop containing nucleoside triphosphate hydrolases superfamily protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 47,
        "qstart" : 1346,
        "qcovhsp" : 23,
        "shared_name" : "SpCluster-2433.0",
        "ppos" : 71.21,
        "score" : 723,
        "pident" : 49.845,
        "SUID" : 16988,
        "selected" : false,
        "sseqid" : "AT4G34910",
        "length" : 323,
        "nident" : 161,
        "evalue" : 1.56E-88,
        "positive" : 230,
        "gaps" : 10,
        "Type" : "protein_coding",
        "bitscore" : 283.0,
        "slen" : 626,
        "mismatch" : 152,
        "name" : "SpCluster-2433.0",
        "send" : 359,
        "qcovs" : 69,
        "PrimarySymbol" : "0",
        "qend" : 378
      },
      "position" : {
        "x" : -1307.4749728870163,
        "y" : -2298.065190944718
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16987",
        "degree_layout" : 44,
        "Description" : "\"Encodes RH39, a DEAD-box protein involved in the introduction of the hidden break into the 23S rRNA in the chloroplasts. Recombinant RH39 binds to the 23S rRNA in a segment adjacent to the stem-loop creating the hidden break target loop in a sequence-dependent manner. Has ATP-hydrolyzing activity at a Kcat of 5.3 /min in the presence of rRNA sequence. Mutants have drastically reduced level of level of ribulose 1,5-bisphosphate carboxylase/oxygenase. The mRNA is cell-to-cell mobile.\"",
        "SecondarySymbol" : "RH39 (RH39)",
        "sstart" : 114,
        "qstart" : 572,
        "qcovhsp" : 12,
        "shared_name" : "SpCluster-19207.0",
        "ppos" : 77.33,
        "score" : 1029,
        "pident" : 57.143,
        "SUID" : 16987,
        "selected" : false,
        "sseqid" : "AT4G09730",
        "length" : 322,
        "nident" : 184,
        "evalue" : 4.69E-129,
        "positive" : 249,
        "gaps" : 15,
        "Type" : "protein_coding",
        "bitscore" : 400.0,
        "slen" : 621,
        "mismatch" : 123,
        "name" : "SpCluster-19207.0",
        "send" : 420,
        "qcovs" : 37,
        "PrimarySymbol" : "RH39 (RH39)",
        "qend" : 1537
      },
      "position" : {
        "x" : -1264.6881076526413,
        "y" : -2367.093755397843
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16986",
        "degree_layout" : 37,
        "Description" : "P-loop containing nucleoside triphosphate hydrolases superfamily protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 394,
        "qstart" : 1101,
        "qcovhsp" : 14,
        "shared_name" : "SpCluster-18264.0",
        "ppos" : 65.24,
        "score" : 394,
        "pident" : 45.989,
        "SUID" : 16986,
        "selected" : false,
        "sseqid" : "AT4G34910",
        "length" : 187,
        "nident" : 86,
        "evalue" : 1.1E-41,
        "positive" : 122,
        "gaps" : 22,
        "Type" : "protein_coding",
        "bitscore" : 156.0,
        "slen" : 626,
        "mismatch" : 79,
        "name" : "SpCluster-18264.0",
        "send" : 558,
        "qcovs" : 42,
        "PrimarySymbol" : "0",
        "qend" : 541
      },
      "position" : {
        "x" : -1392.9182101917038,
        "y" : -2413.502446804093
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16985",
        "degree_layout" : 46,
        "Description" : "DEA(D/H)-box RNA helicase family protein;(source:Araport11)",
        "SecondarySymbol" : "(RH5);STRESS RESPONSE SUPPRESSOR 1 (STRS1)",
        "sstart" : 100,
        "qstart" : 3364,
        "qcovhsp" : 11,
        "shared_name" : "SpCluster-14645.0",
        "ppos" : 74.65,
        "score" : 1397,
        "pident" : 61.972,
        "SUID" : 16985,
        "selected" : false,
        "sseqid" : "AT1G31970",
        "length" : 426,
        "nident" : 264,
        "evalue" : 0.0,
        "positive" : 318,
        "gaps" : 6,
        "Type" : "protein_coding",
        "bitscore" : 542.0,
        "slen" : 537,
        "mismatch" : 156,
        "name" : "SpCluster-14645.0",
        "send" : 525,
        "qcovs" : 34,
        "PrimarySymbol" : "STRESS RESPONSE SUPPRESSOR 1 (STRS1)",
        "qend" : 2105
      },
      "position" : {
        "x" : -1357.3961154651413,
        "y" : -2312.612554225968
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16984",
        "degree_layout" : 45,
        "Description" : "DEAD/DEAH box RNA helicase PRH75",
        "SecondarySymbol" : "(PRH75); (ATRH7)",
        "sstart" : 86,
        "qstart" : 2147,
        "qcovhsp" : 21,
        "shared_name" : "SpCluster-13609.0",
        "ppos" : 69.19,
        "score" : 1395,
        "pident" : 50.811,
        "SUID" : 16984,
        "selected" : false,
        "sseqid" : "AT5G62190",
        "length" : 555,
        "nident" : 282,
        "evalue" : 0.0,
        "positive" : 384,
        "gaps" : 11,
        "Type" : "protein_coding",
        "bitscore" : 541.0,
        "slen" : 671,
        "mismatch" : 262,
        "name" : "SpCluster-13609.0",
        "send" : 631,
        "qcovs" : 63,
        "PrimarySymbol" : "(PRH75)",
        "qend" : 489
      },
      "position" : {
        "x" : -1373.1938449573288,
        "y" : -2409.732427272843
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16983",
        "degree_layout" : 45,
        "Description" : "DEA(D/H)-box RNA helicase family protein;(source:Araport11)",
        "SecondarySymbol" : "(ATRH20);RNA HELICASE 20 (RH20)",
        "sstart" : 241,
        "qstart" : 1021,
        "qcovhsp" : 10,
        "shared_name" : "SpCluster-12396.0",
        "ppos" : 57.99,
        "score" : 350,
        "pident" : 34.703,
        "SUID" : 16983,
        "selected" : false,
        "sseqid" : "AT1G55150",
        "length" : 219,
        "nident" : 76,
        "evalue" : 5.98E-35,
        "positive" : 127,
        "gaps" : 12,
        "Type" : "protein_coding",
        "bitscore" : 139.0,
        "slen" : 501,
        "mismatch" : 131,
        "name" : "SpCluster-12396.0",
        "send" : 449,
        "qcovs" : 30,
        "PrimarySymbol" : "RNA HELICASE 20 (RH20)",
        "qend" : 371
      },
      "position" : {
        "x" : -1278.2779514026413,
        "y" : -2332.567388210343
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16982",
        "degree_layout" : 38,
        "Description" : "\"Encodes RH39, a DEAD-box protein involved in the introduction of the hidden break into the 23S rRNA in the chloroplasts. Recombinant RH39 binds to the 23S rRNA in a segment adjacent to the stem-loop creating the hidden break target loop in a sequence-dependent manner. Has ATP-hydrolyzing activity at a Kcat of 5.3 /min in the presence of rRNA sequence. Mutants have drastically reduced level of level of ribulose 1,5-bisphosphate carboxylase/oxygenase. The mRNA is cell-to-cell mobile.\"",
        "SecondarySymbol" : "RH39 (RH39)",
        "sstart" : 100,
        "qstart" : 525,
        "qcovhsp" : 8,
        "shared_name" : "PpCluster-8757.0",
        "ppos" : 76.99,
        "score" : 741,
        "pident" : 61.062,
        "SUID" : 16982,
        "selected" : false,
        "sseqid" : "AT4G09730",
        "length" : 226,
        "nident" : 138,
        "evalue" : 2.7E-86,
        "positive" : 174,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 290.0,
        "slen" : 621,
        "mismatch" : 88,
        "name" : "PpCluster-8757.0",
        "send" : 325,
        "qcovs" : 23,
        "PrimarySymbol" : "RH39 (RH39)",
        "qend" : 1202
      },
      "position" : {
        "x" : -1224.1058322620163,
        "y" : -2394.246831569718
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16981",
        "degree_layout" : 49,
        "Description" : "P-loop containing nucleoside triphosphate hydrolases superfamily protein;(source:Araport11)",
        "SecondarySymbol" : "REGULATOR OF CBF GENE EXPRESSION 1 (RCF1)",
        "sstart" : 272,
        "qstart" : 3946,
        "qcovhsp" : 15,
        "shared_name" : "PpCluster-24817.1",
        "ppos" : 78.87,
        "score" : 2219,
        "pident" : 68.641,
        "SUID" : 16981,
        "selected" : false,
        "sseqid" : "AT1G20920",
        "length" : 743,
        "nident" : 510,
        "evalue" : 0.0,
        "positive" : 586,
        "gaps" : 46,
        "Type" : "protein_coding",
        "bitscore" : 859.0,
        "slen" : 1166,
        "mismatch" : 187,
        "name" : "PpCluster-24817.1",
        "send" : 976,
        "qcovs" : 46,
        "PrimarySymbol" : "REGULATOR OF CBF GENE EXPRESSION 1 (RCF1)",
        "qend" : 1742
      },
      "position" : {
        "x" : -1207.0364963245163,
        "y" : -2346.743901882218
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16980",
        "degree_layout" : 30,
        "Description" : "\"Encodes FANCM, a highly conserved helicase that functions as a major factor limiting meiotic crossover formation. It is not directly involved in the repair of DNA lesions but suppresses spontaneous somatic homologous recombination via a RecQ helicase (At-RECQ4A)-independent pathway.\"",
        "SecondarySymbol" : "(AT-FANCM);FANCONI ANEMIA COMPLEMENTATION GROUP M (FANCM)",
        "sstart" : 12,
        "qstart" : 5180,
        "qcovhsp" : 13,
        "shared_name" : "PpCluster-22021.0",
        "ppos" : 67.06,
        "score" : 2061,
        "pident" : 53.437,
        "SUID" : 16980,
        "selected" : false,
        "sseqid" : "AT1G35530",
        "length" : 771,
        "nident" : 412,
        "evalue" : 0.0,
        "positive" : 517,
        "gaps" : 52,
        "Type" : "protein_coding",
        "bitscore" : 798.0,
        "slen" : 1390,
        "mismatch" : 307,
        "name" : "PpCluster-22021.0",
        "send" : 777,
        "qcovs" : 39,
        "PrimarySymbol" : "FANCONI ANEMIA COMPLEMENTATION GROUP M (FANCM)",
        "qend" : 3009
      },
      "position" : {
        "x" : -1400.3107883167038,
        "y" : -2446.395269069718
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16979",
        "degree_layout" : 46,
        "Description" : "P-loop containing nucleoside triphosphate hydrolases superfamily protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 109,
        "qstart" : 483,
        "qcovhsp" : 22,
        "shared_name" : "KfCluster-7764.0",
        "ppos" : 83.71,
        "score" : 1703,
        "pident" : 73.438,
        "SUID" : 16979,
        "selected" : false,
        "sseqid" : "AT2G42520",
        "length" : 448,
        "nident" : 329,
        "evalue" : 0.0,
        "positive" : 375,
        "gaps" : 13,
        "Type" : "protein_coding",
        "bitscore" : 660.0,
        "slen" : 633,
        "mismatch" : 106,
        "name" : "KfCluster-7764.0",
        "send" : 552,
        "qcovs" : 66,
        "PrimarySymbol" : "0",
        "qend" : 1799
      },
      "position" : {
        "x" : -1374.1218234729538,
        "y" : -2346.223394069718
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16978",
        "degree_layout" : 30,
        "Description" : "DEA(D/H)-box RNA helicase family protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 470,
        "qstart" : 906,
        "qcovhsp" : 7,
        "shared_name" : "KfCluster-5077.0",
        "ppos" : 75.41,
        "score" : 123,
        "pident" : 60.656,
        "SUID" : 16978,
        "selected" : false,
        "sseqid" : "AT3G58510",
        "length" : 61,
        "nident" : 37,
        "evalue" : 2.72E-7,
        "positive" : 46,
        "gaps" : 4,
        "Type" : "protein_coding",
        "bitscore" : 52.0,
        "slen" : 612,
        "mismatch" : 20,
        "name" : "KfCluster-5077.0",
        "send" : 526,
        "qcovs" : 20,
        "PrimarySymbol" : "0",
        "qend" : 724
      },
      "position" : {
        "x" : -1265.1336642932663,
        "y" : -2398.157720241593
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16977",
        "degree_layout" : 46,
        "Description" : "RNA HELICASE DRH1",
        "SecondarySymbol" : "ARABIDOPSIS THALIANA DEAD BOX RNA HELICASE 1 (ATDRH1);DEAD BOX RNA HELICASE 1 (DRH1)",
        "sstart" : 1,
        "qstart" : 394,
        "qcovhsp" : 14,
        "shared_name" : "KfCluster-32976.0",
        "ppos" : 72.13,
        "score" : 1596,
        "pident" : 59.199,
        "SUID" : 16977,
        "selected" : false,
        "sseqid" : "AT3G01540",
        "length" : 549,
        "nident" : 325,
        "evalue" : 0.0,
        "positive" : 396,
        "gaps" : 47,
        "Type" : "protein_coding",
        "bitscore" : 619.0,
        "slen" : 618,
        "mismatch" : 177,
        "name" : "KfCluster-32976.0",
        "send" : 545,
        "qcovs" : 41,
        "PrimarySymbol" : "DEAD BOX RNA HELICASE 1 (DRH1)",
        "qend" : 1911
      },
      "position" : {
        "x" : -1340.4508029651413,
        "y" : -2437.122319850968
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16976",
        "degree_layout" : 47,
        "Description" : "DEA(D/H)-box RNA helicase family protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 155,
        "qstart" : 884,
        "qcovhsp" : 16,
        "shared_name" : "KfCluster-32430.0",
        "ppos" : 82.16,
        "score" : 1647,
        "pident" : 65.419,
        "SUID" : 16976,
        "selected" : false,
        "sseqid" : "AT4G16630",
        "length" : 454,
        "nident" : 297,
        "evalue" : 0.0,
        "positive" : 373,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 639.0,
        "slen" : 789,
        "mismatch" : 157,
        "name" : "KfCluster-32430.0",
        "send" : 608,
        "qcovs" : 47,
        "PrimarySymbol" : "0",
        "qend" : 2245
      },
      "position" : {
        "x" : -1281.1837131213913,
        "y" : -2451.198247585343
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16975",
        "degree_layout" : 45,
        "Description" : "DEAD box RNA helicase (RH3);(source:Araport11)",
        "SecondarySymbol" : "EMBRYO DEFECTIVE 1138 (emb1138); (RH3); (ATRH3)",
        "sstart" : 104,
        "qstart" : 674,
        "qcovhsp" : 18,
        "shared_name" : "KfCluster-29646.0",
        "ppos" : 71.03,
        "score" : 1456,
        "pident" : 55.514,
        "SUID" : 16975,
        "selected" : false,
        "sseqid" : "AT5G26742",
        "length" : 535,
        "nident" : 297,
        "evalue" : 0.0,
        "positive" : 380,
        "gaps" : 4,
        "Type" : "protein_coding",
        "bitscore" : 565.0,
        "slen" : 748,
        "mismatch" : 234,
        "name" : "KfCluster-29646.0",
        "send" : 634,
        "qcovs" : 55,
        "PrimarySymbol" : "EMBRYO DEFECTIVE 1138 (emb1138)",
        "qend" : 2278
      },
      "position" : {
        "x" : -1316.7405978870163,
        "y" : -2397.725347194718
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16974",
        "degree_layout" : 46,
        "Description" : "P-loop containing nucleoside triphosphate hydrolases superfamily protein;(source:Araport11)",
        "SecondarySymbol" : "(ATRH57);RNA HELICASE 57 (RH57)",
        "sstart" : 114,
        "qstart" : 2657,
        "qcovhsp" : 9,
        "shared_name" : "KfCluster-26572.0",
        "ppos" : 77.18,
        "score" : 1405,
        "pident" : 60.706,
        "SUID" : 16974,
        "selected" : false,
        "sseqid" : "AT3G09720",
        "length" : 425,
        "nident" : 258,
        "evalue" : 5.69E-178,
        "positive" : 328,
        "gaps" : 3,
        "Type" : "protein_coding",
        "bitscore" : 545.0,
        "slen" : 541,
        "mismatch" : 164,
        "name" : "KfCluster-26572.0",
        "send" : 535,
        "qcovs" : 26,
        "PrimarySymbol" : "RNA HELICASE 57 (RH57)",
        "qend" : 3931
      },
      "position" : {
        "x" : -1320.9864474963913,
        "y" : -2337.363530788468
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16973",
        "degree_layout" : 43,
        "Description" : "\"Similar in sequence to DEAD-box RNA helicases. Binds RNA. Involved in drought, salt and cold stress responses.\"",
        "SecondarySymbol" : "RNA HELICASE 25 (ATRH25);STRESS RESPONSE SUPPRESSOR 2 (STRS2)",
        "sstart" : 46,
        "qstart" : 188,
        "qcovhsp" : 24,
        "shared_name" : "KfCluster-23832.0",
        "ppos" : 67.72,
        "score" : 1218,
        "pident" : 47.921,
        "SUID" : 16973,
        "selected" : false,
        "sseqid" : "AT5G08620",
        "length" : 505,
        "nident" : 242,
        "evalue" : 2.81E-160,
        "positive" : 342,
        "gaps" : 10,
        "Type" : "protein_coding",
        "bitscore" : 473.0,
        "slen" : 563,
        "mismatch" : 253,
        "name" : "KfCluster-23832.0",
        "send" : 547,
        "qcovs" : 72,
        "PrimarySymbol" : "STRESS RESPONSE SUPPRESSOR 2 (STRS2)",
        "qend" : 1681
      },
      "position" : {
        "x" : -1309.3050510120163,
        "y" : -2421.086187038468
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16972",
        "degree_layout" : 40,
        "Description" : "DEA(D/H)-box RNA helicase family protein;(source:Araport11)",
        "SecondarySymbol" : "(ATRH20);RNA HELICASE 20 (RH20)",
        "sstart" : 70,
        "qstart" : 2261,
        "qcovhsp" : 11,
        "shared_name" : "KfCluster-23031.0",
        "ppos" : 63.38,
        "score" : 734,
        "pident" : 43.38,
        "SUID" : 16972,
        "selected" : false,
        "sseqid" : "AT1G55150",
        "length" : 355,
        "nident" : 154,
        "evalue" : 7.87E-86,
        "positive" : 225,
        "gaps" : 16,
        "Type" : "protein_coding",
        "bitscore" : 287.0,
        "slen" : 501,
        "mismatch" : 185,
        "name" : "KfCluster-23031.0",
        "send" : 410,
        "qcovs" : 32,
        "PrimarySymbol" : "RNA HELICASE 20 (RH20)",
        "qend" : 3319
      },
      "position" : {
        "x" : -1288.7789279651413,
        "y" : -2385.938970241593
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17818",
        "degree_layout" : 10,
        "Description" : "DRA2 is a homolog of mammalian nucleoporin 98 and a likely component of the nuclear pore complex in Arabidopsis. It positively participates in the control of the hypocotyl elongation response to plant proximity and control of shade induced gene expression.",
        "SecondarySymbol" : "DRACULA2 (DRA2)",
        "sstart" : 884,
        "qstart" : 311,
        "qcovhsp" : 5,
        "shared_name" : "SpCluster-7195.39",
        "ppos" : 64.13,
        "score" : 242,
        "pident" : 51.087,
        "SUID" : 17818,
        "selected" : false,
        "sseqid" : "AT1G10390",
        "length" : 92,
        "nident" : 47,
        "evalue" : 7.71E-21,
        "positive" : 59,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 97.8,
        "slen" : 1041,
        "mismatch" : 45,
        "name" : "SpCluster-7195.39",
        "send" : 975,
        "qcovs" : 14,
        "PrimarySymbol" : "DRACULA2 (DRA2)",
        "qend" : 36
      },
      "position" : {
        "x" : 2074.981177478923,
        "y" : -2536.3205329476727
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16971",
        "degree_layout" : 41,
        "Description" : "eukaryotic translation initiation factor 4A-1",
        "SecondarySymbol" : "EUKARYOTIC TRANSLATION INITIATION FACTOR 4A1 (EIF4A1); (TIF4A1); (RH4)",
        "sstart" : 266,
        "qstart" : 1,
        "qcovhsp" : 8,
        "shared_name" : "KfCluster-20407.0",
        "ppos" : 97.81,
        "score" : 682,
        "pident" : 92.701,
        "SUID" : 16971,
        "selected" : false,
        "sseqid" : "AT3G13920",
        "length" : 137,
        "nident" : 127,
        "evalue" : 5.71E-84,
        "positive" : 134,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 267.0,
        "slen" : 402,
        "mismatch" : 10,
        "name" : "KfCluster-20407.0",
        "send" : 402,
        "qcovs" : 24,
        "PrimarySymbol" : "EUKARYOTIC TRANSLATION INITIATION FACTOR 4A1 (EIF4A1)",
        "qend" : 411
      },
      "position" : {
        "x" : -1327.9461642932663,
        "y" : -2460.331548366593
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17817",
        "degree_layout" : 2,
        "Description" : "SMAD/FHA domain-containing protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 240,
        "qstart" : 3384,
        "qcovhsp" : 7,
        "shared_name" : "PpCluster-26528.0",
        "ppos" : 65.51,
        "score" : 486,
        "pident" : 40.823,
        "SUID" : 17817,
        "selected" : false,
        "sseqid" : "AT2G45460",
        "length" : 316,
        "nident" : 129,
        "evalue" : 1.67E-49,
        "positive" : 207,
        "gaps" : 2,
        "Type" : "protein_coding",
        "bitscore" : 191.0,
        "slen" : 902,
        "mismatch" : 185,
        "name" : "PpCluster-26528.0",
        "send" : 555,
        "qcovs" : 21,
        "PrimarySymbol" : "0",
        "qend" : 2443
      },
      "position" : {
        "x" : 1665.8069831429855,
        "y" : -2300.484154552327
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16970",
        "degree_layout" : 46,
        "Description" : "DEA(D/H)-box RNA helicase family protein;(source:Araport11)",
        "SecondarySymbol" : "(RH5);STRESS RESPONSE SUPPRESSOR 1 (STRS1)",
        "sstart" : 86,
        "qstart" : 899,
        "qcovhsp" : 13,
        "shared_name" : "KfCluster-19315.0",
        "ppos" : 72.21,
        "score" : 1272,
        "pident" : 57.245,
        "SUID" : 16970,
        "selected" : false,
        "sseqid" : "AT1G31970",
        "length" : 421,
        "nident" : 241,
        "evalue" : 1.95E-164,
        "positive" : 304,
        "gaps" : 8,
        "Type" : "protein_coding",
        "bitscore" : 494.0,
        "slen" : 537,
        "mismatch" : 172,
        "name" : "KfCluster-19315.0",
        "send" : 506,
        "qcovs" : 40,
        "PrimarySymbol" : "STRESS RESPONSE SUPPRESSOR 1 (STRS1)",
        "qend" : 2137
      },
      "position" : {
        "x" : -1245.9019748401413,
        "y" : -2454.798833522843
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16969",
        "degree_layout" : 46,
        "Description" : "RNA HELICASE DRH1",
        "SecondarySymbol" : "ARABIDOPSIS THALIANA DEAD BOX RNA HELICASE 1 (ATDRH1);DEAD BOX RNA HELICASE 1 (DRH1)",
        "sstart" : 123,
        "qstart" : 2792,
        "qcovhsp" : 10,
        "shared_name" : "KfCluster-16828.0",
        "ppos" : 73.06,
        "score" : 1060,
        "pident" : 54.722,
        "SUID" : 16969,
        "selected" : false,
        "sseqid" : "AT3G01540",
        "length" : 360,
        "nident" : 197,
        "evalue" : 1.15E-130,
        "positive" : 263,
        "gaps" : 3,
        "Type" : "protein_coding",
        "bitscore" : 412.0,
        "slen" : 618,
        "mismatch" : 160,
        "name" : "KfCluster-16828.0",
        "send" : 482,
        "qcovs" : 30,
        "PrimarySymbol" : "DEAD BOX RNA HELICASE 1 (DRH1)",
        "qend" : 1722
      },
      "position" : {
        "x" : -1351.6785861682663,
        "y" : -2380.565923366593
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16968",
        "degree_layout" : 4,
        "Description" : "\"Encodes a subunit of eukaryotic initiation factor 3 (eIF3), a multisubunit complex that is required for binding of mRNA to 40 S ribosomal subunits, stabilization of ternary complex binding to 40 S subunits, and dissociation of 40 and 60 S subunits.\"",
        "SecondarySymbol" : "EUKARYOTIC TRANSLATION INITIATION FACTOR 3A (EIF3A); (ATEIF3A-1); (TIF3A1); (ATTIF3A1); (EIF3A-1)",
        "sstart" : 1,
        "qstart" : 3445,
        "qcovhsp" : 24,
        "shared_name" : "SpCluster-9705.0",
        "ppos" : 73.77,
        "score" : 2030,
        "pident" : 56.886,
        "SUID" : 16968,
        "selected" : false,
        "sseqid" : "AT4G11420",
        "length" : 835,
        "nident" : 475,
        "evalue" : 0.0,
        "positive" : 616,
        "gaps" : 33,
        "Type" : "protein_coding",
        "bitscore" : 786.0,
        "slen" : 987,
        "mismatch" : 327,
        "name" : "SpCluster-9705.0",
        "send" : 804,
        "qcovs" : 71,
        "PrimarySymbol" : "EUKARYOTIC TRANSLATION INITIATION FACTOR 3A (EIF3A)",
        "qend" : 947
      },
      "position" : {
        "x" : -305.7427673339844,
        "y" : -1154.6142578125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16967",
        "degree_layout" : 5,
        "Description" : "\"Encodes a subunit of eukaryotic initiation factor 3 (eIF3), a multisubunit complex that is required for binding of mRNA to 40 S ribosomal subunits, stabilization of ternary complex binding to 40 S subunits, and dissociation of 40 and 60 S subunits.\"",
        "SecondarySymbol" : "EUKARYOTIC TRANSLATION INITIATION FACTOR 3A (EIF3A); (ATEIF3A-1); (TIF3A1); (ATTIF3A1); (EIF3A-1)",
        "sstart" : 1,
        "qstart" : 125,
        "qcovhsp" : 21,
        "shared_name" : "PpCluster-27177.3",
        "ppos" : 82.86,
        "score" : 2408,
        "pident" : 65.968,
        "SUID" : 16967,
        "selected" : false,
        "sseqid" : "AT4G11420",
        "length" : 811,
        "nident" : 535,
        "evalue" : 0.0,
        "positive" : 672,
        "gaps" : 5,
        "Type" : "protein_coding",
        "bitscore" : 932.0,
        "slen" : 987,
        "mismatch" : 271,
        "name" : "PpCluster-27177.3",
        "send" : 807,
        "qcovs" : 62,
        "PrimarySymbol" : "EUKARYOTIC TRANSLATION INITIATION FACTOR 3A (EIF3A)",
        "qend" : 2554
      },
      "position" : {
        "x" : -36.78700256347656,
        "y" : -1253.61474609375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17814",
        "degree_layout" : 3,
        "Description" : "\"Arabidopsis thaliana telomere-binding protein, putative (At1g07540)\"",
        "SecondarySymbol" : "TRF-LIKE 2 (TRFL2)",
        "sstart" : 530,
        "qstart" : 702,
        "qcovhsp" : 6,
        "shared_name" : "SpCluster-13509.0",
        "ppos" : 76.4,
        "score" : 316,
        "pident" : 66.292,
        "SUID" : 17814,
        "selected" : false,
        "sseqid" : "AT1G07540",
        "length" : 89,
        "nident" : 59,
        "evalue" : 1.22E-30,
        "positive" : 68,
        "gaps" : 9,
        "Type" : "protein_coding",
        "bitscore" : 126.0,
        "slen" : 630,
        "mismatch" : 21,
        "name" : "SpCluster-13509.0",
        "send" : 609,
        "qcovs" : 17,
        "PrimarySymbol" : "TRF-LIKE 2 (TRFL2)",
        "qend" : 436
      },
      "position" : {
        "x" : 151.55487060546875,
        "y" : -1310.5350341796875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17813",
        "degree_layout" : 3,
        "Description" : "\"CAMTA2 proteins bind to the AtALMT1 promoter at in vitro. The gene itself is Al inducible, and AtALMT1 expression is partially repressed in camta2 mutant. The mRNA is cell-to-cell mobile.\"",
        "SecondarySymbol" : "CALMODULIN-BINDING TRANSCRIPTION ACTIVATOR 2 (CAMTA2)",
        "sstart" : 496,
        "qstart" : 1859,
        "qcovhsp" : 22,
        "shared_name" : "SpCluster-9645.0",
        "ppos" : 51.54,
        "score" : 571,
        "pident" : 32.819,
        "SUID" : 17813,
        "selected" : false,
        "sseqid" : "AT5G64220",
        "length" : 518,
        "nident" : 170,
        "evalue" : 1.41E-61,
        "positive" : 267,
        "gaps" : 30,
        "Type" : "protein_coding",
        "bitscore" : 224.0,
        "slen" : 1050,
        "mismatch" : 318,
        "name" : "SpCluster-9645.0",
        "send" : 998,
        "qcovs" : 66,
        "PrimarySymbol" : "CALMODULIN-BINDING TRANSCRIPTION ACTIVATOR 2 (CAMTA2)",
        "qend" : 351
      },
      "position" : {
        "x" : -452.8371887207031,
        "y" : -175.1199188232422
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17812",
        "degree_layout" : 2,
        "Description" : "\"Encodes a class XI myosin that is involved in organelle motility, actin organization, and optimal growth of pollen tubes.\"",
        "SecondarySymbol" : "(XIE);MYOSIN XI E (ATXIE)",
        "sstart" : 1116,
        "qstart" : 1705,
        "qcovhsp" : 8,
        "shared_name" : "SpCluster-13395.0",
        "ppos" : 48.84,
        "score" : 487,
        "pident" : 32.093,
        "SUID" : 17812,
        "selected" : false,
        "sseqid" : "AT1G54560",
        "length" : 430,
        "nident" : 138,
        "evalue" : 4.88E-49,
        "positive" : 210,
        "gaps" : 105,
        "Type" : "protein_coding",
        "bitscore" : 192.0,
        "slen" : 1529,
        "mismatch" : 187,
        "name" : "SpCluster-13395.0",
        "send" : 1528,
        "qcovs" : 23,
        "PrimarySymbol" : "(XIE)",
        "qend" : 680
      },
      "position" : {
        "x" : -528.2848510742188,
        "y" : -171.38915126249069
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17811",
        "degree_layout" : 4,
        "Description" : "\"Encodes a class XI myosin that is involved in organelle motility, actin organization, and optimal growth of pollen tubes.\"",
        "SecondarySymbol" : "(XIE);MYOSIN XI E (ATXIE)",
        "sstart" : 1021,
        "qstart" : 2465,
        "qcovhsp" : 13,
        "shared_name" : "PpCluster-26121.0",
        "ppos" : 71.55,
        "score" : 1195,
        "pident" : 56.455,
        "SUID" : 17811,
        "selected" : false,
        "sseqid" : "AT1G54560",
        "length" : 457,
        "nident" : 258,
        "evalue" : 0.0,
        "positive" : 327,
        "gaps" : 33,
        "Type" : "protein_coding",
        "bitscore" : 464.0,
        "slen" : 1529,
        "mismatch" : 166,
        "name" : "PpCluster-26121.0",
        "send" : 1452,
        "qcovs" : 40,
        "PrimarySymbol" : "(XIE)",
        "qend" : 1119
      },
      "position" : {
        "x" : -512.746826171875,
        "y" : -265.21431605741253
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17810",
        "degree_layout" : 2,
        "Description" : "",
        "SecondarySymbol" : "",
        "shared_name" : "SpCluster-18194.1",
        "SUID" : 17810,
        "selected" : false,
        "sseqid" : "",
        "Type" : "",
        "name" : "SpCluster-18194.1",
        "PrimarySymbol" : ""
      },
      "position" : {
        "x" : 568.3695453992558,
        "y" : -1809.3878591363095
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16952",
        "degree_layout" : 28,
        "Description" : "RNA-binding (RRM/RBD/RNP motifs) family protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 1,
        "qstart" : 135,
        "qcovhsp" : 10,
        "shared_name" : "SpCluster-19309.0",
        "ppos" : 82.13,
        "score" : 767,
        "pident" : 69.565,
        "SUID" : 16952,
        "selected" : false,
        "sseqid" : "AT5G55550",
        "length" : 207,
        "nident" : 144,
        "evalue" : 1.8E-94,
        "positive" : 170,
        "gaps" : 7,
        "Type" : "protein_coding",
        "bitscore" : 300.0,
        "slen" : 448,
        "mismatch" : 56,
        "name" : "SpCluster-19309.0",
        "send" : 202,
        "qcovs" : 29,
        "PrimarySymbol" : "0",
        "qend" : 749
      },
      "position" : {
        "x" : -1628.80908203125,
        "y" : -985.0144653320312
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17809",
        "degree_layout" : 5,
        "Description" : "\"Encodes MUSE13, a TRAF domain protein. Regulates the turnover of nucleotide-binding domain and leucine-rich repeat-containing (NLR) immune receptors SNC1 and RPS2. Loss of both MUSE13 and MUSE14 leads to enhanced pathogen resistance, NLR accumulation, and autoimmunity.In addition, MUSE13/14 physically interact with ATG6 and appear to regulate ATG6 ubiquitination and thus formation of autophagosomes.\"",
        "SecondarySymbol" : "TUMOR NECROSIS FACTOR RECEPTOR-ASSOCIATED FACTOR 1B (TRAF1B); (MUSE13)",
        "sstart" : 125,
        "qstart" : 2,
        "qcovhsp" : 6,
        "shared_name" : "PpCluster-25945.1",
        "ppos" : 79.45,
        "score" : 630,
        "pident" : 63.47,
        "SUID" : 17809,
        "selected" : false,
        "sseqid" : "AT1G04300",
        "length" : 219,
        "nident" : 139,
        "evalue" : 1.7E-67,
        "positive" : 174,
        "gaps" : 3,
        "Type" : "protein_coding",
        "bitscore" : 247.0,
        "slen" : 997,
        "mismatch" : 77,
        "name" : "PpCluster-25945.1",
        "send" : 340,
        "qcovs" : 19,
        "PrimarySymbol" : "(MUSE13)",
        "qend" : 658
      },
      "position" : {
        "x" : 881.4752197265625,
        "y" : -2438.87109375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17808",
        "degree_layout" : 3,
        "Description" : "\"Encodes MUSE13, a TRAF domain protein. Regulates the turnover of nucleotide-binding domain and leucine-rich repeat-containing (NLR) immune receptors SNC1 and RPS2. Loss of both MUSE13 and MUSE14 leads to enhanced pathogen resistance, NLR accumulation, and autoimmunity.In addition, MUSE13/14 physically interact with ATG6 and appear to regulate ATG6 ubiquitination and thus formation of autophagosomes.\"",
        "SecondarySymbol" : "TUMOR NECROSIS FACTOR RECEPTOR-ASSOCIATED FACTOR 1B (TRAF1B); (MUSE13)",
        "sstart" : 937,
        "qstart" : 2976,
        "qcovhsp" : 1,
        "shared_name" : "PpCluster-25945.0",
        "ppos" : 65.12,
        "score" : 103,
        "pident" : 44.186,
        "SUID" : 17808,
        "selected" : false,
        "sseqid" : "AT1G04300",
        "length" : 43,
        "nident" : 19,
        "evalue" : 6.72E-4,
        "positive" : 28,
        "gaps" : 1,
        "Type" : "protein_coding",
        "bitscore" : 44.3,
        "slen" : 1074,
        "mismatch" : 23,
        "name" : "PpCluster-25945.0",
        "send" : 978,
        "qcovs" : 4,
        "PrimarySymbol" : "(MUSE13)",
        "qend" : 3104
      },
      "position" : {
        "x" : 953.0369262695312,
        "y" : -2592.97802734375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16951",
        "degree_layout" : 21,
        "Description" : "nucleotide/nucleic acid binding protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 405,
        "qstart" : 660,
        "qcovhsp" : 21,
        "shared_name" : "SpCluster-18348.1",
        "ppos" : 59.3,
        "score" : 830,
        "pident" : 42.67,
        "SUID" : 16951,
        "selected" : false,
        "sseqid" : "AT4G19610",
        "length" : 457,
        "nident" : 195,
        "evalue" : 7.35E-111,
        "positive" : 271,
        "gaps" : 50,
        "Type" : "protein_coding",
        "bitscore" : 324.0,
        "slen" : 816,
        "mismatch" : 212,
        "name" : "SpCluster-18348.1",
        "send" : 814,
        "qcovs" : 63,
        "PrimarySymbol" : "0",
        "qend" : 2021
      },
      "position" : {
        "x" : -1661.851806640625,
        "y" : -870.5724487304688
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16950",
        "degree_layout" : 16,
        "Description" : "\"Encodes ATNUC-L1 (NUCLEOLIN LIKE 1), the predominant form of the two nucleolin proteins found in Arabidopsis. This protein is involved in rRNA processing, ribosome biosynthesis, and vascular pattern formation. PARL1 localizes to the nucleolus and parl1 mutants accumulate elevated levels of the unspliced 35S pre-rRNA. parl1 mutants also have defects in cotyledon, leaf, sepal, and petal vein patterning and have reduced stature, reduced fertility, increased bushiness, and reduced root length. The sugar-induced expression of ribosome proteins is also reduced in parl1 mutants. The mRNA is cell-to-cell mobile.\"",
        "SecondarySymbol" : "NUCLEOLIN LIKE 1 (ATNUC-L1);PARALLEL 1 (PARL1);NUCLEOLIN 1 (NUC1);NUCLEOLIN LIKE 1 (NUC-L1)",
        "sstart" : 365,
        "qstart" : 1011,
        "qcovhsp" : 8,
        "shared_name" : "SpCluster-11529.0",
        "ppos" : 60.0,
        "score" : 204,
        "pident" : 45.455,
        "SUID" : 16950,
        "selected" : false,
        "sseqid" : "AT1G48920",
        "length" : 110,
        "nident" : 50,
        "evalue" : 6.31E-17,
        "positive" : 66,
        "gaps" : 8,
        "Type" : "protein_coding",
        "bitscore" : 83.2,
        "slen" : 557,
        "mismatch" : 52,
        "name" : "SpCluster-11529.0",
        "send" : 472,
        "qcovs" : 24,
        "PrimarySymbol" : "NUCLEOLIN LIKE 1 (NUC-L1)",
        "qend" : 1322
      },
      "position" : {
        "x" : -1586.191162109375,
        "y" : -835.2508544921875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16949",
        "degree_layout" : 27,
        "Description" : "RNA-binding (RRM/RBD/RNP motifs) family protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 21,
        "qstart" : 3834,
        "qcovhsp" : 9,
        "shared_name" : "PpCluster-9958.0",
        "ppos" : 55.58,
        "score" : 715,
        "pident" : 41.624,
        "SUID" : 16949,
        "selected" : false,
        "sseqid" : "AT2G21440",
        "length" : 394,
        "nident" : 164,
        "evalue" : 4.54E-78,
        "positive" : 219,
        "gaps" : 46,
        "Type" : "protein_coding",
        "bitscore" : 280.0,
        "slen" : 1003,
        "mismatch" : 184,
        "name" : "PpCluster-9958.0",
        "send" : 413,
        "qcovs" : 27,
        "PrimarySymbol" : "0",
        "qend" : 2788
      },
      "position" : {
        "x" : -1617.9515380859375,
        "y" : -921.9151611328125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16948",
        "degree_layout" : 30,
        "Description" : "\"Splicing factor, CC1-like protein;(source:Araport11)\"",
        "SecondarySymbol" : "0",
        "sstart" : 158,
        "qstart" : 3066,
        "qcovhsp" : 8,
        "shared_name" : "MpCluster-17918.0",
        "ppos" : 69.75,
        "score" : 1010,
        "pident" : 60.49,
        "SUID" : 16948,
        "selected" : false,
        "sseqid" : "AT5G09880",
        "length" : 367,
        "nident" : 222,
        "evalue" : 5.24E-123,
        "positive" : 256,
        "gaps" : 55,
        "Type" : "protein_coding",
        "bitscore" : 393.0,
        "slen" : 527,
        "mismatch" : 90,
        "name" : "MpCluster-17918.0",
        "send" : 478,
        "qcovs" : 25,
        "PrimarySymbol" : "0",
        "qend" : 1993
      },
      "position" : {
        "x" : -1523.4029541015625,
        "y" : -1011.2496337890625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16947",
        "degree_layout" : 20,
        "Description" : "Encodes an RNA?binding protein involved in stress granule formation. Regulated by a transposable element small RNA.",
        "SecondarySymbol" : "OLIGOURIDYLATE BINDING PROTEIN 1B (UBP1B)",
        "sstart" : 117,
        "qstart" : 1193,
        "qcovhsp" : 5,
        "shared_name" : "KfCluster-29906.0",
        "ppos" : 86.14,
        "score" : 416,
        "pident" : 71.287,
        "SUID" : 16947,
        "selected" : false,
        "sseqid" : "AT1G17370",
        "length" : 101,
        "nident" : 72,
        "evalue" : 2.77E-44,
        "positive" : 87,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 164.0,
        "slen" : 416,
        "mismatch" : 29,
        "name" : "KfCluster-29906.0",
        "send" : 217,
        "qcovs" : 14,
        "PrimarySymbol" : "OLIGOURIDYLATE BINDING PROTEIN 1B (UBP1B)",
        "qend" : 1495
      },
      "position" : {
        "x" : -1689.4202880859375,
        "y" : -935.9686279296875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16946",
        "degree_layout" : 2,
        "Description" : "Nuclear transport factor 2 (NTF2) family protein with RNA binding (RRM-RBD-RNP motifs) domain-containing protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 313,
        "qstart" : 1351,
        "qcovhsp" : 4,
        "shared_name" : "KfCluster-26927.0",
        "ppos" : 64.38,
        "score" : 160,
        "pident" : 38.356,
        "SUID" : 16946,
        "selected" : false,
        "sseqid" : "AT3G25150",
        "length" : 73,
        "nident" : 28,
        "evalue" : 3.52E-11,
        "positive" : 47,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 66.2,
        "slen" : 488,
        "mismatch" : 45,
        "name" : "KfCluster-26927.0",
        "send" : 385,
        "qcovs" : 11,
        "PrimarySymbol" : "0",
        "qend" : 1133
      },
      "position" : {
        "x" : -1679.031982421875,
        "y" : -785.4605102539062
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16945",
        "degree_layout" : 20,
        "Description" : "RNA-binding (RRM/RBD/RNP motifs) family protein;(source:Araport11)",
        "SecondarySymbol" : "BRUNO-LIKE 2 (BRN2); (ATBRN2)",
        "sstart" : 51,
        "qstart" : 1582,
        "qcovhsp" : 6,
        "shared_name" : "KfCluster-24800.0",
        "ppos" : 57.45,
        "score" : 275,
        "pident" : 40.426,
        "SUID" : 16945,
        "selected" : false,
        "sseqid" : "AT1G03457",
        "length" : 141,
        "nident" : 57,
        "evalue" : 1.87E-25,
        "positive" : 81,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 110.0,
        "slen" : 429,
        "mismatch" : 84,
        "name" : "KfCluster-24800.0",
        "send" : 191,
        "qcovs" : 17,
        "PrimarySymbol" : "BRUNO-LIKE 2 (BRN2)",
        "qend" : 1160
      },
      "position" : {
        "x" : -1592.697509765625,
        "y" : -1014.5333251953125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16944",
        "degree_layout" : 26,
        "Description" : "Belongs to a member of the RNA-binding glycine-rich (RBG) gene superfamily.",
        "SecondarySymbol" : "RNA-BINDING GLYCINE-RICH PROTEIN D1 (RBGD1)",
        "sstart" : 66,
        "qstart" : 1943,
        "qcovhsp" : 6,
        "shared_name" : "KfCluster-17491.0",
        "ppos" : 75.0,
        "score" : 511,
        "pident" : 56.977,
        "SUID" : 16944,
        "selected" : false,
        "sseqid" : "AT1G17640",
        "length" : 172,
        "nident" : 98,
        "evalue" : 2.34E-57,
        "positive" : 129,
        "gaps" : 5,
        "Type" : "protein_coding",
        "bitscore" : 201.0,
        "slen" : 369,
        "mismatch" : 69,
        "name" : "KfCluster-17491.0",
        "send" : 237,
        "qcovs" : 19,
        "PrimarySymbol" : "RNA-BINDING GLYCINE-RICH PROTEIN D1 (RBGD1)",
        "qend" : 1443
      },
      "position" : {
        "x" : -1530.04150390625,
        "y" : -957.245849609375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16943",
        "degree_layout" : 24,
        "Description" : "Putative poly-A binding protein. Member of a gene family .Expressed in stele and root meristem and post-fertilization ovules.Member of the class II family of PABP proteins. The mRNA is cell-to-cell mobile.",
        "SecondarySymbol" : "ARABIDOPSIS POLY(A) BINDING 2 (ATPAB2);POLY(A) BINDING PROTEIN 2 (PABP2);POLY(A) BINDING PROTEIN 2 (PAB2)",
        "sstart" : 37,
        "qstart" : 486,
        "qcovhsp" : 13,
        "shared_name" : "KfCluster-16527.0",
        "ppos" : 73.8,
        "score" : 1163,
        "pident" : 55.529,
        "SUID" : 16943,
        "selected" : false,
        "sseqid" : "AT4G34110",
        "length" : 416,
        "nident" : 231,
        "evalue" : 1.37E-146,
        "positive" : 307,
        "gaps" : 6,
        "Type" : "protein_coding",
        "bitscore" : 452.0,
        "slen" : 629,
        "mismatch" : 179,
        "name" : "KfCluster-16527.0",
        "send" : 449,
        "qcovs" : 39,
        "PrimarySymbol" : "POLY(A) BINDING PROTEIN 2 (PAB2)",
        "qend" : 1724
      },
      "position" : {
        "x" : -1574.875732421875,
        "y" : -898.6559448242188
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16942",
        "degree_layout" : 15,
        "Description" : "\"LEUNIG regulates floral organ identity,gynoecium and ovule development. Negatively regulates AGAMOUS . Encodes a glutamine-rich protein with seven WD repeats similar to transcriptional corepressors.\"",
        "SecondarySymbol" : "LEUNIG (LUG)",
        "sstart" : 576,
        "qstart" : 1554,
        "qcovhsp" : 9,
        "shared_name" : "SpCluster-6937.0",
        "ppos" : 76.58,
        "score" : 1251,
        "pident" : 62.259,
        "SUID" : 16942,
        "selected" : false,
        "sseqid" : "AT4G32551",
        "length" : 363,
        "nident" : 226,
        "evalue" : 4.78E-153,
        "positive" : 278,
        "gaps" : 8,
        "Type" : "protein_coding",
        "bitscore" : 486.0,
        "slen" : 931,
        "mismatch" : 129,
        "name" : "SpCluster-6937.0",
        "send" : 930,
        "qcovs" : 27,
        "PrimarySymbol" : "LEUNIG (LUG)",
        "qend" : 466
      },
      "position" : {
        "x" : -775.090576171875,
        "y" : -484.6741943359375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16941",
        "degree_layout" : 6,
        "Description" : "Transducin family protein / WD-40 repeat family protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 30,
        "qstart" : 3502,
        "qcovhsp" : 7,
        "shared_name" : "SpCluster-6623.0",
        "ppos" : 72.05,
        "score" : 777,
        "pident" : 60.63,
        "SUID" : 16941,
        "selected" : false,
        "sseqid" : "AT1G04140",
        "length" : 254,
        "nident" : 154,
        "evalue" : 4.67E-88,
        "positive" : 183,
        "gaps" : 3,
        "Type" : "protein_coding",
        "bitscore" : 303.0,
        "slen" : 790,
        "mismatch" : 97,
        "name" : "SpCluster-6623.0",
        "send" : 281,
        "qcovs" : 20,
        "PrimarySymbol" : "0",
        "qend" : 2744
      },
      "position" : {
        "x" : -674.7040405273438,
        "y" : -472.7333679199219
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16940",
        "degree_layout" : 14,
        "Description" : "\"similar to man and yeast U3-55K genes, involved in processing of pre-ribosomal RNA.\"",
        "SecondarySymbol" : "EMBRYO DEFECTIVE 2271 (EMB2271)",
        "sstart" : 104,
        "qstart" : 1679,
        "qcovhsp" : 13,
        "shared_name" : "SpCluster-12636.0",
        "ppos" : 63.92,
        "score" : 593,
        "pident" : 42.268,
        "SUID" : 16940,
        "selected" : false,
        "sseqid" : "AT4G21130",
        "length" : 291,
        "nident" : 123,
        "evalue" : 1.39E-68,
        "positive" : 186,
        "gaps" : 9,
        "Type" : "protein_coding",
        "bitscore" : 233.0,
        "slen" : 479,
        "mismatch" : 159,
        "name" : "SpCluster-12636.0",
        "send" : 385,
        "qcovs" : 40,
        "PrimarySymbol" : "EMBRYO DEFECTIVE 2271 (EMB2271)",
        "qend" : 807
      },
      "position" : {
        "x" : -735.3682861328125,
        "y" : -517.6975708007812
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16939",
        "degree_layout" : 16,
        "Description" : "\"LEUNIG regulates floral organ identity,gynoecium and ovule development. Negatively regulates AGAMOUS . Encodes a glutamine-rich protein with seven WD repeats similar to transcriptional corepressors.\"",
        "SecondarySymbol" : "LEUNIG (LUG)",
        "sstart" : 638,
        "qstart" : 486,
        "qcovhsp" : 15,
        "shared_name" : "PpCluster-8705.3",
        "ppos" : 84.43,
        "score" : 1134,
        "pident" : 70.934,
        "SUID" : 16939,
        "selected" : false,
        "sseqid" : "AT4G32551",
        "length" : 289,
        "nident" : 205,
        "evalue" : 1.15E-143,
        "positive" : 244,
        "gaps" : 1,
        "Type" : "protein_coding",
        "bitscore" : 441.0,
        "slen" : 931,
        "mismatch" : 83,
        "name" : "PpCluster-8705.3",
        "send" : 925,
        "qcovs" : 45,
        "PrimarySymbol" : "LEUNIG (LUG)",
        "qend" : 1352
      },
      "position" : {
        "x" : -756.5072631835938,
        "y" : -417.5190734863281
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16938",
        "degree_layout" : 15,
        "Description" : "This gene is predicted to encode a protein with a DWD motif. It can bind to DDB1a in Y2H assays and may be involved in the formation of a CUL4-based E3 ubiquitin ligase",
        "SecondarySymbol" : "0",
        "sstart" : 1,
        "qstart" : 696,
        "qcovhsp" : 10,
        "shared_name" : "KfCluster-31227.0",
        "ppos" : 80.27,
        "score" : 1350,
        "pident" : 63.784,
        "SUID" : 16938,
        "selected" : false,
        "sseqid" : "AT4G28450",
        "length" : 370,
        "nident" : 236,
        "evalue" : 1.06E-175,
        "positive" : 297,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 524.0,
        "slen" : 452,
        "mismatch" : 134,
        "name" : "KfCluster-31227.0",
        "send" : 370,
        "qcovs" : 31,
        "PrimarySymbol" : "0",
        "qend" : 1805
      },
      "position" : {
        "x" : -724.9257202148438,
        "y" : -423.7914123535156
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16937",
        "degree_layout" : 14,
        "Description" : "Encodes a transducin family nucleolar protein with six WD40 repeats that is most likely involved in 18S rRNA biogenesis. The slow progression of the gametophytic division cycles in swa1 suggested that the SWA1 protein is required for the normal progression of mitotic division cycles through the regulation of cell metabolism. Ubiquitously expressed throughout the plant.",
        "SecondarySymbol" : "SLOW WALKER1 (SWA1);EMBRYO SAC DEVELOPMENT ARREST 19 (EDA19);EMBRYO SAC DEVELOPMENT ARREST 13 (EDA13)",
        "sstart" : 28,
        "qstart" : 480,
        "qcovhsp" : 20,
        "shared_name" : "KfCluster-16447.0",
        "ppos" : 56.16,
        "score" : 830,
        "pident" : 36.986,
        "SUID" : 16937,
        "selected" : false,
        "sseqid" : "AT2G47990",
        "length" : 511,
        "nident" : 189,
        "evalue" : 2.72E-101,
        "positive" : 287,
        "gaps" : 24,
        "Type" : "protein_coding",
        "bitscore" : 324.0,
        "slen" : 530,
        "mismatch" : 298,
        "name" : "KfCluster-16447.0",
        "send" : 522,
        "qcovs" : 60,
        "PrimarySymbol" : "SLOW WALKER1 (SWA1)",
        "qend" : 1988
      },
      "position" : {
        "x" : -702.5457763671875,
        "y" : -584.9675903320312
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16936",
        "degree_layout" : 1,
        "Description" : "Encodes a plastid-localized &#945;-amylase. Expression is reduced in the SEX4 mutant. Loss of function mutations show normal diurnal pattern of starch accumulation/degradation.  Expression follows circadian rhythms.",
        "SecondarySymbol" : "ALPHA-AMYLASE-LIKE 3 (AMY3);ALPHA-AMYLASE-LIKE 3 (ATAMY3)",
        "sstart" : 840,
        "qstart" : 689,
        "qcovhsp" : 1,
        "shared_name" : "KfCluster-16445.0",
        "ppos" : 54.17,
        "score" : 68,
        "pident" : 33.333,
        "SUID" : 16936,
        "selected" : false,
        "sseqid" : "AT1G69830",
        "length" : 48,
        "nident" : 16,
        "evalue" : 7.5,
        "positive" : 26,
        "gaps" : 9,
        "Type" : "protein_coding",
        "bitscore" : 30.8,
        "slen" : 887,
        "mismatch" : 23,
        "name" : "KfCluster-16445.0",
        "send" : 884,
        "qcovs" : 4,
        "PrimarySymbol" : "ALPHA-AMYLASE-LIKE 3 (AMY3)",
        "qend" : 814
      },
      "position" : {
        "x" : -151.45074462890625,
        "y" : -450.7156982421875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16931",
        "Description" : "\"Required for nonsense-mediated mRNA decay. Involved in RNA interference. lba1 mutants has reduced sugar-induced expression of Atb-  amylase, is hypersensitive to glucose and abscisic acid and resistant to mannose, and shows early flowering, short day-sensitive growth, and seed germination phenotypes. The mRNA is cell-to-cell mobile.\"",
        "SecondarySymbol" : "(UPF1); (ATUPF1);LOW-LEVEL BETA-AMYLASE 1 (LBA1)",
        "sstart" : 9,
        "qstart" : 111,
        "qcovhsp" : 28,
        "shared_name" : "SpCluster-16599.0",
        "ppos" : 74.22,
        "score" : 4056,
        "pident" : 64.439,
        "SUID" : 16931,
        "selected" : false,
        "sseqid" : "AT5G47010",
        "length" : 1257,
        "nident" : 810,
        "evalue" : 0.0,
        "positive" : 933,
        "gaps" : 121,
        "Type" : "protein_coding",
        "bitscore" : 1566.0,
        "slen" : 1254,
        "mismatch" : 326,
        "name" : "SpCluster-16599.0",
        "send" : 1186,
        "qcovs" : 83,
        "PrimarySymbol" : "LOW-LEVEL BETA-AMYLASE 1 (LBA1)",
        "qend" : 3755
      },
      "position" : {
        "x" : 532.1163521378483,
        "y" : -3696.3959769637145
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17807",
        "degree_layout" : 6,
        "Description" : "splicing factor PWI domain-containing protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 1,
        "qstart" : 54,
        "qcovhsp" : 7,
        "shared_name" : "SpCluster-8930.0",
        "ppos" : 80.77,
        "score" : 522,
        "pident" : 65.385,
        "SUID" : 17807,
        "selected" : false,
        "sseqid" : "AT2G29210",
        "length" : 156,
        "nident" : 102,
        "evalue" : 9.21E-56,
        "positive" : 126,
        "gaps" : 4,
        "Type" : "protein_coding",
        "bitscore" : 205.0,
        "slen" : 878,
        "mismatch" : 50,
        "name" : "SpCluster-8930.0",
        "send" : 152,
        "qcovs" : 21,
        "PrimarySymbol" : "0",
        "qend" : 521
      },
      "position" : {
        "x" : 827.0472412109375,
        "y" : -1059.238525390625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16930",
        "Description" : "DNA-binding protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 4,
        "qstart" : 2282,
        "qcovhsp" : 22,
        "shared_name" : "SpCluster-15679.0",
        "ppos" : 77.36,
        "score" : 1884,
        "pident" : 60.0,
        "SUID" : 16930,
        "selected" : false,
        "sseqid" : "AT2G03270",
        "length" : 645,
        "nident" : 387,
        "evalue" : 0.0,
        "positive" : 499,
        "gaps" : 10,
        "Type" : "protein_coding",
        "bitscore" : 730.0,
        "slen" : 639,
        "mismatch" : 248,
        "name" : "SpCluster-15679.0",
        "send" : 639,
        "qcovs" : 65,
        "PrimarySymbol" : "0",
        "qend" : 351
      },
      "position" : {
        "x" : 415.011066493317,
        "y" : -3760.0658988387145
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17806",
        "degree_layout" : 4,
        "Description" : "splicing factor PWI domain-containing protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 1,
        "qstart" : 4446,
        "qcovhsp" : 3,
        "shared_name" : "PpCluster-25843.1",
        "ppos" : 85.53,
        "score" : 590,
        "pident" : 71.053,
        "SUID" : 17806,
        "selected" : false,
        "sseqid" : "AT2G29210",
        "length" : 152,
        "nident" : 108,
        "evalue" : 1.4E-62,
        "positive" : 130,
        "gaps" : 4,
        "Type" : "protein_coding",
        "bitscore" : 231.0,
        "slen" : 878,
        "mismatch" : 40,
        "name" : "PpCluster-25843.1",
        "send" : 148,
        "qcovs" : 10,
        "PrimarySymbol" : "0",
        "qend" : 3991
      },
      "position" : {
        "x" : 1022.583251953125,
        "y" : -881.1387329101562
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16929",
        "Description" : "Similar to yeast Sen1 (splicing endonuclease 1)helicase protein. Involved in female gametophyte development. The mRNA is cell-to-cell mobile.",
        "SecondarySymbol" : "MAGATAMA 3 (MAA3)",
        "sstart" : 375,
        "qstart" : 2742,
        "qcovhsp" : 6,
        "shared_name" : "PpCluster-14182.0",
        "ppos" : 55.42,
        "score" : 583,
        "pident" : 40.05,
        "SUID" : 16929,
        "selected" : false,
        "sseqid" : "AT4G15570",
        "length" : 397,
        "nident" : 159,
        "evalue" : 7.19E-62,
        "positive" : 220,
        "gaps" : 41,
        "Type" : "protein_coding",
        "bitscore" : 229.0,
        "slen" : 818,
        "mismatch" : 197,
        "name" : "PpCluster-14182.0",
        "send" : 751,
        "qcovs" : 19,
        "PrimarySymbol" : "MAGATAMA 3 (MAA3)",
        "qend" : 1615
      },
      "position" : {
        "x" : 468.9092903702701,
        "y" : -3719.7094535262145
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17805",
        "degree_layout" : 4,
        "Description" : "splicing factor PWI domain-containing protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 2,
        "qstart" : 4278,
        "qcovhsp" : 3,
        "shared_name" : "PpCluster-25843.0",
        "ppos" : 82.89,
        "score" : 542,
        "pident" : 67.105,
        "SUID" : 17805,
        "selected" : false,
        "sseqid" : "AT2G29210",
        "length" : 152,
        "nident" : 102,
        "evalue" : 1.53E-56,
        "positive" : 126,
        "gaps" : 5,
        "Type" : "protein_coding",
        "bitscore" : 213.0,
        "slen" : 878,
        "mismatch" : 45,
        "name" : "PpCluster-25843.0",
        "send" : 148,
        "qcovs" : 9,
        "PrimarySymbol" : "0",
        "qend" : 3823
      },
      "position" : {
        "x" : 957.8613891601562,
        "y" : -986.57177734375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16928",
        "Description" : "P-loop containing nucleoside triphosphate hydrolases superfamily protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 111,
        "qstart" : 3103,
        "qcovhsp" : 21,
        "shared_name" : "KfCluster-16273.0",
        "ppos" : 64.25,
        "score" : 1735,
        "pident" : 47.701,
        "SUID" : 16928,
        "selected" : false,
        "sseqid" : "AT5G35970",
        "length" : 870,
        "nident" : 415,
        "evalue" : 0.0,
        "positive" : 559,
        "gaps" : 73,
        "Type" : "protein_coding",
        "bitscore" : 672.0,
        "slen" : 961,
        "mismatch" : 382,
        "name" : "KfCluster-16273.0",
        "send" : 941,
        "qcovs" : 64,
        "PrimarySymbol" : "0",
        "qend" : 596
      },
      "position" : {
        "x" : 428.1653938858951,
        "y" : -3644.4946097762145
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16927",
        "degree_layout" : 2,
        "Description" : "member of eIF3c - eukaryotic initiation factor 3c",
        "SecondarySymbol" : "EUKARYOTIC TRANSLATION INITIATION FACTOR 3C (EIF3C); (ATEIF3C-1); (TIF3C1); (ATTIF3C1); (EIF3C-1)",
        "sstart" : 229,
        "qstart" : 762,
        "qcovhsp" : 20,
        "shared_name" : "SpCluster-18855.0",
        "ppos" : 73.9,
        "score" : 1764,
        "pident" : 53.834,
        "SUID" : 16927,
        "selected" : false,
        "sseqid" : "AT3G56150",
        "length" : 613,
        "nident" : 330,
        "evalue" : 0.0,
        "positive" : 453,
        "gaps" : 25,
        "Type" : "protein_coding",
        "bitscore" : 684.0,
        "slen" : 900,
        "mismatch" : 258,
        "name" : "SpCluster-18855.0",
        "send" : 816,
        "qcovs" : 61,
        "PrimarySymbol" : "EUKARYOTIC TRANSLATION INITIATION FACTOR 3C (EIF3C)",
        "qend" : 2600
      },
      "position" : {
        "x" : -1193.8768310546875,
        "y" : -1249.57666015625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16926",
        "degree_layout" : 4,
        "Description" : "member of eIF3c - eukaryotic initiation factor 3c",
        "SecondarySymbol" : "EUKARYOTIC TRANSLATION INITIATION FACTOR 3C (EIF3C); (ATEIF3C-1); (TIF3C1); (ATTIF3C1); (EIF3C-1)",
        "sstart" : 49,
        "qstart" : 410,
        "qcovhsp" : 23,
        "shared_name" : "KfCluster-15996.0",
        "ppos" : 75.31,
        "score" : 2178,
        "pident" : 56.642,
        "SUID" : 16926,
        "selected" : false,
        "sseqid" : "AT3G56150",
        "length" : 798,
        "nident" : 452,
        "evalue" : 0.0,
        "positive" : 601,
        "gaps" : 34,
        "Type" : "protein_coding",
        "bitscore" : 843.0,
        "slen" : 900,
        "mismatch" : 312,
        "name" : "KfCluster-15996.0",
        "send" : 817,
        "qcovs" : 69,
        "PrimarySymbol" : "EUKARYOTIC TRANSLATION INITIATION FACTOR 3C (EIF3C)",
        "qend" : 2788
      },
      "position" : {
        "x" : -1064.6494140625,
        "y" : -1228.0474853515625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16925",
        "degree_layout" : 10,
        "Description" : "\"Encodes a nuclear localized DEAH-box containing protein that is involved in miRNA biogenesis. Loss of function mutants are embryo lethal. Gene silencing experiments demonstrated its role in the localization of DCL-1 and HYL1 to the nuclear D-body. In silenced lines, miRNA production is suppressed and plants have developmental abnormalities and are hypersensitive to fungal pathogens.\"",
        "SecondarySymbol" : "EMBRYO DEFECTIVE 3011 (EMB3011);PSR1-INTERACTING PROTEIN 1 (PINP1);HOMOLOG IN YEAST PRP16 (PRP16);CLUMSY VEIN (CUV)",
        "sstart" : 257,
        "qstart" : 1001,
        "qcovhsp" : 22,
        "shared_name" : "SpCluster-9352.0",
        "ppos" : 84.51,
        "score" : 3395,
        "pident" : 73.077,
        "SUID" : 16925,
        "selected" : false,
        "sseqid" : "AT5G13010",
        "length" : 936,
        "nident" : 684,
        "evalue" : 0.0,
        "positive" : 791,
        "gaps" : 4,
        "Type" : "protein_coding",
        "bitscore" : 1312.0,
        "slen" : 1255,
        "mismatch" : 248,
        "name" : "SpCluster-9352.0",
        "send" : 1188,
        "qcovs" : 67,
        "PrimarySymbol" : "EMBRYO DEFECTIVE 3011 (EMB3011)",
        "qend" : 3808
      },
      "position" : {
        "x" : -248.98291285517135,
        "y" : -2914.699951171875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17801",
        "degree_layout" : 2,
        "Description" : "encodes a protein whose sequence is similar to actin-related proteins (ARPs) in other organisms. Member of nuclear ARP family of genes.",
        "SecondarySymbol" : "ACTIN-RELATED PROTEIN 9 (ARP9);ACTIN-RELATED PROTEIN 9 (ATARP9)",
        "sstart" : 158,
        "qstart" : 1633,
        "qcovhsp" : 18,
        "shared_name" : "SpCluster-19620.0",
        "ppos" : 57.64,
        "score" : 765,
        "pident" : 39.583,
        "SUID" : 17801,
        "selected" : false,
        "sseqid" : "AT5G43500",
        "length" : 432,
        "nident" : 171,
        "evalue" : 9.51E-92,
        "positive" : 249,
        "gaps" : 15,
        "Type" : "protein_coding",
        "bitscore" : 299.0,
        "slen" : 584,
        "mismatch" : 246,
        "name" : "SpCluster-19620.0",
        "send" : 581,
        "qcovs" : 55,
        "PrimarySymbol" : "ACTIN-RELATED PROTEIN 9 (ARP9)",
        "qend" : 359
      },
      "position" : {
        "x" : 511.80694580078125,
        "y" : -1673.42431640625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16924",
        "degree_layout" : 10,
        "Description" : "\"Encodes a homolog of the yeast PRP2 protein, one of four related DEAH RNA helicases identified as essential cofactors for RNA splicing.\"",
        "SecondarySymbol" : "ENHANCED SILENCING PHENOTYPE 3 (ESP3);EMBRYO DEFECTIVE 2733 (EMB2733)",
        "sstart" : 168,
        "qstart" : 2803,
        "qcovhsp" : 25,
        "shared_name" : "SpCluster-17991.1",
        "ppos" : 86.02,
        "score" : 3191,
        "pident" : 70.909,
        "SUID" : 16924,
        "selected" : false,
        "sseqid" : "AT1G32490",
        "length" : 880,
        "nident" : 624,
        "evalue" : 0.0,
        "positive" : 757,
        "gaps" : 5,
        "Type" : "protein_coding",
        "bitscore" : 1233.0,
        "slen" : 1044,
        "mismatch" : 251,
        "name" : "SpCluster-17991.1",
        "send" : 1044,
        "qcovs" : 75,
        "PrimarySymbol" : "ENHANCED SILENCING PHENOTYPE 3 (ESP3)",
        "qend" : 170
      },
      "position" : {
        "x" : -138.0501125622026,
        "y" : -2935.058349609375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17800",
        "degree_layout" : 12,
        "Description" : "",
        "SecondarySymbol" : "",
        "shared_name" : "SpCluster-15594.0",
        "SUID" : 17800,
        "selected" : false,
        "sseqid" : "",
        "Type" : "",
        "name" : "SpCluster-15594.0",
        "PrimarySymbol" : ""
      },
      "position" : {
        "x" : 626.1061401367188,
        "y" : -1506.8516845703125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16923",
        "degree_layout" : 11,
        "Description" : "ATP-dependent RNA helicase;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 212,
        "qstart" : 752,
        "qcovhsp" : 24,
        "shared_name" : "SpCluster-12653.0",
        "ppos" : 91.35,
        "score" : 3997,
        "pident" : 81.96,
        "SUID" : 16923,
        "selected" : false,
        "sseqid" : "AT3G26560",
        "length" : 959,
        "nident" : 786,
        "evalue" : 0.0,
        "positive" : 876,
        "gaps" : 6,
        "Type" : "protein_coding",
        "bitscore" : 1544.0,
        "slen" : 1168,
        "mismatch" : 167,
        "name" : "SpCluster-12653.0",
        "send" : 1168,
        "qcovs" : 72,
        "PrimarySymbol" : "0",
        "qend" : 3616
      },
      "position" : {
        "x" : -139.31115992548385,
        "y" : -2861.054443359375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16922",
        "degree_layout" : 12,
        "Description" : "Over-expression of this gene results in stem fasciation.  The predicted amino acid sequence reveals the presence of two   domains (DEXH-box or DEAD-box helicase and DUF1065 domain) and fragments of two more domains (HrpA domain and HA2 domain).",
        "SecondarySymbol" : "FASCIATED STEM 4 (FAS4);FASCIATED STEM 4 (ATFAS4)",
        "sstart" : 202,
        "qstart" : 3746,
        "qcovhsp" : 21,
        "shared_name" : "PpCluster-2922.0",
        "ppos" : 63.75,
        "score" : 2295,
        "pident" : 46.903,
        "SUID" : 16922,
        "selected" : false,
        "sseqid" : "AT1G33390",
        "length" : 1098,
        "nident" : 515,
        "evalue" : 0.0,
        "positive" : 700,
        "gaps" : 89,
        "Type" : "protein_coding",
        "bitscore" : 888.0,
        "slen" : 1237,
        "mismatch" : 494,
        "name" : "PpCluster-2922.0",
        "send" : 1232,
        "qcovs" : 64,
        "PrimarySymbol" : "FASCIATED STEM 4 (FAS4)",
        "qend" : 519
      },
      "position" : {
        "x" : -178.00808985712447,
        "y" : -2815.061279296875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16921",
        "degree_layout" : 12,
        "Description" : "Has RNA or DNA helicase activity and expressed specifically in tapetum and vascular tissue. First identified member of a new group of the mle helicase group of the DEAH family.",
        "SecondarySymbol" : "(ATVT-1);HELICASE IN VASCULAR TISSUE AND TAPETUM (HVT1)",
        "sstart" : 42,
        "qstart" : 3717,
        "qcovhsp" : 22,
        "shared_name" : "PpCluster-20851.0",
        "ppos" : 66.79,
        "score" : 2425,
        "pident" : 47.09,
        "SUID" : 16921,
        "selected" : false,
        "sseqid" : "AT2G30800",
        "length" : 1117,
        "nident" : 526,
        "evalue" : 0.0,
        "positive" : 746,
        "gaps" : 70,
        "Type" : "protein_coding",
        "bitscore" : 938.0,
        "slen" : 1299,
        "mismatch" : 521,
        "name" : "PpCluster-20851.0",
        "send" : 1112,
        "qcovs" : 66,
        "PrimarySymbol" : "HELICASE IN VASCULAR TISSUE AND TAPETUM (HVT1)",
        "qend" : 439
      },
      "position" : {
        "x" : -234.9931057262651,
        "y" : -2833.763427734375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16920",
        "degree_layout" : 10,
        "Description" : "RNA helicase family protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 285,
        "qstart" : 2080,
        "qcovhsp" : 12,
        "shared_name" : "KfCluster-15980.0",
        "ppos" : 91.05,
        "score" : 1102,
        "pident" : 85.214,
        "SUID" : 16920,
        "selected" : false,
        "sseqid" : "AT2G47250",
        "length" : 257,
        "nident" : 219,
        "evalue" : 1.06E-140,
        "positive" : 234,
        "gaps" : 7,
        "Type" : "protein_coding",
        "bitscore" : 429.0,
        "slen" : 729,
        "mismatch" : 31,
        "name" : "KfCluster-15980.0",
        "send" : 534,
        "qcovs" : 37,
        "PrimarySymbol" : "0",
        "qend" : 1310
      },
      "position" : {
        "x" : -200.01120265009322,
        "y" : -2956.093994140625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16919",
        "degree_layout" : 3,
        "Description" : "Homeodomain-like superfamily protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 302,
        "qstart" : 1772,
        "qcovhsp" : 1,
        "shared_name" : "KfCluster-9948.0",
        "ppos" : 63.64,
        "score" : 67,
        "pident" : 39.394,
        "SUID" : 16919,
        "selected" : false,
        "sseqid" : "AT5G47660",
        "length" : 33,
        "nident" : 13,
        "evalue" : 7.4,
        "positive" : 21,
        "gaps" : 3,
        "Type" : "protein_coding",
        "bitscore" : 30.4,
        "slen" : 398,
        "mismatch" : 17,
        "name" : "KfCluster-9948.0",
        "send" : 331,
        "qcovs" : 4,
        "PrimarySymbol" : "0",
        "qend" : 1674
      },
      "position" : {
        "x" : 70.73545837402344,
        "y" : -1041.2130126953125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16918",
        "degree_layout" : 3,
        "Description" : "Encodes a protein with xylanase activity.",
        "SecondarySymbol" : "ARABIDOPSIS THALIANA XYLANASE 1 (ATXYN1); (RXF12)",
        "sstart" : 481,
        "qstart" : 312,
        "qcovhsp" : 19,
        "shared_name" : "KfCluster-15815.0",
        "ppos" : 40.65,
        "score" : 232,
        "pident" : 22.764,
        "SUID" : 16918,
        "selected" : false,
        "sseqid" : "AT1G58370",
        "length" : 492,
        "nident" : 112,
        "evalue" : 1.86E-19,
        "positive" : 200,
        "gaps" : 66,
        "Type" : "protein_coding",
        "bitscore" : 94.0,
        "slen" : 917,
        "mismatch" : 314,
        "name" : "KfCluster-15815.0",
        "send" : 914,
        "qcovs" : 58,
        "PrimarySymbol" : "(RXF12)",
        "qend" : 1763
      },
      "position" : {
        "x" : 1.41748046875,
        "y" : -1157.300048828125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16915",
        "degree_layout" : 8,
        "Description" : "\"belongs to the P-type ATPase superfamily of cation-transporting ATPases, pumps protons out of the cell, generating a proton gradient that drives the active transport of nutrients by proton symport. has two autoinhibitory  regions within the C-terminal dom\"",
        "SecondarySymbol" : "H(+)-ATPASE 2 (HA2)",
        "sstart" : 428,
        "qstart" : 1817,
        "qcovhsp" : 29,
        "shared_name" : "SpCluster-3926.0",
        "ppos" : 98.85,
        "score" : 2596,
        "pident" : 98.656,
        "SUID" : 16915,
        "selected" : false,
        "sseqid" : "AT4G30190",
        "length" : 521,
        "nident" : 514,
        "evalue" : 0.0,
        "positive" : 515,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 1004.0,
        "slen" : 948,
        "mismatch" : 7,
        "name" : "SpCluster-3926.0",
        "send" : 948,
        "qcovs" : 86,
        "PrimarySymbol" : "H(+)-ATPASE 2 (HA2)",
        "qend" : 255
      },
      "position" : {
        "x" : -661.356201171875,
        "y" : -2857.4738796520464
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16914",
        "degree_layout" : 2,
        "Description" : "Encodes a plasma membrane proton ATPase.  Mutants have a reduced ability to close their stomata in response to drought and are affected in stomatal but not seed responsiveness to ABA. The mRNA is cell-to-cell mobile.",
        "SecondarySymbol" : "H(+)-ATPASE 1 (AHA1);PLASMA MEMBRANE PROTON ATPASE (PMA);OPEN STOMATA 2 (OST2);H(+)-ATPASE 1 (HA1)",
        "sstart" : 757,
        "qstart" : 1091,
        "qcovhsp" : 8,
        "shared_name" : "KfCluster-15734.0",
        "ppos" : 52.04,
        "score" : 123,
        "pident" : 35.714,
        "SUID" : 16914,
        "selected" : false,
        "sseqid" : "AT2G18960",
        "length" : 98,
        "nident" : 35,
        "evalue" : 4.71E-7,
        "positive" : 51,
        "gaps" : 12,
        "Type" : "protein_coding",
        "bitscore" : 52.0,
        "slen" : 949,
        "mismatch" : 51,
        "name" : "KfCluster-15734.0",
        "send" : 844,
        "qcovs" : 25,
        "PrimarySymbol" : "H(+)-ATPASE 1 (HA1)",
        "qend" : 804
      },
      "position" : {
        "x" : -586.9143676757812,
        "y" : -2887.0393093395464
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16913",
        "degree_layout" : 6,
        "Description" : "splicing factor;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 213,
        "qstart" : 3695,
        "qcovhsp" : 23,
        "shared_name" : "SpCluster-18995.0",
        "ppos" : 92.86,
        "score" : 4681,
        "pident" : 86.103,
        "SUID" : 16913,
        "selected" : false,
        "sseqid" : "AT5G64270",
        "length" : 1065,
        "nident" : 917,
        "evalue" : 0.0,
        "positive" : 989,
        "gaps" : 13,
        "Type" : "protein_coding",
        "bitscore" : 1807.0,
        "slen" : 1269,
        "mismatch" : 135,
        "name" : "SpCluster-18995.0",
        "send" : 1267,
        "qcovs" : 69,
        "PrimarySymbol" : "0",
        "qend" : 510
      },
      "position" : {
        "x" : -1423.5958224963913,
        "y" : -1433.164794921875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16912",
        "degree_layout" : 5,
        "Description" : "Mitochondrial substrate carrier family protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 31,
        "qstart" : 1660,
        "qcovhsp" : 9,
        "shared_name" : "PpCluster-15341.2",
        "ppos" : 47.31,
        "score" : 280,
        "pident" : 30.466,
        "SUID" : 16912,
        "selected" : false,
        "sseqid" : "AT4G03115",
        "length" : 279,
        "nident" : 85,
        "evalue" : 8.32E-27,
        "positive" : 132,
        "gaps" : 16,
        "Type" : "protein_coding",
        "bitscore" : 112.0,
        "slen" : 314,
        "mismatch" : 178,
        "name" : "PpCluster-15341.2",
        "send" : 303,
        "qcovs" : 28,
        "PrimarySymbol" : "0",
        "qend" : 2466
      },
      "position" : {
        "x" : -1412.2728244495163,
        "y" : -1600.39501953125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17799",
        "degree_layout" : 1,
        "Description" : "actin cytoskeleton-regulatory complex pan-like protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 257,
        "qstart" : 1276,
        "qcovhsp" : 10,
        "shared_name" : "SpCluster-17345.0",
        "ppos" : 48.5,
        "score" : 89,
        "pident" : 23.952,
        "SUID" : 17799,
        "selected" : false,
        "sseqid" : "AT3G20350",
        "length" : 167,
        "nident" : 40,
        "evalue" : 0.012,
        "positive" : 81,
        "gaps" : 19,
        "Type" : "protein_coding",
        "bitscore" : 38.9,
        "slen" : 673,
        "mismatch" : 108,
        "name" : "SpCluster-17345.0",
        "send" : 404,
        "qcovs" : 29,
        "PrimarySymbol" : "0",
        "qend" : 776
      },
      "position" : {
        "x" : 422.4639892578125,
        "y" : -1501.160888671875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16911",
        "degree_layout" : 14,
        "Description" : "Seedling lethal mutation; Mitochondrial Carnitine Acyl Carrier-Like Protein",
        "SecondarySymbol" : "A BOUT DE SOUFFLE (BOU)",
        "sstart" : 6,
        "qstart" : 249,
        "qcovhsp" : 20,
        "shared_name" : "KfCluster-22998.0",
        "ppos" : 82.33,
        "score" : 970,
        "pident" : 69.667,
        "SUID" : 16911,
        "selected" : false,
        "sseqid" : "AT5G46800",
        "length" : 300,
        "nident" : 209,
        "evalue" : 2.09E-129,
        "positive" : 247,
        "gaps" : 5,
        "Type" : "protein_coding",
        "bitscore" : 378.0,
        "slen" : 300,
        "mismatch" : 86,
        "name" : "KfCluster-22998.0",
        "send" : 300,
        "qcovs" : 60,
        "PrimarySymbol" : "A BOUT DE SOUFFLE (BOU)",
        "qend" : 1148
      },
      "position" : {
        "x" : -1502.1614963245163,
        "y" : -1531.9044189453125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16910",
        "degree_layout" : 7,
        "Description" : "S-adenosylmethionine carrier 2;(source:Araport11)",
        "SecondarySymbol" : "S-ADENOSYLMETHIONINE CARRIER 2 (SAMC2)",
        "sstart" : 76,
        "qstart" : 1207,
        "qcovhsp" : 13,
        "shared_name" : "KfCluster-18257.0",
        "ppos" : 53.26,
        "score" : 297,
        "pident" : 35.507,
        "SUID" : 16910,
        "selected" : false,
        "sseqid" : "AT1G34065",
        "length" : 276,
        "nident" : 98,
        "evalue" : 4.34E-29,
        "positive" : 147,
        "gaps" : 26,
        "Type" : "protein_coding",
        "bitscore" : 119.0,
        "slen" : 345,
        "mismatch" : 152,
        "name" : "KfCluster-18257.0",
        "send" : 339,
        "qcovs" : 39,
        "PrimarySymbol" : "S-ADENOSYLMETHIONINE CARRIER 2 (SAMC2)",
        "qend" : 422
      },
      "position" : {
        "x" : -1470.6409885120163,
        "y" : -1441.9090576171875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16909",
        "degree_layout" : 5,
        "Description" : "Encodes a mitochondrial ADP/ATP carrier protein. Shown in heterologous systems to be located in the plasma membrane. Has comparable affinity for ADP and ATP (in E.coli).",
        "SecondarySymbol" : "ADP/ATP CARRIER 3 (AAC3); (ATAAC3)",
        "sstart" : 63,
        "qstart" : 874,
        "qcovhsp" : 17,
        "shared_name" : "KfCluster-18220.0",
        "ppos" : 85.9,
        "score" : 1159,
        "pident" : 77.244,
        "SUID" : 16909,
        "selected" : false,
        "sseqid" : "AT4G28390",
        "length" : 312,
        "nident" : 241,
        "evalue" : 3.22E-155,
        "positive" : 268,
        "gaps" : 3,
        "Type" : "protein_coding",
        "bitscore" : 451.0,
        "slen" : 379,
        "mismatch" : 68,
        "name" : "KfCluster-18220.0",
        "send" : 372,
        "qcovs" : 52,
        "PrimarySymbol" : "ADP/ATP CARRIER 3 (AAC3)",
        "qend" : 1806
      },
      "position" : {
        "x" : -1516.9139377307663,
        "y" : -1446.8458251953125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16908",
        "degree_layout" : 6,
        "Description" : "O-fucosyltransferase family protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 222,
        "qstart" : 1545,
        "qcovhsp" : 10,
        "shared_name" : "SpCluster-13182.388",
        "ppos" : 71.33,
        "score" : 1189,
        "pident" : 52.607,
        "SUID" : 16908,
        "selected" : false,
        "sseqid" : "AT5G35570",
        "length" : 422,
        "nident" : 222,
        "evalue" : 5.46E-147,
        "positive" : 301,
        "gaps" : 2,
        "Type" : "protein_coding",
        "bitscore" : 462.0,
        "slen" : 652,
        "mismatch" : 198,
        "name" : "SpCluster-13182.388",
        "send" : 642,
        "qcovs" : 30,
        "PrimarySymbol" : "0",
        "qend" : 283
      },
      "position" : {
        "x" : -599.8450927734375,
        "y" : -1953.0592041015625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16907",
        "degree_layout" : 2,
        "Description" : "O-fucosyltransferase family protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 59,
        "qstart" : 1564,
        "qcovhsp" : 14,
        "shared_name" : "KfCluster-15672.0",
        "ppos" : 51.32,
        "score" : 567,
        "pident" : 32.599,
        "SUID" : 16907,
        "selected" : false,
        "sseqid" : "AT5G65470",
        "length" : 454,
        "nident" : 148,
        "evalue" : 4.4E-63,
        "positive" : 233,
        "gaps" : 53,
        "Type" : "protein_coding",
        "bitscore" : 223.0,
        "slen" : 504,
        "mismatch" : 253,
        "name" : "KfCluster-15672.0",
        "send" : 503,
        "qcovs" : 41,
        "PrimarySymbol" : "0",
        "qend" : 2793
      },
      "position" : {
        "x" : -658.7898559570312,
        "y" : -2090.75341796875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16906",
        "degree_layout" : 3,
        "Description" : "BRI1 suppressor 1 (BSU1)-like 3;(source:Araport11)",
        "SecondarySymbol" : "BRI1 SUPPRESSOR 1 (BSU1)-LIKE 3 (BSL3)",
        "sstart" : 586,
        "qstart" : 1799,
        "qcovhsp" : 12,
        "shared_name" : "SpCluster-9845.0",
        "ppos" : 83.89,
        "score" : 1606,
        "pident" : 74.76,
        "SUID" : 16906,
        "selected" : false,
        "sseqid" : "AT2G27210",
        "length" : 416,
        "nident" : 311,
        "evalue" : 0.0,
        "positive" : 349,
        "gaps" : 6,
        "Type" : "protein_coding",
        "bitscore" : 623.0,
        "slen" : 1001,
        "mismatch" : 99,
        "name" : "SpCluster-9845.0",
        "send" : 1001,
        "qcovs" : 35,
        "PrimarySymbol" : "BRI1 SUPPRESSOR 1 (BSU1)-LIKE 3 (BSL3)",
        "qend" : 3028
      },
      "position" : {
        "x" : -1118.56689453125,
        "y" : -1987.456787109375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16905",
        "degree_layout" : 7,
        "Description" : "\"Encodes a nitrile-specifier protein NSP1 responsible for constitutive and herbivore-induced simple nitrile formation in rosette leaves. NSP1 is one out of five (At3g16400/NSP1, At2g33070/NSP2, At3g16390/NSP3, At3g16410/NSP4 and At5g48180/NSP5) A. thaliana epithiospecifier protein (ESP) homologues that promote simple nitrile, but not epithionitrile or thiocyanate formation. The mRNA is cell-to-cell mobile.\"",
        "SecondarySymbol" : "NITRILE SPECIFIER PROTEIN 1 (ATNSP1);NITRILE SPECIFIER PROTEIN 1 (NSP1);MYROSINASE-BINDING PROTEIN-LIKE PROTEIN-470 (ATMLP-470)",
        "sstart" : 1,
        "qstart" : 1612,
        "qcovhsp" : 28,
        "shared_name" : "SpCluster-16245.0",
        "ppos" : 100.0,
        "score" : 2497,
        "pident" : 100.0,
        "SUID" : 16905,
        "selected" : false,
        "sseqid" : "AT3G16400",
        "length" : 470,
        "nident" : 470,
        "evalue" : 0.0,
        "positive" : 470,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 966.0,
        "slen" : 470,
        "mismatch" : 0,
        "name" : "SpCluster-16245.0",
        "send" : 470,
        "qcovs" : 85,
        "PrimarySymbol" : "NITRILE SPECIFIER PROTEIN 1 (NSP1)",
        "qend" : 203
      },
      "position" : {
        "x" : -995.50146484375,
        "y" : -1919.0205078125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16904",
        "degree_layout" : 4,
        "Description" : "Acyl-CoA binding protein with high affinity for   oleoyl-CoA. Expressed in all plant organs. Involved in fatty acid transport.",
        "SecondarySymbol" : "(ATACBP4);ACYL-COA BINDING PROTEIN 4 (ACBP4)",
        "sstart" : 6,
        "qstart" : 400,
        "qcovhsp" : 17,
        "shared_name" : "KfCluster-15633.0",
        "ppos" : 63.35,
        "score" : 1181,
        "pident" : 46.414,
        "SUID" : 16904,
        "selected" : false,
        "sseqid" : "AT3G05420",
        "length" : 502,
        "nident" : 233,
        "evalue" : 1.07E-149,
        "positive" : 318,
        "gaps" : 26,
        "Type" : "protein_coding",
        "bitscore" : 459.0,
        "slen" : 668,
        "mismatch" : 243,
        "name" : "KfCluster-15633.0",
        "send" : 484,
        "qcovs" : 51,
        "PrimarySymbol" : "ACYL-COA BINDING PROTEIN 4 (ACBP4)",
        "qend" : 1896
      },
      "position" : {
        "x" : -1105.4537353515625,
        "y" : -1893.2606201171875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17793",
        "degree_layout" : 2,
        "Description" : "Zinc finger C-x8-C-x5-C-x3-H type family protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 294,
        "qstart" : 2100,
        "qcovhsp" : 3,
        "shared_name" : "PpCluster-25353.0",
        "ppos" : 83.0,
        "score" : 369,
        "pident" : 64.0,
        "SUID" : 17793,
        "selected" : false,
        "sseqid" : "AT1G10320",
        "length" : 100,
        "nident" : 64,
        "evalue" : 9.21E-36,
        "positive" : 83,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 146.0,
        "slen" : 757,
        "mismatch" : 36,
        "name" : "PpCluster-25353.0",
        "send" : 393,
        "qcovs" : 8,
        "PrimarySymbol" : "0",
        "qend" : 1801
      },
      "position" : {
        "x" : -1364.6429443359375,
        "y" : -943.9000854492188
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16899",
        "Description" : "\"protein synthesis initiation factor 4G (EIF4G).  A mutation in this gene (cum2-1) results in decreased accumulation of CMV coat protein in upper, uninoculated leaves. Likely affects cell-to-cell movement of the virus, also affects TCV multiplication.\"",
        "SecondarySymbol" : "CUCUMOVIRUS MULTIPLICATION 2 (CUM2);EUKARYOTIC TRANSLATION INITIATION FACTOR 4G (EIF4G)",
        "sstart" : 829,
        "qstart" : 4950,
        "qcovhsp" : 7,
        "shared_name" : "SpCluster-4395.0",
        "ppos" : 56.74,
        "score" : 879,
        "pident" : 42.434,
        "SUID" : 16899,
        "selected" : false,
        "sseqid" : "AT3G60240",
        "length" : 608,
        "nident" : 258,
        "evalue" : 6.29E-95,
        "positive" : 345,
        "gaps" : 52,
        "Type" : "protein_coding",
        "bitscore" : 343.0,
        "slen" : 1727,
        "mismatch" : 298,
        "name" : "SpCluster-4395.0",
        "send" : 1421,
        "qcovs" : 22,
        "PrimarySymbol" : "EUKARYOTIC TRANSLATION INITIATION FACTOR 4G (EIF4G)",
        "qend" : 6662
      },
      "position" : {
        "x" : 1845.860901623896,
        "y" : -440.765869140625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16898",
        "Description" : "\"protein synthesis initiation factor 4G (EIF4G).  A mutation in this gene (cum2-1) results in decreased accumulation of CMV coat protein in upper, uninoculated leaves. Likely affects cell-to-cell movement of the virus, also affects TCV multiplication.\"",
        "SecondarySymbol" : "CUCUMOVIRUS MULTIPLICATION 2 (CUM2);EUKARYOTIC TRANSLATION INITIATION FACTOR 4G (EIF4G)",
        "sstart" : 1074,
        "qstart" : 1,
        "qcovhsp" : 11,
        "shared_name" : "PpCluster-18773.0",
        "ppos" : 82.25,
        "score" : 902,
        "pident" : 68.478,
        "SUID" : 16898,
        "selected" : false,
        "sseqid" : "AT3G60240",
        "length" : 276,
        "nident" : 189,
        "evalue" : 6.77E-104,
        "positive" : 227,
        "gaps" : 3,
        "Type" : "protein_coding",
        "bitscore" : 352.0,
        "slen" : 1723,
        "mismatch" : 84,
        "name" : "PpCluster-18773.0",
        "send" : 1346,
        "qcovs" : 34,
        "PrimarySymbol" : "EUKARYOTIC TRANSLATION INITIATION FACTOR 4G (EIF4G)",
        "qend" : 828
      },
      "position" : {
        "x" : 1864.434387952021,
        "y" : -543.205078125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16897",
        "Description" : "Encodes a putative eukaryotic translation initiation factor The mRNA is cell-to-cell mobile.",
        "SecondarySymbol" : "EUKARYOTIC TRANSLATION INITIATION FACTOR ISOFORM 4G1 (eIFiso4G1)",
        "sstart" : 195,
        "qstart" : 2006,
        "qcovhsp" : 9,
        "shared_name" : "KfCluster-15395.0",
        "ppos" : 70.71,
        "score" : 708,
        "pident" : 50.714,
        "SUID" : 16897,
        "selected" : false,
        "sseqid" : "AT5G57870",
        "length" : 280,
        "nident" : 142,
        "evalue" : 7.62E-80,
        "positive" : 198,
        "gaps" : 8,
        "Type" : "protein_coding",
        "bitscore" : 277.0,
        "slen" : 780,
        "mismatch" : 130,
        "name" : "KfCluster-15395.0",
        "send" : 470,
        "qcovs" : 27,
        "PrimarySymbol" : "EUKARYOTIC TRANSLATION INITIATION FACTOR ISOFORM 4G1 (eIFiso4G1)",
        "qend" : 1179
      },
      "position" : {
        "x" : 1943.841614514521,
        "y" : -475.9035949707031
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16896",
        "degree_layout" : 16,
        "Description" : "ABC1K8 is a member of an atypical protein kinase family that is induced by heavy metals. Loss of function mutations affect the metabolic profile of chloroplast lipids. It appears to function along with ABC1K7 in mediating lipid membrane changes in response to stress. The mRNA is cell-to-cell mobile.",
        "SecondarySymbol" : "ARABIDOPSIS THALIANA ABC2 HOMOLOG 13 (ATATH13); (ABC1K8);OXIDATIVE STRESS-RELATED ABC1-LIKE PROTEIN 1 (OSA1);ABC2 HOMOLOG 13 (ATH13);A. THALIANA OXIDATIVE STRESS-RELATED ABC1-LIKE PROTEIN 1 (ATOSA1)",
        "sstart" : 155,
        "qstart" : 1566,
        "qcovhsp" : 33,
        "shared_name" : "SpCluster-9678.0",
        "ppos" : 87.6,
        "score" : 2046,
        "pident" : 76.718,
        "SUID" : 16896,
        "selected" : false,
        "sseqid" : "AT5G64940",
        "length" : 524,
        "nident" : 402,
        "evalue" : 0.0,
        "positive" : 459,
        "gaps" : 2,
        "Type" : "protein_coding",
        "bitscore" : 792.0,
        "slen" : 761,
        "mismatch" : 120,
        "name" : "SpCluster-9678.0",
        "send" : 678,
        "qcovs" : 100,
        "PrimarySymbol" : "ABC2 HOMOLOG 13 (ATH13)",
        "qend" : 1
      },
      "position" : {
        "x" : -1432.241091566109,
        "y" : -1887.164794921875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16895",
        "degree_layout" : 10,
        "Description" : "Protein kinase superfamily protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 80,
        "qstart" : 930,
        "qcovhsp" : 19,
        "shared_name" : "SpCluster-7047.0",
        "ppos" : 87.1,
        "score" : 1221,
        "pident" : 73.226,
        "SUID" : 16895,
        "selected" : false,
        "sseqid" : "AT3G24190",
        "length" : 310,
        "nident" : 227,
        "evalue" : 1.08E-159,
        "positive" : 270,
        "gaps" : 1,
        "Type" : "protein_coding",
        "bitscore" : 474.0,
        "slen" : 793,
        "mismatch" : 82,
        "name" : "SpCluster-7047.0",
        "send" : 388,
        "qcovs" : 56,
        "PrimarySymbol" : "0",
        "qend" : 1
      },
      "position" : {
        "x" : -1470.650759534859,
        "y" : -1931.545166015625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16894",
        "degree_layout" : 6,
        "Description" : "Protein kinase superfamily protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 63,
        "qstart" : 2323,
        "qcovhsp" : 14,
        "shared_name" : "SpCluster-19537.0",
        "ppos" : 65.15,
        "score" : 852,
        "pident" : 50.758,
        "SUID" : 16894,
        "selected" : false,
        "sseqid" : "AT1G11390",
        "length" : 396,
        "nident" : 201,
        "evalue" : 1.37E-102,
        "positive" : 258,
        "gaps" : 26,
        "Type" : "protein_coding",
        "bitscore" : 332.0,
        "slen" : 624,
        "mismatch" : 169,
        "name" : "SpCluster-19537.0",
        "send" : 438,
        "qcovs" : 43,
        "PrimarySymbol" : "0",
        "qend" : 1154
      },
      "position" : {
        "x" : -1471.469118909859,
        "y" : -1988.70068359375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16893",
        "degree_layout" : 8,
        "Description" : "Protein kinase superfamily protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 381,
        "qstart" : 2,
        "qcovhsp" : 31,
        "shared_name" : "SpCluster-12906.0",
        "ppos" : 74.28,
        "score" : 1233,
        "pident" : 60.31,
        "SUID" : 16893,
        "selected" : false,
        "sseqid" : "AT3G24190",
        "length" : 451,
        "nident" : 272,
        "evalue" : 2.02E-162,
        "positive" : 335,
        "gaps" : 40,
        "Type" : "protein_coding",
        "bitscore" : 479.0,
        "slen" : 793,
        "mismatch" : 139,
        "name" : "SpCluster-12906.0",
        "send" : 793,
        "qcovs" : 93,
        "PrimarySymbol" : "0",
        "qend" : 1348
      },
      "position" : {
        "x" : -1439.047976331734,
        "y" : -1810.468017578125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16892",
        "degree_layout" : 5,
        "Description" : "ABC1 family protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 457,
        "qstart" : 1085,
        "qcovhsp" : 17,
        "shared_name" : "PpCluster-12268.0",
        "ppos" : 62.76,
        "score" : 1251,
        "pident" : 48.81,
        "SUID" : 16892,
        "selected" : false,
        "sseqid" : "AT5G24810",
        "length" : 588,
        "nident" : 287,
        "evalue" : 1.41E-154,
        "positive" : 369,
        "gaps" : 75,
        "Type" : "protein_coding",
        "bitscore" : 486.0,
        "slen" : 1009,
        "mismatch" : 226,
        "name" : "PpCluster-12268.0",
        "send" : 1007,
        "qcovs" : 51,
        "PrimarySymbol" : "0",
        "qend" : 2734
      },
      "position" : {
        "x" : -1520.470339612984,
        "y" : -1959.871337890625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16891",
        "degree_layout" : 13,
        "Description" : "Protein kinase superfamily protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 137,
        "qstart" : 3123,
        "qcovhsp" : 13,
        "shared_name" : "KfCluster-5607.0",
        "ppos" : 65.19,
        "score" : 1284,
        "pident" : 46.82,
        "SUID" : 16891,
        "selected" : false,
        "sseqid" : "AT3G24190",
        "length" : 566,
        "nident" : 265,
        "evalue" : 2.08E-159,
        "positive" : 369,
        "gaps" : 28,
        "Type" : "protein_coding",
        "bitscore" : 499.0,
        "slen" : 793,
        "mismatch" : 273,
        "name" : "KfCluster-5607.0",
        "send" : 698,
        "qcovs" : 40,
        "PrimarySymbol" : "0",
        "qend" : 1498
      },
      "position" : {
        "x" : -1488.796755628609,
        "y" : -1857.2685546875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16890",
        "degree_layout" : 13,
        "Description" : "Protein kinase superfamily protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 169,
        "qstart" : 2366,
        "qcovhsp" : 27,
        "shared_name" : "KfCluster-4296.0",
        "ppos" : 79.78,
        "score" : 2200,
        "pident" : 67.555,
        "SUID" : 16890,
        "selected" : false,
        "sseqid" : "AT3G24190",
        "length" : 638,
        "nident" : 431,
        "evalue" : 0.0,
        "positive" : 509,
        "gaps" : 20,
        "Type" : "protein_coding",
        "bitscore" : 852.0,
        "slen" : 793,
        "mismatch" : 187,
        "name" : "KfCluster-4296.0",
        "send" : 793,
        "qcovs" : 80,
        "PrimarySymbol" : "0",
        "qend" : 474
      },
      "position" : {
        "x" : -1347.2897976207964,
        "y" : -1813.452880859375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16889",
        "degree_layout" : 13,
        "Description" : "Protein kinase superfamily protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 143,
        "qstart" : 1771,
        "qcovhsp" : 24,
        "shared_name" : "KfCluster-16138.0",
        "ppos" : 75.46,
        "score" : 1505,
        "pident" : 59.794,
        "SUID" : 16889,
        "selected" : false,
        "sseqid" : "AT1G11390",
        "length" : 485,
        "nident" : 290,
        "evalue" : 0.0,
        "positive" : 366,
        "gaps" : 19,
        "Type" : "protein_coding",
        "bitscore" : 584.0,
        "slen" : 624,
        "mismatch" : 176,
        "name" : "KfCluster-16138.0",
        "send" : 624,
        "qcovs" : 71,
        "PrimarySymbol" : "0",
        "qend" : 365
      },
      "position" : {
        "x" : -1363.6030300426714,
        "y" : -1909.419677734375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16888",
        "degree_layout" : 18,
        "Description" : "ABC1K7 is a member of an atypical protein kinase family that is induced by salt stress. Loss of function mutations affect the metabolic profile of chloroplast lipids. It appears to function along with ABC1K8 in mediating lipid membrane changes in response to stress.",
        "SecondarySymbol" : "SALT-INDUCED ABC1 KINASE 1 (SIA1); (ATSIA1); (ABC1K7)",
        "sstart" : 84,
        "qstart" : 1334,
        "qcovhsp" : 19,
        "shared_name" : "KfCluster-15388.0",
        "ppos" : 74.29,
        "score" : 1718,
        "pident" : 57.68,
        "SUID" : 16888,
        "selected" : false,
        "sseqid" : "AT3G07700",
        "length" : 638,
        "nident" : 368,
        "evalue" : 0.0,
        "positive" : 474,
        "gaps" : 26,
        "Type" : "protein_coding",
        "bitscore" : 666.0,
        "slen" : 695,
        "mismatch" : 244,
        "name" : "KfCluster-15388.0",
        "send" : 695,
        "qcovs" : 56,
        "PrimarySymbol" : "SALT-INDUCED ABC1 KINASE 1 (SIA1)",
        "qend" : 3247
      },
      "position" : {
        "x" : -1376.7585476207964,
        "y" : -1981.574951171875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16887",
        "degree_layout" : 17,
        "Description" : "\"Encodes ATNUC-L1 (NUCLEOLIN LIKE 1), the predominant form of the two nucleolin proteins found in Arabidopsis. This protein is involved in rRNA processing, ribosome biosynthesis, and vascular pattern formation. PARL1 localizes to the nucleolus and parl1 mutants accumulate elevated levels of the unspliced 35S pre-rRNA. parl1 mutants also have defects in cotyledon, leaf, sepal, and petal vein patterning and have reduced stature, reduced fertility, increased bushiness, and reduced root length. The sugar-induced expression of ribosome proteins is also reduced in parl1 mutants. The mRNA is cell-to-cell mobile.\"",
        "SecondarySymbol" : "NUCLEOLIN LIKE 1 (ATNUC-L1);PARALLEL 1 (PARL1);NUCLEOLIN 1 (NUC1);NUCLEOLIN LIKE 1 (NUC-L1)",
        "sstart" : 296,
        "qstart" : 1113,
        "qcovhsp" : 11,
        "shared_name" : "KfCluster-31326.0",
        "ppos" : 60.51,
        "score" : 354,
        "pident" : 45.128,
        "SUID" : 16887,
        "selected" : false,
        "sseqid" : "AT1G48920",
        "length" : 195,
        "nident" : 88,
        "evalue" : 1.73E-35,
        "positive" : 118,
        "gaps" : 16,
        "Type" : "protein_coding",
        "bitscore" : 140.0,
        "slen" : 557,
        "mismatch" : 91,
        "name" : "KfCluster-31326.0",
        "send" : 479,
        "qcovs" : 32,
        "PrimarySymbol" : "NUCLEOLIN LIKE 1 (NUC-L1)",
        "qend" : 1682
      },
      "position" : {
        "x" : -1664.5489501953125,
        "y" : -910.5892333984375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16886",
        "degree_layout" : 2,
        "Description" : "\"Encodes a 3'-phosphoadenosine-5'-phosphate (PAP) phosphatase that is sensitive to physiological concentrations of Na+.  It does not also act as inositol polyphosphate 1-phosphatases, which other members of the HAL2-like family do.  It is proposed that AHL acts in concert with sulphotransferases to prevent both the toxicity of PAP on RNA processing enzymes as well as the product inhibition of PAP on sulphate conjugation. The mRNA is cell-to-cell mobile.\"",
        "SecondarySymbol" : "HAL2-LIKE (AHL);HAL2-LIKE (HL); (ATAHL)",
        "sstart" : 9,
        "qstart" : 1628,
        "qcovhsp" : 13,
        "shared_name" : "KfCluster-21697.0",
        "ppos" : 67.11,
        "score" : 959,
        "pident" : 52.139,
        "SUID" : 16886,
        "selected" : false,
        "sseqid" : "AT5G54390",
        "length" : 374,
        "nident" : 195,
        "evalue" : 2.11E-121,
        "positive" : 251,
        "gaps" : 10,
        "Type" : "protein_coding",
        "bitscore" : 374.0,
        "slen" : 373,
        "mismatch" : 169,
        "name" : "KfCluster-21697.0",
        "send" : 373,
        "qcovs" : 40,
        "PrimarySymbol" : "HAL2-LIKE (HL)",
        "qend" : 510
      },
      "position" : {
        "x" : -1971.3131103515625,
        "y" : -667.9779052734375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16885",
        "degree_layout" : 1,
        "Description" : "Rrp15p protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 183,
        "qstart" : 455,
        "qcovhsp" : 4,
        "shared_name" : "KfCluster-19235.0",
        "ppos" : 54.79,
        "score" : 80,
        "pident" : 43.836,
        "SUID" : 16885,
        "selected" : false,
        "sseqid" : "AT5G48240",
        "length" : 73,
        "nident" : 32,
        "evalue" : 0.1,
        "positive" : 40,
        "gaps" : 8,
        "Type" : "protein_coding",
        "bitscore" : 35.4,
        "slen" : 309,
        "mismatch" : 33,
        "name" : "KfCluster-19235.0",
        "send" : 250,
        "qcovs" : 11,
        "PrimarySymbol" : "0",
        "qend" : 664
      },
      "position" : {
        "x" : -2038.19775390625,
        "y" : -710.8099365234375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16884",
        "degree_layout" : 4,
        "Description" : "\"Encodes a bifunctional protein that has 3'(2'),5'-bisphosphate nucleotidase and inositol polyphosphate 1-phosphatase activities and rescues sulfur assimilation mutants in yeast.  It is involved in the response to cold, drought (negative regulator of drought tolerance), and ABA. Mutants in this gene exhibit enhanced induction of stress genes in response to cold, ABA, salt and dehydration due to higher accumulation of the second messenger, inositol (1,4,5)- triphosphate (IP(3)). Involved in degradation of small mRNAs. Mutants also affect the accumulation of miRNA target cleavage products. Regulates light-dependent repression of hypocotyl elongation and flowering time via its 3'(2'),5'-bisphosphate nucleotidase activity. Its kinase activity is sensitive to the redox state of its environment, decreasing under oxidative conditions.  Kinase activity is regulated by dimerization and intra and inter-molecular disulfide bond formation.\"",
        "SecondarySymbol" : "(SAL1);ALTERED EXPRESSION OF APX2 8 (ALX8); (ATSAL1); (ATFRY1);FIERY1 (FRY1);ROTUNDA 1 (RON1);SUPPRESSORS OF PIN1 OVEREXPRESSION 1 (SUPO1);HIGH EXPRESSION OF OSMOTICALLY RESPONSIVE GENES 2 (HOS2)",
        "sstart" : 57,
        "qstart" : 388,
        "qcovhsp" : 15,
        "shared_name" : "KfCluster-15176.0",
        "ppos" : 72.62,
        "score" : 952,
        "pident" : 59.366,
        "SUID" : 16884,
        "selected" : false,
        "sseqid" : "AT5G63980",
        "length" : 347,
        "nident" : 206,
        "evalue" : 7.06E-122,
        "positive" : 252,
        "gaps" : 2,
        "Type" : "protein_coding",
        "bitscore" : 371.0,
        "slen" : 407,
        "mismatch" : 139,
        "name" : "KfCluster-15176.0",
        "send" : 402,
        "qcovs" : 46,
        "PrimarySymbol" : "(SAL1)",
        "qend" : 1425
      },
      "position" : {
        "x" : -1887.8861083984375,
        "y" : -761.656494140625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16881",
        "degree_layout" : 4,
        "Description" : "UDP-D-glucuronate 4-epimerase The mRNA is cell-to-cell mobile.",
        "SecondarySymbol" : "UDP-D-GLUCURONATE 4-EPIMERASE 2 (GAE2)",
        "sstart" : 17,
        "qstart" : 2042,
        "qcovhsp" : 8,
        "shared_name" : "PpCluster-15556.0",
        "ppos" : 71.68,
        "score" : 654,
        "pident" : 60.619,
        "SUID" : 16881,
        "selected" : false,
        "sseqid" : "AT1G02000",
        "length" : 226,
        "nident" : 137,
        "evalue" : 1.6E-76,
        "positive" : 162,
        "gaps" : 16,
        "Type" : "protein_coding",
        "bitscore" : 256.0,
        "slen" : 434,
        "mismatch" : 73,
        "name" : "PpCluster-15556.0",
        "send" : 232,
        "qcovs" : 24,
        "PrimarySymbol" : "UDP-D-GLUCURONATE 4-EPIMERASE 2 (GAE2)",
        "qend" : 2701
      },
      "position" : {
        "x" : 303.51953125,
        "y" : -604.5994262695312
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16880",
        "degree_layout" : 4,
        "Description" : "\"Encodes an enzyme with 3&#946;-hydroxysteroid dehydrogenase/C4-decarboxylase activity <i>in vitro</i>. The activity of the enzyme was determined using microsomal extracts of yeast overexpressing the <i>Arabidopsis</i> gene. Cytosolic fractions failed to be associated to the activity, leading to the speculation that the enzyme is membrane-bound.\"",
        "SecondarySymbol" : "3BETA-HYDROXYSTEROID-DEHYDROGENASE/DECARBOXYLASE ISOFORM 2 (3BETAHSD/D2);3BETA-HYDROXYSTEROID-DEHYDROGENASE/DECARBOXYLASE ISOFORM 2 (AT3BETAHSD/D2)",
        "sstart" : 4,
        "qstart" : 2190,
        "qcovhsp" : 10,
        "shared_name" : "KfCluster-15977.0",
        "ppos" : 68.0,
        "score" : 632,
        "pident" : 49.6,
        "SUID" : 16880,
        "selected" : false,
        "sseqid" : "AT2G26260",
        "length" : 250,
        "nident" : 124,
        "evalue" : 2.24E-72,
        "positive" : 170,
        "gaps" : 2,
        "Type" : "protein_coding",
        "bitscore" : 248.0,
        "slen" : 564,
        "mismatch" : 124,
        "name" : "KfCluster-15977.0",
        "send" : 252,
        "qcovs" : 30,
        "PrimarySymbol" : "3BETA-HYDROXYSTEROID-DEHYDROGENASE/DECARBOXYLASE ISOFORM 2 (3BETAHSD/D2)",
        "qend" : 1444
      },
      "position" : {
        "x" : -59.09100341796875,
        "y" : -835.9757690429688
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16879",
        "degree_layout" : 5,
        "Description" : "\"Encodes a UDP-L-Rhamnose synthase involved in the biosynthesis of rhamnose, a major monosaccharide component of pectin. Catalyzes the conversion of UDP-D-Glc to UDP-L-Rha.  The dehydrogenase domain of RHM1 was shown to catalyze the conversion of UDP-D-Glc to the reaction intermediate UDP-4-keto-6-deoxy-D-Glc using recombinant protein assay but the activity of the full-length protein was not determined as it could not be expressed in <i>E. coli</i>.\"",
        "SecondarySymbol" : "RHAMNOSE BIOSYNTHESIS 1 (RHM1);REPRESSOR OF LRX1 1 (ROL1);ARABIDOPSIS THALIANA RHAMNOSE BIOSYNTHESIS 1 (ATRHM1)",
        "sstart" : 2,
        "qstart" : 270,
        "qcovhsp" : 24,
        "shared_name" : "KfCluster-14831.0",
        "ppos" : 83.38,
        "score" : 2718,
        "pident" : 73.529,
        "SUID" : 16879,
        "selected" : false,
        "sseqid" : "AT1G78570",
        "length" : 680,
        "nident" : 500,
        "evalue" : 0.0,
        "positive" : 567,
        "gaps" : 15,
        "Type" : "protein_coding",
        "bitscore" : 1051.0,
        "slen" : 669,
        "mismatch" : 165,
        "name" : "KfCluster-14831.0",
        "send" : 669,
        "qcovs" : 71,
        "PrimarySymbol" : "RHAMNOSE BIOSYNTHESIS 1 (RHM1)",
        "qend" : 2300
      },
      "position" : {
        "x" : 130.15338134765625,
        "y" : -653.1831665039062
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16878",
        "degree_layout" : 9,
        "Description" : "\"Encodes a guard cell outward potassium channel.  Belongs to the Shaker family K+ channel. This family includes five groups based on phylogenetic analysis (FEBS Letters (2007) 581: 2357): I (inward rectifying channel): AKT1 (AT2G26650), AKT5 (AT4G32500) and SPIK (also known as AKT6, AT2G25600); II (inward rectifying channel): KAT1 (AT5G46240) and KAT2 (AT4G18290); III (weakly inward rectifying channel): AKT2 (AT4G22200); IV (regulatory subunit involved in inwardly rectifying conductance formation): KAT3 (also known as AtKC1, AT4G32650); V (outward rectifying channel): SKOR (AT3G02850) and GORK (AT5G37500). Mutants have increased water consumption and limited stomatal closure in response to abscisic and jasmonic acids. It forms a heteromeric K(out) channels with SKOR. The gene is expressed ubiquitously in root and the vasculature and guard cells of leaves. Expression is suppressed during agrobacterium-induced tumor formation and increased in response to water deprivation and cold.\"",
        "SecondarySymbol" : "GATED OUTWARDLY-RECTIFYING K+ CHANNEL (GORK)",
        "sstart" : 55,
        "qstart" : 720,
        "qcovhsp" : 23,
        "shared_name" : "KfCluster-21973.6",
        "ppos" : 47.97,
        "score" : 709,
        "pident" : 28.924,
        "SUID" : 16878,
        "selected" : false,
        "sseqid" : "AT5G37500",
        "length" : 688,
        "nident" : 199,
        "evalue" : 6.33E-80,
        "positive" : 330,
        "gaps" : 42,
        "Type" : "protein_coding",
        "bitscore" : 277.0,
        "slen" : 820,
        "mismatch" : 447,
        "name" : "KfCluster-21973.6",
        "send" : 714,
        "qcovs" : 69,
        "PrimarySymbol" : "GATED OUTWARDLY-RECTIFYING K+ CHANNEL (GORK)",
        "qend" : 2741
      },
      "position" : {
        "x" : -380.2684326171875,
        "y" : -542.4454956054688
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16873",
        "degree_layout" : 2,
        "Description" : "Involved in the conversion of the early brassinosteroid precursor  24-methylenecholesterol to campesterol. Brassinosteroids affect cellular elongation. Mutants have dwarf phenotype.  DWF1 is a Ca2+-dependent calmodulin-binding protein.",
        "SecondarySymbol" : "DWARF 1 (DWF1);DIMINUTIA (DIM);CABBAGE 1 (CBB1);DIMINUTO 1 (DIM1);ENHANCED VERY-LOW-FLUENCE RESPONSES 1 (EVE1)",
        "sstart" : 274,
        "qstart" : 3,
        "qcovhsp" : 30,
        "shared_name" : "SpCluster-3064.0",
        "ppos" : 100.0,
        "score" : 1569,
        "pident" : 100.0,
        "SUID" : 16873,
        "selected" : false,
        "sseqid" : "AT3G19820",
        "length" : 288,
        "nident" : 288,
        "evalue" : 0.0,
        "positive" : 288,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 608.0,
        "slen" : 561,
        "mismatch" : 0,
        "name" : "SpCluster-3064.0",
        "send" : 561,
        "qcovs" : 90,
        "PrimarySymbol" : "DWARF 1 (DWF1)",
        "qend" : 866
      },
      "position" : {
        "x" : 587.4356689453125,
        "y" : -547.4035034179688
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16872",
        "degree_layout" : 6,
        "Description" : "\"Encodes a cellulose synthase isomer. CESA3 mutants have cellulose defect in the primary cell wall. Multiple lines of evidence suggest that CESA3, along with CESA1 and CESA6 are present in the same plasma membrane complex for cellulose biosynthesis.  As inferred from the null role of secondary wall-type CesAs, included in a set of five primary wall-type CesAs that may support trichome cell wall thickening. The xylem cells in primary root have reduced cell expansion and higher than normal lignification.\"",
        "SecondarySymbol" : "ISOXABEN RESISTANT  1 (IXR1); (ATCESA3); (ATH-B);ECTOPIC LIGNIFICATION 1 (ELI1);CELLULOSE SYNTHASE 3 (CESA3);CONSTITUTIVE EXPRESSION OF VSP 1 (CEV1);MULTIPLE RESPONSE EXPANSION 1 (MRE1)",
        "sstart" : 20,
        "qstart" : 3478,
        "qcovhsp" : 22,
        "shared_name" : "KfCluster-32901.0",
        "ppos" : 67.11,
        "score" : 2701,
        "pident" : 53.5,
        "SUID" : 16872,
        "selected" : false,
        "sseqid" : "AT5G05170",
        "length" : 1043,
        "nident" : 558,
        "evalue" : 0.0,
        "positive" : 700,
        "gaps" : 70,
        "Type" : "protein_coding",
        "bitscore" : 1045.0,
        "slen" : 1065,
        "mismatch" : 415,
        "name" : "KfCluster-32901.0",
        "send" : 1046,
        "qcovs" : 66,
        "PrimarySymbol" : "CONSTITUTIVE EXPRESSION OF VSP 1 (CEV1)",
        "qend" : 512
      },
      "position" : {
        "x" : 593.4267578125,
        "y" : -753.2042846679688
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16871",
        "degree_layout" : 3,
        "Description" : "Involved in the conversion of the early brassinosteroid precursor  24-methylenecholesterol to campesterol. Brassinosteroids affect cellular elongation. Mutants have dwarf phenotype.  DWF1 is a Ca2+-dependent calmodulin-binding protein.",
        "SecondarySymbol" : "DWARF 1 (DWF1);DIMINUTIA (DIM);CABBAGE 1 (CBB1);DIMINUTO 1 (DIM1);ENHANCED VERY-LOW-FLUENCE RESPONSES 1 (EVE1)",
        "sstart" : 5,
        "qstart" : 120,
        "qcovhsp" : 22,
        "shared_name" : "KfCluster-14495.0",
        "ppos" : 78.94,
        "score" : 1908,
        "pident" : 65.568,
        "SUID" : 16871,
        "selected" : false,
        "sseqid" : "AT3G19820",
        "length" : 546,
        "nident" : 358,
        "evalue" : 0.0,
        "positive" : 431,
        "gaps" : 5,
        "Type" : "protein_coding",
        "bitscore" : 739.0,
        "slen" : 561,
        "mismatch" : 183,
        "name" : "KfCluster-14495.0",
        "send" : 545,
        "qcovs" : 65,
        "PrimarySymbol" : "DWARF 1 (DWF1)",
        "qend" : 1757
      },
      "position" : {
        "x" : 530.5134887695312,
        "y" : -625.1084594726562
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16870",
        "degree_layout" : 23,
        "Description" : "Encodes a nucleolar localized WD-40 repeat protein that is preferentially expressed in dividing cells and is required for regulated division planes and embryo development.",
        "SecondarySymbol" : "TORMOZEMBRYO DEFECTIVE (TOZ)",
        "sstart" : 6,
        "qstart" : 199,
        "qcovhsp" : 24,
        "shared_name" : "KfCluster-3899.0",
        "ppos" : 66.55,
        "score" : 2094,
        "pident" : 47.464,
        "SUID" : 16870,
        "selected" : false,
        "sseqid" : "AT5G16750",
        "length" : 828,
        "nident" : 393,
        "evalue" : 0.0,
        "positive" : 551,
        "gaps" : 28,
        "Type" : "protein_coding",
        "bitscore" : 811.0,
        "slen" : 876,
        "mismatch" : 407,
        "name" : "KfCluster-3899.0",
        "send" : 813,
        "qcovs" : 73,
        "PrimarySymbol" : "TORMOZEMBRYO DEFECTIVE (TOZ)",
        "qend" : 2658
      },
      "position" : {
        "x" : -643.6024169921875,
        "y" : -510.7005615234375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16869",
        "degree_layout" : 20,
        "Description" : "Transducin/WD40 repeat-like superfamily protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 26,
        "qstart" : 238,
        "qcovhsp" : 24,
        "shared_name" : "KfCluster-27310.0",
        "ppos" : 66.58,
        "score" : 1086,
        "pident" : 53.924,
        "SUID" : 16869,
        "selected" : false,
        "sseqid" : "AT2G46290",
        "length" : 395,
        "nident" : 213,
        "evalue" : 2.06E-145,
        "positive" : 263,
        "gaps" : 71,
        "Type" : "protein_coding",
        "bitscore" : 422.0,
        "slen" : 355,
        "mismatch" : 111,
        "name" : "KfCluster-27310.0",
        "send" : 354,
        "qcovs" : 71,
        "PrimarySymbol" : "0",
        "qend" : 1407
      },
      "position" : {
        "x" : -623.4153442382812,
        "y" : -463.4070739746094
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16868",
        "degree_layout" : 6,
        "Description" : "\"GHS40 encodes a WD40 protein, that is localized in the nucleus and nucleolus. In the presence of high glucose it negatively regulates the expression of  abscisic acid degradation and signaling genes.\"",
        "SecondarySymbol" : "NUCLEAR GLUCOSE-RESPONSIVE WD40 PROTEIN1 (NUGWD1); (ATGHS40);GLUCOSE HYPERSENSITIVE 40 (GHS40)",
        "sstart" : 95,
        "qstart" : 581,
        "qcovhsp" : 17,
        "shared_name" : "KfCluster-14418.0",
        "ppos" : 53.31,
        "score" : 315,
        "pident" : 29.965,
        "SUID" : 16868,
        "selected" : false,
        "sseqid" : "AT5G11240",
        "length" : 287,
        "nident" : 86,
        "evalue" : 1.54E-30,
        "positive" : 153,
        "gaps" : 18,
        "Type" : "protein_coding",
        "bitscore" : 125.0,
        "slen" : 615,
        "mismatch" : 183,
        "name" : "KfCluster-14418.0",
        "send" : 373,
        "qcovs" : 52,
        "PrimarySymbol" : "NUCLEAR GLUCOSE-RESPONSIVE WD40 PROTEIN1 (NUGWD1)",
        "qend" : 1411
      },
      "position" : {
        "x" : -541.7081909179688,
        "y" : -572.9168090820312
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16867",
        "degree_layout" : 12,
        "Description" : "member of GCN subfamily",
        "SecondarySymbol" : "GENERAL CONTROL NON-REPRESSIBLE 4 (ATGCN4);ATP-BINDING CASSETTE F4 (ABCF4);GENERAL CONTROL NON-REPRESSIBLE 4 (GCN4)",
        "sstart" : 636,
        "qstart" : 115,
        "qcovhsp" : 14,
        "shared_name" : "SpCluster-7952.1",
        "ppos" : 82.76,
        "score" : 91,
        "pident" : 55.172,
        "SUID" : 16867,
        "selected" : false,
        "sseqid" : "AT3G54540",
        "length" : 29,
        "nident" : 16,
        "evalue" : 2.89E-5,
        "positive" : 24,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 39.7,
        "slen" : 723,
        "mismatch" : 13,
        "name" : "SpCluster-7952.1",
        "send" : 664,
        "qcovs" : 43,
        "PrimarySymbol" : "ATP-BINDING CASSETTE F4 (ABCF4)",
        "qend" : 201
      },
      "position" : {
        "x" : 112.52906799316406,
        "y" : 44.19597244262695
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16866",
        "degree_layout" : 9,
        "Description" : "\"Encodes a member of GCN subfamily. Predicted to be involved in stress-associated protein translation control. The mutant is affected in MAMP ((microbe-associated molecular patterns)-induced stomatal closure, but not other MAMP-induced responses in the leaves.\"",
        "SecondarySymbol" : "GENERAL CONTROL NON-REPRESSIBLE 3 (ATGCN3);GENERAL CONTROL NON-REPRESSIBLE 3 (GCN3);ATP-BINDING CASSETTE F3 (ABCF3); (ATGCN20);SUSCEPTIBLE TO CORONATINE-DEFICIENT PST DC3000 5 (SCORD5);GENERAL CONTROL NON-REPRESSIBLE 20 (GCN20); (ATABCF3)",
        "sstart" : 577,
        "qstart" : 241,
        "qcovhsp" : 14,
        "shared_name" : "SpCluster-3370.0",
        "ppos" : 44.44,
        "score" : 81,
        "pident" : 34.722,
        "SUID" : 16866,
        "selected" : false,
        "sseqid" : "AT1G64550",
        "length" : 72,
        "nident" : 25,
        "evalue" : 0.006,
        "positive" : 32,
        "gaps" : 11,
        "Type" : "protein_coding",
        "bitscore" : 35.8,
        "slen" : 715,
        "mismatch" : 36,
        "name" : "SpCluster-3370.0",
        "send" : 647,
        "qcovs" : 43,
        "PrimarySymbol" : "ATP-BINDING CASSETTE F3 (ABCF3)",
        "qend" : 426
      },
      "position" : {
        "x" : 142.90811157226562,
        "y" : 106.64096069335938
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16865",
        "degree_layout" : 6,
        "Description" : "\"The WAG1 and its homolog, WAG2 each encodes a protein-serine/threonine kinase that are nearly 70% identical to PsPK3 protein. All three together with CsPK3 belong to PsPK3-type kinases. At the N-terminus, all four possess a serine/threonine-rich domain. They are closely related to Arabidopsis kinases PINOID. wag1/wag2 double mutants exhibit a pronounced wavy root phenotype when grown vertically on agar plates (while wild-type plants develop wavy roots only on plates inclined to angles less than 90 degrees), indicating an overlapping role for WAG1 and WAG2 as suppressors of root waving. Simultaneous disruption of PID(AT2G34650) and its 3 closest homologs (PID2/AT2G26700, WAG1/AT1G53700, and WAG2/AT3G14370) abolishes the formation of cotyledons.\"",
        "SecondarySymbol" : "PROTEIN KINASE 3 ARABIDOPSIS THALIANA (PK3AT);WAG 1 (WAG1)",
        "sstart" : 355,
        "qstart" : 141,
        "qcovhsp" : 21,
        "shared_name" : "SpCluster-17046.0",
        "ppos" : 59.57,
        "score" : 58,
        "pident" : 31.915,
        "SUID" : 16865,
        "selected" : false,
        "sseqid" : "AT1G53700",
        "length" : 47,
        "nident" : 15,
        "evalue" : 1.2,
        "positive" : 28,
        "gaps" : 3,
        "Type" : "protein_coding",
        "bitscore" : 26.9,
        "slen" : 476,
        "mismatch" : 29,
        "name" : "SpCluster-17046.0",
        "send" : 401,
        "qcovs" : 62,
        "PrimarySymbol" : "WAG 1 (WAG1)",
        "qend" : 10
      },
      "position" : {
        "x" : 239.65560913085938,
        "y" : 113.58795166015625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16864",
        "degree_layout" : 6,
        "Description" : "ILITHYIA (ILA) is a HEAT repeat protein involved in plant immunity. The gene is also involved in systemic acquired resistance induced by P. syringae expressing avrRps4. Loss-of-function mutants of ILA caused pleiotropic defects in the mutant plants. The mutant plants are smaller in size and the leaves are serrated and yellow to light green in color. Required for bacterium-triggered stomatal closure.",
        "SecondarySymbol" : "ILITHYIA (ILA)",
        "sstart" : 1337,
        "qstart" : 1232,
        "qcovhsp" : 20,
        "shared_name" : "SpCluster-14562.0",
        "ppos" : 58.47,
        "score" : 410,
        "pident" : 33.223,
        "SUID" : 16864,
        "selected" : false,
        "sseqid" : "AT1G64790",
        "length" : 301,
        "nident" : 100,
        "evalue" : 2.06E-42,
        "positive" : 176,
        "gaps" : 4,
        "Type" : "protein_coding",
        "bitscore" : 162.0,
        "slen" : 2610,
        "mismatch" : 197,
        "name" : "SpCluster-14562.0",
        "send" : 1635,
        "qcovs" : 60,
        "PrimarySymbol" : "ILITHYIA (ILA)",
        "qend" : 336
      },
      "position" : {
        "x" : 43.172035217285156,
        "y" : -309.685935779001
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17780",
        "degree_layout" : 11,
        "Description" : "myosin heavy chain-like protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 242,
        "qstart" : 1088,
        "qcovhsp" : 2,
        "shared_name" : "SpCluster-15223.0",
        "ppos" : 72.46,
        "score" : 114,
        "pident" : 50.725,
        "SUID" : 17780,
        "selected" : false,
        "sseqid" : "AT5G07890",
        "length" : 69,
        "nident" : 35,
        "evalue" : 2.21E-5,
        "positive" : 50,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 48.5,
        "slen" : 328,
        "mismatch" : 34,
        "name" : "SpCluster-15223.0",
        "send" : 310,
        "qcovs" : 5,
        "PrimarySymbol" : "0",
        "qend" : 1294
      },
      "position" : {
        "x" : 770.0317993164062,
        "y" : -1463.961669921875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16863",
        "degree_layout" : 20,
        "Description" : "member of RLI subfamily The mRNA is cell-to-cell mobile.",
        "SecondarySymbol" : "ARABIDOPSIS THALIANA RNASE L INHIBITOR PROTEIN 2 (ATRLI2);ATP-BINDING CASSETTE E2 (ABCE2);RNASE L INHIBITOR PROTEIN 2 (RLI2)",
        "sstart" : 3,
        "qstart" : 2027,
        "qcovhsp" : 23,
        "shared_name" : "KfCluster-8284.0",
        "ppos" : 92.38,
        "score" : 2704,
        "pident" : 84.768,
        "SUID" : 16863,
        "selected" : false,
        "sseqid" : "AT4G19210",
        "length" : 604,
        "nident" : 512,
        "evalue" : 0.0,
        "positive" : 558,
        "gaps" : 4,
        "Type" : "protein_coding",
        "bitscore" : 1046.0,
        "slen" : 605,
        "mismatch" : 88,
        "name" : "KfCluster-8284.0",
        "send" : 605,
        "qcovs" : 69,
        "PrimarySymbol" : "ATP-BINDING CASSETTE E2 (ABCE2)",
        "qend" : 225
      },
      "position" : {
        "x" : 194.12051391601562,
        "y" : 69.37625885009766
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16862",
        "degree_layout" : 17,
        "Description" : "ILITHYIA (ILA) is a HEAT repeat protein involved in plant immunity. The gene is also involved in systemic acquired resistance induced by P. syringae expressing avrRps4. Loss-of-function mutants of ILA caused pleiotropic defects in the mutant plants. The mutant plants are smaller in size and the leaves are serrated and yellow to light green in color. Required for bacterium-triggered stomatal closure.",
        "SecondarySymbol" : "ILITHYIA (ILA)",
        "sstart" : 1432,
        "qstart" : 40,
        "qcovhsp" : 16,
        "shared_name" : "KfCluster-7642.0",
        "ppos" : 57.59,
        "score" : 334,
        "pident" : 35.714,
        "SUID" : 16862,
        "selected" : false,
        "sseqid" : "AT1G64790",
        "length" : 224,
        "nident" : 80,
        "evalue" : 6.27E-33,
        "positive" : 129,
        "gaps" : 12,
        "Type" : "protein_coding",
        "bitscore" : 133.0,
        "slen" : 2610,
        "mismatch" : 132,
        "name" : "KfCluster-7642.0",
        "send" : 1646,
        "qcovs" : 47,
        "PrimarySymbol" : "ILITHYIA (ILA)",
        "qend" : 702
      },
      "position" : {
        "x" : -50.14595413208008,
        "y" : -241.48220042743853
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16861",
        "degree_layout" : 18,
        "Description" : "P-loop containing nucleoside triphosphate hydrolases superfamily protein;(source:Araport11)",
        "SecondarySymbol" : "ATP-BINDING CASSETTE I19 (ABCI19);NON-INTRINSIC ABC PROTEIN 4 (ATNAP4)",
        "sstart" : 13,
        "qstart" : 308,
        "qcovhsp" : 19,
        "shared_name" : "KfCluster-29585.0",
        "ppos" : 73.01,
        "score" : 823,
        "pident" : 60.9,
        "SUID" : 16861,
        "selected" : false,
        "sseqid" : "AT1G03905",
        "length" : 289,
        "nident" : 176,
        "evalue" : 2.39E-107,
        "positive" : 211,
        "gaps" : 13,
        "Type" : "protein_coding",
        "bitscore" : 321.0,
        "slen" : 290,
        "mismatch" : 100,
        "name" : "KfCluster-29585.0",
        "send" : 290,
        "qcovs" : 57,
        "PrimarySymbol" : "ATP-BINDING CASSETTE I19 (ABCI19)",
        "qend" : 1168
      },
      "position" : {
        "x" : 215.96629333496094,
        "y" : 84.98246002197266
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16860",
        "degree_layout" : 20,
        "Description" : "member of NAP subfamily",
        "SecondarySymbol" : "ATP-BINDING CASSETTE I20 (ABCI20);NON-INTRINSIC ABC PROTEIN 9 (NAP9)",
        "sstart" : 13,
        "qstart" : 381,
        "qcovhsp" : 23,
        "shared_name" : "KfCluster-24058.0",
        "ppos" : 75.39,
        "score" : 1018,
        "pident" : 68.77,
        "SUID" : 16860,
        "selected" : false,
        "sseqid" : "AT5G02270",
        "length" : 317,
        "nident" : 218,
        "evalue" : 3.31E-137,
        "positive" : 239,
        "gaps" : 20,
        "Type" : "protein_coding",
        "bitscore" : 396.0,
        "slen" : 328,
        "mismatch" : 79,
        "name" : "KfCluster-24058.0",
        "send" : 328,
        "qcovs" : 68,
        "PrimarySymbol" : "ATP-BINDING CASSETTE I20 (ABCI20)",
        "qend" : 1274
      },
      "position" : {
        "x" : 293.4813537597656,
        "y" : -40.746482849121094
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16859",
        "degree_layout" : 30,
        "Description" : "ATP-binding cassette A1;(source:Araport11)",
        "SecondarySymbol" : "ATP-BINDING CASSETTE A1 (ABCA1);ARABIDOPSIS THALIANA ATP-BINDING CASSETTE A1 (AtABCA1)",
        "sstart" : 162,
        "qstart" : 5933,
        "qcovhsp" : 9,
        "shared_name" : "KfCluster-21745.0",
        "ppos" : 55.59,
        "score" : 1129,
        "pident" : 40.503,
        "SUID" : 16859,
        "selected" : false,
        "sseqid" : "AT2G41700",
        "length" : 716,
        "nident" : 290,
        "evalue" : 5.16E-125,
        "positive" : 398,
        "gaps" : 66,
        "Type" : "protein_coding",
        "bitscore" : 439.0,
        "slen" : 1882,
        "mismatch" : 360,
        "name" : "KfCluster-21745.0",
        "send" : 873,
        "qcovs" : 26,
        "PrimarySymbol" : "ATP-BINDING CASSETTE A1 (ABCA1)",
        "qend" : 3972
      },
      "position" : {
        "x" : 270.8390808105469,
        "y" : -27.956541061401367
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16852",
        "degree_layout" : 2,
        "Description" : "putative obtusifoliol 14-alpha demethylase involved in sterol biosynthesis. The mRNA is cell-to-cell mobile.",
        "SecondarySymbol" : "EMBRYO DEFECTIVE 1738 (EMB1738);CYTOCHROME P450 51A2 (CYP51A2);CYTOCHROME P450 51 (CYP51);CYTOCHROME P450 51 (ATCYP51);CYTOCHROME P450 51G1 (CYP51G1)",
        "sstart" : 35,
        "qstart" : 1874,
        "qcovhsp" : 20,
        "shared_name" : "KfCluster-9709.0",
        "ppos" : 80.7,
        "score" : 1599,
        "pident" : 65.132,
        "SUID" : 16852,
        "selected" : false,
        "sseqid" : "AT1G11680",
        "length" : 456,
        "nident" : 297,
        "evalue" : 0.0,
        "positive" : 368,
        "gaps" : 3,
        "Type" : "protein_coding",
        "bitscore" : 620.0,
        "slen" : 488,
        "mismatch" : 156,
        "name" : "KfCluster-9709.0",
        "send" : 488,
        "qcovs" : 60,
        "PrimarySymbol" : "CYTOCHROME P450 51G1 (CYP51G1)",
        "qend" : 510
      },
      "position" : {
        "x" : 359.8830261230469,
        "y" : -479.1462097167969
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17779",
        "degree_layout" : 3,
        "Description" : "Glutaredoxin family protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 73,
        "qstart" : 772,
        "qcovhsp" : 5,
        "shared_name" : "SpCluster-11969.0",
        "ppos" : 62.94,
        "score" : 410,
        "pident" : 47.647,
        "SUID" : 17779,
        "selected" : false,
        "sseqid" : "AT5G06470",
        "length" : 170,
        "nident" : 81,
        "evalue" : 7.09E-45,
        "positive" : 107,
        "gaps" : 12,
        "Type" : "protein_coding",
        "bitscore" : 162.0,
        "slen" : 239,
        "mismatch" : 77,
        "name" : "SpCluster-11969.0",
        "send" : 239,
        "qcovs" : 14,
        "PrimarySymbol" : "0",
        "qend" : 290
      },
      "position" : {
        "x" : 842.3027954101562,
        "y" : -1685.1412353515625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16851",
        "degree_layout" : 4,
        "Description" : "\"Encodes a protein with C22-sterol desaturase activity. The enzyme was shown to catalyze in the presence of NADPH the conversion of &beta;-sitosterol to stigmasterol, but not that of 24-<i>epi</i>-campesterol to brassicasterol (unlike CYP710A2).\"",
        "SecondarySymbol" : "\"CYTOCHROME P450, FAMILY 710, SUBFAMILY A, POLYPEPTIDE 1 (CYP710A1)\"",
        "sstart" : 81,
        "qstart" : 1179,
        "qcovhsp" : 14,
        "shared_name" : "KfCluster-14089.0",
        "ppos" : 70.98,
        "score" : 1240,
        "pident" : 56.115,
        "SUID" : 16851,
        "selected" : false,
        "sseqid" : "AT2G34500",
        "length" : 417,
        "nident" : 234,
        "evalue" : 7.21E-161,
        "positive" : 296,
        "gaps" : 13,
        "Type" : "protein_coding",
        "bitscore" : 482.0,
        "slen" : 495,
        "mismatch" : 170,
        "name" : "KfCluster-14089.0",
        "send" : 489,
        "qcovs" : 42,
        "PrimarySymbol" : "\"CYTOCHROME P450, FAMILY 710, SUBFAMILY A, POLYPEPTIDE 1 (CYP710A1)\"",
        "qend" : 2414
      },
      "position" : {
        "x" : 219.08505249023438,
        "y" : -549.1139526367188
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16850",
        "degree_layout" : 14,
        "Description" : "\"Encodes BOP1, an ortholog of Block of cell proliferation (BOP) protein. A T-DNA null allele of the BOP1 gene is lethal, and a 50% decrease in transcript accumulation is sufficient to cause severe developmental defects linked to defective cell division.\"",
        "SecondarySymbol" : "ARABIDOPSIS THALIANA PESCADILLO ORTHOLOG1 (ATPEP1);BLOCK OF CELL PROLIFERATION 1 (BOP1); (ATPEIP1)",
        "sstart" : 144,
        "qstart" : 807,
        "qcovhsp" : 17,
        "shared_name" : "KfCluster-22654.0",
        "ppos" : 73.23,
        "score" : 1733,
        "pident" : 57.34,
        "SUID" : 16850,
        "selected" : false,
        "sseqid" : "AT2G40360",
        "length" : 579,
        "nident" : 332,
        "evalue" : 0.0,
        "positive" : 424,
        "gaps" : 2,
        "Type" : "protein_coding",
        "bitscore" : 672.0,
        "slen" : 753,
        "mismatch" : 245,
        "name" : "KfCluster-22654.0",
        "send" : 721,
        "qcovs" : 52,
        "PrimarySymbol" : "ARABIDOPSIS THALIANA PESCADILLO ORTHOLOG1 (ATPEP1)",
        "qend" : 2540
      },
      "position" : {
        "x" : -637.13623046875,
        "y" : -573.5631103515625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16849",
        "degree_layout" : 2,
        "Description" : "ARM repeat superfamily protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 29,
        "qstart" : 404,
        "qcovhsp" : 30,
        "shared_name" : "PpCluster-10241.0",
        "ppos" : 50.09,
        "score" : 2021,
        "pident" : 29.456,
        "SUID" : 16849,
        "selected" : false,
        "sseqid" : "AT3G06530",
        "length" : 2278,
        "nident" : 671,
        "evalue" : 0.0,
        "positive" : 1141,
        "gaps" : 264,
        "Type" : "protein_coding",
        "bitscore" : 783.0,
        "slen" : 2197,
        "mismatch" : 1343,
        "name" : "PpCluster-10241.0",
        "send" : 2197,
        "qcovs" : 91,
        "PrimarySymbol" : "0",
        "qend" : 6772
      },
      "position" : {
        "x" : -74.10687255859375,
        "y" : -968.6961669921875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16848",
        "degree_layout" : 5,
        "Description" : "ARM repeat superfamily protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 1334,
        "qstart" : 4089,
        "qcovhsp" : 13,
        "shared_name" : "KfCluster-13986.0",
        "ppos" : 50.33,
        "score" : 899,
        "pident" : 30.0,
        "SUID" : 16848,
        "selected" : false,
        "sseqid" : "AT3G06530",
        "length" : 920,
        "nident" : 276,
        "evalue" : 7.03E-97,
        "positive" : 463,
        "gaps" : 89,
        "Type" : "protein_coding",
        "bitscore" : 350.0,
        "slen" : 2197,
        "mismatch" : 555,
        "name" : "KfCluster-13986.0",
        "send" : 2197,
        "qcovs" : 38,
        "PrimarySymbol" : "0",
        "qend" : 6749
      },
      "position" : {
        "x" : -125.03012084960938,
        "y" : -1091.4171142578125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17776",
        "degree_layout" : 1,
        "Description" : "Encodes a circadian-regulated transcription factor which specifically controls cell expansion during leaf development by controlling ROS homeostasis. The mRNA is cell-to-cell mobile.",
        "SecondarySymbol" : "KUODA1 (CHINESE FOR ENLARGE OR EXPAND) (KUA1);MYB HYPOCOTYL ELONGATION-RELATED (MYBH)",
        "sstart" : 1,
        "qstart" : 1023,
        "qcovhsp" : 6,
        "shared_name" : "PpCluster-24281.0",
        "ppos" : 77.71,
        "score" : 486,
        "pident" : 66.265,
        "SUID" : 17776,
        "selected" : false,
        "sseqid" : "AT5G47390",
        "length" : 166,
        "nident" : 110,
        "evalue" : 7.81E-54,
        "positive" : 129,
        "gaps" : 14,
        "Type" : "protein_coding",
        "bitscore" : 191.0,
        "slen" : 365,
        "mismatch" : 42,
        "name" : "PpCluster-24281.0",
        "send" : 161,
        "qcovs" : 17,
        "PrimarySymbol" : "MYB HYPOCOTYL ELONGATION-RELATED (MYBH)",
        "qend" : 1493
      },
      "position" : {
        "x" : 17.881301879882812,
        "y" : -1178.4013671875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16847",
        "degree_layout" : 7,
        "Description" : "Avirulence induced gene (AIG1) family protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 191,
        "qstart" : 1804,
        "qcovhsp" : 3,
        "shared_name" : "SpCluster-13811.0",
        "ppos" : 53.06,
        "score" : 73,
        "pident" : 30.612,
        "SUID" : 16847,
        "selected" : false,
        "sseqid" : "AT1G33890",
        "length" : 98,
        "nident" : 30,
        "evalue" : 1.5,
        "positive" : 52,
        "gaps" : 12,
        "Type" : "protein_coding",
        "bitscore" : 32.7,
        "slen" : 334,
        "mismatch" : 56,
        "name" : "SpCluster-13811.0",
        "send" : 288,
        "qcovs" : 9,
        "PrimarySymbol" : "0",
        "qend" : 1547
      },
      "position" : {
        "x" : 597.7550659179688,
        "y" : -1447.828369140625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16846",
        "degree_layout" : 5,
        "Description" : "the glycosyltransferase (UGT72B1) is involved in metabolizing xenobiotica (chloroaniline and chlorophenole). Comparison between wild type and knock-out mutant demonstrates the central role of this gene for metabolizing chloroaniline but significantly less for chlorophenole. The glucosyltransferase preferred UDP-xylose over UDP-glucose indicating its (additional) functioning as a xylosyltransferase in planta",
        "SecondarySymbol" : "UDP-GLUCOSE-DEPENDENT GLUCOSYLTRANSFERASE 72 B1 (UGT72B1); (GT72B1)",
        "sstart" : 28,
        "qstart" : 3638,
        "qcovhsp" : 3,
        "shared_name" : "KfCluster-13942.0",
        "ppos" : 46.36,
        "score" : 94,
        "pident" : 30.909,
        "SUID" : 16846,
        "selected" : false,
        "sseqid" : "AT4G01070",
        "length" : 110,
        "nident" : 34,
        "evalue" : 0.006,
        "positive" : 51,
        "gaps" : 5,
        "Type" : "protein_coding",
        "bitscore" : 40.8,
        "slen" : 349,
        "mismatch" : 71,
        "name" : "KfCluster-13942.0",
        "send" : 137,
        "qcovs" : 9,
        "PrimarySymbol" : "(GT72B1)",
        "qend" : 3324
      },
      "position" : {
        "x" : 472.03955078125,
        "y" : -1318.805908203125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16845",
        "degree_layout" : 4,
        "Description" : "\"Barta et al (2010) have proposed a nomenclature for Serine/Arginine-Rich Protein Splicing Factors (SR proteins): Plant Cell. 2010, 22:2926.\"",
        "SecondarySymbol" : "ARGININE/SERINE-RICH ZINC KNUCKLE-CONTAINING PROTEIN 32 (RSZ32);ARGININE/SERINE-RICH ZINC KNUCKLE-CONTAINING PROTEIN 32 (RS2Z32);ARGININE/SERINE-RICH ZINC KNUCKLE-CONTAINING PROTEIN 32 (At-RS2Z)",
        "sstart" : 108,
        "qstart" : 256,
        "qcovhsp" : 2,
        "shared_name" : "SpCluster-20174.0",
        "ppos" : 60.98,
        "score" : 102,
        "pident" : 48.78,
        "SUID" : 16845,
        "selected" : false,
        "sseqid" : "AT3G53500",
        "length" : 41,
        "nident" : 20,
        "evalue" : 2.04E-4,
        "positive" : 25,
        "gaps" : 3,
        "Type" : "protein_coding",
        "bitscore" : 43.9,
        "slen" : 284,
        "mismatch" : 18,
        "name" : "SpCluster-20174.0",
        "send" : 148,
        "qcovs" : 7,
        "PrimarySymbol" : "ARGININE/SERINE-RICH ZINC KNUCKLE-CONTAINING PROTEIN 32 (RS2Z32)",
        "qend" : 369
      },
      "position" : {
        "x" : -166.51950073242188,
        "y" : -1209.6068115234375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17775",
        "degree_layout" : 4,
        "Description" : "member of MRP subfamily",
        "SecondarySymbol" : "MULTIDRUG RESISTANCE-ASSOCIATED PROTEIN 10 (MRP10);MULTIDRUG RESISTANCE-ASSOCIATED PROTEIN 10 (ATMRP10);ATP-BINDING CASSETTE C14 (ABCC14)",
        "sstart" : 540,
        "qstart" : 526,
        "qcovhsp" : 32,
        "shared_name" : "SpCluster-1188.1",
        "ppos" : 53.41,
        "score" : 227,
        "pident" : 35.227,
        "SUID" : 17775,
        "selected" : false,
        "sseqid" : "AT3G62700",
        "length" : 176,
        "nident" : 62,
        "evalue" : 7.9E-22,
        "positive" : 94,
        "gaps" : 3,
        "Type" : "protein_coding",
        "bitscore" : 92.0,
        "slen" : 1539,
        "mismatch" : 111,
        "name" : "SpCluster-1188.1",
        "send" : 715,
        "qcovs" : 96,
        "PrimarySymbol" : "ATP-BINDING CASSETTE C14 (ABCC14)",
        "qend" : 8
      },
      "position" : {
        "x" : 398.1310729980469,
        "y" : 1.907440185546875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16844",
        "degree_layout" : 2,
        "Description" : "Encodes a cold shock domain protein. Involved in cold acclimation by blocking the secondary structure of mRNA which in turn facilitates translation at cold temperature.",
        "SecondarySymbol" : "COLD SHOCK DOMAIN PROTEIN 1 (CSDP1);COLD SHOCK PROTEIN 1 (CSP1); (ATCSP1)",
        "sstart" : 200,
        "qstart" : 1827,
        "qcovhsp" : 3,
        "shared_name" : "SpCluster-17615.0",
        "ppos" : 41.05,
        "score" : 88,
        "pident" : 27.368,
        "SUID" : 16844,
        "selected" : false,
        "sseqid" : "AT4G36020",
        "length" : 95,
        "nident" : 26,
        "evalue" : 0.018,
        "positive" : 39,
        "gaps" : 2,
        "Type" : "protein_coding",
        "bitscore" : 38.5,
        "slen" : 299,
        "mismatch" : 67,
        "name" : "SpCluster-17615.0",
        "send" : 292,
        "qcovs" : 10,
        "PrimarySymbol" : "COLD SHOCK DOMAIN PROTEIN 1 (CSDP1)",
        "qend" : 2111
      },
      "position" : {
        "x" : -683.8621215820312,
        "y" : -1073.734130859375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16843",
        "degree_layout" : 1,
        "Description" : "Encodes a U12-type spliceosomal protein U11/U12-31K.  Involved in U12 intron splicing via RNA chaperone activity and affects plant development.",
        "SecondarySymbol" : "U11/U12-31K (U11/U12-31K)",
        "sstart" : 154,
        "qstart" : 925,
        "qcovhsp" : 1,
        "shared_name" : "KfCluster-19518.0",
        "ppos" : 87.5,
        "score" : 78,
        "pident" : 68.75,
        "SUID" : 16843,
        "selected" : false,
        "sseqid" : "AT3G10400",
        "length" : 16,
        "nident" : 11,
        "evalue" : 0.16,
        "positive" : 14,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 34.7,
        "slen" : 261,
        "mismatch" : 5,
        "name" : "KfCluster-19518.0",
        "send" : 169,
        "qcovs" : 2,
        "PrimarySymbol" : "U11/U12-31K (U11/U12-31K)",
        "qend" : 972
      },
      "position" : {
        "x" : -739.771484375,
        "y" : -1043.392578125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16842",
        "degree_layout" : 8,
        "Description" : "Encodes a cold shock domain protein. Involved in cold acclimation by blocking the secondary structure of mRNA which in turn facilitates translation at cold temperature.",
        "SecondarySymbol" : "COLD SHOCK DOMAIN PROTEIN 1 (CSDP1);COLD SHOCK PROTEIN 1 (CSP1); (ATCSP1)",
        "sstart" : 102,
        "qstart" : 1165,
        "qcovhsp" : 14,
        "shared_name" : "KfCluster-13778.0",
        "ppos" : 45.05,
        "score" : 277,
        "pident" : 34.685,
        "SUID" : 16842,
        "selected" : false,
        "sseqid" : "AT4G36020",
        "length" : 222,
        "nident" : 77,
        "evalue" : 2.62E-27,
        "positive" : 100,
        "gaps" : 42,
        "Type" : "protein_coding",
        "bitscore" : 111.0,
        "slen" : 299,
        "mismatch" : 103,
        "name" : "KfCluster-13778.0",
        "send" : 298,
        "qcovs" : 42,
        "PrimarySymbol" : "COLD SHOCK DOMAIN PROTEIN 1 (CSDP1)",
        "qend" : 551
      },
      "position" : {
        "x" : -552.519775390625,
        "y" : -1068.605224609375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16841",
        "degree_layout" : 14,
        "Description" : "\"Plant-specific protein. Interacts with phragmoplastin, Rop1 and Rop2. Involved in cell plate formation.\"",
        "SecondarySymbol" : "PHRAGMOPLASTIN INTERACTING PROTEIN 1 (PHIP1)",
        "sstart" : 162,
        "qstart" : 297,
        "qcovhsp" : 10,
        "shared_name" : "SpCluster-15016.0",
        "ppos" : 49.43,
        "score" : 364,
        "pident" : 34.981,
        "SUID" : 16841,
        "selected" : false,
        "sseqid" : "AT3G55340",
        "length" : 263,
        "nident" : 92,
        "evalue" : 4.99E-36,
        "positive" : 130,
        "gaps" : 40,
        "Type" : "protein_coding",
        "bitscore" : 144.0,
        "slen" : 597,
        "mismatch" : 131,
        "name" : "SpCluster-15016.0",
        "send" : 417,
        "qcovs" : 29,
        "PrimarySymbol" : "PHRAGMOPLASTIN INTERACTING PROTEIN 1 (PHIP1)",
        "qend" : 986
      },
      "position" : {
        "x" : -1516.97705078125,
        "y" : -876.18408203125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16840",
        "degree_layout" : 24,
        "Description" : "\"polyadenylate-binding protein, putative / PABP, putative, similar to poly(A)-binding protein GB:AAF66825 GI:7673359 from (Nicotiana tabacum). Highly and ubiquitously expressed. Member of the class II PABP family.\"",
        "SecondarySymbol" : "POLY(A) BINDING PROTEIN 8 (PABP8);POLY(A) BINDING PROTEIN 8 (PAB8)",
        "sstart" : 44,
        "qstart" : 2807,
        "qcovhsp" : 15,
        "shared_name" : "KfCluster-3086.0",
        "ppos" : 77.53,
        "score" : 1405,
        "pident" : 63.371,
        "SUID" : 16840,
        "selected" : false,
        "sseqid" : "AT1G49760",
        "length" : 445,
        "nident" : 282,
        "evalue" : 0.0,
        "positive" : 345,
        "gaps" : 2,
        "Type" : "protein_coding",
        "bitscore" : 545.0,
        "slen" : 671,
        "mismatch" : 161,
        "name" : "KfCluster-3086.0",
        "send" : 486,
        "qcovs" : 44,
        "PrimarySymbol" : "POLY(A) BINDING PROTEIN 8 (PAB8)",
        "qend" : 1473
      },
      "position" : {
        "x" : -1525.2064208984375,
        "y" : -915.8843383789062
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16839",
        "degree_layout" : 5,
        "Description" : "RNA-binding (RRM/RBD/RNP motifs) family protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 40,
        "qstart" : 1174,
        "qcovhsp" : 9,
        "shared_name" : "KfCluster-13548.0",
        "ppos" : 52.68,
        "score" : 296,
        "pident" : 35.61,
        "SUID" : 16839,
        "selected" : false,
        "sseqid" : "AT5G66010",
        "length" : 205,
        "nident" : 73,
        "evalue" : 8.72E-30,
        "positive" : 108,
        "gaps" : 28,
        "Type" : "protein_coding",
        "bitscore" : 118.0,
        "slen" : 255,
        "mismatch" : 104,
        "name" : "KfCluster-13548.0",
        "send" : 239,
        "qcovs" : 26,
        "PrimarySymbol" : "0",
        "qend" : 629
      },
      "position" : {
        "x" : -1441.595947265625,
        "y" : -892.7250366210938
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16838",
        "degree_layout" : 24,
        "Description" : "member of GCN subfamily",
        "SecondarySymbol" : "GENERAL CONTROL NON-REPRESSIBLE 4 (ATGCN4);ATP-BINDING CASSETTE F4 (ABCF4);GENERAL CONTROL NON-REPRESSIBLE 4 (GCN4)",
        "sstart" : 617,
        "qstart" : 62,
        "qcovhsp" : 23,
        "shared_name" : "SpCluster-7952.0",
        "ppos" : 72.92,
        "score" : 127,
        "pident" : 50.0,
        "SUID" : 16838,
        "selected" : false,
        "sseqid" : "AT3G54540",
        "length" : 48,
        "nident" : 24,
        "evalue" : 4.82E-10,
        "positive" : 35,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 53.5,
        "slen" : 723,
        "mismatch" : 24,
        "name" : "SpCluster-7952.0",
        "send" : 664,
        "qcovs" : 70,
        "PrimarySymbol" : "ATP-BINDING CASSETTE F4 (ABCF4)",
        "qend" : 205
      },
      "position" : {
        "x" : 174.18199157714844,
        "y" : 37.68815994262695
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17774",
        "degree_layout" : 3,
        "Description" : "zinc knuckle (CCHC-type) family protein;(source:Araport11)",
        "SecondarySymbol" : "EMBRYO DEFECTIVE 1441 (emb1441)",
        "sstart" : 935,
        "qstart" : 596,
        "qcovhsp" : 6,
        "shared_name" : "SpCluster-9967.0",
        "ppos" : 77.52,
        "score" : 387,
        "pident" : 55.039,
        "SUID" : 17774,
        "selected" : false,
        "sseqid" : "AT5G49930",
        "length" : 129,
        "nident" : 71,
        "evalue" : 2.32E-38,
        "positive" : 100,
        "gaps" : 1,
        "Type" : "protein_coding",
        "bitscore" : 153.0,
        "slen" : 1080,
        "mismatch" : 57,
        "name" : "SpCluster-9967.0",
        "send" : 1062,
        "qcovs" : 18,
        "PrimarySymbol" : "EMBRYO DEFECTIVE 1441 (emb1441)",
        "qend" : 210
      },
      "position" : {
        "x" : 1053.2520751953125,
        "y" : -1278.125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17773",
        "degree_layout" : 2,
        "Description" : "zinc knuckle (CCHC-type) family protein;(source:Araport11)",
        "SecondarySymbol" : "EMBRYO DEFECTIVE 1441 (emb1441)",
        "sstart" : 950,
        "qstart" : 1168,
        "qcovhsp" : 6,
        "shared_name" : "PpCluster-23936.0",
        "ppos" : 79.65,
        "score" : 390,
        "pident" : 61.062,
        "SUID" : 17773,
        "selected" : false,
        "sseqid" : "AT5G49930",
        "length" : 113,
        "nident" : 69,
        "evalue" : 4.91E-39,
        "positive" : 90,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 154.0,
        "slen" : 1080,
        "mismatch" : 44,
        "name" : "PpCluster-23936.0",
        "send" : 1062,
        "qcovs" : 18,
        "PrimarySymbol" : "EMBRYO DEFECTIVE 1441 (emb1441)",
        "qend" : 1506
      },
      "position" : {
        "x" : 1182.32080078125,
        "y" : -1218.806396484375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16837",
        "degree_layout" : 38,
        "Description" : "\"Encodes a member of GCN subfamily. Predicted to be involved in stress-associated protein translation control. The mutant is affected in MAMP ((microbe-associated molecular patterns)-induced stomatal closure, but not other MAMP-induced responses in the leaves.\"",
        "SecondarySymbol" : "GENERAL CONTROL NON-REPRESSIBLE 3 (ATGCN3);GENERAL CONTROL NON-REPRESSIBLE 3 (GCN3);ATP-BINDING CASSETTE F3 (ABCF3); (ATGCN20);SUSCEPTIBLE TO CORONATINE-DEFICIENT PST DC3000 5 (SCORD5);GENERAL CONTROL NON-REPRESSIBLE 20 (GCN20); (ATABCF3)",
        "sstart" : 180,
        "qstart" : 46,
        "qcovhsp" : 31,
        "shared_name" : "SpCluster-16506.0",
        "ppos" : 45.68,
        "score" : 451,
        "pident" : 31.111,
        "SUID" : 16837,
        "selected" : false,
        "sseqid" : "AT1G64550",
        "length" : 405,
        "nident" : 126,
        "evalue" : 2.1E-50,
        "positive" : 185,
        "gaps" : 106,
        "Type" : "protein_coding",
        "bitscore" : 178.0,
        "slen" : 715,
        "mismatch" : 173,
        "name" : "SpCluster-16506.0",
        "send" : 575,
        "qcovs" : 92,
        "PrimarySymbol" : "ATP-BINDING CASSETTE F3 (ABCF3)",
        "qend" : 969
      },
      "position" : {
        "x" : 213.61708068847656,
        "y" : -3.3779296875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16836",
        "degree_layout" : 36,
        "Description" : "member of GCN subfamily",
        "SecondarySymbol" : "ARABIDOPSIS THALIANA GENERAL CONTROL NON-REPRESSIBLE 1 (ATGCN1);ATP-BINDING CASSETTE F1 (ABCF1);GENERAL CONTROL NON-REPRESSIBLE 1 (GCN1)",
        "sstart" : 226,
        "qstart" : 1982,
        "qcovhsp" : 12,
        "shared_name" : "KfCluster-7115.0",
        "ppos" : 46.5,
        "score" : 323,
        "pident" : 30.42,
        "SUID" : 16836,
        "selected" : false,
        "sseqid" : "AT5G60790",
        "length" : 286,
        "nident" : 87,
        "evalue" : 4.18E-31,
        "positive" : 133,
        "gaps" : 47,
        "Type" : "protein_coding",
        "bitscore" : 129.0,
        "slen" : 595,
        "mismatch" : 152,
        "name" : "KfCluster-7115.0",
        "send" : 508,
        "qcovs" : 37,
        "PrimarySymbol" : "ATP-BINDING CASSETTE F1 (ABCF1)",
        "qend" : 1257
      },
      "position" : {
        "x" : 309.29541015625,
        "y" : 84.4692153930664
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16835",
        "degree_layout" : 36,
        "Description" : "member of GCN subfamily",
        "SecondarySymbol" : "GENERAL CONTROL NON-REPRESSIBLE 4 (ATGCN4);ATP-BINDING CASSETTE F4 (ABCF4);GENERAL CONTROL NON-REPRESSIBLE 4 (GCN4)",
        "sstart" : 101,
        "qstart" : 2162,
        "qcovhsp" : 23,
        "shared_name" : "KfCluster-4858.0",
        "ppos" : 82.75,
        "score" : 2116,
        "pident" : 68.85,
        "SUID" : 16835,
        "selected" : false,
        "sseqid" : "AT3G54540",
        "length" : 626,
        "nident" : 431,
        "evalue" : 0.0,
        "positive" : 518,
        "gaps" : 3,
        "Type" : "protein_coding",
        "bitscore" : 819.0,
        "slen" : 723,
        "mismatch" : 192,
        "name" : "KfCluster-4858.0",
        "send" : 723,
        "qcovs" : 68,
        "PrimarySymbol" : "ATP-BINDING CASSETTE F4 (ABCF4)",
        "qend" : 285
      },
      "position" : {
        "x" : 172.0079803466797,
        "y" : -68.80329132080078
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16834",
        "degree_layout" : 37,
        "Description" : "member of GCN subfamily",
        "SecondarySymbol" : "ARABIDOPSIS THALIANA GENERAL CONTROL NON-REPRESSIBLE 1 (ATGCN1);ATP-BINDING CASSETTE F1 (ABCF1);GENERAL CONTROL NON-REPRESSIBLE 1 (GCN1)",
        "sstart" : 54,
        "qstart" : 2129,
        "qcovhsp" : 17,
        "shared_name" : "KfCluster-29944.0",
        "ppos" : 70.99,
        "score" : 1609,
        "pident" : 56.204,
        "SUID" : 16834,
        "selected" : false,
        "sseqid" : "AT5G60790",
        "length" : 548,
        "nident" : 308,
        "evalue" : 0.0,
        "positive" : 389,
        "gaps" : 9,
        "Type" : "protein_coding",
        "bitscore" : 624.0,
        "slen" : 595,
        "mismatch" : 231,
        "name" : "KfCluster-29944.0",
        "send" : 593,
        "qcovs" : 51,
        "PrimarySymbol" : "ATP-BINDING CASSETTE F1 (ABCF1)",
        "qend" : 489
      },
      "position" : {
        "x" : 150.58323669433594,
        "y" : -32.36558532714844
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16833",
        "degree_layout" : 22,
        "Description" : "member of GCN subfamily",
        "SecondarySymbol" : "GENERAL CONTROL NON-REPRESSIBLE 4 (ATGCN4);ATP-BINDING CASSETTE F4 (ABCF4);GENERAL CONTROL NON-REPRESSIBLE 4 (GCN4)",
        "sstart" : 535,
        "qstart" : 1289,
        "qcovhsp" : 15,
        "shared_name" : "KfCluster-1342.0",
        "ppos" : 49.24,
        "score" : 239,
        "pident" : 32.995,
        "SUID" : 16833,
        "selected" : false,
        "sseqid" : "AT3G54540",
        "length" : 197,
        "nident" : 65,
        "evalue" : 2.57E-21,
        "positive" : 97,
        "gaps" : 22,
        "Type" : "protein_coding",
        "bitscore" : 96.7,
        "slen" : 723,
        "mismatch" : 110,
        "name" : "KfCluster-1342.0",
        "send" : 715,
        "qcovs" : 44,
        "PrimarySymbol" : "ATP-BINDING CASSETTE F4 (ABCF4)",
        "qend" : 717
      },
      "position" : {
        "x" : 266.3496398925781,
        "y" : 16.67398452758789
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16832",
        "degree_layout" : 7,
        "Description" : "receptor like protein 4;(source:Araport11)",
        "SecondarySymbol" : "RECEPTOR LIKE PROTEIN 4 (RLP4);RECEPTOR LIKE PROTEIN 4 (AtRLP4)",
        "sstart" : 239,
        "qstart" : 3248,
        "qcovhsp" : 3,
        "shared_name" : "KfCluster-4507.0",
        "ppos" : 42.74,
        "score" : 82,
        "pident" : 29.032,
        "SUID" : 16832,
        "selected" : false,
        "sseqid" : "AT1G28340",
        "length" : 124,
        "nident" : 36,
        "evalue" : 0.21,
        "positive" : 53,
        "gaps" : 6,
        "Type" : "protein_coding",
        "bitscore" : 36.2,
        "slen" : 626,
        "mismatch" : 82,
        "name" : "KfCluster-4507.0",
        "send" : 360,
        "qcovs" : 9,
        "PrimarySymbol" : "RECEPTOR LIKE PROTEIN 4 (RLP4)",
        "qend" : 2889
      },
      "position" : {
        "x" : -257.3712463378906,
        "y" : -1303.28369140625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17769",
        "degree_layout" : 8,
        "Description" : "xyloglucan endotransglucosylase/hydrolase 1;(source:Araport11)",
        "SecondarySymbol" : "XYLOGLUCAN ENDOTRANSGLUCOSYLASE/HYDROLASE 1 (XTH1)",
        "sstart" : 67,
        "qstart" : 834,
        "qcovhsp" : 4,
        "shared_name" : "SpCluster-18408.0",
        "ppos" : 54.0,
        "score" : 178,
        "pident" : 43.0,
        "SUID" : 17769,
        "selected" : false,
        "sseqid" : "AT4G13080",
        "length" : 100,
        "nident" : 43,
        "evalue" : 6.52E-14,
        "positive" : 54,
        "gaps" : 5,
        "Type" : "protein_coding",
        "bitscore" : 73.2,
        "slen" : 292,
        "mismatch" : 52,
        "name" : "SpCluster-18408.0",
        "send" : 163,
        "qcovs" : 13,
        "PrimarySymbol" : "XYLOGLUCAN ENDOTRANSGLUCOSYLASE/HYDROLASE 1 (XTH1)",
        "qend" : 541
      },
      "position" : {
        "x" : -932.7446899414062,
        "y" : -624.4306640625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16831",
        "degree_layout" : 6,
        "Description" : "Di-glucose binding protein with Kinesin motor domain-containing protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 64,
        "qstart" : 2243,
        "qcovhsp" : 4,
        "shared_name" : "KfCluster-27895.0",
        "ppos" : 44.23,
        "score" : 146,
        "pident" : 31.41,
        "SUID" : 16831,
        "selected" : false,
        "sseqid" : "AT2G22610",
        "length" : 156,
        "nident" : 49,
        "evalue" : 5.06E-9,
        "positive" : 69,
        "gaps" : 29,
        "Type" : "protein_coding",
        "bitscore" : 60.8,
        "slen" : 1062,
        "mismatch" : 78,
        "name" : "KfCluster-27895.0",
        "send" : 196,
        "qcovs" : 13,
        "PrimarySymbol" : "0",
        "qend" : 1794
      },
      "position" : {
        "x" : -286.1615295410156,
        "y" : -1335.66455078125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17768",
        "degree_layout" : 8,
        "Description" : "xyloglucan endotransglucosylase/hydrolase 1;(source:Araport11)",
        "SecondarySymbol" : "XYLOGLUCAN ENDOTRANSGLUCOSYLASE/HYDROLASE 1 (XTH1)",
        "sstart" : 79,
        "qstart" : 4,
        "qcovhsp" : 8,
        "shared_name" : "SpCluster-18377.0",
        "ppos" : 53.33,
        "score" : 153,
        "pident" : 40.0,
        "SUID" : 17768,
        "selected" : false,
        "sseqid" : "AT4G13080",
        "length" : 90,
        "nident" : 36,
        "evalue" : 3.76E-11,
        "positive" : 48,
        "gaps" : 7,
        "Type" : "protein_coding",
        "bitscore" : 63.5,
        "slen" : 292,
        "mismatch" : 47,
        "name" : "SpCluster-18377.0",
        "send" : 163,
        "qcovs" : 24,
        "PrimarySymbol" : "XYLOGLUCAN ENDOTRANSGLUCOSYLASE/HYDROLASE 1 (XTH1)",
        "qend" : 267
      },
      "position" : {
        "x" : -993.67529296875,
        "y" : -582.2745361328125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17767",
        "degree_layout" : 8,
        "Description" : "Encodes a putative amino acid transporter that localizes to the chloroplast inner envelope membrane.",
        "SecondarySymbol" : "0",
        "sstart" : 122,
        "qstart" : 539,
        "qcovhsp" : 12,
        "shared_name" : "SpCluster-14556.1",
        "ppos" : 63.15,
        "score" : 854,
        "pident" : 50.337,
        "SUID" : 17767,
        "selected" : false,
        "sseqid" : "AT5G19500",
        "length" : 445,
        "nident" : 224,
        "evalue" : 7.1E-102,
        "positive" : 281,
        "gaps" : 66,
        "Type" : "protein_coding",
        "bitscore" : 333.0,
        "slen" : 505,
        "mismatch" : 155,
        "name" : "SpCluster-14556.1",
        "send" : 501,
        "qcovs" : 35,
        "PrimarySymbol" : "0",
        "qend" : 1870
      },
      "position" : {
        "x" : -990.3433837890625,
        "y" : -695.97900390625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17766",
        "degree_layout" : 8,
        "Description" : "xyloglucan endotransglucosylase/hydrolase 1;(source:Araport11)",
        "SecondarySymbol" : "XYLOGLUCAN ENDOTRANSGLUCOSYLASE/HYDROLASE 1 (XTH1)",
        "sstart" : 42,
        "qstart" : 1459,
        "qcovhsp" : 6,
        "shared_name" : "PpCluster-23676.0",
        "ppos" : 59.28,
        "score" : 301,
        "pident" : 40.12,
        "SUID" : 17766,
        "selected" : false,
        "sseqid" : "AT4G13080",
        "length" : 167,
        "nident" : 67,
        "evalue" : 8.59E-30,
        "positive" : 99,
        "gaps" : 7,
        "Type" : "protein_coding",
        "bitscore" : 120.0,
        "slen" : 292,
        "mismatch" : 93,
        "name" : "PpCluster-23676.0",
        "send" : 206,
        "qcovs" : 17,
        "PrimarySymbol" : "XYLOGLUCAN ENDOTRANSGLUCOSYLASE/HYDROLASE 1 (XTH1)",
        "qend" : 1944
      },
      "position" : {
        "x" : -1040.6014404296875,
        "y" : -650.5982055664062
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16826",
        "degree_layout" : 3,
        "Description" : "Encodes a protein with  putative galacturonosyltransferase activity. The mRNA is cell-to-cell mobile.",
        "SecondarySymbol" : "(LGT1);GALACTURONOSYLTRANSFERASE 1 (GAUT1)",
        "sstart" : 196,
        "qstart" : 1563,
        "qcovhsp" : 12,
        "shared_name" : "SpCluster-20316.0",
        "ppos" : 80.32,
        "score" : 1516,
        "pident" : 61.556,
        "SUID" : 16826,
        "selected" : false,
        "sseqid" : "AT3G61130",
        "length" : 437,
        "nident" : 269,
        "evalue" : 0.0,
        "positive" : 351,
        "gaps" : 8,
        "Type" : "protein_coding",
        "bitscore" : 588.0,
        "slen" : 673,
        "mismatch" : 160,
        "name" : "SpCluster-20316.0",
        "send" : 624,
        "qcovs" : 36,
        "PrimarySymbol" : "GALACTURONOSYLTRANSFERASE 1 (GAUT1)",
        "qend" : 2873
      },
      "position" : {
        "x" : 107.73919677734375,
        "y" : -962.1458129882812
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16825",
        "degree_layout" : 3,
        "Description" : "Encodes a protein with  putative galacturonosyltransferase activity. The mRNA is cell-to-cell mobile.",
        "SecondarySymbol" : "(LGT1);GALACTURONOSYLTRANSFERASE 1 (GAUT1)",
        "sstart" : 212,
        "qstart" : 1793,
        "qcovhsp" : 16,
        "shared_name" : "KfCluster-13110.0",
        "ppos" : 66.95,
        "score" : 1236,
        "pident" : 47.49,
        "SUID" : 16825,
        "selected" : false,
        "sseqid" : "AT3G61130",
        "length" : 478,
        "nident" : 227,
        "evalue" : 6.69E-158,
        "positive" : 320,
        "gaps" : 24,
        "Type" : "protein_coding",
        "bitscore" : 480.0,
        "slen" : 673,
        "mismatch" : 227,
        "name" : "KfCluster-13110.0",
        "send" : 671,
        "qcovs" : 49,
        "PrimarySymbol" : "GALACTURONOSYLTRANSFERASE 1 (GAUT1)",
        "qend" : 378
      },
      "position" : {
        "x" : -13.201793670654297,
        "y" : -912.9784545898438
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16824",
        "degree_layout" : 39,
        "Description" : "\"Membrane-bound protein serine/threonine kinase that functions as blue light photoreceptor in redundancy with PHO1. Involved in stomatal opening, chloroplast movement and phototropism. Mediates blue light-induced growth enhancements. PHOT1 and PHOT2 mediate blue light-dependent activation of the plasma membrane H+-ATPase in guard cell protoplasts. PHOT2 possesses two LOV (LOV1 and LOV2, for light-oxygen-voltage-sensing) domains involved in FMN-binding and a C-terminus forming a serine/threonine kinase domain. LOV2 acts as an inhibitor of phototropin kinase in the dark, and light cancels the inhibition through cysteine-FMN adduct formation. LOV1 in contrast acts as an attenuator of photoactivation.  Localized to the Golgi apparatus under the induction of blue light. The mRNA is cell-to-cell mobile.\"",
        "SecondarySymbol" : "PHOTOTROPIN 2 (PHOT2); (ATPHOT2);NON PHOTOTROPIC HYPOCOTYL 1-LIKE (NPL1)",
        "sstart" : 369,
        "qstart" : 52,
        "qcovhsp" : 25,
        "shared_name" : "PpCluster-21401.2",
        "ppos" : 84.65,
        "score" : 1905,
        "pident" : 70.669,
        "SUID" : 16824,
        "selected" : false,
        "sseqid" : "AT5G58140",
        "length" : 508,
        "nident" : 359,
        "evalue" : 0.0,
        "positive" : 430,
        "gaps" : 1,
        "Type" : "protein_coding",
        "bitscore" : 738.0,
        "slen" : 915,
        "mismatch" : 148,
        "name" : "PpCluster-21401.2",
        "send" : 875,
        "qcovs" : 75,
        "PrimarySymbol" : "PHOTOTROPIN 2 (PHOT2)",
        "qend" : 1575
      },
      "position" : {
        "x" : -122.94661239630597,
        "y" : -1669.7770127867996
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16823",
        "degree_layout" : 18,
        "Description" : "\"Chloroplast thylakoid protein kinase STN8 is specific in phosphorylation of N-terminal threonine residues in D1, D2  and CP43 proteins, and Thr-4 in PsbH  protein of photosystem II. Phosphorylation of Thr-4 in  the wild type required both light and prior  phosphorylation at Thr-2.\"",
        "SecondarySymbol" : "STATE TRANSITION 8 (STN8)",
        "sstart" : 82,
        "qstart" : 1433,
        "qcovhsp" : 20,
        "shared_name" : "KfCluster-13017.0",
        "ppos" : 73.49,
        "score" : 1124,
        "pident" : 58.554,
        "SUID" : 16823,
        "selected" : false,
        "sseqid" : "AT5G01920",
        "length" : 415,
        "nident" : 243,
        "evalue" : 6.28E-147,
        "positive" : 305,
        "gaps" : 3,
        "Type" : "protein_coding",
        "bitscore" : 437.0,
        "slen" : 495,
        "mismatch" : 169,
        "name" : "KfCluster-13017.0",
        "send" : 495,
        "qcovs" : 59,
        "PrimarySymbol" : "STATE TRANSITION 8 (STN8)",
        "qend" : 195
      },
      "position" : {
        "x" : -240.36126708984375,
        "y" : -1781.43115234375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "18138",
        "degree_layout" : 1,
        "Description" : "",
        "SecondarySymbol" : "",
        "shared_name" : "SpCluster-4973.0",
        "SUID" : 18138,
        "selected" : false,
        "sseqid" : "",
        "Type" : "",
        "name" : "SpCluster-4973.0",
        "PrimarySymbol" : ""
      },
      "position" : {
        "x" : 474.69427490234375,
        "y" : -1802.7276611328125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16820",
        "degree_layout" : 13,
        "Description" : "Homocysteine S-methyltransferase family protein;(source:Araport11)",
        "SecondarySymbol" : "(ATHMT-1); (HMT-1)",
        "sstart" : 48,
        "qstart" : 1266,
        "qcovhsp" : 5,
        "shared_name" : "KfCluster-4339.0",
        "ppos" : 45.83,
        "score" : 222,
        "pident" : 27.431,
        "SUID" : 16820,
        "selected" : false,
        "sseqid" : "AT3G25900",
        "length" : 288,
        "nident" : 79,
        "evalue" : 7.8E-19,
        "positive" : 132,
        "gaps" : 35,
        "Type" : "protein_coding",
        "bitscore" : 90.1,
        "slen" : 326,
        "mismatch" : 174,
        "name" : "KfCluster-4339.0",
        "send" : 320,
        "qcovs" : 15,
        "PrimarySymbol" : "(HMT-1)",
        "qend" : 2069
      },
      "position" : {
        "x" : -453.70867919921875,
        "y" : -811.1616821289062
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16819",
        "degree_layout" : 4,
        "Description" : "ARM repeat superfamily protein;(source:Araport11)",
        "SecondarySymbol" : "(ATKPNB1);HOMOLOG OF HUMAN KPNB1 (KPNB1)",
        "sstart" : 1,
        "qstart" : 354,
        "qcovhsp" : 29,
        "shared_name" : "KfCluster-17431.0",
        "ppos" : 79.39,
        "score" : 2762,
        "pident" : 64.547,
        "SUID" : 16819,
        "selected" : false,
        "sseqid" : "AT5G53480",
        "length" : 849,
        "nident" : 548,
        "evalue" : 0.0,
        "positive" : 674,
        "gaps" : 13,
        "Type" : "protein_coding",
        "bitscore" : 1068.0,
        "slen" : 870,
        "mismatch" : 288,
        "name" : "KfCluster-17431.0",
        "send" : 841,
        "qcovs" : 88,
        "PrimarySymbol" : "HOMOLOG OF HUMAN KPNB1 (KPNB1)",
        "qend" : 2885
      },
      "position" : {
        "x" : -313.3515930175781,
        "y" : -1006.52734375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16818",
        "degree_layout" : 5,
        "Description" : "TRN1 is an importin beta protein that functions as a nuclear import receptor for AtGRP7 and in interacts with AGO1 to affect miRNA loading.",
        "SecondarySymbol" : "TRANSPORTIN 1 (ATTRN1);TRANSPORTIN 1 (TRN1)",
        "sstart" : 8,
        "qstart" : 3300,
        "qcovhsp" : 23,
        "shared_name" : "KfCluster-8207.0",
        "ppos" : 76.3,
        "score" : 2621,
        "pident" : 57.562,
        "SUID" : 16818,
        "selected" : false,
        "sseqid" : "AT2G16950",
        "length" : 886,
        "nident" : 510,
        "evalue" : 0.0,
        "positive" : 676,
        "gaps" : 9,
        "Type" : "protein_coding",
        "bitscore" : 1014.0,
        "slen" : 891,
        "mismatch" : 367,
        "name" : "KfCluster-8207.0",
        "send" : 886,
        "qcovs" : 70,
        "PrimarySymbol" : "TRANSPORTIN 1 (TRN1)",
        "qend" : 649
      },
      "position" : {
        "x" : -325.726806640625,
        "y" : -891.9680786132812
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16817",
        "degree_layout" : 9,
        "Description" : "\"Represents a homolog of the yeast MDN gene, which encodes a non-ribosomal protein involved in the maturation and assembly of the 60S ribosomal subunit. In Arabidopsis, it is essential for female gametogenesis progression.\"",
        "SecondarySymbol" : "(ATMDN1);MIDASIN 1 (MDN1)",
        "sstart" : 1736,
        "qstart" : 10078,
        "qcovhsp" : 4,
        "shared_name" : "KfCluster-4307.0",
        "ppos" : 66.44,
        "score" : 1210,
        "pident" : 51.247,
        "SUID" : 16817,
        "selected" : false,
        "sseqid" : "AT1G67120",
        "length" : 441,
        "nident" : 226,
        "evalue" : 2.13E-132,
        "positive" : 293,
        "gaps" : 14,
        "Type" : "protein_coding",
        "bitscore" : 470.0,
        "slen" : 5393,
        "mismatch" : 201,
        "name" : "KfCluster-4307.0",
        "send" : 2162,
        "qcovs" : 13,
        "PrimarySymbol" : "MIDASIN 1 (MDN1)",
        "qend" : 8756
      },
      "position" : {
        "x" : -379.9011535644531,
        "y" : -909.7162475585938
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16816",
        "degree_layout" : 5,
        "Description" : "\"Encodes an importin that transports HYL1, a component of the microprocessor, from the cytoplasm to the nucleus to constitute functional microprocessor, thereby affecting miRNA processing. Knockdown amiR mutants significantly reduced nuclear portion of HYL1 protein and correspondingly compromised the pri-miRNA processing in the nucleus.\"",
        "SecondarySymbol" : "(KARYOPHERIN ENABLING THE TRANSPORT OF THE  CYTOPLASMIC HYL1 (KETCH1);EMBRYO DEFECTIVE 2734 (emb2734)",
        "sstart" : 25,
        "qstart" : 3623,
        "qcovhsp" : 27,
        "shared_name" : "KfCluster-12575.0",
        "ppos" : 77.99,
        "score" : 3273,
        "pident" : 60.167,
        "SUID" : 16816,
        "selected" : false,
        "sseqid" : "AT5G19820",
        "length" : 1077,
        "nident" : 648,
        "evalue" : 0.0,
        "positive" : 840,
        "gaps" : 6,
        "Type" : "protein_coding",
        "bitscore" : 1265.0,
        "slen" : 1116,
        "mismatch" : 423,
        "name" : "KfCluster-12575.0",
        "send" : 1100,
        "qcovs" : 82,
        "PrimarySymbol" : "(KARYOPHERIN ENABLING THE TRANSPORT OF THE  CYTOPLASMIC HYL1 (KETCH1)",
        "qend" : 408
      },
      "position" : {
        "x" : -162.36228942871094,
        "y" : -797.7938232421875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16815",
        "degree_layout" : 9,
        "Description" : "\"Encodes carbamoyl phosphate synthetase (CPS) large subunit (CARB), also named as VEN3. Heterologous expression of the Arabidopsis VEN3 and VEN6 genes in a CPS-deficient Escherichia coli strain fully restored bacterial growth in minimal medium, demonstrating the enzymatic activity of the VEN3 and VEN6 proteins.\"",
        "SecondarySymbol" : "CARBAMOYL PHOSPHATE SYNTHETASE B (CARB);VENOSA 3 (VEN3);CELLULOSE SYNTHASE LIKE B6 (CLSB6)",
        "sstart" : 348,
        "qstart" : 3,
        "qcovhsp" : 27,
        "shared_name" : "KfCluster-3774.0",
        "ppos" : 82.72,
        "score" : 3154,
        "pident" : 71.752,
        "SUID" : 16815,
        "selected" : false,
        "sseqid" : "AT1G29900",
        "length" : 839,
        "nident" : 602,
        "evalue" : 0.0,
        "positive" : 694,
        "gaps" : 1,
        "Type" : "protein_coding",
        "bitscore" : 1219.0,
        "slen" : 1187,
        "mismatch" : 236,
        "name" : "KfCluster-3774.0",
        "send" : 1185,
        "qcovs" : 82,
        "PrimarySymbol" : "CARBAMOYL PHOSPHATE SYNTHETASE B (CARB)",
        "qend" : 2519
      },
      "position" : {
        "x" : -431.7755126953125,
        "y" : -1041.4833984375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16814",
        "degree_layout" : 10,
        "Description" : "\"Chloroplastic enzyme responsible for the synthesis of 16:2 and 18:2 fatty acids from galactolipids, sulpholipids and phosphatidylglycerol. Uses ferredoxin as electron donor. Gene mutation resulted in reduced level of unsaturated fatty acids leading to susceptibility to photoinhibition.\"",
        "SecondarySymbol" : "FATTY ACID DESATURASE 6 (FAD6);STEAROYL DESATURASE DEFICIENCY 4 (SFD4);FATTY ACID DESATURASE C (FADC)",
        "sstart" : 164,
        "qstart" : 1320,
        "qcovhsp" : 20,
        "shared_name" : "KfCluster-21221.0",
        "ppos" : 74.35,
        "score" : 805,
        "pident" : 56.877,
        "SUID" : 16814,
        "selected" : false,
        "sseqid" : "AT4G30950",
        "length" : 269,
        "nident" : 153,
        "evalue" : 2.45E-103,
        "positive" : 200,
        "gaps" : 4,
        "Type" : "protein_coding",
        "bitscore" : 314.0,
        "slen" : 448,
        "mismatch" : 112,
        "name" : "KfCluster-21221.0",
        "send" : 429,
        "qcovs" : 61,
        "PrimarySymbol" : "FATTY ACID DESATURASE 6 (FAD6)",
        "qend" : 517
      },
      "position" : {
        "x" : -934.1109619140625,
        "y" : -894.33203125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16813",
        "degree_layout" : 9,
        "Description" : "\"Encodes the cytosolic minor isoform of nitrate reductase (NR). Involved in the first step of nitrate assimilation, it contributes about 15% of the nitrate reductase activity in shoots. Similar to molybdopterin oxidoreductases at the N-terminus, and to FAD/NAD-binding cytochrome reductases at the C-terminus. Cofactors: FAD, heme iron (cytochrome B-557), and molybdenum-pterin.\"",
        "SecondarySymbol" : "NITRATE REDUCTASE 1 (NIA1);NITRATE REDUCTASE 1 (NR1); (GNR1)",
        "sstart" : 99,
        "qstart" : 773,
        "qcovhsp" : 23,
        "shared_name" : "KfCluster-17137.0",
        "ppos" : 73.5,
        "score" : 2533,
        "pident" : 56.41,
        "SUID" : 16813,
        "selected" : false,
        "sseqid" : "AT1G77760",
        "length" : 819,
        "nident" : 462,
        "evalue" : 0.0,
        "positive" : 602,
        "gaps" : 13,
        "Type" : "protein_coding",
        "bitscore" : 980.0,
        "slen" : 917,
        "mismatch" : 344,
        "name" : "KfCluster-17137.0",
        "send" : 908,
        "qcovs" : 68,
        "PrimarySymbol" : "NITRATE REDUCTASE 1 (NIA1)",
        "qend" : 3217
      },
      "position" : {
        "x" : -819.7564697265625,
        "y" : -1347.027099609375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16812",
        "degree_layout" : 12,
        "Description" : "\"Chloroplastic enzyme responsible for the synthesis of 16:2 and 18:2 fatty acids from galactolipids, sulpholipids and phosphatidylglycerol. Uses ferredoxin as electron donor. Gene mutation resulted in reduced level of unsaturated fatty acids leading to susceptibility to photoinhibition.\"",
        "SecondarySymbol" : "FATTY ACID DESATURASE 6 (FAD6);STEAROYL DESATURASE DEFICIENCY 4 (SFD4);FATTY ACID DESATURASE C (FADC)",
        "sstart" : 260,
        "qstart" : 928,
        "qcovhsp" : 7,
        "shared_name" : "KfCluster-17050.0",
        "ppos" : 83.24,
        "score" : 657,
        "pident" : 70.52,
        "SUID" : 16812,
        "selected" : false,
        "sseqid" : "AT4G30950",
        "length" : 173,
        "nident" : 122,
        "evalue" : 3.59E-77,
        "positive" : 144,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 257.0,
        "slen" : 448,
        "mismatch" : 51,
        "name" : "KfCluster-17050.0",
        "send" : 432,
        "qcovs" : 21,
        "PrimarySymbol" : "FATTY ACID DESATURASE 6 (FAD6)",
        "qend" : 410
      },
      "position" : {
        "x" : -1007.18701171875,
        "y" : -890.6159057617188
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16811",
        "degree_layout" : 6,
        "Description" : "Fatty acid/sphingolipid desaturase;(source:Araport11)",
        "SecondarySymbol" : "(ATSLD2);SPHINGOID LCB DESATURASE 2 (SLD2)",
        "sstart" : 5,
        "qstart" : 608,
        "qcovhsp" : 18,
        "shared_name" : "KfCluster-12470.0",
        "ppos" : 65.26,
        "score" : 1086,
        "pident" : 46.325,
        "SUID" : 16811,
        "selected" : false,
        "sseqid" : "AT2G46210",
        "length" : 449,
        "nident" : 208,
        "evalue" : 6.14E-140,
        "positive" : 293,
        "gaps" : 4,
        "Type" : "protein_coding",
        "bitscore" : 422.0,
        "slen" : 449,
        "mismatch" : 237,
        "name" : "KfCluster-12470.0",
        "send" : 449,
        "qcovs" : 53,
        "PrimarySymbol" : "SPHINGOID LCB DESATURASE 2 (SLD2)",
        "qend" : 1954
      },
      "position" : {
        "x" : -910.7536010742188,
        "y" : -1060.03564453125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17763",
        "degree_layout" : 2,
        "Description" : "proline-rich spliceosome-associated (PSP) family protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 90,
        "qstart" : 314,
        "qcovhsp" : 22,
        "shared_name" : "SpCluster-16584.0",
        "ppos" : 79.87,
        "score" : 1389,
        "pident" : 66.083,
        "SUID" : 17763,
        "selected" : false,
        "sseqid" : "AT4G21660",
        "length" : 457,
        "nident" : 302,
        "evalue" : 0.0,
        "positive" : 365,
        "gaps" : 23,
        "Type" : "protein_coding",
        "bitscore" : 539.0,
        "slen" : 584,
        "mismatch" : 132,
        "name" : "SpCluster-16584.0",
        "send" : 524,
        "qcovs" : 67,
        "PrimarySymbol" : "0",
        "qend" : 1681
      },
      "position" : {
        "x" : 250.85003662109375,
        "y" : -777.9998779296875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17762",
        "degree_layout" : 3,
        "Description" : "proline-rich spliceosome-associated (PSP) family protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 63,
        "qstart" : 2288,
        "qcovhsp" : 17,
        "shared_name" : "PpCluster-23258.0",
        "ppos" : 79.76,
        "score" : 1481,
        "pident" : 66.733,
        "SUID" : 17762,
        "selected" : false,
        "sseqid" : "AT4G21660",
        "length" : 499,
        "nident" : 333,
        "evalue" : 0.0,
        "positive" : 398,
        "gaps" : 16,
        "Type" : "protein_coding",
        "bitscore" : 575.0,
        "slen" : 598,
        "mismatch" : 150,
        "name" : "PpCluster-23258.0",
        "send" : 552,
        "qcovs" : 52,
        "PrimarySymbol" : "0",
        "qend" : 813
      },
      "position" : {
        "x" : 208.94944763183594,
        "y" : -736.0016479492188
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17761",
        "degree_layout" : 4,
        "Description" : "\"Encodes a protein with ABA 8'-hydroxylase activity, involved in ABA catabolism. Member of the CYP707A gene family. CYP707A1 appears to play an important role in determining the ABA levels in dry seeds. Gene involved in postgermination growth. Overexpression of CYP707A1 leads to a decrease in ABA levels and a reduction in after-ripening period to break dormancy.\"",
        "SecondarySymbol" : "\"CYTOCHROME P450, FAMILY 707, SUBFAMILY A, POLYPEPTIDE 1 (CYP707A1)\"",
        "sstart" : 44,
        "qstart" : 232,
        "qcovhsp" : 14,
        "shared_name" : "PpCluster-26133.0",
        "ppos" : 51.34,
        "score" : 436,
        "pident" : 31.642,
        "SUID" : 17761,
        "selected" : false,
        "sseqid" : "AT4G19230",
        "length" : 335,
        "nident" : 106,
        "evalue" : 2.95E-46,
        "positive" : 172,
        "gaps" : 20,
        "Type" : "protein_coding",
        "bitscore" : 172.0,
        "slen" : 467,
        "mismatch" : 209,
        "name" : "PpCluster-26133.0",
        "send" : 358,
        "qcovs" : 41,
        "PrimarySymbol" : "\"CYTOCHROME P450, FAMILY 707, SUBFAMILY A, POLYPEPTIDE 1 (CYP707A1)\"",
        "qend" : 1236
      },
      "position" : {
        "x" : -820.5106201171875,
        "y" : -546.6836547851562
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16801",
        "degree_layout" : 4,
        "Description" : "Encodes a dual targeted lysyl-tRNA ligase that is found both in the mitochondrion and the chloroplast.  Plants mutated in this gene exhibit an ovule abortion phenotype.",
        "SecondarySymbol" : "ARABIDOPSIS THALIANA LYSYL-TRNA SYNTHETASE 2 (ATKRS-2);OVULE ABORTION 5 (OVA5)",
        "sstart" : 91,
        "qstart" : 1025,
        "qcovhsp" : 19,
        "shared_name" : "SpCluster-17781.0",
        "ppos" : 74.39,
        "score" : 1576,
        "pident" : 57.196,
        "SUID" : 16801,
        "selected" : false,
        "sseqid" : "AT3G13490",
        "length" : 535,
        "nident" : 306,
        "evalue" : 0.0,
        "positive" : 398,
        "gaps" : 30,
        "Type" : "protein_coding",
        "bitscore" : 611.0,
        "slen" : 602,
        "mismatch" : 199,
        "name" : "SpCluster-17781.0",
        "send" : 599,
        "qcovs" : 58,
        "PrimarySymbol" : "OVULE ABORTION 5 (OVA5)",
        "qend" : 2617
      },
      "position" : {
        "x" : 126.79461669921875,
        "y" : -753.6444091796875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16800",
        "degree_layout" : 3,
        "Description" : "Encodes a putative cytosolic asparaginyl-tRNA synthetase. The mRNA is cell-to-cell mobile.",
        "SecondarySymbol" : "(SYNC1); (SYNC1 ARATH);EMBRYO DEFECTIVE 2755 (EMB2755)",
        "sstart" : 291,
        "qstart" : 1102,
        "qcovhsp" : 12,
        "shared_name" : "KfCluster-12086.1",
        "ppos" : 88.65,
        "score" : 1092,
        "pident" : 76.596,
        "SUID" : 16800,
        "selected" : false,
        "sseqid" : "AT5G56680",
        "length" : 282,
        "nident" : 216,
        "evalue" : 2.11E-140,
        "positive" : 250,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 425.0,
        "slen" : 572,
        "mismatch" : 66,
        "name" : "KfCluster-12086.1",
        "send" : 572,
        "qcovs" : 37,
        "PrimarySymbol" : "(SYNC1)",
        "qend" : 1947
      },
      "position" : {
        "x" : 36.22356033325195,
        "y" : -623.963623046875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16797",
        "degree_layout" : 7,
        "Description" : "Encodes a cytoplasmic LAM domain containing protein that is involved in leaf senescence. The mRNA is cell-to-cell mobile.",
        "SecondarySymbol" : "(ATLARP1C);LA RELATED PROTEIN 1C (LARP1C)",
        "sstart" : 369,
        "qstart" : 1546,
        "qcovhsp" : 2,
        "shared_name" : "KfCluster-25944.0",
        "ppos" : 71.08,
        "score" : 248,
        "pident" : 49.398,
        "SUID" : 16797,
        "selected" : false,
        "sseqid" : "AT4G35890",
        "length" : 83,
        "nident" : 41,
        "evalue" : 1.76E-21,
        "positive" : 59,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 100.0,
        "slen" : 523,
        "mismatch" : 42,
        "name" : "KfCluster-25944.0",
        "send" : 451,
        "qcovs" : 7,
        "PrimarySymbol" : "LA RELATED PROTEIN 1C (LARP1C)",
        "qend" : 1298
      },
      "position" : {
        "x" : -250.30136108398438,
        "y" : -1221.8431396484375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17758",
        "degree_layout" : 4,
        "Description" : "Glutaredoxin family protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 77,
        "qstart" : 944,
        "qcovhsp" : 12,
        "shared_name" : "PpCluster-24338.0",
        "ppos" : 65.85,
        "score" : 399,
        "pident" : 46.951,
        "SUID" : 17758,
        "selected" : false,
        "sseqid" : "AT5G06470",
        "length" : 164,
        "nident" : 77,
        "evalue" : 1.02E-45,
        "positive" : 108,
        "gaps" : 10,
        "Type" : "protein_coding",
        "bitscore" : 158.0,
        "slen" : 239,
        "mismatch" : 77,
        "name" : "PpCluster-24338.0",
        "send" : 238,
        "qcovs" : 37,
        "PrimarySymbol" : "0",
        "qend" : 477
      },
      "position" : {
        "x" : 1017.33203125,
        "y" : -1785.8126220703125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16796",
        "degree_layout" : 5,
        "Description" : "\"Encodes carbamoyl phosphate synthetase (CPS) large subunit (CARB), also named as VEN3. Heterologous expression of the Arabidopsis VEN3 and VEN6 genes in a CPS-deficient Escherichia coli strain fully restored bacterial growth in minimal medium, demonstrating the enzymatic activity of the VEN3 and VEN6 proteins.\"",
        "SecondarySymbol" : "CARBAMOYL PHOSPHATE SYNTHETASE B (CARB);VENOSA 3 (VEN3);CELLULOSE SYNTHASE LIKE B6 (CLSB6)",
        "sstart" : 92,
        "qstart" : 791,
        "qcovhsp" : 20,
        "shared_name" : "KfCluster-13525.0",
        "ppos" : 94.68,
        "score" : 1212,
        "pident" : 84.411,
        "SUID" : 16796,
        "selected" : false,
        "sseqid" : "AT1G29900",
        "length" : 263,
        "nident" : 222,
        "evalue" : 8.61E-156,
        "positive" : 249,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 471.0,
        "slen" : 1187,
        "mismatch" : 41,
        "name" : "KfCluster-13525.0",
        "send" : 354,
        "qcovs" : 60,
        "PrimarySymbol" : "CARBAMOYL PHOSPHATE SYNTHETASE B (CARB)",
        "qend" : 3
      },
      "position" : {
        "x" : -363.4379577636719,
        "y" : -1170.20556640625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17757",
        "degree_layout" : 2,
        "Description" : "Glutaredoxin family protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 38,
        "qstart" : 840,
        "qcovhsp" : 2,
        "shared_name" : "PpCluster-22895.0",
        "ppos" : 52.94,
        "score" : 105,
        "pident" : 35.294,
        "SUID" : 17757,
        "selected" : false,
        "sseqid" : "AT2G41330",
        "length" : 85,
        "nident" : 30,
        "evalue" : 3.36E-4,
        "positive" : 45,
        "gaps" : 7,
        "Type" : "protein_coding",
        "bitscore" : 45.1,
        "slen" : 402,
        "mismatch" : 48,
        "name" : "PpCluster-22895.0",
        "send" : 120,
        "qcovs" : 5,
        "PrimarySymbol" : "0",
        "qend" : 1079
      },
      "position" : {
        "x" : 1150.025146484375,
        "y" : -1874.0155029296875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16795",
        "degree_layout" : 2,
        "Description" : "Encodes an Fe-S binding protein with quinolinate synthase (QS) activity and cysteine desulfurase activator activity. The QS activity was demonstrated by functional complementation of corresponding E. coli mutants and complementation of embryo-lethal phenotypes of the QS homozygous null allele in Arabidopsis. The SufE domain of the protein also stimulates the cysteine desulfurase activity of CpNifS (AT1G08490) in vitro. This protein binds a (4Fe-Su)2+ cluster in its NadA domain and is localized in the chloroplast.",
        "SecondarySymbol" : "SULFUR E 3 (SUFE3);ONSET OF LEAF DEATH 5 (OLD5);QUINOLINATE SYNTHASE (QS)",
        "sstart" : 86,
        "qstart" : 776,
        "qcovhsp" : 12,
        "shared_name" : "KfCluster-11913.0",
        "ppos" : 74.31,
        "score" : 1097,
        "pident" : 54.912,
        "SUID" : 16795,
        "selected" : false,
        "sseqid" : "AT5G50210",
        "length" : 397,
        "nident" : 218,
        "evalue" : 2.78E-135,
        "positive" : 295,
        "gaps" : 3,
        "Type" : "protein_coding",
        "bitscore" : 427.0,
        "slen" : 718,
        "mismatch" : 176,
        "name" : "KfCluster-11913.0",
        "send" : 480,
        "qcovs" : 35,
        "PrimarySymbol" : "QUINOLINATE SYNTHASE (QS)",
        "qend" : 1963
      },
      "position" : {
        "x" : -300.18511962890625,
        "y" : -1082.1732177734375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16792",
        "degree_layout" : 14,
        "Description" : "ILITHYIA (ILA) is a HEAT repeat protein involved in plant immunity. The gene is also involved in systemic acquired resistance induced by P. syringae expressing avrRps4. Loss-of-function mutants of ILA caused pleiotropic defects in the mutant plants. The mutant plants are smaller in size and the leaves are serrated and yellow to light green in color. Required for bacterium-triggered stomatal closure.",
        "SecondarySymbol" : "ILITHYIA (ILA)",
        "sstart" : 23,
        "qstart" : 181,
        "qcovhsp" : 32,
        "shared_name" : "KfCluster-22827.0",
        "ppos" : 70.3,
        "score" : 6283,
        "pident" : 52.294,
        "SUID" : 16792,
        "selected" : false,
        "sseqid" : "AT1G64790",
        "length" : 2616,
        "nident" : 1368,
        "evalue" : 0.0,
        "positive" : 1839,
        "gaps" : 61,
        "Type" : "protein_coding",
        "bitscore" : 2424.0,
        "slen" : 2610,
        "mismatch" : 1187,
        "name" : "KfCluster-22827.0",
        "send" : 2594,
        "qcovs" : 96,
        "PrimarySymbol" : "ILITHYIA (ILA)",
        "qend" : 7977
      },
      "position" : {
        "x" : -97.74774952373336,
        "y" : -537.3595847107896
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16791",
        "degree_layout" : 1,
        "Description" : "Encodes a gene whose sequence is similar to ferredoxin dependent glutamate synthase (Fd-GOGAT). Expression in leaves is induced by light and sucrose. Proposed to be involved in photorespiration and nitrogen assimilation. The mRNA is cell-to-cell mobile.",
        "SecondarySymbol" : "FERREDOXIN-DEPENDENT GLUTAMATE SYNTHASE (FD-GOGAT);GLUTAMATE SYNTHASE 1 (GLU1);FERREDOXIN-DEPENDENT GLUTAMATE SYNTHASE 1 (GLS1); (GLUS)",
        "sstart" : 811,
        "qstart" : 1571,
        "qcovhsp" : 33,
        "shared_name" : "KfCluster-10853.0",
        "ppos" : 89.29,
        "score" : 2312,
        "pident" : 81.262,
        "SUID" : 16791,
        "selected" : false,
        "sseqid" : "AT5G04140",
        "length" : 523,
        "nident" : 425,
        "evalue" : 0.0,
        "positive" : 467,
        "gaps" : 1,
        "Type" : "protein_coding",
        "bitscore" : 895.0,
        "slen" : 1648,
        "mismatch" : 97,
        "name" : "KfCluster-10853.0",
        "send" : 1332,
        "qcovs" : 99,
        "PrimarySymbol" : "GLUTAMATE SYNTHASE 1 (GLU1)",
        "qend" : 3
      },
      "position" : {
        "x" : 32.3770637512207,
        "y" : -522.6382446289062
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17755",
        "degree_layout" : 3,
        "Description" : "Encodes a protein involved in modification of nucleosides in tRNA. Mutants have 50% less 1-methylguanosine than wt counterparts.",
        "SecondarySymbol" : "(AtTRM);TRNA MODIFICATION 10 (TRM10)",
        "sstart" : 58,
        "qstart" : 1335,
        "qcovhsp" : 12,
        "shared_name" : "PpCluster-23625.0",
        "ppos" : 58.16,
        "score" : 579,
        "pident" : 45.035,
        "SUID" : 17755,
        "selected" : false,
        "sseqid" : "AT5G47680",
        "length" : 282,
        "nident" : 127,
        "evalue" : 8.63E-68,
        "positive" : 164,
        "gaps" : 49,
        "Type" : "protein_coding",
        "bitscore" : 227.0,
        "slen" : 344,
        "mismatch" : 106,
        "name" : "PpCluster-23625.0",
        "send" : 294,
        "qcovs" : 37,
        "PrimarySymbol" : "TRNA MODIFICATION 10 (TRM10)",
        "qend" : 502
      },
      "position" : {
        "x" : 1423.254576891729,
        "y" : -454.0160529910837
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16790",
        "degree_layout" : 2,
        "Description" : "ethylene-insensitive3-like1 (EIL1) The mRNA is cell-to-cell mobile.",
        "SecondarySymbol" : "(AtEIL1);ETHYLENE-INSENSITIVE3-LIKE 1 (EIL1)",
        "sstart" : 51,
        "qstart" : 2194,
        "qcovhsp" : 15,
        "shared_name" : "KfCluster-32186.0",
        "ppos" : 64.95,
        "score" : 705,
        "pident" : 52.32,
        "SUID" : 16790,
        "selected" : false,
        "sseqid" : "AT2G27050",
        "length" : 388,
        "nident" : 203,
        "evalue" : 2.7E-82,
        "positive" : 252,
        "gaps" : 9,
        "Type" : "protein_coding",
        "bitscore" : 276.0,
        "slen" : 584,
        "mismatch" : 176,
        "name" : "KfCluster-32186.0",
        "send" : 436,
        "qcovs" : 44,
        "PrimarySymbol" : "ETHYLENE-INSENSITIVE3-LIKE 1 (EIL1)",
        "qend" : 1052
      },
      "position" : {
        "x" : 2.4149703979492188,
        "y" : -971.1608276367188
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "18137",
        "degree_layout" : 14,
        "Description" : "",
        "SecondarySymbol" : "",
        "shared_name" : "SpCluster-9338.0",
        "SUID" : 18137,
        "selected" : false,
        "sseqid" : "",
        "Type" : "",
        "name" : "SpCluster-9338.0",
        "PrimarySymbol" : ""
      },
      "position" : {
        "x" : 193.7345733642578,
        "y" : -1422.6195068359375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17754",
        "degree_layout" : 2,
        "Description" : "Encodes a ARID-HMG DNA-binding protein that functions in pollen tube growth through the regulation of gene expression by interacting with the transcription factors AGL66 and AGL104.",
        "SecondarySymbol" : "ARID-HMG DNA-BINDING PROTEIN 15 (AtHMGB15);ARID-HMG DNA-BINDING PROTEIN 15 (HMGBD15)",
        "sstart" : 25,
        "qstart" : 2062,
        "qcovhsp" : 10,
        "shared_name" : "PpCluster-22808.0",
        "ppos" : 56.87,
        "score" : 580,
        "pident" : 37.637,
        "SUID" : 17754,
        "selected" : false,
        "sseqid" : "AT1G04880",
        "length" : 364,
        "nident" : 137,
        "evalue" : 3.67E-65,
        "positive" : 207,
        "gaps" : 67,
        "Type" : "protein_coding",
        "bitscore" : 228.0,
        "slen" : 448,
        "mismatch" : 160,
        "name" : "PpCluster-22808.0",
        "send" : 338,
        "qcovs" : 31,
        "PrimarySymbol" : "ARID-HMG DNA-BINDING PROTEIN 15 (HMGBD15)",
        "qend" : 1022
      },
      "position" : {
        "x" : 1525.129456311396,
        "y" : -363.16387939453125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16789",
        "degree_layout" : 2,
        "Description" : "\"Encodes a lipase that hydrolyzes phosphatidylcholine, glycolipids as well as triacylglycerols.\"",
        "SecondarySymbol" : "DAD1-LIKE LIPASE 3 (DALL3)",
        "sstart" : 237,
        "qstart" : 3697,
        "qcovhsp" : 1,
        "shared_name" : "KfCluster-10704.0",
        "ppos" : 50.91,
        "score" : 76,
        "pident" : 32.727,
        "SUID" : 16789,
        "selected" : false,
        "sseqid" : "AT2G30550",
        "length" : 55,
        "nident" : 18,
        "evalue" : 1.4,
        "positive" : 28,
        "gaps" : 6,
        "Type" : "protein_coding",
        "bitscore" : 33.9,
        "slen" : 464,
        "mismatch" : 31,
        "name" : "KfCluster-10704.0",
        "send" : 285,
        "qcovs" : 3,
        "PrimarySymbol" : "DAD1-LIKE LIPASE 3 (DALL3)",
        "qend" : 3533
      },
      "position" : {
        "x" : -75.97244262695312,
        "y" : -1109.0147705078125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16788",
        "degree_layout" : 24,
        "Description" : "Encodes a nuclear localized splicing factor homolog that is involved in alternative splicing of some mRNAs.",
        "SecondarySymbol" : "ARABIDOPSIS SF1 HOMOLOG (ATSF1)",
        "sstart" : 86,
        "qstart" : 436,
        "qcovhsp" : 15,
        "shared_name" : "SpCluster-19190.0",
        "ppos" : 73.54,
        "score" : 1453,
        "pident" : 61.479,
        "SUID" : 16788,
        "selected" : false,
        "sseqid" : "AT5G51300",
        "length" : 514,
        "nident" : 316,
        "evalue" : 0.0,
        "positive" : 378,
        "gaps" : 46,
        "Type" : "protein_coding",
        "bitscore" : 564.0,
        "slen" : 804,
        "mismatch" : 152,
        "name" : "SpCluster-19190.0",
        "send" : 558,
        "qcovs" : 46,
        "PrimarySymbol" : "ARABIDOPSIS SF1 HOMOLOG (ATSF1)",
        "qend" : 1962
      },
      "position" : {
        "x" : -1439.2276611328125,
        "y" : -977.3162841796875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16787",
        "degree_layout" : 4,
        "Description" : "RNA-binding (RRM/RBD/RNP motifs) family protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 61,
        "qstart" : 1532,
        "qcovhsp" : 2,
        "shared_name" : "KfCluster-10633.0",
        "ppos" : 88.37,
        "score" : 184,
        "pident" : 69.767,
        "SUID" : 16787,
        "selected" : false,
        "sseqid" : "AT5G04600",
        "length" : 43,
        "nident" : 30,
        "evalue" : 2.97E-15,
        "positive" : 38,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 75.5,
        "slen" : 222,
        "mismatch" : 13,
        "name" : "KfCluster-10633.0",
        "send" : 103,
        "qcovs" : 6,
        "PrimarySymbol" : "0",
        "qend" : 1404
      },
      "position" : {
        "x" : -1538.6534423828125,
        "y" : -1083.903564453125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16786",
        "degree_layout" : 6,
        "Description" : "\"Encodes a subunit of eukaryotic initiation factor 3 (eIF3), a multisubunit complex that is required for binding of mRNA to 40 S ribosomal subunits, stabilization of ternary complex binding to 40 S subunits, and dissociation of 40 and 60 S subunits.\"",
        "SecondarySymbol" : "EUKARYOTIC TRANSLATION INITIATION FACTOR 3A (EIF3A); (ATEIF3A-1); (TIF3A1); (ATTIF3A1); (EIF3A-1)",
        "sstart" : 1,
        "qstart" : 235,
        "qcovhsp" : 24,
        "shared_name" : "KfCluster-16773.0",
        "ppos" : 75.29,
        "score" : 2081,
        "pident" : 58.301,
        "SUID" : 16786,
        "selected" : false,
        "sseqid" : "AT4G11420",
        "length" : 765,
        "nident" : 446,
        "evalue" : 0.0,
        "positive" : 576,
        "gaps" : 11,
        "Type" : "protein_coding",
        "bitscore" : 806.0,
        "slen" : 987,
        "mismatch" : 308,
        "name" : "KfCluster-16773.0",
        "send" : 758,
        "qcovs" : 71,
        "PrimarySymbol" : "EUKARYOTIC TRANSLATION INITIATION FACTOR 3A (EIF3A)",
        "qend" : 2517
      },
      "position" : {
        "x" : -244.29855346679688,
        "y" : -1153.23876953125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16785",
        "degree_layout" : 2,
        "Description" : "encodes 3-phosphoshikimate 1-carboxyvinyltransferase / 5-enolpyruvylshikimate-3-phosphate / EPSP synthase involved in chorismate biosynthesis The mRNA is cell-to-cell mobile.",
        "SecondarySymbol" : "0",
        "sstart" : 85,
        "qstart" : 540,
        "qcovhsp" : 20,
        "shared_name" : "KfCluster-10540.0",
        "ppos" : 78.05,
        "score" : 1364,
        "pident" : 67.873,
        "SUID" : 16785,
        "selected" : false,
        "sseqid" : "AT2G45300",
        "length" : 442,
        "nident" : 300,
        "evalue" : 0.0,
        "positive" : 345,
        "gaps" : 6,
        "Type" : "protein_coding",
        "bitscore" : 530.0,
        "slen" : 520,
        "mismatch" : 136,
        "name" : "KfCluster-10540.0",
        "send" : 520,
        "qcovs" : 59,
        "PrimarySymbol" : "0",
        "qend" : 1865
      },
      "position" : {
        "x" : -354.63494873046875,
        "y" : -1047.2161865234375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17753",
        "degree_layout" : 3,
        "Description" : "Auxin receptor involved in primary and lateral root growth inhibition in response to nitrate. Target of miR393. Induced by nitrate in primary roots.",
        "SecondarySymbol" : "AUXIN SIGNALING F-BOX 3 (AFB3)",
        "sstart" : 4,
        "qstart" : 1093,
        "qcovhsp" : 17,
        "shared_name" : "PpCluster-22752.1",
        "ppos" : 68.98,
        "score" : 1615,
        "pident" : 54.073,
        "SUID" : 17753,
        "selected" : false,
        "sseqid" : "AT1G12820",
        "length" : 577,
        "nident" : 312,
        "evalue" : 0.0,
        "positive" : 398,
        "gaps" : 15,
        "Type" : "protein_coding",
        "bitscore" : 626.0,
        "slen" : 577,
        "mismatch" : 250,
        "name" : "PpCluster-22752.1",
        "send" : 577,
        "qcovs" : 50,
        "PrimarySymbol" : "AUXIN SIGNALING F-BOX 3 (AFB3)",
        "qend" : 2787
      },
      "position" : {
        "x" : 1167.1341552734375,
        "y" : -1768.01123046875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16784",
        "degree_layout" : 14,
        "Description" : "starch synthase 4;(source:Araport11)",
        "SecondarySymbol" : "ARABIDOPSIS THALIANA STARCH SYNTHASE 4 (ATSS4);STARCH SYNTHASE 4 (SSIV);STARCH SYNTHASE 4 (SS4)",
        "sstart" : 542,
        "qstart" : 1708,
        "qcovhsp" : 19,
        "shared_name" : "SpCluster-3535.0",
        "ppos" : 62.74,
        "score" : 1148,
        "pident" : 45.174,
        "SUID" : 16784,
        "selected" : false,
        "sseqid" : "AT4G18240",
        "length" : 518,
        "nident" : 234,
        "evalue" : 1.56E-141,
        "positive" : 325,
        "gaps" : 35,
        "Type" : "protein_coding",
        "bitscore" : 446.0,
        "slen" : 1040,
        "mismatch" : 249,
        "name" : "SpCluster-3535.0",
        "send" : 1032,
        "qcovs" : 57,
        "PrimarySymbol" : "STARCH SYNTHASE 4 (SS4)",
        "qend" : 179
      },
      "position" : {
        "x" : -721.290283203125,
        "y" : -1482.0404052734375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16783",
        "degree_layout" : 14,
        "Description" : "starch synthase 2;(source:Araport11)",
        "SecondarySymbol" : "STARCH SYNTHASE 2 (SS2);STARCH SYNTHASE 2 (AtSS2)",
        "sstart" : 295,
        "qstart" : 1287,
        "qcovhsp" : 17,
        "shared_name" : "SpCluster-2253.0",
        "ppos" : 82.77,
        "score" : 2005,
        "pident" : 71.343,
        "SUID" : 16783,
        "selected" : false,
        "sseqid" : "AT3G01180",
        "length" : 499,
        "nident" : 356,
        "evalue" : 0.0,
        "positive" : 413,
        "gaps" : 2,
        "Type" : "protein_coding",
        "bitscore" : 776.0,
        "slen" : 792,
        "mismatch" : 141,
        "name" : "SpCluster-2253.0",
        "send" : 792,
        "qcovs" : 51,
        "PrimarySymbol" : "STARCH SYNTHASE 2 (SS2)",
        "qend" : 2780
      },
      "position" : {
        "x" : -613.6467895507812,
        "y" : -1518.2213134765625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16782",
        "degree_layout" : 12,
        "Description" : "UDP-Glycosyltransferase superfamily protein;(source:Araport11)",
        "SecondarySymbol" : "GRANULE BOUND STARCH SYNTHASE 1 (GBSS1)",
        "sstart" : 436,
        "qstart" : 754,
        "qcovhsp" : 21,
        "shared_name" : "SpCluster-13746.1",
        "ppos" : 80.5,
        "score" : 613,
        "pident" : 69.182,
        "SUID" : 16782,
        "selected" : false,
        "sseqid" : "AT1G32900",
        "length" : 159,
        "nident" : 110,
        "evalue" : 1.24E-75,
        "positive" : 128,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 240.0,
        "slen" : 610,
        "mismatch" : 49,
        "name" : "SpCluster-13746.1",
        "send" : 594,
        "qcovs" : 63,
        "PrimarySymbol" : "GRANULE BOUND STARCH SYNTHASE 1 (GBSS1)",
        "qend" : 278
      },
      "position" : {
        "x" : -681.2659912109375,
        "y" : -1429.777099609375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16781",
        "degree_layout" : 12,
        "Description" : "starch synthase 4;(source:Araport11)",
        "SecondarySymbol" : "ARABIDOPSIS THALIANA STARCH SYNTHASE 4 (ATSS4);STARCH SYNTHASE 4 (SSIV);STARCH SYNTHASE 4 (SS4)",
        "sstart" : 577,
        "qstart" : 2044,
        "qcovhsp" : 14,
        "shared_name" : "PpCluster-26332.0",
        "ppos" : 65.16,
        "score" : 760,
        "pident" : 49.477,
        "SUID" : 16781,
        "selected" : false,
        "sseqid" : "AT4G18240",
        "length" : 287,
        "nident" : 142,
        "evalue" : 5.24E-88,
        "positive" : 187,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 297.0,
        "slen" : 1040,
        "mismatch" : 145,
        "name" : "PpCluster-26332.0",
        "send" : 863,
        "qcovs" : 42,
        "PrimarySymbol" : "STARCH SYNTHASE 4 (SS4)",
        "qend" : 1184
      },
      "position" : {
        "x" : -649.0145263671875,
        "y" : -1433.2181396484375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17749",
        "degree_layout" : 2,
        "Description" : "\"Helicase/SANT-associated, DNA binding protein;(source:Araport11)\"",
        "SecondarySymbol" : "(ATEAF1B)",
        "sstart" : 1016,
        "qstart" : 3672,
        "qcovhsp" : 5,
        "shared_name" : "PpCluster-5932.1",
        "ppos" : 49.46,
        "score" : 366,
        "pident" : 34.783,
        "SUID" : 17749,
        "selected" : false,
        "sseqid" : "AT3G24870",
        "length" : 368,
        "nident" : 128,
        "evalue" : 2.64E-34,
        "positive" : 182,
        "gaps" : 35,
        "Type" : "protein_coding",
        "bitscore" : 145.0,
        "slen" : 1899,
        "mismatch" : 205,
        "name" : "PpCluster-5932.1",
        "send" : 1363,
        "qcovs" : 15,
        "PrimarySymbol" : "(ATEAF1B)",
        "qend" : 2614
      },
      "position" : {
        "x" : -489.589599609375,
        "y" : -538.3632202148438
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16780",
        "degree_layout" : 14,
        "Description" : "SSI is a plastidial enzyme and crucial for the synthesis of normal amylopectin in the leaves of Arabidopsis. The absence of SSI results in a deficiency in the number of shorter glucans which in turn affect the formation and connection of the amylopectin clusters in starch.",
        "SecondarySymbol" : "SUPPRESSOR OF SALICYLIC ACID INSENSITIVITY 1 (SSI1);SUPPRESSOR OF SALICYLIC ACID INSENSITIVE (SSI);STARCH SYNTHASE 1 (SS1);STARCH SYNTHASE 1 (ATSS1)",
        "sstart" : 135,
        "qstart" : 1986,
        "qcovhsp" : 19,
        "shared_name" : "KfCluster-2570.0",
        "ppos" : 82.59,
        "score" : 2031,
        "pident" : 70.6,
        "SUID" : 16780,
        "selected" : false,
        "sseqid" : "AT5G24300",
        "length" : 517,
        "nident" : 365,
        "evalue" : 0.0,
        "positive" : 427,
        "gaps" : 1,
        "Type" : "protein_coding",
        "bitscore" : 786.0,
        "slen" : 652,
        "mismatch" : 151,
        "name" : "KfCluster-2570.0",
        "send" : 651,
        "qcovs" : 56,
        "PrimarySymbol" : "STARCH SYNTHASE 1 (SS1)",
        "qend" : 439
      },
      "position" : {
        "x" : -595.221923828125,
        "y" : -1471.6646728515625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16779",
        "degree_layout" : 21,
        "Description" : "starch synthase 4;(source:Araport11)",
        "SecondarySymbol" : "ARABIDOPSIS THALIANA STARCH SYNTHASE 4 (ATSS4);STARCH SYNTHASE 4 (SSIV);STARCH SYNTHASE 4 (SS4)",
        "sstart" : 539,
        "qstart" : 1694,
        "qcovhsp" : 24,
        "shared_name" : "KfCluster-22823.0",
        "ppos" : 64.05,
        "score" : 1196,
        "pident" : 46.758,
        "SUID" : 16779,
        "selected" : false,
        "sseqid" : "AT4G18240",
        "length" : 509,
        "nident" : 238,
        "evalue" : 4.78E-151,
        "positive" : 326,
        "gaps" : 28,
        "Type" : "protein_coding",
        "bitscore" : 465.0,
        "slen" : 1040,
        "mismatch" : 243,
        "name" : "KfCluster-22823.0",
        "send" : 1027,
        "qcovs" : 72,
        "PrimarySymbol" : "STARCH SYNTHASE 4 (SS4)",
        "qend" : 192
      },
      "position" : {
        "x" : -628.2880859375,
        "y" : -1579.49951171875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "18136",
        "degree_layout" : 2,
        "Description" : "late embryogenesis abundant protein-related / LEA protein-like protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 296,
        "qstart" : 1332,
        "qcovhsp" : 10,
        "shared_name" : "SpCluster-9157.0",
        "ppos" : 43.3,
        "score" : 197,
        "pident" : 27.586,
        "SUID" : 18136,
        "selected" : false,
        "sseqid" : "AT3G19430",
        "length" : 261,
        "nident" : 72,
        "evalue" : 1.85E-15,
        "positive" : 113,
        "gaps" : 38,
        "Type" : "protein_coding",
        "bitscore" : 80.5,
        "slen" : 559,
        "mismatch" : 151,
        "name" : "SpCluster-9157.0",
        "send" : 526,
        "qcovs" : 30,
        "PrimarySymbol" : "0",
        "qend" : 2090
      },
      "position" : {
        "x" : 254.41372680664062,
        "y" : -1800.6402587890625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17748",
        "degree_layout" : 4,
        "Description" : "encodes a ubiquitin-protein ligase containing a HECT domain. There are six other HECT-domain UPLs in Arabidopsis.",
        "SecondarySymbol" : "UBIQUITIN-PROTEIN LIGASE 7 (UPL7)",
        "sstart" : 600,
        "qstart" : 3704,
        "qcovhsp" : 8,
        "shared_name" : "PpCluster-22597.1",
        "ppos" : 74.3,
        "score" : 1617,
        "pident" : 59.163,
        "SUID" : 17748,
        "selected" : false,
        "sseqid" : "AT3G53090",
        "length" : 502,
        "nident" : 297,
        "evalue" : 0.0,
        "positive" : 373,
        "gaps" : 5,
        "Type" : "protein_coding",
        "bitscore" : 627.0,
        "slen" : 1142,
        "mismatch" : 200,
        "name" : "PpCluster-22597.1",
        "send" : 1097,
        "qcovs" : 23,
        "PrimarySymbol" : "UBIQUITIN-PROTEIN LIGASE 7 (UPL7)",
        "qend" : 5206
      },
      "position" : {
        "x" : -202.6574249267578,
        "y" : -2078.4755859375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16778",
        "degree_layout" : 21,
        "Description" : "Encodes a starch synthase that in addition to its role in starch biosynthesis also has a negative regulatory function in the biosynthesis of transient starch. The protein apparently contains a starch-binding domain (SBD).",
        "SecondarySymbol" : "STARCH SYNTHASE 3 (SS3)",
        "sstart" : 193,
        "qstart" : 3306,
        "qcovhsp" : 20,
        "shared_name" : "KfCluster-12505.0",
        "ppos" : 69.65,
        "score" : 2288,
        "pident" : 52.539,
        "SUID" : 16778,
        "selected" : false,
        "sseqid" : "AT1G11720",
        "length" : 906,
        "nident" : 476,
        "evalue" : 0.0,
        "positive" : 631,
        "gaps" : 9,
        "Type" : "protein_coding",
        "bitscore" : 885.0,
        "slen" : 1094,
        "mismatch" : 421,
        "name" : "KfCluster-12505.0",
        "send" : 1094,
        "qcovs" : 61,
        "PrimarySymbol" : "STARCH SYNTHASE 3 (SS3)",
        "qend" : 604
      },
      "position" : {
        "x" : -541.6890869140625,
        "y" : -1384.388916015625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16777",
        "degree_layout" : 14,
        "Description" : "UDP-Glycosyltransferase superfamily protein;(source:Araport11)",
        "SecondarySymbol" : "GRANULE BOUND STARCH SYNTHASE 1 (GBSS1)",
        "sstart" : 76,
        "qstart" : 549,
        "qcovhsp" : 19,
        "shared_name" : "KfCluster-10331.0",
        "ppos" : 78.69,
        "score" : 1865,
        "pident" : 67.477,
        "SUID" : 16777,
        "selected" : false,
        "sseqid" : "AT1G32900",
        "length" : 535,
        "nident" : 361,
        "evalue" : 0.0,
        "positive" : 421,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 723.0,
        "slen" : 610,
        "mismatch" : 174,
        "name" : "KfCluster-10331.0",
        "send" : 610,
        "qcovs" : 57,
        "PrimarySymbol" : "GRANULE BOUND STARCH SYNTHASE 1 (GBSS1)",
        "qend" : 2153
      },
      "position" : {
        "x" : -675.0431518554688,
        "y" : -1510.8377685546875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16776",
        "degree_layout" : 3,
        "Description" : "\"encodes high molecular weight heat shock protein 70 not a HSP90 homolog, mRNA is constitutively expressed but transiently induced after heat shock\"",
        "SecondarySymbol" : "(AtHsp70-14);HEAT SHOCK PROTEIN 91 (HSP91)",
        "sstart" : 423,
        "qstart" : 1610,
        "qcovhsp" : 22,
        "shared_name" : "KfCluster-10055.0",
        "ppos" : 65.85,
        "score" : 706,
        "pident" : 47.268,
        "SUID" : 16776,
        "selected" : false,
        "sseqid" : "AT1G79930",
        "length" : 366,
        "nident" : 173,
        "evalue" : 2.28E-83,
        "positive" : 241,
        "gaps" : 9,
        "Type" : "protein_coding",
        "bitscore" : 276.0,
        "slen" : 831,
        "mismatch" : 184,
        "name" : "KfCluster-10055.0",
        "send" : 785,
        "qcovs" : 66,
        "PrimarySymbol" : "HEAT SHOCK PROTEIN 91 (HSP91)",
        "qend" : 531
      },
      "position" : {
        "x" : -671.9893188476562,
        "y" : -1329.9659423828125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16772",
        "Description" : "NADH-dependent glutamate synthase The mRNA is cell-to-cell mobile.",
        "SecondarySymbol" : "NADH-DEPENDENT GLUTAMATE SYNTHASE 1 (GLT1)",
        "sstart" : 1689,
        "qstart" : 1908,
        "qcovhsp" : 24,
        "shared_name" : "SpCluster-16251.1",
        "ppos" : 86.69,
        "score" : 1999,
        "pident" : 76.908,
        "SUID" : 16772,
        "selected" : false,
        "sseqid" : "AT5G53460",
        "length" : 511,
        "nident" : 393,
        "evalue" : 0.0,
        "positive" : 443,
        "gaps" : 5,
        "Type" : "protein_coding",
        "bitscore" : 774.0,
        "slen" : 2208,
        "mismatch" : 113,
        "name" : "SpCluster-16251.1",
        "send" : 2194,
        "qcovs" : 73,
        "PrimarySymbol" : "NADH-DEPENDENT GLUTAMATE SYNTHASE 1 (GLT1)",
        "qend" : 376
      },
      "position" : {
        "x" : -2205.415484918328,
        "y" : -2507.2314453125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16771",
        "degree_layout" : 11,
        "Description" : "glutathione S-conjugate transporting ATPase (AtMRP1) mRNA. An ABCC-type arsenite-phytochelatin transporter. The expression of this gene is upregulated by herbicide safeners such as benoxacor and fenclorim.",
        "SecondarySymbol" : "(EST1);ATP-BINDING CASSETTE C1 (ABCC1);ARABIDOPSIS THALIANA ATP-BINDING CASSETTE C1 (ATABCC1);MULTIDRUG RESISTANCE-ASSOCIATED PROTEIN 1 (MRP1);ARABIDOPSIS THALIANA MULTIDRUG RESISTANCE-ASSOCIATED PROTEIN 1 (ATMRP1)",
        "sstart" : 1402,
        "qstart" : 399,
        "qcovhsp" : 22,
        "shared_name" : "SpCluster-2687.0",
        "ppos" : 69.77,
        "score" : 211,
        "pident" : 48.837,
        "SUID" : 16771,
        "selected" : false,
        "sseqid" : "AT1G30400",
        "length" : 86,
        "nident" : 42,
        "evalue" : 2.1E-20,
        "positive" : 60,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 85.9,
        "slen" : 1622,
        "mismatch" : 44,
        "name" : "SpCluster-2687.0",
        "send" : 1487,
        "qcovs" : 65,
        "PrimarySymbol" : "ATP-BINDING CASSETTE C1 (ABCC1)",
        "qend" : 142
      },
      "position" : {
        "x" : 139.53292846679688,
        "y" : -181.969482421875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16770",
        "degree_layout" : 44,
        "Description" : "member of GCN subfamily",
        "SecondarySymbol" : "ARABIDOPSIS THALIANA GENERAL CONTROL NON-REPRESSIBLE 2 (ATGCN2);ATP-BINDING CASSETTE F2 (ABCF2);GENERAL CONTROL NON-REPRESSIBLE 2 (GCN2)",
        "sstart" : 86,
        "qstart" : 434,
        "qcovhsp" : 21,
        "shared_name" : "SpCluster-2557.0",
        "ppos" : 52.63,
        "score" : 489,
        "pident" : 31.228,
        "SUID" : 16770,
        "selected" : false,
        "sseqid" : "AT5G09930",
        "length" : 570,
        "nident" : 178,
        "evalue" : 1.24E-51,
        "positive" : 300,
        "gaps" : 62,
        "Type" : "protein_coding",
        "bitscore" : 192.0,
        "slen" : 678,
        "mismatch" : 330,
        "name" : "SpCluster-2557.0",
        "send" : 617,
        "qcovs" : 63,
        "PrimarySymbol" : "ATP-BINDING CASSETTE F2 (ABCF2)",
        "qend" : 2071
      },
      "position" : {
        "x" : 220.1564483642578,
        "y" : -54.9281120300293
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16769",
        "degree_layout" : 12,
        "Description" : "member of MRP subfamily",
        "SecondarySymbol" : "MULTIDRUG RESISTANCE-ASSOCIATED PROTEIN 9 (ATMRP9);ATP-BINDING CASSETTE C9 (ABCC9);MULTIDRUG RESISTANCE-ASSOCIATED PROTEIN 9 (MRP9)",
        "sstart" : 1391,
        "qstart" : 14,
        "qcovhsp" : 32,
        "shared_name" : "SpCluster-17517.1",
        "ppos" : 44.17,
        "score" : 158,
        "pident" : 33.333,
        "SUID" : 16769,
        "selected" : false,
        "sseqid" : "AT3G60160",
        "length" : 120,
        "nident" : 40,
        "evalue" : 2.26E-13,
        "positive" : 53,
        "gaps" : 44,
        "Type" : "protein_coding",
        "bitscore" : 65.5,
        "slen" : 1506,
        "mismatch" : 36,
        "name" : "SpCluster-17517.1",
        "send" : 1466,
        "qcovs" : 97,
        "PrimarySymbol" : "ATP-BINDING CASSETTE C9 (ABCC9)",
        "qend" : 373
      },
      "position" : {
        "x" : 176.9725799560547,
        "y" : -136.0672607421875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16768",
        "degree_layout" : 41,
        "Description" : "member of GCN subfamily",
        "SecondarySymbol" : "GENERAL CONTROL NON-REPRESSIBLE 4 (ATGCN4);ATP-BINDING CASSETTE F4 (ABCF4);GENERAL CONTROL NON-REPRESSIBLE 4 (GCN4)",
        "sstart" : 279,
        "qstart" : 1148,
        "qcovhsp" : 16,
        "shared_name" : "SpCluster-12654.0",
        "ppos" : 86.55,
        "score" : 1681,
        "pident" : 73.543,
        "SUID" : 16768,
        "selected" : false,
        "sseqid" : "AT3G54540",
        "length" : 446,
        "nident" : 328,
        "evalue" : 0.0,
        "positive" : 386,
        "gaps" : 1,
        "Type" : "protein_coding",
        "bitscore" : 652.0,
        "slen" : 723,
        "mismatch" : 117,
        "name" : "SpCluster-12654.0",
        "send" : 723,
        "qcovs" : 49,
        "PrimarySymbol" : "ATP-BINDING CASSETTE F4 (ABCF4)",
        "qend" : 2485
      },
      "position" : {
        "x" : 183.7425537109375,
        "y" : -32.87571716308594
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16766",
        "degree_layout" : 34,
        "Description" : "member of GCN subfamily",
        "SecondarySymbol" : "GENERAL CONTROL NONDEREPRESSIBLE 5 (GCN5);ATP-BINDING CASSETTE F5 (ABCF5);GENERAL CONTROL NON-REPRESSIBLE 5 (ATGCN5)",
        "sstart" : 101,
        "qstart" : 546,
        "qcovhsp" : 17,
        "shared_name" : "KfCluster-32789.0",
        "ppos" : 53.52,
        "score" : 325,
        "pident" : 34.507,
        "SUID" : 16766,
        "selected" : false,
        "sseqid" : "AT5G64840",
        "length" : 284,
        "nident" : 98,
        "evalue" : 1.36E-31,
        "positive" : 152,
        "gaps" : 22,
        "Type" : "protein_coding",
        "bitscore" : 129.0,
        "slen" : 692,
        "mismatch" : 164,
        "name" : "KfCluster-32789.0",
        "send" : 370,
        "qcovs" : 51,
        "PrimarySymbol" : "ATP-BINDING CASSETTE F5 (ABCF5)",
        "qend" : 1373
      },
      "position" : {
        "x" : 179.3773651123047,
        "y" : 2.585662841796875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16765",
        "degree_layout" : 54,
        "Description" : "\"Encodes a member of GCN subfamily. Predicted to be involved in stress-associated protein translation control. The mutant is affected in MAMP ((microbe-associated molecular patterns)-induced stomatal closure, but not other MAMP-induced responses in the leaves.\"",
        "SecondarySymbol" : "GENERAL CONTROL NON-REPRESSIBLE 3 (ATGCN3);GENERAL CONTROL NON-REPRESSIBLE 3 (GCN3);ATP-BINDING CASSETTE F3 (ABCF3); (ATGCN20);SUSCEPTIBLE TO CORONATINE-DEFICIENT PST DC3000 5 (SCORD5);GENERAL CONTROL NON-REPRESSIBLE 20 (GCN20); (ATABCF3)",
        "sstart" : 180,
        "qstart" : 2132,
        "qcovhsp" : 7,
        "shared_name" : "KfCluster-14394.0",
        "ppos" : 44.58,
        "score" : 391,
        "pident" : 28.818,
        "SUID" : 16765,
        "selected" : false,
        "sseqid" : "AT1G64550",
        "length" : 406,
        "nident" : 117,
        "evalue" : 1.82E-38,
        "positive" : 181,
        "gaps" : 108,
        "Type" : "protein_coding",
        "bitscore" : 155.0,
        "slen" : 715,
        "mismatch" : 181,
        "name" : "KfCluster-14394.0",
        "send" : 575,
        "qcovs" : 22,
        "PrimarySymbol" : "ATP-BINDING CASSETTE F3 (ABCF3)",
        "qend" : 1209
      },
      "position" : {
        "x" : 93.84144592285156,
        "y" : -94.86785125732422
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16764",
        "degree_layout" : 13,
        "Description" : "Stromal heat shock protein involved in protein import into chloroplast. The mRNA is cell-to-cell mobile.",
        "SecondarySymbol" : "CHLOROPLAST HEAT SHOCK PROTEIN 70-2 (CPHSC70-2EAT SHOCK PROTEIN 70-2);CHLOROPLAST HEAT SHOCK PROTEIN 70-2 (cpHsc70-2);HEAT SHOCK PROTEIN 70-7 (HSC70-7)",
        "sstart" : 539,
        "qstart" : 675,
        "qcovhsp" : 20,
        "shared_name" : "SpCluster-18983.1",
        "ppos" : 88.97,
        "score" : 475,
        "pident" : 73.529,
        "SUID" : 16764,
        "selected" : false,
        "sseqid" : "AT5G49910",
        "length" : 136,
        "nident" : 100,
        "evalue" : 2.77E-55,
        "positive" : 121,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 187.0,
        "slen" : 718,
        "mismatch" : 36,
        "name" : "SpCluster-18983.1",
        "send" : 674,
        "qcovs" : 60,
        "PrimarySymbol" : "CHLOROPLAST HEAT SHOCK PROTEIN 70-2 (cpHsc70-2)",
        "qend" : 268
      },
      "position" : {
        "x" : -486.68658447265625,
        "y" : -1466.41796875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16763",
        "degree_layout" : 26,
        "Description" : "encodes a member of heat shock protein 70 family.",
        "SecondarySymbol" : "(AtHsp70-1);HEAT SHOCK COGNATE PROTEIN 70 (HSC70);ARABIDOPSIS THALIANA HEAT SHOCK COGNATE PROTEIN 70-1 (AT-HSC70-1);HEAT SHOCK PROTEIN 70-1 (HSP70-1);HEAT SHOCK COGNATE PROTEIN 70-1 (HSC70-1)",
        "sstart" : 184,
        "qstart" : 3,
        "qcovhsp" : 31,
        "shared_name" : "SpCluster-14082.1",
        "ppos" : 96.79,
        "score" : 2264,
        "pident" : 95.94,
        "SUID" : 16763,
        "selected" : false,
        "sseqid" : "AT5G02500",
        "length" : 468,
        "nident" : 449,
        "evalue" : 0.0,
        "positive" : 453,
        "gaps" : 2,
        "Type" : "protein_coding",
        "bitscore" : 876.0,
        "slen" : 651,
        "mismatch" : 17,
        "name" : "SpCluster-14082.1",
        "send" : 651,
        "qcovs" : 93,
        "PrimarySymbol" : "HEAT SHOCK COGNATE PROTEIN 70-1 (HSC70-1)",
        "qend" : 1400
      },
      "position" : {
        "x" : -527.3447875976562,
        "y" : -1348.323486328125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "18133",
        "degree_layout" : 1,
        "Description" : "ABC1K8 is a member of an atypical protein kinase family that is induced by heavy metals. Loss of function mutations affect the metabolic profile of chloroplast lipids. It appears to function along with ABC1K7 in mediating lipid membrane changes in response to stress. The mRNA is cell-to-cell mobile.",
        "SecondarySymbol" : "ARABIDOPSIS THALIANA ABC2 HOMOLOG 13 (ATATH13); (ABC1K8);OXIDATIVE STRESS-RELATED ABC1-LIKE PROTEIN 1 (OSA1);ABC2 HOMOLOG 13 (ATH13);A. THALIANA OXIDATIVE STRESS-RELATED ABC1-LIKE PROTEIN 1 (ATOSA1)",
        "sstart" : 672,
        "qstart" : 5,
        "qcovhsp" : 11,
        "shared_name" : "SpCluster-8662.1",
        "ppos" : 82.22,
        "score" : 201,
        "pident" : 60.0,
        "SUID" : 18133,
        "selected" : false,
        "sseqid" : "AT5G64940",
        "length" : 90,
        "nident" : 54,
        "evalue" : 1.92E-17,
        "positive" : 74,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 82.0,
        "slen" : 761,
        "mismatch" : 36,
        "name" : "SpCluster-8662.1",
        "send" : 761,
        "qcovs" : 34,
        "PrimarySymbol" : "ABC2 HOMOLOG 13 (ATH13)",
        "qend" : 274
      },
      "position" : {
        "x" : -1528.983034925484,
        "y" : -2066.47509765625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16762",
        "degree_layout" : 22,
        "Description" : "\"Encodes the luminal binding protein BiP, an ER-localized member of the HSP70 family.  BiP is composed of an N-terminal ATP binding domain and a C-terminal domain that binds to hydrophobic patches on improperly/incompletely folded proteins in an ATP-dependent manner. Involved in polar nuclei fusion during proliferation of endosperm nuclei.\"",
        "SecondarySymbol" : "(BIP1)",
        "sstart" : 16,
        "qstart" : 79,
        "qcovhsp" : 31,
        "shared_name" : "SpCluster-13423.0",
        "ppos" : 95.8,
        "score" : 1972,
        "pident" : 90.21,
        "SUID" : 16762,
        "selected" : false,
        "sseqid" : "AT5G28540",
        "length" : 429,
        "nident" : 387,
        "evalue" : 0.0,
        "positive" : 411,
        "gaps" : 1,
        "Type" : "protein_coding",
        "bitscore" : 764.0,
        "slen" : 669,
        "mismatch" : 41,
        "name" : "SpCluster-13423.0",
        "send" : 443,
        "qcovs" : 94,
        "PrimarySymbol" : "(BIP1)",
        "qend" : 1365
      },
      "position" : {
        "x" : -501.05279541015625,
        "y" : -1319.417724609375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16761",
        "degree_layout" : 16,
        "Description" : "Stromal heat shock protein involved in protein import into chloroplast. The mRNA is cell-to-cell mobile.",
        "SecondarySymbol" : "CHLOROPLAST HEAT SHOCK PROTEIN 70-2 (CPHSC70-2EAT SHOCK PROTEIN 70-2);CHLOROPLAST HEAT SHOCK PROTEIN 70-2 (cpHsc70-2);HEAT SHOCK PROTEIN 70-7 (HSC70-7)",
        "sstart" : 394,
        "qstart" : 5,
        "qcovhsp" : 23,
        "shared_name" : "KfCluster-9817.0",
        "ppos" : 93.62,
        "score" : 1121,
        "pident" : 83.333,
        "SUID" : 16761,
        "selected" : false,
        "sseqid" : "AT5G49910",
        "length" : 282,
        "nident" : 235,
        "evalue" : 1.03E-147,
        "positive" : 264,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 436.0,
        "slen" : 718,
        "mismatch" : 47,
        "name" : "KfCluster-9817.0",
        "send" : 675,
        "qcovs" : 68,
        "PrimarySymbol" : "CHLOROPLAST HEAT SHOCK PROTEIN 70-2 (cpHsc70-2)",
        "qend" : 850
      },
      "position" : {
        "x" : -431.2613830566406,
        "y" : -1341.585205078125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16760",
        "degree_layout" : 14,
        "Description" : "heat shock protein 70;(source:Araport11)",
        "SecondarySymbol" : "(HSC70-4);ARABIDOPSIS HEAT SHOCK PROTEIN 70 (ATHSP70);HEAT SHOCK PROTEIN 70 (HSP70)",
        "sstart" : 347,
        "qstart" : 1,
        "qcovhsp" : 33,
        "shared_name" : "KfCluster-7261.0",
        "ppos" : 99.38,
        "score" : 696,
        "pident" : 97.531,
        "SUID" : 16760,
        "selected" : false,
        "sseqid" : "AT3G12580",
        "length" : 162,
        "nident" : 158,
        "evalue" : 4.88E-89,
        "positive" : 161,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 272.0,
        "slen" : 650,
        "mismatch" : 4,
        "name" : "KfCluster-7261.0",
        "send" : 508,
        "qcovs" : 100,
        "PrimarySymbol" : "HEAT SHOCK PROTEIN 70 (HSP70)",
        "qend" : 486
      },
      "position" : {
        "x" : -542.11328125,
        "y" : -1446.1085205078125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16759",
        "degree_layout" : 7,
        "Description" : "Heat shock protein 70 (Hsp 70) family protein;(source:Araport11)",
        "SecondarySymbol" : "(Hsp70-2); (AtHsp70-2)",
        "sstart" : 501,
        "qstart" : 713,
        "qcovhsp" : 21,
        "shared_name" : "KfCluster-5792.0",
        "ppos" : 81.05,
        "score" : 376,
        "pident" : 70.588,
        "SUID" : 16759,
        "selected" : false,
        "sseqid" : "AT5G02490",
        "length" : 153,
        "nident" : 108,
        "evalue" : 1.94E-41,
        "positive" : 124,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 149.0,
        "slen" : 653,
        "mismatch" : 45,
        "name" : "KfCluster-5792.0",
        "send" : 653,
        "qcovs" : 64,
        "PrimarySymbol" : "(Hsp70-2)",
        "qend" : 255
      },
      "position" : {
        "x" : -595.6759643554688,
        "y" : -1408.295166015625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16758",
        "degree_layout" : 25,
        "Description" : "heat shock protein 70 (Hsc70-5); nuclear",
        "SecondarySymbol" : "MITOCHONDRIAL HSO70 2 (MTHSC70-2);HEAT SHOCK COGNATE (HSC70-5)",
        "sstart" : 33,
        "qstart" : 414,
        "qcovhsp" : 22,
        "shared_name" : "KfCluster-33161.1",
        "ppos" : 88.7,
        "score" : 2220,
        "pident" : 75.652,
        "SUID" : 16758,
        "selected" : false,
        "sseqid" : "AT5G09590",
        "length" : 575,
        "nident" : 435,
        "evalue" : 0.0,
        "positive" : 510,
        "gaps" : 3,
        "Type" : "protein_coding",
        "bitscore" : 859.0,
        "slen" : 682,
        "mismatch" : 137,
        "name" : "KfCluster-33161.1",
        "send" : 606,
        "qcovs" : 67,
        "PrimarySymbol" : "MITOCHONDRIAL HSO70 2 (MTHSC70-2)",
        "qend" : 2132
      },
      "position" : {
        "x" : -499.013427734375,
        "y" : -1394.5821533203125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16757",
        "degree_layout" : 14,
        "Description" : "encodes a heat shock protein whose gene expression is induced by heat and dehydration.",
        "SecondarySymbol" : "EARLY-RESPONSIVE TO DEHYDRATION 2 (ERD2);HEAT SHOCK PROTEIN 70T-1 (HSP70T-1)",
        "sstart" : 1,
        "qstart" : 331,
        "qcovhsp" : 21,
        "shared_name" : "KfCluster-20915.0",
        "ppos" : 96.41,
        "score" : 956,
        "pident" : 89.744,
        "SUID" : 16757,
        "selected" : false,
        "sseqid" : "AT1G56410",
        "length" : 195,
        "nident" : 175,
        "evalue" : 6.9E-126,
        "positive" : 188,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 372.0,
        "slen" : 617,
        "mismatch" : 20,
        "name" : "KfCluster-20915.0",
        "send" : 195,
        "qcovs" : 64,
        "PrimarySymbol" : "EARLY-RESPONSIVE TO DEHYDRATION 2 (ERD2)",
        "qend" : 915
      },
      "position" : {
        "x" : -396.1985778808594,
        "y" : -1375.0614013671875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16756",
        "degree_layout" : 18,
        "Description" : "\"encodes high molecular weight heat shock protein 70 not a HSP90 homolog, mRNA is constitutively expressed but transiently induced after heat shock\"",
        "SecondarySymbol" : "(AtHsp70-14);HEAT SHOCK PROTEIN 91 (HSP91)",
        "sstart" : 3,
        "qstart" : 257,
        "qcovhsp" : 27,
        "shared_name" : "KfCluster-20913.0",
        "ppos" : 83.05,
        "score" : 1417,
        "pident" : 63.636,
        "SUID" : 16756,
        "selected" : false,
        "sseqid" : "AT1G79930",
        "length" : 407,
        "nident" : 259,
        "evalue" : 0.0,
        "positive" : 338,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 550.0,
        "slen" : 789,
        "mismatch" : 148,
        "name" : "KfCluster-20913.0",
        "send" : 409,
        "qcovs" : 80,
        "PrimarySymbol" : "HEAT SHOCK PROTEIN 91 (HSP91)",
        "qend" : 1477
      },
      "position" : {
        "x" : -448.9326171875,
        "y" : -1301.47216796875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16755",
        "degree_layout" : 16,
        "Description" : "encodes a member of heat shock protein 70 family.",
        "SecondarySymbol" : "(AtHsp70-1);HEAT SHOCK COGNATE PROTEIN 70 (HSC70);ARABIDOPSIS THALIANA HEAT SHOCK COGNATE PROTEIN 70-1 (AT-HSC70-1);HEAT SHOCK PROTEIN 70-1 (HSP70-1);HEAT SHOCK COGNATE PROTEIN 70-1 (HSC70-1)",
        "sstart" : 188,
        "qstart" : 502,
        "qcovhsp" : 33,
        "shared_name" : "KfCluster-15458.0",
        "ppos" : 97.6,
        "score" : 833,
        "pident" : 91.617,
        "SUID" : 16755,
        "selected" : false,
        "sseqid" : "AT5G02500",
        "length" : 167,
        "nident" : 153,
        "evalue" : 5.29E-111,
        "positive" : 163,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 325.0,
        "slen" : 521,
        "mismatch" : 14,
        "name" : "KfCluster-15458.0",
        "send" : 354,
        "qcovs" : 99,
        "PrimarySymbol" : "HEAT SHOCK COGNATE PROTEIN 70-1 (HSC70-1)",
        "qend" : 2
      },
      "position" : {
        "x" : -422.22979736328125,
        "y" : -1378.353271484375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16754",
        "degree_layout" : 30,
        "Description" : "heat shock protein 70 (Hsp 70) family protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 23,
        "qstart" : 241,
        "qcovhsp" : 20,
        "shared_name" : "KfCluster-12896.0",
        "ppos" : 62.94,
        "score" : 1408,
        "pident" : 44.823,
        "SUID" : 16754,
        "selected" : false,
        "sseqid" : "AT4G16660",
        "length" : 734,
        "nident" : 329,
        "evalue" : 2.65E-178,
        "positive" : 462,
        "gaps" : 25,
        "Type" : "protein_coding",
        "bitscore" : 546.0,
        "slen" : 867,
        "mismatch" : 380,
        "name" : "KfCluster-12896.0",
        "send" : 742,
        "qcovs" : 61,
        "PrimarySymbol" : "0",
        "qend" : 2409
      },
      "position" : {
        "x" : -435.1489562988281,
        "y" : -1224.419189453125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16753",
        "degree_layout" : 25,
        "Description" : "heat shock protein 70 (Hsc70-5); nuclear",
        "SecondarySymbol" : "MITOCHONDRIAL HSO70 2 (MTHSC70-2);HEAT SHOCK COGNATE (HSC70-5)",
        "sstart" : 47,
        "qstart" : 2425,
        "qcovhsp" : 22,
        "shared_name" : "CrCluster-42004.0",
        "ppos" : 89.75,
        "score" : 2430,
        "pident" : 80.496,
        "SUID" : 16753,
        "selected" : false,
        "sseqid" : "AT5G09590",
        "length" : 605,
        "nident" : 487,
        "evalue" : 0.0,
        "positive" : 543,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 940.0,
        "slen" : 682,
        "mismatch" : 118,
        "name" : "CrCluster-42004.0",
        "send" : 651,
        "qcovs" : 67,
        "PrimarySymbol" : "MITOCHONDRIAL HSO70 2 (MTHSC70-2)",
        "qend" : 611
      },
      "position" : {
        "x" : -463.0545959472656,
        "y" : -1399.683349609375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17742",
        "degree_layout" : 4,
        "Description" : "Encodes a predicted protein with 30% identity with MER3/RCK. Similar to yast Brr2p DEAD/DExH box ATP-dependent RNA helicase.",
        "SecondarySymbol" : "(BRR2C)",
        "sstart" : 73,
        "qstart" : 7093,
        "qcovhsp" : 27,
        "shared_name" : "PpCluster-26543.0",
        "ppos" : 78.42,
        "score" : 6626,
        "pident" : 63.732,
        "SUID" : 17742,
        "selected" : false,
        "sseqid" : "AT5G61140",
        "length" : 1988,
        "nident" : 1267,
        "evalue" : 0.0,
        "positive" : 1559,
        "gaps" : 54,
        "Type" : "protein_coding",
        "bitscore" : 2556.0,
        "slen" : 2157,
        "mismatch" : 667,
        "name" : "PpCluster-26543.0",
        "send" : 2016,
        "qcovs" : 82,
        "PrimarySymbol" : "(BRR2C)",
        "qend" : 1160
      },
      "position" : {
        "x" : -1513.0634738635788,
        "y" : -2595.248052272843
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16750",
        "degree_layout" : 8,
        "Description" : "Encodes a plastid isoform of the enzyme phosphoglucomutase involved in controlling photosynthetic carbon flow. Effective petiole movement against the direction of the gravity requires functional  PGM activity that is required for full development of amyloplasts.",
        "SecondarySymbol" : "STARCH-FREE 1 (STF1);PHOSPHOGLUCOMUTASE (PGM);ARABIDOPSIS THALIANA PHOSPHOGLUCOMUTASE (ATPGMP); (PGM1)",
        "sstart" : 65,
        "qstart" : 698,
        "qcovhsp" : 21,
        "shared_name" : "KfCluster-4993.0",
        "ppos" : 87.48,
        "score" : 2253,
        "pident" : 74.419,
        "SUID" : 16750,
        "selected" : false,
        "sseqid" : "AT5G51820",
        "length" : 559,
        "nident" : 416,
        "evalue" : 0.0,
        "positive" : 489,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 872.0,
        "slen" : 623,
        "mismatch" : 143,
        "name" : "KfCluster-4993.0",
        "send" : 623,
        "qcovs" : 62,
        "PrimarySymbol" : "PHOSPHOGLUCOMUTASE (PGM)",
        "qend" : 2374
      },
      "position" : {
        "x" : -339.732666015625,
        "y" : -969.1685791015625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16749",
        "degree_layout" : 2,
        "Description" : "Encodes a plastid isoform of the enzyme phosphoglucomutase involved in controlling photosynthetic carbon flow. Effective petiole movement against the direction of the gravity requires functional  PGM activity that is required for full development of amyloplasts.",
        "SecondarySymbol" : "STARCH-FREE 1 (STF1);PHOSPHOGLUCOMUTASE (PGM);ARABIDOPSIS THALIANA PHOSPHOGLUCOMUTASE (ATPGMP); (PGM1)",
        "sstart" : 26,
        "qstart" : 2004,
        "qcovhsp" : 25,
        "shared_name" : "CrCluster-39352.0",
        "ppos" : 88.46,
        "score" : 2499,
        "pident" : 77.258,
        "SUID" : 16749,
        "selected" : false,
        "sseqid" : "AT5G51820",
        "length" : 598,
        "nident" : 462,
        "evalue" : 0.0,
        "positive" : 529,
        "gaps" : 6,
        "Type" : "protein_coding",
        "bitscore" : 967.0,
        "slen" : 623,
        "mismatch" : 130,
        "name" : "CrCluster-39352.0",
        "send" : 623,
        "qcovs" : 76,
        "PrimarySymbol" : "PHOSPHOGLUCOMUTASE (PGM)",
        "qend" : 229
      },
      "position" : {
        "x" : -426.079345703125,
        "y" : -872.5413208007812
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17741",
        "degree_layout" : 2,
        "Description" : "Red/far-red photoreceptor involved in the regulation of de-etiolation. Exists in two inter-convertible forms: Pr and Pfr (active). Involved in the light-promotion of seed germination and in the shade avoidance response. Promotes seedling etiolation in both the presence and absence of phytochrome A. Overexpression results in etiolation under far-red light. Accumulates in the nucleus after exposure to far red light. The phosphorylation state of the Ser-86 residue of the phytochrome B molecule alters dark reversion of the molecule. The mRNA is cell-to-cell mobile.",
        "SecondarySymbol" : "PHYTOCHROME B (PHYB);OUT OF PHASE 1 (OOP1); (HY3)",
        "sstart" : 1074,
        "qstart" : 9,
        "qcovhsp" : 9,
        "shared_name" : "PpCluster-21922.2",
        "ppos" : 66.67,
        "score" : 238,
        "pident" : 48.387,
        "SUID" : 17741,
        "selected" : false,
        "sseqid" : "AT2G18790",
        "length" : 93,
        "nident" : 45,
        "evalue" : 1.45E-21,
        "positive" : 62,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 96.3,
        "slen" : 1172,
        "mismatch" : 48,
        "name" : "PpCluster-21922.2",
        "send" : 1166,
        "qcovs" : 27,
        "PrimarySymbol" : "PHYTOCHROME B (PHYB)",
        "qend" : 287
      },
      "position" : {
        "x" : 1912.2110121844084,
        "y" : -1522.0704108773607
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "18128",
        "degree_layout" : 2,
        "Description" : "\"CHC1 is predicted to encode a protein that belongs to the chromodomain remodeling complex. Two RNAi knock-down lines have a dwarf phenotype and reduced rates of Agrobacterium-mediated transformation. The low rate of root-mediated transformation rate may result from altered root morphology or reduced root growth rates. Also named as SWP73B, a subunit of the SWI/SNF chromatin remodeling complex. Acts as important modulator of major developmental pathways.\"",
        "SecondarySymbol" : "(CHC1); (BAF60);SWP73B (SWP73B)",
        "sstart" : 131,
        "qstart" : 391,
        "qcovhsp" : 23,
        "shared_name" : "SpCluster-8260.0",
        "ppos" : 67.64,
        "score" : 986,
        "pident" : 44.039,
        "SUID" : 18128,
        "selected" : false,
        "sseqid" : "AT5G14170",
        "length" : 411,
        "nident" : 181,
        "evalue" : 5.83E-127,
        "positive" : 278,
        "gaps" : 12,
        "Type" : "protein_coding",
        "bitscore" : 384.0,
        "slen" : 534,
        "mismatch" : 218,
        "name" : "SpCluster-8260.0",
        "send" : 529,
        "qcovs" : 68,
        "PrimarySymbol" : "(CHC1)",
        "qend" : 1623
      },
      "position" : {
        "x" : 38.777191162109375,
        "y" : -1222.1044921875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "18127",
        "degree_layout" : 1,
        "Description" : "TRAF-like family protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 1495,
        "qstart" : 971,
        "qcovhsp" : 3,
        "shared_name" : "SpCluster-8219.0",
        "ppos" : 54.79,
        "score" : 66,
        "pident" : 28.767,
        "SUID" : 18127,
        "selected" : false,
        "sseqid" : "AT2G25320",
        "length" : 73,
        "nident" : 21,
        "evalue" : 7.7,
        "positive" : 40,
        "gaps" : 10,
        "Type" : "protein_coding",
        "bitscore" : 30.0,
        "slen" : 1673,
        "mismatch" : 42,
        "name" : "SpCluster-8219.0",
        "send" : 1560,
        "qcovs" : 10,
        "PrimarySymbol" : "0",
        "qend" : 1180
      },
      "position" : {
        "x" : 914.6983032226562,
        "y" : -1436.1737060546875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16746",
        "degree_layout" : 10,
        "Description" : "receptor like protein 4;(source:Araport11)",
        "SecondarySymbol" : "RECEPTOR LIKE PROTEIN 4 (RLP4);RECEPTOR LIKE PROTEIN 4 (AtRLP4)",
        "sstart" : 214,
        "qstart" : 1691,
        "qcovhsp" : 4,
        "shared_name" : "KfCluster-5800.0",
        "ppos" : 48.37,
        "score" : 130,
        "pident" : 33.333,
        "SUID" : 16746,
        "selected" : false,
        "sseqid" : "AT1G28340",
        "length" : 153,
        "nident" : 51,
        "evalue" : 3.0E-7,
        "positive" : 74,
        "gaps" : 18,
        "Type" : "protein_coding",
        "bitscore" : 54.7,
        "slen" : 626,
        "mismatch" : 84,
        "name" : "KfCluster-5800.0",
        "send" : 360,
        "qcovs" : 13,
        "PrimarySymbol" : "RECEPTOR LIKE PROTEIN 4 (RLP4)",
        "qend" : 2113
      },
      "position" : {
        "x" : -263.77606201171875,
        "y" : -1406.4488525390625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16745",
        "degree_layout" : 8,
        "Description" : "Leucine-rich repeat transmembrane protein kinase;(source:Araport11)",
        "SecondarySymbol" : "CELLULOSE SYNTHASE LIKE D2 (CLSD2)",
        "sstart" : 462,
        "qstart" : 1306,
        "qcovhsp" : 6,
        "shared_name" : "KfCluster-13420.0",
        "ppos" : 45.69,
        "score" : 118,
        "pident" : 34.483,
        "SUID" : 16745,
        "selected" : false,
        "sseqid" : "AT1G29720",
        "length" : 116,
        "nident" : 40,
        "evalue" : 5.56E-6,
        "positive" : 53,
        "gaps" : 18,
        "Type" : "protein_coding",
        "bitscore" : 50.1,
        "slen" : 1019,
        "mismatch" : 58,
        "name" : "KfCluster-13420.0",
        "send" : 568,
        "qcovs" : 17,
        "PrimarySymbol" : "0",
        "qend" : 986
      },
      "position" : {
        "x" : -340.57806396484375,
        "y" : -1400.74609375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16744",
        "degree_layout" : 4,
        "Description" : "encodes tubulin beta-2/beta-3 chain The mRNA is cell-to-cell mobile.",
        "SecondarySymbol" : "ARABIDOPSIS THALIANA GAMMA TUBULIN COMPLEX PROTEIN 3 (ATGCP3);TUBULIN BETA CHAIN 3 (TUB3)",
        "sstart" : 1,
        "qstart" : 1714,
        "qcovhsp" : 22,
        "shared_name" : "KfCluster-8640.0",
        "ppos" : 98.36,
        "score" : 2160,
        "pident" : 95.316,
        "SUID" : 16744,
        "selected" : false,
        "sseqid" : "AT5G62700",
        "length" : 427,
        "nident" : 407,
        "evalue" : 0.0,
        "positive" : 420,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 836.0,
        "slen" : 450,
        "mismatch" : 20,
        "name" : "KfCluster-8640.0",
        "send" : 427,
        "qcovs" : 66,
        "PrimarySymbol" : "TUBULIN BETA CHAIN 3 (TUB3)",
        "qend" : 434
      },
      "position" : {
        "x" : -201.71849060058594,
        "y" : -2123.57958984375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16743",
        "degree_layout" : 2,
        "Description" : "Encodes a putative apyrase involved in pollen exine pattern formation and anther dehiscence.",
        "SecondarySymbol" : "(ATAPY6);APYRASE 6 (APY6)",
        "sstart" : 291,
        "qstart" : 322,
        "qcovhsp" : 6,
        "shared_name" : "CrCluster-35114.1",
        "ppos" : 58.06,
        "score" : 66,
        "pident" : 41.935,
        "SUID" : 16743,
        "selected" : false,
        "sseqid" : "AT2G02970",
        "length" : 31,
        "nident" : 13,
        "evalue" : 0.96,
        "positive" : 18,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 30.0,
        "slen" : 555,
        "mismatch" : 18,
        "name" : "CrCluster-35114.1",
        "send" : 321,
        "qcovs" : 17,
        "PrimarySymbol" : "APYRASE 6 (APY6)",
        "qend" : 230
      },
      "position" : {
        "x" : -335.61907958984375,
        "y" : -2459.920654296875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16742",
        "degree_layout" : 3,
        "Description" : "hypothetical protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 5,
        "qstart" : 351,
        "qcovhsp" : 6,
        "shared_name" : "CrCluster-35114.0",
        "ppos" : 50.0,
        "score" : 57,
        "pident" : 41.667,
        "SUID" : 16742,
        "selected" : false,
        "sseqid" : "AT4G29905",
        "length" : 36,
        "nident" : 15,
        "evalue" : 3.7,
        "positive" : 18,
        "gaps" : 2,
        "Type" : "protein_coding",
        "bitscore" : 26.6,
        "slen" : 67,
        "mismatch" : 19,
        "name" : "CrCluster-35114.0",
        "send" : 40,
        "qcovs" : 19,
        "PrimarySymbol" : "0",
        "qend" : 250
      },
      "position" : {
        "x" : -302.7518310546875,
        "y" : -2337.972900390625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17737",
        "degree_layout" : 5,
        "Description" : "",
        "SecondarySymbol" : "",
        "shared_name" : "SpCluster-11139.0",
        "SUID" : 17737,
        "selected" : false,
        "sseqid" : "",
        "Type" : "",
        "name" : "SpCluster-11139.0",
        "PrimarySymbol" : ""
      },
      "position" : {
        "x" : 596.7456665039062,
        "y" : -1670.71533203125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16734",
        "Description" : "EXORDIUM like 2;(source:Araport11)",
        "SecondarySymbol" : "EXORDIUM LIKE 2 (EXL2)",
        "sstart" : 25,
        "qstart" : 1294,
        "qcovhsp" : 13,
        "shared_name" : "PpCluster-20991.1",
        "ppos" : 61.46,
        "score" : 675,
        "pident" : 49.653,
        "SUID" : 16734,
        "selected" : false,
        "sseqid" : "AT5G64260",
        "length" : 288,
        "nident" : 143,
        "evalue" : 2.44E-82,
        "positive" : 177,
        "gaps" : 15,
        "Type" : "protein_coding",
        "bitscore" : 264.0,
        "slen" : 305,
        "mismatch" : 130,
        "name" : "PpCluster-20991.1",
        "send" : 301,
        "qcovs" : 38,
        "PrimarySymbol" : "EXORDIUM LIKE 2 (EXL2)",
        "qend" : 443
      },
      "position" : {
        "x" : -1468.2847592791707,
        "y" : -3510.658218504946
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16733",
        "Description" : "Phosphate-responsive 1 family protein;(source:Araport11)",
        "SecondarySymbol" : "EXORDIUM (EXO)",
        "sstart" : 35,
        "qstart" : 514,
        "qcovhsp" : 13,
        "shared_name" : "CrCluster-3237.1726",
        "ppos" : 53.94,
        "score" : 521,
        "pident" : 38.801,
        "SUID" : 16733,
        "selected" : false,
        "sseqid" : "AT4G08950",
        "length" : 317,
        "nident" : 123,
        "evalue" : 1.27E-59,
        "positive" : 171,
        "gaps" : 45,
        "Type" : "protein_coding",
        "bitscore" : 205.0,
        "slen" : 314,
        "mismatch" : 149,
        "name" : "CrCluster-3237.1726",
        "send" : 311,
        "qcovs" : 38,
        "PrimarySymbol" : "EXORDIUM (EXO)",
        "qend" : 1449
      },
      "position" : {
        "x" : -1366.6209409197957,
        "y" : -3481.352310301821
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16730",
        "Description" : "YUCCA 3;(source:Araport11)",
        "SecondarySymbol" : "YUCCA 3 (YUC3)",
        "sstart" : 23,
        "qstart" : 1904,
        "qcovhsp" : 13,
        "shared_name" : "PpCluster-12017.0",
        "ppos" : 67.74,
        "score" : 1030,
        "pident" : 51.117,
        "SUID" : 16730,
        "selected" : false,
        "sseqid" : "AT1G04610",
        "length" : 403,
        "nident" : 206,
        "evalue" : 2.69E-130,
        "positive" : 273,
        "gaps" : 5,
        "Type" : "protein_coding",
        "bitscore" : 401.0,
        "slen" : 437,
        "mismatch" : 192,
        "name" : "PpCluster-12017.0",
        "send" : 421,
        "qcovs" : 40,
        "PrimarySymbol" : "YUCCA 3 (YUC3)",
        "qend" : 699
      },
      "position" : {
        "x" : -2340.834674371453,
        "y" : -2342.002197265625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16729",
        "Description" : "Encodes YUC2. Catalyzes conversion of IPA (indole-3-pyruvic acid) to IAA (indole-3-acetic acid) in auxin biosynthesis pathway.",
        "SecondarySymbol" : "(ATYUC2);YUCCA2 (YUC2)",
        "sstart" : 3,
        "qstart" : 2018,
        "qcovhsp" : 8,
        "shared_name" : "MpCluster-21870.0",
        "ppos" : 75.97,
        "score" : 732,
        "pident" : 57.94,
        "SUID" : 16729,
        "selected" : false,
        "sseqid" : "AT4G13260",
        "length" : 233,
        "nident" : 135,
        "evalue" : 1.21E-87,
        "positive" : 177,
        "gaps" : 5,
        "Type" : "protein_coding",
        "bitscore" : 286.0,
        "slen" : 415,
        "mismatch" : 93,
        "name" : "MpCluster-21870.0",
        "send" : 231,
        "qcovs" : 24,
        "PrimarySymbol" : "YUCCA2 (YUC2)",
        "qend" : 1323
      },
      "position" : {
        "x" : -2333.857379449578,
        "y" : -2453.50341796875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16728",
        "Description" : "Auxin biosynthetic gene regulated by RVE1. Overexpression leads to suppression of bri1 phenotype.",
        "SecondarySymbol" : "CYTOKININ INDUCED ROOT CURLING 2 (CKRC2);YUCCA 8 (YUC8)",
        "sstart" : 21,
        "qstart" : 437,
        "qcovhsp" : 17,
        "shared_name" : "CrCluster-8830.0",
        "ppos" : 72.66,
        "score" : 1117,
        "pident" : 53.646,
        "SUID" : 16728,
        "selected" : false,
        "sseqid" : "AT4G28720",
        "length" : 384,
        "nident" : 206,
        "evalue" : 3.57E-146,
        "positive" : 279,
        "gaps" : 6,
        "Type" : "protein_coding",
        "bitscore" : 434.0,
        "slen" : 426,
        "mismatch" : 172,
        "name" : "CrCluster-8830.0",
        "send" : 403,
        "qcovs" : 50,
        "PrimarySymbol" : "YUCCA 8 (YUC8)",
        "qend" : 1573
      },
      "position" : {
        "x" : -2244.984088433953,
        "y" : -2418.02099609375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16727",
        "Description" : "Auxin biosynthetic gene regulated by RVE1. Overexpression leads to suppression of bri1 phenotype.",
        "SecondarySymbol" : "CYTOKININ INDUCED ROOT CURLING 2 (CKRC2);YUCCA 8 (YUC8)",
        "sstart" : 8,
        "qstart" : 378,
        "qcovhsp" : 19,
        "shared_name" : "CrCluster-32248.0",
        "ppos" : 68.75,
        "score" : 1068,
        "pident" : 49.5,
        "SUID" : 16727,
        "selected" : false,
        "sseqid" : "AT4G28720",
        "length" : 400,
        "nident" : 198,
        "evalue" : 1.53E-139,
        "positive" : 275,
        "gaps" : 4,
        "Type" : "protein_coding",
        "bitscore" : 416.0,
        "slen" : 426,
        "mismatch" : 198,
        "name" : "CrCluster-32248.0",
        "send" : 403,
        "qcovs" : 57,
        "PrimarySymbol" : "YUCCA 8 (YUC8)",
        "qend" : 1577
      },
      "position" : {
        "x" : -2241.570025933953,
        "y" : -2311.65380859375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16726",
        "Description" : "\"Encodes a chloroplast-targeted 90-kDa heat shock protein located in the stroma involved in red-light mediated deetiolation response and crucial for protein import into the chloroplast stroma. Mutants are resistant to chlorate, have elongated hypocotyls in light, and affect the expression of NR2, CAB, and RBCS but NOT NR1 and NiR.\"",
        "SecondarySymbol" : "(CR88);HEAT SHOCK PROTEIN 88.1 (Hsp88.1);HEAT SHOCK PROTEIN 90.5 (HSP90.5);HEAT SHOCK PROTEIN 90.5 (AtHsp90.5);EMBRYO DEFECTIVE 1956 (emb1956); (ATHSP90C)",
        "sstart" : 562,
        "qstart" : 893,
        "qcovhsp" : 24,
        "shared_name" : "SpCluster-2216.0",
        "ppos" : 76.74,
        "score" : 596,
        "pident" : 55.349,
        "SUID" : 16726,
        "selected" : false,
        "sseqid" : "AT2G04030",
        "length" : 215,
        "nident" : 119,
        "evalue" : 3.33E-71,
        "positive" : 165,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 234.0,
        "slen" : 777,
        "mismatch" : 96,
        "name" : "SpCluster-2216.0",
        "send" : 776,
        "qcovs" : 72,
        "PrimarySymbol" : "(CR88)",
        "qend" : 249
      },
      "position" : {
        "x" : 134.91797305183644,
        "y" : -3310.7410321338675
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16725",
        "Description" : "Encodes a cytosolic heat shock protein AtHSP90.1.  AtHSP90.1 interacts with disease resistance signaling components SGT1b and RAR1 and is required for RPS2-mediated resistance. The mRNA is cell-to-cell mobile.",
        "SecondarySymbol" : "HEAT SHOCK PROTEIN 81-1 (HSP81-1); (ATHS83); (HSP81.1);HEAT SHOCK PROTEIN 90.1 (HSP90.1);HEAT SHOCK PROTEIN 90.1 (ATHSP90.1);HEAT SHOCK PROTEIN 90-1 (AtHsp90-1);HEAT SHOCK PROTEIN 83 (HSP83)",
        "sstart" : 9,
        "qstart" : 3124,
        "qcovhsp" : 16,
        "shared_name" : "SpCluster-16794.0",
        "ppos" : 66.41,
        "score" : 1106,
        "pident" : 48.473,
        "SUID" : 16725,
        "selected" : false,
        "sseqid" : "AT5G52640",
        "length" : 524,
        "nident" : 254,
        "evalue" : 1.37E-136,
        "positive" : 348,
        "gaps" : 38,
        "Type" : "protein_coding",
        "bitscore" : 430.0,
        "slen" : 705,
        "mismatch" : 232,
        "name" : "SpCluster-16794.0",
        "send" : 495,
        "qcovs" : 47,
        "PrimarySymbol" : "HEAT SHOCK PROTEIN 90.1 (HSP90.1)",
        "qend" : 1556
      },
      "position" : {
        "x" : 64.6321225269341,
        "y" : -3408.3037762744925
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16724",
        "Description" : "\"Encodes a chloroplast-targeted 90-kDa heat shock protein located in the stroma involved in red-light mediated deetiolation response and crucial for protein import into the chloroplast stroma. Mutants are resistant to chlorate, have elongated hypocotyls in light, and affect the expression of NR2, CAB, and RBCS but NOT NR1 and NiR.\"",
        "SecondarySymbol" : "(CR88);HEAT SHOCK PROTEIN 88.1 (Hsp88.1);HEAT SHOCK PROTEIN 90.5 (HSP90.5);HEAT SHOCK PROTEIN 90.5 (AtHsp90.5);EMBRYO DEFECTIVE 1956 (emb1956); (ATHSP90C)",
        "sstart" : 323,
        "qstart" : 111,
        "qcovhsp" : 14,
        "shared_name" : "PpCluster-22764.0",
        "ppos" : 85.84,
        "score" : 1295,
        "pident" : 73.41,
        "SUID" : 16724,
        "selected" : false,
        "sseqid" : "AT2G04030",
        "length" : 346,
        "nident" : 254,
        "evalue" : 4.85E-167,
        "positive" : 297,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 503.0,
        "slen" : 780,
        "mismatch" : 92,
        "name" : "PpCluster-22764.0",
        "send" : 668,
        "qcovs" : 42,
        "PrimarySymbol" : "(CR88)",
        "qend" : 1148
      },
      "position" : {
        "x" : 184.848774443438,
        "y" : -3351.4009442432425
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16723",
        "Description" : "\"A member of heat shock protein 90 (HSP90) gene family. Expressed in all tissues and abundant in root apical meristem, pollen and tapetum. Expression is NOT heat-induced but induced by IAA and NaCl. Overexpression reduced tolerance to heat and conferred higher tolerance to calcium. The mRNA is cell-to-cell mobile.\"",
        "SecondarySymbol" : "HEAT SHOCK PROTEIN 81-3 (HSP81-3);HEAT SHOCK PROTEIN 90.3 (AtHsp90.3);HEAT SHOCK PROTEIN 90-3 (AtHsp90-3);HEAT SHOCK PROTEIN 81.3 (Hsp81.3)",
        "sstart" : 2,
        "qstart" : 1531,
        "qcovhsp" : 27,
        "shared_name" : "KfCluster-28526.6",
        "ppos" : 92.55,
        "score" : 2066,
        "pident" : 83.137,
        "SUID" : 16723,
        "selected" : false,
        "sseqid" : "AT5G56010",
        "length" : 510,
        "nident" : 424,
        "evalue" : 0.0,
        "positive" : 472,
        "gaps" : 6,
        "Type" : "protein_coding",
        "bitscore" : 800.0,
        "slen" : 699,
        "mismatch" : 80,
        "name" : "KfCluster-28526.6",
        "send" : 505,
        "qcovs" : 81,
        "PrimarySymbol" : "HEAT SHOCK PROTEIN 81-3 (HSP81-3)",
        "qend" : 2
      },
      "position" : {
        "x" : 100.711811552813,
        "y" : -3309.5911297901175
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16722",
        "Description" : "HEAT SHOCK PROTEIN 81.4;(source:Araport11)",
        "SecondarySymbol" : "HEAT SHOCK PROTEIN 90.4 (AtHsp90.4);HEAT SHOCK PROTEIN 81.4 (Hsp81.4)",
        "sstart" : 469,
        "qstart" : 1026,
        "qcovhsp" : 23,
        "shared_name" : "KfCluster-28526.1",
        "ppos" : 90.09,
        "score" : 724,
        "pident" : 78.448,
        "SUID" : 16722,
        "selected" : false,
        "sseqid" : "AT5G56000",
        "length" : 232,
        "nident" : 182,
        "evalue" : 1.0E-89,
        "positive" : 209,
        "gaps" : 1,
        "Type" : "protein_coding",
        "bitscore" : 283.0,
        "slen" : 699,
        "mismatch" : 49,
        "name" : "KfCluster-28526.1",
        "send" : 699,
        "qcovs" : 68,
        "PrimarySymbol" : "HEAT SHOCK PROTEIN 81.4 (Hsp81.4)",
        "qend" : 331
      },
      "position" : {
        "x" : 168.69148684578175,
        "y" : -3408.2984051807425
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16721",
        "Description" : "Encodes a cytosolic heat shock protein AtHSP90.1.  AtHSP90.1 interacts with disease resistance signaling components SGT1b and RAR1 and is required for RPS2-mediated resistance. The mRNA is cell-to-cell mobile.",
        "SecondarySymbol" : "HEAT SHOCK PROTEIN 81-1 (HSP81-1); (ATHS83); (HSP81.1);HEAT SHOCK PROTEIN 90.1 (HSP90.1);HEAT SHOCK PROTEIN 90.1 (ATHSP90.1);HEAT SHOCK PROTEIN 90-1 (AtHsp90-1);HEAT SHOCK PROTEIN 83 (HSP83)",
        "sstart" : 416,
        "qstart" : 1653,
        "qcovhsp" : 18,
        "shared_name" : "KfCluster-28526.0",
        "ppos" : 86.01,
        "score" : 887,
        "pident" : 76.792,
        "SUID" : 16721,
        "selected" : false,
        "sseqid" : "AT5G52640",
        "length" : 293,
        "nident" : 225,
        "evalue" : 6.11E-111,
        "positive" : 252,
        "gaps" : 4,
        "Type" : "protein_coding",
        "bitscore" : 346.0,
        "slen" : 705,
        "mismatch" : 64,
        "name" : "KfCluster-28526.0",
        "send" : 705,
        "qcovs" : 53,
        "PrimarySymbol" : "HEAT SHOCK PROTEIN 90.1 (HSP90.1)",
        "qend" : 778
      },
      "position" : {
        "x" : 50.1158871753716,
        "y" : -3349.3338055713675
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16720",
        "Description" : "\"Encodes a chloroplast-targeted 90-kDa heat shock protein located in the stroma involved in red-light mediated deetiolation response and crucial for protein import into the chloroplast stroma. Mutants are resistant to chlorate, have elongated hypocotyls in light, and affect the expression of NR2, CAB, and RBCS but NOT NR1 and NiR.\"",
        "SecondarySymbol" : "(CR88);HEAT SHOCK PROTEIN 88.1 (Hsp88.1);HEAT SHOCK PROTEIN 90.5 (HSP90.5);HEAT SHOCK PROTEIN 90.5 (AtHsp90.5);EMBRYO DEFECTIVE 1956 (emb1956); (ATHSP90C)",
        "sstart" : 46,
        "qstart" : 338,
        "qcovhsp" : 24,
        "shared_name" : "CrCluster-32138.1",
        "ppos" : 79.45,
        "score" : 2414,
        "pident" : 66.164,
        "SUID" : 16720,
        "selected" : false,
        "sseqid" : "AT2G04030",
        "length" : 730,
        "nident" : 483,
        "evalue" : 0.0,
        "positive" : 580,
        "gaps" : 36,
        "Type" : "protein_coding",
        "bitscore" : 934.0,
        "slen" : 780,
        "mismatch" : 211,
        "name" : "CrCluster-32138.1",
        "send" : 740,
        "qcovs" : 71,
        "PrimarySymbol" : "(CR88)",
        "qend" : 2524
      },
      "position" : {
        "x" : 117.0393262012505,
        "y" : -3433.9170575244925
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16719",
        "degree_layout" : 4,
        "Description" : "Required for flavonoid 3' hydroxylase activity. Enzyme abundance relative to CHS determines Quercetin/Kaempferol metabolite ratio. The mRNA is cell-to-cell mobile.",
        "SecondarySymbol" : "TRANSPARENT TESTA 7 (TT7); (D501);CYTOCHROME P450 75B1 (CYP75B1)",
        "sstart" : 73,
        "qstart" : 1866,
        "qcovhsp" : 19,
        "shared_name" : "PpCluster-25399.0",
        "ppos" : 51.97,
        "score" : 583,
        "pident" : 34.783,
        "SUID" : 16719,
        "selected" : false,
        "sseqid" : "AT5G07990",
        "length" : 483,
        "nident" : 168,
        "evalue" : 5.29E-66,
        "positive" : 251,
        "gaps" : 57,
        "Type" : "protein_coding",
        "bitscore" : 229.0,
        "slen" : 513,
        "mismatch" : 258,
        "name" : "PpCluster-25399.0",
        "send" : 503,
        "qcovs" : 57,
        "PrimarySymbol" : "TRANSPARENT TESTA 7 (TT7)",
        "qend" : 433
      },
      "position" : {
        "x" : -613.816162109375,
        "y" : -697.78857421875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16718",
        "degree_layout" : 8,
        "Description" : "Encodes a member of the cytochrome p450 family that serves as a control point between multiple photoreceptor systems and brassinosteroid signal transduction. Involved in brassinolide metabolism. Mediates response to a variety of light signals including hypocotyl elongation and cotyledon expansion.",
        "SecondarySymbol" : "PHYB ACTIVATION TAGGED SUPPRESSOR 1 (BAS1); (CYP72B1); (CYP734A1)",
        "sstart" : 13,
        "qstart" : 1061,
        "qcovhsp" : 15,
        "shared_name" : "KfCluster-7862.0",
        "ppos" : 40.32,
        "score" : 292,
        "pident" : 24.731,
        "SUID" : 16718,
        "selected" : false,
        "sseqid" : "AT2G26710",
        "length" : 558,
        "nident" : 138,
        "evalue" : 5.42E-27,
        "positive" : 225,
        "gaps" : 134,
        "Type" : "protein_coding",
        "bitscore" : 117.0,
        "slen" : 520,
        "mismatch" : 286,
        "name" : "KfCluster-7862.0",
        "send" : 489,
        "qcovs" : 44,
        "PrimarySymbol" : "PHYB ACTIVATION TAGGED SUPPRESSOR 1 (BAS1)",
        "qend" : 2575
      },
      "position" : {
        "x" : -148.27879333496094,
        "y" : -999.780029296875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16717",
        "degree_layout" : 4,
        "Description" : "Required for flavonoid 3' hydroxylase activity. Enzyme abundance relative to CHS determines Quercetin/Kaempferol metabolite ratio. The mRNA is cell-to-cell mobile.",
        "SecondarySymbol" : "TRANSPARENT TESTA 7 (TT7); (D501);CYTOCHROME P450 75B1 (CYP75B1)",
        "sstart" : 33,
        "qstart" : 219,
        "qcovhsp" : 17,
        "shared_name" : "CrCluster-30291.0",
        "ppos" : 52.43,
        "score" : 352,
        "pident" : 35.206,
        "SUID" : 16717,
        "selected" : false,
        "sseqid" : "AT5G07990",
        "length" : 267,
        "nident" : 94,
        "evalue" : 1.29E-66,
        "positive" : 140,
        "gaps" : 5,
        "Type" : "protein_coding",
        "bitscore" : 140.0,
        "slen" : 513,
        "mismatch" : 168,
        "name" : "CrCluster-30291.0",
        "send" : 297,
        "qcovs" : 52,
        "PrimarySymbol" : "TRANSPARENT TESTA 7 (TT7)",
        "qend" : 1010
      },
      "position" : {
        "x" : -382.7759094238281,
        "y" : -837.1575927734375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16714",
        "Description" : "Pectin lyase-like superfamily protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 97,
        "qstart" : 1439,
        "qcovhsp" : 12,
        "shared_name" : "PpCluster-18612.0",
        "ppos" : 69.8,
        "score" : 579,
        "pident" : 53.061,
        "SUID" : 16714,
        "selected" : false,
        "sseqid" : "AT2G36710",
        "length" : 245,
        "nident" : 130,
        "evalue" : 8.27E-68,
        "positive" : 171,
        "gaps" : 13,
        "Type" : "protein_coding",
        "bitscore" : 227.0,
        "slen" : 407,
        "mismatch" : 102,
        "name" : "PpCluster-18612.0",
        "send" : 339,
        "qcovs" : 36,
        "PrimarySymbol" : "0",
        "qend" : 738
      },
      "position" : {
        "x" : -1696.2373649776664,
        "y" : 262.89468309290066
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17731",
        "degree_layout" : 2,
        "Description" : "Ypt/Rab-GAP domain of gyp1p superfamily protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 403,
        "qstart" : 3112,
        "qcovhsp" : 4,
        "shared_name" : "SpCluster-461.1",
        "ppos" : 70.94,
        "score" : 349,
        "pident" : 50.427,
        "SUID" : 17731,
        "selected" : false,
        "sseqid" : "AT2G39280",
        "length" : 117,
        "nident" : 59,
        "evalue" : 2.01E-33,
        "positive" : 83,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 139.0,
        "slen" : 749,
        "mismatch" : 58,
        "name" : "SpCluster-461.1",
        "send" : 519,
        "qcovs" : 11,
        "PrimarySymbol" : "0",
        "qend" : 2762
      },
      "position" : {
        "x" : 962.02783203125,
        "y" : -1842.318359375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16713",
        "Description" : "Encodes an atypical pectin methylesterase that does not require salt for its activity and has a blockwise mode of pectin demethylesterification.",
        "SecondarySymbol" : "A. THALIANA PECTIN METHYLESTERASE 31 (ATPME31);PECTIN METHYLESTERASE 31 (PME31)",
        "sstart" : 14,
        "qstart" : 1114,
        "qcovhsp" : 9,
        "shared_name" : "KfCluster-5846.0",
        "ppos" : 51.72,
        "score" : 277,
        "pident" : 35.632,
        "SUID" : 16713,
        "selected" : false,
        "sseqid" : "AT3G29090",
        "length" : 174,
        "nident" : 62,
        "evalue" : 9.6E-27,
        "positive" : 90,
        "gaps" : 17,
        "Type" : "protein_coding",
        "bitscore" : 111.0,
        "slen" : 317,
        "mismatch" : 95,
        "name" : "KfCluster-5846.0",
        "send" : 183,
        "qcovs" : 27,
        "PrimarySymbol" : "PECTIN METHYLESTERASE 31 (PME31)",
        "qend" : 632
      },
      "position" : {
        "x" : -1677.6638786495414,
        "y" : 160.45497056848663
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16712",
        "Description" : "Pectin lyase-like superfamily protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 85,
        "qstart" : 1574,
        "qcovhsp" : 14,
        "shared_name" : "CrCluster-28590.0",
        "ppos" : 70.71,
        "score" : 891,
        "pident" : 55.219,
        "SUID" : 16712,
        "selected" : false,
        "sseqid" : "AT5G19730",
        "length" : 297,
        "nident" : 164,
        "evalue" : 7.01E-114,
        "positive" : 210,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 347.0,
        "slen" : 383,
        "mismatch" : 133,
        "name" : "CrCluster-28590.0",
        "send" : 381,
        "qcovs" : 43,
        "PrimarySymbol" : "0",
        "qend" : 684
      },
      "position" : {
        "x" : -1598.2568962276664,
        "y" : 227.75695726282257
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "18125",
        "degree_layout" : 2,
        "Description" : "",
        "SecondarySymbol" : "",
        "shared_name" : "SpCluster-7244.1",
        "SUID" : 18125,
        "selected" : false,
        "sseqid" : "",
        "Type" : "",
        "name" : "SpCluster-7244.1",
        "PrimarySymbol" : ""
      },
      "position" : {
        "x" : -2246.90234375,
        "y" : -816.7421264648438
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17730",
        "degree_layout" : 3,
        "Description" : "Ypt/Rab-GAP domain of gyp1p superfamily protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 201,
        "qstart" : 3014,
        "qcovhsp" : 15,
        "shared_name" : "PpCluster-21263.0",
        "ppos" : 56.94,
        "score" : 914,
        "pident" : 38.489,
        "SUID" : 17730,
        "selected" : false,
        "sseqid" : "AT3G55020",
        "length" : 569,
        "nident" : 219,
        "evalue" : 2.36E-107,
        "positive" : 324,
        "gaps" : 53,
        "Type" : "protein_coding",
        "bitscore" : 356.0,
        "slen" : 777,
        "mismatch" : 297,
        "name" : "PpCluster-21263.0",
        "send" : 735,
        "qcovs" : 44,
        "PrimarySymbol" : "0",
        "qend" : 1365
      },
      "position" : {
        "x" : 857.3563417648777,
        "y" : -1758.3429380202786
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16711",
        "degree_layout" : 3,
        "Description" : "Encodes an Arabidopsis Transmembrane nine (TMN) protein.  Transmembrane nine (TM9) proteins are localized in the secretory pathway of eukaryotic cells and are involved in cell adhesion and phagocytosis.  Overexpression of this protein in yeast alters copper and zinc homeostasis.",
        "SecondarySymbol" : "(AtTMN7);TRANSMEMBRANE NINE 7 (TMN7)",
        "sstart" : 27,
        "qstart" : 413,
        "qcovhsp" : 26,
        "shared_name" : "KfCluster-24246.0",
        "ppos" : 83.7,
        "score" : 1911,
        "pident" : 70.825,
        "SUID" : 16711,
        "selected" : false,
        "sseqid" : "AT3G13772",
        "length" : 497,
        "nident" : 352,
        "evalue" : 0.0,
        "positive" : 416,
        "gaps" : 3,
        "Type" : "protein_coding",
        "bitscore" : 740.0,
        "slen" : 641,
        "mismatch" : 142,
        "name" : "KfCluster-24246.0",
        "send" : 520,
        "qcovs" : 78,
        "PrimarySymbol" : "TRANSMEMBRANE NINE 7 (TMN7)",
        "qend" : 1903
      },
      "position" : {
        "x" : -775.8877563476562,
        "y" : -875.0209350585938
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "18124",
        "degree_layout" : 3,
        "Description" : "ENTH/VHS family protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 1,
        "qstart" : 1108,
        "qcovhsp" : 19,
        "shared_name" : "SpCluster-7244.0",
        "ppos" : 61.65,
        "score" : 564,
        "pident" : 46.617,
        "SUID" : 18124,
        "selected" : false,
        "sseqid" : "AT2G43160",
        "length" : 266,
        "nident" : 124,
        "evalue" : 8.76E-66,
        "positive" : 164,
        "gaps" : 32,
        "Type" : "protein_coding",
        "bitscore" : 221.0,
        "slen" : 646,
        "mismatch" : 110,
        "name" : "SpCluster-7244.0",
        "send" : 266,
        "qcovs" : 56,
        "PrimarySymbol" : "0",
        "qend" : 407
      },
      "position" : {
        "x" : -2135.752197265625,
        "y" : -864.9828491210938
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16710",
        "degree_layout" : 3,
        "Description" : "Encodes an Arabidopsis Transmembrane nine (TMN) protein.  Transmembrane nine (TM9) proteins are localized in the secretory pathway of eukaryotic cells and are involved in cell adhesion and phagocytosis.  Overexpression of this protein in yeast alters copper and zinc homeostasis.",
        "SecondarySymbol" : "(AtTMN7);TRANSMEMBRANE NINE 7 (TMN7)",
        "sstart" : 513,
        "qstart" : 837,
        "qcovhsp" : 15,
        "shared_name" : "KfCluster-14057.0",
        "ppos" : 96.12,
        "score" : 424,
        "pident" : 88.372,
        "SUID" : 16710,
        "selected" : false,
        "sseqid" : "AT3G13772",
        "length" : 129,
        "nident" : 114,
        "evalue" : 1.21E-47,
        "positive" : 124,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 167.0,
        "slen" : 641,
        "mismatch" : 15,
        "name" : "KfCluster-14057.0",
        "send" : 641,
        "qcovs" : 46,
        "PrimarySymbol" : "TRANSMEMBRANE NINE 7 (TMN7)",
        "qend" : 451
      },
      "position" : {
        "x" : -795.9037475585938,
        "y" : -624.9202270507812
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "18123",
        "degree_layout" : 1,
        "Description" : "organic cation/carnitine transporter 6;(source:Araport11)",
        "SecondarySymbol" : "ARABIDOPSIS THALIANA ORGANIC CATION/CARNITINE TRANSPORTER 6 (ATOCT6);ORGANIC CATION/CARNITINE TRANSPORTER 6 (OCT6)",
        "sstart" : 262,
        "qstart" : 148,
        "qcovhsp" : 7,
        "shared_name" : "SpCluster-7231.0",
        "ppos" : 48.65,
        "score" : 64,
        "pident" : 24.324,
        "SUID" : 18123,
        "selected" : false,
        "sseqid" : "AT1G16370",
        "length" : 74,
        "nident" : 18,
        "evalue" : 5.2,
        "positive" : 36,
        "gaps" : 1,
        "Type" : "protein_coding",
        "bitscore" : 29.3,
        "slen" : 521,
        "mismatch" : 55,
        "name" : "SpCluster-7231.0",
        "send" : 335,
        "qcovs" : 21,
        "PrimarySymbol" : "ORGANIC CATION/CARNITINE TRANSPORTER 6 (OCT6)",
        "qend" : 366
      },
      "position" : {
        "x" : -204.44908142089844,
        "y" : -1017.9815673828125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16709",
        "degree_layout" : 4,
        "Description" : "Endomembrane protein 70 protein family;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 51,
        "qstart" : 1748,
        "qcovhsp" : 22,
        "shared_name" : "CrCluster-27452.0",
        "ppos" : 85.06,
        "score" : 2034,
        "pident" : 72.325,
        "SUID" : 16709,
        "selected" : false,
        "sseqid" : "AT2G01970",
        "length" : 542,
        "nident" : 392,
        "evalue" : 0.0,
        "positive" : 461,
        "gaps" : 2,
        "Type" : "protein_coding",
        "bitscore" : 788.0,
        "slen" : 592,
        "mismatch" : 148,
        "name" : "CrCluster-27452.0",
        "send" : 592,
        "qcovs" : 67,
        "PrimarySymbol" : "0",
        "qend" : 129
      },
      "position" : {
        "x" : -792.1802978515625,
        "y" : -701.34619140625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17727",
        "degree_layout" : 1,
        "Description" : "cyclin-like protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 454,
        "qstart" : 3592,
        "qcovhsp" : 1,
        "shared_name" : "PpCluster-21168.0",
        "ppos" : 75.0,
        "score" : 162,
        "pident" : 61.538,
        "SUID" : 17727,
        "selected" : false,
        "sseqid" : "AT1G70620",
        "length" : 52,
        "nident" : 32,
        "evalue" : 1.0E-10,
        "positive" : 39,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 67.0,
        "slen" : 897,
        "mismatch" : 20,
        "name" : "PpCluster-21168.0",
        "send" : 505,
        "qcovs" : 3,
        "PrimarySymbol" : "0",
        "qend" : 3437
      },
      "position" : {
        "x" : 1017.4696044921875,
        "y" : -1372.500244140625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16708",
        "degree_layout" : 8,
        "Description" : "\"Encodes a member of the DREB subfamily A-5 of ERF/AP2 transcription factor family. The protein contains one AP2 domain. Involved in defense and freezing stress responses. There are 16 members in this subfamily including RAP2.1, RAP2.9 and RAP2.10. The mRNA is cell-to-cell mobile.\"",
        "SecondarySymbol" : "COOPERATIVELY REGULATED BY ETHYLENE AND JASMONATE 1 (CEJ1);DREB AND EAR MOTIF PROTEIN 1 (DEAR1); (ATERF#011)",
        "sstart" : 14,
        "qstart" : 828,
        "qcovhsp" : 3,
        "shared_name" : "CrCluster-24540.0",
        "ppos" : 73.91,
        "score" : 194,
        "pident" : 65.217,
        "SUID" : 16708,
        "selected" : false,
        "sseqid" : "AT3G50260",
        "length" : 69,
        "nident" : 45,
        "evalue" : 4.54E-17,
        "positive" : 51,
        "gaps" : 1,
        "Type" : "protein_coding",
        "bitscore" : 79.3,
        "slen" : 153,
        "mismatch" : 23,
        "name" : "CrCluster-24540.0",
        "send" : 81,
        "qcovs" : 8,
        "PrimarySymbol" : "COOPERATIVELY REGULATED BY ETHYLENE AND JASMONATE 1 (CEJ1)",
        "qend" : 1034
      },
      "position" : {
        "x" : -854.9489351980376,
        "y" : 153.25400669649366
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16703",
        "degree_layout" : 17,
        "Description" : "Encodes a  plastidial nucleotide uniport   carrier protein required to export newly synthesized adenylates into the cytosol.",
        "SecondarySymbol" : "EMBRYO DEFECTIVE 104 (EMB104);ARABIDOPSIS THALIANA BRITTLE 1 (ATBT1);EMBRYO DEFECTIVE 42 (EMB42);SODIUM HYPERSENSITIVE 1 (SHS1)",
        "sstart" : 114,
        "qstart" : 1296,
        "qcovhsp" : 13,
        "shared_name" : "KfCluster-27330.0",
        "ppos" : 77.78,
        "score" : 837,
        "pident" : 61.29,
        "SUID" : 16703,
        "selected" : false,
        "sseqid" : "AT4G32400",
        "length" : 279,
        "nident" : 171,
        "evalue" : 2.74E-105,
        "positive" : 217,
        "gaps" : 5,
        "Type" : "protein_coding",
        "bitscore" : 327.0,
        "slen" : 392,
        "mismatch" : 103,
        "name" : "KfCluster-27330.0",
        "send" : 388,
        "qcovs" : 38,
        "PrimarySymbol" : "SODIUM HYPERSENSITIVE 1 (SHS1)",
        "qend" : 463
      },
      "position" : {
        "x" : -1375.3446017932663,
        "y" : -1499.354736328125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16702",
        "degree_layout" : 4,
        "Description" : "Encodes a mitochondrial phosphate transporter. Modulates plant responses to salt stress.",
        "SecondarySymbol" : "MITOCHONDRIAL PHOSPHATE TRANSPORTER 3 (MPT3);PHOSPHATE TRANSPORTER 3;1 (PHT3;1)",
        "sstart" : 221,
        "qstart" : 1068,
        "qcovhsp" : 13,
        "shared_name" : "KfCluster-26075.0",
        "ppos" : 88.57,
        "score" : 608,
        "pident" : 79.286,
        "SUID" : 16702,
        "selected" : false,
        "sseqid" : "AT5G14040",
        "length" : 140,
        "nident" : 111,
        "evalue" : 6.16E-76,
        "positive" : 124,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 238.0,
        "slen" : 375,
        "mismatch" : 29,
        "name" : "KfCluster-26075.0",
        "send" : 360,
        "qcovs" : 39,
        "PrimarySymbol" : "PHOSPHATE TRANSPORTER 3;1 (PHT3;1)",
        "qend" : 649
      },
      "position" : {
        "x" : -1569.0028049182663,
        "y" : -1612.385009765625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16701",
        "degree_layout" : 13,
        "Description" : "Mitochondrial substrate carrier family protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 68,
        "qstart" : 1360,
        "qcovhsp" : 13,
        "shared_name" : "KfCluster-1570.0",
        "ppos" : 76.9,
        "score" : 927,
        "pident" : 58.746,
        "SUID" : 16701,
        "selected" : false,
        "sseqid" : "AT3G51870",
        "length" : 303,
        "nident" : 178,
        "evalue" : 1.36E-118,
        "positive" : 233,
        "gaps" : 2,
        "Type" : "protein_coding",
        "bitscore" : 361.0,
        "slen" : 381,
        "mismatch" : 123,
        "name" : "KfCluster-1570.0",
        "send" : 370,
        "qcovs" : 40,
        "PrimarySymbol" : "0",
        "qend" : 458
      },
      "position" : {
        "x" : -1424.3397189807663,
        "y" : -1517.74658203125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16700",
        "degree_layout" : 6,
        "Description" : "Encodes a mitochondrial phosphate transporter. Modulates plant responses to salt stress.",
        "SecondarySymbol" : "MITOCHONDRIAL PHOSPHATE TRANSPORTER 2 (MPT2);PHOSPHATE TRANSPORTER 3;2 (PHT3;2)",
        "sstart" : 9,
        "qstart" : 1511,
        "qcovhsp" : 18,
        "shared_name" : "KfCluster-13423.0",
        "ppos" : 69.72,
        "score" : 1020,
        "pident" : 56.389,
        "SUID" : 16700,
        "selected" : false,
        "sseqid" : "AT3G48850",
        "length" : 360,
        "nident" : 203,
        "evalue" : 1.36E-133,
        "positive" : 251,
        "gaps" : 18,
        "Type" : "protein_coding",
        "bitscore" : 397.0,
        "slen" : 363,
        "mismatch" : 139,
        "name" : "KfCluster-13423.0",
        "send" : 350,
        "qcovs" : 53,
        "PrimarySymbol" : "PHOSPHATE TRANSPORTER 3;2 (PHT3;2)",
        "qend" : 432
      },
      "position" : {
        "x" : -1466.5948459338913,
        "y" : -1549.1329345703125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16699",
        "degree_layout" : 9,
        "Description" : "Encodes a mitochondrial phosphate transporter. Modulates plant responses to salt stress.",
        "SecondarySymbol" : "MITOCHONDRIAL PHOSPHATE TRANSPORTER 3 (MPT3);PHOSPHATE TRANSPORTER 3;1 (PHT3;1)",
        "sstart" : 57,
        "qstart" : 1810,
        "qcovhsp" : 14,
        "shared_name" : "CrCluster-20111.1",
        "ppos" : 92.83,
        "score" : 1341,
        "pident" : 85.016,
        "SUID" : 16699,
        "selected" : false,
        "sseqid" : "AT5G14040",
        "length" : 307,
        "nident" : 261,
        "evalue" : 0.0,
        "positive" : 285,
        "gaps" : 1,
        "Type" : "protein_coding",
        "bitscore" : 521.0,
        "slen" : 375,
        "mismatch" : 45,
        "name" : "CrCluster-20111.1",
        "send" : 363,
        "qcovs" : 43,
        "PrimarySymbol" : "PHOSPHATE TRANSPORTER 3;1 (PHT3;1)",
        "qend" : 893
      },
      "position" : {
        "x" : -1453.2159396838913,
        "y" : -1621.1689453125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "18122",
        "degree_layout" : 1,
        "Description" : "pentatricopeptide (PPR) repeat-containing protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 755,
        "qstart" : 211,
        "qcovhsp" : 11,
        "shared_name" : "SpCluster-7195.2",
        "ppos" : 58.54,
        "score" : 59,
        "pident" : 31.707,
        "SUID" : 18122,
        "selected" : false,
        "sseqid" : "AT5G12100",
        "length" : 41,
        "nident" : 13,
        "evalue" : 3.3,
        "positive" : 24,
        "gaps" : 2,
        "Type" : "protein_coding",
        "bitscore" : 27.3,
        "slen" : 816,
        "mismatch" : 26,
        "name" : "SpCluster-7195.2",
        "send" : 795,
        "qcovs" : 34,
        "PrimarySymbol" : "0",
        "qend" : 95
      },
      "position" : {
        "x" : 1679.3820563851732,
        "y" : -2878.5199958382977
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "18121",
        "degree_layout" : 1,
        "Description" : "",
        "SecondarySymbol" : "",
        "shared_name" : "SpCluster-7195.29",
        "SUID" : 18121,
        "selected" : false,
        "sseqid" : "",
        "Type" : "",
        "name" : "SpCluster-7195.29",
        "PrimarySymbol" : ""
      },
      "position" : {
        "x" : 2032.4362556039232,
        "y" : -2670.2197028695477
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "18120",
        "degree_layout" : 6,
        "Description" : "",
        "SecondarySymbol" : "",
        "shared_name" : "SpCluster-7195.30",
        "SUID" : 18120,
        "selected" : false,
        "sseqid" : "",
        "Type" : "",
        "name" : "SpCluster-7195.30",
        "PrimarySymbol" : ""
      },
      "position" : {
        "x" : 1702.2472907601732,
        "y" : -2754.1659919320477
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17726",
        "Description" : "Encodes EXORDIUM LIKE 7.",
        "SecondarySymbol" : "EXORDIUM LIKE 7 (EXL7);EXORDIUM LIKE 1 (EXL1)",
        "sstart" : 34,
        "qstart" : 249,
        "qcovhsp" : 16,
        "shared_name" : "SpCluster-4914.3",
        "ppos" : 50.69,
        "score" : 254,
        "pident" : 26.728,
        "SUID" : 17726,
        "selected" : false,
        "sseqid" : "AT2G35150",
        "length" : 217,
        "nident" : 58,
        "evalue" : 2.8E-24,
        "positive" : 110,
        "gaps" : 25,
        "Type" : "protein_coding",
        "bitscore" : 102.0,
        "slen" : 323,
        "mismatch" : 134,
        "name" : "SpCluster-4914.3",
        "send" : 245,
        "qcovs" : 47,
        "PrimarySymbol" : "EXORDIUM LIKE 7 (EXL7)",
        "qend" : 839
      },
      "position" : {
        "x" : -1569.3390805682332,
        "y" : -3546.316177489321
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "18119",
        "degree_layout" : 8,
        "Description" : "\"Mutant has early-flowering phenotype, encodes a putative nucleoporin. Required for the activation of downstream defense pathways by the snc1 mutation. Involved in basal resistance against bacterial pathogens.\"",
        "SecondarySymbol" : "\"PRECOCIOUS (PRE);MODIFIER OF SNC1,3 (MOS3);SUPPRESSOR OF AUXIN RESISTANCE 3 (SAR3); (NUP96)\"",
        "sstart" : 46,
        "qstart" : 195,
        "qcovhsp" : 18,
        "shared_name" : "SpCluster-7195.41",
        "ppos" : 70.97,
        "score" : 188,
        "pident" : 56.452,
        "SUID" : 18119,
        "selected" : false,
        "sseqid" : "AT1G80680",
        "length" : 62,
        "nident" : 35,
        "evalue" : 1.5E-17,
        "positive" : 44,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 77.0,
        "slen" : 1046,
        "mismatch" : 27,
        "name" : "SpCluster-7195.41",
        "send" : 107,
        "qcovs" : 55,
        "PrimarySymbol" : "SUPPRESSOR OF AUXIN RESISTANCE 3 (SAR3)",
        "qend" : 10
      },
      "position" : {
        "x" : 2000.6249763070482,
        "y" : -2605.5505134164227
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16683",
        "degree_layout" : 9,
        "Description" : "\"Encodes a member of the DREB subfamily A-5 of ERF/AP2 transcription factor family. The protein contains one AP2 domain. Involved in defense and freezing stress responses. There are 16 members in this subfamily including RAP2.1, RAP2.9 and RAP2.10. The mRNA is cell-to-cell mobile.\"",
        "SecondarySymbol" : "COOPERATIVELY REGULATED BY ETHYLENE AND JASMONATE 1 (CEJ1);DREB AND EAR MOTIF PROTEIN 1 (DEAR1); (ATERF#011)",
        "sstart" : 16,
        "qstart" : 854,
        "qcovhsp" : 6,
        "shared_name" : "SpCluster-8332.0",
        "ppos" : 60.0,
        "score" : 187,
        "pident" : 45.455,
        "SUID" : 16683,
        "selected" : false,
        "sseqid" : "AT3G50260",
        "length" : 110,
        "nident" : 50,
        "evalue" : 2.53E-16,
        "positive" : 66,
        "gaps" : 9,
        "Type" : "protein_coding",
        "bitscore" : 76.6,
        "slen" : 153,
        "mismatch" : 51,
        "name" : "SpCluster-8332.0",
        "send" : 116,
        "qcovs" : 18,
        "PrimarySymbol" : "COOPERATIVELY REGULATED BY ETHYLENE AND JASMONATE 1 (CEJ1)",
        "qend" : 1183
      },
      "position" : {
        "x" : -784.5623385183501,
        "y" : 108.98227055147413
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17725",
        "degree_layout" : 3,
        "Description" : "pentatricopeptide (PPR) repeat-containing protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 80,
        "qstart" : 1619,
        "qcovhsp" : 13,
        "shared_name" : "PpCluster-20989.0",
        "ppos" : 60.0,
        "score" : 574,
        "pident" : 38.769,
        "SUID" : 17725,
        "selected" : false,
        "sseqid" : "AT2G30100",
        "length" : 325,
        "nident" : 126,
        "evalue" : 7.78E-65,
        "positive" : 195,
        "gaps" : 14,
        "Type" : "protein_coding",
        "bitscore" : 225.0,
        "slen" : 503,
        "mismatch" : 185,
        "name" : "PpCluster-20989.0",
        "send" : 404,
        "qcovs" : 38,
        "PrimarySymbol" : "0",
        "qend" : 687
      },
      "position" : {
        "x" : -397.61492919921875,
        "y" : -2098.23046875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "18118",
        "degree_layout" : 12,
        "Description" : "Encodes a protein with similarity to mammalian nucleoporin Nup98.Its expression is upregulated in mutants that are NUP deficient.",
        "SecondarySymbol" : "DRA2-LIKE (DRAL)",
        "sstart" : 845,
        "qstart" : 682,
        "qcovhsp" : 9,
        "shared_name" : "SpCluster-7195.28",
        "ppos" : 67.78,
        "score" : 208,
        "pident" : 56.667,
        "SUID" : 18118,
        "selected" : false,
        "sseqid" : "AT1G59660",
        "length" : 90,
        "nident" : 51,
        "evalue" : 8.52E-18,
        "positive" : 61,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 84.7,
        "slen" : 997,
        "mismatch" : 39,
        "name" : "SpCluster-7195.28",
        "send" : 934,
        "qcovs" : 26,
        "PrimarySymbol" : "DRA2-LIKE (DRAL)",
        "qend" : 413
      },
      "position" : {
        "x" : 1889.8545905648607,
        "y" : -2572.7558356820477
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16682",
        "degree_layout" : 9,
        "Description" : "\"encodes a member of the ERF (ethylene response factor) subfamily B-1 of ERF/AP2 transcription factor family. The protein contains one AP2 domain. There are 15 members in this subfamily including ATERF-3, ATERF-4, ATERF-7, and leafy petiole.\"",
        "SecondarySymbol" : "0",
        "sstart" : 115,
        "qstart" : 964,
        "qcovhsp" : 6,
        "shared_name" : "PpCluster-7867.0",
        "ppos" : 93.33,
        "score" : 175,
        "pident" : 83.333,
        "SUID" : 16682,
        "selected" : false,
        "sseqid" : "AT1G80580",
        "length" : 60,
        "nident" : 50,
        "evalue" : 2.46E-14,
        "positive" : 56,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 72.0,
        "slen" : 256,
        "mismatch" : 10,
        "name" : "PpCluster-7867.0",
        "send" : 174,
        "qcovs" : 18,
        "PrimarySymbol" : "0",
        "qend" : 785
      },
      "position" : {
        "x" : -768.7901217214751,
        "y" : 178.49094517305616
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16681",
        "degree_layout" : 7,
        "Description" : "\"Encodes a member of the ERF (ethylene response factor) subfamily B-1 of ERF/AP2 transcription factor family (LEAFY PETIOLE). The protein contains one AP2 domain. There are 15 members in this subfamily including ATERF-3, ATERF-4, ATERF-7, and LEAFY PETIOLE.  Acts as a positive regulator of gibberellic acid-induced germination.\"",
        "SecondarySymbol" : "LEAFY PETIOLE (LEP)",
        "sstart" : 31,
        "qstart" : 291,
        "qcovhsp" : 2,
        "shared_name" : "MpCluster-4477.0",
        "ppos" : 76.79,
        "score" : 156,
        "pident" : 69.643,
        "SUID" : 16681,
        "selected" : false,
        "sseqid" : "AT5G13910",
        "length" : 56,
        "nident" : 39,
        "evalue" : 1.86E-11,
        "positive" : 43,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 64.7,
        "slen" : 211,
        "mismatch" : 17,
        "name" : "MpCluster-4477.0",
        "send" : 86,
        "qcovs" : 6,
        "PrimarySymbol" : "LEAFY PETIOLE (LEP)",
        "qend" : 458
      },
      "position" : {
        "x" : -695.4350191824126,
        "y" : 147.61957676485304
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "18117",
        "degree_layout" : 12,
        "Description" : "",
        "SecondarySymbol" : "",
        "shared_name" : "SpCluster-7195.61",
        "SUID" : 18117,
        "selected" : false,
        "sseqid" : "",
        "Type" : "",
        "name" : "SpCluster-7195.61",
        "PrimarySymbol" : ""
      },
      "position" : {
        "x" : 1825.5057136117357,
        "y" : -2707.5453864632977
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16680",
        "degree_layout" : 4,
        "Description" : "Encodes an AP2/B3 domain transcription factor which is upregulated in response to low temperature. It contains a B3 DNA binding domain. It has circadian regulation and may function as a negative growth regulator. The mRNA is cell-to-cell mobile.",
        "SecondarySymbol" : "RELATED TO ABI3/VP1 1 (RAV1); (ATRAV1);ETHYLENE RESPONSE DNA BINDING FACTOR 4 (EDF4)",
        "sstart" : 51,
        "qstart" : 1514,
        "qcovhsp" : 5,
        "shared_name" : "AaCluster-9093.0",
        "ppos" : 82.69,
        "score" : 410,
        "pident" : 72.115,
        "SUID" : 16680,
        "selected" : false,
        "sseqid" : "AT1G13260",
        "length" : 104,
        "nident" : 75,
        "evalue" : 1.71E-44,
        "positive" : 86,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 162.0,
        "slen" : 344,
        "mismatch" : 29,
        "name" : "AaCluster-9093.0",
        "send" : 154,
        "qcovs" : 16,
        "PrimarySymbol" : "RELATED TO ABI3/VP1 1 (RAV1)",
        "qend" : 1825
      },
      "position" : {
        "x" : -692.6744601003813,
        "y" : 77.85794956758741
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "18116",
        "degree_layout" : 13,
        "Description" : "Encodes a protein with similarity to mammalian nucleoporin Nup98.Its expression is upregulated in mutants that are NUP deficient.",
        "SecondarySymbol" : "DRA2-LIKE (DRAL)",
        "sstart" : 847,
        "qstart" : 652,
        "qcovhsp" : 9,
        "shared_name" : "SpCluster-7195.54",
        "ppos" : 68.18,
        "score" : 205,
        "pident" : 55.682,
        "SUID" : 18116,
        "selected" : false,
        "sseqid" : "AT1G59660",
        "length" : 88,
        "nident" : 49,
        "evalue" : 1.25E-17,
        "positive" : 60,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 83.6,
        "slen" : 997,
        "mismatch" : 39,
        "name" : "SpCluster-7195.54",
        "send" : 934,
        "qcovs" : 28,
        "PrimarySymbol" : "DRA2-LIKE (DRAL)",
        "qend" : 389
      },
      "position" : {
        "x" : 1911.1790534554857,
        "y" : -2622.8835212289227
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "18115",
        "degree_layout" : 9,
        "Description" : "Ribosomal L32p protein family;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 21,
        "qstart" : 308,
        "qcovhsp" : 14,
        "shared_name" : "SpCluster-7195.50",
        "ppos" : 56.82,
        "score" : 57,
        "pident" : 27.273,
        "SUID" : 18115,
        "selected" : false,
        "sseqid" : "AT1G26740",
        "length" : 44,
        "nident" : 12,
        "evalue" : 3.2,
        "positive" : 25,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 26.6,
        "slen" : 134,
        "mismatch" : 32,
        "name" : "SpCluster-7195.50",
        "send" : 64,
        "qcovs" : 43,
        "PrimarySymbol" : "0",
        "qend" : 177
      },
      "position" : {
        "x" : 1822.2044440804857,
        "y" : -2662.9111091195477
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "18114",
        "degree_layout" : 12,
        "Description" : "Disease resistance protein (TIR-NBS-LRR class) family;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 902,
        "qstart" : 213,
        "qcovhsp" : 8,
        "shared_name" : "SpCluster-7195.43",
        "ppos" : 49.18,
        "score" : 64,
        "pident" : 32.787,
        "SUID" : 18114,
        "selected" : false,
        "sseqid" : "AT5G45200",
        "length" : 61,
        "nident" : 20,
        "evalue" : 2.7,
        "positive" : 30,
        "gaps" : 13,
        "Type" : "protein_coding",
        "bitscore" : 29.3,
        "slen" : 1261,
        "mismatch" : 28,
        "name" : "SpCluster-7195.43",
        "send" : 961,
        "qcovs" : 23,
        "PrimarySymbol" : "0",
        "qend" : 359
      },
      "position" : {
        "x" : 1793.8100349007982,
        "y" : -2784.6347419320477
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "18113",
        "degree_layout" : 10,
        "Description" : "\"methylenetetrahydrofolate reductase MTHFR1 mRNA, complete\"",
        "SecondarySymbol" : "METHYLENETETRAHYDROFOLATE REDUCTASE 1 (MTHFR1)",
        "sstart" : 322,
        "qstart" : 531,
        "qcovhsp" : 12,
        "shared_name" : "SpCluster-7195.18",
        "ppos" : 50.51,
        "score" : 66,
        "pident" : 22.222,
        "SUID" : 18113,
        "selected" : false,
        "sseqid" : "AT3G59970",
        "length" : 99,
        "nident" : 22,
        "evalue" : 1.6,
        "positive" : 50,
        "gaps" : 13,
        "Type" : "protein_coding",
        "bitscore" : 30.0,
        "slen" : 421,
        "mismatch" : 64,
        "name" : "SpCluster-7195.18",
        "send" : 419,
        "qcovs" : 36,
        "PrimarySymbol" : "METHYLENETETRAHYDROFOLATE REDUCTASE 1 (MTHFR1)",
        "qend" : 271
      },
      "position" : {
        "x" : 1769.6706306039232,
        "y" : -2675.8154059945477
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16676",
        "degree_layout" : 4,
        "Description" : "Encodes a telomeric DNA-binding protein.",
        "SecondarySymbol" : "TELOMERIC DNA-BINDING PROTEIN 2 (ATTBP2);TRF-LIKE 9 (TRFL9)",
        "sstart" : 486,
        "qstart" : 1462,
        "qcovhsp" : 6,
        "shared_name" : "PpCluster-26263.1",
        "ppos" : 79.82,
        "score" : 435,
        "pident" : 71.053,
        "SUID" : 16676,
        "selected" : false,
        "sseqid" : "AT3G12560",
        "length" : 114,
        "nident" : 81,
        "evalue" : 8.73E-46,
        "positive" : 91,
        "gaps" : 1,
        "Type" : "protein_coding",
        "bitscore" : 172.0,
        "slen" : 619,
        "mismatch" : 32,
        "name" : "PpCluster-26263.1",
        "send" : 598,
        "qcovs" : 18,
        "PrimarySymbol" : "TRF-LIKE 9 (TRFL9)",
        "qend" : 1803
      },
      "position" : {
        "x" : -99.91400146484375,
        "y" : -1234.2457275390625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "18112",
        "degree_layout" : 16,
        "Description" : "Encodes a protein with similarity to mammalian nucleoporin Nup98.Its expression is upregulated in mutants that are NUP deficient.",
        "SecondarySymbol" : "DRA2-LIKE (DRAL)",
        "sstart" : 845,
        "qstart" : 949,
        "qcovhsp" : 7,
        "shared_name" : "SpCluster-7195.16",
        "ppos" : 67.78,
        "score" : 211,
        "pident" : 57.778,
        "SUID" : 18112,
        "selected" : false,
        "sseqid" : "AT1G59660",
        "length" : 90,
        "nident" : 52,
        "evalue" : 1.17E-17,
        "positive" : 61,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 85.9,
        "slen" : 997,
        "mismatch" : 38,
        "name" : "SpCluster-7195.16",
        "send" : 934,
        "qcovs" : 21,
        "PrimarySymbol" : "DRA2-LIKE (DRAL)",
        "qend" : 680
      },
      "position" : {
        "x" : 1929.2610847054857,
        "y" : -2682.7851325570477
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "18111",
        "degree_layout" : 11,
        "Description" : "",
        "SecondarySymbol" : "",
        "shared_name" : "SpCluster-7195.10",
        "SUID" : 18111,
        "selected" : false,
        "sseqid" : "",
        "Type" : "",
        "name" : "SpCluster-7195.10",
        "PrimarySymbol" : ""
      },
      "position" : {
        "x" : 1875.4627448617357,
        "y" : -2760.8715583382977
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16675",
        "degree_layout" : 20,
        "Description" : "Stromal heat shock protein involved in protein import into chloroplast. The mRNA is cell-to-cell mobile.",
        "SecondarySymbol" : "CHLOROPLAST HEAT SHOCK PROTEIN 70-2 (CPHSC70-2EAT SHOCK PROTEIN 70-2);CHLOROPLAST HEAT SHOCK PROTEIN 70-2 (cpHsc70-2);HEAT SHOCK PROTEIN 70-7 (HSC70-7)",
        "sstart" : 73,
        "qstart" : 991,
        "qcovhsp" : 29,
        "shared_name" : "KfCluster-26549.0",
        "ppos" : 93.94,
        "score" : 1533,
        "pident" : 86.97,
        "SUID" : 16675,
        "selected" : false,
        "sseqid" : "AT5G49910",
        "length" : 330,
        "nident" : 287,
        "evalue" : 0.0,
        "positive" : 310,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 595.0,
        "slen" : 718,
        "mismatch" : 43,
        "name" : "KfCluster-26549.0",
        "send" : 402,
        "qcovs" : 86,
        "PrimarySymbol" : "CHLOROPLAST HEAT SHOCK PROTEIN 70-2 (cpHsc70-2)",
        "qend" : 2
      },
      "position" : {
        "x" : -403.7279357910156,
        "y" : -1307.2432861328125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16674",
        "degree_layout" : 3,
        "Description" : "serine carboxypeptidase-like 9;(source:Araport11)",
        "SecondarySymbol" : "SERINE CARBOXYPEPTIDASE-LIKE 9 (SCPL9)",
        "sstart" : 56,
        "qstart" : 46,
        "qcovhsp" : 4,
        "shared_name" : "AaCluster-8963.1521",
        "ppos" : 42.68,
        "score" : 81,
        "pident" : 28.049,
        "SUID" : 16674,
        "selected" : false,
        "sseqid" : "AT2G23010",
        "length" : 82,
        "nident" : 23,
        "evalue" : 0.092,
        "positive" : 35,
        "gaps" : 8,
        "Type" : "protein_coding",
        "bitscore" : 35.8,
        "slen" : 437,
        "mismatch" : 51,
        "name" : "AaCluster-8963.1521",
        "send" : 135,
        "qcovs" : 11,
        "PrimarySymbol" : "SERINE CARBOXYPEPTIDASE-LIKE 9 (SCPL9)",
        "qend" : 273
      },
      "position" : {
        "x" : -299.2805480957031,
        "y" : -1215.6939697265625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17724",
        "degree_layout" : 7,
        "Description" : "zinc finger (CCCH type) helicase family protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 322,
        "qstart" : 121,
        "qcovhsp" : 10,
        "shared_name" : "SpCluster-17700.0",
        "ppos" : 56.74,
        "score" : 408,
        "pident" : 38.764,
        "SUID" : 17724,
        "selected" : false,
        "sseqid" : "AT2G47680",
        "length" : 356,
        "nident" : 138,
        "evalue" : 4.07E-40,
        "positive" : 202,
        "gaps" : 24,
        "Type" : "protein_coding",
        "bitscore" : 161.0,
        "slen" : 1015,
        "mismatch" : 194,
        "name" : "SpCluster-17700.0",
        "send" : 654,
        "qcovs" : 31,
        "PrimarySymbol" : "0",
        "qend" : 1185
      },
      "position" : {
        "x" : -194.78308375360885,
        "y" : -2758.313232421875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16673",
        "degree_layout" : 7,
        "Description" : "disease resistance protein (TIR-NBS-LRR class);(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 729,
        "qstart" : 692,
        "qcovhsp" : 20,
        "shared_name" : "SpCluster-10653.0",
        "ppos" : 47.71,
        "score" : 397,
        "pident" : 33.277,
        "SUID" : 16673,
        "selected" : false,
        "sseqid" : "AT1G69550",
        "length" : 589,
        "nident" : 196,
        "evalue" : 8.4E-39,
        "positive" : 281,
        "gaps" : 90,
        "Type" : "protein_coding",
        "bitscore" : 157.0,
        "slen" : 1400,
        "mismatch" : 303,
        "name" : "SpCluster-10653.0",
        "send" : 1236,
        "qcovs" : 59,
        "PrimarySymbol" : "0",
        "qend" : 2431
      },
      "position" : {
        "x" : -155.44491577148438,
        "y" : -1649.0604248046875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "18110",
        "degree_layout" : 2,
        "Description" : "DEA(D/H)-box RNA helicase family protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 1016,
        "qstart" : 169,
        "qcovhsp" : 19,
        "shared_name" : "SpCluster-7050.25",
        "ppos" : 60.98,
        "score" : 62,
        "pident" : 39.024,
        "SUID" : 18110,
        "selected" : false,
        "sseqid" : "AT1G48650",
        "length" : 41,
        "nident" : 16,
        "evalue" : 0.42,
        "positive" : 25,
        "gaps" : 2,
        "Type" : "protein_coding",
        "bitscore" : 28.5,
        "slen" : 1197,
        "mismatch" : 23,
        "name" : "SpCluster-7050.25",
        "send" : 1054,
        "qcovs" : 56,
        "PrimarySymbol" : "0",
        "qend" : 47
      },
      "position" : {
        "x" : 880.1064453125,
        "y" : 22.20640912672455
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "18109",
        "degree_layout" : 6,
        "Description" : "GTP binding Elongation factor Tu family protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 300,
        "qstart" : 330,
        "qcovhsp" : 18,
        "shared_name" : "SpCluster-7050.3",
        "ppos" : 86.67,
        "score" : 254,
        "pident" : 78.333,
        "SUID" : 18109,
        "selected" : false,
        "sseqid" : "AT1G07930",
        "length" : 60,
        "nident" : 47,
        "evalue" : 3.7E-27,
        "positive" : 52,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 102.0,
        "slen" : 372,
        "mismatch" : 13,
        "name" : "SpCluster-7050.3",
        "send" : 359,
        "qcovs" : 53,
        "PrimarySymbol" : "0",
        "qend" : 151
      },
      "position" : {
        "x" : 961.7402122835447,
        "y" : -82.20028686523438
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "18108",
        "degree_layout" : 4,
        "Description" : "GTP binding Elongation factor Tu family protein;(source:Araport11)",
        "SecondarySymbol" : "(EF1ALPHA)",
        "sstart" : 277,
        "qstart" : 262,
        "qcovhsp" : 33,
        "shared_name" : "SpCluster-7050.16",
        "ppos" : 93.1,
        "score" : 331,
        "pident" : 83.908,
        "SUID" : 18108,
        "selected" : false,
        "sseqid" : "AT5G60390",
        "length" : 87,
        "nident" : 73,
        "evalue" : 1.37E-38,
        "positive" : 81,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 132.0,
        "slen" : 400,
        "mismatch" : 14,
        "name" : "SpCluster-7050.16",
        "send" : 363,
        "qcovs" : 99,
        "PrimarySymbol" : "(EF1ALPHA)",
        "qend" : 2
      },
      "position" : {
        "x" : 926.5886619905759,
        "y" : -160.01651000976562
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "18107",
        "degree_layout" : 6,
        "Description" : "GTP binding Elongation factor Tu family protein;(source:Araport11)",
        "SecondarySymbol" : "(EF1ALPHA)",
        "sstart" : 260,
        "qstart" : 291,
        "qcovhsp" : 33,
        "shared_name" : "SpCluster-7050.11",
        "ppos" : 90.72,
        "score" : 428,
        "pident" : 82.474,
        "SUID" : 18107,
        "selected" : false,
        "sseqid" : "AT5G60390",
        "length" : 97,
        "nident" : 80,
        "evalue" : 9.3E-53,
        "positive" : 88,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 169.0,
        "slen" : 400,
        "mismatch" : 17,
        "name" : "SpCluster-7050.11",
        "send" : 356,
        "qcovs" : 99,
        "PrimarySymbol" : "(EF1ALPHA)",
        "qend" : 1
      },
      "position" : {
        "x" : 981.5140159944822,
        "y" : -236.68087768554688
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16672",
        "Description" : "germin-like protein (GLP1)",
        "SecondarySymbol" : "GERMIN-LIKE PROTEIN 1 (GLP1);A. THALIANA GERMIN-LIKE PROTEIN 1 (ATGER1);GERMIN-LIKE PROTEIN 1 (GER1)",
        "sstart" : 1,
        "qstart" : 71,
        "qcovhsp" : 23,
        "shared_name" : "SpCluster-7440.0",
        "ppos" : 100.0,
        "score" : 921,
        "pident" : 100.0,
        "SUID" : 16672,
        "selected" : false,
        "sseqid" : "AT1G72610",
        "length" : 194,
        "nident" : 194,
        "evalue" : 1.06E-126,
        "positive" : 194,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 359.0,
        "slen" : 208,
        "mismatch" : 0,
        "name" : "SpCluster-7440.0",
        "send" : 194,
        "qcovs" : 69,
        "PrimarySymbol" : "GERMIN-LIKE PROTEIN 1 (GER1)",
        "qend" : 652
      },
      "position" : {
        "x" : -1848.27841700067,
        "y" : 0.9478803778700673
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16671",
        "Description" : "RmlC-like cupins superfamily protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 55,
        "qstart" : 1141,
        "qcovhsp" : 11,
        "shared_name" : "KfCluster-1971.0",
        "ppos" : 50.0,
        "score" : 183,
        "pident" : 29.747,
        "SUID" : 16671,
        "selected" : false,
        "sseqid" : "AT5G26700",
        "length" : 158,
        "nident" : 47,
        "evalue" : 2.67E-15,
        "positive" : 79,
        "gaps" : 7,
        "Type" : "protein_coding",
        "bitscore" : 75.1,
        "slen" : 213,
        "mismatch" : 104,
        "name" : "KfCluster-1971.0",
        "send" : 206,
        "qcovs" : 32,
        "PrimarySymbol" : "0",
        "qend" : 671
      },
      "position" : {
        "x" : -1843.931493172545,
        "y" : -102.57174433221294
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16670",
        "Description" : "Encodes a plasodesmata-located protein involved in regulating primary root growth by controlling phloem-mediated allocation of resources between the primary and lateral root meristems. The mRNA is cell-to-cell mobile.",
        "SecondarySymbol" : "PLASMODESMAL GERMIN-LIKE PROTEIN 1 (PDGLP1);GERMIN-LIKE PROTEIN 5 (GLP5)",
        "sstart" : 23,
        "qstart" : 288,
        "qcovhsp" : 16,
        "shared_name" : "AaCluster-7580.0",
        "ppos" : 67.71,
        "score" : 507,
        "pident" : 53.646,
        "SUID" : 16670,
        "selected" : false,
        "sseqid" : "AT1G09560",
        "length" : 192,
        "nident" : 103,
        "evalue" : 3.14E-62,
        "positive" : 130,
        "gaps" : 1,
        "Type" : "protein_coding",
        "bitscore" : 199.0,
        "slen" : 219,
        "mismatch" : 88,
        "name" : "AaCluster-7580.0",
        "send" : 213,
        "qcovs" : 47,
        "PrimarySymbol" : "GERMIN-LIKE PROTEIN 5 (GLP5)",
        "qend" : 863
      },
      "position" : {
        "x" : -1938.202000985045,
        "y" : -54.777169594664116
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16669",
        "degree_layout" : 4,
        "Description" : "Alanyl-tRNA synthetase;(source:Araport11)",
        "SecondarySymbol" : "ALANYL-TRNA SYNTHETASE (ALATS); (ACD)",
        "sstart" : 57,
        "qstart" : 3725,
        "qcovhsp" : 24,
        "shared_name" : "KfCluster-15360.0",
        "ppos" : 76.48,
        "score" : 2938,
        "pident" : 61.814,
        "SUID" : 16669,
        "selected" : false,
        "sseqid" : "AT1G50200",
        "length" : 948,
        "nident" : 586,
        "evalue" : 0.0,
        "positive" : 725,
        "gaps" : 7,
        "Type" : "protein_coding",
        "bitscore" : 1136.0,
        "slen" : 1003,
        "mismatch" : 355,
        "name" : "KfCluster-15360.0",
        "send" : 1002,
        "qcovs" : 72,
        "PrimarySymbol" : "ALANYL-TRNA SYNTHETASE (ALATS)",
        "qend" : 897
      },
      "position" : {
        "x" : -232.45428466796875,
        "y" : -110.43172454833984
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16668",
        "degree_layout" : 8,
        "Description" : "encodes a member of the ERF (ethylene response factor) subfamily B-6 of ERF/AP2 transcription factor family (RAP2.11). The protein contains one AP2 domain. There are 12 members in this subfamily including RAP2.11.",
        "SecondarySymbol" : "RELATED TO AP2 11 (RAP2.11)",
        "sstart" : 29,
        "qstart" : 2121,
        "qcovhsp" : 2,
        "shared_name" : "AaCluster-6382.0",
        "ppos" : 92.0,
        "score" : 130,
        "pident" : 74.0,
        "SUID" : 16668,
        "selected" : false,
        "sseqid" : "AT5G19790",
        "length" : 50,
        "nident" : 37,
        "evalue" : 5.17E-8,
        "positive" : 46,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 54.7,
        "slen" : 253,
        "mismatch" : 13,
        "name" : "AaCluster-6382.0",
        "send" : 78,
        "qcovs" : 7,
        "PrimarySymbol" : "RELATED TO AP2 11 (RAP2.11)",
        "qend" : 1972
      },
      "position" : {
        "x" : -797.0855929128813,
        "y" : 21.630383802206552
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "18106",
        "degree_layout" : 1,
        "Description" : "ARID/BRIGHT DNA-binding domain-containing protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 492,
        "qstart" : 247,
        "qcovhsp" : 18,
        "shared_name" : "PpCluster-12399.6",
        "ppos" : 57.09,
        "score" : 552,
        "pident" : 45.946,
        "SUID" : 18106,
        "selected" : false,
        "sseqid" : "AT2G17410",
        "length" : 296,
        "nident" : 136,
        "evalue" : 7.25E-62,
        "positive" : 169,
        "gaps" : 65,
        "Type" : "protein_coding",
        "bitscore" : 217.0,
        "slen" : 786,
        "mismatch" : 95,
        "name" : "PpCluster-12399.6",
        "send" : 723,
        "qcovs" : 55,
        "PrimarySymbol" : "0",
        "qend" : 1131
      },
      "position" : {
        "x" : -95.83982849121094,
        "y" : -2441.25537109375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "18105",
        "degree_layout" : 4,
        "Description" : "DRA2 is a homolog of mammalian nucleoporin 98 and a likely component of the nuclear pore complex in Arabidopsis. It positively participates in the control of the hypocotyl elongation response to plant proximity and control of shade induced gene expression.",
        "SecondarySymbol" : "DRACULA2 (DRA2)",
        "sstart" : 242,
        "qstart" : 3,
        "qcovhsp" : 12,
        "shared_name" : "SpCluster-7021.2",
        "ppos" : 56.76,
        "score" : 69,
        "pident" : 45.946,
        "SUID" : 18105,
        "selected" : false,
        "sseqid" : "AT1G10390",
        "length" : 37,
        "nident" : 17,
        "evalue" : 0.13,
        "positive" : 21,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 31.2,
        "slen" : 1041,
        "mismatch" : 20,
        "name" : "SpCluster-7021.2",
        "send" : 278,
        "qcovs" : 35,
        "PrimarySymbol" : "DRACULA2 (DRA2)",
        "qend" : 113
      },
      "position" : {
        "x" : -135.67715454101562,
        "y" : -2385.992919921875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16665",
        "Description" : "Encodes a xyloglucan-specific galacturonosyltransferase (XUT1) that forms the beta-d-galactosyluronic acid-(1->2)-alpha-d-xylosyl linkage.",
        "SecondarySymbol" : "XYLOGLUCAN-SPECIFIC GALACTURONOSYLTRANSFERASE 1 (XUT1);ROOT HAIR SPECIFIC 8 (RHS8)",
        "sstart" : 267,
        "qstart" : 1998,
        "qcovhsp" : 11,
        "shared_name" : "SpCluster-16327.0",
        "ppos" : 66.39,
        "score" : 864,
        "pident" : 42.5,
        "SUID" : 16665,
        "selected" : false,
        "sseqid" : "AT1G63450",
        "length" : 360,
        "nident" : 153,
        "evalue" : 6.71E-103,
        "positive" : 239,
        "gaps" : 12,
        "Type" : "protein_coding",
        "bitscore" : 337.0,
        "slen" : 664,
        "mismatch" : 195,
        "name" : "SpCluster-16327.0",
        "send" : 617,
        "qcovs" : 34,
        "PrimarySymbol" : "ROOT HAIR SPECIFIC 8 (RHS8)",
        "qend" : 928
      },
      "position" : {
        "x" : -435.4973101512886,
        "y" : -3427.57470703125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "18104",
        "degree_layout" : 6,
        "Description" : "lectin protein kinase family protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 66,
        "qstart" : 187,
        "qcovhsp" : 13,
        "shared_name" : "SpCluster-7021.1",
        "ppos" : 46.81,
        "score" : 64,
        "pident" : 34.043,
        "SUID" : 18104,
        "selected" : false,
        "sseqid" : "AT1G34300",
        "length" : 47,
        "nident" : 16,
        "evalue" : 0.48,
        "positive" : 22,
        "gaps" : 6,
        "Type" : "protein_coding",
        "bitscore" : 29.3,
        "slen" : 829,
        "mismatch" : 25,
        "name" : "SpCluster-7021.1",
        "send" : 112,
        "qcovs" : 38,
        "PrimarySymbol" : "0",
        "qend" : 309
      },
      "position" : {
        "x" : -89.90721130371094,
        "y" : -2264.6103515625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16664",
        "Description" : "Exostosin family protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 287,
        "qstart" : 1907,
        "qcovhsp" : 12,
        "shared_name" : "PpCluster-9264.0",
        "ppos" : 57.74,
        "score" : 811,
        "pident" : 39.803,
        "SUID" : 16664,
        "selected" : false,
        "sseqid" : "AT2G29040",
        "length" : 407,
        "nident" : 162,
        "evalue" : 1.91E-94,
        "positive" : 235,
        "gaps" : 10,
        "Type" : "protein_coding",
        "bitscore" : 317.0,
        "slen" : 720,
        "mismatch" : 235,
        "name" : "PpCluster-9264.0",
        "send" : 687,
        "qcovs" : 37,
        "PrimarySymbol" : "0",
        "qend" : 699
      },
      "position" : {
        "x" : -507.9663042919136,
        "y" : -3460.693359375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "18103",
        "degree_layout" : 4,
        "Description" : "DRA2 is a homolog of mammalian nucleoporin 98 and a likely component of the nuclear pore complex in Arabidopsis. It positively participates in the control of the hypocotyl elongation response to plant proximity and control of shade induced gene expression.",
        "SecondarySymbol" : "DRACULA2 (DRA2)",
        "sstart" : 242,
        "qstart" : 3,
        "qcovhsp" : 10,
        "shared_name" : "SpCluster-7021.0",
        "ppos" : 56.76,
        "score" : 69,
        "pident" : 45.946,
        "SUID" : 18103,
        "selected" : false,
        "sseqid" : "AT1G10390",
        "length" : 37,
        "nident" : 17,
        "evalue" : 0.23,
        "positive" : 21,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 31.2,
        "slen" : 1041,
        "mismatch" : 20,
        "name" : "SpCluster-7021.0",
        "send" : 278,
        "qcovs" : 29,
        "PrimarySymbol" : "DRACULA2 (DRA2)",
        "qend" : 113
      },
      "position" : {
        "x" : -37.638832092285156,
        "y" : -2379.919189453125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16663",
        "Description" : "Exostosin family protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 72,
        "qstart" : 2335,
        "qcovhsp" : 12,
        "shared_name" : "PpCluster-25891.1",
        "ppos" : 55.28,
        "score" : 751,
        "pident" : 38.084,
        "SUID" : 16663,
        "selected" : false,
        "sseqid" : "AT2G32750",
        "length" : 407,
        "nident" : 155,
        "evalue" : 2.89E-88,
        "positive" : 225,
        "gaps" : 8,
        "Type" : "protein_coding",
        "bitscore" : 293.0,
        "slen" : 509,
        "mismatch" : 244,
        "name" : "PpCluster-25891.1",
        "send" : 474,
        "qcovs" : 37,
        "PrimarySymbol" : "0",
        "qend" : 1127
      },
      "position" : {
        "x" : -488.340907563398,
        "y" : -3538.52685546875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16662",
        "Description" : "Exostosin family protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 336,
        "qstart" : 2638,
        "qcovhsp" : 3,
        "shared_name" : "PpCluster-15466.0",
        "ppos" : 61.8,
        "score" : 222,
        "pident" : 50.562,
        "SUID" : 16662,
        "selected" : false,
        "sseqid" : "AT4G13990",
        "length" : 89,
        "nident" : 45,
        "evalue" : 2.41E-18,
        "positive" : 55,
        "gaps" : 14,
        "Type" : "protein_coding",
        "bitscore" : 90.1,
        "slen" : 521,
        "mismatch" : 30,
        "name" : "PpCluster-15466.0",
        "send" : 414,
        "qcovs" : 8,
        "PrimarySymbol" : "0",
        "qend" : 2384
      },
      "position" : {
        "x" : -382.5550494091011,
        "y" : -3479.105224609375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16661",
        "Description" : "Encodes a Golgi apparatus-localized galactosyltransferase involved in galactosyl-substitution of xyloglucan at position 2.",
        "SecondarySymbol" : "GLYCOSYLTRANSFERASE 18 (ATGT18);XYLOGLUCAN L-SIDE CHAIN GALACTOSYLTRANSFERASE POSITION 2 (XLT2);GLYCOSYLTRANSFERASE 18 (GT18)",
        "sstart" : 118,
        "qstart" : 915,
        "qcovhsp" : 14,
        "shared_name" : "AaCluster-5854.0",
        "ppos" : 63.77,
        "score" : 1005,
        "pident" : 46.618,
        "SUID" : 16661,
        "selected" : false,
        "sseqid" : "AT5G62220",
        "length" : 414,
        "nident" : 193,
        "evalue" : 8.77E-126,
        "positive" : 264,
        "gaps" : 26,
        "Type" : "protein_coding",
        "bitscore" : 391.0,
        "slen" : 517,
        "mismatch" : 195,
        "name" : "AaCluster-5854.0",
        "send" : 508,
        "qcovs" : 42,
        "PrimarySymbol" : "GLYCOSYLTRANSFERASE 18 (GT18)",
        "qend" : 2147
      },
      "position" : {
        "x" : -415.04461239738237,
        "y" : -3546.98046875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "18102",
        "degree_layout" : 6,
        "Description" : "GTP binding Elongation factor Tu family protein;(source:Araport11)",
        "SecondarySymbol" : "(EF1ALPHA)",
        "sstart" : 217,
        "qstart" : 228,
        "qcovhsp" : 30,
        "shared_name" : "SpCluster-7050.14",
        "ppos" : 95.77,
        "score" : 335,
        "pident" : 90.141,
        "SUID" : 18102,
        "selected" : false,
        "sseqid" : "AT5G60390",
        "length" : 71,
        "nident" : 64,
        "evalue" : 2.95E-39,
        "positive" : 68,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 133.0,
        "slen" : 400,
        "mismatch" : 7,
        "name" : "SpCluster-7050.14",
        "send" : 287,
        "qcovs" : 89,
        "PrimarySymbol" : "(EF1ALPHA)",
        "qend" : 16
      },
      "position" : {
        "x" : 1080.8111351351072,
        "y" : -145.9264678955078
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16660",
        "degree_layout" : 51,
        "Description" : "phosphoenolpyruvate carboxylase-related kinase 1;(source:Araport11)",
        "SecondarySymbol" : "PHOSPHOENOLPYRUVATE CARBOXYLASE-RELATED KINASE 1 (PEPKR1)",
        "sstart" : 40,
        "qstart" : 1162,
        "qcovhsp" : 19,
        "shared_name" : "SpCluster-20144.0",
        "ppos" : 57.6,
        "score" : 525,
        "pident" : 40.989,
        "SUID" : 16660,
        "selected" : false,
        "sseqid" : "AT1G12580",
        "length" : 283,
        "nident" : 116,
        "evalue" : 1.97E-60,
        "positive" : 163,
        "gaps" : 15,
        "Type" : "protein_coding",
        "bitscore" : 206.0,
        "slen" : 522,
        "mismatch" : 152,
        "name" : "SpCluster-20144.0",
        "send" : 309,
        "qcovs" : 58,
        "PrimarySymbol" : "PHOSPHOENOLPYRUVATE CARBOXYLASE-RELATED KINASE 1 (PEPKR1)",
        "qend" : 320
      },
      "position" : {
        "x" : -224.86712646484375,
        "y" : -1686.4659423828125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17717",
        "degree_layout" : 4,
        "Description" : "Calcium-dependent lipid-binding (CaLB domain) family protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 50,
        "qstart" : 404,
        "qcovhsp" : 2,
        "shared_name" : "SpCluster-7333.0",
        "ppos" : 59.04,
        "score" : 86,
        "pident" : 26.506,
        "SUID" : 17717,
        "selected" : false,
        "sseqid" : "AT2G13350",
        "length" : 83,
        "nident" : 22,
        "evalue" : 0.047,
        "positive" : 49,
        "gaps" : 14,
        "Type" : "protein_coding",
        "bitscore" : 37.7,
        "slen" : 401,
        "mismatch" : 47,
        "name" : "SpCluster-7333.0",
        "send" : 128,
        "qcovs" : 7,
        "PrimarySymbol" : "0",
        "qend" : 622
      },
      "position" : {
        "x" : -7.389667510986328,
        "y" : -1889.1258544921875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16659",
        "Description" : "LOB domain-containing protein 20;(source:Araport11)",
        "SecondarySymbol" : "LOB DOMAIN-CONTAINING PROTEIN 20 (LBD20)",
        "sstart" : 50,
        "qstart" : 1759,
        "qcovhsp" : 4,
        "shared_name" : "PpCluster-644.2",
        "ppos" : 95.24,
        "score" : 490,
        "pident" : 83.81,
        "SUID" : 16659,
        "selected" : false,
        "sseqid" : "AT3G03760",
        "length" : 105,
        "nident" : 88,
        "evalue" : 2.5E-55,
        "positive" : 100,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 193.0,
        "slen" : 273,
        "mismatch" : 17,
        "name" : "PpCluster-644.2",
        "send" : 154,
        "qcovs" : 11,
        "PrimarySymbol" : "LOB DOMAIN-CONTAINING PROTEIN 20 (LBD20)",
        "qend" : 1445
      },
      "position" : {
        "x" : 629.6995239257812,
        "y" : -3148.4840655223825
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17716",
        "degree_layout" : 1,
        "Description" : "GroES-like zinc-binding alcohol dehydrogenase family protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 148,
        "qstart" : 571,
        "qcovhsp" : 6,
        "shared_name" : "PpCluster-20247.0",
        "ppos" : 50.0,
        "score" : 62,
        "pident" : 35.0,
        "SUID" : 17716,
        "selected" : false,
        "sseqid" : "AT5G63620",
        "length" : 40,
        "nident" : 14,
        "evalue" : 5.6,
        "positive" : 20,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 28.5,
        "slen" : 427,
        "mismatch" : 26,
        "name" : "PpCluster-20247.0",
        "send" : 187,
        "qcovs" : 17,
        "PrimarySymbol" : "0",
        "qend" : 690
      },
      "position" : {
        "x" : 63.617897033691406,
        "y" : -2047.068359375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16658",
        "Description" : "LOB domain-containing protein 20;(source:Araport11)",
        "SecondarySymbol" : "LOB DOMAIN-CONTAINING PROTEIN 20 (LBD20)",
        "sstart" : 50,
        "qstart" : 1615,
        "qcovhsp" : 3,
        "shared_name" : "PpCluster-644.1",
        "ppos" : 96.19,
        "score" : 499,
        "pident" : 83.81,
        "SUID" : 16658,
        "selected" : false,
        "sseqid" : "AT3G03760",
        "length" : 105,
        "nident" : 88,
        "evalue" : 2.66E-56,
        "positive" : 101,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 196.0,
        "slen" : 273,
        "mismatch" : 17,
        "name" : "PpCluster-644.1",
        "send" : 154,
        "qcovs" : 8,
        "PrimarySymbol" : "LOB DOMAIN-CONTAINING PROTEIN 20 (LBD20)",
        "qend" : 1301
      },
      "position" : {
        "x" : 563.9513549804688,
        "y" : -3187.7404131786325
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16657",
        "Description" : "LOB domain-containing protein 20;(source:Araport11)",
        "SecondarySymbol" : "LOB DOMAIN-CONTAINING PROTEIN 20 (LBD20)",
        "sstart" : 50,
        "qstart" : 1299,
        "qcovhsp" : 2,
        "shared_name" : "PpCluster-26274.0",
        "ppos" : 86.41,
        "score" : 430,
        "pident" : 74.757,
        "SUID" : 16657,
        "selected" : false,
        "sseqid" : "AT3G03760",
        "length" : 103,
        "nident" : 77,
        "evalue" : 9.31E-47,
        "positive" : 89,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 170.0,
        "slen" : 273,
        "mismatch" : 26,
        "name" : "PpCluster-26274.0",
        "send" : 152,
        "qcovs" : 5,
        "PrimarySymbol" : "LOB DOMAIN-CONTAINING PROTEIN 20 (LBD20)",
        "qend" : 1607
      },
      "position" : {
        "x" : 654.7507934570312,
        "y" : -3263.8700518505075
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16656",
        "Description" : "LOB domain-containing protein 22;(source:Araport11)",
        "SecondarySymbol" : "LOB DOMAIN-CONTAINING PROTEIN 22 (LBD22)",
        "sstart" : 36,
        "qstart" : 962,
        "qcovhsp" : 4,
        "shared_name" : "MpCluster-13359.0",
        "ppos" : 75.64,
        "score" : 249,
        "pident" : 57.692,
        "SUID" : 16656,
        "selected" : false,
        "sseqid" : "AT3G13850",
        "length" : 78,
        "nident" : 45,
        "evalue" : 1.81E-23,
        "positive" : 59,
        "gaps" : 1,
        "Type" : "protein_coding",
        "bitscore" : 100.0,
        "slen" : 268,
        "mismatch" : 32,
        "name" : "MpCluster-13359.0",
        "send" : 113,
        "qcovs" : 12,
        "PrimarySymbol" : "LOB DOMAIN-CONTAINING PROTEIN 22 (LBD22)",
        "qend" : 1192
      },
      "position" : {
        "x" : 674.85400390625,
        "y" : -3325.3766436473825
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17713",
        "Description" : "Ribosomal protein L2 family;(source:Araport11)",
        "SecondarySymbol" : "EMBRYO DEFECTIVE 2296 (EMB2296)",
        "sstart" : 1,
        "qstart" : 16,
        "qcovhsp" : 30,
        "shared_name" : "SpCluster-57.2",
        "ppos" : 100.0,
        "score" : 1308,
        "pident" : 100.0,
        "SUID" : 17713,
        "selected" : false,
        "sseqid" : "AT2G18020",
        "length" : 249,
        "nident" : 249,
        "evalue" : 0.0,
        "positive" : 249,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 508.0,
        "slen" : 258,
        "mismatch" : 0,
        "name" : "SpCluster-57.2",
        "send" : 249,
        "qcovs" : 89,
        "PrimarySymbol" : "EMBRYO DEFECTIVE 2296 (EMB2296)",
        "qend" : 762
      },
      "position" : {
        "x" : 1110.14501953125,
        "y" : -3059.8818168074645
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16655",
        "Description" : "LOB domain-containing protein 20;(source:Araport11)",
        "SecondarySymbol" : "LOB DOMAIN-CONTAINING PROTEIN 20 (LBD20)",
        "sstart" : 50,
        "qstart" : 1575,
        "qcovhsp" : 3,
        "shared_name" : "AaCluster-7333.0",
        "ppos" : 94.95,
        "score" : 460,
        "pident" : 82.828,
        "SUID" : 16655,
        "selected" : false,
        "sseqid" : "AT3G03760",
        "length" : 99,
        "nident" : 82,
        "evalue" : 4.41E-51,
        "positive" : 94,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 181.0,
        "slen" : 273,
        "mismatch" : 17,
        "name" : "AaCluster-7333.0",
        "send" : 148,
        "qcovs" : 8,
        "PrimarySymbol" : "LOB DOMAIN-CONTAINING PROTEIN 20 (LBD20)",
        "qend" : 1279
      },
      "position" : {
        "x" : 687.4007568359375,
        "y" : -3202.4918780223825
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16654",
        "Description" : "\"Overexpression/activation tagged allele has epinastic leaves, reduced apical dominance and is sterile. Gene is similar to asymmetric leaves (AS)/lateral organ boundary (LOB) genes  which repress KNOX gene expression.\"",
        "SecondarySymbol" : "(LBD12); (ASL5);PEACOCK 1 (PCK1)",
        "sstart" : 5,
        "qstart" : 1505,
        "qcovhsp" : 6,
        "shared_name" : "AaCluster-4796.0",
        "ppos" : 83.74,
        "score" : 320,
        "pident" : 68.293,
        "SUID" : 16654,
        "selected" : false,
        "sseqid" : "AT2G30130",
        "length" : 123,
        "nident" : 84,
        "evalue" : 1.03E-33,
        "positive" : 103,
        "gaps" : 2,
        "Type" : "protein_coding",
        "bitscore" : 127.0,
        "slen" : 193,
        "mismatch" : 37,
        "name" : "AaCluster-4796.0",
        "send" : 125,
        "qcovs" : 19,
        "PrimarySymbol" : "(ASL5)",
        "qend" : 1137
      },
      "position" : {
        "x" : 582.8505859375,
        "y" : -3264.4696612255075
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17712",
        "Description" : "EXORDIUM like 5;(source:Araport11)",
        "SecondarySymbol" : "EXORDIUM LIKE 5 (EXL5)",
        "sstart" : 51,
        "qstart" : 1274,
        "qcovhsp" : 14,
        "shared_name" : "SpCluster-10695.0",
        "ppos" : 43.67,
        "score" : 246,
        "pident" : 30.422,
        "SUID" : 17712,
        "selected" : false,
        "sseqid" : "AT2G17230",
        "length" : 332,
        "nident" : 101,
        "evalue" : 3.15E-22,
        "positive" : 145,
        "gaps" : 45,
        "Type" : "protein_coding",
        "bitscore" : 99.4,
        "slen" : 363,
        "mismatch" : 186,
        "name" : "SpCluster-10695.0",
        "send" : 356,
        "qcovs" : 41,
        "PrimarySymbol" : "EXORDIUM LIKE 5 (EXL5)",
        "qend" : 336
      },
      "position" : {
        "x" : -1665.5053403338582,
        "y" : -3591.600845458071
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16653",
        "degree_layout" : 5,
        "Description" : "\"Nucleic acid-binding, OB-fold-like protein;(source:Araport11)\"",
        "SecondarySymbol" : "0",
        "sstart" : 229,
        "qstart" : 662,
        "qcovhsp" : 10,
        "shared_name" : "SpCluster-19757.0",
        "ppos" : 78.26,
        "score" : 543,
        "pident" : 60.87,
        "SUID" : 16653,
        "selected" : false,
        "sseqid" : "AT2G40660",
        "length" : 161,
        "nident" : 98,
        "evalue" : 5.45E-64,
        "positive" : 126,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 213.0,
        "slen" : 389,
        "mismatch" : 63,
        "name" : "SpCluster-19757.0",
        "send" : 389,
        "qcovs" : 31,
        "PrimarySymbol" : "0",
        "qend" : 180
      },
      "position" : {
        "x" : 299.42755126953125,
        "y" : -896.8628540039062
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17711",
        "Description" : "dentin sialophosphoprotein-like protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 91,
        "qstart" : 5061,
        "qcovhsp" : 2,
        "shared_name" : "PpCluster-20056.0",
        "ppos" : 71.9,
        "score" : 352,
        "pident" : 55.372,
        "SUID" : 17711,
        "selected" : false,
        "sseqid" : "AT3G21290",
        "length" : 121,
        "nident" : 67,
        "evalue" : 5.05E-33,
        "positive" : 87,
        "gaps" : 3,
        "Type" : "protein_coding",
        "bitscore" : 140.0,
        "slen" : 1192,
        "mismatch" : 51,
        "name" : "PpCluster-20056.0",
        "send" : 211,
        "qcovs" : 7,
        "PrimarySymbol" : "0",
        "qend" : 4708
      },
      "position" : {
        "x" : -1758.5260922869832,
        "y" : -3649.940200926821
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16652",
        "degree_layout" : 5,
        "Description" : "\"methionine-tRNA ligase, putative / methionyl-tRNA synthetase, putative / MetRS;(source:Araport11)\"",
        "SecondarySymbol" : "0",
        "sstart" : 641,
        "qstart" : 1678,
        "qcovhsp" : 6,
        "shared_name" : "KfCluster-24552.0",
        "ppos" : 58.46,
        "score" : 131,
        "pident" : 32.308,
        "SUID" : 16652,
        "selected" : false,
        "sseqid" : "AT4G13780",
        "length" : 130,
        "nident" : 42,
        "evalue" : 1.55E-7,
        "positive" : 76,
        "gaps" : 9,
        "Type" : "protein_coding",
        "bitscore" : 55.1,
        "slen" : 797,
        "mismatch" : 79,
        "name" : "KfCluster-24552.0",
        "send" : 761,
        "qcovs" : 18,
        "PrimarySymbol" : "0",
        "qend" : 1289
      },
      "position" : {
        "x" : 221.811767578125,
        "y" : -1017.5411376953125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16651",
        "degree_layout" : 5,
        "Description" : "\"methionine-tRNA ligase, putative / methionyl-tRNA synthetase, putative / MetRS;(source:Araport11)\"",
        "SecondarySymbol" : "0",
        "sstart" : 7,
        "qstart" : 2680,
        "qcovhsp" : 27,
        "shared_name" : "CrCluster-19464.0",
        "ppos" : 79.15,
        "score" : 2755,
        "pident" : 65.918,
        "SUID" : 16651,
        "selected" : false,
        "sseqid" : "AT4G13780",
        "length" : 801,
        "nident" : 528,
        "evalue" : 0.0,
        "positive" : 634,
        "gaps" : 14,
        "Type" : "protein_coding",
        "bitscore" : 1065.0,
        "slen" : 797,
        "mismatch" : 259,
        "name" : "CrCluster-19464.0",
        "send" : 797,
        "qcovs" : 81,
        "PrimarySymbol" : "0",
        "qend" : 290
      },
      "position" : {
        "x" : 267.9670715332031,
        "y" : -813.27978515625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16650",
        "degree_layout" : 8,
        "Description" : "\"methionine-tRNA ligase, putative / methionyl-tRNA synthetase, putative / MetRS;(source:Araport11)\"",
        "SecondarySymbol" : "0",
        "sstart" : 600,
        "qstart" : 1991,
        "qcovhsp" : 6,
        "shared_name" : "AaCluster-3551.0",
        "ppos" : 53.96,
        "score" : 268,
        "pident" : 35.644,
        "SUID" : 16650,
        "selected" : false,
        "sseqid" : "AT4G13780",
        "length" : 202,
        "nident" : 72,
        "evalue" : 1.47E-23,
        "positive" : 109,
        "gaps" : 8,
        "Type" : "protein_coding",
        "bitscore" : 107.0,
        "slen" : 797,
        "mismatch" : 122,
        "name" : "AaCluster-3551.0",
        "send" : 795,
        "qcovs" : 19,
        "PrimarySymbol" : "0",
        "qend" : 2590
      },
      "position" : {
        "x" : 185.49868774414062,
        "y" : -865.6063232421875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16649",
        "degree_layout" : 32,
        "Description" : "Cysteine proteinases superfamily protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 140,
        "qstart" : 714,
        "qcovhsp" : 8,
        "shared_name" : "SpCluster-2644.2",
        "ppos" : 53.02,
        "score" : 338,
        "pident" : 37.069,
        "SUID" : 16649,
        "selected" : false,
        "sseqid" : "AT3G45310",
        "length" : 232,
        "nident" : 86,
        "evalue" : 3.66E-34,
        "positive" : 123,
        "gaps" : 26,
        "Type" : "protein_coding",
        "bitscore" : 134.0,
        "slen" : 358,
        "mismatch" : 120,
        "name" : "SpCluster-2644.2",
        "send" : 357,
        "qcovs" : 25,
        "PrimarySymbol" : "0",
        "qend" : 55
      },
      "position" : {
        "x" : 111.62973022460938,
        "y" : -1254.232421875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16648",
        "degree_layout" : 2,
        "Description" : "Transmembrane amino acid transporter family protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 151,
        "qstart" : 338,
        "qcovhsp" : 4,
        "shared_name" : "SpCluster-16390.0",
        "ppos" : 59.26,
        "score" : 61,
        "pident" : 40.741,
        "SUID" : 16648,
        "selected" : false,
        "sseqid" : "AT1G47670",
        "length" : 27,
        "nident" : 11,
        "evalue" : 7.2,
        "positive" : 16,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 28.1,
        "slen" : 519,
        "mismatch" : 16,
        "name" : "SpCluster-16390.0",
        "send" : 177,
        "qcovs" : 11,
        "PrimarySymbol" : "0",
        "qend" : 418
      },
      "position" : {
        "x" : 3.9910736083984375,
        "y" : -1076.7816162109375
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16647",
        "degree_layout" : 14,
        "Description" : "F-box and associated interaction domains-containing protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 86,
        "qstart" : 842,
        "qcovhsp" : 4,
        "shared_name" : "SpCluster-14771.2",
        "ppos" : 41.86,
        "score" : 73,
        "pident" : 24.419,
        "SUID" : 16647,
        "selected" : false,
        "sseqid" : "AT2G40925",
        "length" : 86,
        "nident" : 21,
        "evalue" : 0.88,
        "positive" : 36,
        "gaps" : 1,
        "Type" : "protein_coding",
        "bitscore" : 32.7,
        "slen" : 403,
        "mismatch" : 64,
        "name" : "SpCluster-14771.2",
        "send" : 171,
        "qcovs" : 12,
        "PrimarySymbol" : "0",
        "qend" : 588
      },
      "position" : {
        "x" : 196.70306396484375,
        "y" : -1279.207763671875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16646",
        "degree_layout" : 1,
        "Description" : "member of eIF3b - eukaryotic initiation factor 3b",
        "SecondarySymbol" : "EUKARYOTIC TRANSLATION INITIATION FACTOR 3B-2 (EIF3B-2); (ATEIF3B-2);EUKARYOTIC TRANSLATION INITIATION FACTOR 3B (EIF3B)",
        "sstart" : 14,
        "qstart" : 2815,
        "qcovhsp" : 20,
        "shared_name" : "KfCluster-26183.0",
        "ppos" : 78.79,
        "score" : 2061,
        "pident" : 61.61,
        "SUID" : 16646,
        "selected" : false,
        "sseqid" : "AT5G25780",
        "length" : 646,
        "nident" : 398,
        "evalue" : 0.0,
        "positive" : 509,
        "gaps" : 2,
        "Type" : "protein_coding",
        "bitscore" : 798.0,
        "slen" : 714,
        "mismatch" : 246,
        "name" : "KfCluster-26183.0",
        "send" : 659,
        "qcovs" : 61,
        "PrimarySymbol" : "EUKARYOTIC TRANSLATION INITIATION FACTOR 3B-2 (EIF3B-2)",
        "qend" : 884
      },
      "position" : {
        "x" : 276.2455139160156,
        "y" : -1015.6646728515625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16645",
        "degree_layout" : 5,
        "Description" : "nucleolar GTP-binding protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 71,
        "qstart" : 2811,
        "qcovhsp" : 1,
        "shared_name" : "AaCluster-2917.0",
        "ppos" : 79.31,
        "score" : 78,
        "pident" : 48.276,
        "SUID" : 16645,
        "selected" : false,
        "sseqid" : "AT1G22230",
        "length" : 29,
        "nident" : 14,
        "evalue" : 0.43,
        "positive" : 23,
        "gaps" : 2,
        "Type" : "protein_coding",
        "bitscore" : 34.7,
        "slen" : 314,
        "mismatch" : 13,
        "name" : "AaCluster-2917.0",
        "send" : 97,
        "qcovs" : 2,
        "PrimarySymbol" : "0",
        "qend" : 2897
      },
      "position" : {
        "x" : 128.7581329345703,
        "y" : -1153.921875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17710",
        "degree_layout" : 16,
        "Description" : "actin binding protein required for normal chloroplast positioning The mRNA is cell-to-cell mobile.",
        "SecondarySymbol" : "ARABIDOPSIS THALIANA CHLOROPLAST UNUSUAL POSITIONING 1 (ATCHUP1);CHLOROPLAST UNUSUAL POSITIONING 1 (CHUP1)",
        "sstart" : 343,
        "qstart" : 1470,
        "qcovhsp" : 3,
        "shared_name" : "SpCluster-9720.0",
        "ppos" : 53.45,
        "score" : 84,
        "pident" : 37.931,
        "SUID" : 17710,
        "selected" : false,
        "sseqid" : "AT3G25690",
        "length" : 58,
        "nident" : 22,
        "evalue" : 0.051,
        "positive" : 31,
        "gaps" : 7,
        "Type" : "protein_coding",
        "bitscore" : 37.0,
        "slen" : 1004,
        "mismatch" : 29,
        "name" : "SpCluster-9720.0",
        "send" : 398,
        "qcovs" : 8,
        "PrimarySymbol" : "CHLOROPLAST UNUSUAL POSITIONING 1 (CHUP1)",
        "qend" : 1628
      },
      "position" : {
        "x" : 464.70250265354963,
        "y" : -1631.927447721909
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16644",
        "degree_layout" : 29,
        "Description" : "",
        "SecondarySymbol" : "",
        "shared_name" : "KfCluster-29657.1",
        "SUID" : 16644,
        "selected" : false,
        "sseqid" : "",
        "Type" : "",
        "name" : "KfCluster-29657.1",
        "PrimarySymbol" : ""
      },
      "position" : {
        "x" : 623.1875,
        "y" : -1526.494873046875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16643",
        "degree_layout" : 4,
        "Description" : "RING/U-box superfamily protein;(source:Araport11)",
        "SecondarySymbol" : "ABERRANT POLLEN DEVELOPMENT 1 (APD1)",
        "sstart" : 295,
        "qstart" : 574,
        "qcovhsp" : 6,
        "shared_name" : "AaCluster-2529.0",
        "ppos" : 50.0,
        "score" : 94,
        "pident" : 39.474,
        "SUID" : 16643,
        "selected" : false,
        "sseqid" : "AT2G38185",
        "length" : 38,
        "nident" : 15,
        "evalue" : 3.89E-4,
        "positive" : 19,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 40.8,
        "slen" : 346,
        "mismatch" : 23,
        "name" : "AaCluster-2529.0",
        "send" : 332,
        "qcovs" : 17,
        "PrimarySymbol" : "ABERRANT POLLEN DEVELOPMENT 1 (APD1)",
        "qend" : 687
      },
      "position" : {
        "x" : 492.00634765625,
        "y" : -1423.3951416015625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17709",
        "degree_layout" : 11,
        "Description" : "P-loop containing nucleoside triphosphate hydrolases superfamily protein;(source:Araport11)",
        "SecondarySymbol" : "KINESIN 7.1 (KIN7.1)",
        "sstart" : 593,
        "qstart" : 574,
        "qcovhsp" : 8,
        "shared_name" : "SpCluster-7151.3",
        "ppos" : 48.2,
        "score" : 173,
        "pident" : 29.836,
        "SUID" : 17709,
        "selected" : false,
        "sseqid" : "AT1G21730",
        "length" : 305,
        "nident" : 91,
        "evalue" : 3.56E-12,
        "positive" : 147,
        "gaps" : 40,
        "Type" : "protein_coding",
        "bitscore" : 71.2,
        "slen" : 890,
        "mismatch" : 174,
        "name" : "SpCluster-7151.3",
        "send" : 864,
        "qcovs" : 23,
        "PrimarySymbol" : "KINESIN 7.1 (KIN7.1)",
        "qend" : 1467
      },
      "position" : {
        "x" : 804.9689440396397,
        "y" : -1868.5660084607675
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16642",
        "degree_layout" : 16,
        "Description" : "Encodes histidine kinase AHK2.",
        "SecondarySymbol" : "HISTIDINE KINASE 2 (AHK2);HISTIDINE KINASE 2 (HK2)",
        "sstart" : 569,
        "qstart" : 2051,
        "qcovhsp" : 4,
        "shared_name" : "SpCluster-19673.0",
        "ppos" : 59.38,
        "score" : 355,
        "pident" : 42.708,
        "SUID" : 16642,
        "selected" : false,
        "sseqid" : "AT5G35750",
        "length" : 192,
        "nident" : 82,
        "evalue" : 2.15E-33,
        "positive" : 114,
        "gaps" : 6,
        "Type" : "protein_coding",
        "bitscore" : 141.0,
        "slen" : 1176,
        "mismatch" : 104,
        "name" : "SpCluster-19673.0",
        "send" : 760,
        "qcovs" : 12,
        "PrimarySymbol" : "HISTIDINE KINASE 2 (HK2)",
        "qend" : 1494
      },
      "position" : {
        "x" : 1718.7710707781584,
        "y" : -1408.0689460336107
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17708",
        "degree_layout" : 7,
        "Description" : "",
        "SecondarySymbol" : "",
        "shared_name" : "SpCluster-14372.0",
        "SUID" : 17708,
        "selected" : false,
        "sseqid" : "",
        "Type" : "",
        "name" : "SpCluster-14372.0",
        "PrimarySymbol" : ""
      },
      "position" : {
        "x" : 710.9402465820312,
        "y" : -1652.8369140625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16641",
        "degree_layout" : 17,
        "Description" : "Encodes histidine kinase AHK2.",
        "SecondarySymbol" : "HISTIDINE KINASE 2 (AHK2);HISTIDINE KINASE 2 (HK2)",
        "sstart" : 567,
        "qstart" : 1208,
        "qcovhsp" : 8,
        "shared_name" : "SpCluster-16555.0",
        "ppos" : 57.88,
        "score" : 511,
        "pident" : 37.273,
        "SUID" : 16641,
        "selected" : false,
        "sseqid" : "AT5G35750",
        "length" : 330,
        "nident" : 123,
        "evalue" : 3.76E-52,
        "positive" : 191,
        "gaps" : 33,
        "Type" : "protein_coding",
        "bitscore" : 201.0,
        "slen" : 1176,
        "mismatch" : 174,
        "name" : "SpCluster-16555.0",
        "send" : 885,
        "qcovs" : 23,
        "PrimarySymbol" : "HISTIDINE KINASE 2 (HK2)",
        "qend" : 2131
      },
      "position" : {
        "x" : 1717.737989723471,
        "y" : -1527.2413093148607
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16640",
        "degree_layout" : 20,
        "Description" : "\"Encodes a histidine kinases, a cytokinin receptor that controls cytokinin-mediated leaf longevity through a specific phosphorylation of the response regulator, ARR2. The mRNA is cell-to-cell mobile.\"",
        "SecondarySymbol" : "HISTIDINE KINASE 3 (HK3);HISTIDINE KINASE 3 (AHK3)",
        "sstart" : 451,
        "qstart" : 2510,
        "qcovhsp" : 3,
        "shared_name" : "PpCluster-8805.0",
        "ppos" : 64.25,
        "score" : 319,
        "pident" : 39.106,
        "SUID" : 16640,
        "selected" : false,
        "sseqid" : "AT1G27320",
        "length" : 179,
        "nident" : 70,
        "evalue" : 4.3E-29,
        "positive" : 115,
        "gaps" : 10,
        "Type" : "protein_coding",
        "bitscore" : 127.0,
        "slen" : 1036,
        "mismatch" : 99,
        "name" : "PpCluster-8805.0",
        "send" : 620,
        "qcovs" : 10,
        "PrimarySymbol" : "HISTIDINE KINASE 3 (HK3)",
        "qend" : 3043
      },
      "position" : {
        "x" : 1785.8509047625334,
        "y" : -1421.5425788461107
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16639",
        "degree_layout" : 16,
        "Description" : "member of Histidine Kinase",
        "SecondarySymbol" : "HISTIDINE KINASE 5 (HK5);CYTOKININ INDEPENDENT 2 (CKI2);HISTIDINE KINASE 5 (AHK5)",
        "sstart" : 55,
        "qstart" : 4481,
        "qcovhsp" : 8,
        "shared_name" : "PpCluster-23824.2",
        "ppos" : 71.43,
        "score" : 1250,
        "pident" : 54.978,
        "SUID" : 16639,
        "selected" : false,
        "sseqid" : "AT5G10720",
        "length" : 462,
        "nident" : 254,
        "evalue" : 1.37E-149,
        "positive" : 330,
        "gaps" : 9,
        "Type" : "protein_coding",
        "bitscore" : 486.0,
        "slen" : 922,
        "mismatch" : 199,
        "name" : "PpCluster-23824.2",
        "send" : 507,
        "qcovs" : 25,
        "PrimarySymbol" : "HISTIDINE KINASE 5 (HK5)",
        "qend" : 3096
      },
      "position" : {
        "x" : 1684.544142067221,
        "y" : -1444.0549079476732
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16638",
        "degree_layout" : 19,
        "Description" : "member of Histidine Kinase",
        "SecondarySymbol" : "HISTIDINE KINASE 5 (HK5);CYTOKININ INDEPENDENT 2 (CKI2);HISTIDINE KINASE 5 (AHK5)",
        "sstart" : 243,
        "qstart" : 6,
        "qcovhsp" : 8,
        "shared_name" : "PpCluster-16855.1",
        "ppos" : 79.56,
        "score" : 817,
        "pident" : 58.029,
        "SUID" : 16638,
        "selected" : false,
        "sseqid" : "AT5G10720",
        "length" : 274,
        "nident" : 159,
        "evalue" : 2.04E-93,
        "positive" : 218,
        "gaps" : 3,
        "Type" : "protein_coding",
        "bitscore" : 319.0,
        "slen" : 922,
        "mismatch" : 112,
        "name" : "PpCluster-16855.1",
        "send" : 513,
        "qcovs" : 25,
        "PrimarySymbol" : "HISTIDINE KINASE 5 (HK5)",
        "qend" : 827
      },
      "position" : {
        "x" : 1744.3411391375334,
        "y" : -1468.0527106820482
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16637",
        "degree_layout" : 17,
        "Description" : "\"Encodes a histidine kinases, a cytokinin receptor that controls cytokinin-mediated leaf longevity through a specific phosphorylation of the response regulator, ARR2. The mRNA is cell-to-cell mobile.\"",
        "SecondarySymbol" : "HISTIDINE KINASE 3 (HK3);HISTIDINE KINASE 3 (AHK3)",
        "sstart" : 534,
        "qstart" : 2296,
        "qcovhsp" : 9,
        "shared_name" : "PpCluster-16147.1",
        "ppos" : 46.8,
        "score" : 380,
        "pident" : 28.155,
        "SUID" : 16637,
        "selected" : false,
        "sseqid" : "AT1G27320",
        "length" : 515,
        "nident" : 145,
        "evalue" : 1.92E-36,
        "positive" : 241,
        "gaps" : 63,
        "Type" : "protein_coding",
        "bitscore" : 150.0,
        "slen" : 1036,
        "mismatch" : 307,
        "name" : "PpCluster-16147.1",
        "send" : 1030,
        "qcovs" : 28,
        "PrimarySymbol" : "HISTIDINE KINASE 3 (HK3)",
        "qend" : 887
      },
      "position" : {
        "x" : 1768.1377699969084,
        "y" : -1519.0480720101732
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16636",
        "degree_layout" : 17,
        "Description" : "Encodes histidine kinase AHK2.",
        "SecondarySymbol" : "HISTIDINE KINASE 2 (AHK2);HISTIDINE KINASE 2 (HK2)",
        "sstart" : 587,
        "qstart" : 372,
        "qcovhsp" : 11,
        "shared_name" : "KfCluster-21429.0",
        "ppos" : 49.85,
        "score" : 389,
        "pident" : 30.792,
        "SUID" : 16636,
        "selected" : false,
        "sseqid" : "AT5G35750",
        "length" : 341,
        "nident" : 105,
        "evalue" : 6.38E-38,
        "positive" : 170,
        "gaps" : 31,
        "Type" : "protein_coding",
        "bitscore" : 154.0,
        "slen" : 1176,
        "mismatch" : 205,
        "name" : "KfCluster-21429.0",
        "send" : 922,
        "qcovs" : 33,
        "PrimarySymbol" : "HISTIDINE KINASE 2 (HK2)",
        "qend" : 1316
      },
      "position" : {
        "x" : 1623.7630141375334,
        "y" : -1433.3334724007982
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16635",
        "degree_layout" : 13,
        "Description" : "Encodes histidine kinase AHK2.",
        "SecondarySymbol" : "HISTIDINE KINASE 2 (AHK2);HISTIDINE KINASE 2 (HK2)",
        "sstart" : 801,
        "qstart" : 351,
        "qcovhsp" : 10,
        "shared_name" : "AaCluster-20253.0",
        "ppos" : 59.68,
        "score" : 112,
        "pident" : 40.323,
        "SUID" : 16635,
        "selected" : false,
        "sseqid" : "AT5G35750",
        "length" : 62,
        "nident" : 25,
        "evalue" : 1.3E-7,
        "positive" : 37,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 47.8,
        "slen" : 1176,
        "mismatch" : 37,
        "name" : "AaCluster-20253.0",
        "send" : 862,
        "qcovs" : 29,
        "PrimarySymbol" : "HISTIDINE KINASE 2 (HK2)",
        "qend" : 166
      },
      "position" : {
        "x" : 1666.460157692221,
        "y" : -1503.0783454476732
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16634",
        "Description" : "member of Putative Na+/H+ antiporter family",
        "SecondarySymbol" : "CATION/H+ EXCHANGER 18 (CHX18);ARABIDOPSIS THALIANA CATION/H+ EXCHANGER 18 (ATCHX18)",
        "sstart" : 15,
        "qstart" : 4037,
        "qcovhsp" : 13,
        "shared_name" : "KfCluster-25045.0",
        "ppos" : 65.16,
        "score" : 1099,
        "pident" : 46.794,
        "SUID" : 16634,
        "selected" : false,
        "sseqid" : "AT5G41610",
        "length" : 577,
        "nident" : 270,
        "evalue" : 1.13E-131,
        "positive" : 376,
        "gaps" : 18,
        "Type" : "protein_coding",
        "bitscore" : 427.0,
        "slen" : 810,
        "mismatch" : 289,
        "name" : "KfCluster-25045.0",
        "send" : 586,
        "qcovs" : 38,
        "PrimarySymbol" : "CATION/H+ EXCHANGER 18 (CHX18)",
        "qend" : 2346
      },
      "position" : {
        "x" : 1332.471741467646,
        "y" : 199.65106126672882
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "18101",
        "degree_layout" : 5,
        "Description" : "\"encodes a protein that physically interacts specifically with the putative coiled-coil region of COP1 in vitro. In hypocotyl and cotyledon protoplasts, it is associated to the cytoskeleton, but not in the root. expression is not regulated by light. The mRNA is cell-to-cell mobile.\"",
        "SecondarySymbol" : "COP1-INTERACTIVE PROTEIN 1 (CIP1)",
        "sstart" : 875,
        "qstart" : 325,
        "qcovhsp" : 4,
        "shared_name" : "SpCluster-6245.0",
        "ppos" : 53.04,
        "score" : 72,
        "pident" : 28.696,
        "SUID" : 18101,
        "selected" : false,
        "sseqid" : "AT5G41790",
        "length" : 115,
        "nident" : 33,
        "evalue" : 1.5,
        "positive" : 61,
        "gaps" : 21,
        "Type" : "protein_coding",
        "bitscore" : 32.3,
        "slen" : 1586,
        "mismatch" : 61,
        "name" : "SpCluster-6245.0",
        "send" : 989,
        "qcovs" : 13,
        "PrimarySymbol" : "COP1-INTERACTIVE PROTEIN 1 (CIP1)",
        "qend" : 606
      },
      "position" : {
        "x" : 558.9119873046875,
        "y" : -1684.934326171875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16633",
        "Description" : "member of Putative Na+/H+ antiporter family",
        "SecondarySymbol" : "CATION/H+ EXCHANGER 17 (ATCHX17);CATION/H+ EXCHANGER 17 (CHX17)",
        "sstart" : 4,
        "qstart" : 3282,
        "qcovhsp" : 11,
        "shared_name" : "CrCluster-39817.2",
        "ppos" : 69.21,
        "score" : 924,
        "pident" : 48.346,
        "SUID" : 16633,
        "selected" : false,
        "sseqid" : "AT4G23700",
        "length" : 393,
        "nident" : 190,
        "evalue" : 9.92E-109,
        "positive" : 272,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 360.0,
        "slen" : 820,
        "mismatch" : 203,
        "name" : "CrCluster-39817.2",
        "send" : 396,
        "qcovs" : 34,
        "PrimarySymbol" : "CATION/H+ EXCHANGER 17 (CHX17)",
        "qend" : 2104
      },
      "position" : {
        "x" : 1351.045471936396,
        "y" : 97.21180650598663
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17707",
        "degree_layout" : 2,
        "Description" : "phosphoinositide binding protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 933,
        "qstart" : 739,
        "qcovhsp" : 8,
        "shared_name" : "SpCluster-2033.0",
        "ppos" : 50.0,
        "score" : 133,
        "pident" : 30.0,
        "SUID" : 17707,
        "selected" : false,
        "sseqid" : "AT1G61690",
        "length" : 140,
        "nident" : 42,
        "evalue" : 7.15E-8,
        "positive" : 70,
        "gaps" : 15,
        "Type" : "protein_coding",
        "bitscore" : 55.8,
        "slen" : 1171,
        "mismatch" : 83,
        "name" : "SpCluster-2033.0",
        "send" : 1057,
        "qcovs" : 23,
        "PrimarySymbol" : "0",
        "qend" : 320
      },
      "position" : {
        "x" : -937.363691396542,
        "y" : -373.82710082037016
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16632",
        "Description" : "member of Putative Na+/H+ antiporter family",
        "SecondarySymbol" : "CATION/H+ EXCHANGER 18 (CHX18);ARABIDOPSIS THALIANA CATION/H+ EXCHANGER 18 (ATCHX18)",
        "sstart" : 4,
        "qstart" : 283,
        "qcovhsp" : 17,
        "shared_name" : "AaCluster-19829.1",
        "ppos" : 74.5,
        "score" : 839,
        "pident" : 59.158,
        "SUID" : 16632,
        "selected" : false,
        "sseqid" : "AT5G41610",
        "length" : 404,
        "nident" : 239,
        "evalue" : 1.25E-170,
        "positive" : 301,
        "gaps" : 6,
        "Type" : "protein_coding",
        "bitscore" : 327.0,
        "slen" : 810,
        "mismatch" : 159,
        "name" : "AaCluster-19829.1",
        "send" : 402,
        "qcovs" : 51,
        "PrimarySymbol" : "CATION/H+ EXCHANGER 18 (CHX18)",
        "qend" : 1491
      },
      "position" : {
        "x" : 1430.452454358271,
        "y" : 164.51287767297882
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17706",
        "degree_layout" : 2,
        "Description" : "Regulator of chromosome condensation (RCC1) family with FYVE zinc finger domain-containing protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 523,
        "qstart" : 2959,
        "qcovhsp" : 21,
        "shared_name" : "PpCluster-9888.2",
        "ppos" : 61.05,
        "score" : 1203,
        "pident" : 47.695,
        "SUID" : 17706,
        "selected" : false,
        "sseqid" : "AT5G19420",
        "length" : 629,
        "nident" : 300,
        "evalue" : 1.08E-147,
        "positive" : 384,
        "gaps" : 109,
        "Type" : "protein_coding",
        "bitscore" : 468.0,
        "slen" : 1105,
        "mismatch" : 220,
        "name" : "PpCluster-9888.2",
        "send" : 1060,
        "qcovs" : 62,
        "PrimarySymbol" : "0",
        "qend" : 1127
      },
      "position" : {
        "x" : -934.5445727636143,
        "y" : -461.7935791015625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16631",
        "Description" : "Exostosin family protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 262,
        "qstart" : 643,
        "qcovhsp" : 14,
        "shared_name" : "SpCluster-7646.0",
        "ppos" : 68.45,
        "score" : 450,
        "pident" : 48.81,
        "SUID" : 16631,
        "selected" : false,
        "sseqid" : "AT1G67410",
        "length" : 168,
        "nident" : 82,
        "evalue" : 3.25E-51,
        "positive" : 115,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 177.0,
        "slen" : 430,
        "mismatch" : 86,
        "name" : "SpCluster-7646.0",
        "send" : 429,
        "qcovs" : 41,
        "PrimarySymbol" : "0",
        "qend" : 140
      },
      "position" : {
        "x" : -715.7088580028511,
        "y" : -3379.017578125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "18100",
        "Description" : "Plant regulator RWP-RK family protein;(source:Araport11)",
        "SecondarySymbol" : "NIN-LIKE PROTEIN 8 (NLP8)",
        "sstart" : 628,
        "qstart" : 2066,
        "qcovhsp" : 2,
        "shared_name" : "SpCluster-6117.4",
        "ppos" : 94.87,
        "score" : 187,
        "pident" : 82.051,
        "SUID" : 18100,
        "selected" : false,
        "sseqid" : "AT2G43500",
        "length" : 39,
        "nident" : 32,
        "evalue" : 3.96E-14,
        "positive" : 37,
        "gaps" : 0,
        "Type" : "protein_coding",
        "bitscore" : 76.6,
        "slen" : 947,
        "mismatch" : 7,
        "name" : "SpCluster-6117.4",
        "send" : 666,
        "qcovs" : 5,
        "PrimarySymbol" : "NIN-LIKE PROTEIN 8 (NLP8)",
        "qend" : 1950
      },
      "position" : {
        "x" : -826.2400469676949,
        "y" : -3351.374267578125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17705",
        "degree_layout" : 4,
        "Description" : "\"Encodes a cytochrome P-450 gene that is involved in leaf blade expansion by controlling polar cell expansion in the leaf length direction. Member of the CYP90C CYP450 family. ROT3 was shown to be involved in brassinosteroid biosynthesis, most likely in the conversion step of typhasterol (TY) to castasterone (CS). As 6-deoxo-CS was unable to restore the phenotype of rot3-1, it has been postulated that ROT3 might be specifically involved in the conversion of TY to CS in the C6-oxidation pathway of brassinolide. Recently, CYP90C1 was shown to catalyse the C-23 hydroxylation of several brassinosteroids (the enzyme has a broad specificity for 22-hydroxylated substrates).\"",
        "SecondarySymbol" : "ROTUNDIFOLIA 3 (ROT3)",
        "sstart" : 81,
        "qstart" : 517,
        "qcovhsp" : 18,
        "shared_name" : "PpCluster-23240.0",
        "ppos" : 54.59,
        "score" : 663,
        "pident" : 34.174,
        "SUID" : 17705,
        "selected" : false,
        "sseqid" : "AT4G36380",
        "length" : 436,
        "nident" : 149,
        "evalue" : 1.65E-77,
        "positive" : 238,
        "gaps" : 6,
        "Type" : "protein_coding",
        "bitscore" : 259.0,
        "slen" : 524,
        "mismatch" : 281,
        "name" : "PpCluster-23240.0",
        "send" : 513,
        "qcovs" : 55,
        "PrimarySymbol" : "ROTUNDIFOLIA 3 (ROT3)",
        "qend" : 1815
      },
      "position" : {
        "x" : -865.254472665958,
        "y" : -496.7638989160733
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16630",
        "Description" : "Exostosin family protein;(source:Araport11)",
        "SecondarySymbol" : "(GUT1);IRREGULAR XYLEM 10 (IRX10-L);XYLAN SYNTHASE-1 (XYS1)",
        "sstart" : 45,
        "qstart" : 1559,
        "qcovhsp" : 5,
        "shared_name" : "KfCluster-15457.0",
        "ppos" : 60.0,
        "score" : 449,
        "pident" : 41.463,
        "SUID" : 16630,
        "selected" : false,
        "sseqid" : "AT5G61840",
        "length" : 205,
        "nident" : 85,
        "evalue" : 6.15E-48,
        "positive" : 123,
        "gaps" : 4,
        "Type" : "protein_coding",
        "bitscore" : 177.0,
        "slen" : 415,
        "mismatch" : 116,
        "name" : "KfCluster-15457.0",
        "send" : 245,
        "qcovs" : 14,
        "PrimarySymbol" : "(GUT1)",
        "qend" : 2173
      },
      "position" : {
        "x" : -609.1049151317574,
        "y" : -3405.378173828125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17704",
        "degree_layout" : 6,
        "Description" : "phosphoinositide binding protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 2,
        "qstart" : 752,
        "qcovhsp" : 6,
        "shared_name" : "PpCluster-20003.0",
        "ppos" : 52.27,
        "score" : 492,
        "pident" : 37.784,
        "SUID" : 17704,
        "selected" : false,
        "sseqid" : "AT1G61690",
        "length" : 352,
        "nident" : 133,
        "evalue" : 1.29E-49,
        "positive" : 184,
        "gaps" : 56,
        "Type" : "protein_coding",
        "bitscore" : 194.0,
        "slen" : 1171,
        "mismatch" : 163,
        "name" : "PpCluster-20003.0",
        "send" : 307,
        "qcovs" : 18,
        "PrimarySymbol" : "0",
        "qend" : 1777
      },
      "position" : {
        "x" : -871.2019213964268,
        "y" : -431.0960351368341
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16629",
        "Description" : "Exostosin family protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 20,
        "qstart" : 4815,
        "qcovhsp" : 7,
        "shared_name" : "AaCluster-19717.0",
        "ppos" : 67.37,
        "score" : 1247,
        "pident" : 50.424,
        "SUID" : 16629,
        "selected" : false,
        "sseqid" : "AT1G34270",
        "length" : 472,
        "nident" : 238,
        "evalue" : 1.03E-153,
        "positive" : 318,
        "gaps" : 28,
        "Type" : "protein_coding",
        "bitscore" : 484.0,
        "slen" : 477,
        "mismatch" : 206,
        "name" : "AaCluster-19717.0",
        "send" : 477,
        "qcovs" : 21,
        "PrimarySymbol" : "0",
        "qend" : 3442
      },
      "position" : {
        "x" : -643.6326250926949,
        "y" : -3304.75048828125
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17701",
        "degree_layout" : 26,
        "Description" : "\"Encodes the kinesin-like protein PAK has an Armadillo motif tail and is involved  in guard cell development in Arabidopsis (from Genbank record AF159052).However, no defect in stomatal complexes has been observed in loss of function mutations.  It accumulates at the preprophase band (PPB) in a cell-cycle and microtubule-dependent manner and is most highly expressed in cells where the placement of the division plane (early embryogenesis, stomatal lineages) is critical.\"",
        "SecondarySymbol" : "\"ARABIDOPSIS THALIANA KINESIN UNGROUPED CLADE, GENE A (AtKINUa);ARMADILLO REPEAT KINESIN 3 (ARK3)\"",
        "sstart" : 70,
        "qstart" : 2277,
        "qcovhsp" : 17,
        "shared_name" : "SpCluster-18425.0",
        "ppos" : 56.75,
        "score" : 701,
        "pident" : 41.542,
        "SUID" : 17701,
        "selected" : false,
        "sseqid" : "AT1G12430",
        "length" : 467,
        "nident" : 194,
        "evalue" : 9.06E-79,
        "positive" : 265,
        "gaps" : 60,
        "Type" : "protein_coding",
        "bitscore" : 274.0,
        "slen" : 920,
        "mismatch" : 213,
        "name" : "SpCluster-18425.0",
        "send" : 495,
        "qcovs" : 51,
        "PrimarySymbol" : "ARMADILLO REPEAT KINESIN 3 (ARK3)",
        "qend" : 934
      },
      "position" : {
        "x" : 1401.5831298828125,
        "y" : -2346.426337703166
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17700",
        "degree_layout" : 2,
        "Description" : "",
        "SecondarySymbol" : "",
        "shared_name" : "SpCluster-16661.0",
        "SUID" : 17700,
        "selected" : false,
        "sseqid" : "",
        "Type" : "",
        "name" : "SpCluster-16661.0",
        "PrimarySymbol" : ""
      },
      "position" : {
        "x" : 1458.9324951171875,
        "y" : -2435.494208796916
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17699",
        "degree_layout" : 26,
        "Description" : "encodes a novel member of the kinesin superfamily of motor proteins. recessive mutations have reduced number of trichome branches.",
        "SecondarySymbol" : "ZWICHEL (ZWI)",
        "sstart" : 63,
        "qstart" : 4251,
        "qcovhsp" : 22,
        "shared_name" : "PpCluster-21140.1",
        "ppos" : 76.94,
        "score" : 3451,
        "pident" : 60.895,
        "SUID" : 17699,
        "selected" : false,
        "sseqid" : "AT5G65930",
        "length" : 1184,
        "nident" : 721,
        "evalue" : 0.0,
        "positive" : 911,
        "gaps" : 46,
        "Type" : "protein_coding",
        "bitscore" : 1333.0,
        "slen" : 1266,
        "mismatch" : 417,
        "name" : "PpCluster-21140.1",
        "send" : 1206,
        "qcovs" : 65,
        "PrimarySymbol" : "ZWICHEL (ZWI)",
        "qend" : 718
      },
      "position" : {
        "x" : 1405.4102783203125,
        "y" : -2228.315497859416
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16628",
        "degree_layout" : 21,
        "Description" : "Plays role in DNA-damage repair/toleration. Partially complements RecA- phenotypes.",
        "SecondarySymbol" : "DNA-DAMAGE REPAIR/TOLERATION 100 (DRT100)",
        "sstart" : 52,
        "qstart" : 1052,
        "qcovhsp" : 18,
        "shared_name" : "SpCluster-9101.0",
        "ppos" : 52.17,
        "score" : 287,
        "pident" : 36.759,
        "SUID" : 16628,
        "selected" : false,
        "sseqid" : "AT3G12610",
        "length" : 253,
        "nident" : 93,
        "evalue" : 2.23E-28,
        "positive" : 132,
        "gaps" : 20,
        "Type" : "protein_coding",
        "bitscore" : 115.0,
        "slen" : 372,
        "mismatch" : 140,
        "name" : "SpCluster-9101.0",
        "send" : 302,
        "qcovs" : 54,
        "PrimarySymbol" : "DNA-DAMAGE REPAIR/TOLERATION 100 (DRT100)",
        "qend" : 348
      },
      "position" : {
        "x" : -180.874755859375,
        "y" : -1682.9754638671875
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "17698",
        "degree_layout" : 27,
        "Description" : "encodes a novel member of the kinesin superfamily of motor proteins. recessive mutations have reduced number of trichome branches.",
        "SecondarySymbol" : "ZWICHEL (ZWI)",
        "sstart" : 30,
        "qstart" : 1080,
        "qcovhsp" : 22,
        "shared_name" : "PpCluster-19878.0",
        "ppos" : 75.37,
        "score" : 3608,
        "pident" : 59.934,
        "SUID" : 17698,
        "selected" : false,
        "sseqid" : "AT5G65930",
        "length" : 1218,
        "nident" : 730,
        "evalue" : 0.0,
        "positive" : 918,
        "gaps" : 62,
        "Type" : "protein_coding",
        "bitscore" : 1394.0,
        "slen" : 1260,
        "mismatch" : 426,
        "name" : "PpCluster-19878.0",
        "send" : 1200,
        "qcovs" : 66,
        "PrimarySymbol" : "ZWICHEL (ZWI)",
        "qend" : 4688
      },
      "position" : {
        "x" : 1442.5621337890625,
        "y" : -2346.542060359416
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16627",
        "degree_layout" : 27,
        "Description" : "kinase family with leucine-rich repeat domain-containing protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 245,
        "qstart" : 843,
        "qcovhsp" : 6,
        "shared_name" : "SpCluster-19239.0",
        "ppos" : 62.5,
        "score" : 196,
        "pident" : 40.179,
        "SUID" : 16627,
        "selected" : false,
        "sseqid" : "AT1G35710",
        "length" : 112,
        "nident" : 45,
        "evalue" : 2.52E-15,
        "positive" : 70,
        "gaps" : 1,
        "Type" : "protein_coding",
        "bitscore" : 80.1,
        "slen" : 1120,
        "mismatch" : 66,
        "name" : "SpCluster-19239.0",
        "send" : 356,
        "qcovs" : 18,
        "PrimarySymbol" : "0",
        "qend" : 511
      },
      "position" : {
        "x" : -156.571533203125,
        "y" : -1597.000244140625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16626",
        "degree_layout" : 24,
        "Description" : "\"Encodes PEPR2, a plasma membrane leucine-rich repeat receptor kinase functioning as a receptor for the Pep1 and Pep2 peptides.  Pep1 and Pep2 are amino acids that induce the transcription of defense-related genes.\"",
        "SecondarySymbol" : "PEP1 RECEPTOR 2 (PEPR2);PEP1 RECEPTOR 2 (AtPEPR2)",
        "sstart" : 77,
        "qstart" : 2308,
        "qcovhsp" : 18,
        "shared_name" : "KfCluster-14848.1",
        "ppos" : 46.98,
        "score" : 320,
        "pident" : 30.409,
        "SUID" : 16626,
        "selected" : false,
        "sseqid" : "AT1G17750",
        "length" : 513,
        "nident" : 156,
        "evalue" : 8.07E-30,
        "positive" : 241,
        "gaps" : 63,
        "Type" : "protein_coding",
        "bitscore" : 127.0,
        "slen" : 1088,
        "mismatch" : 294,
        "name" : "KfCluster-14848.1",
        "send" : 560,
        "qcovs" : 54,
        "PrimarySymbol" : "PEP1 RECEPTOR 2 (PEPR2)",
        "qend" : 872
      },
      "position" : {
        "x" : -181.534912109375,
        "y" : -1625.8228759765625
      },
      "selected" : false
    }, {
      "data" : {
        "id" : "16625",
        "degree_layout" : 23,
        "Description" : "Leucine-rich repeat protein kinase family protein;(source:Araport11)",
        "SecondarySymbol" : "0",
        "sstart" : 195,
        "qstart" : 110,
        "qcovhsp" : 20,
        "shared_name" : "AaCluster-19021.0",
        "ppos" : 43.43,
        "score" : 272,
        "pident" : 27.273,
        "SUID" : 16625,
        "selected" : false,
        "sseqid" : "AT2G37050",
        "length" : 396,
        "nident" : 108,
        "evalue" : 1.45E-24,
        "positive" : 172,
        "gaps" : 80,
        "Type" : "protein_coding",
        "bitscore" : 109.0,
        "slen" : 934,
        "mismatch" : 208,
        "name" : "AaCluster-19021.0",
        "send" : 522,
        "qcovs" : 59,
        "PrimarySymbol" : "0",
        "qend" : 1261
      },
      "position" : {
        "x" : -214.75762939453125,
        "y" : -1754.285400390625
      },
      "selected" : false
    }, {
      "data" : {
        "id" 