function [I_syn,s] = compute_LIF_syn_currents(spk,v,s,dt,ind_EL,ind_ER,ind_I,E_E,E_I,G_I_EL,G_I_ER,G_EL_I,G_ER_I,G_I_I,tau_g)

% This function computes synaptic currents to all neurons (I_syn) and updates values of
% synaptic activations (s), based on:
%
% - current spike vector (spk) 
% - current membrane potential vector (v)
% - time step (dt)
% - synaptic activations from previous time step (s)
% - indices of neurons in each population (ind_EL, ind_ER, ind_I)
% - reversal potentials of exc and inh synapses (E_E,E_I)
% - synaptic conductance amplitudes (G_I_EL,G_I_ER,G_EL_I,G_ER_I,G_I_I)
% - synaptic conductance time constants (tau_g)

s_EL = s(ind_EL);
s_ER = s(ind_ER);
s_I = s(ind_I);

v_EL = v(ind_EL);
v_ER = v(ind_ER);
v_I = v(ind_I);

%Update synaptic inputs into inhibitory pop.
I_I_syn = G_I_EL*(s_EL.*E_E(1:end/2)) - (G_I_EL*s_EL).*v_I + G_I_ER*(s_ER.*E_E(end/2+1:end)) - (G_I_ER*s_ER).*v_I + G_I_I*(s_I.*E_I) - (G_I_I*s_I).*v_I;
    
%Update synaptic inputs into excitatory pops.
I_EL_syn = G_EL_I*(s_I.*E_I) - (G_EL_I*s_I).*v_EL;
I_ER_syn = G_ER_I*(s_I.*E_I) - (G_ER_I*s_I).*v_ER;

I_syn = [I_I_syn;I_EL_syn;I_ER_syn];

%Update synaptic activations
s_EL = s_EL + dt/tau_g*(-s_EL) + spk(ind_EL);
s_ER = s_ER + dt/tau_g*(-s_ER) + spk(ind_ER);
s_I = s_I + dt/tau_g*(-s_I) + spk(ind_I);

s = [s_I; s_EL; s_ER];
