function [I_syn,s] = compute_LNP_syn_currents(spk,s,dt,ind_EL,ind_ER,ind_I,G_I_EL,G_I_ER,G_EL_I,G_ER_I,G_I_I,tau_g)

% This function computes synaptic currents to all neurons (I_syn) and updates values of
% synaptic activations (s), based on:
%
% - current spike vector (spk) 
% - time step (dt)
% - synaptic activations from previous time step (s)
% - indices of neurons in each population (ind_EL, ind_ER, ind_I)
% - synaptic conductance amplitudes (G_I_EL,G_I_ER,G_EL_I,G_ER_I,G_I_I)
% - synaptic conductance time constants (tau_g)

s_EL = s(ind_EL);
s_ER = s(ind_ER);
s_I = s(ind_I);

%Update synaptic inputs into inhibitory pop.
I_I_syn = G_I_EL*s_EL + G_I_ER*s_ER - G_I_I*s_I;
    
%Update synaptic inputs into excitatory pops.
I_EL_syn = -G_EL_I*s_I;
I_ER_syn = -G_ER_I*s_I;

I_syn = [I_I_syn;I_EL_syn;I_ER_syn];

%Update synaptic activations
s_EL = s_EL + dt/tau_g*(-s_EL) + spk(ind_EL);
s_ER = s_ER + dt/tau_g*(-s_ER) + spk(ind_ER);
s_I = s_I + dt/tau_g*(-s_I) + spk(ind_I);

s = [s_I; s_EL; s_ER];
