function [v,spk] = compute_HH_output(v,v_prev,dt,I_ion,I_syn,I_app,A_env,C_m)

% This function updates the membrane potential (v) vector for all neurons and outputs the spike vector (spk), based on:
%
% - membrane potential vector (v) in current time step
% - membrane potential vector (v_prev) from previous time step
% - time step (dt)
% - ionic currents (I_ion)
% - synaptic currents (I_syn)
% - externally applied currents (I_app)
% - envelope function for suppressing edge neurons in aperiodic nets (A_env)
% - membrane capacitance (C_m)

%total input current into all neurons
I_in = -I_ion + A_env.*(I_syn + I_app);

%update voltages
v = v + dt/C_m*I_in;

%declare spike once voltage crosses 0 mV from below
spk = 0 + ones(size(v)).*(v_prev<0 & v>0);


