function [v,spk] = compute_LIF_output(v,dt,I_ion,I_syn,I_app,A_env,C_m,V_T,Vreset)

% This function updates the membrane potential (v) vector for all neurons and outputs the spike vector (spk), based on:
%
% - membrane potential vector (v) in current time step
% - time step (dt)
% - ionic currents (I_ion)
% - synaptic currents (I_syn)
% - externally applied currents (I_app)
% - envelope function for suppressing edge neurons in aperiodic nets (A_env)
% - membrane capacitance (C_m)
% - membrane potential spk threshold (V_T)
% - membrane potential reset (Vreset)

%total input current into all neurons
I_in = -I_ion + A_env.*(I_syn + I_app);

%declare spike if voltage crosses threshold, V_T 
spk = (v>=V_T);

%reset voltages
v = (v + dt/C_m*I_in).*(v<V_T)+Vreset*(v>=V_T);
