function [spk] = compute_LNP_output(dt,I_ion,I_syn,I_app,A_env)

% This function outputs the spike vector (spk), based on:
%
% - time step (dt)
% - ionic currents (I_ion)
% - synaptic currents (I_syn)
% - externally applied currents (I_app)
% - envelope function for suppressing edge neurons in aperiodic nets (A_env)

%total input current into all neurons
I_in = -I_ion + A_env.*(I_syn + I_app);

%apply threshold nonlinearity to input current
I_in = I_in.*(I_in>0);

%draw spikes with rate = I_in*dt
spk = poissrnd(I_in*dt);
