function A = create_envelope(periodic,N)

%This function returns an envelope for network of size N; The envelope can
%either be suppressive (periodic = 0) or flat and equal to one (periodic = 1)

kappa = 0.3; %controls width of main body of envelope
a0 = 30;    %contrls steepness of envelope
if periodic==0
    A = zeros(1,N);
    for m = 1:N
        r = abs(m-N/2);
        if r<kappa*N 
            A(m) = 1;
        else
            A(m) = exp(-a0*((r-kappa*N)/((1-kappa)*N))^2);
        end
    end
else
    A = ones(1,N);
end
